// Copyright (c) 2002 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//   1. Redistributions of source code must retain the above copyright
//      notice, this list of conditions, and the following disclaimer.
//   2. Redistributions in binary form must reproduce the above
//      copyright notice, this list of conditions, and the following
//      disclaimer in the documentation and/or other materials provided
//      with the distribution.
//   3. Redistributions must acknowledge that this software was
//      originally developed by the UCSF Computer Graphics Laboratory
//      under support by the NIH National Center for Research Resources,
//      grant P41-RR01081.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// $Id: Daemon.cpp,v 1.4 2002/02/07 22:49:15 gregc Exp $

#include "Daemon.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdexcept>

Daemon::Daemon(int port)
{
	sockaddr_in address;
#if 0
	address.sin_len = ?;
#endif
	address.sin_family = AF_INET;
	address.sin_addr.s_addr = INADDR_ANY;
	address.sin_port = htons(port);

	socket = ::socket(AF_INET, SOCK_STREAM, 0);
	if (port) {
		int on = 1;
		setsockopt(socket, SOL_SOCKET, SO_REUSEADDR, (char *) &on,
								sizeof on);
	}
	if (::bind(socket, (sockaddr *) &address, sizeof address) < 0)
		throw std::runtime_error("unable to bind network control port");
	::listen(socket, 5);
}

Daemon::~Daemon()
{
	::close(socket);
}

int
Daemon::fd() const
{
	return socket;
}

int
Daemon::port() const
{
	sockaddr_in address;
	int len = sizeof address;
	if (getsockname(socket, (sockaddr*) &address, &len) == -1)
		throw std::runtime_error("unable to get network control port");
	return ntohs(address.sin_port);
}
