#ifndef otf_GetOpt_h
# define otf_GetOpt_h

// Copyright (c) 2002 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//   1. Redistributions of source code must retain the above copyright
//      notice, this list of conditions, and the following disclaimer.
//   2. Redistributions in binary form must reproduce the above
//      copyright notice, this list of conditions, and the following
//      disclaimer in the documentation and/or other materials provided
//      with the distribution.
//   3. Redistributions must acknowledge that this software was
//      originally developed by the UCSF Computer Graphics Laboratory
//      under support by the NIH National Center for Research Resources,
//      grant P41-RR01081.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// $Id: GetOpt.h,v 1.2 2002/02/07 22:49:15 gregc Exp $

namespace otf {

class GetOpt {
public:
	GetOpt(int argc, char *const *argv, char const *opts,
						bool printErrors = true);
	int		index() const;	// arg index of option
	char		*arg() const;	// optional argument to option
	int		option() const;	// option being processed
	void		reset();	// restart processing arguments
	void		skip(int count);	// skip count args
	void		printErrors(bool b);	// print errors on stderr?
	int		operator()();	// return next option
private:
	bool		opterr;		// if error message should be printed
	int		optind;		// index into parent argv vector
	int		optopt;		// character checked for validity
	bool		optreset;	// reset getopt
	char		*optarg;	// argument associated with option
	int		nargc;		// saved argument count
	char *const	*nargv;		// saved argument values
	char const	*ostr;		// saved options description
	char		*place;		// option letter processing
};

} // namespace otf

#endif
