#ifndef VideoControl_h
# define VideoControl_h

// Copyright (c) 2002 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//   1. Redistributions of source code must retain the above copyright
//      notice, this list of conditions, and the following disclaimer.
//   2. Redistributions in binary form must reproduce the above
//      copyright notice, this list of conditions, and the following
//      disclaimer in the documentation and/or other materials provided
//      with the distribution.
//   3. Redistributions must acknowledge that this software was
//      originally developed by the UCSF Computer Graphics Laboratory
//      under support by the NIH National Center for Research Resources,
//      grant P41-RR01081.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// $Id: VideoControl.h,v 1.3 2002/02/07 22:49:15 gregc Exp $

# include "X11Gui.h"
# include <X11/Xlib.h>
# include <X11/extensions/XSGIvc.h>
# include <string>

class VideoControl {
public:
	VideoControl(const X11Gui *gui);
	~VideoControl();
	void setStereo(bool stereo);
	const std::string &originalVideoFormat() const;
	const std::string &stereoVideoFormat() const;
private:
	void setup();
	// some typedefs to cut down on typing
	typedef XSGIvcVideoFormatInfo VFI;
	typedef XSGIvcChannelInfo CI;
	static const int MAX = 512;	// maximum count for various queries

	const X11Gui *gui;
	XSGIvcScreenInfo sinfo;		// only handle one screen
	int screen;
	bool useCombination;
	std::string originalVF;		// original video formats
	std::string stereoVF;		// stereo video formats
};

inline const std::string &
VideoControl::originalVideoFormat() const
{
	return originalVF;
}

inline const std::string &
VideoControl::stereoVideoFormat() const
{
	return stereoVF;
}

#endif
