/*
 * Copyright (c) 2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions, and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions, and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *   3. Redistributions must acknowledge that this software was
 *      originally developed by the UCSF Computer Graphics Laboratory
 *      under support by the NIH National Center for Research Resources,
 *      grant P41-RR01081.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: autostereo.c,v 1.4 2002/02/07 22:53:04 gregc Exp $
 */

#include "autostereo.h"
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <X11/Xatom.h>

static Atom	property = None;
enum State	{ Initial, Absent, Exists };
static enum State
		serverState = Initial;

typedef struct ScreenInfo ScreenInfo;
struct ScreenInfo {
	struct sockaddr_in address;
};
static ScreenInfo *screenInfo = NULL;

static const char SGI[] = "Silicon Graphics";

int
ASInitialize(Display *display, const char *daemonLocation)
{
	int screen;
	int len;
	long *port;
	Window root;
	Atom type;
	int format;
	int status;
	unsigned long nitems, bytes_after;
	int fd;

	if (strncmp(ServerVendor(display), SGI, (sizeof SGI) - 1) != 0) {
		serverState = Absent;
		return Success;
	}
	property = XInternAtom(display, "SGI_AUTOSTEREO", False);

	screen = DefaultScreen(display);
	root = RootWindow(display, screen);
	port = NULL;
	while (port == NULL) {
		type = XA_INTEGER;
		format = 32;
		nitems = 1;
		bytes_after = 0;
		status = XGetWindowProperty(display, root, property, 0, 1,
			False, AnyPropertyType, &type, &format,
			&nitems, &bytes_after, ((unsigned char **) &port));
		if (status != Success) {
			/* unable to get port number from server */
			serverState = Absent;
			return BadImplementation;
		}
		if (type == XA_INTEGER)
			break;
		if (daemonLocation) {
			if (system(daemonLocation) == 0) {
				/* prevent retrying forever if it fails */
				daemonLocation = NULL;
				continue;
			}
		}
		serverState = Absent;
		return BadImplementation;
	}

	if (screenInfo == NULL)
		screenInfo = malloc(ScreenCount(display) * sizeof (ScreenInfo));

	/* find out remote IP addr */
	fd = ConnectionNumber(display);
	len = sizeof (struct sockaddr_in);
	getpeername(fd, (struct sockaddr *) &screenInfo[screen].address, &len);
	if (screenInfo[screen].address.sin_family != AF_INET) {
		/* UNIX domain socket to X server, use localhost */
		memset(&screenInfo[screen], 0, sizeof (ScreenInfo));
		screenInfo[screen].address.sin_family = AF_INET;
		inet_aton("127.0.0.1", &screenInfo[screen].address.sin_addr);
	}
	screenInfo[screen].address.sin_port = *port;
	serverState = Exists;
	return Success;
}

ASHandle
ASCreatedStereoWindow(Display *display)
{
	int screen;
	int s;

	switch (serverState) { 
	  case Initial:
	  case Absent:
		return -1;
	  case Exists:
		break;
	}
	screen = DefaultScreen(display);
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (-1 == connect(s, (struct sockaddr *) &screenInfo[screen].address,
						sizeof (struct sockaddr_in))) {
		close(s);
		return -1;
	}
	return s;
}

void
ASClosedStereoWindow(ASHandle handle)
{
	if (handle == -1)
		return;
	close(handle);
}
