import cPickle, base64
try:
	from SimpleSession.versions.v41 import beginRestore,\
	    registerAfterModelsCB, reportRestoreError, checkVersion
except ImportError:
	from chimera import UserError
	raise UserError('Cannot open session that was saved in a'
	    ' newer version of Chimera; update your version')
checkVersion([1, 4, 27752])
import chimera
from chimera import replyobj
replyobj.status('Beginning session restore...', \
    blankAfter=0)
beginRestore()

def restoreCoreModels():
	from SimpleSession.versions.v41 import init, restoreViewer, \
	     restoreMolecules, restoreColors, restoreSurfaces, \
	     restoreVRML, restorePseudoBondGroups, restoreModelAssociations
	molInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQliYWxsU2NhbGVxAksATn2HcQNVFHJpYmJvbkhpZGVzTWFpbmNoYWlucQRLAE59h3EFVQlwb2ludFNpemVxBksATn2HcQdVBG5hbWVxCEsATn2HcQlVBWNvbG9ycQpLAE59h3ELVQhvcHRpb25hbHEMfXENVQpwZGJIZWFkZXJzcQ5dcQ9VA2lkc3EQSwBOfYdxEVUOc3VyZmFjZU9wYWNpdHlxEksATn2HcRNVCWF1dG9jaGFpbnEUSwBOfYdxFVUKdmR3RGVuc2l0eXEWSwBOfYdxF1UGaGlkZGVucRhLAE59h3EZVQlsaW5lV2lkdGhxGksATn2HcRtVCnN0aWNrU2NhbGVxHEsATn2HcR1VB2Rpc3BsYXlxHksATn2HcR91Lg=='))
	resInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQZpbnNlcnRxAksATn2HcQNVBG5hbWVxBEsATn2HcQVVBWNoYWlucQZLAE59h3EHVQJzc3EISwBOfYdxCVUIbW9sZWN1bGVxCksATn2HcQtVC3JpYmJvbkNvbG9ycQxLAE59h3ENVQVsYWJlbHEOSwBOfYdxD1UKbGFiZWxDb2xvcnEQSwBOfYdxEVUFaXNIZXRxEksATn2HcRNVCHBvc2l0aW9ucRRdcRVVDXJpYmJvbkRpc3BsYXlxFksATn2HcRdVCG9wdGlvbmFscRh9cRlVDnJpYmJvbkRyYXdNb2RlcRpLAE59h3EbdS4='))
	atomInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQdyZXNpZHVlcQJLAE59h3EDVQh2ZHdDb2xvcnEESwBOfYdxBVUEbmFtZXEGSwBOfYdxB1UDdmR3cQhLAE59h3EJVQ5zdXJmYWNlRGlzcGxheXEKSwBOfYdxC1UFY29sb3JxDEsATn2HcQ1VCWlkYXRtVHlwZXEOSwBOfYdxD1UGYWx0TG9jcRBLAE59h3ERVQVsYWJlbHESSwBOfYdxE1UOc3VyZmFjZU9wYWNpdHlxFEsATn2HcRVVB2VsZW1lbnRxFksATn2HcRdVCmxhYmVsQ29sb3JxGEsATn2HcRlVDHN1cmZhY2VDb2xvcnEaSwBOfYdxG1UGcmFkaXVzcRxLAE59h3EdVQ9zdXJmYWNlQ2F0ZWdvcnlxHksATn2HcR9VCGRyYXdNb2RlcSBLAE59h3EhVQhvcHRpb25hbHEifXEjVQdkaXNwbGF5cSRLAE59h3EldS4='))
	bondInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQhvcHRpb25hbHECfXEDVQhkcmF3TW9kZXEESwBOfYdxBVUGcmFkaXVzcQZLAE59h3EHVQdkaXNwbGF5cQhLAE59h3EJVQVhdG9tc3EKXXELdS4='))
	crdInfo = cPickle.loads(base64.b64decode('gAJ9cQEu'))
	surfInfo = {'category': (0, None, {}), 'probeRadius': (0, None, {}), 'pointSize': (0, None, {}), 'name': [], 'density': (0, None, {}), 'colorMode': (0, None, {}), 'useLighting': (0, None, {}), 'transparencyBlendMode': (0, None, {}), 'molecule': [], 'smoothLines': (0, None, {}), 'lineWidth': (0, None, {}), 'allComponents': (0, None, {}), 'twoSidedLighting': (0, None, {}), 'oneTransparentLayer': (0, None, {}), 'drawMode': (0, None, {}), 'display': (0, None, {}), 'customColors': []}
	vrmlInfo = {'subid': (0, None, {}), 'display': (0, None, {}), 'id': (0, None, {}), 'vrmlString': [], 'name': (0, None, {})}
	colors = {'Ru': ((0.141176, 0.560784, 0.560784), 1, 'default'), 'Ni': ((0.313725, 0.815686, 0.313725), 1, 'default'), 'Re': ((0.14902, 0.490196, 0.670588), 1, 'default'), 'Rf': ((0.8, 0, 0.34902), 1, 'default'), 'Ra': ((0, 0.490196, 0), 1, 'default'), 'Rb': ((0.439216, 0.180392, 0.690196), 1, 'default'), 'Rn': ((0.258824, 0.509804, 0.588235), 1, 'default'), 'Rh': ((0.0392157, 0.490196, 0.54902), 1, 'default'), 'Be': ((0.760784, 1, 0), 1, 'default'), 'Ba': ((0, 0.788235, 0), 1, 'default'), 'Bh': ((0.878431, 0, 0.219608), 1, 'default'), 'Bi': ((0.619608, 0.309804, 0.709804), 1, 'default'), 'Bk': ((0.541176, 0.309804, 0.890196), 1, 'default'), 'Br': ((0.65098, 0.160784, 0.160784), 1, 'default'), '_openColor00': ((1, 1, 1), 1, 'default'), '_openColor01': ((1, 0, 1), 1, 'default'), '_openColor02': ((0, 1, 1), 1, 'default'), '_openColor03': ((1, 1, 0), 1, 'default'), '_openColor04': ((1, 0, 0), 1, 'default'), '_openColor05': ((0, 0, 1), 1, 'default'), '_openColor06': ((0.67, 1, 0), 1, 'default'), '_openColor07': ((0.67, 0, 1), 1, 'default'), '_openColor08': ((0.67, 1, 1), 1, 'default'),
'H': ((1, 1, 1), 1, 'default'), 'P': ((1, 0.501961, 0), 1, 'default'), 'Os': ((0.14902, 0.4, 0.588235), 1, 'default'), 'orange red': ((1, 0.270588, 0), 1, 'default'), 'Ge': ((0.4, 0.560784, 0.560784), 1, 'default'), 'Gd': ((0.270588, 1, 0.780392), 1, 'default'), 'Ga': ((0.760784, 0.560784, 0.560784), 1, 'default'), 'Pr': ((0.85098, 1, 0.780392), 1, 'default'), '_openColor12': ((1, 1, 0.5), 1, 'default'), '_openColor11': ((1, 0.67, 1), 1, 'default'), '_openColor10': ((0, 0.67, 1), 1, 'default'), 'Pt': ((0.815686, 0.815686, 0.878431), 1, 'default'), 'Pu': ((0, 0.419608, 1), 1, 'default'), 'C': ((0.564706, 0.564706, 0.564706), 1, 'default'), 'Pb': ((0.341176, 0.34902, 0.380392), 1, 'default'), 'Pa': ((0, 0.631373, 1), 1, 'default'), 'Pd': ((0, 0.411765, 0.521569), 1, 'default'), 'Xe': ((0.258824, 0.619608, 0.690196), 1, 'default'), 'Po': ((0.670588, 0.360784, 0), 1, 'default'), 'Pm': ((0.639216, 1, 0.780392), 1, 'default'), 'Hs': ((0.901961, 0, 0.180392), 1, 'default'), 'Ho': ((0, 1, 0.611765), 1, 'default'), 'Hf': ((0.301961, 0.760784, 1), 1, 'default'), 'Hg': ((0.721569, 0.721569, 0.815686), 1, 'default'),
'He': ((0.85098, 1, 1), 1, 'default'), 'Md': ((0.701961, 0.0509804, 0.65098), 1, 'default'), 'Mg': ((0.541176, 1, 0), 1, 'default'), 'K': ((0.560784, 0.25098, 0.831373), 1, 'default'), 'Mn': ((0.611765, 0.478431, 0.780392), 1, 'default'), 'O': ((1, 0.0509804, 0.0509804), 1, 'default'), 'Mt': ((0.921569, 0, 0.14902), 1, 'default'), 'S': ((1, 1, 0.188235), 1, 'default'), 'W': ((0.129412, 0.580392, 0.839216), 1, 'default'), 'Zn': ((0.490196, 0.501961, 0.690196), 1, 'default'), 'Eu': ((0.380392, 1, 0.780392), 1, 'default'), 'Zr': ((0.580392, 0.878431, 0.878431), 1, 'default'), 'Er': ((0, 0.901961, 0.458824), 1, 'default'), '_openColor13': ((1, 0, 0.5), 1, 'default'), 'No': ((0.741176, 0.0509804, 0.529412), 1, 'default'), 'Na': ((0.670588, 0.360784, 0.94902), 1, 'default'), 'Nb': ((0.45098, 0.760784, 0.788235), 1, 'default'), 'Nd': ((0.780392, 1, 0.780392), 1, 'default'), 'Ne': ((0.701961, 0.890196, 0.960784), 1, 'default'), 'Np': ((0, 0.501961, 1), 1, 'default'), 'Fr': ((0.258824, 0, 0.4), 1, 'default'), '_openColor15': ((0.67, 0.67, 1), 1, 'default'), '_openColor14': ((0, 1, 0.5), 1, 'default'),
'Fe': ((0.878431, 0.4, 0.2), 1, 'default'), 'Fm': ((0.701961, 0.121569, 0.729412), 1, 'default'), 'B': ((1, 0.709804, 0.709804), 1, 'default'), 'F': ((0.564706, 0.878431, 0.313725), 1, 'default'), 'Sr': ((0, 1, 0), 1, 'default'), 'N': ((0.188235, 0.313725, 0.972549), 1, 'default'), 'Kr': ((0.360784, 0.721569, 0.819608), 1, 'default'), 'Si': ((0.941176, 0.784314, 0.627451), 1, 'default'), 'Sn': ((0.4, 0.501961, 0.501961), 1, 'default'), 'Sm': ((0.560784, 1, 0.780392), 1, 'default'), 'V': ((0.65098, 0.65098, 0.670588), 1, 'default'), 'Sc': ((0.901961, 0.901961, 0.901961), 1, 'default'), 'Sb': ((0.619608, 0.388235, 0.709804), 1, 'default'), 'Sg': ((0.85098, 0, 0.270588), 1, 'default'), 'Se': ((1, 0.631373, 0), 1, 'default'), 'Co': ((0.941176, 0.564706, 0.627451), 1, 'default'), 'Cm': ((0.470588, 0.360784, 0.890196), 1, 'default'), 'Cl': ((0.121569, 0.941176, 0.121569), 1, 'default'), 'Ca': ((0.239216, 1, 0), 1, 'default'), 'Cf': ((0.631373, 0.211765, 0.831373), 1, 'default'), 'Ce': ((1, 1, 0.780392), 1, 'default'), 'Cd': ((1, 0.85098, 0.560784), 1, 'default'),
'Tm': ((0, 0.831373, 0.321569), 1, 'default'), 'Cs': ((0.341176, 0.0901961, 0.560784), 1, 'default'), 'Cr': ((0.541176, 0.6, 0.780392), 1, 'default'), 'Cu': ((0.784314, 0.501961, 0.2), 1, 'default'), 'La': ((0.439216, 0.831373, 1), 1, 'default'), 'Li': ((0.8, 0.501961, 1), 1, 'default'), 'Tl': ((0.65098, 0.329412, 0.301961), 1, 'default'), 'Lu': ((0, 0.670588, 0.141176), 1, 'default'), 'Lr': ((0.780392, 0, 0.4), 1, 'default'), 'Th': ((0, 0.729412, 1), 1, 'default'), 'Ti': ((0.74902, 0.760784, 0.780392), 1, 'default'), 'Te': ((0.831373, 0.478431, 0), 1, 'default'), 'Tb': ((0.188235, 1, 0.780392), 1, 'default'), 'Tc': ((0.231373, 0.619608, 0.619608), 1, 'default'), 'Ta': ((0.301961, 0.65098, 1), 1, 'default'), 'Yb': ((0, 0.74902, 0.219608), 1, 'default'), 'Db': ((0.819608, 0, 0.309804), 1, 'default'), 'Dy': ((0.121569, 1, 0.780392), 1, 'default'), '_openColor09': ((1, 0.67, 0), 1, 'default'), 'At': ((0.458824, 0.309804, 0.270588), 1, 'default'), 'I': ((0.580392, 0, 0.580392), 1, 'default'), 'U': ((0, 0.560784, 1), 1, 'default'), 'Y': ((0.580392, 1, 1), 1, 'default'),
'Ac': ((0.439216, 0.670588, 0.980392), 1, 'default'), 'Ag': ((0.752941, 0.752941, 0.752941), 1, 'default'), 'Ir': ((0.0901961, 0.329412, 0.529412), 1, 'default'), 'Am': ((0.329412, 0.360784, 0.94902), 1, 'default'), 'Al': ((0.74902, 0.65098, 0.65098), 1, 'default'), 'As': ((0.741176, 0.501961, 0.890196), 1, 'default'), 'Ar': ((0.501961, 0.819608, 0.890196), 1, 'default'), 'Au': ((1, 0.819608, 0.137255), 1, 'default'), 'Es': ((0.701961, 0.121569, 0.831373), 1, 'default'), 'In': ((0.65098, 0.458824, 0.45098), 1, 'default'), 'Mo': ((0.329412, 0.709804, 0.709804), 1, 'default')}
	materials = {'default': ((0.85, 0.85, 0.85), 30)}
	pbInfo = {'category': ['distance monitor', 'missing segments'], 'bondInfo': [{'color': (0, None, {}), 'atoms': [], 'label': (0, None, {}), 'halfbond': (0, None, {}), 'labelColor': (0, None, {}), 'drawMode': (0, None, {}), 'display': (0, None, {})}, {'color': (0, None, {}), 'atoms': [], 'label': (0, None, {}), 'halfbond': (0, None, {}), 'labelColor': (0, None, {}), 'drawMode': (0, None, {}), 'display': (0, None, {})}], 'lineType': (2, 2, {}), 'color': (2, 0, {1: [1]}), 'showStubBonds': (2, False, {}), 'lineWidth': (2, 1, {}), 'stickScale': (2, 1, {}), 'id': [-2, -1]}
	modelAssociations = {}
	colorInfo = {0: ('yellow', (1, 1, 0, 1)), 1: ('gray', (0.745, 0.745, 0.745, 1)), 2: ('green', (0, 1, 0, 1))}
	viewerInfo = {'cameraAttrs': {'center': (58.9435, 67.8165, 1019.92), 'fieldOfView': 14.3387, 'nearFar': (1354.8, 733.395), 'ortho': False, 'eyeSeparation': 50.8, 'focal': 135.622}, 'viewerAttrs': {'silhouetteColor': None, 'clipping': False, 'showSilhouette': False, 'viewSize': 109.019, 'depthCueRange': (0.5, 1), 'silhouetteWidth': 1, 'depthCue': True, 'highlight': 0, 'scaleFactor': 0.407343}, 'viewerHL': 2, 'cameraMode': 'mono', 'detail': 1, 'viewerFog': None, 'viewerBG': None}

	replyobj.status("Initializing session restore...", blankAfter=0)
	init(colorInfo)
	replyobj.status("Restoring colors...", blankAfter=0)
	restoreColors(colors, materials)
	replyobj.status("Restoring molecules...", blankAfter=0)
	restoreMolecules(molInfo, resInfo, atomInfo, bondInfo, crdInfo)
	replyobj.status("Restoring surfaces...", blankAfter=0)
	restoreSurfaces(surfInfo)
	replyobj.status("Restoring VRML models...", blankAfter=0)
	restoreVRML(vrmlInfo)
	replyobj.status("Restoring pseudobond groups...", blankAfter=0)
	restorePseudoBondGroups(pbInfo)
	replyobj.status("Restoring model associations...", blankAfter=0)
	restoreModelAssociations(modelAssociations)
	replyobj.status("Restoring camera...", blankAfter=0)
	restoreViewer(viewerInfo)

try:
	restoreCoreModels()
except:
	reportRestoreError("Error restoring core models")

	replyobj.status("Restoring extension info...", blankAfter=0)


def restore_scale_bar():
 scale_bar_state = \
  {
   'bar_length': '19',
   'bar_rgba': ( 1, 1, 1, 1.0, ),
   'bar_thickness': '1',
   'class': 'Scale_Bar_Dialog_State',
   'frozen_models': [ ],
   'geometry': '280x196+107+823',
   'is_visible': True,
   'label_rgba': ( 1, 1, 1, 1.0, ),
   'label_text': u'# \u212b',
   'label_x_offset': '',
   'label_y_offset': '',
   'model': None,
   'move_scalebar': 0,
   'orientation': 'horizontal',
   'preserve_position': 1,
   'screen_x_position': '0.44',
   'screen_y_position': '-0.36',
   'show_scalebar': 0,
   'version': 1,
  }
 import ScaleBar.session
 ScaleBar.session.restore_scale_bar_state(scale_bar_state)

try:
  restore_scale_bar()
except:
  reportRestoreError('Error restoring scale bar')


def restore_surface_zones():
 surface_zone_state = \
   {
    'class': 'Surface_Zone_State',
    'version': 1,
    'zone_table': {},
   }
 try:
  import SurfaceZone.session
  SurfaceZone.session.restore_surface_zone_state(surface_zone_state)
 except:
  reportRestoreError('Error restoring surface zones')

registerAfterModelsCB(restore_surface_zones)


def restore_volume_data():
 volume_data_state = \
  {
   'class': 'Volume_Manager_State',
   'data_and_regions_state': [
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90, 90, 90, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': '2zu0_A_5_magnet.mrc',
       'path': './2zu0_A_5_magnet.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 0.69999999999999996, 0.69999999999999996, 0.69999999999999996, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 231, 261, 323, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 231, 261, 323, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': 0,
          'cap_faces': 1,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': 1,
          'dim_transparent_voxels': 1,
          'flip_normals': 1,
          'limit_voxel_count': 1,
          'line_thickness': 1.0,
          'linear_interpolation': 1,
          'maximum_intensity_projection': 0,
          'mesh_lighting': 1,
          'minimal_texture_memory': 0,
          'one_transparent_layer': 0,
          'outline_box_linewidth': 1.0,
          'outline_box_rgb': ( 1.0, 1.0, 1.0, ),
          'projection_mode': 'auto',
          'show_outline_box': 0,
          'smooth_lines': 0,
          'smoothing_factor': 0.29999999999999999,
          'smoothing_iterations': 2,
          'square_mesh': 1,
          'subdivide_surface': 0,
          'subdivision_levels': 1,
          'surface_smoothing': 0,
          'two_sided_lighting': 1,
          'version': 1,
          'voxel_limit': 19.0,
         },
        'representation': 'surface',
        'session_volume_id': 1219454376,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
         ],
        'solid_levels': [
          ( 0.0, 0, ),
          ( 0.081275414317846295, 0.98999999999999999, ),
          ( 0.8600572943687439, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 0.69999999999999996, 0.69999999999999996, 0.69999999999999996, 1, ),
         ],
        'surface_levels': [ 0.029999999999999999, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( 0.0, 0.0, 0.0, ),
          'clip_plane_origin': ( 0.0, 0.0, 0.0, ),
          'clip_thickness': 5.0,
          'display': True,
          'id': 6,
          'name': '2zu0_A_5_magnet.mrc',
          'osl_identifier': '#6',
          'subid': 0,
          'use_clip_plane': False,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 122.38179747111063,
            'rotation_axis': ( -0.10879168292586723, 0.36694447858689749, 0.92385936124538437, ),
            'translation': ( 56.191834873357067, -39.526251774121199, 962.35431792188785, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.5,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90, 90, 90, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': '2zu0_nonA_10_magnet.mrc',
       'path': './2zu0_nonA_10_magnet.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 0.69999999999999996, 1, 1, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 180, 156, 224, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 180, 156, 224, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': 0,
          'cap_faces': 1,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': 1,
          'dim_transparent_voxels': 1,
          'flip_normals': 1,
          'limit_voxel_count': 1,
          'line_thickness': 1.0,
          'linear_interpolation': 1,
          'maximum_intensity_projection': 0,
          'mesh_lighting': 1,
          'minimal_texture_memory': 0,
          'one_transparent_layer': 0,
          'outline_box_linewidth': 1.0,
          'outline_box_rgb': ( 1.0, 1.0, 1.0, ),
          'projection_mode': 'auto',
          'show_outline_box': 0,
          'smooth_lines': 0,
          'smoothing_factor': 0.29999999999999999,
          'smoothing_iterations': 2,
          'square_mesh': 1,
          'subdivide_surface': 0,
          'subdivision_levels': 1,
          'surface_smoothing': 0,
          'two_sided_lighting': 1,
          'version': 1,
          'voxel_limit': 6.1600000000000001,
         },
        'representation': 'surface',
        'session_volume_id': 860556704,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 0.69999999999999996, 1, 1, 1, ),
          ( 0.69999999999999996, 1, 1, 1, ),
          ( 0.69999999999999996, 1, 1, 1, ),
         ],
        'solid_levels': [
          ( 0.0, 0, ),
          ( 0.061629659533500671, 0.98999999999999999, ),
          ( 0.49902558326721191, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 0.69999998807907104, 1.0, 1.0, 1.0, ),
         ],
        'surface_levels': [ 0.029999999999999999, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( 0.0, 0.0, 0.0, ),
          'clip_plane_origin': ( 0.0, 0.0, 0.0, ),
          'clip_thickness': 5.0,
          'display': True,
          'id': 3,
          'name': '2zu0_nonA_10_magnet.mrc',
          'osl_identifier': '#3',
          'subid': 0,
          'use_clip_plane': False,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 122.38179747111063,
            'rotation_axis': ( -0.10879168292586723, 0.36694447858689749, 0.92385936124538437, ),
            'translation': ( 56.191834873357067, -39.526251774121199, 962.35431792188785, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.5,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90, 90, 90, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': '2zv5_10_magnet.mrc',
       'path': './2zv5_10_magnet.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 1, 0.69999999999999996, 1, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 208, 197, 179, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 208, 197, 179, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': 0,
          'cap_faces': 1,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': 1,
          'dim_transparent_voxels': 1,
          'flip_normals': 1,
          'limit_voxel_count': 1,
          'line_thickness': 1.0,
          'linear_interpolation': 1,
          'maximum_intensity_projection': 0,
          'mesh_lighting': 1,
          'minimal_texture_memory': 0,
          'one_transparent_layer': 0,
          'outline_box_linewidth': 1.0,
          'outline_box_rgb': ( 1.0, 1.0, 1.0, ),
          'projection_mode': 'auto',
          'show_outline_box': 0,
          'smooth_lines': 0,
          'smoothing_factor': 0.29999999999999999,
          'smoothing_iterations': 2,
          'square_mesh': 1,
          'subdivide_surface': 0,
          'subdivision_levels': 1,
          'surface_smoothing': 0,
          'two_sided_lighting': 1,
          'version': 1,
          'voxel_limit': 7.1699999999999999,
         },
        'representation': 'surface',
        'session_volume_id': 1220392400,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 1, 0.69999999999999996, 1, 1, ),
          ( 1, 0.69999999999999996, 1, 1, ),
          ( 1, 0.69999999999999996, 1, 1, ),
         ],
        'solid_levels': [
          ( 0.0, 0, ),
          ( 0.062086245751380921, 0.98999999999999999, ),
          ( 0.49196708202362061, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 1.0, 0.69999998807907104, 1.0, 1.0, ),
         ],
        'surface_levels': [ 0.029999999999999999, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( 0.0, 0.0, 0.0, ),
          'clip_plane_origin': ( 0.0, 0.0, 0.0, ),
          'clip_thickness': 5.0,
          'display': True,
          'id': 5,
          'name': '2zv5_10_magnet.mrc',
          'osl_identifier': '#5',
          'subid': 0,
          'use_clip_plane': False,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 122.38179747111063,
            'rotation_axis': ( -0.10879168292586723, 0.36694447858689749, 0.92385936124538437, ),
            'translation': ( 56.191834873357067, -39.526251774121199, 962.35431792188785, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.5,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90, 90, 90, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': '2zv4_10_magnet.mrc',
       'path': './2zv4_10_magnet.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 0.69999999999999996, 0.69999999999999996, 1, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 171, 177, 218, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 171, 177, 218, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': 0,
          'cap_faces': 1,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': 1,
          'dim_transparent_voxels': 1,
          'flip_normals': 1,
          'limit_voxel_count': 1,
          'line_thickness': 1.0,
          'linear_interpolation': 1,
          'maximum_intensity_projection': 0,
          'mesh_lighting': 1,
          'minimal_texture_memory': 0,
          'one_transparent_layer': 0,
          'outline_box_linewidth': 1.0,
          'outline_box_rgb': ( 1.0, 1.0, 1.0, ),
          'projection_mode': 'auto',
          'show_outline_box': 0,
          'smooth_lines': 0,
          'smoothing_factor': 0.29999999999999999,
          'smoothing_iterations': 2,
          'square_mesh': 1,
          'subdivide_surface': 0,
          'subdivision_levels': 1,
          'surface_smoothing': 0,
          'two_sided_lighting': 1,
          'version': 1,
          'voxel_limit': 6.46,
         },
        'representation': 'surface',
        'session_volume_id': 1220991136,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 0.69999999999999996, 0.69999999999999996, 1, 1, ),
          ( 0.69999999999999996, 0.69999999999999996, 1, 1, ),
          ( 0.69999999999999996, 0.69999999999999996, 1, 1, ),
         ],
        'solid_levels': [
          ( 0.0, 0, ),
          ( 0.060888199120759962, 0.98999999999999999, ),
          ( 0.4999031126499176, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 0.69999998807907104, 0.69999998807907104, 1.0, 1.0, ),
         ],
        'surface_levels': [ 0.029999999999999999, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( 0.0, 0.0, 0.0, ),
          'clip_plane_origin': ( 0.0, 0.0, 0.0, ),
          'clip_thickness': 5.0,
          'display': True,
          'id': 7,
          'name': '2zv4_10_magnet.mrc',
          'osl_identifier': '#7',
          'subid': 0,
          'use_clip_plane': False,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 122.38179747111063,
            'rotation_axis': ( -0.10879168292586723, 0.36694447858689749, 0.92385936124538437, ),
            'translation': ( 56.191834873357067, -39.526251774121199, 962.35431792188785, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.5,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
    ],
   'version': 2,
  }
 from VolumeViewer import session
 session.restore_volume_data_state(volume_data_state)

try:
  restore_volume_data()
except:
  reportRestoreError('Error restoring volume data')


def restore_volume_dialog():
 volume_dialog_state = \
  {
   'adjust_camera': 0,
   'auto_show_subregion': 0,
   'box_padding': '0',
   'class': 'Volume_Dialog_State',
   'data_cache_size': '512',
   'focus_volume': 1220392400,
   'geometry': '459x558+760+412',
   'histogram_active_order': [ 1, 2, 0, 3, ],
   'histogram_volumes': [ 860556704, 1220392400, 1220991136, 1219454376, ],
   'immediate_update': 1,
   'initial_colors': (
     ( 0.69999999999999996, 0.69999999999999996, 0.69999999999999996, 1, ),
     ( 1, 1, 0.69999999999999996, 1, ),
     ( 0.69999999999999996, 1, 1, 1, ),
     ( 0.69999999999999996, 0.69999999999999996, 1, 1, ),
     ( 1, 0.69999999999999996, 1, 1, ),
     ( 1, 0.69999999999999996, 0.69999999999999996, 1, ),
     ( 0.69999999999999996, 1, 0.69999999999999996, 1, ),
     ( 0.90000000000000002, 0.75, 0.59999999999999998, 1, ),
     ( 0.59999999999999998, 0.75, 0.90000000000000002, 1, ),
     ( 0.80000000000000004, 0.80000000000000004, 0.59999999999999998, 1, ),
    ),
   'is_visible': True,
   'max_histograms': '5',
   'representation': 'surface',
   'selectable_subregions': 0,
   'show_on_open': 1,
   'show_plane': 1,
   'shown_panels': [
     'Threshold and Color',
     'Display style',
     'Feature buttons',
    ],
   'subregion_button': 'button 2',
   'use_initial_colors': 1,
   'version': 12,
   'voxel_limit_for_open': '256',
   'voxel_limit_for_plane': '256',
   'zone_radius': 2.0,
  }
 from VolumeViewer import session
 session.restore_volume_dialog_state(volume_dialog_state)

try:
  restore_volume_dialog()
except:
  reportRestoreError('Error restoring volume dialog')

ctMap = {
}

try:
	newMap = {}
	from SimpleSession import idLookup
	for k, v in ctMap.items():
		if v:
			value = [idLookup(a) for a in v]
		else:
			value = v
		newMap[idLookup(k)] = value
	# avoid having the group missing its 'chainTraceMapping' attribute
	# for any period of time...
	from chimera import PseudoBondMgr
	ctGroup = PseudoBondMgr.mgr().findPseudoBondGroup('missing segments')
	if hasattr(ctGroup, "chainTraceMapping"):
		needHandlers = False
	else:
		needHandlers = True
		ctGroup.chainTraceMapping = {}
	ctGroup.display = True
	# chain-trace pseudobonds only exists after a redraw...
	def restoreLBCTmap(trigName, info, trigArgs):
		ctGroup, ctMap, needHandlers = info
		try:
			from chimera import triggers, _longBondTraceCB, _chainTraceSessionCB
			from SimpleSession import SAVE_SESSION
			if needHandlers:
				ctGroup.chainTraceMapping = ctm = {}
				triggers.addHandler("Atom",
						_longBondTraceCB, ctGroup)
				triggers.addHandler(SAVE_SESSION,
						_chainTraceSessionCB, ctGroup)
			for lbpb, v in ctMap.items():
				if v:
					a1, a2 = v
					pbs1 = set(a1.pseudoBonds)
					pbs2 = set(a2.pseudoBonds)
					for pb in (pbs1 & pbs2):
						if pb.category.startswith(
						"internal-chain-"):
							value = pb
							break
					else:
						value = None
				else:
					value = v
				ctm[lbpb] = value
		finally:
			from chimera.triggerSet import ONESHOT
			return ONESHOT
	import chimera
	chimera.triggers.addHandler("post-frame", restoreLBCTmap,
						(ctGroup, newMap, needHandlers))
except:
	reportRestoreError('Error restoring chain-trace pseudobond group')


def restoreLightController():
	import Lighting
	c = Lighting.get().setFromParams({'quality': 'glossy', 'shininess': (30.0, (0.84999999999999998, 0.84999999999999998, 0.84999999999999998), 1.0), 'key': (True, (1.0, 1.0, 1.0), 0.65327227115631104, (1.0, 1.0, 1.0), 1.0, (-0.35740674433659331, 0.66040155174814563, 0.66040155174814552)), 'fill': (True, (1.0, 1.0, 1.0), 0.49998998641967773, (1.0, 1.0, 1.0), 0.0, (0.25056280708573153, 0.25056280708573153, 0.93511312653102929))})
try:
	restoreLightController()
except:
	reportRestoreError("Error restoring lighting parameters")


def restoreSession_RibbonStyleEditor():
	import SimpleSession
	import RibbonStyleEditor
	userScalings = [('aa', [[0.25, 0.25], [1.7, 0.25], [1.5, 0.25], [0.25, 0.25, 3, 0.25], [1.7, 0.25]]), ('default', [[0.25, 0.25], [1.5, 0.25], [1.5, 0.25], [0.25, 0.25, 3, 0.25], [1.5, 0.25]]), ('slim', [[0.2, 0.2], [0.6, 0.2], [0.6, 0.2], [1, 0.2, 0.2, 0.2], [0.6, 0.2]]), ('licorice', [[0.35, 0.35], [0.35, 0.35], [0.35, 0.35], [0.35, 0.35, 0.35, 0.35], [0.35, 0.35]])]
	userXSections = []
	userResidueClasses = [('aa-nomain-ca-o', ('CA', 'O', False, False, {})), ('aa-nomain-c-o', ('C', 'O', False, False, {})), ('aa-camain-ca-o', ('CA', 'O', False, False, {'CA': 0.5}))]
	residueData = []
	SimpleSession.registerAfterModelsCB(RibbonStyleEditor.restoreState,
				(userScalings, userXSections,
				userResidueClasses, residueData))
try:
	restoreSession_RibbonStyleEditor()
except:
	reportRestoreError("Error restoring RibbonStyleEditor state")

def restore_surfaces():
 surface_state = \
  [
   {
    'class': 'Surface_Model_State',
    'name': 'cylinder',
    'one_transparent_layer': False,
    'pieces_are_selectable': True,
    'surface_model': {
      'active': True,
      'class': 'Model_State',
      'clip_plane_normal': ( 0.0, 0.0, 0.0, ),
      'clip_plane_origin': ( 0.0, 0.0, 0.0, ),
      'clip_thickness': 5.0,
      'display': True,
      'id': 0,
      'name': 'cylinder',
      'osl_identifier': '#0',
      'subid': 0,
      'use_clip_plane': False,
      'use_clip_thickness': False,
      'version': 4,
      'xform': {
        'class': 'Xform_State',
        'rotation_angle': 82.138047873437174,
        'rotation_axis': ( 0.72252225350498489, 0.5806084919282789, 0.37530703735851839, ),
        'translation': ( 9.8945944431632995, 33.290234818946033, 1164.9191907983939, ),
        'version': 1,
       },
     },
    'surface_piece_states': [
      {
       'class': 'Surface_Piece_State',
       'color': ( 1.0, 0.27058824896812439, 0.0, 1.0, ),
       'displayStyle': 0,
       'dotSize': 1.0,
       'lineThickness': 1.0,
       'normals': [
         (
          0.83028609,
          0.0,
          -0.5573374,
         ),
         (
          0.82712668,
          0.072364248,
          -0.55733734,
         ),
         (
          0.81767207,
          0.14417781,
          -0.55733764,
         ),
         (
          0.8019945,
          0.21489388,
          -0.55733776,
         ),
         (
          0.78021389,
          0.28397435,
          -0.55733728,
         ),
         (
          0.75249493,
          0.3508943,
          -0.55733693,
         ),
         (
          0.71904886,
          0.41514313,
          -0.5573374,
         ),
         (
          0.6801306,
          0.47623244,
          -0.5573374,
         ),
         (
          0.63603616,
          0.53369772,
          -0.55733722,
         ),
         (
          0.58710086,
          0.58710092,
          -0.55733746,
         ),
         (
          0.53369772,
          0.63603616,
          -0.55733722,
         ),
         (
          0.47623244,
          0.6801306,
          -0.5573374,
         ),
         (
          0.41514313,
          0.7190488,
          -0.5573374,
         ),
         (
          0.35089427,
          0.75249493,
          -0.55733693,
         ),
         (
          0.28397441,
          0.78021383,
          -0.55733734,
         ),
         (
          0.21489386,
          0.8019945,
          -0.55733776,
         ),
         (
          0.14417781,
          0.81767207,
          -0.55733764,
         ),
         (
          0.072364248,
          0.82712668,
          -0.55733734,
         ),
         (
          0.0,
          0.83028609,
          -0.5573374,
         ),
         (
          -0.072364248,
          0.82712668,
          -0.55733734,
         ),
         (
          -0.14417781,
          0.81767207,
          -0.55733764,
         ),
         (
          -0.21489388,
          0.8019945,
          -0.55733776,
         ),
         (
          -0.28397435,
          0.78021389,
          -0.55733728,
         ),
         (
          -0.3508943,
          0.75249493,
          -0.55733693,
         ),
         (
          -0.41514313,
          0.71904886,
          -0.5573374,
         ),
         (
          -0.47623244,
          0.6801306,
          -0.5573374,
         ),
         (
          -0.53369772,
          0.63603616,
          -0.55733722,
         ),
         (
          -0.58710092,
          0.58710086,
          -0.55733746,
         ),
         (
          -0.63603616,
          0.53369772,
          -0.55733722,
         ),
         (
          -0.6801306,
          0.47623244,
          -0.5573374,
         ),
         (
          -0.7190488,
          0.41514313,
          -0.5573374,
         ),
         (
          -0.75249493,
          0.35089427,
          -0.55733693,
         ),
         (
          -0.78021383,
          0.28397441,
          -0.55733734,
         ),
         (
          -0.8019945,
          0.21489386,
          -0.55733776,
         ),
         (
          -0.81767207,
          0.14417781,
          -0.55733764,
         ),
         (
          -0.82712668,
          0.072364248,
          -0.55733734,
         ),
         (
          -0.83028609,
          0.0,
          -0.5573374,
         ),
         (
          -0.82712668,
          -0.072364248,
          -0.55733734,
         ),
         (
          -0.81767207,
          -0.14417781,
          -0.55733764,
         ),
         (
          -0.8019945,
          -0.21489388,
          -0.55733776,
         ),
         (
          -0.78021389,
          -0.28397435,
          -0.55733728,
         ),
         (
          -0.75249493,
          -0.3508943,
          -0.55733693,
         ),
         (
          -0.71904886,
          -0.41514313,
          -0.5573374,
         ),
         (
          -0.6801306,
          -0.47623244,
          -0.5573374,
         ),
         (
          -0.63603616,
          -0.53369772,
          -0.55733722,
         ),
         (
          -0.58710086,
          -0.58710092,
          -0.55733746,
         ),
         (
          -0.53369772,
          -0.63603616,
          -0.55733722,
         ),
         (
          -0.47623244,
          -0.6801306,
          -0.5573374,
         ),
         (
          -0.41514313,
          -0.7190488,
          -0.5573374,
         ),
         (
          -0.35089427,
          -0.75249493,
          -0.55733693,
         ),
         (
          -0.28397441,
          -0.78021383,
          -0.55733734,
         ),
         (
          -0.21489386,
          -0.8019945,
          -0.55733776,
         ),
         (
          -0.14417781,
          -0.81767207,
          -0.55733764,
         ),
         (
          -0.072364248,
          -0.82712668,
          -0.55733734,
         ),
         (
          0.0,
          -0.83028609,
          -0.5573374,
         ),
         (
          0.072364248,
          -0.82712668,
          -0.55733734,
         ),
         (
          0.14417781,
          -0.81767207,
          -0.55733764,
         ),
         (
          0.21489388,
          -0.8019945,
          -0.55733776,
         ),
         (
          0.28397435,
          -0.78021389,
          -0.55733728,
         ),
         (
          0.3508943,
          -0.75249493,
          -0.55733693,
         ),
         (
          0.41514313,
          -0.71904886,
          -0.5573374,
         ),
         (
          0.47623244,
          -0.6801306,
          -0.5573374,
         ),
         (
          0.53369772,
          -0.63603616,
          -0.55733722,
         ),
         (
          0.58710092,
          -0.58710086,
          -0.55733746,
         ),
         (
          0.63603616,
          -0.53369772,
          -0.55733722,
         ),
         (
          0.6801306,
          -0.47623244,
          -0.5573374,
         ),
         (
          0.7190488,
          -0.41514313,
          -0.5573374,
         ),
         (
          0.75249493,
          -0.35089427,
          -0.55733693,
         ),
         (
          0.78021383,
          -0.28397441,
          -0.55733734,
         ),
         (
          0.8019945,
          -0.21489386,
          -0.55733776,
         ),
         (
          0.81767207,
          -0.14417781,
          -0.55733764,
         ),
         (
          0.82712668,
          -0.072364248,
          -0.55733734,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          9.3198493e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.5533083e-10,
         ),
         (
          0.97629595,
          0.21643975,
          -1.0873157e-09,
         ),
         (
          0.95371693,
          0.30070585,
          1.7086391e-09,
         ),
         (
          0.92387956,
          0.38268337,
          1.5533082e-10,
         ),
         (
          0.88701075,
          0.46174878,
          1.5533083e-09,
         ),
         (
          0.84339154,
          0.53729939,
          4.6599247e-10,
         ),
         (
          0.79335344,
          0.60876131,
          2.6406239e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          0.60876131,
          0.7933535,
          2.6406242e-09,
         ),
         (
          0.53729945,
          0.84339154,
          2.9512857e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          0.38268337,
          0.92387956,
          2.7959546e-09,
         ),
         (
          0.30070585,
          0.95371699,
          4.1939323e-09,
         ),
         (
          0.21643974,
          0.97629595,
          4.038601e-09,
         ),
         (
          0.13052627,
          0.99144489,
          1.8639699e-09,
         ),
         (
          0.043619301,
          0.99904829,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          0.99904817,
          9.3198493e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.5533083e-10,
         ),
         (
          -0.21643975,
          0.97629595,
          -1.0873157e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          1.7086391e-09,
         ),
         (
          -0.38268337,
          0.92387956,
          1.5533082e-10,
         ),
         (
          -0.46174878,
          0.88701075,
          1.5533083e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          4.6599247e-10,
         ),
         (
          -0.60876131,
          0.79335344,
          2.6406239e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          2.6406242e-09,
         ),
         (
          -0.84339154,
          0.53729945,
          2.9512857e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.92387956,
          0.38268337,
          2.7959546e-09,
         ),
         (
          -0.95371699,
          0.30070585,
          4.1939323e-09,
         ),
         (
          -0.97629595,
          0.21643974,
          4.038601e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          1.8639699e-09,
         ),
         (
          -0.99904829,
          0.043619301,
          1.8639699e-09,
         ),
         (
          -0.99904817,
          -0.043619301,
          9.3198493e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.5533083e-10,
         ),
         (
          -0.97629595,
          -0.21643975,
          -1.0873157e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          1.7086391e-09,
         ),
         (
          -0.92387956,
          -0.38268337,
          1.5533082e-10,
         ),
         (
          -0.88701075,
          -0.46174878,
          1.5533083e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          4.6599247e-10,
         ),
         (
          -0.79335344,
          -0.60876131,
          2.6406239e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          2.6406242e-09,
         ),
         (
          -0.53729945,
          -0.84339154,
          2.9512857e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.38268337,
          -0.92387956,
          2.7959546e-09,
         ),
         (
          -0.30070585,
          -0.95371699,
          4.1939323e-09,
         ),
         (
          -0.21643974,
          -0.97629595,
          4.038601e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          -0.99904829,
          1.8639699e-09,
         ),
         (
          0.043619301,
          -0.99904817,
          9.3198493e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.5533083e-10,
         ),
         (
          0.21643975,
          -0.97629595,
          -1.0873157e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          1.7086391e-09,
         ),
         (
          0.38268337,
          -0.92387956,
          1.5533082e-10,
         ),
         (
          0.46174878,
          -0.88701075,
          1.5533083e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          4.6599247e-10,
         ),
         (
          0.60876131,
          -0.79335344,
          2.6406239e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          2.6406242e-09,
         ),
         (
          0.84339154,
          -0.53729945,
          2.9512857e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          0.92387956,
          -0.38268337,
          2.7959546e-09,
         ),
         (
          0.95371699,
          -0.30070585,
          4.1939323e-09,
         ),
         (
          0.97629595,
          -0.21643974,
          4.038601e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          1.8639699e-09,
         ),
         (
          0.99904829,
          -0.043619301,
          1.8639699e-09,
         ),
         (
          1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          0.99619478,
          0.087155804,
          -2.3299624e-09,
         ),
         (
          0.98480773,
          0.17364837,
          -3.1066165e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -1.8639699e-09,
         ),
         (
          0.93969274,
          0.34201986,
          -1.3979773e-09,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533081e-09,
         ),
         (
          0.86602545,
          0.50000006,
          -2.4852933e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -1.3979774e-09,
         ),
         (
          0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          0.57357633,
          0.81915212,
          1.0873157e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -2.4852933e-09,
         ),
         (
          0.42261839,
          0.9063077,
          -1.3979773e-09,
         ),
         (
          0.34201986,
          0.93969274,
          1.2426465e-09,
         ),
         (
          0.25881913,
          0.96592581,
          1.8639699e-09,
         ),
         (
          0.17364839,
          0.98480773,
          -4.6599247e-10,
         ),
         (
          0.087155804,
          0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          1.0,
          -1.2426465e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          -2.3299624e-09,
         ),
         (
          -0.17364837,
          0.98480773,
          -3.1066165e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -1.8639699e-09,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.3979773e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533081e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -1.3979774e-09,
         ),
         (
          -0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          1.0873157e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -2.4852933e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          -1.3979773e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          1.2426465e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          1.8639699e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          -4.6599247e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          -1.3979774e-09,
         ),
         (
          -1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          -2.3299624e-09,
         ),
         (
          -0.98480773,
          -0.17364837,
          -3.1066165e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -1.8639699e-09,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.3979773e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533081e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          -2.4852933e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -1.3979774e-09,
         ),
         (
          -0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          1.0873157e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -2.4852933e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          -1.3979773e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          1.2426465e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          1.8639699e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          -4.6599247e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          -1.0,
          -1.2426465e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          -2.3299624e-09,
         ),
         (
          0.17364837,
          -0.98480773,
          -3.1066165e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -1.8639699e-09,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.3979773e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533081e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -1.3979774e-09,
         ),
         (
          0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          1.0873157e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -2.4852933e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          -1.3979773e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          1.2426465e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          1.8639699e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          -4.6599247e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          -1.3979774e-09,
         ),
         (
          0.99904829,
          0.043619301,
          -2.1746316e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -3.1066165e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -4.038601e-09,
         ),
         (
          0.95371693,
          0.30070588,
          -1.3979774e-09,
         ),
         (
          0.92387956,
          0.3826834,
          -2.7959548e-09,
         ),
         (
          0.88701075,
          0.46174878,
          -1.5533083e-09,
         ),
         (
          0.84339154,
          0.53729945,
          -2.6406239e-09,
         ),
         (
          0.79335344,
          0.60876137,
          -4.6599247e-10,
         ),
         (
          0.73727721,
          0.67559034,
          -4.1939323e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -4.1939323e-09,
         ),
         (
          0.60876131,
          0.7933535,
          -4.6599247e-10,
         ),
         (
          0.53729939,
          0.84339154,
          -1.5533082e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -4.0386015e-09,
         ),
         (
          0.38268337,
          0.92387956,
          -1.5533082e-10,
         ),
         (
          0.30070585,
          0.95371693,
          1.2426465e-09,
         ),
         (
          0.21643975,
          0.97629595,
          1.0873157e-09,
         ),
         (
          0.13052627,
          0.99144489,
          -1.2426467e-09,
         ),
         (
          0.043619301,
          0.99904829,
          -1.2426467e-09,
         ),
         (
          -0.043619301,
          0.99904817,
          -2.1746316e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -3.1066165e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -4.038601e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          -1.3979774e-09,
         ),
         (
          -0.3826834,
          0.92387956,
          -2.7959548e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          -1.5533083e-09,
         ),
         (
          -0.53729945,
          0.84339154,
          -2.6406239e-09,
         ),
         (
          -0.60876137,
          0.79335344,
          -4.6599247e-10,
         ),
         (
          -0.67559034,
          0.73727721,
          -4.1939323e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -4.1939323e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          -4.6599247e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          -1.5533082e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -4.0386015e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          -1.5533082e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          1.2426465e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          1.0873157e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          -1.2426467e-09,
         ),
         (
          -0.99904829,
          0.043619301,
          -1.2426467e-09,
         ),
         (
          -0.99904817,
          -0.043619301,
          -2.1746316e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -3.1066165e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -4.038601e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          -1.3979774e-09,
         ),
         (
          -0.92387956,
          -0.3826834,
          -2.7959548e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          -1.5533083e-09,
         ),
         (
          -0.84339154,
          -0.53729945,
          -2.6406239e-09,
         ),
         (
          -0.79335344,
          -0.60876137,
          -4.6599247e-10,
         ),
         (
          -0.73727721,
          -0.67559034,
          -4.1939323e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -4.1939323e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          -4.6599247e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          -1.5533082e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -4.0386015e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          -1.5533082e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          1.2426465e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          1.0873157e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          -1.2426467e-09,
         ),
         (
          -0.043619301,
          -0.99904829,
          -1.2426467e-09,
         ),
         (
          0.043619301,
          -0.99904817,
          -2.1746316e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -3.1066165e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -4.038601e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          -1.3979774e-09,
         ),
         (
          0.3826834,
          -0.92387956,
          -2.7959548e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          -1.5533083e-09,
         ),
         (
          0.53729945,
          -0.84339154,
          -2.6406239e-09,
         ),
         (
          0.60876137,
          -0.79335344,
          -4.6599247e-10,
         ),
         (
          0.67559034,
          -0.73727721,
          -4.1939323e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -4.1939323e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          -4.6599247e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          -1.5533082e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -4.0386015e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          -1.5533082e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          1.2426465e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          1.0873157e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          -1.2426467e-09,
         ),
         (
          0.99904829,
          -0.043619301,
          -1.2426467e-09,
         ),
         (
          1.0,
          0.0,
          3.417278e-09,
         ),
         (
          0.99619478,
          0.087155804,
          2.0193007e-09,
         ),
         (
          0.98480773,
          0.17364839,
          1.3979774e-09,
         ),
         (
          0.96592581,
          0.25881913,
          2.1746314e-09,
         ),
         (
          0.93969274,
          0.34201986,
          3.1066163e-09,
         ),
         (
          0.9063077,
          0.42261836,
          3.1066163e-09,
         ),
         (
          0.86602545,
          0.50000006,
          1.8639699e-09,
         ),
         (
          0.81915218,
          0.57357633,
          2.9512857e-09,
         ),
         (
          0.76604438,
          0.64278764,
          1.5533083e-10,
         ),
         (
          0.70710683,
          0.70710683,
          -2.3299624e-09,
         ),
         (
          0.64278764,
          0.76604444,
          1.5533083e-10,
         ),
         (
          0.57357633,
          0.81915212,
          5.5919092e-09,
         ),
         (
          0.50000006,
          0.86602539,
          2.0193005e-09,
         ),
         (
          0.42261839,
          0.9063077,
          3.2619472e-09,
         ),
         (
          0.34201986,
          0.93969274,
          5.74724e-09,
         ),
         (
          0.25881913,
          0.96592581,
          6.0579017e-09,
         ),
         (
          0.17364839,
          0.98480773,
          3.8832706e-09,
         ),
         (
          0.087155797,
          0.99619466,
          2.9512857e-09,
         ),
         (
          0.0,
          1.0,
          3.417278e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          2.0193007e-09,
         ),
         (
          -0.17364839,
          0.98480773,
          1.3979774e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          2.1746314e-09,
         ),
         (
          -0.34201986,
          0.93969274,
          3.1066163e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          3.1066163e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          1.8639699e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          2.9512857e-09,
         ),
         (
          -0.64278764,
          0.76604438,
          1.5533083e-10,
         ),
         (
          -0.70710683,
          0.70710683,
          -2.3299624e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          1.5533083e-10,
         ),
         (
          -0.81915212,
          0.57357633,
          5.5919092e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          2.0193005e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          3.2619472e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          5.74724e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          6.0579017e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          3.8832706e-09,
         ),
         (
          -0.99619466,
          0.087155797,
          2.9512857e-09,
         ),
         (
          -1.0,
          0.0,
          3.417278e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          2.0193007e-09,
         ),
         (
          -0.98480773,
          -0.17364839,
          1.3979774e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          2.1746314e-09,
         ),
         (
          -0.93969274,
          -0.34201986,
          3.1066163e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          3.1066163e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          1.8639699e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          2.9512857e-09,
         ),
         (
          -0.76604438,
          -0.64278764,
          1.5533083e-10,
         ),
         (
          -0.70710683,
          -0.70710683,
          -2.3299624e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          1.5533083e-10,
         ),
         (
          -0.57357633,
          -0.81915212,
          5.5919092e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          2.0193005e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          3.2619472e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          5.74724e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          6.0579017e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          3.8832706e-09,
         ),
         (
          -0.087155797,
          -0.99619466,
          2.9512857e-09,
         ),
         (
          0.0,
          -1.0,
          3.417278e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          2.0193007e-09,
         ),
         (
          0.17364839,
          -0.98480773,
          1.3979774e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          2.1746314e-09,
         ),
         (
          0.34201986,
          -0.93969274,
          3.1066163e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          3.1066163e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          1.8639699e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          2.9512857e-09,
         ),
         (
          0.64278764,
          -0.76604438,
          1.5533083e-10,
         ),
         (
          0.70710683,
          -0.70710683,
          -2.3299624e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          1.5533083e-10,
         ),
         (
          0.81915212,
          -0.57357633,
          5.5919092e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          2.0193005e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          3.2619472e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          5.74724e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          6.0579017e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          3.8832706e-09,
         ),
         (
          0.99619466,
          -0.087155797,
          2.9512857e-09,
         ),
         (
          0.99904829,
          0.043619297,
          -2.1746316e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -3.2619472e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -4.3492627e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.708639e-09,
         ),
         (
          0.92387956,
          0.38268337,
          -2.7959546e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.3979774e-09,
         ),
         (
          0.84339154,
          0.53729939,
          -2.9512854e-09,
         ),
         (
          0.7933535,
          0.60876131,
          -1.5533083e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -4.038601e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -4.0386015e-09,
         ),
         (
          0.60876131,
          0.79335338,
          -1.5533083e-10,
         ),
         (
          0.53729939,
          0.84339154,
          -3.1066164e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -3.8832706e-09,
         ),
         (
          0.38268337,
          0.92387956,
          -1.5533082e-10,
         ),
         (
          0.30070585,
          0.95371693,
          9.3198493e-10,
         ),
         (
          0.21643975,
          0.97629595,
          9.3198493e-10,
         ),
         (
          0.13052627,
          0.99144489,
          -1.2426467e-09,
         ),
         (
          0.043619297,
          0.99904829,
          -1.2426467e-09,
         ),
         (
          -0.043619297,
          0.99904817,
          -2.1746316e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -3.2619472e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -4.3492627e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.708639e-09,
         ),
         (
          -0.38268337,
          0.92387956,
          -2.7959546e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.3979774e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          -2.9512854e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          -1.5533083e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -4.038601e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -4.0386015e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          -3.1066164e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -3.8832706e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          -1.5533082e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          9.3198493e-10,
         ),
         (
          -0.97629595,
          0.21643975,
          9.3198493e-10,
         ),
         (
          -0.99144489,
          0.13052627,
          -1.2426467e-09,
         ),
         (
          -0.99904829,
          0.043619297,
          -1.2426467e-09,
         ),
         (
          -0.99904817,
          -0.043619297,
          -2.1746316e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -3.2619472e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -4.3492627e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.708639e-09,
         ),
         (
          -0.92387956,
          -0.38268337,
          -2.7959546e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.3979774e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          -2.9512854e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          -1.5533083e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -4.038601e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -4.0386015e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          -1.5533083e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          -3.1066164e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -3.8832706e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          -1.5533082e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          9.3198493e-10,
         ),
         (
          -0.21643975,
          -0.97629595,
          9.3198493e-10,
         ),
         (
          -0.13052627,
          -0.99144489,
          -1.2426467e-09,
         ),
         (
          -0.043619297,
          -0.99904829,
          -1.2426467e-09,
         ),
         (
          0.043619297,
          -0.99904817,
          -2.1746316e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -3.2619472e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -4.3492627e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.708639e-09,
         ),
         (
          0.38268337,
          -0.92387956,
          -2.7959546e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.3979774e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          -2.9512854e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          -1.5533083e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -4.038601e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -4.0386015e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          -3.1066164e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -3.8832706e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          -1.5533082e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          9.3198493e-10,
         ),
         (
          0.97629595,
          -0.21643975,
          9.3198493e-10,
         ),
         (
          0.99144489,
          -0.13052627,
          -1.2426467e-09,
         ),
         (
          0.99904829,
          -0.043619297,
          -1.2426467e-09,
         ),
         (
          1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          0.99619466,
          0.087155797,
          -3.1066166e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.0873158e-09,
         ),
         (
          0.96592581,
          0.25881916,
          0.0,
         ),
         (
          0.9396928,
          0.34201986,
          7.7665413e-10,
         ),
         (
          0.9063077,
          0.42261836,
          7.7665407e-10,
         ),
         (
          0.86602539,
          0.5,
          -6.2132322e-10,
         ),
         (
          0.81915218,
          0.57357633,
          6.2132333e-10,
         ),
         (
          0.76604438,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -3.8832701e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          0.57357633,
          0.81915212,
          3.1066163e-09,
         ),
         (
          0.50000006,
          0.86602545,
          -6.2132333e-10,
         ),
         (
          0.42261839,
          0.9063077,
          7.7665407e-10,
         ),
         (
          0.34201989,
          0.93969274,
          3.2619474e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.8832701e-09,
         ),
         (
          0.17364839,
          0.98480773,
          1.5533083e-09,
         ),
         (
          0.087155804,
          0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          1.0,
          1.0873157e-09,
         ),
         (
          -0.087155797,
          0.99619466,
          -3.1066166e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.0873158e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          0.0,
         ),
         (
          -0.34201986,
          0.9396928,
          7.7665413e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          7.7665407e-10,
         ),
         (
          -0.5,
          0.86602539,
          -6.2132322e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          6.2132333e-10,
         ),
         (
          -0.64278764,
          0.76604438,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -3.8832701e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          3.1066163e-09,
         ),
         (
          -0.86602545,
          0.50000006,
          -6.2132333e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          7.7665407e-10,
         ),
         (
          -0.93969274,
          0.34201989,
          3.2619474e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.8832701e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          1.5533083e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          6.2132333e-10,
         ),
         (
          -1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          -0.99619466,
          -0.087155797,
          -3.1066166e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.0873158e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          0.0,
         ),
         (
          -0.9396928,
          -0.34201986,
          7.7665413e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          7.7665407e-10,
         ),
         (
          -0.86602539,
          -0.5,
          -6.2132322e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          6.2132333e-10,
         ),
         (
          -0.76604438,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -3.8832701e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          3.1066163e-09,
         ),
         (
          -0.50000006,
          -0.86602545,
          -6.2132333e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          -0.34201989,
          -0.93969274,
          3.2619474e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.8832701e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          1.5533083e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          -1.0,
          1.0873157e-09,
         ),
         (
          0.087155797,
          -0.99619466,
          -3.1066166e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.0873158e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          0.0,
         ),
         (
          0.34201986,
          -0.9396928,
          7.7665413e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          0.5,
          -0.86602539,
          -6.2132322e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          6.2132333e-10,
         ),
         (
          0.64278764,
          -0.76604438,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -3.8832701e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          3.1066163e-09,
         ),
         (
          0.86602545,
          -0.50000006,
          -6.2132333e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          7.7665407e-10,
         ),
         (
          0.93969274,
          -0.34201989,
          3.2619474e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.8832701e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          1.5533083e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          6.2132333e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -1.3979774e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -2.4852931e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -3.417278e-09,
         ),
         (
          0.95371699,
          0.30070585,
          -7.7665413e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -2.0193005e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -2.1746314e-09,
         ),
         (
          0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -2.9512854e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.9512857e-09,
         ),
         (
          0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          0.53729939,
          0.84339154,
          3.1066164e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -3.4172782e-09,
         ),
         (
          0.3826834,
          0.92387956,
          4.6599247e-10,
         ),
         (
          0.30070585,
          0.95371693,
          1.8639699e-09,
         ),
         (
          0.21643975,
          0.97629595,
          1.8639699e-09,
         ),
         (
          0.13052627,
          0.99144489,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          0.99904829,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -1.3979774e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -2.4852931e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -3.417278e-09,
         ),
         (
          -0.30070585,
          0.95371699,
          -7.7665413e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -2.0193005e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -2.1746314e-09,
         ),
         (
          -0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.9512854e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.9512857e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          3.1066164e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -3.4172782e-09,
         ),
         (
          -0.92387956,
          0.3826834,
          4.6599247e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          1.8639699e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          1.8639699e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          -4.6599247e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          -4.6599247e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -1.3979774e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -2.4852931e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -3.417278e-09,
         ),
         (
          -0.95371699,
          -0.30070585,
          -7.7665413e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -2.0193005e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -2.1746314e-09,
         ),
         (
          -0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.9512854e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.9512857e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          3.1066164e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -3.4172782e-09,
         ),
         (
          -0.3826834,
          -0.92387956,
          4.6599247e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          1.8639699e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          1.8639699e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -1.3979774e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -2.4852931e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -3.417278e-09,
         ),
         (
          0.30070585,
          -0.95371699,
          -7.7665413e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -2.0193005e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -2.1746314e-09,
         ),
         (
          0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.9512854e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.9512857e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          3.1066164e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -3.4172782e-09,
         ),
         (
          0.92387956,
          -0.3826834,
          4.6599247e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          1.8639699e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          1.8639699e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          -4.6599247e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          -4.6599247e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          6.2132327e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -6.2132333e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.3979774e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -4.6599247e-10,
         ),
         (
          0.93969274,
          0.34201986,
          4.6599247e-10,
         ),
         (
          0.9063077,
          0.42261836,
          4.6599247e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -9.3198493e-10,
         ),
         (
          0.81915218,
          0.57357633,
          3.1066166e-10,
         ),
         (
          0.76604444,
          0.64278764,
          -2.0193007e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.5045936e-09,
         ),
         (
          0.64278764,
          0.76604438,
          -2.0193007e-09,
         ),
         (
          0.57357633,
          0.81915218,
          2.9512854e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -9.3198493e-10,
         ),
         (
          0.42261836,
          0.9063077,
          3.1066164e-10,
         ),
         (
          0.34201992,
          0.93969274,
          2.9512857e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.417278e-09,
         ),
         (
          0.17364837,
          0.98480773,
          1.2426467e-09,
         ),
         (
          0.087155804,
          0.99619466,
          3.1066166e-10,
         ),
         (
          0.0,
          1.0,
          6.2132327e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -6.2132333e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.3979774e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -4.6599247e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          4.6599247e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          4.6599247e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -9.3198493e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          3.1066166e-10,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.0193007e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.5045936e-09,
         ),
         (
          -0.76604438,
          0.64278764,
          -2.0193007e-09,
         ),
         (
          -0.81915218,
          0.57357633,
          2.9512854e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -9.3198493e-10,
         ),
         (
          -0.9063077,
          0.42261836,
          3.1066164e-10,
         ),
         (
          -0.93969274,
          0.34201992,
          2.9512857e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.417278e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          1.2426467e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          3.1066166e-10,
         ),
         (
          -1.0,
          0.0,
          6.2132327e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -6.2132333e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.3979774e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -4.6599247e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          4.6599247e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          4.6599247e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -9.3198493e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          3.1066166e-10,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.0193007e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.5045936e-09,
         ),
         (
          -0.64278764,
          -0.76604438,
          -2.0193007e-09,
         ),
         (
          -0.57357633,
          -0.81915218,
          2.9512854e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -9.3198493e-10,
         ),
         (
          -0.42261836,
          -0.9063077,
          3.1066164e-10,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.9512857e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.417278e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          1.2426467e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          3.1066166e-10,
         ),
         (
          0.0,
          -1.0,
          6.2132327e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -6.2132333e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.3979774e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -4.6599247e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          4.6599247e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          4.6599247e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -9.3198493e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          3.1066166e-10,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.0193007e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.5045936e-09,
         ),
         (
          0.76604438,
          -0.64278764,
          -2.0193007e-09,
         ),
         (
          0.81915218,
          -0.57357633,
          2.9512854e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -9.3198493e-10,
         ),
         (
          0.9063077,
          -0.42261836,
          3.1066164e-10,
         ),
         (
          0.93969274,
          -0.34201992,
          2.9512857e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.417278e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          1.2426467e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          3.1066166e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.5533081e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.4852931e-09,
         ),
         (
          0.95371693,
          0.30070588,
          0.0,
         ),
         (
          0.92387956,
          0.38268337,
          -1.0873157e-09,
         ),
         (
          0.88701075,
          0.46174878,
          1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.79335338,
          0.60876143,
          1.0873158e-09,
         ),
         (
          0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          0.60876137,
          0.79335338,
          1.0873158e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.2426465e-09,
         ),
         (
          0.46174878,
          0.88701075,
          -2.4852933e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.3979773e-09,
         ),
         (
          0.30070588,
          0.95371693,
          2.4852933e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.5533081e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.4852931e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          0.0,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.0873157e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876143,
          0.79335338,
          1.0873158e-09,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.79335338,
          0.60876137,
          1.0873158e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.2426465e-09,
         ),
         (
          -0.88701075,
          0.46174878,
          -2.4852933e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.3979773e-09,
         ),
         (
          -0.95371693,
          0.30070588,
          2.4852933e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.5533081e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.4852931e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          0.0,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.0873157e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.79335338,
          -0.60876143,
          1.0873158e-09,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.60876137,
          -0.79335338,
          1.0873158e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.2426465e-09,
         ),
         (
          -0.46174878,
          -0.88701075,
          -2.4852933e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.3979773e-09,
         ),
         (
          -0.30070588,
          -0.95371693,
          2.4852933e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.5533081e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.4852931e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          0.0,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.0873157e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876143,
          -0.79335338,
          1.0873158e-09,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          0.79335338,
          -0.60876137,
          1.0873158e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.2426465e-09,
         ),
         (
          0.88701075,
          -0.46174878,
          -2.4852933e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.3979773e-09,
         ),
         (
          0.95371693,
          -0.30070588,
          2.4852933e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          4.6599247e-10,
         ),
         (
          0.99619478,
          0.087155804,
          -1.0873158e-09,
         ),
         (
          0.98480773,
          0.17364837,
          -1.5533083e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -1.0873157e-09,
         ),
         (
          0.93969274,
          0.34201992,
          -6.2132327e-10,
         ),
         (
          0.9063077,
          0.42261836,
          0.0,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -3.1066166e-10,
         ),
         (
          0.76604438,
          0.64278769,
          -2.7959548e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -5.2812479e-09,
         ),
         (
          0.64278769,
          0.76604438,
          -2.7959546e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.3299622e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -1.0873158e-09,
         ),
         (
          0.42261836,
          0.9063077,
          1.5533082e-10,
         ),
         (
          0.34201992,
          0.93969274,
          2.0193005e-09,
         ),
         (
          0.25881913,
          0.96592581,
          2.6406239e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155804,
          0.99619466,
          -1.5533083e-10,
         ),
         (
          0.0,
          1.0,
          4.6599247e-10,
         ),
         (
          -0.087155804,
          0.99619478,
          -1.0873158e-09,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.5533083e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -1.0873157e-09,
         ),
         (
          -0.34201992,
          0.93969274,
          -6.2132327e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          0.0,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -3.1066166e-10,
         ),
         (
          -0.64278769,
          0.76604438,
          -2.7959548e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -5.2812479e-09,
         ),
         (
          -0.76604438,
          0.64278769,
          -2.7959546e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.3299622e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -1.0873158e-09,
         ),
         (
          -0.9063077,
          0.42261836,
          1.5533082e-10,
         ),
         (
          -0.93969274,
          0.34201992,
          2.0193005e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          2.6406239e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          -1.5533083e-10,
         ),
         (
          -1.0,
          0.0,
          4.6599247e-10,
         ),
         (
          -0.99619478,
          -0.087155804,
          -1.0873158e-09,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.5533083e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -1.0873157e-09,
         ),
         (
          -0.93969274,
          -0.34201992,
          -6.2132327e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          0.0,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -3.1066166e-10,
         ),
         (
          -0.76604438,
          -0.64278769,
          -2.7959548e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -5.2812479e-09,
         ),
         (
          -0.64278769,
          -0.76604438,
          -2.7959546e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.3299622e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -1.0873158e-09,
         ),
         (
          -0.42261836,
          -0.9063077,
          1.5533082e-10,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.0193005e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          2.6406239e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          -1.5533083e-10,
         ),
         (
          0.0,
          -1.0,
          4.6599247e-10,
         ),
         (
          0.087155804,
          -0.99619478,
          -1.0873158e-09,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.5533083e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -1.0873157e-09,
         ),
         (
          0.34201992,
          -0.93969274,
          -6.2132327e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          0.0,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -3.1066166e-10,
         ),
         (
          0.64278769,
          -0.76604438,
          -2.7959548e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -5.2812479e-09,
         ),
         (
          0.76604438,
          -0.64278769,
          -2.7959546e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.3299622e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -1.0873158e-09,
         ),
         (
          0.9063077,
          -0.42261836,
          1.5533082e-10,
         ),
         (
          0.93969274,
          -0.34201992,
          2.0193005e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          2.6406239e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          -1.5533083e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -4.6599247e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.3979774e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.1746314e-09,
         ),
         (
          0.95371693,
          0.30070588,
          -1.5533083e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.0873157e-09,
         ),
         (
          0.88701075,
          0.46174878,
          4.6599247e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.0873157e-09,
         ),
         (
          0.79335338,
          0.60876143,
          1.2426467e-09,
         ),
         (
          0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          0.60876143,
          0.79335338,
          1.2426467e-09,
         ),
         (
          0.53729945,
          0.84339154,
          1.5533081e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.0193007e-09,
         ),
         (
          0.3826834,
          0.92387956,
          1.5533083e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.3299622e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.7959546e-09,
         ),
         (
          0.13052627,
          0.99144489,
          4.6599247e-10,
         ),
         (
          0.043619301,
          0.99904829,
          4.6599247e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -4.6599247e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.3979774e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.1746314e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          -1.5533083e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.0873157e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          4.6599247e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.0873157e-09,
         ),
         (
          -0.60876143,
          0.79335338,
          1.2426467e-09,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.79335338,
          0.60876143,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729945,
          1.5533081e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.0193007e-09,
         ),
         (
          -0.92387956,
          0.3826834,
          1.5533083e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.3299622e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.7959546e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          4.6599247e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          4.6599247e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -4.6599247e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.3979774e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.1746314e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          -1.5533083e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.0873157e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          4.6599247e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.0873157e-09,
         ),
         (
          -0.79335338,
          -0.60876143,
          1.2426467e-09,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.60876143,
          -0.79335338,
          1.2426467e-09,
         ),
         (
          -0.53729945,
          -0.84339154,
          1.5533081e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.0193007e-09,
         ),
         (
          -0.3826834,
          -0.92387956,
          1.5533083e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.3299622e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.7959546e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          4.6599247e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          4.6599247e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -4.6599247e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.3979774e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.1746314e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          -1.5533083e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.0873157e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          4.6599247e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.0873157e-09,
         ),
         (
          0.60876143,
          -0.79335338,
          1.2426467e-09,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          0.79335338,
          -0.60876143,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729945,
          1.5533081e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.0193007e-09,
         ),
         (
          0.92387956,
          -0.3826834,
          1.5533083e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.3299622e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.7959546e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          4.6599247e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          4.6599247e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619478,
          0.087155804,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.5533083e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -6.2132327e-10,
         ),
         (
          0.93969274,
          0.34201986,
          0.0,
         ),
         (
          0.9063077,
          0.42261836,
          3.1066164e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -1.5533083e-10,
         ),
         (
          0.76604444,
          0.64278769,
          -2.6406242e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278775,
          0.76604438,
          -2.6406242e-09,
         ),
         (
          0.57357633,
          0.81915218,
          2.4852931e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -1.2426467e-09,
         ),
         (
          0.42261836,
          0.9063077,
          1.5533082e-10,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852931e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364839,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155804,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155804,
          0.99619478,
          -9.3198493e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.5533083e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -6.2132327e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          0.0,
         ),
         (
          -0.42261836,
          0.9063077,
          3.1066164e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -1.5533083e-10,
         ),
         (
          -0.64278769,
          0.76604444,
          -2.6406242e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604438,
          0.64278775,
          -2.6406242e-09,
         ),
         (
          -0.81915218,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -1.2426467e-09,
         ),
         (
          -0.9063077,
          0.42261836,
          1.5533082e-10,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852931e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619478,
          -0.087155804,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.5533083e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -6.2132327e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          0.0,
         ),
         (
          -0.9063077,
          -0.42261836,
          3.1066164e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -1.5533083e-10,
         ),
         (
          -0.76604444,
          -0.64278769,
          -2.6406242e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278775,
          -0.76604438,
          -2.6406242e-09,
         ),
         (
          -0.57357633,
          -0.81915218,
          2.4852931e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -1.2426467e-09,
         ),
         (
          -0.42261836,
          -0.9063077,
          1.5533082e-10,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852931e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155804,
          -0.99619478,
          -9.3198493e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.5533083e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -6.2132327e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          0.0,
         ),
         (
          0.42261836,
          -0.9063077,
          3.1066164e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -1.5533083e-10,
         ),
         (
          0.64278769,
          -0.76604444,
          -2.6406242e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604438,
          -0.64278775,
          -2.6406242e-09,
         ),
         (
          0.81915218,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -1.2426467e-09,
         ),
         (
          0.9063077,
          -0.42261836,
          1.5533082e-10,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852931e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          -9.3198493e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -2.0193005e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -3.2619472e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -4.6599247e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.708639e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -4.6599247e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.8639699e-09,
         ),
         (
          0.7933535,
          0.60876131,
          9.3198493e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -2.7959546e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.7959548e-09,
         ),
         (
          0.60876131,
          0.79335338,
          9.3198493e-10,
         ),
         (
          0.53729939,
          0.84339154,
          7.7665407e-10,
         ),
         (
          0.46174878,
          0.88701075,
          -3.1066165e-09,
         ),
         (
          0.38268337,
          0.92387956,
          7.7665407e-10,
         ),
         (
          0.30070588,
          0.95371693,
          2.1746316e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.0193005e-09,
         ),
         (
          0.13052627,
          0.99144489,
          0.0,
         ),
         (
          0.043619301,
          0.99904829,
          0.0,
         ),
         (
          -0.043619301,
          0.99904817,
          -9.3198493e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -2.0193005e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -3.2619472e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -4.6599247e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.708639e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -4.6599247e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.8639699e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          9.3198493e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.7959546e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.7959548e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          9.3198493e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          7.7665407e-10,
         ),
         (
          -0.88701075,
          0.46174878,
          -3.1066165e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          7.7665407e-10,
         ),
         (
          -0.95371693,
          0.30070588,
          2.1746316e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.0193005e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          0.0,
         ),
         (
          -0.99904829,
          0.043619301,
          0.0,
         ),
         (
          -0.99904817,
          -0.043619301,
          -9.3198493e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -2.0193005e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -3.2619472e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -4.6599247e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.708639e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -4.6599247e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.8639699e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          9.3198493e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.7959546e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.7959548e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          9.3198493e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          7.7665407e-10,
         ),
         (
          -0.46174878,
          -0.88701075,
          -3.1066165e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          7.7665407e-10,
         ),
         (
          -0.30070588,
          -0.95371693,
          2.1746316e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.0193005e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          0.0,
         ),
         (
          -0.043619301,
          -0.99904829,
          0.0,
         ),
         (
          0.043619301,
          -0.99904817,
          -9.3198493e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -2.0193005e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -3.2619472e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -4.6599247e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.708639e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -4.6599247e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.8639699e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          9.3198493e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.7959546e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.7959548e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          9.3198493e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          7.7665407e-10,
         ),
         (
          0.88701075,
          -0.46174878,
          -3.1066165e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          7.7665407e-10,
         ),
         (
          0.95371693,
          -0.30070588,
          2.1746316e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.0193005e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          0.0,
         ),
         (
          0.99904829,
          -0.043619301,
          0.0,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          0.99619466,
          0.087155797,
          -3.1066166e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.0873158e-09,
         ),
         (
          0.96592581,
          0.25881916,
          0.0,
         ),
         (
          0.9396928,
          0.34201986,
          7.7665413e-10,
         ),
         (
          0.9063077,
          0.42261836,
          7.7665407e-10,
         ),
         (
          0.86602539,
          0.5,
          -6.2132322e-10,
         ),
         (
          0.81915218,
          0.57357633,
          6.2132333e-10,
         ),
         (
          0.76604438,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -3.8832701e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          0.57357633,
          0.81915212,
          3.1066163e-09,
         ),
         (
          0.50000006,
          0.86602545,
          -6.2132333e-10,
         ),
         (
          0.42261839,
          0.9063077,
          7.7665407e-10,
         ),
         (
          0.34201989,
          0.93969274,
          3.2619474e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.8832701e-09,
         ),
         (
          0.17364839,
          0.98480773,
          1.5533083e-09,
         ),
         (
          0.087155804,
          0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          1.0,
          1.0873157e-09,
         ),
         (
          -0.087155797,
          0.99619466,
          -3.1066166e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.0873158e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          0.0,
         ),
         (
          -0.34201986,
          0.9396928,
          7.7665413e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          7.7665407e-10,
         ),
         (
          -0.5,
          0.86602539,
          -6.2132322e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          6.2132333e-10,
         ),
         (
          -0.64278764,
          0.76604438,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -3.8832701e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          3.1066163e-09,
         ),
         (
          -0.86602545,
          0.50000006,
          -6.2132333e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          7.7665407e-10,
         ),
         (
          -0.93969274,
          0.34201989,
          3.2619474e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.8832701e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          1.5533083e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          6.2132333e-10,
         ),
         (
          -1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          -0.99619466,
          -0.087155797,
          -3.1066166e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.0873158e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          0.0,
         ),
         (
          -0.9396928,
          -0.34201986,
          7.7665413e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          7.7665407e-10,
         ),
         (
          -0.86602539,
          -0.5,
          -6.2132322e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          6.2132333e-10,
         ),
         (
          -0.76604438,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -3.8832701e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          3.1066163e-09,
         ),
         (
          -0.50000006,
          -0.86602545,
          -6.2132333e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          -0.34201989,
          -0.93969274,
          3.2619474e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.8832701e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          1.5533083e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          -1.0,
          1.0873157e-09,
         ),
         (
          0.087155797,
          -0.99619466,
          -3.1066166e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.0873158e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          0.0,
         ),
         (
          0.34201986,
          -0.9396928,
          7.7665413e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          0.5,
          -0.86602539,
          -6.2132322e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          6.2132333e-10,
         ),
         (
          0.64278764,
          -0.76604438,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -3.8832701e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          3.1066163e-09,
         ),
         (
          0.86602545,
          -0.50000006,
          -6.2132333e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          7.7665407e-10,
         ),
         (
          0.93969274,
          -0.34201989,
          3.2619474e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.8832701e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          1.5533083e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          6.2132333e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -1.3979774e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -2.4852931e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -3.417278e-09,
         ),
         (
          0.95371699,
          0.30070585,
          -7.7665413e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -2.0193005e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -2.1746314e-09,
         ),
         (
          0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -2.9512854e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.9512857e-09,
         ),
         (
          0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          0.53729939,
          0.84339154,
          3.1066164e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -3.4172782e-09,
         ),
         (
          0.3826834,
          0.92387956,
          4.6599247e-10,
         ),
         (
          0.30070585,
          0.95371693,
          1.8639699e-09,
         ),
         (
          0.21643975,
          0.97629595,
          1.8639699e-09,
         ),
         (
          0.13052627,
          0.99144489,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          0.99904829,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -1.3979774e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -2.4852931e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -3.417278e-09,
         ),
         (
          -0.30070585,
          0.95371699,
          -7.7665413e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -2.0193005e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -2.1746314e-09,
         ),
         (
          -0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.9512854e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.9512857e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          3.1066164e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -3.4172782e-09,
         ),
         (
          -0.92387956,
          0.3826834,
          4.6599247e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          1.8639699e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          1.8639699e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          -4.6599247e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          -4.6599247e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -1.3979774e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -2.4852931e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -3.417278e-09,
         ),
         (
          -0.95371699,
          -0.30070585,
          -7.7665413e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -2.0193005e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -2.1746314e-09,
         ),
         (
          -0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.9512854e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.9512857e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          3.1066164e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -3.4172782e-09,
         ),
         (
          -0.3826834,
          -0.92387956,
          4.6599247e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          1.8639699e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          1.8639699e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -1.3979774e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -2.4852931e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -3.417278e-09,
         ),
         (
          0.30070585,
          -0.95371699,
          -7.7665413e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -2.0193005e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -2.1746314e-09,
         ),
         (
          0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.9512854e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.9512857e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          3.1066164e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -3.4172782e-09,
         ),
         (
          0.92387956,
          -0.3826834,
          4.6599247e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          1.8639699e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          1.8639699e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          -4.6599247e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          -4.6599247e-10,
         ),
         (
          1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          0.99619466,
          0.087155804,
          4.6599247e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -3.1066166e-10,
         ),
         (
          0.96592581,
          0.25881916,
          4.6599247e-10,
         ),
         (
          0.93969274,
          0.34201986,
          1.3979773e-09,
         ),
         (
          0.9063077,
          0.42261836,
          1.5533081e-09,
         ),
         (
          0.86602545,
          0.50000006,
          3.1066166e-10,
         ),
         (
          0.81915218,
          0.57357633,
          1.3979774e-09,
         ),
         (
          0.76604438,
          0.64278764,
          -7.7665413e-10,
         ),
         (
          0.70710677,
          0.70710683,
          -3.5726087e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -7.7665413e-10,
         ),
         (
          0.57357633,
          0.81915212,
          4.038601e-09,
         ),
         (
          0.50000006,
          0.86602539,
          4.6599247e-10,
         ),
         (
          0.42261839,
          0.9063077,
          1.708639e-09,
         ),
         (
          0.34201992,
          0.93969274,
          4.0386015e-09,
         ),
         (
          0.25881913,
          0.96592581,
          4.3492627e-09,
         ),
         (
          0.17364837,
          0.98480773,
          2.3299624e-09,
         ),
         (
          0.087155797,
          0.99619466,
          1.3979774e-09,
         ),
         (
          0.0,
          1.0,
          1.8639699e-09,
         ),
         (
          -0.087155804,
          0.99619466,
          4.6599247e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -3.1066166e-10,
         ),
         (
          -0.25881916,
          0.96592581,
          4.6599247e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          1.3979773e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          1.5533081e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          3.1066166e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          1.3979774e-09,
         ),
         (
          -0.64278764,
          0.76604438,
          -7.7665413e-10,
         ),
         (
          -0.70710683,
          0.70710677,
          -3.5726087e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -7.7665413e-10,
         ),
         (
          -0.81915212,
          0.57357633,
          4.038601e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          4.6599247e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          1.708639e-09,
         ),
         (
          -0.93969274,
          0.34201992,
          4.0386015e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          4.3492627e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          2.3299624e-09,
         ),
         (
          -0.99619466,
          0.087155797,
          1.3979774e-09,
         ),
         (
          -1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          -0.99619466,
          -0.087155804,
          4.6599247e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -3.1066166e-10,
         ),
         (
          -0.96592581,
          -0.25881916,
          4.6599247e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          1.3979773e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          1.5533081e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          3.1066166e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          1.3979774e-09,
         ),
         (
          -0.76604438,
          -0.64278764,
          -7.7665413e-10,
         ),
         (
          -0.70710677,
          -0.70710683,
          -3.5726087e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -7.7665413e-10,
         ),
         (
          -0.57357633,
          -0.81915212,
          4.038601e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          4.6599247e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          1.708639e-09,
         ),
         (
          -0.34201992,
          -0.93969274,
          4.0386015e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          4.3492627e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          2.3299624e-09,
         ),
         (
          -0.087155797,
          -0.99619466,
          1.3979774e-09,
         ),
         (
          0.0,
          -1.0,
          1.8639699e-09,
         ),
         (
          0.087155804,
          -0.99619466,
          4.6599247e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -3.1066166e-10,
         ),
         (
          0.25881916,
          -0.96592581,
          4.6599247e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          1.3979773e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          1.5533081e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          3.1066166e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          1.3979774e-09,
         ),
         (
          0.64278764,
          -0.76604438,
          -7.7665413e-10,
         ),
         (
          0.70710683,
          -0.70710677,
          -3.5726087e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -7.7665413e-10,
         ),
         (
          0.81915212,
          -0.57357633,
          4.038601e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          4.6599247e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          1.708639e-09,
         ),
         (
          0.93969274,
          -0.34201992,
          4.0386015e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          4.3492627e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          2.3299624e-09,
         ),
         (
          0.99619466,
          -0.087155797,
          1.3979774e-09,
         ),
         (
          0.99904829,
          0.043619297,
          -3.7279397e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -4.6599244e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -5.5919092e-09,
         ),
         (
          0.95371693,
          0.30070588,
          -2.9512857e-09,
         ),
         (
          0.92387956,
          0.3826834,
          -4.0386015e-09,
         ),
         (
          0.88701075,
          0.46174878,
          -2.7959548e-09,
         ),
         (
          0.84339154,
          0.53729939,
          -4.1939319e-09,
         ),
         (
          0.79335344,
          0.60876137,
          -1.8639699e-09,
         ),
         (
          0.73727715,
          0.6755904,
          -5.74724e-09,
         ),
         (
          0.6755904,
          0.73727715,
          -5.74724e-09,
         ),
         (
          0.60876131,
          0.79335338,
          -1.8639699e-09,
         ),
         (
          0.53729939,
          0.84339154,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -5.2812483e-09,
         ),
         (
          0.38268337,
          0.92387956,
          -1.3979773e-09,
         ),
         (
          0.30070585,
          0.95371693,
          -3.1066166e-10,
         ),
         (
          0.21643975,
          0.97629595,
          -4.6599247e-10,
         ),
         (
          0.13052627,
          0.99144489,
          -2.7959548e-09,
         ),
         (
          0.043619297,
          0.99904829,
          -2.7959548e-09,
         ),
         (
          -0.043619297,
          0.99904817,
          -3.7279397e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -4.6599244e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -5.5919092e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          -2.9512857e-09,
         ),
         (
          -0.3826834,
          0.92387956,
          -4.0386015e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          -2.7959548e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          -4.1939319e-09,
         ),
         (
          -0.60876137,
          0.79335344,
          -1.8639699e-09,
         ),
         (
          -0.6755904,
          0.73727715,
          -5.74724e-09,
         ),
         (
          -0.73727715,
          0.6755904,
          -5.74724e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          -1.8639699e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -5.2812483e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          -1.3979773e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          -3.1066166e-10,
         ),
         (
          -0.97629595,
          0.21643975,
          -4.6599247e-10,
         ),
         (
          -0.99144489,
          0.13052627,
          -2.7959548e-09,
         ),
         (
          -0.99904829,
          0.043619297,
          -2.7959548e-09,
         ),
         (
          -0.99904817,
          -0.043619297,
          -3.7279397e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -4.6599244e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -5.5919092e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          -2.9512857e-09,
         ),
         (
          -0.92387956,
          -0.3826834,
          -4.0386015e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          -2.7959548e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          -4.1939319e-09,
         ),
         (
          -0.79335344,
          -0.60876137,
          -1.8639699e-09,
         ),
         (
          -0.73727715,
          -0.6755904,
          -5.74724e-09,
         ),
         (
          -0.6755904,
          -0.73727715,
          -5.74724e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          -1.8639699e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -5.2812483e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          -1.3979773e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          -3.1066166e-10,
         ),
         (
          -0.21643975,
          -0.97629595,
          -4.6599247e-10,
         ),
         (
          -0.13052627,
          -0.99144489,
          -2.7959548e-09,
         ),
         (
          -0.043619297,
          -0.99904829,
          -2.7959548e-09,
         ),
         (
          0.043619297,
          -0.99904817,
          -3.7279397e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -4.6599244e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -5.5919092e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          -2.9512857e-09,
         ),
         (
          0.3826834,
          -0.92387956,
          -4.0386015e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          -2.7959548e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          -4.1939319e-09,
         ),
         (
          0.60876137,
          -0.79335344,
          -1.8639699e-09,
         ),
         (
          0.6755904,
          -0.73727715,
          -5.74724e-09,
         ),
         (
          0.73727715,
          -0.6755904,
          -5.74724e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          -1.8639699e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -5.2812483e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          -1.3979773e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          -3.1066166e-10,
         ),
         (
          0.97629595,
          -0.21643975,
          -4.6599247e-10,
         ),
         (
          0.99144489,
          -0.13052627,
          -2.7959548e-09,
         ),
         (
          0.99904829,
          -0.043619297,
          -2.7959548e-09,
         ),
         (
          1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          0.99619478,
          0.087155804,
          6.2132333e-10,
         ),
         (
          0.98480773,
          0.17364839,
          0.0,
         ),
         (
          0.96592581,
          0.25881913,
          9.3198493e-10,
         ),
         (
          0.93969274,
          0.34201986,
          1.5533081e-09,
         ),
         (
          0.9063077,
          0.42261836,
          1.3979773e-09,
         ),
         (
          0.86602545,
          0.50000006,
          3.1066166e-10,
         ),
         (
          0.81915218,
          0.57357633,
          1.5533083e-09,
         ),
         (
          0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          0.70710683,
          -3.7279397e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          0.57357633,
          0.81915212,
          4.038601e-09,
         ),
         (
          0.50000006,
          0.86602539,
          3.1066164e-10,
         ),
         (
          0.42261839,
          0.9063077,
          1.5533081e-09,
         ),
         (
          0.34201986,
          0.93969274,
          4.1939319e-09,
         ),
         (
          0.25881913,
          0.96592581,
          4.8152553e-09,
         ),
         (
          0.17364839,
          0.98480773,
          2.4852933e-09,
         ),
         (
          0.087155804,
          0.99619466,
          1.5533083e-09,
         ),
         (
          0.0,
          1.0,
          1.8639699e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          6.2132333e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          0.0,
         ),
         (
          -0.25881913,
          0.96592581,
          9.3198493e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          1.5533081e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          1.3979773e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          3.1066166e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          1.5533083e-09,
         ),
         (
          -0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          0.70710683,
          -3.7279397e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          4.038601e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          3.1066164e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          1.5533081e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          4.1939319e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          4.8152553e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          2.4852933e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          1.5533083e-09,
         ),
         (
          -1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          6.2132333e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          0.0,
         ),
         (
          -0.96592581,
          -0.25881913,
          9.3198493e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          1.5533081e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          1.3979773e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          3.1066166e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          1.5533083e-09,
         ),
         (
          -0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          -0.70710683,
          -3.7279397e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          4.038601e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          3.1066164e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          1.5533081e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          4.1939319e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          4.8152553e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          2.4852933e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          1.5533083e-09,
         ),
         (
          0.0,
          -1.0,
          1.8639699e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          6.2132333e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          0.0,
         ),
         (
          0.25881913,
          -0.96592581,
          9.3198493e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          1.5533081e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          1.3979773e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          3.1066166e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          1.5533083e-09,
         ),
         (
          0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          -0.70710683,
          -3.7279397e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          4.038601e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          3.1066164e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          1.5533081e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          4.1939319e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          4.8152553e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          2.4852933e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          1.5533083e-09,
         ),
         (
          0.99904829,
          0.043619301,
          9.3198493e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.5533083e-10,
         ),
         (
          0.97629595,
          0.21643975,
          -1.0873157e-09,
         ),
         (
          0.95371693,
          0.30070585,
          1.7086391e-09,
         ),
         (
          0.92387956,
          0.38268337,
          1.5533082e-10,
         ),
         (
          0.88701075,
          0.46174878,
          1.5533083e-09,
         ),
         (
          0.84339154,
          0.53729939,
          4.6599247e-10,
         ),
         (
          0.79335344,
          0.60876131,
          2.6406239e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          0.60876131,
          0.7933535,
          2.6406242e-09,
         ),
         (
          0.53729945,
          0.84339154,
          2.9512857e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          0.38268337,
          0.92387956,
          2.7959546e-09,
         ),
         (
          0.30070585,
          0.95371699,
          4.1939323e-09,
         ),
         (
          0.21643974,
          0.97629595,
          4.038601e-09,
         ),
         (
          0.13052627,
          0.99144489,
          1.8639699e-09,
         ),
         (
          0.043619301,
          0.99904829,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          0.99904817,
          9.3198493e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.5533083e-10,
         ),
         (
          -0.21643975,
          0.97629595,
          -1.0873157e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          1.7086391e-09,
         ),
         (
          -0.38268337,
          0.92387956,
          1.5533082e-10,
         ),
         (
          -0.46174878,
          0.88701075,
          1.5533083e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          4.6599247e-10,
         ),
         (
          -0.60876131,
          0.79335344,
          2.6406239e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          2.6406242e-09,
         ),
         (
          -0.84339154,
          0.53729945,
          2.9512857e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.92387956,
          0.38268337,
          2.7959546e-09,
         ),
         (
          -0.95371699,
          0.30070585,
          4.1939323e-09,
         ),
         (
          -0.97629595,
          0.21643974,
          4.038601e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          1.8639699e-09,
         ),
         (
          -0.99904829,
          0.043619301,
          1.8639699e-09,
         ),
         (
          -0.99904817,
          -0.043619301,
          9.3198493e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.5533083e-10,
         ),
         (
          -0.97629595,
          -0.21643975,
          -1.0873157e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          1.7086391e-09,
         ),
         (
          -0.92387956,
          -0.38268337,
          1.5533082e-10,
         ),
         (
          -0.88701075,
          -0.46174878,
          1.5533083e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          4.6599247e-10,
         ),
         (
          -0.79335344,
          -0.60876131,
          2.6406239e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          2.6406242e-09,
         ),
         (
          -0.53729945,
          -0.84339154,
          2.9512857e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.38268337,
          -0.92387956,
          2.7959546e-09,
         ),
         (
          -0.30070585,
          -0.95371699,
          4.1939323e-09,
         ),
         (
          -0.21643974,
          -0.97629595,
          4.038601e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          -0.99904829,
          1.8639699e-09,
         ),
         (
          0.043619301,
          -0.99904817,
          9.3198493e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.5533083e-10,
         ),
         (
          0.21643975,
          -0.97629595,
          -1.0873157e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          1.7086391e-09,
         ),
         (
          0.38268337,
          -0.92387956,
          1.5533082e-10,
         ),
         (
          0.46174878,
          -0.88701075,
          1.5533083e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          4.6599247e-10,
         ),
         (
          0.60876131,
          -0.79335344,
          2.6406239e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          2.6406242e-09,
         ),
         (
          0.84339154,
          -0.53729945,
          2.9512857e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          0.92387956,
          -0.38268337,
          2.7959546e-09,
         ),
         (
          0.95371699,
          -0.30070585,
          4.1939323e-09,
         ),
         (
          0.97629595,
          -0.21643974,
          4.038601e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          1.8639699e-09,
         ),
         (
          0.99904829,
          -0.043619301,
          1.8639699e-09,
         ),
         (
          1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          0.99619478,
          0.087155804,
          -2.3299624e-09,
         ),
         (
          0.98480773,
          0.17364837,
          -3.1066165e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -1.8639699e-09,
         ),
         (
          0.93969274,
          0.34201986,
          -1.3979773e-09,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533081e-09,
         ),
         (
          0.86602545,
          0.50000006,
          -2.4852933e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -1.3979774e-09,
         ),
         (
          0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          0.57357633,
          0.81915212,
          1.0873157e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -2.4852933e-09,
         ),
         (
          0.42261839,
          0.9063077,
          -1.3979773e-09,
         ),
         (
          0.34201986,
          0.93969274,
          1.2426465e-09,
         ),
         (
          0.25881913,
          0.96592581,
          1.8639699e-09,
         ),
         (
          0.17364839,
          0.98480773,
          -4.6599247e-10,
         ),
         (
          0.087155804,
          0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          1.0,
          -1.2426465e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          -2.3299624e-09,
         ),
         (
          -0.17364837,
          0.98480773,
          -3.1066165e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -1.8639699e-09,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.3979773e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533081e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -1.3979774e-09,
         ),
         (
          -0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          1.0873157e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -2.4852933e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          -1.3979773e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          1.2426465e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          1.8639699e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          -4.6599247e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          -1.3979774e-09,
         ),
         (
          -1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          -2.3299624e-09,
         ),
         (
          -0.98480773,
          -0.17364837,
          -3.1066165e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -1.8639699e-09,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.3979773e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533081e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          -2.4852933e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -1.3979774e-09,
         ),
         (
          -0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          1.0873157e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -2.4852933e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          -1.3979773e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          1.2426465e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          1.8639699e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          -4.6599247e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          -1.0,
          -1.2426465e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          -2.3299624e-09,
         ),
         (
          0.17364837,
          -0.98480773,
          -3.1066165e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -1.8639699e-09,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.3979773e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533081e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -1.3979774e-09,
         ),
         (
          0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          1.0873157e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -2.4852933e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          -1.3979773e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          1.2426465e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          1.8639699e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          -4.6599247e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          -1.3979774e-09,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.82949585,
          0.036216497,
          0.5573374,
         ),
         (
          0.82318282,
          0.10837414,
          0.5573374,
         ),
         (
          0.81060517,
          0.17970698,
          0.55733699,
         ),
         (
          0.79185808,
          0.24967194,
          0.55733716,
         ),
         (
          0.76708418,
          0.31773663,
          0.55733776,
         ),
         (
          0.73647255,
          0.38338354,
          0.5573377,
         ),
         (
          0.70025635,
          0.44611236,
          0.55733728,
         ),
         (
          0.65871024,
          0.50544602,
          0.55733752,
         ),
         (
          0.61215103,
          0.56093329,
          0.5573374,
         ),
         (
          0.56093329,
          0.61215103,
          0.5573374,
         ),
         (
          0.50544602,
          0.65871024,
          0.55733752,
         ),
         (
          0.44611236,
          0.70025635,
          0.55733728,
         ),
         (
          0.38338354,
          0.73647255,
          0.5573377,
         ),
         (
          0.3177366,
          0.76708418,
          0.5573377,
         ),
         (
          0.24967194,
          0.79185808,
          0.55733716,
         ),
         (
          0.17970698,
          0.81060517,
          0.55733699,
         ),
         (
          0.10837415,
          0.82318282,
          0.5573374,
         ),
         (
          0.036216497,
          0.82949585,
          0.5573374,
         ),
         (
          -0.036216497,
          0.82949585,
          0.5573374,
         ),
         (
          -0.10837414,
          0.82318282,
          0.5573374,
         ),
         (
          -0.17970698,
          0.81060517,
          0.55733699,
         ),
         (
          -0.24967194,
          0.79185808,
          0.55733716,
         ),
         (
          -0.31773663,
          0.76708418,
          0.55733776,
         ),
         (
          -0.38338354,
          0.73647255,
          0.5573377,
         ),
         (
          -0.44611236,
          0.70025635,
          0.55733728,
         ),
         (
          -0.50544602,
          0.65871024,
          0.55733752,
         ),
         (
          -0.56093329,
          0.61215103,
          0.5573374,
         ),
         (
          -0.61215103,
          0.56093329,
          0.5573374,
         ),
         (
          -0.65871024,
          0.50544602,
          0.55733752,
         ),
         (
          -0.70025635,
          0.44611236,
          0.55733728,
         ),
         (
          -0.73647255,
          0.38338354,
          0.5573377,
         ),
         (
          -0.76708418,
          0.3177366,
          0.5573377,
         ),
         (
          -0.79185808,
          0.24967194,
          0.55733716,
         ),
         (
          -0.81060517,
          0.17970698,
          0.55733699,
         ),
         (
          -0.82318282,
          0.10837415,
          0.5573374,
         ),
         (
          -0.82949585,
          0.036216497,
          0.5573374,
         ),
         (
          -0.82949585,
          -0.036216497,
          0.5573374,
         ),
         (
          -0.82318282,
          -0.10837414,
          0.5573374,
         ),
         (
          -0.81060517,
          -0.17970698,
          0.55733699,
         ),
         (
          -0.79185808,
          -0.24967194,
          0.55733716,
         ),
         (
          -0.76708418,
          -0.31773663,
          0.55733776,
         ),
         (
          -0.73647255,
          -0.38338354,
          0.5573377,
         ),
         (
          -0.70025635,
          -0.44611236,
          0.55733728,
         ),
         (
          -0.65871024,
          -0.50544602,
          0.55733752,
         ),
         (
          -0.61215103,
          -0.56093329,
          0.5573374,
         ),
         (
          -0.56093329,
          -0.61215103,
          0.5573374,
         ),
         (
          -0.50544602,
          -0.65871024,
          0.55733752,
         ),
         (
          -0.44611236,
          -0.70025635,
          0.55733728,
         ),
         (
          -0.38338354,
          -0.73647255,
          0.5573377,
         ),
         (
          -0.3177366,
          -0.76708418,
          0.5573377,
         ),
         (
          -0.24967194,
          -0.79185808,
          0.55733716,
         ),
         (
          -0.17970698,
          -0.81060517,
          0.55733699,
         ),
         (
          -0.10837415,
          -0.82318282,
          0.5573374,
         ),
         (
          -0.036216497,
          -0.82949585,
          0.5573374,
         ),
         (
          0.036216497,
          -0.82949585,
          0.5573374,
         ),
         (
          0.10837414,
          -0.82318282,
          0.5573374,
         ),
         (
          0.17970698,
          -0.81060517,
          0.55733699,
         ),
         (
          0.24967194,
          -0.79185808,
          0.55733716,
         ),
         (
          0.31773663,
          -0.76708418,
          0.55733776,
         ),
         (
          0.38338354,
          -0.73647255,
          0.5573377,
         ),
         (
          0.44611236,
          -0.70025635,
          0.55733728,
         ),
         (
          0.50544602,
          -0.65871024,
          0.55733752,
         ),
         (
          0.56093329,
          -0.61215103,
          0.5573374,
         ),
         (
          0.61215103,
          -0.56093329,
          0.5573374,
         ),
         (
          0.65871024,
          -0.50544602,
          0.55733752,
         ),
         (
          0.70025635,
          -0.44611236,
          0.55733728,
         ),
         (
          0.73647255,
          -0.38338354,
          0.5573377,
         ),
         (
          0.76708418,
          -0.3177366,
          0.5573377,
         ),
         (
          0.79185808,
          -0.24967194,
          0.55733716,
         ),
         (
          0.81060517,
          -0.17970698,
          0.55733699,
         ),
         (
          0.82318282,
          -0.10837415,
          0.5573374,
         ),
         (
          0.82949585,
          -0.036216497,
          0.5573374,
         ),
         (
          0.0,
          0.0,
          -1.0,
         ),
         (
          0.0,
          0.0,
          1.0,
         ),
        ],
       'per_vertex_colors': None,
       'smoothLines': False,
       'transparencyBlendMode': 1,
       'triangle_and_edge_mask': None,
       'triangles': [
         ( 0, 1, 72, ),
         ( 1, 73, 72, ),
         ( 1, 2, 73, ),
         ( 2, 74, 73, ),
         ( 2, 3, 74, ),
         ( 3, 75, 74, ),
         ( 3, 4, 75, ),
         ( 4, 76, 75, ),
         ( 4, 5, 76, ),
         ( 5, 77, 76, ),
         ( 5, 6, 77, ),
         ( 6, 78, 77, ),
         ( 6, 7, 78, ),
         ( 7, 79, 78, ),
         ( 7, 8, 79, ),
         ( 8, 80, 79, ),
         ( 8, 9, 80, ),
         ( 9, 81, 80, ),
         ( 9, 10, 81, ),
         ( 10, 82, 81, ),
         ( 10, 11, 82, ),
         ( 11, 83, 82, ),
         ( 11, 12, 83, ),
         ( 12, 84, 83, ),
         ( 12, 13, 84, ),
         ( 13, 85, 84, ),
         ( 13, 14, 85, ),
         ( 14, 86, 85, ),
         ( 14, 15, 86, ),
         ( 15, 87, 86, ),
         ( 15, 16, 87, ),
         ( 16, 88, 87, ),
         ( 16, 17, 88, ),
         ( 17, 89, 88, ),
         ( 17, 18, 89, ),
         ( 18, 90, 89, ),
         ( 18, 19, 90, ),
         ( 19, 91, 90, ),
         ( 19, 20, 91, ),
         ( 20, 92, 91, ),
         ( 20, 21, 92, ),
         ( 21, 93, 92, ),
         ( 21, 22, 93, ),
         ( 22, 94, 93, ),
         ( 22, 23, 94, ),
         ( 23, 95, 94, ),
         ( 23, 24, 95, ),
         ( 24, 96, 95, ),
         ( 24, 25, 96, ),
         ( 25, 97, 96, ),
         ( 25, 26, 97, ),
         ( 26, 98, 97, ),
         ( 26, 27, 98, ),
         ( 27, 99, 98, ),
         ( 27, 28, 99, ),
         ( 28, 100, 99, ),
         ( 28, 29, 100, ),
         ( 29, 101, 100, ),
         ( 29, 30, 101, ),
         ( 30, 102, 101, ),
         ( 30, 31, 102, ),
         ( 31, 103, 102, ),
         ( 31, 32, 103, ),
         ( 32, 104, 103, ),
         ( 32, 33, 104, ),
         ( 33, 105, 104, ),
         ( 33, 34, 105, ),
         ( 34, 106, 105, ),
         ( 34, 35, 106, ),
         ( 35, 107, 106, ),
         ( 35, 36, 107, ),
         ( 36, 108, 107, ),
         ( 36, 37, 108, ),
         ( 37, 109, 108, ),
         ( 37, 38, 109, ),
         ( 38, 110, 109, ),
         ( 38, 39, 110, ),
         ( 39, 111, 110, ),
         ( 39, 40, 111, ),
         ( 40, 112, 111, ),
         ( 40, 41, 112, ),
         ( 41, 113, 112, ),
         ( 41, 42, 113, ),
         ( 42, 114, 113, ),
         ( 42, 43, 114, ),
         ( 43, 115, 114, ),
         ( 43, 44, 115, ),
         ( 44, 116, 115, ),
         ( 44, 45, 116, ),
         ( 45, 117, 116, ),
         ( 45, 46, 117, ),
         ( 46, 118, 117, ),
         ( 46, 47, 118, ),
         ( 47, 119, 118, ),
         ( 47, 48, 119, ),
         ( 48, 120, 119, ),
         ( 48, 49, 120, ),
         ( 49, 121, 120, ),
         ( 49, 50, 121, ),
         ( 50, 122, 121, ),
         ( 50, 51, 122, ),
         ( 51, 123, 122, ),
         ( 51, 52, 123, ),
         ( 52, 124, 123, ),
         ( 52, 53, 124, ),
         ( 53, 125, 124, ),
         ( 53, 54, 125, ),
         ( 54, 126, 125, ),
         ( 54, 55, 126, ),
         ( 55, 127, 126, ),
         ( 55, 56, 127, ),
         ( 56, 128, 127, ),
         ( 56, 57, 128, ),
         ( 57, 129, 128, ),
         ( 57, 58, 129, ),
         ( 58, 130, 129, ),
         ( 58, 59, 130, ),
         ( 59, 131, 130, ),
         ( 59, 60, 131, ),
         ( 60, 132, 131, ),
         ( 60, 61, 132, ),
         ( 61, 133, 132, ),
         ( 61, 62, 133, ),
         ( 62, 134, 133, ),
         ( 62, 63, 134, ),
         ( 63, 135, 134, ),
         ( 63, 64, 135, ),
         ( 64, 136, 135, ),
         ( 64, 65, 136, ),
         ( 65, 137, 136, ),
         ( 65, 66, 137, ),
         ( 66, 138, 137, ),
         ( 66, 67, 138, ),
         ( 67, 139, 138, ),
         ( 67, 68, 139, ),
         ( 68, 140, 139, ),
         ( 68, 69, 140, ),
         ( 69, 141, 140, ),
         ( 69, 70, 141, ),
         ( 70, 142, 141, ),
         ( 70, 71, 142, ),
         ( 71, 143, 142, ),
         ( 71, 0, 143, ),
         ( 0, 72, 143, ),
         ( 72, 73, 145, ),
         ( 72, 145, 144, ),
         ( 73, 74, 146, ),
         ( 73, 146, 145, ),
         ( 74, 75, 147, ),
         ( 74, 147, 146, ),
         ( 75, 76, 148, ),
         ( 75, 148, 147, ),
         ( 76, 77, 149, ),
         ( 76, 149, 148, ),
         ( 77, 78, 150, ),
         ( 77, 150, 149, ),
         ( 78, 79, 151, ),
         ( 78, 151, 150, ),
         ( 79, 80, 152, ),
         ( 79, 152, 151, ),
         ( 80, 81, 153, ),
         ( 80, 153, 152, ),
         ( 81, 82, 154, ),
         ( 81, 154, 153, ),
         ( 82, 83, 155, ),
         ( 82, 155, 154, ),
         ( 83, 84, 156, ),
         ( 83, 156, 155, ),
         ( 84, 85, 157, ),
         ( 84, 157, 156, ),
         ( 85, 86, 158, ),
         ( 85, 158, 157, ),
         ( 86, 87, 159, ),
         ( 86, 159, 158, ),
         ( 87, 88, 160, ),
         ( 87, 160, 159, ),
         ( 88, 89, 161, ),
         ( 88, 161, 160, ),
         ( 89, 90, 162, ),
         ( 89, 162, 161, ),
         ( 90, 91, 163, ),
         ( 90, 163, 162, ),
         ( 91, 92, 164, ),
         ( 91, 164, 163, ),
         ( 92, 93, 165, ),
         ( 92, 165, 164, ),
         ( 93, 94, 166, ),
         ( 93, 166, 165, ),
         ( 94, 95, 167, ),
         ( 94, 167, 166, ),
         ( 95, 96, 168, ),
         ( 95, 168, 167, ),
         ( 96, 97, 169, ),
         ( 96, 169, 168, ),
         ( 97, 98, 170, ),
         ( 97, 170, 169, ),
         ( 98, 99, 171, ),
         ( 98, 171, 170, ),
         ( 99, 100, 172, ),
         ( 99, 172, 171, ),
         ( 100, 101, 173, ),
         ( 100, 173, 172, ),
         ( 101, 102, 174, ),
         ( 101, 174, 173, ),
         ( 102, 103, 175, ),
         ( 102, 175, 174, ),
         ( 103, 104, 176, ),
         ( 103, 176, 175, ),
         ( 104, 105, 177, ),
         ( 104, 177, 176, ),
         ( 105, 106, 178, ),
         ( 105, 178, 177, ),
         ( 106, 107, 179, ),
         ( 106, 179, 178, ),
         ( 107, 108, 180, ),
         ( 107, 180, 179, ),
         ( 108, 109, 181, ),
         ( 108, 181, 180, ),
         ( 109, 110, 182, ),
         ( 109, 182, 181, ),
         ( 110, 111, 183, ),
         ( 110, 183, 182, ),
         ( 111, 112, 184, ),
         ( 111, 184, 183, ),
         ( 112, 113, 185, ),
         ( 112, 185, 184, ),
         ( 113, 114, 186, ),
         ( 113, 186, 185, ),
         ( 114, 115, 187, ),
         ( 114, 187, 186, ),
         ( 115, 116, 188, ),
         ( 115, 188, 187, ),
         ( 116, 117, 189, ),
         ( 116, 189, 188, ),
         ( 117, 118, 190, ),
         ( 117, 190, 189, ),
         ( 118, 119, 191, ),
         ( 118, 191, 190, ),
         ( 119, 120, 192, ),
         ( 119, 192, 191, ),
         ( 120, 121, 193, ),
         ( 120, 193, 192, ),
         ( 121, 122, 194, ),
         ( 121, 194, 193, ),
         ( 122, 123, 195, ),
         ( 122, 195, 194, ),
         ( 123, 124, 196, ),
         ( 123, 196, 195, ),
         ( 124, 125, 197, ),
         ( 124, 197, 196, ),
         ( 125, 126, 198, ),
         ( 125, 198, 197, ),
         ( 126, 127, 199, ),
         ( 126, 199, 198, ),
         ( 127, 128, 200, ),
         ( 127, 200, 199, ),
         ( 128, 129, 201, ),
         ( 128, 201, 200, ),
         ( 129, 130, 202, ),
         ( 129, 202, 201, ),
         ( 130, 131, 203, ),
         ( 130, 203, 202, ),
         ( 131, 132, 204, ),
         ( 131, 204, 203, ),
         ( 132, 133, 205, ),
         ( 132, 205, 204, ),
         ( 133, 134, 206, ),
         ( 133, 206, 205, ),
         ( 134, 135, 207, ),
         ( 134, 207, 206, ),
         ( 135, 136, 208, ),
         ( 135, 208, 207, ),
         ( 136, 137, 209, ),
         ( 136, 209, 208, ),
         ( 137, 138, 210, ),
         ( 137, 210, 209, ),
         ( 138, 139, 211, ),
         ( 138, 211, 210, ),
         ( 139, 140, 212, ),
         ( 139, 212, 211, ),
         ( 140, 141, 213, ),
         ( 140, 213, 212, ),
         ( 141, 142, 214, ),
         ( 141, 214, 213, ),
         ( 142, 143, 215, ),
         ( 142, 215, 214, ),
         ( 143, 72, 144, ),
         ( 143, 144, 215, ),
         ( 144, 145, 216, ),
         ( 145, 217, 216, ),
         ( 145, 146, 217, ),
         ( 146, 218, 217, ),
         ( 146, 147, 218, ),
         ( 147, 219, 218, ),
         ( 147, 148, 219, ),
         ( 148, 220, 219, ),
         ( 148, 149, 220, ),
         ( 149, 221, 220, ),
         ( 149, 150, 221, ),
         ( 150, 222, 221, ),
         ( 150, 151, 222, ),
         ( 151, 223, 222, ),
         ( 151, 152, 223, ),
         ( 152, 224, 223, ),
         ( 152, 153, 224, ),
         ( 153, 225, 224, ),
         ( 153, 154, 225, ),
         ( 154, 226, 225, ),
         ( 154, 155, 226, ),
         ( 155, 227, 226, ),
         ( 155, 156, 227, ),
         ( 156, 228, 227, ),
         ( 156, 157, 228, ),
         ( 157, 229, 228, ),
         ( 157, 158, 229, ),
         ( 158, 230, 229, ),
         ( 158, 159, 230, ),
         ( 159, 231, 230, ),
         ( 159, 160, 231, ),
         ( 160, 232, 231, ),
         ( 160, 161, 232, ),
         ( 161, 233, 232, ),
         ( 161, 162, 233, ),
         ( 162, 234, 233, ),
         ( 162, 163, 234, ),
         ( 163, 235, 234, ),
         ( 163, 164, 235, ),
         ( 164, 236, 235, ),
         ( 164, 165, 236, ),
         ( 165, 237, 236, ),
         ( 165, 166, 237, ),
         ( 166, 238, 237, ),
         ( 166, 167, 238, ),
         ( 167, 239, 238, ),
         ( 167, 168, 239, ),
         ( 168, 240, 239, ),
         ( 168, 169, 240, ),
         ( 169, 241, 240, ),
         ( 169, 170, 241, ),
         ( 170, 242, 241, ),
         ( 170, 171, 242, ),
         ( 171, 243, 242, ),
         ( 171, 172, 243, ),
         ( 172, 244, 243, ),
         ( 172, 173, 244, ),
         ( 173, 245, 244, ),
         ( 173, 174, 245, ),
         ( 174, 246, 245, ),
         ( 174, 175, 246, ),
         ( 175, 247, 246, ),
         ( 175, 176, 247, ),
         ( 176, 248, 247, ),
         ( 176, 177, 248, ),
         ( 177, 249, 248, ),
         ( 177, 178, 249, ),
         ( 178, 250, 249, ),
         ( 178, 179, 250, ),
         ( 179, 251, 250, ),
         ( 179, 180, 251, ),
         ( 180, 252, 251, ),
         ( 180, 181, 252, ),
         ( 181, 253, 252, ),
         ( 181, 182, 253, ),
         ( 182, 254, 253, ),
         ( 182, 183, 254, ),
         ( 183, 255, 254, ),
         ( 183, 184, 255, ),
         ( 184, 256, 255, ),
         ( 184, 185, 256, ),
         ( 185, 257, 256, ),
         ( 185, 186, 257, ),
         ( 186, 258, 257, ),
         ( 186, 187, 258, ),
         ( 187, 259, 258, ),
         ( 187, 188, 259, ),
         ( 188, 260, 259, ),
         ( 188, 189, 260, ),
         ( 189, 261, 260, ),
         ( 189, 190, 261, ),
         ( 190, 262, 261, ),
         ( 190, 191, 262, ),
         ( 191, 263, 262, ),
         ( 191, 192, 263, ),
         ( 192, 264, 263, ),
         ( 192, 193, 264, ),
         ( 193, 265, 264, ),
         ( 193, 194, 265, ),
         ( 194, 266, 265, ),
         ( 194, 195, 266, ),
         ( 195, 267, 266, ),
         ( 195, 196, 267, ),
         ( 196, 268, 267, ),
         ( 196, 197, 268, ),
         ( 197, 269, 268, ),
         ( 197, 198, 269, ),
         ( 198, 270, 269, ),
         ( 198, 199, 270, ),
         ( 199, 271, 270, ),
         ( 199, 200, 271, ),
         ( 200, 272, 271, ),
         ( 200, 201, 272, ),
         ( 201, 273, 272, ),
         ( 201, 202, 273, ),
         ( 202, 274, 273, ),
         ( 202, 203, 274, ),
         ( 203, 275, 274, ),
         ( 203, 204, 275, ),
         ( 204, 276, 275, ),
         ( 204, 205, 276, ),
         ( 205, 277, 276, ),
         ( 205, 206, 277, ),
         ( 206, 278, 277, ),
         ( 206, 207, 278, ),
         ( 207, 279, 278, ),
         ( 207, 208, 279, ),
         ( 208, 280, 279, ),
         ( 208, 209, 280, ),
         ( 209, 281, 280, ),
         ( 209, 210, 281, ),
         ( 210, 282, 281, ),
         ( 210, 211, 282, ),
         ( 211, 283, 282, ),
         ( 211, 212, 283, ),
         ( 212, 284, 283, ),
         ( 212, 213, 284, ),
         ( 213, 285, 284, ),
         ( 213, 214, 285, ),
         ( 214, 286, 285, ),
         ( 214, 215, 286, ),
         ( 215, 287, 286, ),
         ( 215, 144, 287, ),
         ( 144, 216, 287, ),
         ( 216, 217, 289, ),
         ( 216, 289, 288, ),
         ( 217, 218, 290, ),
         ( 217, 290, 289, ),
         ( 218, 219, 291, ),
         ( 218, 291, 290, ),
         ( 219, 220, 292, ),
         ( 219, 292, 291, ),
         ( 220, 221, 293, ),
         ( 220, 293, 292, ),
         ( 221, 222, 294, ),
         ( 221, 294, 293, ),
         ( 222, 223, 295, ),
         ( 222, 295, 294, ),
         ( 223, 224, 296, ),
         ( 223, 296, 295, ),
         ( 224, 225, 297, ),
         ( 224, 297, 296, ),
         ( 225, 226, 298, ),
         ( 225, 298, 297, ),
         ( 226, 227, 299, ),
         ( 226, 299, 298, ),
         ( 227, 228, 300, ),
         ( 227, 300, 299, ),
         ( 228, 229, 301, ),
         ( 228, 301, 300, ),
         ( 229, 230, 302, ),
         ( 229, 302, 301, ),
         ( 230, 231, 303, ),
         ( 230, 303, 302, ),
         ( 231, 232, 304, ),
         ( 231, 304, 303, ),
         ( 232, 233, 305, ),
         ( 232, 305, 304, ),
         ( 233, 234, 306, ),
         ( 233, 306, 305, ),
         ( 234, 235, 307, ),
         ( 234, 307, 306, ),
         ( 235, 236, 308, ),
         ( 235, 308, 307, ),
         ( 236, 237, 309, ),
         ( 236, 309, 308, ),
         ( 237, 238, 310, ),
         ( 237, 310, 309, ),
         ( 238, 239, 311, ),
         ( 238, 311, 310, ),
         ( 239, 240, 312, ),
         ( 239, 312, 311, ),
         ( 240, 241, 313, ),
         ( 240, 313, 312, ),
         ( 241, 242, 314, ),
         ( 241, 314, 313, ),
         ( 242, 243, 315, ),
         ( 242, 315, 314, ),
         ( 243, 244, 316, ),
         ( 243, 316, 315, ),
         ( 244, 245, 317, ),
         ( 244, 317, 316, ),
         ( 245, 246, 318, ),
         ( 245, 318, 317, ),
         ( 246, 247, 319, ),
         ( 246, 319, 318, ),
         ( 247, 248, 320, ),
         ( 247, 320, 319, ),
         ( 248, 249, 321, ),
         ( 248, 321, 320, ),
         ( 249, 250, 322, ),
         ( 249, 322, 321, ),
         ( 250, 251, 323, ),
         ( 250, 323, 322, ),
         ( 251, 252, 324, ),
         ( 251, 324, 323, ),
         ( 252, 253, 325, ),
         ( 252, 325, 324, ),
         ( 253, 254, 326, ),
         ( 253, 326, 325, ),
         ( 254, 255, 327, ),
         ( 254, 327, 326, ),
         ( 255, 256, 328, ),
         ( 255, 328, 327, ),
         ( 256, 257, 329, ),
         ( 256, 329, 328, ),
         ( 257, 258, 330, ),
         ( 257, 330, 329, ),
         ( 258, 259, 331, ),
         ( 258, 331, 330, ),
         ( 259, 260, 332, ),
         ( 259, 332, 331, ),
         ( 260, 261, 333, ),
         ( 260, 333, 332, ),
         ( 261, 262, 334, ),
         ( 261, 334, 333, ),
         ( 262, 263, 335, ),
         ( 262, 335, 334, ),
         ( 263, 264, 336, ),
         ( 263, 336, 335, ),
         ( 264, 265, 337, ),
         ( 264, 337, 336, ),
         ( 265, 266, 338, ),
         ( 265, 338, 337, ),
         ( 266, 267, 339, ),
         ( 266, 339, 338, ),
         ( 267, 268, 340, ),
         ( 267, 340, 339, ),
         ( 268, 269, 341, ),
         ( 268, 341, 340, ),
         ( 269, 270, 342, ),
         ( 269, 342, 341, ),
         ( 270, 271, 343, ),
         ( 270, 343, 342, ),
         ( 271, 272, 344, ),
         ( 271, 344, 343, ),
         ( 272, 273, 345, ),
         ( 272, 345, 344, ),
         ( 273, 274, 346, ),
         ( 273, 346, 345, ),
         ( 274, 275, 347, ),
         ( 274, 347, 346, ),
         ( 275, 276, 348, ),
         ( 275, 348, 347, ),
         ( 276, 277, 349, ),
         ( 276, 349, 348, ),
         ( 277, 278, 350, ),
         ( 277, 350, 349, ),
         ( 278, 279, 351, ),
         ( 278, 351, 350, ),
         ( 279, 280, 352, ),
         ( 279, 352, 351, ),
         ( 280, 281, 353, ),
         ( 280, 353, 352, ),
         ( 281, 282, 354, ),
         ( 281, 354, 353, ),
         ( 282, 283, 355, ),
         ( 282, 355, 354, ),
         ( 283, 284, 356, ),
         ( 283, 356, 355, ),
         ( 284, 285, 357, ),
         ( 284, 357, 356, ),
         ( 285, 286, 358, ),
         ( 285, 358, 357, ),
         ( 286, 287, 359, ),
         ( 286, 359, 358, ),
         ( 287, 216, 288, ),
         ( 287, 288, 359, ),
         ( 288, 289, 360, ),
         ( 289, 361, 360, ),
         ( 289, 290, 361, ),
         ( 290, 362, 361, ),
         ( 290, 291, 362, ),
         ( 291, 363, 362, ),
         ( 291, 292, 363, ),
         ( 292, 364, 363, ),
         ( 292, 293, 364, ),
         ( 293, 365, 364, ),
         ( 293, 294, 365, ),
         ( 294, 366, 365, ),
         ( 294, 295, 366, ),
         ( 295, 367, 366, ),
         ( 295, 296, 367, ),
         ( 296, 368, 367, ),
         ( 296, 297, 368, ),
         ( 297, 369, 368, ),
         ( 297, 298, 369, ),
         ( 298, 370, 369, ),
         ( 298, 299, 370, ),
         ( 299, 371, 370, ),
         ( 299, 300, 371, ),
         ( 300, 372, 371, ),
         ( 300, 301, 372, ),
         ( 301, 373, 372, ),
         ( 301, 302, 373, ),
         ( 302, 374, 373, ),
         ( 302, 303, 374, ),
         ( 303, 375, 374, ),
         ( 303, 304, 375, ),
         ( 304, 376, 375, ),
         ( 304, 305, 376, ),
         ( 305, 377, 376, ),
         ( 305, 306, 377, ),
         ( 306, 378, 377, ),
         ( 306, 307, 378, ),
         ( 307, 379, 378, ),
         ( 307, 308, 379, ),
         ( 308, 380, 379, ),
         ( 308, 309, 380, ),
         ( 309, 381, 380, ),
         ( 309, 310, 381, ),
         ( 310, 382, 381, ),
         ( 310, 311, 382, ),
         ( 311, 383, 382, ),
         ( 311, 312, 383, ),
         ( 312, 384, 383, ),
         ( 312, 313, 384, ),
         ( 313, 385, 384, ),
         ( 313, 314, 385, ),
         ( 314, 386, 385, ),
         ( 314, 315, 386, ),
         ( 315, 387, 386, ),
         ( 315, 316, 387, ),
         ( 316, 388, 387, ),
         ( 316, 317, 388, ),
         ( 317, 389, 388, ),
         ( 317, 318, 389, ),
         ( 318, 390, 389, ),
         ( 318, 319, 390, ),
         ( 319, 391, 390, ),
         ( 319, 320, 391, ),
         ( 320, 392, 391, ),
         ( 320, 321, 392, ),
         ( 321, 393, 392, ),
         ( 321, 322, 393, ),
         ( 322, 394, 393, ),
         ( 322, 323, 394, ),
         ( 323, 395, 394, ),
         ( 323, 324, 395, ),
         ( 324, 396, 395, ),
         ( 324, 325, 396, ),
         ( 325, 397, 396, ),
         ( 325, 326, 397, ),
         ( 326, 398, 397, ),
         ( 326, 327, 398, ),
         ( 327, 399, 398, ),
         ( 327, 328, 399, ),
         ( 328, 400, 399, ),
         ( 328, 329, 400, ),
         ( 329, 401, 400, ),
         ( 329, 330, 401, ),
         ( 330, 402, 401, ),
         ( 330, 331, 402, ),
         ( 331, 403, 402, ),
         ( 331, 332, 403, ),
         ( 332, 404, 403, ),
         ( 332, 333, 404, ),
         ( 333, 405, 404, ),
         ( 333, 334, 405, ),
         ( 334, 406, 405, ),
         ( 334, 335, 406, ),
         ( 335, 407, 406, ),
         ( 335, 336, 407, ),
         ( 336, 408, 407, ),
         ( 336, 337, 408, ),
         ( 337, 409, 408, ),
         ( 337, 338, 409, ),
         ( 338, 410, 409, ),
         ( 338, 339, 410, ),
         ( 339, 411, 410, ),
         ( 339, 340, 411, ),
         ( 340, 412, 411, ),
         ( 340, 341, 412, ),
         ( 341, 413, 412, ),
         ( 341, 342, 413, ),
         ( 342, 414, 413, ),
         ( 342, 343, 414, ),
         ( 343, 415, 414, ),
         ( 343, 344, 415, ),
         ( 344, 416, 415, ),
         ( 344, 345, 416, ),
         ( 345, 417, 416, ),
         ( 345, 346, 417, ),
         ( 346, 418, 417, ),
         ( 346, 347, 418, ),
         ( 347, 419, 418, ),
         ( 347, 348, 419, ),
         ( 348, 420, 419, ),
         ( 348, 349, 420, ),
         ( 349, 421, 420, ),
         ( 349, 350, 421, ),
         ( 350, 422, 421, ),
         ( 350, 351, 422, ),
         ( 351, 423, 422, ),
         ( 351, 352, 423, ),
         ( 352, 424, 423, ),
         ( 352, 353, 424, ),
         ( 353, 425, 424, ),
         ( 353, 354, 425, ),
         ( 354, 426, 425, ),
         ( 354, 355, 426, ),
         ( 355, 427, 426, ),
         ( 355, 356, 427, ),
         ( 356, 428, 427, ),
         ( 356, 357, 428, ),
         ( 357, 429, 428, ),
         ( 357, 358, 429, ),
         ( 358, 430, 429, ),
         ( 358, 359, 430, ),
         ( 359, 431, 430, ),
         ( 359, 288, 431, ),
         ( 288, 360, 431, ),
         ( 360, 361, 433, ),
         ( 360, 433, 432, ),
         ( 361, 362, 434, ),
         ( 361, 434, 433, ),
         ( 362, 363, 435, ),
         ( 362, 435, 434, ),
         ( 363, 364, 436, ),
         ( 363, 436, 435, ),
         ( 364, 365, 437, ),
         ( 364, 437, 436, ),
         ( 365, 366, 438, ),
         ( 365, 438, 437, ),
         ( 366, 367, 439, ),
         ( 366, 439, 438, ),
         ( 367, 368, 440, ),
         ( 367, 440, 439, ),
         ( 368, 369, 441, ),
         ( 368, 441, 440, ),
         ( 369, 370, 442, ),
         ( 369, 442, 441, ),
         ( 370, 371, 443, ),
         ( 370, 443, 442, ),
         ( 371, 372, 444, ),
         ( 371, 444, 443, ),
         ( 372, 373, 445, ),
         ( 372, 445, 444, ),
         ( 373, 374, 446, ),
         ( 373, 446, 445, ),
         ( 374, 375, 447, ),
         ( 374, 447, 446, ),
         ( 375, 376, 448, ),
         ( 375, 448, 447, ),
         ( 376, 377, 449, ),
         ( 376, 449, 448, ),
         ( 377, 378, 450, ),
         ( 377, 450, 449, ),
         ( 378, 379, 451, ),
         ( 378, 451, 450, ),
         ( 379, 380, 452, ),
         ( 379, 452, 451, ),
         ( 380, 381, 453, ),
         ( 380, 453, 452, ),
         ( 381, 382, 454, ),
         ( 381, 454, 453, ),
         ( 382, 383, 455, ),
         ( 382, 455, 454, ),
         ( 383, 384, 456, ),
         ( 383, 456, 455, ),
         ( 384, 385, 457, ),
         ( 384, 457, 456, ),
         ( 385, 386, 458, ),
         ( 385, 458, 457, ),
         ( 386, 387, 459, ),
         ( 386, 459, 458, ),
         ( 387, 388, 460, ),
         ( 387, 460, 459, ),
         ( 388, 389, 461, ),
         ( 388, 461, 460, ),
         ( 389, 390, 462, ),
         ( 389, 462, 461, ),
         ( 390, 391, 463, ),
         ( 390, 463, 462, ),
         ( 391, 392, 464, ),
         ( 391, 464, 463, ),
         ( 392, 393, 465, ),
         ( 392, 465, 464, ),
         ( 393, 394, 466, ),
         ( 393, 466, 465, ),
         ( 394, 395, 467, ),
         ( 394, 467, 466, ),
         ( 395, 396, 468, ),
         ( 395, 468, 467, ),
         ( 396, 397, 469, ),
         ( 396, 469, 468, ),
         ( 397, 398, 470, ),
         ( 397, 470, 469, ),
         ( 398, 399, 471, ),
         ( 398, 471, 470, ),
         ( 399, 400, 472, ),
         ( 399, 472, 471, ),
         ( 400, 401, 473, ),
         ( 400, 473, 472, ),
         ( 401, 402, 474, ),
         ( 401, 474, 473, ),
         ( 402, 403, 475, ),
         ( 402, 475, 474, ),
         ( 403, 404, 476, ),
         ( 403, 476, 475, ),
         ( 404, 405, 477, ),
         ( 404, 477, 476, ),
         ( 405, 406, 478, ),
         ( 405, 478, 477, ),
         ( 406, 407, 479, ),
         ( 406, 479, 478, ),
         ( 407, 408, 480, ),
         ( 407, 480, 479, ),
         ( 408, 409, 481, ),
         ( 408, 481, 480, ),
         ( 409, 410, 482, ),
         ( 409, 482, 481, ),
         ( 410, 411, 483, ),
         ( 410, 483, 482, ),
         ( 411, 412, 484, ),
         ( 411, 484, 483, ),
         ( 412, 413, 485, ),
         ( 412, 485, 484, ),
         ( 413, 414, 486, ),
         ( 413, 486, 485, ),
         ( 414, 415, 487, ),
         ( 414, 487, 486, ),
         ( 415, 416, 488, ),
         ( 415, 488, 487, ),
         ( 416, 417, 489, ),
         ( 416, 489, 488, ),
         ( 417, 418, 490, ),
         ( 417, 490, 489, ),
         ( 418, 419, 491, ),
         ( 418, 491, 490, ),
         ( 419, 420, 492, ),
         ( 419, 492, 491, ),
         ( 420, 421, 493, ),
         ( 420, 493, 492, ),
         ( 421, 422, 494, ),
         ( 421, 494, 493, ),
         ( 422, 423, 495, ),
         ( 422, 495, 494, ),
         ( 423, 424, 496, ),
         ( 423, 496, 495, ),
         ( 424, 425, 497, ),
         ( 424, 497, 496, ),
         ( 425, 426, 498, ),
         ( 425, 498, 497, ),
         ( 426, 427, 499, ),
         ( 426, 499, 498, ),
         ( 427, 428, 500, ),
         ( 427, 500, 499, ),
         ( 428, 429, 501, ),
         ( 428, 501, 500, ),
         ( 429, 430, 502, ),
         ( 429, 502, 501, ),
         ( 430, 431, 503, ),
         ( 430, 503, 502, ),
         ( 431, 360, 432, ),
         ( 431, 432, 503, ),
         ( 432, 433, 504, ),
         ( 433, 505, 504, ),
         ( 433, 434, 505, ),
         ( 434, 506, 505, ),
         ( 434, 435, 506, ),
         ( 435, 507, 506, ),
         ( 435, 436, 507, ),
         ( 436, 508, 507, ),
         ( 436, 437, 508, ),
         ( 437, 509, 508, ),
         ( 437, 438, 509, ),
         ( 438, 510, 509, ),
         ( 438, 439, 510, ),
         ( 439, 511, 510, ),
         ( 439, 440, 511, ),
         ( 440, 512, 511, ),
         ( 440, 441, 512, ),
         ( 441, 513, 512, ),
         ( 441, 442, 513, ),
         ( 442, 514, 513, ),
         ( 442, 443, 514, ),
         ( 443, 515, 514, ),
         ( 443, 444, 515, ),
         ( 444, 516, 515, ),
         ( 444, 445, 516, ),
         ( 445, 517, 516, ),
         ( 445, 446, 517, ),
         ( 446, 518, 517, ),
         ( 446, 447, 518, ),
         ( 447, 519, 518, ),
         ( 447, 448, 519, ),
         ( 448, 520, 519, ),
         ( 448, 449, 520, ),
         ( 449, 521, 520, ),
         ( 449, 450, 521, ),
         ( 450, 522, 521, ),
         ( 450, 451, 522, ),
         ( 451, 523, 522, ),
         ( 451, 452, 523, ),
         ( 452, 524, 523, ),
         ( 452, 453, 524, ),
         ( 453, 525, 524, ),
         ( 453, 454, 525, ),
         ( 454, 526, 525, ),
         ( 454, 455, 526, ),
         ( 455, 527, 526, ),
         ( 455, 456, 527, ),
         ( 456, 528, 527, ),
         ( 456, 457, 528, ),
         ( 457, 529, 528, ),
         ( 457, 458, 529, ),
         ( 458, 530, 529, ),
         ( 458, 459, 530, ),
         ( 459, 531, 530, ),
         ( 459, 460, 531, ),
         ( 460, 532, 531, ),
         ( 460, 461, 532, ),
         ( 461, 533, 532, ),
         ( 461, 462, 533, ),
         ( 462, 534, 533, ),
         ( 462, 463, 534, ),
         ( 463, 535, 534, ),
         ( 463, 464, 535, ),
         ( 464, 536, 535, ),
         ( 464, 465, 536, ),
         ( 465, 537, 536, ),
         ( 465, 466, 537, ),
         ( 466, 538, 537, ),
         ( 466, 467, 538, ),
         ( 467, 539, 538, ),
         ( 467, 468, 539, ),
         ( 468, 540, 539, ),
         ( 468, 469, 540, ),
         ( 469, 541, 540, ),
         ( 469, 470, 541, ),
         ( 470, 542, 541, ),
         ( 470, 471, 542, ),
         ( 471, 543, 542, ),
         ( 471, 472, 543, ),
         ( 472, 544, 543, ),
         ( 472, 473, 544, ),
         ( 473, 545, 544, ),
         ( 473, 474, 545, ),
         ( 474, 546, 545, ),
         ( 474, 475, 546, ),
         ( 475, 547, 546, ),
         ( 475, 476, 547, ),
         ( 476, 548, 547, ),
         ( 476, 477, 548, ),
         ( 477, 549, 548, ),
         ( 477, 478, 549, ),
         ( 478, 550, 549, ),
         ( 478, 479, 550, ),
         ( 479, 551, 550, ),
         ( 479, 480, 551, ),
         ( 480, 552, 551, ),
         ( 480, 481, 552, ),
         ( 481, 553, 552, ),
         ( 481, 482, 553, ),
         ( 482, 554, 553, ),
         ( 482, 483, 554, ),
         ( 483, 555, 554, ),
         ( 483, 484, 555, ),
         ( 484, 556, 555, ),
         ( 484, 485, 556, ),
         ( 485, 557, 556, ),
         ( 485, 486, 557, ),
         ( 486, 558, 557, ),
         ( 486, 487, 558, ),
         ( 487, 559, 558, ),
         ( 487, 488, 559, ),
         ( 488, 560, 559, ),
         ( 488, 489, 560, ),
         ( 489, 561, 560, ),
         ( 489, 490, 561, ),
         ( 490, 562, 561, ),
         ( 490, 491, 562, ),
         ( 491, 563, 562, ),
         ( 491, 492, 563, ),
         ( 492, 564, 563, ),
         ( 492, 493, 564, ),
         ( 493, 565, 564, ),
         ( 493, 494, 565, ),
         ( 494, 566, 565, ),
         ( 494, 495, 566, ),
         ( 495, 567, 566, ),
         ( 495, 496, 567, ),
         ( 496, 568, 567, ),
         ( 496, 497, 568, ),
         ( 497, 569, 568, ),
         ( 497, 498, 569, ),
         ( 498, 570, 569, ),
         ( 498, 499, 570, ),
         ( 499, 571, 570, ),
         ( 499, 500, 571, ),
         ( 500, 572, 571, ),
         ( 500, 501, 572, ),
         ( 501, 573, 572, ),
         ( 501, 502, 573, ),
         ( 502, 574, 573, ),
         ( 502, 503, 574, ),
         ( 503, 575, 574, ),
         ( 503, 432, 575, ),
         ( 432, 504, 575, ),
         ( 504, 505, 577, ),
         ( 504, 577, 576, ),
         ( 505, 506, 578, ),
         ( 505, 578, 577, ),
         ( 506, 507, 579, ),
         ( 506, 579, 578, ),
         ( 507, 508, 580, ),
         ( 507, 580, 579, ),
         ( 508, 509, 581, ),
         ( 508, 581, 580, ),
         ( 509, 510, 582, ),
         ( 509, 582, 581, ),
         ( 510, 511, 583, ),
         ( 510, 583, 582, ),
         ( 511, 512, 584, ),
         ( 511, 584, 583, ),
         ( 512, 513, 585, ),
         ( 512, 585, 584, ),
         ( 513, 514, 586, ),
         ( 513, 586, 585, ),
         ( 514, 515, 587, ),
         ( 514, 587, 586, ),
         ( 515, 516, 588, ),
         ( 515, 588, 587, ),
         ( 516, 517, 589, ),
         ( 516, 589, 588, ),
         ( 517, 518, 590, ),
         ( 517, 590, 589, ),
         ( 518, 519, 591, ),
         ( 518, 591, 590, ),
         ( 519, 520, 592, ),
         ( 519, 592, 591, ),
         ( 520, 521, 593, ),
         ( 520, 593, 592, ),
         ( 521, 522, 594, ),
         ( 521, 594, 593, ),
         ( 522, 523, 595, ),
         ( 522, 595, 594, ),
         ( 523, 524, 596, ),
         ( 523, 596, 595, ),
         ( 524, 525, 597, ),
         ( 524, 597, 596, ),
         ( 525, 526, 598, ),
         ( 525, 598, 597, ),
         ( 526, 527, 599, ),
         ( 526, 599, 598, ),
         ( 527, 528, 600, ),
         ( 527, 600, 599, ),
         ( 528, 529, 601, ),
         ( 528, 601, 600, ),
         ( 529, 530, 602, ),
         ( 529, 602, 601, ),
         ( 530, 531, 603, ),
         ( 530, 603, 602, ),
         ( 531, 532, 604, ),
         ( 531, 604, 603, ),
         ( 532, 533, 605, ),
         ( 532, 605, 604, ),
         ( 533, 534, 606, ),
         ( 533, 606, 605, ),
         ( 534, 535, 607, ),
         ( 534, 607, 606, ),
         ( 535, 536, 608, ),
         ( 535, 608, 607, ),
         ( 536, 537, 609, ),
         ( 536, 609, 608, ),
         ( 537, 538, 610, ),
         ( 537, 610, 609, ),
         ( 538, 539, 611, ),
         ( 538, 611, 610, ),
         ( 539, 540, 612, ),
         ( 539, 612, 611, ),
         ( 540, 541, 613, ),
         ( 540, 613, 612, ),
         ( 541, 542, 614, ),
         ( 541, 614, 613, ),
         ( 542, 543, 615, ),
         ( 542, 615, 614, ),
         ( 543, 544, 616, ),
         ( 543, 616, 615, ),
         ( 544, 545, 617, ),
         ( 544, 617, 616, ),
         ( 545, 546, 618, ),
         ( 545, 618, 617, ),
         ( 546, 547, 619, ),
         ( 546, 619, 618, ),
         ( 547, 548, 620, ),
         ( 547, 620, 619, ),
         ( 548, 549, 621, ),
         ( 548, 621, 620, ),
         ( 549, 550, 622, ),
         ( 549, 622, 621, ),
         ( 550, 551, 623, ),
         ( 550, 623, 622, ),
         ( 551, 552, 624, ),
         ( 551, 624, 623, ),
         ( 552, 553, 625, ),
         ( 552, 625, 624, ),
         ( 553, 554, 626, ),
         ( 553, 626, 625, ),
         ( 554, 555, 627, ),
         ( 554, 627, 626, ),
         ( 555, 556, 628, ),
         ( 555, 628, 627, ),
         ( 556, 557, 629, ),
         ( 556, 629, 628, ),
         ( 557, 558, 630, ),
         ( 557, 630, 629, ),
         ( 558, 559, 631, ),
         ( 558, 631, 630, ),
         ( 559, 560, 632, ),
         ( 559, 632, 631, ),
         ( 560, 561, 633, ),
         ( 560, 633, 632, ),
         ( 561, 562, 634, ),
         ( 561, 634, 633, ),
         ( 562, 563, 635, ),
         ( 562, 635, 634, ),
         ( 563, 564, 636, ),
         ( 563, 636, 635, ),
         ( 564, 565, 637, ),
         ( 564, 637, 636, ),
         ( 565, 566, 638, ),
         ( 565, 638, 637, ),
         ( 566, 567, 639, ),
         ( 566, 639, 638, ),
         ( 567, 568, 640, ),
         ( 567, 640, 639, ),
         ( 568, 569, 641, ),
         ( 568, 641, 640, ),
         ( 569, 570, 642, ),
         ( 569, 642, 641, ),
         ( 570, 571, 643, ),
         ( 570, 643, 642, ),
         ( 571, 572, 644, ),
         ( 571, 644, 643, ),
         ( 572, 573, 645, ),
         ( 572, 645, 644, ),
         ( 573, 574, 646, ),
         ( 573, 646, 645, ),
         ( 574, 575, 647, ),
         ( 574, 647, 646, ),
         ( 575, 504, 576, ),
         ( 575, 576, 647, ),
         ( 576, 577, 648, ),
         ( 577, 649, 648, ),
         ( 577, 578, 649, ),
         ( 578, 650, 649, ),
         ( 578, 579, 650, ),
         ( 579, 651, 650, ),
         ( 579, 580, 651, ),
         ( 580, 652, 651, ),
         ( 580, 581, 652, ),
         ( 581, 653, 652, ),
         ( 581, 582, 653, ),
         ( 582, 654, 653, ),
         ( 582, 583, 654, ),
         ( 583, 655, 654, ),
         ( 583, 584, 655, ),
         ( 584, 656, 655, ),
         ( 584, 585, 656, ),
         ( 585, 657, 656, ),
         ( 585, 586, 657, ),
         ( 586, 658, 657, ),
         ( 586, 587, 658, ),
         ( 587, 659, 658, ),
         ( 587, 588, 659, ),
         ( 588, 660, 659, ),
         ( 588, 589, 660, ),
         ( 589, 661, 660, ),
         ( 589, 590, 661, ),
         ( 590, 662, 661, ),
         ( 590, 591, 662, ),
         ( 591, 663, 662, ),
         ( 591, 592, 663, ),
         ( 592, 664, 663, ),
         ( 592, 593, 664, ),
         ( 593, 665, 664, ),
         ( 593, 594, 665, ),
         ( 594, 666, 665, ),
         ( 594, 595, 666, ),
         ( 595, 667, 666, ),
         ( 595, 596, 667, ),
         ( 596, 668, 667, ),
         ( 596, 597, 668, ),
         ( 597, 669, 668, ),
         ( 597, 598, 669, ),
         ( 598, 670, 669, ),
         ( 598, 599, 670, ),
         ( 599, 671, 670, ),
         ( 599, 600, 671, ),
         ( 600, 672, 671, ),
         ( 600, 601, 672, ),
         ( 601, 673, 672, ),
         ( 601, 602, 673, ),
         ( 602, 674, 673, ),
         ( 602, 603, 674, ),
         ( 603, 675, 674, ),
         ( 603, 604, 675, ),
         ( 604, 676, 675, ),
         ( 604, 605, 676, ),
         ( 605, 677, 676, ),
         ( 605, 606, 677, ),
         ( 606, 678, 677, ),
         ( 606, 607, 678, ),
         ( 607, 679, 678, ),
         ( 607, 608, 679, ),
         ( 608, 680, 679, ),
         ( 608, 609, 680, ),
         ( 609, 681, 680, ),
         ( 609, 610, 681, ),
         ( 610, 682, 681, ),
         ( 610, 611, 682, ),
         ( 611, 683, 682, ),
         ( 611, 612, 683, ),
         ( 612, 684, 683, ),
         ( 612, 613, 684, ),
         ( 613, 685, 684, ),
         ( 613, 614, 685, ),
         ( 614, 686, 685, ),
         ( 614, 615, 686, ),
         ( 615, 687, 686, ),
         ( 615, 616, 687, ),
         ( 616, 688, 687, ),
         ( 616, 617, 688, ),
         ( 617, 689, 688, ),
         ( 617, 618, 689, ),
         ( 618, 690, 689, ),
         ( 618, 619, 690, ),
         ( 619, 691, 690, ),
         ( 619, 620, 691, ),
         ( 620, 692, 691, ),
         ( 620, 621, 692, ),
         ( 621, 693, 692, ),
         ( 621, 622, 693, ),
         ( 622, 694, 693, ),
         ( 622, 623, 694, ),
         ( 623, 695, 694, ),
         ( 623, 624, 695, ),
         ( 624, 696, 695, ),
         ( 624, 625, 696, ),
         ( 625, 697, 696, ),
         ( 625, 626, 697, ),
         ( 626, 698, 697, ),
         ( 626, 627, 698, ),
         ( 627, 699, 698, ),
         ( 627, 628, 699, ),
         ( 628, 700, 699, ),
         ( 628, 629, 700, ),
         ( 629, 701, 700, ),
         ( 629, 630, 701, ),
         ( 630, 702, 701, ),
         ( 630, 631, 702, ),
         ( 631, 703, 702, ),
         ( 631, 632, 703, ),
         ( 632, 704, 703, ),
         ( 632, 633, 704, ),
         ( 633, 705, 704, ),
         ( 633, 634, 705, ),
         ( 634, 706, 705, ),
         ( 634, 635, 706, ),
         ( 635, 707, 706, ),
         ( 635, 636, 707, ),
         ( 636, 708, 707, ),
         ( 636, 637, 708, ),
         ( 637, 709, 708, ),
         ( 637, 638, 709, ),
         ( 638, 710, 709, ),
         ( 638, 639, 710, ),
         ( 639, 711, 710, ),
         ( 639, 640, 711, ),
         ( 640, 712, 711, ),
         ( 640, 641, 712, ),
         ( 641, 713, 712, ),
         ( 641, 642, 713, ),
         ( 642, 714, 713, ),
         ( 642, 643, 714, ),
         ( 643, 715, 714, ),
         ( 643, 644, 715, ),
         ( 644, 716, 715, ),
         ( 644, 645, 716, ),
         ( 645, 717, 716, ),
         ( 645, 646, 717, ),
         ( 646, 718, 717, ),
         ( 646, 647, 718, ),
         ( 647, 719, 718, ),
         ( 647, 576, 719, ),
         ( 576, 648, 719, ),
         ( 648, 649, 721, ),
         ( 648, 721, 720, ),
         ( 649, 650, 722, ),
         ( 649, 722, 721, ),
         ( 650, 651, 723, ),
         ( 650, 723, 722, ),
         ( 651, 652, 724, ),
         ( 651, 724, 723, ),
         ( 652, 653, 725, ),
         ( 652, 725, 724, ),
         ( 653, 654, 726, ),
         ( 653, 726, 725, ),
         ( 654, 655, 727, ),
         ( 654, 727, 726, ),
         ( 655, 656, 728, ),
         ( 655, 728, 727, ),
         ( 656, 657, 729, ),
         ( 656, 729, 728, ),
         ( 657, 658, 730, ),
         ( 657, 730, 729, ),
         ( 658, 659, 731, ),
         ( 658, 731, 730, ),
         ( 659, 660, 732, ),
         ( 659, 732, 731, ),
         ( 660, 661, 733, ),
         ( 660, 733, 732, ),
         ( 661, 662, 734, ),
         ( 661, 734, 733, ),
         ( 662, 663, 735, ),
         ( 662, 735, 734, ),
         ( 663, 664, 736, ),
         ( 663, 736, 735, ),
         ( 664, 665, 737, ),
         ( 664, 737, 736, ),
         ( 665, 666, 738, ),
         ( 665, 738, 737, ),
         ( 666, 667, 739, ),
         ( 666, 739, 738, ),
         ( 667, 668, 740, ),
         ( 667, 740, 739, ),
         ( 668, 669, 741, ),
         ( 668, 741, 740, ),
         ( 669, 670, 742, ),
         ( 669, 742, 741, ),
         ( 670, 671, 743, ),
         ( 670, 743, 742, ),
         ( 671, 672, 744, ),
         ( 671, 744, 743, ),
         ( 672, 673, 745, ),
         ( 672, 745, 744, ),
         ( 673, 674, 746, ),
         ( 673, 746, 745, ),
         ( 674, 675, 747, ),
         ( 674, 747, 746, ),
         ( 675, 676, 748, ),
         ( 675, 748, 747, ),
         ( 676, 677, 749, ),
         ( 676, 749, 748, ),
         ( 677, 678, 750, ),
         ( 677, 750, 749, ),
         ( 678, 679, 751, ),
         ( 678, 751, 750, ),
         ( 679, 680, 752, ),
         ( 679, 752, 751, ),
         ( 680, 681, 753, ),
         ( 680, 753, 752, ),
         ( 681, 682, 754, ),
         ( 681, 754, 753, ),
         ( 682, 683, 755, ),
         ( 682, 755, 754, ),
         ( 683, 684, 756, ),
         ( 683, 756, 755, ),
         ( 684, 685, 757, ),
         ( 684, 757, 756, ),
         ( 685, 686, 758, ),
         ( 685, 758, 757, ),
         ( 686, 687, 759, ),
         ( 686, 759, 758, ),
         ( 687, 688, 760, ),
         ( 687, 760, 759, ),
         ( 688, 689, 761, ),
         ( 688, 761, 760, ),
         ( 689, 690, 762, ),
         ( 689, 762, 761, ),
         ( 690, 691, 763, ),
         ( 690, 763, 762, ),
         ( 691, 692, 764, ),
         ( 691, 764, 763, ),
         ( 692, 693, 765, ),
         ( 692, 765, 764, ),
         ( 693, 694, 766, ),
         ( 693, 766, 765, ),
         ( 694, 695, 767, ),
         ( 694, 767, 766, ),
         ( 695, 696, 768, ),
         ( 695, 768, 767, ),
         ( 696, 697, 769, ),
         ( 696, 769, 768, ),
         ( 697, 698, 770, ),
         ( 697, 770, 769, ),
         ( 698, 699, 771, ),
         ( 698, 771, 770, ),
         ( 699, 700, 772, ),
         ( 699, 772, 771, ),
         ( 700, 701, 773, ),
         ( 700, 773, 772, ),
         ( 701, 702, 774, ),
         ( 701, 774, 773, ),
         ( 702, 703, 775, ),
         ( 702, 775, 774, ),
         ( 703, 704, 776, ),
         ( 703, 776, 775, ),
         ( 704, 705, 777, ),
         ( 704, 777, 776, ),
         ( 705, 706, 778, ),
         ( 705, 778, 777, ),
         ( 706, 707, 779, ),
         ( 706, 779, 778, ),
         ( 707, 708, 780, ),
         ( 707, 780, 779, ),
         ( 708, 709, 781, ),
         ( 708, 781, 780, ),
         ( 709, 710, 782, ),
         ( 709, 782, 781, ),
         ( 710, 711, 783, ),
         ( 710, 783, 782, ),
         ( 711, 712, 784, ),
         ( 711, 784, 783, ),
         ( 712, 713, 785, ),
         ( 712, 785, 784, ),
         ( 713, 714, 786, ),
         ( 713, 786, 785, ),
         ( 714, 715, 787, ),
         ( 714, 787, 786, ),
         ( 715, 716, 788, ),
         ( 715, 788, 787, ),
         ( 716, 717, 789, ),
         ( 716, 789, 788, ),
         ( 717, 718, 790, ),
         ( 717, 790, 789, ),
         ( 718, 719, 791, ),
         ( 718, 791, 790, ),
         ( 719, 648, 720, ),
         ( 719, 720, 791, ),
         ( 720, 721, 792, ),
         ( 721, 793, 792, ),
         ( 721, 722, 793, ),
         ( 722, 794, 793, ),
         ( 722, 723, 794, ),
         ( 723, 795, 794, ),
         ( 723, 724, 795, ),
         ( 724, 796, 795, ),
         ( 724, 725, 796, ),
         ( 725, 797, 796, ),
         ( 725, 726, 797, ),
         ( 726, 798, 797, ),
         ( 726, 727, 798, ),
         ( 727, 799, 798, ),
         ( 727, 728, 799, ),
         ( 728, 800, 799, ),
         ( 728, 729, 800, ),
         ( 729, 801, 800, ),
         ( 729, 730, 801, ),
         ( 730, 802, 801, ),
         ( 730, 731, 802, ),
         ( 731, 803, 802, ),
         ( 731, 732, 803, ),
         ( 732, 804, 803, ),
         ( 732, 733, 804, ),
         ( 733, 805, 804, ),
         ( 733, 734, 805, ),
         ( 734, 806, 805, ),
         ( 734, 735, 806, ),
         ( 735, 807, 806, ),
         ( 735, 736, 807, ),
         ( 736, 808, 807, ),
         ( 736, 737, 808, ),
         ( 737, 809, 808, ),
         ( 737, 738, 809, ),
         ( 738, 810, 809, ),
         ( 738, 739, 810, ),
         ( 739, 811, 810, ),
         ( 739, 740, 811, ),
         ( 740, 812, 811, ),
         ( 740, 741, 812, ),
         ( 741, 813, 812, ),
         ( 741, 742, 813, ),
         ( 742, 814, 813, ),
         ( 742, 743, 814, ),
         ( 743, 815, 814, ),
         ( 743, 744, 815, ),
         ( 744, 816, 815, ),
         ( 744, 745, 816, ),
         ( 745, 817, 816, ),
         ( 745, 746, 817, ),
         ( 746, 818, 817, ),
         ( 746, 747, 818, ),
         ( 747, 819, 818, ),
         ( 747, 748, 819, ),
         ( 748, 820, 819, ),
         ( 748, 749, 820, ),
         ( 749, 821, 820, ),
         ( 749, 750, 821, ),
         ( 750, 822, 821, ),
         ( 750, 751, 822, ),
         ( 751, 823, 822, ),
         ( 751, 752, 823, ),
         ( 752, 824, 823, ),
         ( 752, 753, 824, ),
         ( 753, 825, 824, ),
         ( 753, 754, 825, ),
         ( 754, 826, 825, ),
         ( 754, 755, 826, ),
         ( 755, 827, 826, ),
         ( 755, 756, 827, ),
         ( 756, 828, 827, ),
         ( 756, 757, 828, ),
         ( 757, 829, 828, ),
         ( 757, 758, 829, ),
         ( 758, 830, 829, ),
         ( 758, 759, 830, ),
         ( 759, 831, 830, ),
         ( 759, 760, 831, ),
         ( 760, 832, 831, ),
         ( 760, 761, 832, ),
         ( 761, 833, 832, ),
         ( 761, 762, 833, ),
         ( 762, 834, 833, ),
         ( 762, 763, 834, ),
         ( 763, 835, 834, ),
         ( 763, 764, 835, ),
         ( 764, 836, 835, ),
         ( 764, 765, 836, ),
         ( 765, 837, 836, ),
         ( 765, 766, 837, ),
         ( 766, 838, 837, ),
         ( 766, 767, 838, ),
         ( 767, 839, 838, ),
         ( 767, 768, 839, ),
         ( 768, 840, 839, ),
         ( 768, 769, 840, ),
         ( 769, 841, 840, ),
         ( 769, 770, 841, ),
         ( 770, 842, 841, ),
         ( 770, 771, 842, ),
         ( 771, 843, 842, ),
         ( 771, 772, 843, ),
         ( 772, 844, 843, ),
         ( 772, 773, 844, ),
         ( 773, 845, 844, ),
         ( 773, 774, 845, ),
         ( 774, 846, 845, ),
         ( 774, 775, 846, ),
         ( 775, 847, 846, ),
         ( 775, 776, 847, ),
         ( 776, 848, 847, ),
         ( 776, 777, 848, ),
         ( 777, 849, 848, ),
         ( 777, 778, 849, ),
         ( 778, 850, 849, ),
         ( 778, 779, 850, ),
         ( 779, 851, 850, ),
         ( 779, 780, 851, ),
         ( 780, 852, 851, ),
         ( 780, 781, 852, ),
         ( 781, 853, 852, ),
         ( 781, 782, 853, ),
         ( 782, 854, 853, ),
         ( 782, 783, 854, ),
         ( 783, 855, 854, ),
         ( 783, 784, 855, ),
         ( 784, 856, 855, ),
         ( 784, 785, 856, ),
         ( 785, 857, 856, ),
         ( 785, 786, 857, ),
         ( 786, 858, 857, ),
         ( 786, 787, 858, ),
         ( 787, 859, 858, ),
         ( 787, 788, 859, ),
         ( 788, 860, 859, ),
         ( 788, 789, 860, ),
         ( 789, 861, 860, ),
         ( 789, 790, 861, ),
         ( 790, 862, 861, ),
         ( 790, 791, 862, ),
         ( 791, 863, 862, ),
         ( 791, 720, 863, ),
         ( 720, 792, 863, ),
         ( 792, 793, 865, ),
         ( 792, 865, 864, ),
         ( 793, 794, 866, ),
         ( 793, 866, 865, ),
         ( 794, 795, 867, ),
         ( 794, 867, 866, ),
         ( 795, 796, 868, ),
         ( 795, 868, 867, ),
         ( 796, 797, 869, ),
         ( 796, 869, 868, ),
         ( 797, 798, 870, ),
         ( 797, 870, 869, ),
         ( 798, 799, 871, ),
         ( 798, 871, 870, ),
         ( 799, 800, 872, ),
         ( 799, 872, 871, ),
         ( 800, 801, 873, ),
         ( 800, 873, 872, ),
         ( 801, 802, 874, ),
         ( 801, 874, 873, ),
         ( 802, 803, 875, ),
         ( 802, 875, 874, ),
         ( 803, 804, 876, ),
         ( 803, 876, 875, ),
         ( 804, 805, 877, ),
         ( 804, 877, 876, ),
         ( 805, 806, 878, ),
         ( 805, 878, 877, ),
         ( 806, 807, 879, ),
         ( 806, 879, 878, ),
         ( 807, 808, 880, ),
         ( 807, 880, 879, ),
         ( 808, 809, 881, ),
         ( 808, 881, 880, ),
         ( 809, 810, 882, ),
         ( 809, 882, 881, ),
         ( 810, 811, 883, ),
         ( 810, 883, 882, ),
         ( 811, 812, 884, ),
         ( 811, 884, 883, ),
         ( 812, 813, 885, ),
         ( 812, 885, 884, ),
         ( 813, 814, 886, ),
         ( 813, 886, 885, ),
         ( 814, 815, 887, ),
         ( 814, 887, 886, ),
         ( 815, 816, 888, ),
         ( 815, 888, 887, ),
         ( 816, 817, 889, ),
         ( 816, 889, 888, ),
         ( 817, 818, 890, ),
         ( 817, 890, 889, ),
         ( 818, 819, 891, ),
         ( 818, 891, 890, ),
         ( 819, 820, 892, ),
         ( 819, 892, 891, ),
         ( 820, 821, 893, ),
         ( 820, 893, 892, ),
         ( 821, 822, 894, ),
         ( 821, 894, 893, ),
         ( 822, 823, 895, ),
         ( 822, 895, 894, ),
         ( 823, 824, 896, ),
         ( 823, 896, 895, ),
         ( 824, 825, 897, ),
         ( 824, 897, 896, ),
         ( 825, 826, 898, ),
         ( 825, 898, 897, ),
         ( 826, 827, 899, ),
         ( 826, 899, 898, ),
         ( 827, 828, 900, ),
         ( 827, 900, 899, ),
         ( 828, 829, 901, ),
         ( 828, 901, 900, ),
         ( 829, 830, 902, ),
         ( 829, 902, 901, ),
         ( 830, 831, 903, ),
         ( 830, 903, 902, ),
         ( 831, 832, 904, ),
         ( 831, 904, 903, ),
         ( 832, 833, 905, ),
         ( 832, 905, 904, ),
         ( 833, 834, 906, ),
         ( 833, 906, 905, ),
         ( 834, 835, 907, ),
         ( 834, 907, 906, ),
         ( 835, 836, 908, ),
         ( 835, 908, 907, ),
         ( 836, 837, 909, ),
         ( 836, 909, 908, ),
         ( 837, 838, 910, ),
         ( 837, 910, 909, ),
         ( 838, 839, 911, ),
         ( 838, 911, 910, ),
         ( 839, 840, 912, ),
         ( 839, 912, 911, ),
         ( 840, 841, 913, ),
         ( 840, 913, 912, ),
         ( 841, 842, 914, ),
         ( 841, 914, 913, ),
         ( 842, 843, 915, ),
         ( 842, 915, 914, ),
         ( 843, 844, 916, ),
         ( 843, 916, 915, ),
         ( 844, 845, 917, ),
         ( 844, 917, 916, ),
         ( 845, 846, 918, ),
         ( 845, 918, 917, ),
         ( 846, 847, 919, ),
         ( 846, 919, 918, ),
         ( 847, 848, 920, ),
         ( 847, 920, 919, ),
         ( 848, 849, 921, ),
         ( 848, 921, 920, ),
         ( 849, 850, 922, ),
         ( 849, 922, 921, ),
         ( 850, 851, 923, ),
         ( 850, 923, 922, ),
         ( 851, 852, 924, ),
         ( 851, 924, 923, ),
         ( 852, 853, 925, ),
         ( 852, 925, 924, ),
         ( 853, 854, 926, ),
         ( 853, 926, 925, ),
         ( 854, 855, 927, ),
         ( 854, 927, 926, ),
         ( 855, 856, 928, ),
         ( 855, 928, 927, ),
         ( 856, 857, 929, ),
         ( 856, 929, 928, ),
         ( 857, 858, 930, ),
         ( 857, 930, 929, ),
         ( 858, 859, 931, ),
         ( 858, 931, 930, ),
         ( 859, 860, 932, ),
         ( 859, 932, 931, ),
         ( 860, 861, 933, ),
         ( 860, 933, 932, ),
         ( 861, 862, 934, ),
         ( 861, 934, 933, ),
         ( 862, 863, 935, ),
         ( 862, 935, 934, ),
         ( 863, 792, 864, ),
         ( 863, 864, 935, ),
         ( 864, 865, 936, ),
         ( 865, 937, 936, ),
         ( 865, 866, 937, ),
         ( 866, 938, 937, ),
         ( 866, 867, 938, ),
         ( 867, 939, 938, ),
         ( 867, 868, 939, ),
         ( 868, 940, 939, ),
         ( 868, 869, 940, ),
         ( 869, 941, 940, ),
         ( 869, 870, 941, ),
         ( 870, 942, 941, ),
         ( 870, 871, 942, ),
         ( 871, 943, 942, ),
         ( 871, 872, 943, ),
         ( 872, 944, 943, ),
         ( 872, 873, 944, ),
         ( 873, 945, 944, ),
         ( 873, 874, 945, ),
         ( 874, 946, 945, ),
         ( 874, 875, 946, ),
         ( 875, 947, 946, ),
         ( 875, 876, 947, ),
         ( 876, 948, 947, ),
         ( 876, 877, 948, ),
         ( 877, 949, 948, ),
         ( 877, 878, 949, ),
         ( 878, 950, 949, ),
         ( 878, 879, 950, ),
         ( 879, 951, 950, ),
         ( 879, 880, 951, ),
         ( 880, 952, 951, ),
         ( 880, 881, 952, ),
         ( 881, 953, 952, ),
         ( 881, 882, 953, ),
         ( 882, 954, 953, ),
         ( 882, 883, 954, ),
         ( 883, 955, 954, ),
         ( 883, 884, 955, ),
         ( 884, 956, 955, ),
         ( 884, 885, 956, ),
         ( 885, 957, 956, ),
         ( 885, 886, 957, ),
         ( 886, 958, 957, ),
         ( 886, 887, 958, ),
         ( 887, 959, 958, ),
         ( 887, 888, 959, ),
         ( 888, 960, 959, ),
         ( 888, 889, 960, ),
         ( 889, 961, 960, ),
         ( 889, 890, 961, ),
         ( 890, 962, 961, ),
         ( 890, 891, 962, ),
         ( 891, 963, 962, ),
         ( 891, 892, 963, ),
         ( 892, 964, 963, ),
         ( 892, 893, 964, ),
         ( 893, 965, 964, ),
         ( 893, 894, 965, ),
         ( 894, 966, 965, ),
         ( 894, 895, 966, ),
         ( 895, 967, 966, ),
         ( 895, 896, 967, ),
         ( 896, 968, 967, ),
         ( 896, 897, 968, ),
         ( 897, 969, 968, ),
         ( 897, 898, 969, ),
         ( 898, 970, 969, ),
         ( 898, 899, 970, ),
         ( 899, 971, 970, ),
         ( 899, 900, 971, ),
         ( 900, 972, 971, ),
         ( 900, 901, 972, ),
         ( 901, 973, 972, ),
         ( 901, 902, 973, ),
         ( 902, 974, 973, ),
         ( 902, 903, 974, ),
         ( 903, 975, 974, ),
         ( 903, 904, 975, ),
         ( 904, 976, 975, ),
         ( 904, 905, 976, ),
         ( 905, 977, 976, ),
         ( 905, 906, 977, ),
         ( 906, 978, 977, ),
         ( 906, 907, 978, ),
         ( 907, 979, 978, ),
         ( 907, 908, 979, ),
         ( 908, 980, 979, ),
         ( 908, 909, 980, ),
         ( 909, 981, 980, ),
         ( 909, 910, 981, ),
         ( 910, 982, 981, ),
         ( 910, 911, 982, ),
         ( 911, 983, 982, ),
         ( 911, 912, 983, ),
         ( 912, 984, 983, ),
         ( 912, 913, 984, ),
         ( 913, 985, 984, ),
         ( 913, 914, 985, ),
         ( 914, 986, 985, ),
         ( 914, 915, 986, ),
         ( 915, 987, 986, ),
         ( 915, 916, 987, ),
         ( 916, 988, 987, ),
         ( 916, 917, 988, ),
         ( 917, 989, 988, ),
         ( 917, 918, 989, ),
         ( 918, 990, 989, ),
         ( 918, 919, 990, ),
         ( 919, 991, 990, ),
         ( 919, 920, 991, ),
         ( 920, 992, 991, ),
         ( 920, 921, 992, ),
         ( 921, 993, 992, ),
         ( 921, 922, 993, ),
         ( 922, 994, 993, ),
         ( 922, 923, 994, ),
         ( 923, 995, 994, ),
         ( 923, 924, 995, ),
         ( 924, 996, 995, ),
         ( 924, 925, 996, ),
         ( 925, 997, 996, ),
         ( 925, 926, 997, ),
         ( 926, 998, 997, ),
         ( 926, 927, 998, ),
         ( 927, 999, 998, ),
         ( 927, 928, 999, ),
         ( 928, 1000, 999, ),
         ( 928, 929, 1000, ),
         ( 929, 1001, 1000, ),
         ( 929, 930, 1001, ),
         ( 930, 1002, 1001, ),
         ( 930, 931, 1002, ),
         ( 931, 1003, 1002, ),
         ( 931, 932, 1003, ),
         ( 932, 1004, 1003, ),
         ( 932, 933, 1004, ),
         ( 933, 1005, 1004, ),
         ( 933, 934, 1005, ),
         ( 934, 1006, 1005, ),
         ( 934, 935, 1006, ),
         ( 935, 1007, 1006, ),
         ( 935, 864, 1007, ),
         ( 864, 936, 1007, ),
         ( 936, 937, 1009, ),
         ( 936, 1009, 1008, ),
         ( 937, 938, 1010, ),
         ( 937, 1010, 1009, ),
         ( 938, 939, 1011, ),
         ( 938, 1011, 1010, ),
         ( 939, 940, 1012, ),
         ( 939, 1012, 1011, ),
         ( 940, 941, 1013, ),
         ( 940, 1013, 1012, ),
         ( 941, 942, 1014, ),
         ( 941, 1014, 1013, ),
         ( 942, 943, 1015, ),
         ( 942, 1015, 1014, ),
         ( 943, 944, 1016, ),
         ( 943, 1016, 1015, ),
         ( 944, 945, 1017, ),
         ( 944, 1017, 1016, ),
         ( 945, 946, 1018, ),
         ( 945, 1018, 1017, ),
         ( 946, 947, 1019, ),
         ( 946, 1019, 1018, ),
         ( 947, 948, 1020, ),
         ( 947, 1020, 1019, ),
         ( 948, 949, 1021, ),
         ( 948, 1021, 1020, ),
         ( 949, 950, 1022, ),
         ( 949, 1022, 1021, ),
         ( 950, 951, 1023, ),
         ( 950, 1023, 1022, ),
         ( 951, 952, 1024, ),
         ( 951, 1024, 1023, ),
         ( 952, 953, 1025, ),
         ( 952, 1025, 1024, ),
         ( 953, 954, 1026, ),
         ( 953, 1026, 1025, ),
         ( 954, 955, 1027, ),
         ( 954, 1027, 1026, ),
         ( 955, 956, 1028, ),
         ( 955, 1028, 1027, ),
         ( 956, 957, 1029, ),
         ( 956, 1029, 1028, ),
         ( 957, 958, 1030, ),
         ( 957, 1030, 1029, ),
         ( 958, 959, 1031, ),
         ( 958, 1031, 1030, ),
         ( 959, 960, 1032, ),
         ( 959, 1032, 1031, ),
         ( 960, 961, 1033, ),
         ( 960, 1033, 1032, ),
         ( 961, 962, 1034, ),
         ( 961, 1034, 1033, ),
         ( 962, 963, 1035, ),
         ( 962, 1035, 1034, ),
         ( 963, 964, 1036, ),
         ( 963, 1036, 1035, ),
         ( 964, 965, 1037, ),
         ( 964, 1037, 1036, ),
         ( 965, 966, 1038, ),
         ( 965, 1038, 1037, ),
         ( 966, 967, 1039, ),
         ( 966, 1039, 1038, ),
         ( 967, 968, 1040, ),
         ( 967, 1040, 1039, ),
         ( 968, 969, 1041, ),
         ( 968, 1041, 1040, ),
         ( 969, 970, 1042, ),
         ( 969, 1042, 1041, ),
         ( 970, 971, 1043, ),
         ( 970, 1043, 1042, ),
         ( 971, 972, 1044, ),
         ( 971, 1044, 1043, ),
         ( 972, 973, 1045, ),
         ( 972, 1045, 1044, ),
         ( 973, 974, 1046, ),
         ( 973, 1046, 1045, ),
         ( 974, 975, 1047, ),
         ( 974, 1047, 1046, ),
         ( 975, 976, 1048, ),
         ( 975, 1048, 1047, ),
         ( 976, 977, 1049, ),
         ( 976, 1049, 1048, ),
         ( 977, 978, 1050, ),
         ( 977, 1050, 1049, ),
         ( 978, 979, 1051, ),
         ( 978, 1051, 1050, ),
         ( 979, 980, 1052, ),
         ( 979, 1052, 1051, ),
         ( 980, 981, 1053, ),
         ( 980, 1053, 1052, ),
         ( 981, 982, 1054, ),
         ( 981, 1054, 1053, ),
         ( 982, 983, 1055, ),
         ( 982, 1055, 1054, ),
         ( 983, 984, 1056, ),
         ( 983, 1056, 1055, ),
         ( 984, 985, 1057, ),
         ( 984, 1057, 1056, ),
         ( 985, 986, 1058, ),
         ( 985, 1058, 1057, ),
         ( 986, 987, 1059, ),
         ( 986, 1059, 1058, ),
         ( 987, 988, 1060, ),
         ( 987, 1060, 1059, ),
         ( 988, 989, 1061, ),
         ( 988, 1061, 1060, ),
         ( 989, 990, 1062, ),
         ( 989, 1062, 1061, ),
         ( 990, 991, 1063, ),
         ( 990, 1063, 1062, ),
         ( 991, 992, 1064, ),
         ( 991, 1064, 1063, ),
         ( 992, 993, 1065, ),
         ( 992, 1065, 1064, ),
         ( 993, 994, 1066, ),
         ( 993, 1066, 1065, ),
         ( 994, 995, 1067, ),
         ( 994, 1067, 1066, ),
         ( 995, 996, 1068, ),
         ( 995, 1068, 1067, ),
         ( 996, 997, 1069, ),
         ( 996, 1069, 1068, ),
         ( 997, 998, 1070, ),
         ( 997, 1070, 1069, ),
         ( 998, 999, 1071, ),
         ( 998, 1071, 1070, ),
         ( 999, 1000, 1072, ),
         ( 999, 1072, 1071, ),
         ( 1000, 1001, 1073, ),
         ( 1000, 1073, 1072, ),
         ( 1001, 1002, 1074, ),
         ( 1001, 1074, 1073, ),
         ( 1002, 1003, 1075, ),
         ( 1002, 1075, 1074, ),
         ( 1003, 1004, 1076, ),
         ( 1003, 1076, 1075, ),
         ( 1004, 1005, 1077, ),
         ( 1004, 1077, 1076, ),
         ( 1005, 1006, 1078, ),
         ( 1005, 1078, 1077, ),
         ( 1006, 1007, 1079, ),
         ( 1006, 1079, 1078, ),
         ( 1007, 936, 1008, ),
         ( 1007, 1008, 1079, ),
         ( 1008, 1009, 1080, ),
         ( 1009, 1081, 1080, ),
         ( 1009, 1010, 1081, ),
         ( 1010, 1082, 1081, ),
         ( 1010, 1011, 1082, ),
         ( 1011, 1083, 1082, ),
         ( 1011, 1012, 1083, ),
         ( 1012, 1084, 1083, ),
         ( 1012, 1013, 1084, ),
         ( 1013, 1085, 1084, ),
         ( 1013, 1014, 1085, ),
         ( 1014, 1086, 1085, ),
         ( 1014, 1015, 1086, ),
         ( 1015, 1087, 1086, ),
         ( 1015, 1016, 1087, ),
         ( 1016, 1088, 1087, ),
         ( 1016, 1017, 1088, ),
         ( 1017, 1089, 1088, ),
         ( 1017, 1018, 1089, ),
         ( 1018, 1090, 1089, ),
         ( 1018, 1019, 1090, ),
         ( 1019, 1091, 1090, ),
         ( 1019, 1020, 1091, ),
         ( 1020, 1092, 1091, ),
         ( 1020, 1021, 1092, ),
         ( 1021, 1093, 1092, ),
         ( 1021, 1022, 1093, ),
         ( 1022, 1094, 1093, ),
         ( 1022, 1023, 1094, ),
         ( 1023, 1095, 1094, ),
         ( 1023, 1024, 1095, ),
         ( 1024, 1096, 1095, ),
         ( 1024, 1025, 1096, ),
         ( 1025, 1097, 1096, ),
         ( 1025, 1026, 1097, ),
         ( 1026, 1098, 1097, ),
         ( 1026, 1027, 1098, ),
         ( 1027, 1099, 1098, ),
         ( 1027, 1028, 1099, ),
         ( 1028, 1100, 1099, ),
         ( 1028, 1029, 1100, ),
         ( 1029, 1101, 1100, ),
         ( 1029, 1030, 1101, ),
         ( 1030, 1102, 1101, ),
         ( 1030, 1031, 1102, ),
         ( 1031, 1103, 1102, ),
         ( 1031, 1032, 1103, ),
         ( 1032, 1104, 1103, ),
         ( 1032, 1033, 1104, ),
         ( 1033, 1105, 1104, ),
         ( 1033, 1034, 1105, ),
         ( 1034, 1106, 1105, ),
         ( 1034, 1035, 1106, ),
         ( 1035, 1107, 1106, ),
         ( 1035, 1036, 1107, ),
         ( 1036, 1108, 1107, ),
         ( 1036, 1037, 1108, ),
         ( 1037, 1109, 1108, ),
         ( 1037, 1038, 1109, ),
         ( 1038, 1110, 1109, ),
         ( 1038, 1039, 1110, ),
         ( 1039, 1111, 1110, ),
         ( 1039, 1040, 1111, ),
         ( 1040, 1112, 1111, ),
         ( 1040, 1041, 1112, ),
         ( 1041, 1113, 1112, ),
         ( 1041, 1042, 1113, ),
         ( 1042, 1114, 1113, ),
         ( 1042, 1043, 1114, ),
         ( 1043, 1115, 1114, ),
         ( 1043, 1044, 1115, ),
         ( 1044, 1116, 1115, ),
         ( 1044, 1045, 1116, ),
         ( 1045, 1117, 1116, ),
         ( 1045, 1046, 1117, ),
         ( 1046, 1118, 1117, ),
         ( 1046, 1047, 1118, ),
         ( 1047, 1119, 1118, ),
         ( 1047, 1048, 1119, ),
         ( 1048, 1120, 1119, ),
         ( 1048, 1049, 1120, ),
         ( 1049, 1121, 1120, ),
         ( 1049, 1050, 1121, ),
         ( 1050, 1122, 1121, ),
         ( 1050, 1051, 1122, ),
         ( 1051, 1123, 1122, ),
         ( 1051, 1052, 1123, ),
         ( 1052, 1124, 1123, ),
         ( 1052, 1053, 1124, ),
         ( 1053, 1125, 1124, ),
         ( 1053, 1054, 1125, ),
         ( 1054, 1126, 1125, ),
         ( 1054, 1055, 1126, ),
         ( 1055, 1127, 1126, ),
         ( 1055, 1056, 1127, ),
         ( 1056, 1128, 1127, ),
         ( 1056, 1057, 1128, ),
         ( 1057, 1129, 1128, ),
         ( 1057, 1058, 1129, ),
         ( 1058, 1130, 1129, ),
         ( 1058, 1059, 1130, ),
         ( 1059, 1131, 1130, ),
         ( 1059, 1060, 1131, ),
         ( 1060, 1132, 1131, ),
         ( 1060, 1061, 1132, ),
         ( 1061, 1133, 1132, ),
         ( 1061, 1062, 1133, ),
         ( 1062, 1134, 1133, ),
         ( 1062, 1063, 1134, ),
         ( 1063, 1135, 1134, ),
         ( 1063, 1064, 1135, ),
         ( 1064, 1136, 1135, ),
         ( 1064, 1065, 1136, ),
         ( 1065, 1137, 1136, ),
         ( 1065, 1066, 1137, ),
         ( 1066, 1138, 1137, ),
         ( 1066, 1067, 1138, ),
         ( 1067, 1139, 1138, ),
         ( 1067, 1068, 1139, ),
         ( 1068, 1140, 1139, ),
         ( 1068, 1069, 1140, ),
         ( 1069, 1141, 1140, ),
         ( 1069, 1070, 1141, ),
         ( 1070, 1142, 1141, ),
         ( 1070, 1071, 1142, ),
         ( 1071, 1143, 1142, ),
         ( 1071, 1072, 1143, ),
         ( 1072, 1144, 1143, ),
         ( 1072, 1073, 1144, ),
         ( 1073, 1145, 1144, ),
         ( 1073, 1074, 1145, ),
         ( 1074, 1146, 1145, ),
         ( 1074, 1075, 1146, ),
         ( 1075, 1147, 1146, ),
         ( 1075, 1076, 1147, ),
         ( 1076, 1148, 1147, ),
         ( 1076, 1077, 1148, ),
         ( 1077, 1149, 1148, ),
         ( 1077, 1078, 1149, ),
         ( 1078, 1150, 1149, ),
         ( 1078, 1079, 1150, ),
         ( 1079, 1151, 1150, ),
         ( 1079, 1008, 1151, ),
         ( 1008, 1080, 1151, ),
         ( 1080, 1081, 1153, ),
         ( 1080, 1153, 1152, ),
         ( 1081, 1082, 1154, ),
         ( 1081, 1154, 1153, ),
         ( 1082, 1083, 1155, ),
         ( 1082, 1155, 1154, ),
         ( 1083, 1084, 1156, ),
         ( 1083, 1156, 1155, ),
         ( 1084, 1085, 1157, ),
         ( 1084, 1157, 1156, ),
         ( 1085, 1086, 1158, ),
         ( 1085, 1158, 1157, ),
         ( 1086, 1087, 1159, ),
         ( 1086, 1159, 1158, ),
         ( 1087, 1088, 1160, ),
         ( 1087, 1160, 1159, ),
         ( 1088, 1089, 1161, ),
         ( 1088, 1161, 1160, ),
         ( 1089, 1090, 1162, ),
         ( 1089, 1162, 1161, ),
         ( 1090, 1091, 1163, ),
         ( 1090, 1163, 1162, ),
         ( 1091, 1092, 1164, ),
         ( 1091, 1164, 1163, ),
         ( 1092, 1093, 1165, ),
         ( 1092, 1165, 1164, ),
         ( 1093, 1094, 1166, ),
         ( 1093, 1166, 1165, ),
         ( 1094, 1095, 1167, ),
         ( 1094, 1167, 1166, ),
         ( 1095, 1096, 1168, ),
         ( 1095, 1168, 1167, ),
         ( 1096, 1097, 1169, ),
         ( 1096, 1169, 1168, ),
         ( 1097, 1098, 1170, ),
         ( 1097, 1170, 1169, ),
         ( 1098, 1099, 1171, ),
         ( 1098, 1171, 1170, ),
         ( 1099, 1100, 1172, ),
         ( 1099, 1172, 1171, ),
         ( 1100, 1101, 1173, ),
         ( 1100, 1173, 1172, ),
         ( 1101, 1102, 1174, ),
         ( 1101, 1174, 1173, ),
         ( 1102, 1103, 1175, ),
         ( 1102, 1175, 1174, ),
         ( 1103, 1104, 1176, ),
         ( 1103, 1176, 1175, ),
         ( 1104, 1105, 1177, ),
         ( 1104, 1177, 1176, ),
         ( 1105, 1106, 1178, ),
         ( 1105, 1178, 1177, ),
         ( 1106, 1107, 1179, ),
         ( 1106, 1179, 1178, ),
         ( 1107, 1108, 1180, ),
         ( 1107, 1180, 1179, ),
         ( 1108, 1109, 1181, ),
         ( 1108, 1181, 1180, ),
         ( 1109, 1110, 1182, ),
         ( 1109, 1182, 1181, ),
         ( 1110, 1111, 1183, ),
         ( 1110, 1183, 1182, ),
         ( 1111, 1112, 1184, ),
         ( 1111, 1184, 1183, ),
         ( 1112, 1113, 1185, ),
         ( 1112, 1185, 1184, ),
         ( 1113, 1114, 1186, ),
         ( 1113, 1186, 1185, ),
         ( 1114, 1115, 1187, ),
         ( 1114, 1187, 1186, ),
         ( 1115, 1116, 1188, ),
         ( 1115, 1188, 1187, ),
         ( 1116, 1117, 1189, ),
         ( 1116, 1189, 1188, ),
         ( 1117, 1118, 1190, ),
         ( 1117, 1190, 1189, ),
         ( 1118, 1119, 1191, ),
         ( 1118, 1191, 1190, ),
         ( 1119, 1120, 1192, ),
         ( 1119, 1192, 1191, ),
         ( 1120, 1121, 1193, ),
         ( 1120, 1193, 1192, ),
         ( 1121, 1122, 1194, ),
         ( 1121, 1194, 1193, ),
         ( 1122, 1123, 1195, ),
         ( 1122, 1195, 1194, ),
         ( 1123, 1124, 1196, ),
         ( 1123, 1196, 1195, ),
         ( 1124, 1125, 1197, ),
         ( 1124, 1197, 1196, ),
         ( 1125, 1126, 1198, ),
         ( 1125, 1198, 1197, ),
         ( 1126, 1127, 1199, ),
         ( 1126, 1199, 1198, ),
         ( 1127, 1128, 1200, ),
         ( 1127, 1200, 1199, ),
         ( 1128, 1129, 1201, ),
         ( 1128, 1201, 1200, ),
         ( 1129, 1130, 1202, ),
         ( 1129, 1202, 1201, ),
         ( 1130, 1131, 1203, ),
         ( 1130, 1203, 1202, ),
         ( 1131, 1132, 1204, ),
         ( 1131, 1204, 1203, ),
         ( 1132, 1133, 1205, ),
         ( 1132, 1205, 1204, ),
         ( 1133, 1134, 1206, ),
         ( 1133, 1206, 1205, ),
         ( 1134, 1135, 1207, ),
         ( 1134, 1207, 1206, ),
         ( 1135, 1136, 1208, ),
         ( 1135, 1208, 1207, ),
         ( 1136, 1137, 1209, ),
         ( 1136, 1209, 1208, ),
         ( 1137, 1138, 1210, ),
         ( 1137, 1210, 1209, ),
         ( 1138, 1139, 1211, ),
         ( 1138, 1211, 1210, ),
         ( 1139, 1140, 1212, ),
         ( 1139, 1212, 1211, ),
         ( 1140, 1141, 1213, ),
         ( 1140, 1213, 1212, ),
         ( 1141, 1142, 1214, ),
         ( 1141, 1214, 1213, ),
         ( 1142, 1143, 1215, ),
         ( 1142, 1215, 1214, ),
         ( 1143, 1144, 1216, ),
         ( 1143, 1216, 1215, ),
         ( 1144, 1145, 1217, ),
         ( 1144, 1217, 1216, ),
         ( 1145, 1146, 1218, ),
         ( 1145, 1218, 1217, ),
         ( 1146, 1147, 1219, ),
         ( 1146, 1219, 1218, ),
         ( 1147, 1148, 1220, ),
         ( 1147, 1220, 1219, ),
         ( 1148, 1149, 1221, ),
         ( 1148, 1221, 1220, ),
         ( 1149, 1150, 1222, ),
         ( 1149, 1222, 1221, ),
         ( 1150, 1151, 1223, ),
         ( 1150, 1223, 1222, ),
         ( 1151, 1080, 1152, ),
         ( 1151, 1152, 1223, ),
         ( 1152, 1153, 1224, ),
         ( 1153, 1225, 1224, ),
         ( 1153, 1154, 1225, ),
         ( 1154, 1226, 1225, ),
         ( 1154, 1155, 1226, ),
         ( 1155, 1227, 1226, ),
         ( 1155, 1156, 1227, ),
         ( 1156, 1228, 1227, ),
         ( 1156, 1157, 1228, ),
         ( 1157, 1229, 1228, ),
         ( 1157, 1158, 1229, ),
         ( 1158, 1230, 1229, ),
         ( 1158, 1159, 1230, ),
         ( 1159, 1231, 1230, ),
         ( 1159, 1160, 1231, ),
         ( 1160, 1232, 1231, ),
         ( 1160, 1161, 1232, ),
         ( 1161, 1233, 1232, ),
         ( 1161, 1162, 1233, ),
         ( 1162, 1234, 1233, ),
         ( 1162, 1163, 1234, ),
         ( 1163, 1235, 1234, ),
         ( 1163, 1164, 1235, ),
         ( 1164, 1236, 1235, ),
         ( 1164, 1165, 1236, ),
         ( 1165, 1237, 1236, ),
         ( 1165, 1166, 1237, ),
         ( 1166, 1238, 1237, ),
         ( 1166, 1167, 1238, ),
         ( 1167, 1239, 1238, ),
         ( 1167, 1168, 1239, ),
         ( 1168, 1240, 1239, ),
         ( 1168, 1169, 1240, ),
         ( 1169, 1241, 1240, ),
         ( 1169, 1170, 1241, ),
         ( 1170, 1242, 1241, ),
         ( 1170, 1171, 1242, ),
         ( 1171, 1243, 1242, ),
         ( 1171, 1172, 1243, ),
         ( 1172, 1244, 1243, ),
         ( 1172, 1173, 1244, ),
         ( 1173, 1245, 1244, ),
         ( 1173, 1174, 1245, ),
         ( 1174, 1246, 1245, ),
         ( 1174, 1175, 1246, ),
         ( 1175, 1247, 1246, ),
         ( 1175, 1176, 1247, ),
         ( 1176, 1248, 1247, ),
         ( 1176, 1177, 1248, ),
         ( 1177, 1249, 1248, ),
         ( 1177, 1178, 1249, ),
         ( 1178, 1250, 1249, ),
         ( 1178, 1179, 1250, ),
         ( 1179, 1251, 1250, ),
         ( 1179, 1180, 1251, ),
         ( 1180, 1252, 1251, ),
         ( 1180, 1181, 1252, ),
         ( 1181, 1253, 1252, ),
         ( 1181, 1182, 1253, ),
         ( 1182, 1254, 1253, ),
         ( 1182, 1183, 1254, ),
         ( 1183, 1255, 1254, ),
         ( 1183, 1184, 1255, ),
         ( 1184, 1256, 1255, ),
         ( 1184, 1185, 1256, ),
         ( 1185, 1257, 1256, ),
         ( 1185, 1186, 1257, ),
         ( 1186, 1258, 1257, ),
         ( 1186, 1187, 1258, ),
         ( 1187, 1259, 1258, ),
         ( 1187, 1188, 1259, ),
         ( 1188, 1260, 1259, ),
         ( 1188, 1189, 1260, ),
         ( 1189, 1261, 1260, ),
         ( 1189, 1190, 1261, ),
         ( 1190, 1262, 1261, ),
         ( 1190, 1191, 1262, ),
         ( 1191, 1263, 1262, ),
         ( 1191, 1192, 1263, ),
         ( 1192, 1264, 1263, ),
         ( 1192, 1193, 1264, ),
         ( 1193, 1265, 1264, ),
         ( 1193, 1194, 1265, ),
         ( 1194, 1266, 1265, ),
         ( 1194, 1195, 1266, ),
         ( 1195, 1267, 1266, ),
         ( 1195, 1196, 1267, ),
         ( 1196, 1268, 1267, ),
         ( 1196, 1197, 1268, ),
         ( 1197, 1269, 1268, ),
         ( 1197, 1198, 1269, ),
         ( 1198, 1270, 1269, ),
         ( 1198, 1199, 1270, ),
         ( 1199, 1271, 1270, ),
         ( 1199, 1200, 1271, ),
         ( 1200, 1272, 1271, ),
         ( 1200, 1201, 1272, ),
         ( 1201, 1273, 1272, ),
         ( 1201, 1202, 1273, ),
         ( 1202, 1274, 1273, ),
         ( 1202, 1203, 1274, ),
         ( 1203, 1275, 1274, ),
         ( 1203, 1204, 1275, ),
         ( 1204, 1276, 1275, ),
         ( 1204, 1205, 1276, ),
         ( 1205, 1277, 1276, ),
         ( 1205, 1206, 1277, ),
         ( 1206, 1278, 1277, ),
         ( 1206, 1207, 1278, ),
         ( 1207, 1279, 1278, ),
         ( 1207, 1208, 1279, ),
         ( 1208, 1280, 1279, ),
         ( 1208, 1209, 1280, ),
         ( 1209, 1281, 1280, ),
         ( 1209, 1210, 1281, ),
         ( 1210, 1282, 1281, ),
         ( 1210, 1211, 1282, ),
         ( 1211, 1283, 1282, ),
         ( 1211, 1212, 1283, ),
         ( 1212, 1284, 1283, ),
         ( 1212, 1213, 1284, ),
         ( 1213, 1285, 1284, ),
         ( 1213, 1214, 1285, ),
         ( 1214, 1286, 1285, ),
         ( 1214, 1215, 1286, ),
         ( 1215, 1287, 1286, ),
         ( 1215, 1216, 1287, ),
         ( 1216, 1288, 1287, ),
         ( 1216, 1217, 1288, ),
         ( 1217, 1289, 1288, ),
         ( 1217, 1218, 1289, ),
         ( 1218, 1290, 1289, ),
         ( 1218, 1219, 1290, ),
         ( 1219, 1291, 1290, ),
         ( 1219, 1220, 1291, ),
         ( 1220, 1292, 1291, ),
         ( 1220, 1221, 1292, ),
         ( 1221, 1293, 1292, ),
         ( 1221, 1222, 1293, ),
         ( 1222, 1294, 1293, ),
         ( 1222, 1223, 1294, ),
         ( 1223, 1295, 1294, ),
         ( 1223, 1152, 1295, ),
         ( 1152, 1224, 1295, ),
         ( 1224, 1225, 1297, ),
         ( 1224, 1297, 1296, ),
         ( 1225, 1226, 1298, ),
         ( 1225, 1298, 1297, ),
         ( 1226, 1227, 1299, ),
         ( 1226, 1299, 1298, ),
         ( 1227, 1228, 1300, ),
         ( 1227, 1300, 1299, ),
         ( 1228, 1229, 1301, ),
         ( 1228, 1301, 1300, ),
         ( 1229, 1230, 1302, ),
         ( 1229, 1302, 1301, ),
         ( 1230, 1231, 1303, ),
         ( 1230, 1303, 1302, ),
         ( 1231, 1232, 1304, ),
         ( 1231, 1304, 1303, ),
         ( 1232, 1233, 1305, ),
         ( 1232, 1305, 1304, ),
         ( 1233, 1234, 1306, ),
         ( 1233, 1306, 1305, ),
         ( 1234, 1235, 1307, ),
         ( 1234, 1307, 1306, ),
         ( 1235, 1236, 1308, ),
         ( 1235, 1308, 1307, ),
         ( 1236, 1237, 1309, ),
         ( 1236, 1309, 1308, ),
         ( 1237, 1238, 1310, ),
         ( 1237, 1310, 1309, ),
         ( 1238, 1239, 1311, ),
         ( 1238, 1311, 1310, ),
         ( 1239, 1240, 1312, ),
         ( 1239, 1312, 1311, ),
         ( 1240, 1241, 1313, ),
         ( 1240, 1313, 1312, ),
         ( 1241, 1242, 1314, ),
         ( 1241, 1314, 1313, ),
         ( 1242, 1243, 1315, ),
         ( 1242, 1315, 1314, ),
         ( 1243, 1244, 1316, ),
         ( 1243, 1316, 1315, ),
         ( 1244, 1245, 1317, ),
         ( 1244, 1317, 1316, ),
         ( 1245, 1246, 1318, ),
         ( 1245, 1318, 1317, ),
         ( 1246, 1247, 1319, ),
         ( 1246, 1319, 1318, ),
         ( 1247, 1248, 1320, ),
         ( 1247, 1320, 1319, ),
         ( 1248, 1249, 1321, ),
         ( 1248, 1321, 1320, ),
         ( 1249, 1250, 1322, ),
         ( 1249, 1322, 1321, ),
         ( 1250, 1251, 1323, ),
         ( 1250, 1323, 1322, ),
         ( 1251, 1252, 1324, ),
         ( 1251, 1324, 1323, ),
         ( 1252, 1253, 1325, ),
         ( 1252, 1325, 1324, ),
         ( 1253, 1254, 1326, ),
         ( 1253, 1326, 1325, ),
         ( 1254, 1255, 1327, ),
         ( 1254, 1327, 1326, ),
         ( 1255, 1256, 1328, ),
         ( 1255, 1328, 1327, ),
         ( 1256, 1257, 1329, ),
         ( 1256, 1329, 1328, ),
         ( 1257, 1258, 1330, ),
         ( 1257, 1330, 1329, ),
         ( 1258, 1259, 1331, ),
         ( 1258, 1331, 1330, ),
         ( 1259, 1260, 1332, ),
         ( 1259, 1332, 1331, ),
         ( 1260, 1261, 1333, ),
         ( 1260, 1333, 1332, ),
         ( 1261, 1262, 1334, ),
         ( 1261, 1334, 1333, ),
         ( 1262, 1263, 1335, ),
         ( 1262, 1335, 1334, ),
         ( 1263, 1264, 1336, ),
         ( 1263, 1336, 1335, ),
         ( 1264, 1265, 1337, ),
         ( 1264, 1337, 1336, ),
         ( 1265, 1266, 1338, ),
         ( 1265, 1338, 1337, ),
         ( 1266, 1267, 1339, ),
         ( 1266, 1339, 1338, ),
         ( 1267, 1268, 1340, ),
         ( 1267, 1340, 1339, ),
         ( 1268, 1269, 1341, ),
         ( 1268, 1341, 1340, ),
         ( 1269, 1270, 1342, ),
         ( 1269, 1342, 1341, ),
         ( 1270, 1271, 1343, ),
         ( 1270, 1343, 1342, ),
         ( 1271, 1272, 1344, ),
         ( 1271, 1344, 1343, ),
         ( 1272, 1273, 1345, ),
         ( 1272, 1345, 1344, ),
         ( 1273, 1274, 1346, ),
         ( 1273, 1346, 1345, ),
         ( 1274, 1275, 1347, ),
         ( 1274, 1347, 1346, ),
         ( 1275, 1276, 1348, ),
         ( 1275, 1348, 1347, ),
         ( 1276, 1277, 1349, ),
         ( 1276, 1349, 1348, ),
         ( 1277, 1278, 1350, ),
         ( 1277, 1350, 1349, ),
         ( 1278, 1279, 1351, ),
         ( 1278, 1351, 1350, ),
         ( 1279, 1280, 1352, ),
         ( 1279, 1352, 1351, ),
         ( 1280, 1281, 1353, ),
         ( 1280, 1353, 1352, ),
         ( 1281, 1282, 1354, ),
         ( 1281, 1354, 1353, ),
         ( 1282, 1283, 1355, ),
         ( 1282, 1355, 1354, ),
         ( 1283, 1284, 1356, ),
         ( 1283, 1356, 1355, ),
         ( 1284, 1285, 1357, ),
         ( 1284, 1357, 1356, ),
         ( 1285, 1286, 1358, ),
         ( 1285, 1358, 1357, ),
         ( 1286, 1287, 1359, ),
         ( 1286, 1359, 1358, ),
         ( 1287, 1288, 1360, ),
         ( 1287, 1360, 1359, ),
         ( 1288, 1289, 1361, ),
         ( 1288, 1361, 1360, ),
         ( 1289, 1290, 1362, ),
         ( 1289, 1362, 1361, ),
         ( 1290, 1291, 1363, ),
         ( 1290, 1363, 1362, ),
         ( 1291, 1292, 1364, ),
         ( 1291, 1364, 1363, ),
         ( 1292, 1293, 1365, ),
         ( 1292, 1365, 1364, ),
         ( 1293, 1294, 1366, ),
         ( 1293, 1366, 1365, ),
         ( 1294, 1295, 1367, ),
         ( 1294, 1367, 1366, ),
         ( 1295, 1224, 1296, ),
         ( 1295, 1296, 1367, ),
         ( 1296, 1297, 1368, ),
         ( 1297, 1369, 1368, ),
         ( 1297, 1298, 1369, ),
         ( 1298, 1370, 1369, ),
         ( 1298, 1299, 1370, ),
         ( 1299, 1371, 1370, ),
         ( 1299, 1300, 1371, ),
         ( 1300, 1372, 1371, ),
         ( 1300, 1301, 1372, ),
         ( 1301, 1373, 1372, ),
         ( 1301, 1302, 1373, ),
         ( 1302, 1374, 1373, ),
         ( 1302, 1303, 1374, ),
         ( 1303, 1375, 1374, ),
         ( 1303, 1304, 1375, ),
         ( 1304, 1376, 1375, ),
         ( 1304, 1305, 1376, ),
         ( 1305, 1377, 1376, ),
         ( 1305, 1306, 1377, ),
         ( 1306, 1378, 1377, ),
         ( 1306, 1307, 1378, ),
         ( 1307, 1379, 1378, ),
         ( 1307, 1308, 1379, ),
         ( 1308, 1380, 1379, ),
         ( 1308, 1309, 1380, ),
         ( 1309, 1381, 1380, ),
         ( 1309, 1310, 1381, ),
         ( 1310, 1382, 1381, ),
         ( 1310, 1311, 1382, ),
         ( 1311, 1383, 1382, ),
         ( 1311, 1312, 1383, ),
         ( 1312, 1384, 1383, ),
         ( 1312, 1313, 1384, ),
         ( 1313, 1385, 1384, ),
         ( 1313, 1314, 1385, ),
         ( 1314, 1386, 1385, ),
         ( 1314, 1315, 1386, ),
         ( 1315, 1387, 1386, ),
         ( 1315, 1316, 1387, ),
         ( 1316, 1388, 1387, ),
         ( 1316, 1317, 1388, ),
         ( 1317, 1389, 1388, ),
         ( 1317, 1318, 1389, ),
         ( 1318, 1390, 1389, ),
         ( 1318, 1319, 1390, ),
         ( 1319, 1391, 1390, ),
         ( 1319, 1320, 1391, ),
         ( 1320, 1392, 1391, ),
         ( 1320, 1321, 1392, ),
         ( 1321, 1393, 1392, ),
         ( 1321, 1322, 1393, ),
         ( 1322, 1394, 1393, ),
         ( 1322, 1323, 1394, ),
         ( 1323, 1395, 1394, ),
         ( 1323, 1324, 1395, ),
         ( 1324, 1396, 1395, ),
         ( 1324, 1325, 1396, ),
         ( 1325, 1397, 1396, ),
         ( 1325, 1326, 1397, ),
         ( 1326, 1398, 1397, ),
         ( 1326, 1327, 1398, ),
         ( 1327, 1399, 1398, ),
         ( 1327, 1328, 1399, ),
         ( 1328, 1400, 1399, ),
         ( 1328, 1329, 1400, ),
         ( 1329, 1401, 1400, ),
         ( 1329, 1330, 1401, ),
         ( 1330, 1402, 1401, ),
         ( 1330, 1331, 1402, ),
         ( 1331, 1403, 1402, ),
         ( 1331, 1332, 1403, ),
         ( 1332, 1404, 1403, ),
         ( 1332, 1333, 1404, ),
         ( 1333, 1405, 1404, ),
         ( 1333, 1334, 1405, ),
         ( 1334, 1406, 1405, ),
         ( 1334, 1335, 1406, ),
         ( 1335, 1407, 1406, ),
         ( 1335, 1336, 1407, ),
         ( 1336, 1408, 1407, ),
         ( 1336, 1337, 1408, ),
         ( 1337, 1409, 1408, ),
         ( 1337, 1338, 1409, ),
         ( 1338, 1410, 1409, ),
         ( 1338, 1339, 1410, ),
         ( 1339, 1411, 1410, ),
         ( 1339, 1340, 1411, ),
         ( 1340, 1412, 1411, ),
         ( 1340, 1341, 1412, ),
         ( 1341, 1413, 1412, ),
         ( 1341, 1342, 1413, ),
         ( 1342, 1414, 1413, ),
         ( 1342, 1343, 1414, ),
         ( 1343, 1415, 1414, ),
         ( 1343, 1344, 1415, ),
         ( 1344, 1416, 1415, ),
         ( 1344, 1345, 1416, ),
         ( 1345, 1417, 1416, ),
         ( 1345, 1346, 1417, ),
         ( 1346, 1418, 1417, ),
         ( 1346, 1347, 1418, ),
         ( 1347, 1419, 1418, ),
         ( 1347, 1348, 1419, ),
         ( 1348, 1420, 1419, ),
         ( 1348, 1349, 1420, ),
         ( 1349, 1421, 1420, ),
         ( 1349, 1350, 1421, ),
         ( 1350, 1422, 1421, ),
         ( 1350, 1351, 1422, ),
         ( 1351, 1423, 1422, ),
         ( 1351, 1352, 1423, ),
         ( 1352, 1424, 1423, ),
         ( 1352, 1353, 1424, ),
         ( 1353, 1425, 1424, ),
         ( 1353, 1354, 1425, ),
         ( 1354, 1426, 1425, ),
         ( 1354, 1355, 1426, ),
         ( 1355, 1427, 1426, ),
         ( 1355, 1356, 1427, ),
         ( 1356, 1428, 1427, ),
         ( 1356, 1357, 1428, ),
         ( 1357, 1429, 1428, ),
         ( 1357, 1358, 1429, ),
         ( 1358, 1430, 1429, ),
         ( 1358, 1359, 1430, ),
         ( 1359, 1431, 1430, ),
         ( 1359, 1360, 1431, ),
         ( 1360, 1432, 1431, ),
         ( 1360, 1361, 1432, ),
         ( 1361, 1433, 1432, ),
         ( 1361, 1362, 1433, ),
         ( 1362, 1434, 1433, ),
         ( 1362, 1363, 1434, ),
         ( 1363, 1435, 1434, ),
         ( 1363, 1364, 1435, ),
         ( 1364, 1436, 1435, ),
         ( 1364, 1365, 1436, ),
         ( 1365, 1437, 1436, ),
         ( 1365, 1366, 1437, ),
         ( 1366, 1438, 1437, ),
         ( 1366, 1367, 1438, ),
         ( 1367, 1439, 1438, ),
         ( 1367, 1296, 1439, ),
         ( 1296, 1368, 1439, ),
         ( 1368, 1369, 1441, ),
         ( 1368, 1441, 1440, ),
         ( 1369, 1370, 1442, ),
         ( 1369, 1442, 1441, ),
         ( 1370, 1371, 1443, ),
         ( 1370, 1443, 1442, ),
         ( 1371, 1372, 1444, ),
         ( 1371, 1444, 1443, ),
         ( 1372, 1373, 1445, ),
         ( 1372, 1445, 1444, ),
         ( 1373, 1374, 1446, ),
         ( 1373, 1446, 1445, ),
         ( 1374, 1375, 1447, ),
         ( 1374, 1447, 1446, ),
         ( 1375, 1376, 1448, ),
         ( 1375, 1448, 1447, ),
         ( 1376, 1377, 1449, ),
         ( 1376, 1449, 1448, ),
         ( 1377, 1378, 1450, ),
         ( 1377, 1450, 1449, ),
         ( 1378, 1379, 1451, ),
         ( 1378, 1451, 1450, ),
         ( 1379, 1380, 1452, ),
         ( 1379, 1452, 1451, ),
         ( 1380, 1381, 1453, ),
         ( 1380, 1453, 1452, ),
         ( 1381, 1382, 1454, ),
         ( 1381, 1454, 1453, ),
         ( 1382, 1383, 1455, ),
         ( 1382, 1455, 1454, ),
         ( 1383, 1384, 1456, ),
         ( 1383, 1456, 1455, ),
         ( 1384, 1385, 1457, ),
         ( 1384, 1457, 1456, ),
         ( 1385, 1386, 1458, ),
         ( 1385, 1458, 1457, ),
         ( 1386, 1387, 1459, ),
         ( 1386, 1459, 1458, ),
         ( 1387, 1388, 1460, ),
         ( 1387, 1460, 1459, ),
         ( 1388, 1389, 1461, ),
         ( 1388, 1461, 1460, ),
         ( 1389, 1390, 1462, ),
         ( 1389, 1462, 1461, ),
         ( 1390, 1391, 1463, ),
         ( 1390, 1463, 1462, ),
         ( 1391, 1392, 1464, ),
         ( 1391, 1464, 1463, ),
         ( 1392, 1393, 1465, ),
         ( 1392, 1465, 1464, ),
         ( 1393, 1394, 1466, ),
         ( 1393, 1466, 1465, ),
         ( 1394, 1395, 1467, ),
         ( 1394, 1467, 1466, ),
         ( 1395, 1396, 1468, ),
         ( 1395, 1468, 1467, ),
         ( 1396, 1397, 1469, ),
         ( 1396, 1469, 1468, ),
         ( 1397, 1398, 1470, ),
         ( 1397, 1470, 1469, ),
         ( 1398, 1399, 1471, ),
         ( 1398, 1471, 1470, ),
         ( 1399, 1400, 1472, ),
         ( 1399, 1472, 1471, ),
         ( 1400, 1401, 1473, ),
         ( 1400, 1473, 1472, ),
         ( 1401, 1402, 1474, ),
         ( 1401, 1474, 1473, ),
         ( 1402, 1403, 1475, ),
         ( 1402, 1475, 1474, ),
         ( 1403, 1404, 1476, ),
         ( 1403, 1476, 1475, ),
         ( 1404, 1405, 1477, ),
         ( 1404, 1477, 1476, ),
         ( 1405, 1406, 1478, ),
         ( 1405, 1478, 1477, ),
         ( 1406, 1407, 1479, ),
         ( 1406, 1479, 1478, ),
         ( 1407, 1408, 1480, ),
         ( 1407, 1480, 1479, ),
         ( 1408, 1409, 1481, ),
         ( 1408, 1481, 1480, ),
         ( 1409, 1410, 1482, ),
         ( 1409, 1482, 1481, ),
         ( 1410, 1411, 1483, ),
         ( 1410, 1483, 1482, ),
         ( 1411, 1412, 1484, ),
         ( 1411, 1484, 1483, ),
         ( 1412, 1413, 1485, ),
         ( 1412, 1485, 1484, ),
         ( 1413, 1414, 1486, ),
         ( 1413, 1486, 1485, ),
         ( 1414, 1415, 1487, ),
         ( 1414, 1487, 1486, ),
         ( 1415, 1416, 1488, ),
         ( 1415, 1488, 1487, ),
         ( 1416, 1417, 1489, ),
         ( 1416, 1489, 1488, ),
         ( 1417, 1418, 1490, ),
         ( 1417, 1490, 1489, ),
         ( 1418, 1419, 1491, ),
         ( 1418, 1491, 1490, ),
         ( 1419, 1420, 1492, ),
         ( 1419, 1492, 1491, ),
         ( 1420, 1421, 1493, ),
         ( 1420, 1493, 1492, ),
         ( 1421, 1422, 1494, ),
         ( 1421, 1494, 1493, ),
         ( 1422, 1423, 1495, ),
         ( 1422, 1495, 1494, ),
         ( 1423, 1424, 1496, ),
         ( 1423, 1496, 1495, ),
         ( 1424, 1425, 1497, ),
         ( 1424, 1497, 1496, ),
         ( 1425, 1426, 1498, ),
         ( 1425, 1498, 1497, ),
         ( 1426, 1427, 1499, ),
         ( 1426, 1499, 1498, ),
         ( 1427, 1428, 1500, ),
         ( 1427, 1500, 1499, ),
         ( 1428, 1429, 1501, ),
         ( 1428, 1501, 1500, ),
         ( 1429, 1430, 1502, ),
         ( 1429, 1502, 1501, ),
         ( 1430, 1431, 1503, ),
         ( 1430, 1503, 1502, ),
         ( 1431, 1432, 1504, ),
         ( 1431, 1504, 1503, ),
         ( 1432, 1433, 1505, ),
         ( 1432, 1505, 1504, ),
         ( 1433, 1434, 1506, ),
         ( 1433, 1506, 1505, ),
         ( 1434, 1435, 1507, ),
         ( 1434, 1507, 1506, ),
         ( 1435, 1436, 1508, ),
         ( 1435, 1508, 1507, ),
         ( 1436, 1437, 1509, ),
         ( 1436, 1509, 1508, ),
         ( 1437, 1438, 1510, ),
         ( 1437, 1510, 1509, ),
         ( 1438, 1439, 1511, ),
         ( 1438, 1511, 1510, ),
         ( 1439, 1368, 1440, ),
         ( 1439, 1440, 1511, ),
         ( 1440, 1441, 1512, ),
         ( 1441, 1513, 1512, ),
         ( 1441, 1442, 1513, ),
         ( 1442, 1514, 1513, ),
         ( 1442, 1443, 1514, ),
         ( 1443, 1515, 1514, ),
         ( 1443, 1444, 1515, ),
         ( 1444, 1516, 1515, ),
         ( 1444, 1445, 1516, ),
         ( 1445, 1517, 1516, ),
         ( 1445, 1446, 1517, ),
         ( 1446, 1518, 1517, ),
         ( 1446, 1447, 1518, ),
         ( 1447, 1519, 1518, ),
         ( 1447, 1448, 1519, ),
         ( 1448, 1520, 1519, ),
         ( 1448, 1449, 1520, ),
         ( 1449, 1521, 1520, ),
         ( 1449, 1450, 1521, ),
         ( 1450, 1522, 1521, ),
         ( 1450, 1451, 1522, ),
         ( 1451, 1523, 1522, ),
         ( 1451, 1452, 1523, ),
         ( 1452, 1524, 1523, ),
         ( 1452, 1453, 1524, ),
         ( 1453, 1525, 1524, ),
         ( 1453, 1454, 1525, ),
         ( 1454, 1526, 1525, ),
         ( 1454, 1455, 1526, ),
         ( 1455, 1527, 1526, ),
         ( 1455, 1456, 1527, ),
         ( 1456, 1528, 1527, ),
         ( 1456, 1457, 1528, ),
         ( 1457, 1529, 1528, ),
         ( 1457, 1458, 1529, ),
         ( 1458, 1530, 1529, ),
         ( 1458, 1459, 1530, ),
         ( 1459, 1531, 1530, ),
         ( 1459, 1460, 1531, ),
         ( 1460, 1532, 1531, ),
         ( 1460, 1461, 1532, ),
         ( 1461, 1533, 1532, ),
         ( 1461, 1462, 1533, ),
         ( 1462, 1534, 1533, ),
         ( 1462, 1463, 1534, ),
         ( 1463, 1535, 1534, ),
         ( 1463, 1464, 1535, ),
         ( 1464, 1536, 1535, ),
         ( 1464, 1465, 1536, ),
         ( 1465, 1537, 1536, ),
         ( 1465, 1466, 1537, ),
         ( 1466, 1538, 1537, ),
         ( 1466, 1467, 1538, ),
         ( 1467, 1539, 1538, ),
         ( 1467, 1468, 1539, ),
         ( 1468, 1540, 1539, ),
         ( 1468, 1469, 1540, ),
         ( 1469, 1541, 1540, ),
         ( 1469, 1470, 1541, ),
         ( 1470, 1542, 1541, ),
         ( 1470, 1471, 1542, ),
         ( 1471, 1543, 1542, ),
         ( 1471, 1472, 1543, ),
         ( 1472, 1544, 1543, ),
         ( 1472, 1473, 1544, ),
         ( 1473, 1545, 1544, ),
         ( 1473, 1474, 1545, ),
         ( 1474, 1546, 1545, ),
         ( 1474, 1475, 1546, ),
         ( 1475, 1547, 1546, ),
         ( 1475, 1476, 1547, ),
         ( 1476, 1548, 1547, ),
         ( 1476, 1477, 1548, ),
         ( 1477, 1549, 1548, ),
         ( 1477, 1478, 1549, ),
         ( 1478, 1550, 1549, ),
         ( 1478, 1479, 1550, ),
         ( 1479, 1551, 1550, ),
         ( 1479, 1480, 1551, ),
         ( 1480, 1552, 1551, ),
         ( 1480, 1481, 1552, ),
         ( 1481, 1553, 1552, ),
         ( 1481, 1482, 1553, ),
         ( 1482, 1554, 1553, ),
         ( 1482, 1483, 1554, ),
         ( 1483, 1555, 1554, ),
         ( 1483, 1484, 1555, ),
         ( 1484, 1556, 1555, ),
         ( 1484, 1485, 1556, ),
         ( 1485, 1557, 1556, ),
         ( 1485, 1486, 1557, ),
         ( 1486, 1558, 1557, ),
         ( 1486, 1487, 1558, ),
         ( 1487, 1559, 1558, ),
         ( 1487, 1488, 1559, ),
         ( 1488, 1560, 1559, ),
         ( 1488, 1489, 1560, ),
         ( 1489, 1561, 1560, ),
         ( 1489, 1490, 1561, ),
         ( 1490, 1562, 1561, ),
         ( 1490, 1491, 1562, ),
         ( 1491, 1563, 1562, ),
         ( 1491, 1492, 1563, ),
         ( 1492, 1564, 1563, ),
         ( 1492, 1493, 1564, ),
         ( 1493, 1565, 1564, ),
         ( 1493, 1494, 1565, ),
         ( 1494, 1566, 1565, ),
         ( 1494, 1495, 1566, ),
         ( 1495, 1567, 1566, ),
         ( 1495, 1496, 1567, ),
         ( 1496, 1568, 1567, ),
         ( 1496, 1497, 1568, ),
         ( 1497, 1569, 1568, ),
         ( 1497, 1498, 1569, ),
         ( 1498, 1570, 1569, ),
         ( 1498, 1499, 1570, ),
         ( 1499, 1571, 1570, ),
         ( 1499, 1500, 1571, ),
         ( 1500, 1572, 1571, ),
         ( 1500, 1501, 1572, ),
         ( 1501, 1573, 1572, ),
         ( 1501, 1502, 1573, ),
         ( 1502, 1574, 1573, ),
         ( 1502, 1503, 1574, ),
         ( 1503, 1575, 1574, ),
         ( 1503, 1504, 1575, ),
         ( 1504, 1576, 1575, ),
         ( 1504, 1505, 1576, ),
         ( 1505, 1577, 1576, ),
         ( 1505, 1506, 1577, ),
         ( 1506, 1578, 1577, ),
         ( 1506, 1507, 1578, ),
         ( 1507, 1579, 1578, ),
         ( 1507, 1508, 1579, ),
         ( 1508, 1580, 1579, ),
         ( 1508, 1509, 1580, ),
         ( 1509, 1581, 1580, ),
         ( 1509, 1510, 1581, ),
         ( 1510, 1582, 1581, ),
         ( 1510, 1511, 1582, ),
         ( 1511, 1583, 1582, ),
         ( 1511, 1440, 1583, ),
         ( 1440, 1512, 1583, ),
         ( 1512, 1513, 1585, ),
         ( 1512, 1585, 1584, ),
         ( 1513, 1514, 1586, ),
         ( 1513, 1586, 1585, ),
         ( 1514, 1515, 1587, ),
         ( 1514, 1587, 1586, ),
         ( 1515, 1516, 1588, ),
         ( 1515, 1588, 1587, ),
         ( 1516, 1517, 1589, ),
         ( 1516, 1589, 1588, ),
         ( 1517, 1518, 1590, ),
         ( 1517, 1590, 1589, ),
         ( 1518, 1519, 1591, ),
         ( 1518, 1591, 1590, ),
         ( 1519, 1520, 1592, ),
         ( 1519, 1592, 1591, ),
         ( 1520, 1521, 1593, ),
         ( 1520, 1593, 1592, ),
         ( 1521, 1522, 1594, ),
         ( 1521, 1594, 1593, ),
         ( 1522, 1523, 1595, ),
         ( 1522, 1595, 1594, ),
         ( 1523, 1524, 1596, ),
         ( 1523, 1596, 1595, ),
         ( 1524, 1525, 1597, ),
         ( 1524, 1597, 1596, ),
         ( 1525, 1526, 1598, ),
         ( 1525, 1598, 1597, ),
         ( 1526, 1527, 1599, ),
         ( 1526, 1599, 1598, ),
         ( 1527, 1528, 1600, ),
         ( 1527, 1600, 1599, ),
         ( 1528, 1529, 1601, ),
         ( 1528, 1601, 1600, ),
         ( 1529, 1530, 1602, ),
         ( 1529, 1602, 1601, ),
         ( 1530, 1531, 1603, ),
         ( 1530, 1603, 1602, ),
         ( 1531, 1532, 1604, ),
         ( 1531, 1604, 1603, ),
         ( 1532, 1533, 1605, ),
         ( 1532, 1605, 1604, ),
         ( 1533, 1534, 1606, ),
         ( 1533, 1606, 1605, ),
         ( 1534, 1535, 1607, ),
         ( 1534, 1607, 1606, ),
         ( 1535, 1536, 1608, ),
         ( 1535, 1608, 1607, ),
         ( 1536, 1537, 1609, ),
         ( 1536, 1609, 1608, ),
         ( 1537, 1538, 1610, ),
         ( 1537, 1610, 1609, ),
         ( 1538, 1539, 1611, ),
         ( 1538, 1611, 1610, ),
         ( 1539, 1540, 1612, ),
         ( 1539, 1612, 1611, ),
         ( 1540, 1541, 1613, ),
         ( 1540, 1613, 1612, ),
         ( 1541, 1542, 1614, ),
         ( 1541, 1614, 1613, ),
         ( 1542, 1543, 1615, ),
         ( 1542, 1615, 1614, ),
         ( 1543, 1544, 1616, ),
         ( 1543, 1616, 1615, ),
         ( 1544, 1545, 1617, ),
         ( 1544, 1617, 1616, ),
         ( 1545, 1546, 1618, ),
         ( 1545, 1618, 1617, ),
         ( 1546, 1547, 1619, ),
         ( 1546, 1619, 1618, ),
         ( 1547, 1548, 1620, ),
         ( 1547, 1620, 1619, ),
         ( 1548, 1549, 1621, ),
         ( 1548, 1621, 1620, ),
         ( 1549, 1550, 1622, ),
         ( 1549, 1622, 1621, ),
         ( 1550, 1551, 1623, ),
         ( 1550, 1623, 1622, ),
         ( 1551, 1552, 1624, ),
         ( 1551, 1624, 1623, ),
         ( 1552, 1553, 1625, ),
         ( 1552, 1625, 1624, ),
         ( 1553, 1554, 1626, ),
         ( 1553, 1626, 1625, ),
         ( 1554, 1555, 1627, ),
         ( 1554, 1627, 1626, ),
         ( 1555, 1556, 1628, ),
         ( 1555, 1628, 1627, ),
         ( 1556, 1557, 1629, ),
         ( 1556, 1629, 1628, ),
         ( 1557, 1558, 1630, ),
         ( 1557, 1630, 1629, ),
         ( 1558, 1559, 1631, ),
         ( 1558, 1631, 1630, ),
         ( 1559, 1560, 1632, ),
         ( 1559, 1632, 1631, ),
         ( 1560, 1561, 1633, ),
         ( 1560, 1633, 1632, ),
         ( 1561, 1562, 1634, ),
         ( 1561, 1634, 1633, ),
         ( 1562, 1563, 1635, ),
         ( 1562, 1635, 1634, ),
         ( 1563, 1564, 1636, ),
         ( 1563, 1636, 1635, ),
         ( 1564, 1565, 1637, ),
         ( 1564, 1637, 1636, ),
         ( 1565, 1566, 1638, ),
         ( 1565, 1638, 1637, ),
         ( 1566, 1567, 1639, ),
         ( 1566, 1639, 1638, ),
         ( 1567, 1568, 1640, ),
         ( 1567, 1640, 1639, ),
         ( 1568, 1569, 1641, ),
         ( 1568, 1641, 1640, ),
         ( 1569, 1570, 1642, ),
         ( 1569, 1642, 1641, ),
         ( 1570, 1571, 1643, ),
         ( 1570, 1643, 1642, ),
         ( 1571, 1572, 1644, ),
         ( 1571, 1644, 1643, ),
         ( 1572, 1573, 1645, ),
         ( 1572, 1645, 1644, ),
         ( 1573, 1574, 1646, ),
         ( 1573, 1646, 1645, ),
         ( 1574, 1575, 1647, ),
         ( 1574, 1647, 1646, ),
         ( 1575, 1576, 1648, ),
         ( 1575, 1648, 1647, ),
         ( 1576, 1577, 1649, ),
         ( 1576, 1649, 1648, ),
         ( 1577, 1578, 1650, ),
         ( 1577, 1650, 1649, ),
         ( 1578, 1579, 1651, ),
         ( 1578, 1651, 1650, ),
         ( 1579, 1580, 1652, ),
         ( 1579, 1652, 1651, ),
         ( 1580, 1581, 1653, ),
         ( 1580, 1653, 1652, ),
         ( 1581, 1582, 1654, ),
         ( 1581, 1654, 1653, ),
         ( 1582, 1583, 1655, ),
         ( 1582, 1655, 1654, ),
         ( 1583, 1512, 1584, ),
         ( 1583, 1584, 1655, ),
         ( 1584, 1585, 1656, ),
         ( 1585, 1657, 1656, ),
         ( 1585, 1586, 1657, ),
         ( 1586, 1658, 1657, ),
         ( 1586, 1587, 1658, ),
         ( 1587, 1659, 1658, ),
         ( 1587, 1588, 1659, ),
         ( 1588, 1660, 1659, ),
         ( 1588, 1589, 1660, ),
         ( 1589, 1661, 1660, ),
         ( 1589, 1590, 1661, ),
         ( 1590, 1662, 1661, ),
         ( 1590, 1591, 1662, ),
         ( 1591, 1663, 1662, ),
         ( 1591, 1592, 1663, ),
         ( 1592, 1664, 1663, ),
         ( 1592, 1593, 1664, ),
         ( 1593, 1665, 1664, ),
         ( 1593, 1594, 1665, ),
         ( 1594, 1666, 1665, ),
         ( 1594, 1595, 1666, ),
         ( 1595, 1667, 1666, ),
         ( 1595, 1596, 1667, ),
         ( 1596, 1668, 1667, ),
         ( 1596, 1597, 1668, ),
         ( 1597, 1669, 1668, ),
         ( 1597, 1598, 1669, ),
         ( 1598, 1670, 1669, ),
         ( 1598, 1599, 1670, ),
         ( 1599, 1671, 1670, ),
         ( 1599, 1600, 1671, ),
         ( 1600, 1672, 1671, ),
         ( 1600, 1601, 1672, ),
         ( 1601, 1673, 1672, ),
         ( 1601, 1602, 1673, ),
         ( 1602, 1674, 1673, ),
         ( 1602, 1603, 1674, ),
         ( 1603, 1675, 1674, ),
         ( 1603, 1604, 1675, ),
         ( 1604, 1676, 1675, ),
         ( 1604, 1605, 1676, ),
         ( 1605, 1677, 1676, ),
         ( 1605, 1606, 1677, ),
         ( 1606, 1678, 1677, ),
         ( 1606, 1607, 1678, ),
         ( 1607, 1679, 1678, ),
         ( 1607, 1608, 1679, ),
         ( 1608, 1680, 1679, ),
         ( 1608, 1609, 1680, ),
         ( 1609, 1681, 1680, ),
         ( 1609, 1610, 1681, ),
         ( 1610, 1682, 1681, ),
         ( 1610, 1611, 1682, ),
         ( 1611, 1683, 1682, ),
         ( 1611, 1612, 1683, ),
         ( 1612, 1684, 1683, ),
         ( 1612, 1613, 1684, ),
         ( 1613, 1685, 1684, ),
         ( 1613, 1614, 1685, ),
         ( 1614, 1686, 1685, ),
         ( 1614, 1615, 1686, ),
         ( 1615, 1687, 1686, ),
         ( 1615, 1616, 1687, ),
         ( 1616, 1688, 1687, ),
         ( 1616, 1617, 1688, ),
         ( 1617, 1689, 1688, ),
         ( 1617, 1618, 1689, ),
         ( 1618, 1690, 1689, ),
         ( 1618, 1619, 1690, ),
         ( 1619, 1691, 1690, ),
         ( 1619, 1620, 1691, ),
         ( 1620, 1692, 1691, ),
         ( 1620, 1621, 1692, ),
         ( 1621, 1693, 1692, ),
         ( 1621, 1622, 1693, ),
         ( 1622, 1694, 1693, ),
         ( 1622, 1623, 1694, ),
         ( 1623, 1695, 1694, ),
         ( 1623, 1624, 1695, ),
         ( 1624, 1696, 1695, ),
         ( 1624, 1625, 1696, ),
         ( 1625, 1697, 1696, ),
         ( 1625, 1626, 1697, ),
         ( 1626, 1698, 1697, ),
         ( 1626, 1627, 1698, ),
         ( 1627, 1699, 1698, ),
         ( 1627, 1628, 1699, ),
         ( 1628, 1700, 1699, ),
         ( 1628, 1629, 1700, ),
         ( 1629, 1701, 1700, ),
         ( 1629, 1630, 1701, ),
         ( 1630, 1702, 1701, ),
         ( 1630, 1631, 1702, ),
         ( 1631, 1703, 1702, ),
         ( 1631, 1632, 1703, ),
         ( 1632, 1704, 1703, ),
         ( 1632, 1633, 1704, ),
         ( 1633, 1705, 1704, ),
         ( 1633, 1634, 1705, ),
         ( 1634, 1706, 1705, ),
         ( 1634, 1635, 1706, ),
         ( 1635, 1707, 1706, ),
         ( 1635, 1636, 1707, ),
         ( 1636, 1708, 1707, ),
         ( 1636, 1637, 1708, ),
         ( 1637, 1709, 1708, ),
         ( 1637, 1638, 1709, ),
         ( 1638, 1710, 1709, ),
         ( 1638, 1639, 1710, ),
         ( 1639, 1711, 1710, ),
         ( 1639, 1640, 1711, ),
         ( 1640, 1712, 1711, ),
         ( 1640, 1641, 1712, ),
         ( 1641, 1713, 1712, ),
         ( 1641, 1642, 1713, ),
         ( 1642, 1714, 1713, ),
         ( 1642, 1643, 1714, ),
         ( 1643, 1715, 1714, ),
         ( 1643, 1644, 1715, ),
         ( 1644, 1716, 1715, ),
         ( 1644, 1645, 1716, ),
         ( 1645, 1717, 1716, ),
         ( 1645, 1646, 1717, ),
         ( 1646, 1718, 1717, ),
         ( 1646, 1647, 1718, ),
         ( 1647, 1719, 1718, ),
         ( 1647, 1648, 1719, ),
         ( 1648, 1720, 1719, ),
         ( 1648, 1649, 1720, ),
         ( 1649, 1721, 1720, ),
         ( 1649, 1650, 1721, ),
         ( 1650, 1722, 1721, ),
         ( 1650, 1651, 1722, ),
         ( 1651, 1723, 1722, ),
         ( 1651, 1652, 1723, ),
         ( 1652, 1724, 1723, ),
         ( 1652, 1653, 1724, ),
         ( 1653, 1725, 1724, ),
         ( 1653, 1654, 1725, ),
         ( 1654, 1726, 1725, ),
         ( 1654, 1655, 1726, ),
         ( 1655, 1727, 1726, ),
         ( 1655, 1584, 1727, ),
         ( 1584, 1656, 1727, ),
         ( 1656, 1657, 1729, ),
         ( 1656, 1729, 1728, ),
         ( 1657, 1658, 1730, ),
         ( 1657, 1730, 1729, ),
         ( 1658, 1659, 1731, ),
         ( 1658, 1731, 1730, ),
         ( 1659, 1660, 1732, ),
         ( 1659, 1732, 1731, ),
         ( 1660, 1661, 1733, ),
         ( 1660, 1733, 1732, ),
         ( 1661, 1662, 1734, ),
         ( 1661, 1734, 1733, ),
         ( 1662, 1663, 1735, ),
         ( 1662, 1735, 1734, ),
         ( 1663, 1664, 1736, ),
         ( 1663, 1736, 1735, ),
         ( 1664, 1665, 1737, ),
         ( 1664, 1737, 1736, ),
         ( 1665, 1666, 1738, ),
         ( 1665, 1738, 1737, ),
         ( 1666, 1667, 1739, ),
         ( 1666, 1739, 1738, ),
         ( 1667, 1668, 1740, ),
         ( 1667, 1740, 1739, ),
         ( 1668, 1669, 1741, ),
         ( 1668, 1741, 1740, ),
         ( 1669, 1670, 1742, ),
         ( 1669, 1742, 1741, ),
         ( 1670, 1671, 1743, ),
         ( 1670, 1743, 1742, ),
         ( 1671, 1672, 1744, ),
         ( 1671, 1744, 1743, ),
         ( 1672, 1673, 1745, ),
         ( 1672, 1745, 1744, ),
         ( 1673, 1674, 1746, ),
         ( 1673, 1746, 1745, ),
         ( 1674, 1675, 1747, ),
         ( 1674, 1747, 1746, ),
         ( 1675, 1676, 1748, ),
         ( 1675, 1748, 1747, ),
         ( 1676, 1677, 1749, ),
         ( 1676, 1749, 1748, ),
         ( 1677, 1678, 1750, ),
         ( 1677, 1750, 1749, ),
         ( 1678, 1679, 1751, ),
         ( 1678, 1751, 1750, ),
         ( 1679, 1680, 1752, ),
         ( 1679, 1752, 1751, ),
         ( 1680, 1681, 1753, ),
         ( 1680, 1753, 1752, ),
         ( 1681, 1682, 1754, ),
         ( 1681, 1754, 1753, ),
         ( 1682, 1683, 1755, ),
         ( 1682, 1755, 1754, ),
         ( 1683, 1684, 1756, ),
         ( 1683, 1756, 1755, ),
         ( 1684, 1685, 1757, ),
         ( 1684, 1757, 1756, ),
         ( 1685, 1686, 1758, ),
         ( 1685, 1758, 1757, ),
         ( 1686, 1687, 1759, ),
         ( 1686, 1759, 1758, ),
         ( 1687, 1688, 1760, ),
         ( 1687, 1760, 1759, ),
         ( 1688, 1689, 1761, ),
         ( 1688, 1761, 1760, ),
         ( 1689, 1690, 1762, ),
         ( 1689, 1762, 1761, ),
         ( 1690, 1691, 1763, ),
         ( 1690, 1763, 1762, ),
         ( 1691, 1692, 1764, ),
         ( 1691, 1764, 1763, ),
         ( 1692, 1693, 1765, ),
         ( 1692, 1765, 1764, ),
         ( 1693, 1694, 1766, ),
         ( 1693, 1766, 1765, ),
         ( 1694, 1695, 1767, ),
         ( 1694, 1767, 1766, ),
         ( 1695, 1696, 1768, ),
         ( 1695, 1768, 1767, ),
         ( 1696, 1697, 1769, ),
         ( 1696, 1769, 1768, ),
         ( 1697, 1698, 1770, ),
         ( 1697, 1770, 1769, ),
         ( 1698, 1699, 1771, ),
         ( 1698, 1771, 1770, ),
         ( 1699, 1700, 1772, ),
         ( 1699, 1772, 1771, ),
         ( 1700, 1701, 1773, ),
         ( 1700, 1773, 1772, ),
         ( 1701, 1702, 1774, ),
         ( 1701, 1774, 1773, ),
         ( 1702, 1703, 1775, ),
         ( 1702, 1775, 1774, ),
         ( 1703, 1704, 1776, ),
         ( 1703, 1776, 1775, ),
         ( 1704, 1705, 1777, ),
         ( 1704, 1777, 1776, ),
         ( 1705, 1706, 1778, ),
         ( 1705, 1778, 1777, ),
         ( 1706, 1707, 1779, ),
         ( 1706, 1779, 1778, ),
         ( 1707, 1708, 1780, ),
         ( 1707, 1780, 1779, ),
         ( 1708, 1709, 1781, ),
         ( 1708, 1781, 1780, ),
         ( 1709, 1710, 1782, ),
         ( 1709, 1782, 1781, ),
         ( 1710, 1711, 1783, ),
         ( 1710, 1783, 1782, ),
         ( 1711, 1712, 1784, ),
         ( 1711, 1784, 1783, ),
         ( 1712, 1713, 1785, ),
         ( 1712, 1785, 1784, ),
         ( 1713, 1714, 1786, ),
         ( 1713, 1786, 1785, ),
         ( 1714, 1715, 1787, ),
         ( 1714, 1787, 1786, ),
         ( 1715, 1716, 1788, ),
         ( 1715, 1788, 1787, ),
         ( 1716, 1717, 1789, ),
         ( 1716, 1789, 1788, ),
         ( 1717, 1718, 1790, ),
         ( 1717, 1790, 1789, ),
         ( 1718, 1719, 1791, ),
         ( 1718, 1791, 1790, ),
         ( 1719, 1720, 1792, ),
         ( 1719, 1792, 1791, ),
         ( 1720, 1721, 1793, ),
         ( 1720, 1793, 1792, ),
         ( 1721, 1722, 1794, ),
         ( 1721, 1794, 1793, ),
         ( 1722, 1723, 1795, ),
         ( 1722, 1795, 1794, ),
         ( 1723, 1724, 1796, ),
         ( 1723, 1796, 1795, ),
         ( 1724, 1725, 1797, ),
         ( 1724, 1797, 1796, ),
         ( 1725, 1726, 1798, ),
         ( 1725, 1798, 1797, ),
         ( 1726, 1727, 1799, ),
         ( 1726, 1799, 1798, ),
         ( 1727, 1656, 1728, ),
         ( 1727, 1728, 1799, ),
         ( 1728, 1729, 1800, ),
         ( 1729, 1801, 1800, ),
         ( 1729, 1730, 1801, ),
         ( 1730, 1802, 1801, ),
         ( 1730, 1731, 1802, ),
         ( 1731, 1803, 1802, ),
         ( 1731, 1732, 1803, ),
         ( 1732, 1804, 1803, ),
         ( 1732, 1733, 1804, ),
         ( 1733, 1805, 1804, ),
         ( 1733, 1734, 1805, ),
         ( 1734, 1806, 1805, ),
         ( 1734, 1735, 1806, ),
         ( 1735, 1807, 1806, ),
         ( 1735, 1736, 1807, ),
         ( 1736, 1808, 1807, ),
         ( 1736, 1737, 1808, ),
         ( 1737, 1809, 1808, ),
         ( 1737, 1738, 1809, ),
         ( 1738, 1810, 1809, ),
         ( 1738, 1739, 1810, ),
         ( 1739, 1811, 1810, ),
         ( 1739, 1740, 1811, ),
         ( 1740, 1812, 1811, ),
         ( 1740, 1741, 1812, ),
         ( 1741, 1813, 1812, ),
         ( 1741, 1742, 1813, ),
         ( 1742, 1814, 1813, ),
         ( 1742, 1743, 1814, ),
         ( 1743, 1815, 1814, ),
         ( 1743, 1744, 1815, ),
         ( 1744, 1816, 1815, ),
         ( 1744, 1745, 1816, ),
         ( 1745, 1817, 1816, ),
         ( 1745, 1746, 1817, ),
         ( 1746, 1818, 1817, ),
         ( 1746, 1747, 1818, ),
         ( 1747, 1819, 1818, ),
         ( 1747, 1748, 1819, ),
         ( 1748, 1820, 1819, ),
         ( 1748, 1749, 1820, ),
         ( 1749, 1821, 1820, ),
         ( 1749, 1750, 1821, ),
         ( 1750, 1822, 1821, ),
         ( 1750, 1751, 1822, ),
         ( 1751, 1823, 1822, ),
         ( 1751, 1752, 1823, ),
         ( 1752, 1824, 1823, ),
         ( 1752, 1753, 1824, ),
         ( 1753, 1825, 1824, ),
         ( 1753, 1754, 1825, ),
         ( 1754, 1826, 1825, ),
         ( 1754, 1755, 1826, ),
         ( 1755, 1827, 1826, ),
         ( 1755, 1756, 1827, ),
         ( 1756, 1828, 1827, ),
         ( 1756, 1757, 1828, ),
         ( 1757, 1829, 1828, ),
         ( 1757, 1758, 1829, ),
         ( 1758, 1830, 1829, ),
         ( 1758, 1759, 1830, ),
         ( 1759, 1831, 1830, ),
         ( 1759, 1760, 1831, ),
         ( 1760, 1832, 1831, ),
         ( 1760, 1761, 1832, ),
         ( 1761, 1833, 1832, ),
         ( 1761, 1762, 1833, ),
         ( 1762, 1834, 1833, ),
         ( 1762, 1763, 1834, ),
         ( 1763, 1835, 1834, ),
         ( 1763, 1764, 1835, ),
         ( 1764, 1836, 1835, ),
         ( 1764, 1765, 1836, ),
         ( 1765, 1837, 1836, ),
         ( 1765, 1766, 1837, ),
         ( 1766, 1838, 1837, ),
         ( 1766, 1767, 1838, ),
         ( 1767, 1839, 1838, ),
         ( 1767, 1768, 1839, ),
         ( 1768, 1840, 1839, ),
         ( 1768, 1769, 1840, ),
         ( 1769, 1841, 1840, ),
         ( 1769, 1770, 1841, ),
         ( 1770, 1842, 1841, ),
         ( 1770, 1771, 1842, ),
         ( 1771, 1843, 1842, ),
         ( 1771, 1772, 1843, ),
         ( 1772, 1844, 1843, ),
         ( 1772, 1773, 1844, ),
         ( 1773, 1845, 1844, ),
         ( 1773, 1774, 1845, ),
         ( 1774, 1846, 1845, ),
         ( 1774, 1775, 1846, ),
         ( 1775, 1847, 1846, ),
         ( 1775, 1776, 1847, ),
         ( 1776, 1848, 1847, ),
         ( 1776, 1777, 1848, ),
         ( 1777, 1849, 1848, ),
         ( 1777, 1778, 1849, ),
         ( 1778, 1850, 1849, ),
         ( 1778, 1779, 1850, ),
         ( 1779, 1851, 1850, ),
         ( 1779, 1780, 1851, ),
         ( 1780, 1852, 1851, ),
         ( 1780, 1781, 1852, ),
         ( 1781, 1853, 1852, ),
         ( 1781, 1782, 1853, ),
         ( 1782, 1854, 1853, ),
         ( 1782, 1783, 1854, ),
         ( 1783, 1855, 1854, ),
         ( 1783, 1784, 1855, ),
         ( 1784, 1856, 1855, ),
         ( 1784, 1785, 1856, ),
         ( 1785, 1857, 1856, ),
         ( 1785, 1786, 1857, ),
         ( 1786, 1858, 1857, ),
         ( 1786, 1787, 1858, ),
         ( 1787, 1859, 1858, ),
         ( 1787, 1788, 1859, ),
         ( 1788, 1860, 1859, ),
         ( 1788, 1789, 1860, ),
         ( 1789, 1861, 1860, ),
         ( 1789, 1790, 1861, ),
         ( 1790, 1862, 1861, ),
         ( 1790, 1791, 1862, ),
         ( 1791, 1863, 1862, ),
         ( 1791, 1792, 1863, ),
         ( 1792, 1864, 1863, ),
         ( 1792, 1793, 1864, ),
         ( 1793, 1865, 1864, ),
         ( 1793, 1794, 1865, ),
         ( 1794, 1866, 1865, ),
         ( 1794, 1795, 1866, ),
         ( 1795, 1867, 1866, ),
         ( 1795, 1796, 1867, ),
         ( 1796, 1868, 1867, ),
         ( 1796, 1797, 1868, ),
         ( 1797, 1869, 1868, ),
         ( 1797, 1798, 1869, ),
         ( 1798, 1870, 1869, ),
         ( 1798, 1799, 1870, ),
         ( 1799, 1871, 1870, ),
         ( 1799, 1728, 1871, ),
         ( 1728, 1800, 1871, ),
         ( 1800, 1801, 1873, ),
         ( 1800, 1873, 1872, ),
         ( 1801, 1802, 1874, ),
         ( 1801, 1874, 1873, ),
         ( 1802, 1803, 1875, ),
         ( 1802, 1875, 1874, ),
         ( 1803, 1804, 1876, ),
         ( 1803, 1876, 1875, ),
         ( 1804, 1805, 1877, ),
         ( 1804, 1877, 1876, ),
         ( 1805, 1806, 1878, ),
         ( 1805, 1878, 1877, ),
         ( 1806, 1807, 1879, ),
         ( 1806, 1879, 1878, ),
         ( 1807, 1808, 1880, ),
         ( 1807, 1880, 1879, ),
         ( 1808, 1809, 1881, ),
         ( 1808, 1881, 1880, ),
         ( 1809, 1810, 1882, ),
         ( 1809, 1882, 1881, ),
         ( 1810, 1811, 1883, ),
         ( 1810, 1883, 1882, ),
         ( 1811, 1812, 1884, ),
         ( 1811, 1884, 1883, ),
         ( 1812, 1813, 1885, ),
         ( 1812, 1885, 1884, ),
         ( 1813, 1814, 1886, ),
         ( 1813, 1886, 1885, ),
         ( 1814, 1815, 1887, ),
         ( 1814, 1887, 1886, ),
         ( 1815, 1816, 1888, ),
         ( 1815, 1888, 1887, ),
         ( 1816, 1817, 1889, ),
         ( 1816, 1889, 1888, ),
         ( 1817, 1818, 1890, ),
         ( 1817, 1890, 1889, ),
         ( 1818, 1819, 1891, ),
         ( 1818, 1891, 1890, ),
         ( 1819, 1820, 1892, ),
         ( 1819, 1892, 1891, ),
         ( 1820, 1821, 1893, ),
         ( 1820, 1893, 1892, ),
         ( 1821, 1822, 1894, ),
         ( 1821, 1894, 1893, ),
         ( 1822, 1823, 1895, ),
         ( 1822, 1895, 1894, ),
         ( 1823, 1824, 1896, ),
         ( 1823, 1896, 1895, ),
         ( 1824, 1825, 1897, ),
         ( 1824, 1897, 1896, ),
         ( 1825, 1826, 1898, ),
         ( 1825, 1898, 1897, ),
         ( 1826, 1827, 1899, ),
         ( 1826, 1899, 1898, ),
         ( 1827, 1828, 1900, ),
         ( 1827, 1900, 1899, ),
         ( 1828, 1829, 1901, ),
         ( 1828, 1901, 1900, ),
         ( 1829, 1830, 1902, ),
         ( 1829, 1902, 1901, ),
         ( 1830, 1831, 1903, ),
         ( 1830, 1903, 1902, ),
         ( 1831, 1832, 1904, ),
         ( 1831, 1904, 1903, ),
         ( 1832, 1833, 1905, ),
         ( 1832, 1905, 1904, ),
         ( 1833, 1834, 1906, ),
         ( 1833, 1906, 1905, ),
         ( 1834, 1835, 1907, ),
         ( 1834, 1907, 1906, ),
         ( 1835, 1836, 1908, ),
         ( 1835, 1908, 1907, ),
         ( 1836, 1837, 1909, ),
         ( 1836, 1909, 1908, ),
         ( 1837, 1838, 1910, ),
         ( 1837, 1910, 1909, ),
         ( 1838, 1839, 1911, ),
         ( 1838, 1911, 1910, ),
         ( 1839, 1840, 1912, ),
         ( 1839, 1912, 1911, ),
         ( 1840, 1841, 1913, ),
         ( 1840, 1913, 1912, ),
         ( 1841, 1842, 1914, ),
         ( 1841, 1914, 1913, ),
         ( 1842, 1843, 1915, ),
         ( 1842, 1915, 1914, ),
         ( 1843, 1844, 1916, ),
         ( 1843, 1916, 1915, ),
         ( 1844, 1845, 1917, ),
         ( 1844, 1917, 1916, ),
         ( 1845, 1846, 1918, ),
         ( 1845, 1918, 1917, ),
         ( 1846, 1847, 1919, ),
         ( 1846, 1919, 1918, ),
         ( 1847, 1848, 1920, ),
         ( 1847, 1920, 1919, ),
         ( 1848, 1849, 1921, ),
         ( 1848, 1921, 1920, ),
         ( 1849, 1850, 1922, ),
         ( 1849, 1922, 1921, ),
         ( 1850, 1851, 1923, ),
         ( 1850, 1923, 1922, ),
         ( 1851, 1852, 1924, ),
         ( 1851, 1924, 1923, ),
         ( 1852, 1853, 1925, ),
         ( 1852, 1925, 1924, ),
         ( 1853, 1854, 1926, ),
         ( 1853, 1926, 1925, ),
         ( 1854, 1855, 1927, ),
         ( 1854, 1927, 1926, ),
         ( 1855, 1856, 1928, ),
         ( 1855, 1928, 1927, ),
         ( 1856, 1857, 1929, ),
         ( 1856, 1929, 1928, ),
         ( 1857, 1858, 1930, ),
         ( 1857, 1930, 1929, ),
         ( 1858, 1859, 1931, ),
         ( 1858, 1931, 1930, ),
         ( 1859, 1860, 1932, ),
         ( 1859, 1932, 1931, ),
         ( 1860, 1861, 1933, ),
         ( 1860, 1933, 1932, ),
         ( 1861, 1862, 1934, ),
         ( 1861, 1934, 1933, ),
         ( 1862, 1863, 1935, ),
         ( 1862, 1935, 1934, ),
         ( 1863, 1864, 1936, ),
         ( 1863, 1936, 1935, ),
         ( 1864, 1865, 1937, ),
         ( 1864, 1937, 1936, ),
         ( 1865, 1866, 1938, ),
         ( 1865, 1938, 1937, ),
         ( 1866, 1867, 1939, ),
         ( 1866, 1939, 1938, ),
         ( 1867, 1868, 1940, ),
         ( 1867, 1940, 1939, ),
         ( 1868, 1869, 1941, ),
         ( 1868, 1941, 1940, ),
         ( 1869, 1870, 1942, ),
         ( 1869, 1942, 1941, ),
         ( 1870, 1871, 1943, ),
         ( 1870, 1943, 1942, ),
         ( 1871, 1800, 1872, ),
         ( 1871, 1872, 1943, ),
         ( 1872, 1873, 1944, ),
         ( 1873, 1945, 1944, ),
         ( 1873, 1874, 1945, ),
         ( 1874, 1946, 1945, ),
         ( 1874, 1875, 1946, ),
         ( 1875, 1947, 1946, ),
         ( 1875, 1876, 1947, ),
         ( 1876, 1948, 1947, ),
         ( 1876, 1877, 1948, ),
         ( 1877, 1949, 1948, ),
         ( 1877, 1878, 1949, ),
         ( 1878, 1950, 1949, ),
         ( 1878, 1879, 1950, ),
         ( 1879, 1951, 1950, ),
         ( 1879, 1880, 1951, ),
         ( 1880, 1952, 1951, ),
         ( 1880, 1881, 1952, ),
         ( 1881, 1953, 1952, ),
         ( 1881, 1882, 1953, ),
         ( 1882, 1954, 1953, ),
         ( 1882, 1883, 1954, ),
         ( 1883, 1955, 1954, ),
         ( 1883, 1884, 1955, ),
         ( 1884, 1956, 1955, ),
         ( 1884, 1885, 1956, ),
         ( 1885, 1957, 1956, ),
         ( 1885, 1886, 1957, ),
         ( 1886, 1958, 1957, ),
         ( 1886, 1887, 1958, ),
         ( 1887, 1959, 1958, ),
         ( 1887, 1888, 1959, ),
         ( 1888, 1960, 1959, ),
         ( 1888, 1889, 1960, ),
         ( 1889, 1961, 1960, ),
         ( 1889, 1890, 1961, ),
         ( 1890, 1962, 1961, ),
         ( 1890, 1891, 1962, ),
         ( 1891, 1963, 1962, ),
         ( 1891, 1892, 1963, ),
         ( 1892, 1964, 1963, ),
         ( 1892, 1893, 1964, ),
         ( 1893, 1965, 1964, ),
         ( 1893, 1894, 1965, ),
         ( 1894, 1966, 1965, ),
         ( 1894, 1895, 1966, ),
         ( 1895, 1967, 1966, ),
         ( 1895, 1896, 1967, ),
         ( 1896, 1968, 1967, ),
         ( 1896, 1897, 1968, ),
         ( 1897, 1969, 1968, ),
         ( 1897, 1898, 1969, ),
         ( 1898, 1970, 1969, ),
         ( 1898, 1899, 1970, ),
         ( 1899, 1971, 1970, ),
         ( 1899, 1900, 1971, ),
         ( 1900, 1972, 1971, ),
         ( 1900, 1901, 1972, ),
         ( 1901, 1973, 1972, ),
         ( 1901, 1902, 1973, ),
         ( 1902, 1974, 1973, ),
         ( 1902, 1903, 1974, ),
         ( 1903, 1975, 1974, ),
         ( 1903, 1904, 1975, ),
         ( 1904, 1976, 1975, ),
         ( 1904, 1905, 1976, ),
         ( 1905, 1977, 1976, ),
         ( 1905, 1906, 1977, ),
         ( 1906, 1978, 1977, ),
         ( 1906, 1907, 1978, ),
         ( 1907, 1979, 1978, ),
         ( 1907, 1908, 1979, ),
         ( 1908, 1980, 1979, ),
         ( 1908, 1909, 1980, ),
         ( 1909, 1981, 1980, ),
         ( 1909, 1910, 1981, ),
         ( 1910, 1982, 1981, ),
         ( 1910, 1911, 1982, ),
         ( 1911, 1983, 1982, ),
         ( 1911, 1912, 1983, ),
         ( 1912, 1984, 1983, ),
         ( 1912, 1913, 1984, ),
         ( 1913, 1985, 1984, ),
         ( 1913, 1914, 1985, ),
         ( 1914, 1986, 1985, ),
         ( 1914, 1915, 1986, ),
         ( 1915, 1987, 1986, ),
         ( 1915, 1916, 1987, ),
         ( 1916, 1988, 1987, ),
         ( 1916, 1917, 1988, ),
         ( 1917, 1989, 1988, ),
         ( 1917, 1918, 1989, ),
         ( 1918, 1990, 1989, ),
         ( 1918, 1919, 1990, ),
         ( 1919, 1991, 1990, ),
         ( 1919, 1920, 1991, ),
         ( 1920, 1992, 1991, ),
         ( 1920, 1921, 1992, ),
         ( 1921, 1993, 1992, ),
         ( 1921, 1922, 1993, ),
         ( 1922, 1994, 1993, ),
         ( 1922, 1923, 1994, ),
         ( 1923, 1995, 1994, ),
         ( 1923, 1924, 1995, ),
         ( 1924, 1996, 1995, ),
         ( 1924, 1925, 1996, ),
         ( 1925, 1997, 1996, ),
         ( 1925, 1926, 1997, ),
         ( 1926, 1998, 1997, ),
         ( 1926, 1927, 1998, ),
         ( 1927, 1999, 1998, ),
         ( 1927, 1928, 1999, ),
         ( 1928, 2000, 1999, ),
         ( 1928, 1929, 2000, ),
         ( 1929, 2001, 2000, ),
         ( 1929, 1930, 2001, ),
         ( 1930, 2002, 2001, ),
         ( 1930, 1931, 2002, ),
         ( 1931, 2003, 2002, ),
         ( 1931, 1932, 2003, ),
         ( 1932, 2004, 2003, ),
         ( 1932, 1933, 2004, ),
         ( 1933, 2005, 2004, ),
         ( 1933, 1934, 2005, ),
         ( 1934, 2006, 2005, ),
         ( 1934, 1935, 2006, ),
         ( 1935, 2007, 2006, ),
         ( 1935, 1936, 2007, ),
         ( 1936, 2008, 2007, ),
         ( 1936, 1937, 2008, ),
         ( 1937, 2009, 2008, ),
         ( 1937, 1938, 2009, ),
         ( 1938, 2010, 2009, ),
         ( 1938, 1939, 2010, ),
         ( 1939, 2011, 2010, ),
         ( 1939, 1940, 2011, ),
         ( 1940, 2012, 2011, ),
         ( 1940, 1941, 2012, ),
         ( 1941, 2013, 2012, ),
         ( 1941, 1942, 2013, ),
         ( 1942, 2014, 2013, ),
         ( 1942, 1943, 2014, ),
         ( 1943, 2015, 2014, ),
         ( 1943, 1872, 2015, ),
         ( 1872, 1944, 2015, ),
         ( 1944, 1945, 2017, ),
         ( 1944, 2017, 2016, ),
         ( 1945, 1946, 2018, ),
         ( 1945, 2018, 2017, ),
         ( 1946, 1947, 2019, ),
         ( 1946, 2019, 2018, ),
         ( 1947, 1948, 2020, ),
         ( 1947, 2020, 2019, ),
         ( 1948, 1949, 2021, ),
         ( 1948, 2021, 2020, ),
         ( 1949, 1950, 2022, ),
         ( 1949, 2022, 2021, ),
         ( 1950, 1951, 2023, ),
         ( 1950, 2023, 2022, ),
         ( 1951, 1952, 2024, ),
         ( 1951, 2024, 2023, ),
         ( 1952, 1953, 2025, ),
         ( 1952, 2025, 2024, ),
         ( 1953, 1954, 2026, ),
         ( 1953, 2026, 2025, ),
         ( 1954, 1955, 2027, ),
         ( 1954, 2027, 2026, ),
         ( 1955, 1956, 2028, ),
         ( 1955, 2028, 2027, ),
         ( 1956, 1957, 2029, ),
         ( 1956, 2029, 2028, ),
         ( 1957, 1958, 2030, ),
         ( 1957, 2030, 2029, ),
         ( 1958, 1959, 2031, ),
         ( 1958, 2031, 2030, ),
         ( 1959, 1960, 2032, ),
         ( 1959, 2032, 2031, ),
         ( 1960, 1961, 2033, ),
         ( 1960, 2033, 2032, ),
         ( 1961, 1962, 2034, ),
         ( 1961, 2034, 2033, ),
         ( 1962, 1963, 2035, ),
         ( 1962, 2035, 2034, ),
         ( 1963, 1964, 2036, ),
         ( 1963, 2036, 2035, ),
         ( 1964, 1965, 2037, ),
         ( 1964, 2037, 2036, ),
         ( 1965, 1966, 2038, ),
         ( 1965, 2038, 2037, ),
         ( 1966, 1967, 2039, ),
         ( 1966, 2039, 2038, ),
         ( 1967, 1968, 2040, ),
         ( 1967, 2040, 2039, ),
         ( 1968, 1969, 2041, ),
         ( 1968, 2041, 2040, ),
         ( 1969, 1970, 2042, ),
         ( 1969, 2042, 2041, ),
         ( 1970, 1971, 2043, ),
         ( 1970, 2043, 2042, ),
         ( 1971, 1972, 2044, ),
         ( 1971, 2044, 2043, ),
         ( 1972, 1973, 2045, ),
         ( 1972, 2045, 2044, ),
         ( 1973, 1974, 2046, ),
         ( 1973, 2046, 2045, ),
         ( 1974, 1975, 2047, ),
         ( 1974, 2047, 2046, ),
         ( 1975, 1976, 2048, ),
         ( 1975, 2048, 2047, ),
         ( 1976, 1977, 2049, ),
         ( 1976, 2049, 2048, ),
         ( 1977, 1978, 2050, ),
         ( 1977, 2050, 2049, ),
         ( 1978, 1979, 2051, ),
         ( 1978, 2051, 2050, ),
         ( 1979, 1980, 2052, ),
         ( 1979, 2052, 2051, ),
         ( 1980, 1981, 2053, ),
         ( 1980, 2053, 2052, ),
         ( 1981, 1982, 2054, ),
         ( 1981, 2054, 2053, ),
         ( 1982, 1983, 2055, ),
         ( 1982, 2055, 2054, ),
         ( 1983, 1984, 2056, ),
         ( 1983, 2056, 2055, ),
         ( 1984, 1985, 2057, ),
         ( 1984, 2057, 2056, ),
         ( 1985, 1986, 2058, ),
         ( 1985, 2058, 2057, ),
         ( 1986, 1987, 2059, ),
         ( 1986, 2059, 2058, ),
         ( 1987, 1988, 2060, ),
         ( 1987, 2060, 2059, ),
         ( 1988, 1989, 2061, ),
         ( 1988, 2061, 2060, ),
         ( 1989, 1990, 2062, ),
         ( 1989, 2062, 2061, ),
         ( 1990, 1991, 2063, ),
         ( 1990, 2063, 2062, ),
         ( 1991, 1992, 2064, ),
         ( 1991, 2064, 2063, ),
         ( 1992, 1993, 2065, ),
         ( 1992, 2065, 2064, ),
         ( 1993, 1994, 2066, ),
         ( 1993, 2066, 2065, ),
         ( 1994, 1995, 2067, ),
         ( 1994, 2067, 2066, ),
         ( 1995, 1996, 2068, ),
         ( 1995, 2068, 2067, ),
         ( 1996, 1997, 2069, ),
         ( 1996, 2069, 2068, ),
         ( 1997, 1998, 2070, ),
         ( 1997, 2070, 2069, ),
         ( 1998, 1999, 2071, ),
         ( 1998, 2071, 2070, ),
         ( 1999, 2000, 2072, ),
         ( 1999, 2072, 2071, ),
         ( 2000, 2001, 2073, ),
         ( 2000, 2073, 2072, ),
         ( 2001, 2002, 2074, ),
         ( 2001, 2074, 2073, ),
         ( 2002, 2003, 2075, ),
         ( 2002, 2075, 2074, ),
         ( 2003, 2004, 2076, ),
         ( 2003, 2076, 2075, ),
         ( 2004, 2005, 2077, ),
         ( 2004, 2077, 2076, ),
         ( 2005, 2006, 2078, ),
         ( 2005, 2078, 2077, ),
         ( 2006, 2007, 2079, ),
         ( 2006, 2079, 2078, ),
         ( 2007, 2008, 2080, ),
         ( 2007, 2080, 2079, ),
         ( 2008, 2009, 2081, ),
         ( 2008, 2081, 2080, ),
         ( 2009, 2010, 2082, ),
         ( 2009, 2082, 2081, ),
         ( 2010, 2011, 2083, ),
         ( 2010, 2083, 2082, ),
         ( 2011, 2012, 2084, ),
         ( 2011, 2084, 2083, ),
         ( 2012, 2013, 2085, ),
         ( 2012, 2085, 2084, ),
         ( 2013, 2014, 2086, ),
         ( 2013, 2086, 2085, ),
         ( 2014, 2015, 2087, ),
         ( 2014, 2087, 2086, ),
         ( 2015, 1944, 2016, ),
         ( 2015, 2016, 2087, ),
         ( 2016, 2017, 2088, ),
         ( 2017, 2089, 2088, ),
         ( 2017, 2018, 2089, ),
         ( 2018, 2090, 2089, ),
         ( 2018, 2019, 2090, ),
         ( 2019, 2091, 2090, ),
         ( 2019, 2020, 2091, ),
         ( 2020, 2092, 2091, ),
         ( 2020, 2021, 2092, ),
         ( 2021, 2093, 2092, ),
         ( 2021, 2022, 2093, ),
         ( 2022, 2094, 2093, ),
         ( 2022, 2023, 2094, ),
         ( 2023, 2095, 2094, ),
         ( 2023, 2024, 2095, ),
         ( 2024, 2096, 2095, ),
         ( 2024, 2025, 2096, ),
         ( 2025, 2097, 2096, ),
         ( 2025, 2026, 2097, ),
         ( 2026, 2098, 2097, ),
         ( 2026, 2027, 2098, ),
         ( 2027, 2099, 2098, ),
         ( 2027, 2028, 2099, ),
         ( 2028, 2100, 2099, ),
         ( 2028, 2029, 2100, ),
         ( 2029, 2101, 2100, ),
         ( 2029, 2030, 2101, ),
         ( 2030, 2102, 2101, ),
         ( 2030, 2031, 2102, ),
         ( 2031, 2103, 2102, ),
         ( 2031, 2032, 2103, ),
         ( 2032, 2104, 2103, ),
         ( 2032, 2033, 2104, ),
         ( 2033, 2105, 2104, ),
         ( 2033, 2034, 2105, ),
         ( 2034, 2106, 2105, ),
         ( 2034, 2035, 2106, ),
         ( 2035, 2107, 2106, ),
         ( 2035, 2036, 2107, ),
         ( 2036, 2108, 2107, ),
         ( 2036, 2037, 2108, ),
         ( 2037, 2109, 2108, ),
         ( 2037, 2038, 2109, ),
         ( 2038, 2110, 2109, ),
         ( 2038, 2039, 2110, ),
         ( 2039, 2111, 2110, ),
         ( 2039, 2040, 2111, ),
         ( 2040, 2112, 2111, ),
         ( 2040, 2041, 2112, ),
         ( 2041, 2113, 2112, ),
         ( 2041, 2042, 2113, ),
         ( 2042, 2114, 2113, ),
         ( 2042, 2043, 2114, ),
         ( 2043, 2115, 2114, ),
         ( 2043, 2044, 2115, ),
         ( 2044, 2116, 2115, ),
         ( 2044, 2045, 2116, ),
         ( 2045, 2117, 2116, ),
         ( 2045, 2046, 2117, ),
         ( 2046, 2118, 2117, ),
         ( 2046, 2047, 2118, ),
         ( 2047, 2119, 2118, ),
         ( 2047, 2048, 2119, ),
         ( 2048, 2120, 2119, ),
         ( 2048, 2049, 2120, ),
         ( 2049, 2121, 2120, ),
         ( 2049, 2050, 2121, ),
         ( 2050, 2122, 2121, ),
         ( 2050, 2051, 2122, ),
         ( 2051, 2123, 2122, ),
         ( 2051, 2052, 2123, ),
         ( 2052, 2124, 2123, ),
         ( 2052, 2053, 2124, ),
         ( 2053, 2125, 2124, ),
         ( 2053, 2054, 2125, ),
         ( 2054, 2126, 2125, ),
         ( 2054, 2055, 2126, ),
         ( 2055, 2127, 2126, ),
         ( 2055, 2056, 2127, ),
         ( 2056, 2128, 2127, ),
         ( 2056, 2057, 2128, ),
         ( 2057, 2129, 2128, ),
         ( 2057, 2058, 2129, ),
         ( 2058, 2130, 2129, ),
         ( 2058, 2059, 2130, ),
         ( 2059, 2131, 2130, ),
         ( 2059, 2060, 2131, ),
         ( 2060, 2132, 2131, ),
         ( 2060, 2061, 2132, ),
         ( 2061, 2133, 2132, ),
         ( 2061, 2062, 2133, ),
         ( 2062, 2134, 2133, ),
         ( 2062, 2063, 2134, ),
         ( 2063, 2135, 2134, ),
         ( 2063, 2064, 2135, ),
         ( 2064, 2136, 2135, ),
         ( 2064, 2065, 2136, ),
         ( 2065, 2137, 2136, ),
         ( 2065, 2066, 2137, ),
         ( 2066, 2138, 2137, ),
         ( 2066, 2067, 2138, ),
         ( 2067, 2139, 2138, ),
         ( 2067, 2068, 2139, ),
         ( 2068, 2140, 2139, ),
         ( 2068, 2069, 2140, ),
         ( 2069, 2141, 2140, ),
         ( 2069, 2070, 2141, ),
         ( 2070, 2142, 2141, ),
         ( 2070, 2071, 2142, ),
         ( 2071, 2143, 2142, ),
         ( 2071, 2072, 2143, ),
         ( 2072, 2144, 2143, ),
         ( 2072, 2073, 2144, ),
         ( 2073, 2145, 2144, ),
         ( 2073, 2074, 2145, ),
         ( 2074, 2146, 2145, ),
         ( 2074, 2075, 2146, ),
         ( 2075, 2147, 2146, ),
         ( 2075, 2076, 2147, ),
         ( 2076, 2148, 2147, ),
         ( 2076, 2077, 2148, ),
         ( 2077, 2149, 2148, ),
         ( 2077, 2078, 2149, ),
         ( 2078, 2150, 2149, ),
         ( 2078, 2079, 2150, ),
         ( 2079, 2151, 2150, ),
         ( 2079, 2080, 2151, ),
         ( 2080, 2152, 2151, ),
         ( 2080, 2081, 2152, ),
         ( 2081, 2153, 2152, ),
         ( 2081, 2082, 2153, ),
         ( 2082, 2154, 2153, ),
         ( 2082, 2083, 2154, ),
         ( 2083, 2155, 2154, ),
         ( 2083, 2084, 2155, ),
         ( 2084, 2156, 2155, ),
         ( 2084, 2085, 2156, ),
         ( 2085, 2157, 2156, ),
         ( 2085, 2086, 2157, ),
         ( 2086, 2158, 2157, ),
         ( 2086, 2087, 2158, ),
         ( 2087, 2159, 2158, ),
         ( 2087, 2016, 2159, ),
         ( 2016, 2088, 2159, ),
         ( 2160, 1, 0, ),
         ( 2160, 2, 1, ),
         ( 2160, 3, 2, ),
         ( 2160, 4, 3, ),
         ( 2160, 5, 4, ),
         ( 2160, 6, 5, ),
         ( 2160, 7, 6, ),
         ( 2160, 8, 7, ),
         ( 2160, 9, 8, ),
         ( 2160, 10, 9, ),
         ( 2160, 11, 10, ),
         ( 2160, 12, 11, ),
         ( 2160, 13, 12, ),
         ( 2160, 14, 13, ),
         ( 2160, 15, 14, ),
         ( 2160, 16, 15, ),
         ( 2160, 17, 16, ),
         ( 2160, 18, 17, ),
         ( 2160, 19, 18, ),
         ( 2160, 20, 19, ),
         ( 2160, 21, 20, ),
         ( 2160, 22, 21, ),
         ( 2160, 23, 22, ),
         ( 2160, 24, 23, ),
         ( 2160, 25, 24, ),
         ( 2160, 26, 25, ),
         ( 2160, 27, 26, ),
         ( 2160, 28, 27, ),
         ( 2160, 29, 28, ),
         ( 2160, 30, 29, ),
         ( 2160, 31, 30, ),
         ( 2160, 32, 31, ),
         ( 2160, 33, 32, ),
         ( 2160, 34, 33, ),
         ( 2160, 35, 34, ),
         ( 2160, 36, 35, ),
         ( 2160, 37, 36, ),
         ( 2160, 38, 37, ),
         ( 2160, 39, 38, ),
         ( 2160, 40, 39, ),
         ( 2160, 41, 40, ),
         ( 2160, 42, 41, ),
         ( 2160, 43, 42, ),
         ( 2160, 44, 43, ),
         ( 2160, 45, 44, ),
         ( 2160, 46, 45, ),
         ( 2160, 47, 46, ),
         ( 2160, 48, 47, ),
         ( 2160, 49, 48, ),
         ( 2160, 50, 49, ),
         ( 2160, 51, 50, ),
         ( 2160, 52, 51, ),
         ( 2160, 53, 52, ),
         ( 2160, 54, 53, ),
         ( 2160, 55, 54, ),
         ( 2160, 56, 55, ),
         ( 2160, 57, 56, ),
         ( 2160, 58, 57, ),
         ( 2160, 59, 58, ),
         ( 2160, 60, 59, ),
         ( 2160, 61, 60, ),
         ( 2160, 62, 61, ),
         ( 2160, 63, 62, ),
         ( 2160, 64, 63, ),
         ( 2160, 65, 64, ),
         ( 2160, 66, 65, ),
         ( 2160, 67, 66, ),
         ( 2160, 68, 67, ),
         ( 2160, 69, 68, ),
         ( 2160, 70, 69, ),
         ( 2160, 71, 70, ),
         ( 2160, 0, 71, ),
         ( 2161, 2088, 2089, ),
         ( 2161, 2089, 2090, ),
         ( 2161, 2090, 2091, ),
         ( 2161, 2091, 2092, ),
         ( 2161, 2092, 2093, ),
         ( 2161, 2093, 2094, ),
         ( 2161, 2094, 2095, ),
         ( 2161, 2095, 2096, ),
         ( 2161, 2096, 2097, ),
         ( 2161, 2097, 2098, ),
         ( 2161, 2098, 2099, ),
         ( 2161, 2099, 2100, ),
         ( 2161, 2100, 2101, ),
         ( 2161, 2101, 2102, ),
         ( 2161, 2102, 2103, ),
         ( 2161, 2103, 2104, ),
         ( 2161, 2104, 2105, ),
         ( 2161, 2105, 2106, ),
         ( 2161, 2106, 2107, ),
         ( 2161, 2107, 2108, ),
         ( 2161, 2108, 2109, ),
         ( 2161, 2109, 2110, ),
         ( 2161, 2110, 2111, ),
         ( 2161, 2111, 2112, ),
         ( 2161, 2112, 2113, ),
         ( 2161, 2113, 2114, ),
         ( 2161, 2114, 2115, ),
         ( 2161, 2115, 2116, ),
         ( 2161, 2116, 2117, ),
         ( 2161, 2117, 2118, ),
         ( 2161, 2118, 2119, ),
         ( 2161, 2119, 2120, ),
         ( 2161, 2120, 2121, ),
         ( 2161, 2121, 2122, ),
         ( 2161, 2122, 2123, ),
         ( 2161, 2123, 2124, ),
         ( 2161, 2124, 2125, ),
         ( 2161, 2125, 2126, ),
         ( 2161, 2126, 2127, ),
         ( 2161, 2127, 2128, ),
         ( 2161, 2128, 2129, ),
         ( 2161, 2129, 2130, ),
         ( 2161, 2130, 2131, ),
         ( 2161, 2131, 2132, ),
         ( 2161, 2132, 2133, ),
         ( 2161, 2133, 2134, ),
         ( 2161, 2134, 2135, ),
         ( 2161, 2135, 2136, ),
         ( 2161, 2136, 2137, ),
         ( 2161, 2137, 2138, ),
         ( 2161, 2138, 2139, ),
         ( 2161, 2139, 2140, ),
         ( 2161, 2140, 2141, ),
         ( 2161, 2141, 2142, ),
         ( 2161, 2142, 2143, ),
         ( 2161, 2143, 2144, ),
         ( 2161, 2144, 2145, ),
         ( 2161, 2145, 2146, ),
         ( 2161, 2146, 2147, ),
         ( 2161, 2147, 2148, ),
         ( 2161, 2148, 2149, ),
         ( 2161, 2149, 2150, ),
         ( 2161, 2150, 2151, ),
         ( 2161, 2151, 2152, ),
         ( 2161, 2152, 2153, ),
         ( 2161, 2153, 2154, ),
         ( 2161, 2154, 2155, ),
         ( 2161, 2155, 2156, ),
         ( 2161, 2156, 2157, ),
         ( 2161, 2157, 2158, ),
         ( 2161, 2158, 2159, ),
         ( 2161, 2159, 2088, ),
        ],
       'twoSidedLighting': True,
       'useLighting': True,
       'version': 2,
       'vertices': [
         (
          8.5,
          0.0,
          -9.5,
         ),
         (
          8.4676552,
          0.74082381,
          -9.5,
         ),
         (
          8.3708658,
          1.4760095,
          -9.5,
         ),
         (
          8.2103691,
          2.1999619,
          -9.5,
         ),
         (
          7.9873872,
          2.9071712,
          -9.5,
         ),
         (
          7.7036166,
          3.5922554,
          -9.5,
         ),
         (
          7.3612156,
          4.25,
          -9.5,
         ),
         (
          6.9627924,
          4.8753996,
          -9.5,
         ),
         (
          6.5113778,
          5.463695,
          -9.5,
         ),
         (
          6.0104074,
          6.0104074,
          -9.5,
         ),
         (
          5.463695,
          6.5113778,
          -9.5,
         ),
         (
          4.8753996,
          6.9627924,
          -9.5,
         ),
         (
          4.25,
          7.3612156,
          -9.5,
         ),
         (
          3.5922554,
          7.7036166,
          -9.5,
         ),
         (
          2.9071712,
          7.9873872,
          -9.5,
         ),
         (
          2.1999619,
          8.2103691,
          -9.5,
         ),
         (
          1.4760095,
          8.3708658,
          -9.5,
         ),
         (
          0.74082381,
          8.4676552,
          -9.5,
         ),
         (
          5.2047491e-16,
          8.5,
          -9.5,
         ),
         (
          -0.74082381,
          8.4676552,
          -9.5,
         ),
         (
          -1.4760095,
          8.3708658,
          -9.5,
         ),
         (
          -2.1999619,
          8.2103691,
          -9.5,
         ),
         (
          -2.9071712,
          7.9873872,
          -9.5,
         ),
         (
          -3.5922554,
          7.7036166,
          -9.5,
         ),
         (
          -4.25,
          7.3612156,
          -9.5,
         ),
         (
          -4.8753996,
          6.9627924,
          -9.5,
         ),
         (
          -5.463695,
          6.5113778,
          -9.5,
         ),
         (
          -6.0104074,
          6.0104074,
          -9.5,
         ),
         (
          -6.5113778,
          5.463695,
          -9.5,
         ),
         (
          -6.9627924,
          4.8753996,
          -9.5,
         ),
         (
          -7.3612156,
          4.25,
          -9.5,
         ),
         (
          -7.7036166,
          3.5922554,
          -9.5,
         ),
         (
          -7.9873872,
          2.9071712,
          -9.5,
         ),
         (
          -8.2103691,
          2.1999619,
          -9.5,
         ),
         (
          -8.3708658,
          1.4760095,
          -9.5,
         ),
         (
          -8.4676552,
          0.74082381,
          -9.5,
         ),
         (
          -8.5,
          1.0409498e-15,
          -9.5,
         ),
         (
          -8.4676552,
          -0.74082381,
          -9.5,
         ),
         (
          -8.3708658,
          -1.4760095,
          -9.5,
         ),
         (
          -8.2103691,
          -2.1999619,
          -9.5,
         ),
         (
          -7.9873872,
          -2.9071712,
          -9.5,
         ),
         (
          -7.7036166,
          -3.5922554,
          -9.5,
         ),
         (
          -7.3612156,
          -4.25,
          -9.5,
         ),
         (
          -6.9627924,
          -4.8753996,
          -9.5,
         ),
         (
          -6.5113778,
          -5.463695,
          -9.5,
         ),
         (
          -6.0104074,
          -6.0104074,
          -9.5,
         ),
         (
          -5.463695,
          -6.5113778,
          -9.5,
         ),
         (
          -4.8753996,
          -6.9627924,
          -9.5,
         ),
         (
          -4.25,
          -7.3612156,
          -9.5,
         ),
         (
          -3.5922554,
          -7.7036166,
          -9.5,
         ),
         (
          -2.9071712,
          -7.9873872,
          -9.5,
         ),
         (
          -2.1999619,
          -8.2103691,
          -9.5,
         ),
         (
          -1.4760095,
          -8.3708658,
          -9.5,
         ),
         (
          -0.74082381,
          -8.4676552,
          -9.5,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -9.5,
         ),
         (
          0.74082381,
          -8.4676552,
          -9.5,
         ),
         (
          1.4760095,
          -8.3708658,
          -9.5,
         ),
         (
          2.1999619,
          -8.2103691,
          -9.5,
         ),
         (
          2.9071712,
          -7.9873872,
          -9.5,
         ),
         (
          3.5922554,
          -7.7036166,
          -9.5,
         ),
         (
          4.25,
          -7.3612156,
          -9.5,
         ),
         (
          4.8753996,
          -6.9627924,
          -9.5,
         ),
         (
          5.463695,
          -6.5113778,
          -9.5,
         ),
         (
          6.0104074,
          -6.0104074,
          -9.5,
         ),
         (
          6.5113778,
          -5.463695,
          -9.5,
         ),
         (
          6.9627924,
          -4.8753996,
          -9.5,
         ),
         (
          7.3612156,
          -4.25,
          -9.5,
         ),
         (
          7.7036166,
          -3.5922554,
          -9.5,
         ),
         (
          7.9873872,
          -2.9071712,
          -9.5,
         ),
         (
          8.2103691,
          -2.1999619,
          -9.5,
         ),
         (
          8.3708658,
          -1.4760095,
          -9.5,
         ),
         (
          8.4676552,
          -0.74082381,
          -9.5,
         ),
         (
          8.49191,
          0.37076479,
          -8.8448277,
         ),
         (
          8.4272814,
          1.1094725,
          -8.8448277,
         ),
         (
          8.2985163,
          1.8397368,
          -8.8448277,
         ),
         (
          8.1065941,
          2.5559993,
          -8.8448277,
         ),
         (
          7.8529758,
          3.252809,
          -8.8448277,
         ),
         (
          7.5395918,
          3.9248631,
          -8.8448277,
         ),
         (
          7.1688271,
          4.5670471,
          -8.8448277,
         ),
         (
          6.7435031,
          5.1744723,
          -8.8448277,
         ),
         (
          6.2668571,
          5.742517,
          -8.8448277,
         ),
         (
          5.742517,
          6.2668571,
          -8.8448277,
         ),
         (
          5.1744723,
          6.7435031,
          -8.8448277,
         ),
         (
          4.5670471,
          7.1688271,
          -8.8448277,
         ),
         (
          3.9248631,
          7.5395918,
          -8.8448277,
         ),
         (
          3.252809,
          7.8529758,
          -8.8448277,
         ),
         (
          2.5559993,
          8.1065941,
          -8.8448277,
         ),
         (
          1.8397368,
          8.2985163,
          -8.8448277,
         ),
         (
          1.1094725,
          8.4272814,
          -8.8448277,
         ),
         (
          0.37076479,
          8.49191,
          -8.8448277,
         ),
         (
          -0.37076479,
          8.49191,
          -8.8448277,
         ),
         (
          -1.1094725,
          8.4272814,
          -8.8448277,
         ),
         (
          -1.8397368,
          8.2985163,
          -8.8448277,
         ),
         (
          -2.5559993,
          8.1065941,
          -8.8448277,
         ),
         (
          -3.252809,
          7.8529758,
          -8.8448277,
         ),
         (
          -3.9248631,
          7.5395918,
          -8.8448277,
         ),
         (
          -4.5670471,
          7.1688271,
          -8.8448277,
         ),
         (
          -5.1744723,
          6.7435031,
          -8.8448277,
         ),
         (
          -5.742517,
          6.2668571,
          -8.8448277,
         ),
         (
          -6.2668571,
          5.742517,
          -8.8448277,
         ),
         (
          -6.7435031,
          5.1744723,
          -8.8448277,
         ),
         (
          -7.1688271,
          4.5670471,
          -8.8448277,
         ),
         (
          -7.5395918,
          3.9248631,
          -8.8448277,
         ),
         (
          -7.8529758,
          3.252809,
          -8.8448277,
         ),
         (
          -8.1065941,
          2.5559993,
          -8.8448277,
         ),
         (
          -8.2985163,
          1.8397368,
          -8.8448277,
         ),
         (
          -8.4272814,
          1.1094725,
          -8.8448277,
         ),
         (
          -8.49191,
          0.37076479,
          -8.8448277,
         ),
         (
          -8.49191,
          -0.37076479,
          -8.8448277,
         ),
         (
          -8.4272814,
          -1.1094725,
          -8.8448277,
         ),
         (
          -8.2985163,
          -1.8397368,
          -8.8448277,
         ),
         (
          -8.1065941,
          -2.5559993,
          -8.8448277,
         ),
         (
          -7.8529758,
          -3.252809,
          -8.8448277,
         ),
         (
          -7.5395918,
          -3.9248631,
          -8.8448277,
         ),
         (
          -7.1688271,
          -4.5670471,
          -8.8448277,
         ),
         (
          -6.7435031,
          -5.1744723,
          -8.8448277,
         ),
         (
          -6.2668571,
          -5.742517,
          -8.8448277,
         ),
         (
          -5.742517,
          -6.2668571,
          -8.8448277,
         ),
         (
          -5.1744723,
          -6.7435031,
          -8.8448277,
         ),
         (
          -4.5670471,
          -7.1688271,
          -8.8448277,
         ),
         (
          -3.9248631,
          -7.5395918,
          -8.8448277,
         ),
         (
          -3.252809,
          -7.8529758,
          -8.8448277,
         ),
         (
          -2.5559993,
          -8.1065941,
          -8.8448277,
         ),
         (
          -1.8397368,
          -8.2985163,
          -8.8448277,
         ),
         (
          -1.1094725,
          -8.4272814,
          -8.8448277,
         ),
         (
          -0.37076479,
          -8.49191,
          -8.8448277,
         ),
         (
          0.37076479,
          -8.49191,
          -8.8448277,
         ),
         (
          1.1094725,
          -8.4272814,
          -8.8448277,
         ),
         (
          1.8397368,
          -8.2985163,
          -8.8448277,
         ),
         (
          2.5559993,
          -8.1065941,
          -8.8448277,
         ),
         (
          3.252809,
          -7.8529758,
          -8.8448277,
         ),
         (
          3.9248631,
          -7.5395918,
          -8.8448277,
         ),
         (
          4.5670471,
          -7.1688271,
          -8.8448277,
         ),
         (
          5.1744723,
          -6.7435031,
          -8.8448277,
         ),
         (
          5.742517,
          -6.2668571,
          -8.8448277,
         ),
         (
          6.2668571,
          -5.742517,
          -8.8448277,
         ),
         (
          6.7435031,
          -5.1744723,
          -8.8448277,
         ),
         (
          7.1688271,
          -4.5670471,
          -8.8448277,
         ),
         (
          7.5395918,
          -3.9248631,
          -8.8448277,
         ),
         (
          7.8529758,
          -3.252809,
          -8.8448277,
         ),
         (
          8.1065941,
          -2.5559993,
          -8.8448277,
         ),
         (
          8.2985163,
          -1.8397368,
          -8.8448277,
         ),
         (
          8.4272814,
          -1.1094725,
          -8.8448277,
         ),
         (
          8.49191,
          -0.37076479,
          -8.8448277,
         ),
         (
          8.5,
          0.0,
          -8.1896553,
         ),
         (
          8.4676552,
          0.74082381,
          -8.1896553,
         ),
         (
          8.3708658,
          1.4760095,
          -8.1896553,
         ),
         (
          8.2103691,
          2.1999619,
          -8.1896553,
         ),
         (
          7.9873872,
          2.9071712,
          -8.1896553,
         ),
         (
          7.7036166,
          3.5922554,
          -8.1896553,
         ),
         (
          7.3612156,
          4.25,
          -8.1896553,
         ),
         (
          6.9627924,
          4.8753996,
          -8.1896553,
         ),
         (
          6.5113778,
          5.463695,
          -8.1896553,
         ),
         (
          6.0104074,
          6.0104074,
          -8.1896553,
         ),
         (
          5.463695,
          6.5113778,
          -8.1896553,
         ),
         (
          4.8753996,
          6.9627924,
          -8.1896553,
         ),
         (
          4.25,
          7.3612156,
          -8.1896553,
         ),
         (
          3.5922554,
          7.7036166,
          -8.1896553,
         ),
         (
          2.9071712,
          7.9873872,
          -8.1896553,
         ),
         (
          2.1999619,
          8.2103691,
          -8.1896553,
         ),
         (
          1.4760095,
          8.3708658,
          -8.1896553,
         ),
         (
          0.74082381,
          8.4676552,
          -8.1896553,
         ),
         (
          5.2047491e-16,
          8.5,
          -8.1896553,
         ),
         (
          -0.74082381,
          8.4676552,
          -8.1896553,
         ),
         (
          -1.4760095,
          8.3708658,
          -8.1896553,
         ),
         (
          -2.1999619,
          8.2103691,
          -8.1896553,
         ),
         (
          -2.9071712,
          7.9873872,
          -8.1896553,
         ),
         (
          -3.5922554,
          7.7036166,
          -8.1896553,
         ),
         (
          -4.25,
          7.3612156,
          -8.1896553,
         ),
         (
          -4.8753996,
          6.9627924,
          -8.1896553,
         ),
         (
          -5.463695,
          6.5113778,
          -8.1896553,
         ),
         (
          -6.0104074,
          6.0104074,
          -8.1896553,
         ),
         (
          -6.5113778,
          5.463695,
          -8.1896553,
         ),
         (
          -6.9627924,
          4.8753996,
          -8.1896553,
         ),
         (
          -7.3612156,
          4.25,
          -8.1896553,
         ),
         (
          -7.7036166,
          3.5922554,
          -8.1896553,
         ),
         (
          -7.9873872,
          2.9071712,
          -8.1896553,
         ),
         (
          -8.2103691,
          2.1999619,
          -8.1896553,
         ),
         (
          -8.3708658,
          1.4760095,
          -8.1896553,
         ),
         (
          -8.4676552,
          0.74082381,
          -8.1896553,
         ),
         (
          -8.5,
          1.0409498e-15,
          -8.1896553,
         ),
         (
          -8.4676552,
          -0.74082381,
          -8.1896553,
         ),
         (
          -8.3708658,
          -1.4760095,
          -8.1896553,
         ),
         (
          -8.2103691,
          -2.1999619,
          -8.1896553,
         ),
         (
          -7.9873872,
          -2.9071712,
          -8.1896553,
         ),
         (
          -7.7036166,
          -3.5922554,
          -8.1896553,
         ),
         (
          -7.3612156,
          -4.25,
          -8.1896553,
         ),
         (
          -6.9627924,
          -4.8753996,
          -8.1896553,
         ),
         (
          -6.5113778,
          -5.463695,
          -8.1896553,
         ),
         (
          -6.0104074,
          -6.0104074,
          -8.1896553,
         ),
         (
          -5.463695,
          -6.5113778,
          -8.1896553,
         ),
         (
          -4.8753996,
          -6.9627924,
          -8.1896553,
         ),
         (
          -4.25,
          -7.3612156,
          -8.1896553,
         ),
         (
          -3.5922554,
          -7.7036166,
          -8.1896553,
         ),
         (
          -2.9071712,
          -7.9873872,
          -8.1896553,
         ),
         (
          -2.1999619,
          -8.2103691,
          -8.1896553,
         ),
         (
          -1.4760095,
          -8.3708658,
          -8.1896553,
         ),
         (
          -0.74082381,
          -8.4676552,
          -8.1896553,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -8.1896553,
         ),
         (
          0.74082381,
          -8.4676552,
          -8.1896553,
         ),
         (
          1.4760095,
          -8.3708658,
          -8.1896553,
         ),
         (
          2.1999619,
          -8.2103691,
          -8.1896553,
         ),
         (
          2.9071712,
          -7.9873872,
          -8.1896553,
         ),
         (
          3.5922554,
          -7.7036166,
          -8.1896553,
         ),
         (
          4.25,
          -7.3612156,
          -8.1896553,
         ),
         (
          4.8753996,
          -6.9627924,
          -8.1896553,
         ),
         (
          5.463695,
          -6.5113778,
          -8.1896553,
         ),
         (
          6.0104074,
          -6.0104074,
          -8.1896553,
         ),
         (
          6.5113778,
          -5.463695,
          -8.1896553,
         ),
         (
          6.9627924,
          -4.8753996,
          -8.1896553,
         ),
         (
          7.3612156,
          -4.25,
          -8.1896553,
         ),
         (
          7.7036166,
          -3.5922554,
          -8.1896553,
         ),
         (
          7.9873872,
          -2.9071712,
          -8.1896553,
         ),
         (
          8.2103691,
          -2.1999619,
          -8.1896553,
         ),
         (
          8.3708658,
          -1.4760095,
          -8.1896553,
         ),
         (
          8.4676552,
          -0.74082381,
          -8.1896553,
         ),
         (
          8.49191,
          0.37076479,
          -7.534483,
         ),
         (
          8.4272814,
          1.1094725,
          -7.534483,
         ),
         (
          8.2985163,
          1.8397368,
          -7.534483,
         ),
         (
          8.1065941,
          2.5559993,
          -7.534483,
         ),
         (
          7.8529758,
          3.252809,
          -7.534483,
         ),
         (
          7.5395918,
          3.9248631,
          -7.534483,
         ),
         (
          7.1688271,
          4.5670471,
          -7.534483,
         ),
         (
          6.7435031,
          5.1744723,
          -7.534483,
         ),
         (
          6.2668571,
          5.742517,
          -7.534483,
         ),
         (
          5.742517,
          6.2668571,
          -7.534483,
         ),
         (
          5.1744723,
          6.7435031,
          -7.534483,
         ),
         (
          4.5670471,
          7.1688271,
          -7.534483,
         ),
         (
          3.9248631,
          7.5395918,
          -7.534483,
         ),
         (
          3.252809,
          7.8529758,
          -7.534483,
         ),
         (
          2.5559993,
          8.1065941,
          -7.534483,
         ),
         (
          1.8397368,
          8.2985163,
          -7.534483,
         ),
         (
          1.1094725,
          8.4272814,
          -7.534483,
         ),
         (
          0.37076479,
          8.49191,
          -7.534483,
         ),
         (
          -0.37076479,
          8.49191,
          -7.534483,
         ),
         (
          -1.1094725,
          8.4272814,
          -7.534483,
         ),
         (
          -1.8397368,
          8.2985163,
          -7.534483,
         ),
         (
          -2.5559993,
          8.1065941,
          -7.534483,
         ),
         (
          -3.252809,
          7.8529758,
          -7.534483,
         ),
         (
          -3.9248631,
          7.5395918,
          -7.534483,
         ),
         (
          -4.5670471,
          7.1688271,
          -7.534483,
         ),
         (
          -5.1744723,
          6.7435031,
          -7.534483,
         ),
         (
          -5.742517,
          6.2668571,
          -7.534483,
         ),
         (
          -6.2668571,
          5.742517,
          -7.534483,
         ),
         (
          -6.7435031,
          5.1744723,
          -7.534483,
         ),
         (
          -7.1688271,
          4.5670471,
          -7.534483,
         ),
         (
          -7.5395918,
          3.9248631,
          -7.534483,
         ),
         (
          -7.8529758,
          3.252809,
          -7.534483,
         ),
         (
          -8.1065941,
          2.5559993,
          -7.534483,
         ),
         (
          -8.2985163,
          1.8397368,
          -7.534483,
         ),
         (
          -8.4272814,
          1.1094725,
          -7.534483,
         ),
         (
          -8.49191,
          0.37076479,
          -7.534483,
         ),
         (
          -8.49191,
          -0.37076479,
          -7.534483,
         ),
         (
          -8.4272814,
          -1.1094725,
          -7.534483,
         ),
         (
          -8.2985163,
          -1.8397368,
          -7.534483,
         ),
         (
          -8.1065941,
          -2.5559993,
          -7.534483,
         ),
         (
          -7.8529758,
          -3.252809,
          -7.534483,
         ),
         (
          -7.5395918,
          -3.9248631,
          -7.534483,
         ),
         (
          -7.1688271,
          -4.5670471,
          -7.534483,
         ),
         (
          -6.7435031,
          -5.1744723,
          -7.534483,
         ),
         (
          -6.2668571,
          -5.742517,
          -7.534483,
         ),
         (
          -5.742517,
          -6.2668571,
          -7.534483,
         ),
         (
          -5.1744723,
          -6.7435031,
          -7.534483,
         ),
         (
          -4.5670471,
          -7.1688271,
          -7.534483,
         ),
         (
          -3.9248631,
          -7.5395918,
          -7.534483,
         ),
         (
          -3.252809,
          -7.8529758,
          -7.534483,
         ),
         (
          -2.5559993,
          -8.1065941,
          -7.534483,
         ),
         (
          -1.8397368,
          -8.2985163,
          -7.534483,
         ),
         (
          -1.1094725,
          -8.4272814,
          -7.534483,
         ),
         (
          -0.37076479,
          -8.49191,
          -7.534483,
         ),
         (
          0.37076479,
          -8.49191,
          -7.534483,
         ),
         (
          1.1094725,
          -8.4272814,
          -7.534483,
         ),
         (
          1.8397368,
          -8.2985163,
          -7.534483,
         ),
         (
          2.5559993,
          -8.1065941,
          -7.534483,
         ),
         (
          3.252809,
          -7.8529758,
          -7.534483,
         ),
         (
          3.9248631,
          -7.5395918,
          -7.534483,
         ),
         (
          4.5670471,
          -7.1688271,
          -7.534483,
         ),
         (
          5.1744723,
          -6.7435031,
          -7.534483,
         ),
         (
          5.742517,
          -6.2668571,
          -7.534483,
         ),
         (
          6.2668571,
          -5.742517,
          -7.534483,
         ),
         (
          6.7435031,
          -5.1744723,
          -7.534483,
         ),
         (
          7.1688271,
          -4.5670471,
          -7.534483,
         ),
         (
          7.5395918,
          -3.9248631,
          -7.534483,
         ),
         (
          7.8529758,
          -3.252809,
          -7.534483,
         ),
         (
          8.1065941,
          -2.5559993,
          -7.534483,
         ),
         (
          8.2985163,
          -1.8397368,
          -7.534483,
         ),
         (
          8.4272814,
          -1.1094725,
          -7.534483,
         ),
         (
          8.49191,
          -0.37076479,
          -7.534483,
         ),
         (
          8.5,
          0.0,
          -6.8793101,
         ),
         (
          8.4676552,
          0.74082381,
          -6.8793101,
         ),
         (
          8.3708658,
          1.4760095,
          -6.8793101,
         ),
         (
          8.2103691,
          2.1999619,
          -6.8793101,
         ),
         (
          7.9873872,
          2.9071712,
          -6.8793101,
         ),
         (
          7.7036166,
          3.5922554,
          -6.8793101,
         ),
         (
          7.3612156,
          4.25,
          -6.8793101,
         ),
         (
          6.9627924,
          4.8753996,
          -6.8793101,
         ),
         (
          6.5113778,
          5.463695,
          -6.8793101,
         ),
         (
          6.0104074,
          6.0104074,
          -6.8793101,
         ),
         (
          5.463695,
          6.5113778,
          -6.8793101,
         ),
         (
          4.8753996,
          6.9627924,
          -6.8793101,
         ),
         (
          4.25,
          7.3612156,
          -6.8793101,
         ),
         (
          3.5922554,
          7.7036166,
          -6.8793101,
         ),
         (
          2.9071712,
          7.9873872,
          -6.8793101,
         ),
         (
          2.1999619,
          8.2103691,
          -6.8793101,
         ),
         (
          1.4760095,
          8.3708658,
          -6.8793101,
         ),
         (
          0.74082381,
          8.4676552,
          -6.8793101,
         ),
         (
          5.2047491e-16,
          8.5,
          -6.8793101,
         ),
         (
          -0.74082381,
          8.4676552,
          -6.8793101,
         ),
         (
          -1.4760095,
          8.3708658,
          -6.8793101,
         ),
         (
          -2.1999619,
          8.2103691,
          -6.8793101,
         ),
         (
          -2.9071712,
          7.9873872,
          -6.8793101,
         ),
         (
          -3.5922554,
          7.7036166,
          -6.8793101,
         ),
         (
          -4.25,
          7.3612156,
          -6.8793101,
         ),
         (
          -4.8753996,
          6.9627924,
          -6.8793101,
         ),
         (
          -5.463695,
          6.5113778,
          -6.8793101,
         ),
         (
          -6.0104074,
          6.0104074,
          -6.8793101,
         ),
         (
          -6.5113778,
          5.463695,
          -6.8793101,
         ),
         (
          -6.9627924,
          4.8753996,
          -6.8793101,
         ),
         (
          -7.3612156,
          4.25,
          -6.8793101,
         ),
         (
          -7.7036166,
          3.5922554,
          -6.8793101,
         ),
         (
          -7.9873872,
          2.9071712,
          -6.8793101,
         ),
         (
          -8.2103691,
          2.1999619,
          -6.8793101,
         ),
         (
          -8.3708658,
          1.4760095,
          -6.8793101,
         ),
         (
          -8.4676552,
          0.74082381,
          -6.8793101,
         ),
         (
          -8.5,
          1.0409498e-15,
          -6.8793101,
         ),
         (
          -8.4676552,
          -0.74082381,
          -6.8793101,
         ),
         (
          -8.3708658,
          -1.4760095,
          -6.8793101,
         ),
         (
          -8.2103691,
          -2.1999619,
          -6.8793101,
         ),
         (
          -7.9873872,
          -2.9071712,
          -6.8793101,
         ),
         (
          -7.7036166,
          -3.5922554,
          -6.8793101,
         ),
         (
          -7.3612156,
          -4.25,
          -6.8793101,
         ),
         (
          -6.9627924,
          -4.8753996,
          -6.8793101,
         ),
         (
          -6.5113778,
          -5.463695,
          -6.8793101,
         ),
         (
          -6.0104074,
          -6.0104074,
          -6.8793101,
         ),
         (
          -5.463695,
          -6.5113778,
          -6.8793101,
         ),
         (
          -4.8753996,
          -6.9627924,
          -6.8793101,
         ),
         (
          -4.25,
          -7.3612156,
          -6.8793101,
         ),
         (
          -3.5922554,
          -7.7036166,
          -6.8793101,
         ),
         (
          -2.9071712,
          -7.9873872,
          -6.8793101,
         ),
         (
          -2.1999619,
          -8.2103691,
          -6.8793101,
         ),
         (
          -1.4760095,
          -8.3708658,
          -6.8793101,
         ),
         (
          -0.74082381,
          -8.4676552,
          -6.8793101,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -6.8793101,
         ),
         (
          0.74082381,
          -8.4676552,
          -6.8793101,
         ),
         (
          1.4760095,
          -8.3708658,
          -6.8793101,
         ),
         (
          2.1999619,
          -8.2103691,
          -6.8793101,
         ),
         (
          2.9071712,
          -7.9873872,
          -6.8793101,
         ),
         (
          3.5922554,
          -7.7036166,
          -6.8793101,
         ),
         (
          4.25,
          -7.3612156,
          -6.8793101,
         ),
         (
          4.8753996,
          -6.9627924,
          -6.8793101,
         ),
         (
          5.463695,
          -6.5113778,
          -6.8793101,
         ),
         (
          6.0104074,
          -6.0104074,
          -6.8793101,
         ),
         (
          6.5113778,
          -5.463695,
          -6.8793101,
         ),
         (
          6.9627924,
          -4.8753996,
          -6.8793101,
         ),
         (
          7.3612156,
          -4.25,
          -6.8793101,
         ),
         (
          7.7036166,
          -3.5922554,
          -6.8793101,
         ),
         (
          7.9873872,
          -2.9071712,
          -6.8793101,
         ),
         (
          8.2103691,
          -2.1999619,
          -6.8793101,
         ),
         (
          8.3708658,
          -1.4760095,
          -6.8793101,
         ),
         (
          8.4676552,
          -0.74082381,
          -6.8793101,
         ),
         (
          8.49191,
          0.37076479,
          -6.2241378,
         ),
         (
          8.4272814,
          1.1094725,
          -6.2241378,
         ),
         (
          8.2985163,
          1.8397368,
          -6.2241378,
         ),
         (
          8.1065941,
          2.5559993,
          -6.2241378,
         ),
         (
          7.8529758,
          3.252809,
          -6.2241378,
         ),
         (
          7.5395918,
          3.9248631,
          -6.2241378,
         ),
         (
          7.1688271,
          4.5670471,
          -6.2241378,
         ),
         (
          6.7435031,
          5.1744723,
          -6.2241378,
         ),
         (
          6.2668571,
          5.742517,
          -6.2241378,
         ),
         (
          5.742517,
          6.2668571,
          -6.2241378,
         ),
         (
          5.1744723,
          6.7435031,
          -6.2241378,
         ),
         (
          4.5670471,
          7.1688271,
          -6.2241378,
         ),
         (
          3.9248631,
          7.5395918,
          -6.2241378,
         ),
         (
          3.252809,
          7.8529758,
          -6.2241378,
         ),
         (
          2.5559993,
          8.1065941,
          -6.2241378,
         ),
         (
          1.8397368,
          8.2985163,
          -6.2241378,
         ),
         (
          1.1094725,
          8.4272814,
          -6.2241378,
         ),
         (
          0.37076479,
          8.49191,
          -6.2241378,
         ),
         (
          -0.37076479,
          8.49191,
          -6.2241378,
         ),
         (
          -1.1094725,
          8.4272814,
          -6.2241378,
         ),
         (
          -1.8397368,
          8.2985163,
          -6.2241378,
         ),
         (
          -2.5559993,
          8.1065941,
          -6.2241378,
         ),
         (
          -3.252809,
          7.8529758,
          -6.2241378,
         ),
         (
          -3.9248631,
          7.5395918,
          -6.2241378,
         ),
         (
          -4.5670471,
          7.1688271,
          -6.2241378,
         ),
         (
          -5.1744723,
          6.7435031,
          -6.2241378,
         ),
         (
          -5.742517,
          6.2668571,
          -6.2241378,
         ),
         (
          -6.2668571,
          5.742517,
          -6.2241378,
         ),
         (
          -6.7435031,
          5.1744723,
          -6.2241378,
         ),
         (
          -7.1688271,
          4.5670471,
          -6.2241378,
         ),
         (
          -7.5395918,
          3.9248631,
          -6.2241378,
         ),
         (
          -7.8529758,
          3.252809,
          -6.2241378,
         ),
         (
          -8.1065941,
          2.5559993,
          -6.2241378,
         ),
         (
          -8.2985163,
          1.8397368,
          -6.2241378,
         ),
         (
          -8.4272814,
          1.1094725,
          -6.2241378,
         ),
         (
          -8.49191,
          0.37076479,
          -6.2241378,
         ),
         (
          -8.49191,
          -0.37076479,
          -6.2241378,
         ),
         (
          -8.4272814,
          -1.1094725,
          -6.2241378,
         ),
         (
          -8.2985163,
          -1.8397368,
          -6.2241378,
         ),
         (
          -8.1065941,
          -2.5559993,
          -6.2241378,
         ),
         (
          -7.8529758,
          -3.252809,
          -6.2241378,
         ),
         (
          -7.5395918,
          -3.9248631,
          -6.2241378,
         ),
         (
          -7.1688271,
          -4.5670471,
          -6.2241378,
         ),
         (
          -6.7435031,
          -5.1744723,
          -6.2241378,
         ),
         (
          -6.2668571,
          -5.742517,
          -6.2241378,
         ),
         (
          -5.742517,
          -6.2668571,
          -6.2241378,
         ),
         (
          -5.1744723,
          -6.7435031,
          -6.2241378,
         ),
         (
          -4.5670471,
          -7.1688271,
          -6.2241378,
         ),
         (
          -3.9248631,
          -7.5395918,
          -6.2241378,
         ),
         (
          -3.252809,
          -7.8529758,
          -6.2241378,
         ),
         (
          -2.5559993,
          -8.1065941,
          -6.2241378,
         ),
         (
          -1.8397368,
          -8.2985163,
          -6.2241378,
         ),
         (
          -1.1094725,
          -8.4272814,
          -6.2241378,
         ),
         (
          -0.37076479,
          -8.49191,
          -6.2241378,
         ),
         (
          0.37076479,
          -8.49191,
          -6.2241378,
         ),
         (
          1.1094725,
          -8.4272814,
          -6.2241378,
         ),
         (
          1.8397368,
          -8.2985163,
          -6.2241378,
         ),
         (
          2.5559993,
          -8.1065941,
          -6.2241378,
         ),
         (
          3.252809,
          -7.8529758,
          -6.2241378,
         ),
         (
          3.9248631,
          -7.5395918,
          -6.2241378,
         ),
         (
          4.5670471,
          -7.1688271,
          -6.2241378,
         ),
         (
          5.1744723,
          -6.7435031,
          -6.2241378,
         ),
         (
          5.742517,
          -6.2668571,
          -6.2241378,
         ),
         (
          6.2668571,
          -5.742517,
          -6.2241378,
         ),
         (
          6.7435031,
          -5.1744723,
          -6.2241378,
         ),
         (
          7.1688271,
          -4.5670471,
          -6.2241378,
         ),
         (
          7.5395918,
          -3.9248631,
          -6.2241378,
         ),
         (
          7.8529758,
          -3.252809,
          -6.2241378,
         ),
         (
          8.1065941,
          -2.5559993,
          -6.2241378,
         ),
         (
          8.2985163,
          -1.8397368,
          -6.2241378,
         ),
         (
          8.4272814,
          -1.1094725,
          -6.2241378,
         ),
         (
          8.49191,
          -0.37076479,
          -6.2241378,
         ),
         (
          8.5,
          0.0,
          -5.5689659,
         ),
         (
          8.4676552,
          0.74082381,
          -5.5689659,
         ),
         (
          8.3708658,
          1.4760095,
          -5.5689659,
         ),
         (
          8.2103691,
          2.1999619,
          -5.5689659,
         ),
         (
          7.9873872,
          2.9071712,
          -5.5689659,
         ),
         (
          7.7036166,
          3.5922554,
          -5.5689659,
         ),
         (
          7.3612156,
          4.25,
          -5.5689659,
         ),
         (
          6.9627924,
          4.8753996,
          -5.5689659,
         ),
         (
          6.5113778,
          5.463695,
          -5.5689659,
         ),
         (
          6.0104074,
          6.0104074,
          -5.5689659,
         ),
         (
          5.463695,
          6.5113778,
          -5.5689659,
         ),
         (
          4.8753996,
          6.9627924,
          -5.5689659,
         ),
         (
          4.25,
          7.3612156,
          -5.5689659,
         ),
         (
          3.5922554,
          7.7036166,
          -5.5689659,
         ),
         (
          2.9071712,
          7.9873872,
          -5.5689659,
         ),
         (
          2.1999619,
          8.2103691,
          -5.5689659,
         ),
         (
          1.4760095,
          8.3708658,
          -5.5689659,
         ),
         (
          0.74082381,
          8.4676552,
          -5.5689659,
         ),
         (
          5.2047491e-16,
          8.5,
          -5.5689659,
         ),
         (
          -0.74082381,
          8.4676552,
          -5.5689659,
         ),
         (
          -1.4760095,
          8.3708658,
          -5.5689659,
         ),
         (
          -2.1999619,
          8.2103691,
          -5.5689659,
         ),
         (
          -2.9071712,
          7.9873872,
          -5.5689659,
         ),
         (
          -3.5922554,
          7.7036166,
          -5.5689659,
         ),
         (
          -4.25,
          7.3612156,
          -5.5689659,
         ),
         (
          -4.8753996,
          6.9627924,
          -5.5689659,
         ),
         (
          -5.463695,
          6.5113778,
          -5.5689659,
         ),
         (
          -6.0104074,
          6.0104074,
          -5.5689659,
         ),
         (
          -6.5113778,
          5.463695,
          -5.5689659,
         ),
         (
          -6.9627924,
          4.8753996,
          -5.5689659,
         ),
         (
          -7.3612156,
          4.25,
          -5.5689659,
         ),
         (
          -7.7036166,
          3.5922554,
          -5.5689659,
         ),
         (
          -7.9873872,
          2.9071712,
          -5.5689659,
         ),
         (
          -8.2103691,
          2.1999619,
          -5.5689659,
         ),
         (
          -8.3708658,
          1.4760095,
          -5.5689659,
         ),
         (
          -8.4676552,
          0.74082381,
          -5.5689659,
         ),
         (
          -8.5,
          1.0409498e-15,
          -5.5689659,
         ),
         (
          -8.4676552,
          -0.74082381,
          -5.5689659,
         ),
         (
          -8.3708658,
          -1.4760095,
          -5.5689659,
         ),
         (
          -8.2103691,
          -2.1999619,
          -5.5689659,
         ),
         (
          -7.9873872,
          -2.9071712,
          -5.5689659,
         ),
         (
          -7.7036166,
          -3.5922554,
          -5.5689659,
         ),
         (
          -7.3612156,
          -4.25,
          -5.5689659,
         ),
         (
          -6.9627924,
          -4.8753996,
          -5.5689659,
         ),
         (
          -6.5113778,
          -5.463695,
          -5.5689659,
         ),
         (
          -6.0104074,
          -6.0104074,
          -5.5689659,
         ),
         (
          -5.463695,
          -6.5113778,
          -5.5689659,
         ),
         (
          -4.8753996,
          -6.9627924,
          -5.5689659,
         ),
         (
          -4.25,
          -7.3612156,
          -5.5689659,
         ),
         (
          -3.5922554,
          -7.7036166,
          -5.5689659,
         ),
         (
          -2.9071712,
          -7.9873872,
          -5.5689659,
         ),
         (
          -2.1999619,
          -8.2103691,
          -5.5689659,
         ),
         (
          -1.4760095,
          -8.3708658,
          -5.5689659,
         ),
         (
          -0.74082381,
          -8.4676552,
          -5.5689659,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -5.5689659,
         ),
         (
          0.74082381,
          -8.4676552,
          -5.5689659,
         ),
         (
          1.4760095,
          -8.3708658,
          -5.5689659,
         ),
         (
          2.1999619,
          -8.2103691,
          -5.5689659,
         ),
         (
          2.9071712,
          -7.9873872,
          -5.5689659,
         ),
         (
          3.5922554,
          -7.7036166,
          -5.5689659,
         ),
         (
          4.25,
          -7.3612156,
          -5.5689659,
         ),
         (
          4.8753996,
          -6.9627924,
          -5.5689659,
         ),
         (
          5.463695,
          -6.5113778,
          -5.5689659,
         ),
         (
          6.0104074,
          -6.0104074,
          -5.5689659,
         ),
         (
          6.5113778,
          -5.463695,
          -5.5689659,
         ),
         (
          6.9627924,
          -4.8753996,
          -5.5689659,
         ),
         (
          7.3612156,
          -4.25,
          -5.5689659,
         ),
         (
          7.7036166,
          -3.5922554,
          -5.5689659,
         ),
         (
          7.9873872,
          -2.9071712,
          -5.5689659,
         ),
         (
          8.2103691,
          -2.1999619,
          -5.5689659,
         ),
         (
          8.3708658,
          -1.4760095,
          -5.5689659,
         ),
         (
          8.4676552,
          -0.74082381,
          -5.5689659,
         ),
         (
          8.49191,
          0.37076479,
          -4.9137931,
         ),
         (
          8.4272814,
          1.1094725,
          -4.9137931,
         ),
         (
          8.2985163,
          1.8397368,
          -4.9137931,
         ),
         (
          8.1065941,
          2.5559993,
          -4.9137931,
         ),
         (
          7.8529758,
          3.252809,
          -4.9137931,
         ),
         (
          7.5395918,
          3.9248631,
          -4.9137931,
         ),
         (
          7.1688271,
          4.5670471,
          -4.9137931,
         ),
         (
          6.7435031,
          5.1744723,
          -4.9137931,
         ),
         (
          6.2668571,
          5.742517,
          -4.9137931,
         ),
         (
          5.742517,
          6.2668571,
          -4.9137931,
         ),
         (
          5.1744723,
          6.7435031,
          -4.9137931,
         ),
         (
          4.5670471,
          7.1688271,
          -4.9137931,
         ),
         (
          3.9248631,
          7.5395918,
          -4.9137931,
         ),
         (
          3.252809,
          7.8529758,
          -4.9137931,
         ),
         (
          2.5559993,
          8.1065941,
          -4.9137931,
         ),
         (
          1.8397368,
          8.2985163,
          -4.9137931,
         ),
         (
          1.1094725,
          8.4272814,
          -4.9137931,
         ),
         (
          0.37076479,
          8.49191,
          -4.9137931,
         ),
         (
          -0.37076479,
          8.49191,
          -4.9137931,
         ),
         (
          -1.1094725,
          8.4272814,
          -4.9137931,
         ),
         (
          -1.8397368,
          8.2985163,
          -4.9137931,
         ),
         (
          -2.5559993,
          8.1065941,
          -4.9137931,
         ),
         (
          -3.252809,
          7.8529758,
          -4.9137931,
         ),
         (
          -3.9248631,
          7.5395918,
          -4.9137931,
         ),
         (
          -4.5670471,
          7.1688271,
          -4.9137931,
         ),
         (
          -5.1744723,
          6.7435031,
          -4.9137931,
         ),
         (
          -5.742517,
          6.2668571,
          -4.9137931,
         ),
         (
          -6.2668571,
          5.742517,
          -4.9137931,
         ),
         (
          -6.7435031,
          5.1744723,
          -4.9137931,
         ),
         (
          -7.1688271,
          4.5670471,
          -4.9137931,
         ),
         (
          -7.5395918,
          3.9248631,
          -4.9137931,
         ),
         (
          -7.8529758,
          3.252809,
          -4.9137931,
         ),
         (
          -8.1065941,
          2.5559993,
          -4.9137931,
         ),
         (
          -8.2985163,
          1.8397368,
          -4.9137931,
         ),
         (
          -8.4272814,
          1.1094725,
          -4.9137931,
         ),
         (
          -8.49191,
          0.37076479,
          -4.9137931,
         ),
         (
          -8.49191,
          -0.37076479,
          -4.9137931,
         ),
         (
          -8.4272814,
          -1.1094725,
          -4.9137931,
         ),
         (
          -8.2985163,
          -1.8397368,
          -4.9137931,
         ),
         (
          -8.1065941,
          -2.5559993,
          -4.9137931,
         ),
         (
          -7.8529758,
          -3.252809,
          -4.9137931,
         ),
         (
          -7.5395918,
          -3.9248631,
          -4.9137931,
         ),
         (
          -7.1688271,
          -4.5670471,
          -4.9137931,
         ),
         (
          -6.7435031,
          -5.1744723,
          -4.9137931,
         ),
         (
          -6.2668571,
          -5.742517,
          -4.9137931,
         ),
         (
          -5.742517,
          -6.2668571,
          -4.9137931,
         ),
         (
          -5.1744723,
          -6.7435031,
          -4.9137931,
         ),
         (
          -4.5670471,
          -7.1688271,
          -4.9137931,
         ),
         (
          -3.9248631,
          -7.5395918,
          -4.9137931,
         ),
         (
          -3.252809,
          -7.8529758,
          -4.9137931,
         ),
         (
          -2.5559993,
          -8.1065941,
          -4.9137931,
         ),
         (
          -1.8397368,
          -8.2985163,
          -4.9137931,
         ),
         (
          -1.1094725,
          -8.4272814,
          -4.9137931,
         ),
         (
          -0.37076479,
          -8.49191,
          -4.9137931,
         ),
         (
          0.37076479,
          -8.49191,
          -4.9137931,
         ),
         (
          1.1094725,
          -8.4272814,
          -4.9137931,
         ),
         (
          1.8397368,
          -8.2985163,
          -4.9137931,
         ),
         (
          2.5559993,
          -8.1065941,
          -4.9137931,
         ),
         (
          3.252809,
          -7.8529758,
          -4.9137931,
         ),
         (
          3.9248631,
          -7.5395918,
          -4.9137931,
         ),
         (
          4.5670471,
          -7.1688271,
          -4.9137931,
         ),
         (
          5.1744723,
          -6.7435031,
          -4.9137931,
         ),
         (
          5.742517,
          -6.2668571,
          -4.9137931,
         ),
         (
          6.2668571,
          -5.742517,
          -4.9137931,
         ),
         (
          6.7435031,
          -5.1744723,
          -4.9137931,
         ),
         (
          7.1688271,
          -4.5670471,
          -4.9137931,
         ),
         (
          7.5395918,
          -3.9248631,
          -4.9137931,
         ),
         (
          7.8529758,
          -3.252809,
          -4.9137931,
         ),
         (
          8.1065941,
          -2.5559993,
          -4.9137931,
         ),
         (
          8.2985163,
          -1.8397368,
          -4.9137931,
         ),
         (
          8.4272814,
          -1.1094725,
          -4.9137931,
         ),
         (
          8.49191,
          -0.37076479,
          -4.9137931,
         ),
         (
          8.5,
          0.0,
          -4.2586207,
         ),
         (
          8.4676552,
          0.74082381,
          -4.2586207,
         ),
         (
          8.3708658,
          1.4760095,
          -4.2586207,
         ),
         (
          8.2103691,
          2.1999619,
          -4.2586207,
         ),
         (
          7.9873872,
          2.9071712,
          -4.2586207,
         ),
         (
          7.7036166,
          3.5922554,
          -4.2586207,
         ),
         (
          7.3612156,
          4.25,
          -4.2586207,
         ),
         (
          6.9627924,
          4.8753996,
          -4.2586207,
         ),
         (
          6.5113778,
          5.463695,
          -4.2586207,
         ),
         (
          6.0104074,
          6.0104074,
          -4.2586207,
         ),
         (
          5.463695,
          6.5113778,
          -4.2586207,
         ),
         (
          4.8753996,
          6.9627924,
          -4.2586207,
         ),
         (
          4.25,
          7.3612156,
          -4.2586207,
         ),
         (
          3.5922554,
          7.7036166,
          -4.2586207,
         ),
         (
          2.9071712,
          7.9873872,
          -4.2586207,
         ),
         (
          2.1999619,
          8.2103691,
          -4.2586207,
         ),
         (
          1.4760095,
          8.3708658,
          -4.2586207,
         ),
         (
          0.74082381,
          8.4676552,
          -4.2586207,
         ),
         (
          5.2047491e-16,
          8.5,
          -4.2586207,
         ),
         (
          -0.74082381,
          8.4676552,
          -4.2586207,
         ),
         (
          -1.4760095,
          8.3708658,
          -4.2586207,
         ),
         (
          -2.1999619,
          8.2103691,
          -4.2586207,
         ),
         (
          -2.9071712,
          7.9873872,
          -4.2586207,
         ),
         (
          -3.5922554,
          7.7036166,
          -4.2586207,
         ),
         (
          -4.25,
          7.3612156,
          -4.2586207,
         ),
         (
          -4.8753996,
          6.9627924,
          -4.2586207,
         ),
         (
          -5.463695,
          6.5113778,
          -4.2586207,
         ),
         (
          -6.0104074,
          6.0104074,
          -4.2586207,
         ),
         (
          -6.5113778,
          5.463695,
          -4.2586207,
         ),
         (
          -6.9627924,
          4.8753996,
          -4.2586207,
         ),
         (
          -7.3612156,
          4.25,
          -4.2586207,
         ),
         (
          -7.7036166,
          3.5922554,
          -4.2586207,
         ),
         (
          -7.9873872,
          2.9071712,
          -4.2586207,
         ),
         (
          -8.2103691,
          2.1999619,
          -4.2586207,
         ),
         (
          -8.3708658,
          1.4760095,
          -4.2586207,
         ),
         (
          -8.4676552,
          0.74082381,
          -4.2586207,
         ),
         (
          -8.5,
          1.0409498e-15,
          -4.2586207,
         ),
         (
          -8.4676552,
          -0.74082381,
          -4.2586207,
         ),
         (
          -8.3708658,
          -1.4760095,
          -4.2586207,
         ),
         (
          -8.2103691,
          -2.1999619,
          -4.2586207,
         ),
         (
          -7.9873872,
          -2.9071712,
          -4.2586207,
         ),
         (
          -7.7036166,
          -3.5922554,
          -4.2586207,
         ),
         (
          -7.3612156,
          -4.25,
          -4.2586207,
         ),
         (
          -6.9627924,
          -4.8753996,
          -4.2586207,
         ),
         (
          -6.5113778,
          -5.463695,
          -4.2586207,
         ),
         (
          -6.0104074,
          -6.0104074,
          -4.2586207,
         ),
         (
          -5.463695,
          -6.5113778,
          -4.2586207,
         ),
         (
          -4.8753996,
          -6.9627924,
          -4.2586207,
         ),
         (
          -4.25,
          -7.3612156,
          -4.2586207,
         ),
         (
          -3.5922554,
          -7.7036166,
          -4.2586207,
         ),
         (
          -2.9071712,
          -7.9873872,
          -4.2586207,
         ),
         (
          -2.1999619,
          -8.2103691,
          -4.2586207,
         ),
         (
          -1.4760095,
          -8.3708658,
          -4.2586207,
         ),
         (
          -0.74082381,
          -8.4676552,
          -4.2586207,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -4.2586207,
         ),
         (
          0.74082381,
          -8.4676552,
          -4.2586207,
         ),
         (
          1.4760095,
          -8.3708658,
          -4.2586207,
         ),
         (
          2.1999619,
          -8.2103691,
          -4.2586207,
         ),
         (
          2.9071712,
          -7.9873872,
          -4.2586207,
         ),
         (
          3.5922554,
          -7.7036166,
          -4.2586207,
         ),
         (
          4.25,
          -7.3612156,
          -4.2586207,
         ),
         (
          4.8753996,
          -6.9627924,
          -4.2586207,
         ),
         (
          5.463695,
          -6.5113778,
          -4.2586207,
         ),
         (
          6.0104074,
          -6.0104074,
          -4.2586207,
         ),
         (
          6.5113778,
          -5.463695,
          -4.2586207,
         ),
         (
          6.9627924,
          -4.8753996,
          -4.2586207,
         ),
         (
          7.3612156,
          -4.25,
          -4.2586207,
         ),
         (
          7.7036166,
          -3.5922554,
          -4.2586207,
         ),
         (
          7.9873872,
          -2.9071712,
          -4.2586207,
         ),
         (
          8.2103691,
          -2.1999619,
          -4.2586207,
         ),
         (
          8.3708658,
          -1.4760095,
          -4.2586207,
         ),
         (
          8.4676552,
          -0.74082381,
          -4.2586207,
         ),
         (
          8.49191,
          0.37076479,
          -3.6034482,
         ),
         (
          8.4272814,
          1.1094725,
          -3.6034482,
         ),
         (
          8.2985163,
          1.8397368,
          -3.6034482,
         ),
         (
          8.1065941,
          2.5559993,
          -3.6034482,
         ),
         (
          7.8529758,
          3.252809,
          -3.6034482,
         ),
         (
          7.5395918,
          3.9248631,
          -3.6034482,
         ),
         (
          7.1688271,
          4.5670471,
          -3.6034482,
         ),
         (
          6.7435031,
          5.1744723,
          -3.6034482,
         ),
         (
          6.2668571,
          5.742517,
          -3.6034482,
         ),
         (
          5.742517,
          6.2668571,
          -3.6034482,
         ),
         (
          5.1744723,
          6.7435031,
          -3.6034482,
         ),
         (
          4.5670471,
          7.1688271,
          -3.6034482,
         ),
         (
          3.9248631,
          7.5395918,
          -3.6034482,
         ),
         (
          3.252809,
          7.8529758,
          -3.6034482,
         ),
         (
          2.5559993,
          8.1065941,
          -3.6034482,
         ),
         (
          1.8397368,
          8.2985163,
          -3.6034482,
         ),
         (
          1.1094725,
          8.4272814,
          -3.6034482,
         ),
         (
          0.37076479,
          8.49191,
          -3.6034482,
         ),
         (
          -0.37076479,
          8.49191,
          -3.6034482,
         ),
         (
          -1.1094725,
          8.4272814,
          -3.6034482,
         ),
         (
          -1.8397368,
          8.2985163,
          -3.6034482,
         ),
         (
          -2.5559993,
          8.1065941,
          -3.6034482,
         ),
         (
          -3.252809,
          7.8529758,
          -3.6034482,
         ),
         (
          -3.9248631,
          7.5395918,
          -3.6034482,
         ),
         (
          -4.5670471,
          7.1688271,
          -3.6034482,
         ),
         (
          -5.1744723,
          6.7435031,
          -3.6034482,
         ),
         (
          -5.742517,
          6.2668571,
          -3.6034482,
         ),
         (
          -6.2668571,
          5.742517,
          -3.6034482,
         ),
         (
          -6.7435031,
          5.1744723,
          -3.6034482,
         ),
         (
          -7.1688271,
          4.5670471,
          -3.6034482,
         ),
         (
          -7.5395918,
          3.9248631,
          -3.6034482,
         ),
         (
          -7.8529758,
          3.252809,
          -3.6034482,
         ),
         (
          -8.1065941,
          2.5559993,
          -3.6034482,
         ),
         (
          -8.2985163,
          1.8397368,
          -3.6034482,
         ),
         (
          -8.4272814,
          1.1094725,
          -3.6034482,
         ),
         (
          -8.49191,
          0.37076479,
          -3.6034482,
         ),
         (
          -8.49191,
          -0.37076479,
          -3.6034482,
         ),
         (
          -8.4272814,
          -1.1094725,
          -3.6034482,
         ),
         (
          -8.2985163,
          -1.8397368,
          -3.6034482,
         ),
         (
          -8.1065941,
          -2.5559993,
          -3.6034482,
         ),
         (
          -7.8529758,
          -3.252809,
          -3.6034482,
         ),
         (
          -7.5395918,
          -3.9248631,
          -3.6034482,
         ),
         (
          -7.1688271,
          -4.5670471,
          -3.6034482,
         ),
         (
          -6.7435031,
          -5.1744723,
          -3.6034482,
         ),
         (
          -6.2668571,
          -5.742517,
          -3.6034482,
         ),
         (
          -5.742517,
          -6.2668571,
          -3.6034482,
         ),
         (
          -5.1744723,
          -6.7435031,
          -3.6034482,
         ),
         (
          -4.5670471,
          -7.1688271,
          -3.6034482,
         ),
         (
          -3.9248631,
          -7.5395918,
          -3.6034482,
         ),
         (
          -3.252809,
          -7.8529758,
          -3.6034482,
         ),
         (
          -2.5559993,
          -8.1065941,
          -3.6034482,
         ),
         (
          -1.8397368,
          -8.2985163,
          -3.6034482,
         ),
         (
          -1.1094725,
          -8.4272814,
          -3.6034482,
         ),
         (
          -0.37076479,
          -8.49191,
          -3.6034482,
         ),
         (
          0.37076479,
          -8.49191,
          -3.6034482,
         ),
         (
          1.1094725,
          -8.4272814,
          -3.6034482,
         ),
         (
          1.8397368,
          -8.2985163,
          -3.6034482,
         ),
         (
          2.5559993,
          -8.1065941,
          -3.6034482,
         ),
         (
          3.252809,
          -7.8529758,
          -3.6034482,
         ),
         (
          3.9248631,
          -7.5395918,
          -3.6034482,
         ),
         (
          4.5670471,
          -7.1688271,
          -3.6034482,
         ),
         (
          5.1744723,
          -6.7435031,
          -3.6034482,
         ),
         (
          5.742517,
          -6.2668571,
          -3.6034482,
         ),
         (
          6.2668571,
          -5.742517,
          -3.6034482,
         ),
         (
          6.7435031,
          -5.1744723,
          -3.6034482,
         ),
         (
          7.1688271,
          -4.5670471,
          -3.6034482,
         ),
         (
          7.5395918,
          -3.9248631,
          -3.6034482,
         ),
         (
          7.8529758,
          -3.252809,
          -3.6034482,
         ),
         (
          8.1065941,
          -2.5559993,
          -3.6034482,
         ),
         (
          8.2985163,
          -1.8397368,
          -3.6034482,
         ),
         (
          8.4272814,
          -1.1094725,
          -3.6034482,
         ),
         (
          8.49191,
          -0.37076479,
          -3.6034482,
         ),
         (
          8.5,
          0.0,
          -2.9482758,
         ),
         (
          8.4676552,
          0.74082381,
          -2.9482758,
         ),
         (
          8.3708658,
          1.4760095,
          -2.9482758,
         ),
         (
          8.2103691,
          2.1999619,
          -2.9482758,
         ),
         (
          7.9873872,
          2.9071712,
          -2.9482758,
         ),
         (
          7.7036166,
          3.5922554,
          -2.9482758,
         ),
         (
          7.3612156,
          4.25,
          -2.9482758,
         ),
         (
          6.9627924,
          4.8753996,
          -2.9482758,
         ),
         (
          6.5113778,
          5.463695,
          -2.9482758,
         ),
         (
          6.0104074,
          6.0104074,
          -2.9482758,
         ),
         (
          5.463695,
          6.5113778,
          -2.9482758,
         ),
         (
          4.8753996,
          6.9627924,
          -2.9482758,
         ),
         (
          4.25,
          7.3612156,
          -2.9482758,
         ),
         (
          3.5922554,
          7.7036166,
          -2.9482758,
         ),
         (
          2.9071712,
          7.9873872,
          -2.9482758,
         ),
         (
          2.1999619,
          8.2103691,
          -2.9482758,
         ),
         (
          1.4760095,
          8.3708658,
          -2.9482758,
         ),
         (
          0.74082381,
          8.4676552,
          -2.9482758,
         ),
         (
          5.2047491e-16,
          8.5,
          -2.9482758,
         ),
         (
          -0.74082381,
          8.4676552,
          -2.9482758,
         ),
         (
          -1.4760095,
          8.3708658,
          -2.9482758,
         ),
         (
          -2.1999619,
          8.2103691,
          -2.9482758,
         ),
         (
          -2.9071712,
          7.9873872,
          -2.9482758,
         ),
         (
          -3.5922554,
          7.7036166,
          -2.9482758,
         ),
         (
          -4.25,
          7.3612156,
          -2.9482758,
         ),
         (
          -4.8753996,
          6.9627924,
          -2.9482758,
         ),
         (
          -5.463695,
          6.5113778,
          -2.9482758,
         ),
         (
          -6.0104074,
          6.0104074,
          -2.9482758,
         ),
         (
          -6.5113778,
          5.463695,
          -2.9482758,
         ),
         (
          -6.9627924,
          4.8753996,
          -2.9482758,
         ),
         (
          -7.3612156,
          4.25,
          -2.9482758,
         ),
         (
          -7.7036166,
          3.5922554,
          -2.9482758,
         ),
         (
          -7.9873872,
          2.9071712,
          -2.9482758,
         ),
         (
          -8.2103691,
          2.1999619,
          -2.9482758,
         ),
         (
          -8.3708658,
          1.4760095,
          -2.9482758,
         ),
         (
          -8.4676552,
          0.74082381,
          -2.9482758,
         ),
         (
          -8.5,
          1.0409498e-15,
          -2.9482758,
         ),
         (
          -8.4676552,
          -0.74082381,
          -2.9482758,
         ),
         (
          -8.3708658,
          -1.4760095,
          -2.9482758,
         ),
         (
          -8.2103691,
          -2.1999619,
          -2.9482758,
         ),
         (
          -7.9873872,
          -2.9071712,
          -2.9482758,
         ),
         (
          -7.7036166,
          -3.5922554,
          -2.9482758,
         ),
         (
          -7.3612156,
          -4.25,
          -2.9482758,
         ),
         (
          -6.9627924,
          -4.8753996,
          -2.9482758,
         ),
         (
          -6.5113778,
          -5.463695,
          -2.9482758,
         ),
         (
          -6.0104074,
          -6.0104074,
          -2.9482758,
         ),
         (
          -5.463695,
          -6.5113778,
          -2.9482758,
         ),
         (
          -4.8753996,
          -6.9627924,
          -2.9482758,
         ),
         (
          -4.25,
          -7.3612156,
          -2.9482758,
         ),
         (
          -3.5922554,
          -7.7036166,
          -2.9482758,
         ),
         (
          -2.9071712,
          -7.9873872,
          -2.9482758,
         ),
         (
          -2.1999619,
          -8.2103691,
          -2.9482758,
         ),
         (
          -1.4760095,
          -8.3708658,
          -2.9482758,
         ),
         (
          -0.74082381,
          -8.4676552,
          -2.9482758,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -2.9482758,
         ),
         (
          0.74082381,
          -8.4676552,
          -2.9482758,
         ),
         (
          1.4760095,
          -8.3708658,
          -2.9482758,
         ),
         (
          2.1999619,
          -8.2103691,
          -2.9482758,
         ),
         (
          2.9071712,
          -7.9873872,
          -2.9482758,
         ),
         (
          3.5922554,
          -7.7036166,
          -2.9482758,
         ),
         (
          4.25,
          -7.3612156,
          -2.9482758,
         ),
         (
          4.8753996,
          -6.9627924,
          -2.9482758,
         ),
         (
          5.463695,
          -6.5113778,
          -2.9482758,
         ),
         (
          6.0104074,
          -6.0104074,
          -2.9482758,
         ),
         (
          6.5113778,
          -5.463695,
          -2.9482758,
         ),
         (
          6.9627924,
          -4.8753996,
          -2.9482758,
         ),
         (
          7.3612156,
          -4.25,
          -2.9482758,
         ),
         (
          7.7036166,
          -3.5922554,
          -2.9482758,
         ),
         (
          7.9873872,
          -2.9071712,
          -2.9482758,
         ),
         (
          8.2103691,
          -2.1999619,
          -2.9482758,
         ),
         (
          8.3708658,
          -1.4760095,
          -2.9482758,
         ),
         (
          8.4676552,
          -0.74082381,
          -2.9482758,
         ),
         (
          8.49191,
          0.37076479,
          -2.2931035,
         ),
         (
          8.4272814,
          1.1094725,
          -2.2931035,
         ),
         (
          8.2985163,
          1.8397368,
          -2.2931035,
         ),
         (
          8.1065941,
          2.5559993,
          -2.2931035,
         ),
         (
          7.8529758,
          3.252809,
          -2.2931035,
         ),
         (
          7.5395918,
          3.9248631,
          -2.2931035,
         ),
         (
          7.1688271,
          4.5670471,
          -2.2931035,
         ),
         (
          6.7435031,
          5.1744723,
          -2.2931035,
         ),
         (
          6.2668571,
          5.742517,
          -2.2931035,
         ),
         (
          5.742517,
          6.2668571,
          -2.2931035,
         ),
         (
          5.1744723,
          6.7435031,
          -2.2931035,
         ),
         (
          4.5670471,
          7.1688271,
          -2.2931035,
         ),
         (
          3.9248631,
          7.5395918,
          -2.2931035,
         ),
         (
          3.252809,
          7.8529758,
          -2.2931035,
         ),
         (
          2.5559993,
          8.1065941,
          -2.2931035,
         ),
         (
          1.8397368,
          8.2985163,
          -2.2931035,
         ),
         (
          1.1094725,
          8.4272814,
          -2.2931035,
         ),
         (
          0.37076479,
          8.49191,
          -2.2931035,
         ),
         (
          -0.37076479,
          8.49191,
          -2.2931035,
         ),
         (
          -1.1094725,
          8.4272814,
          -2.2931035,
         ),
         (
          -1.8397368,
          8.2985163,
          -2.2931035,
         ),
         (
          -2.5559993,
          8.1065941,
          -2.2931035,
         ),
         (
          -3.252809,
          7.8529758,
          -2.2931035,
         ),
         (
          -3.9248631,
          7.5395918,
          -2.2931035,
         ),
         (
          -4.5670471,
          7.1688271,
          -2.2931035,
         ),
         (
          -5.1744723,
          6.7435031,
          -2.2931035,
         ),
         (
          -5.742517,
          6.2668571,
          -2.2931035,
         ),
         (
          -6.2668571,
          5.742517,
          -2.2931035,
         ),
         (
          -6.7435031,
          5.1744723,
          -2.2931035,
         ),
         (
          -7.1688271,
          4.5670471,
          -2.2931035,
         ),
         (
          -7.5395918,
          3.9248631,
          -2.2931035,
         ),
         (
          -7.8529758,
          3.252809,
          -2.2931035,
         ),
         (
          -8.1065941,
          2.5559993,
          -2.2931035,
         ),
         (
          -8.2985163,
          1.8397368,
          -2.2931035,
         ),
         (
          -8.4272814,
          1.1094725,
          -2.2931035,
         ),
         (
          -8.49191,
          0.37076479,
          -2.2931035,
         ),
         (
          -8.49191,
          -0.37076479,
          -2.2931035,
         ),
         (
          -8.4272814,
          -1.1094725,
          -2.2931035,
         ),
         (
          -8.2985163,
          -1.8397368,
          -2.2931035,
         ),
         (
          -8.1065941,
          -2.5559993,
          -2.2931035,
         ),
         (
          -7.8529758,
          -3.252809,
          -2.2931035,
         ),
         (
          -7.5395918,
          -3.9248631,
          -2.2931035,
         ),
         (
          -7.1688271,
          -4.5670471,
          -2.2931035,
         ),
         (
          -6.7435031,
          -5.1744723,
          -2.2931035,
         ),
         (
          -6.2668571,
          -5.742517,
          -2.2931035,
         ),
         (
          -5.742517,
          -6.2668571,
          -2.2931035,
         ),
         (
          -5.1744723,
          -6.7435031,
          -2.2931035,
         ),
         (
          -4.5670471,
          -7.1688271,
          -2.2931035,
         ),
         (
          -3.9248631,
          -7.5395918,
          -2.2931035,
         ),
         (
          -3.252809,
          -7.8529758,
          -2.2931035,
         ),
         (
          -2.5559993,
          -8.1065941,
          -2.2931035,
         ),
         (
          -1.8397368,
          -8.2985163,
          -2.2931035,
         ),
         (
          -1.1094725,
          -8.4272814,
          -2.2931035,
         ),
         (
          -0.37076479,
          -8.49191,
          -2.2931035,
         ),
         (
          0.37076479,
          -8.49191,
          -2.2931035,
         ),
         (
          1.1094725,
          -8.4272814,
          -2.2931035,
         ),
         (
          1.8397368,
          -8.2985163,
          -2.2931035,
         ),
         (
          2.5559993,
          -8.1065941,
          -2.2931035,
         ),
         (
          3.252809,
          -7.8529758,
          -2.2931035,
         ),
         (
          3.9248631,
          -7.5395918,
          -2.2931035,
         ),
         (
          4.5670471,
          -7.1688271,
          -2.2931035,
         ),
         (
          5.1744723,
          -6.7435031,
          -2.2931035,
         ),
         (
          5.742517,
          -6.2668571,
          -2.2931035,
         ),
         (
          6.2668571,
          -5.742517,
          -2.2931035,
         ),
         (
          6.7435031,
          -5.1744723,
          -2.2931035,
         ),
         (
          7.1688271,
          -4.5670471,
          -2.2931035,
         ),
         (
          7.5395918,
          -3.9248631,
          -2.2931035,
         ),
         (
          7.8529758,
          -3.252809,
          -2.2931035,
         ),
         (
          8.1065941,
          -2.5559993,
          -2.2931035,
         ),
         (
          8.2985163,
          -1.8397368,
          -2.2931035,
         ),
         (
          8.4272814,
          -1.1094725,
          -2.2931035,
         ),
         (
          8.49191,
          -0.37076479,
          -2.2931035,
         ),
         (
          8.5,
          0.0,
          -1.6379311,
         ),
         (
          8.4676552,
          0.74082381,
          -1.6379311,
         ),
         (
          8.3708658,
          1.4760095,
          -1.6379311,
         ),
         (
          8.2103691,
          2.1999619,
          -1.6379311,
         ),
         (
          7.9873872,
          2.9071712,
          -1.6379311,
         ),
         (
          7.7036166,
          3.5922554,
          -1.6379311,
         ),
         (
          7.3612156,
          4.25,
          -1.6379311,
         ),
         (
          6.9627924,
          4.8753996,
          -1.6379311,
         ),
         (
          6.5113778,
          5.463695,
          -1.6379311,
         ),
         (
          6.0104074,
          6.0104074,
          -1.6379311,
         ),
         (
          5.463695,
          6.5113778,
          -1.6379311,
         ),
         (
          4.8753996,
          6.9627924,
          -1.6379311,
         ),
         (
          4.25,
          7.3612156,
          -1.6379311,
         ),
         (
          3.5922554,
          7.7036166,
          -1.6379311,
         ),
         (
          2.9071712,
          7.9873872,
          -1.6379311,
         ),
         (
          2.1999619,
          8.2103691,
          -1.6379311,
         ),
         (
          1.4760095,
          8.3708658,
          -1.6379311,
         ),
         (
          0.74082381,
          8.4676552,
          -1.6379311,
         ),
         (
          5.2047491e-16,
          8.5,
          -1.6379311,
         ),
         (
          -0.74082381,
          8.4676552,
          -1.6379311,
         ),
         (
          -1.4760095,
          8.3708658,
          -1.6379311,
         ),
         (
          -2.1999619,
          8.2103691,
          -1.6379311,
         ),
         (
          -2.9071712,
          7.9873872,
          -1.6379311,
         ),
         (
          -3.5922554,
          7.7036166,
          -1.6379311,
         ),
         (
          -4.25,
          7.3612156,
          -1.6379311,
         ),
         (
          -4.8753996,
          6.9627924,
          -1.6379311,
         ),
         (
          -5.463695,
          6.5113778,
          -1.6379311,
         ),
         (
          -6.0104074,
          6.0104074,
          -1.6379311,
         ),
         (
          -6.5113778,
          5.463695,
          -1.6379311,
         ),
         (
          -6.9627924,
          4.8753996,
          -1.6379311,
         ),
         (
          -7.3612156,
          4.25,
          -1.6379311,
         ),
         (
          -7.7036166,
          3.5922554,
          -1.6379311,
         ),
         (
          -7.9873872,
          2.9071712,
          -1.6379311,
         ),
         (
          -8.2103691,
          2.1999619,
          -1.6379311,
         ),
         (
          -8.3708658,
          1.4760095,
          -1.6379311,
         ),
         (
          -8.4676552,
          0.74082381,
          -1.6379311,
         ),
         (
          -8.5,
          1.0409498e-15,
          -1.6379311,
         ),
         (
          -8.4676552,
          -0.74082381,
          -1.6379311,
         ),
         (
          -8.3708658,
          -1.4760095,
          -1.6379311,
         ),
         (
          -8.2103691,
          -2.1999619,
          -1.6379311,
         ),
         (
          -7.9873872,
          -2.9071712,
          -1.6379311,
         ),
         (
          -7.7036166,
          -3.5922554,
          -1.6379311,
         ),
         (
          -7.3612156,
          -4.25,
          -1.6379311,
         ),
         (
          -6.9627924,
          -4.8753996,
          -1.6379311,
         ),
         (
          -6.5113778,
          -5.463695,
          -1.6379311,
         ),
         (
          -6.0104074,
          -6.0104074,
          -1.6379311,
         ),
         (
          -5.463695,
          -6.5113778,
          -1.6379311,
         ),
         (
          -4.8753996,
          -6.9627924,
          -1.6379311,
         ),
         (
          -4.25,
          -7.3612156,
          -1.6379311,
         ),
         (
          -3.5922554,
          -7.7036166,
          -1.6379311,
         ),
         (
          -2.9071712,
          -7.9873872,
          -1.6379311,
         ),
         (
          -2.1999619,
          -8.2103691,
          -1.6379311,
         ),
         (
          -1.4760095,
          -8.3708658,
          -1.6379311,
         ),
         (
          -0.74082381,
          -8.4676552,
          -1.6379311,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -1.6379311,
         ),
         (
          0.74082381,
          -8.4676552,
          -1.6379311,
         ),
         (
          1.4760095,
          -8.3708658,
          -1.6379311,
         ),
         (
          2.1999619,
          -8.2103691,
          -1.6379311,
         ),
         (
          2.9071712,
          -7.9873872,
          -1.6379311,
         ),
         (
          3.5922554,
          -7.7036166,
          -1.6379311,
         ),
         (
          4.25,
          -7.3612156,
          -1.6379311,
         ),
         (
          4.8753996,
          -6.9627924,
          -1.6379311,
         ),
         (
          5.463695,
          -6.5113778,
          -1.6379311,
         ),
         (
          6.0104074,
          -6.0104074,
          -1.6379311,
         ),
         (
          6.5113778,
          -5.463695,
          -1.6379311,
         ),
         (
          6.9627924,
          -4.8753996,
          -1.6379311,
         ),
         (
          7.3612156,
          -4.25,
          -1.6379311,
         ),
         (
          7.7036166,
          -3.5922554,
          -1.6379311,
         ),
         (
          7.9873872,
          -2.9071712,
          -1.6379311,
         ),
         (
          8.2103691,
          -2.1999619,
          -1.6379311,
         ),
         (
          8.3708658,
          -1.4760095,
          -1.6379311,
         ),
         (
          8.4676552,
          -0.74082381,
          -1.6379311,
         ),
         (
          8.49191,
          0.37076479,
          -0.98275864,
         ),
         (
          8.4272814,
          1.1094725,
          -0.98275864,
         ),
         (
          8.2985163,
          1.8397368,
          -0.98275864,
         ),
         (
          8.1065941,
          2.5559993,
          -0.98275864,
         ),
         (
          7.8529758,
          3.252809,
          -0.98275864,
         ),
         (
          7.5395918,
          3.9248631,
          -0.98275864,
         ),
         (
          7.1688271,
          4.5670471,
          -0.98275864,
         ),
         (
          6.7435031,
          5.1744723,
          -0.98275864,
         ),
         (
          6.2668571,
          5.742517,
          -0.98275864,
         ),
         (
          5.742517,
          6.2668571,
          -0.98275864,
         ),
         (
          5.1744723,
          6.7435031,
          -0.98275864,
         ),
         (
          4.5670471,
          7.1688271,
          -0.98275864,
         ),
         (
          3.9248631,
          7.5395918,
          -0.98275864,
         ),
         (
          3.252809,
          7.8529758,
          -0.98275864,
         ),
         (
          2.5559993,
          8.1065941,
          -0.98275864,
         ),
         (
          1.8397368,
          8.2985163,
          -0.98275864,
         ),
         (
          1.1094725,
          8.4272814,
          -0.98275864,
         ),
         (
          0.37076479,
          8.49191,
          -0.98275864,
         ),
         (
          -0.37076479,
          8.49191,
          -0.98275864,
         ),
         (
          -1.1094725,
          8.4272814,
          -0.98275864,
         ),
         (
          -1.8397368,
          8.2985163,
          -0.98275864,
         ),
         (
          -2.5559993,
          8.1065941,
          -0.98275864,
         ),
         (
          -3.252809,
          7.8529758,
          -0.98275864,
         ),
         (
          -3.9248631,
          7.5395918,
          -0.98275864,
         ),
         (
          -4.5670471,
          7.1688271,
          -0.98275864,
         ),
         (
          -5.1744723,
          6.7435031,
          -0.98275864,
         ),
         (
          -5.742517,
          6.2668571,
          -0.98275864,
         ),
         (
          -6.2668571,
          5.742517,
          -0.98275864,
         ),
         (
          -6.7435031,
          5.1744723,
          -0.98275864,
         ),
         (
          -7.1688271,
          4.5670471,
          -0.98275864,
         ),
         (
          -7.5395918,
          3.9248631,
          -0.98275864,
         ),
         (
          -7.8529758,
          3.252809,
          -0.98275864,
         ),
         (
          -8.1065941,
          2.5559993,
          -0.98275864,
         ),
         (
          -8.2985163,
          1.8397368,
          -0.98275864,
         ),
         (
          -8.4272814,
          1.1094725,
          -0.98275864,
         ),
         (
          -8.49191,
          0.37076479,
          -0.98275864,
         ),
         (
          -8.49191,
          -0.37076479,
          -0.98275864,
         ),
         (
          -8.4272814,
          -1.1094725,
          -0.98275864,
         ),
         (
          -8.2985163,
          -1.8397368,
          -0.98275864,
         ),
         (
          -8.1065941,
          -2.5559993,
          -0.98275864,
         ),
         (
          -7.8529758,
          -3.252809,
          -0.98275864,
         ),
         (
          -7.5395918,
          -3.9248631,
          -0.98275864,
         ),
         (
          -7.1688271,
          -4.5670471,
          -0.98275864,
         ),
         (
          -6.7435031,
          -5.1744723,
          -0.98275864,
         ),
         (
          -6.2668571,
          -5.742517,
          -0.98275864,
         ),
         (
          -5.742517,
          -6.2668571,
          -0.98275864,
         ),
         (
          -5.1744723,
          -6.7435031,
          -0.98275864,
         ),
         (
          -4.5670471,
          -7.1688271,
          -0.98275864,
         ),
         (
          -3.9248631,
          -7.5395918,
          -0.98275864,
         ),
         (
          -3.252809,
          -7.8529758,
          -0.98275864,
         ),
         (
          -2.5559993,
          -8.1065941,
          -0.98275864,
         ),
         (
          -1.8397368,
          -8.2985163,
          -0.98275864,
         ),
         (
          -1.1094725,
          -8.4272814,
          -0.98275864,
         ),
         (
          -0.37076479,
          -8.49191,
          -0.98275864,
         ),
         (
          0.37076479,
          -8.49191,
          -0.98275864,
         ),
         (
          1.1094725,
          -8.4272814,
          -0.98275864,
         ),
         (
          1.8397368,
          -8.2985163,
          -0.98275864,
         ),
         (
          2.5559993,
          -8.1065941,
          -0.98275864,
         ),
         (
          3.252809,
          -7.8529758,
          -0.98275864,
         ),
         (
          3.9248631,
          -7.5395918,
          -0.98275864,
         ),
         (
          4.5670471,
          -7.1688271,
          -0.98275864,
         ),
         (
          5.1744723,
          -6.7435031,
          -0.98275864,
         ),
         (
          5.742517,
          -6.2668571,
          -0.98275864,
         ),
         (
          6.2668571,
          -5.742517,
          -0.98275864,
         ),
         (
          6.7435031,
          -5.1744723,
          -0.98275864,
         ),
         (
          7.1688271,
          -4.5670471,
          -0.98275864,
         ),
         (
          7.5395918,
          -3.9248631,
          -0.98275864,
         ),
         (
          7.8529758,
          -3.252809,
          -0.98275864,
         ),
         (
          8.1065941,
          -2.5559993,
          -0.98275864,
         ),
         (
          8.2985163,
          -1.8397368,
          -0.98275864,
         ),
         (
          8.4272814,
          -1.1094725,
          -0.98275864,
         ),
         (
          8.49191,
          -0.37076479,
          -0.98275864,
         ),
         (
          8.5,
          0.0,
          -0.3275862,
         ),
         (
          8.4676552,
          0.74082381,
          -0.3275862,
         ),
         (
          8.3708658,
          1.4760095,
          -0.3275862,
         ),
         (
          8.2103691,
          2.1999619,
          -0.3275862,
         ),
         (
          7.9873872,
          2.9071712,
          -0.3275862,
         ),
         (
          7.7036166,
          3.5922554,
          -0.3275862,
         ),
         (
          7.3612156,
          4.25,
          -0.3275862,
         ),
         (
          6.9627924,
          4.8753996,
          -0.3275862,
         ),
         (
          6.5113778,
          5.463695,
          -0.3275862,
         ),
         (
          6.0104074,
          6.0104074,
          -0.3275862,
         ),
         (
          5.463695,
          6.5113778,
          -0.3275862,
         ),
         (
          4.8753996,
          6.9627924,
          -0.3275862,
         ),
         (
          4.25,
          7.3612156,
          -0.3275862,
         ),
         (
          3.5922554,
          7.7036166,
          -0.3275862,
         ),
         (
          2.9071712,
          7.9873872,
          -0.3275862,
         ),
         (
          2.1999619,
          8.2103691,
          -0.3275862,
         ),
         (
          1.4760095,
          8.3708658,
          -0.3275862,
         ),
         (
          0.74082381,
          8.4676552,
          -0.3275862,
         ),
         (
          5.2047491e-16,
          8.5,
          -0.3275862,
         ),
         (
          -0.74082381,
          8.4676552,
          -0.3275862,
         ),
         (
          -1.4760095,
          8.3708658,
          -0.3275862,
         ),
         (
          -2.1999619,
          8.2103691,
          -0.3275862,
         ),
         (
          -2.9071712,
          7.9873872,
          -0.3275862,
         ),
         (
          -3.5922554,
          7.7036166,
          -0.3275862,
         ),
         (
          -4.25,
          7.3612156,
          -0.3275862,
         ),
         (
          -4.8753996,
          6.9627924,
          -0.3275862,
         ),
         (
          -5.463695,
          6.5113778,
          -0.3275862,
         ),
         (
          -6.0104074,
          6.0104074,
          -0.3275862,
         ),
         (
          -6.5113778,
          5.463695,
          -0.3275862,
         ),
         (
          -6.9627924,
          4.8753996,
          -0.3275862,
         ),
         (
          -7.3612156,
          4.25,
          -0.3275862,
         ),
         (
          -7.7036166,
          3.5922554,
          -0.3275862,
         ),
         (
          -7.9873872,
          2.9071712,
          -0.3275862,
         ),
         (
          -8.2103691,
          2.1999619,
          -0.3275862,
         ),
         (
          -8.3708658,
          1.4760095,
          -0.3275862,
         ),
         (
          -8.4676552,
          0.74082381,
          -0.3275862,
         ),
         (
          -8.5,
          1.0409498e-15,
          -0.3275862,
         ),
         (
          -8.4676552,
          -0.74082381,
          -0.3275862,
         ),
         (
          -8.3708658,
          -1.4760095,
          -0.3275862,
         ),
         (
          -8.2103691,
          -2.1999619,
          -0.3275862,
         ),
         (
          -7.9873872,
          -2.9071712,
          -0.3275862,
         ),
         (
          -7.7036166,
          -3.5922554,
          -0.3275862,
         ),
         (
          -7.3612156,
          -4.25,
          -0.3275862,
         ),
         (
          -6.9627924,
          -4.8753996,
          -0.3275862,
         ),
         (
          -6.5113778,
          -5.463695,
          -0.3275862,
         ),
         (
          -6.0104074,
          -6.0104074,
          -0.3275862,
         ),
         (
          -5.463695,
          -6.5113778,
          -0.3275862,
         ),
         (
          -4.8753996,
          -6.9627924,
          -0.3275862,
         ),
         (
          -4.25,
          -7.3612156,
          -0.3275862,
         ),
         (
          -3.5922554,
          -7.7036166,
          -0.3275862,
         ),
         (
          -2.9071712,
          -7.9873872,
          -0.3275862,
         ),
         (
          -2.1999619,
          -8.2103691,
          -0.3275862,
         ),
         (
          -1.4760095,
          -8.3708658,
          -0.3275862,
         ),
         (
          -0.74082381,
          -8.4676552,
          -0.3275862,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -0.3275862,
         ),
         (
          0.74082381,
          -8.4676552,
          -0.3275862,
         ),
         (
          1.4760095,
          -8.3708658,
          -0.3275862,
         ),
         (
          2.1999619,
          -8.2103691,
          -0.3275862,
         ),
         (
          2.9071712,
          -7.9873872,
          -0.3275862,
         ),
         (
          3.5922554,
          -7.7036166,
          -0.3275862,
         ),
         (
          4.25,
          -7.3612156,
          -0.3275862,
         ),
         (
          4.8753996,
          -6.9627924,
          -0.3275862,
         ),
         (
          5.463695,
          -6.5113778,
          -0.3275862,
         ),
         (
          6.0104074,
          -6.0104074,
          -0.3275862,
         ),
         (
          6.5113778,
          -5.463695,
          -0.3275862,
         ),
         (
          6.9627924,
          -4.8753996,
          -0.3275862,
         ),
         (
          7.3612156,
          -4.25,
          -0.3275862,
         ),
         (
          7.7036166,
          -3.5922554,
          -0.3275862,
         ),
         (
          7.9873872,
          -2.9071712,
          -0.3275862,
         ),
         (
          8.2103691,
          -2.1999619,
          -0.3275862,
         ),
         (
          8.3708658,
          -1.4760095,
          -0.3275862,
         ),
         (
          8.4676552,
          -0.74082381,
          -0.3275862,
         ),
         (
          8.49191,
          0.37076479,
          0.3275862,
         ),
         (
          8.4272814,
          1.1094725,
          0.3275862,
         ),
         (
          8.2985163,
          1.8397368,
          0.3275862,
         ),
         (
          8.1065941,
          2.5559993,
          0.3275862,
         ),
         (
          7.8529758,
          3.252809,
          0.3275862,
         ),
         (
          7.5395918,
          3.9248631,
          0.3275862,
         ),
         (
          7.1688271,
          4.5670471,
          0.3275862,
         ),
         (
          6.7435031,
          5.1744723,
          0.3275862,
         ),
         (
          6.2668571,
          5.742517,
          0.3275862,
         ),
         (
          5.742517,
          6.2668571,
          0.3275862,
         ),
         (
          5.1744723,
          6.7435031,
          0.3275862,
         ),
         (
          4.5670471,
          7.1688271,
          0.3275862,
         ),
         (
          3.9248631,
          7.5395918,
          0.3275862,
         ),
         (
          3.252809,
          7.8529758,
          0.3275862,
         ),
         (
          2.5559993,
          8.1065941,
          0.3275862,
         ),
         (
          1.8397368,
          8.2985163,
          0.3275862,
         ),
         (
          1.1094725,
          8.4272814,
          0.3275862,
         ),
         (
          0.37076479,
          8.49191,
          0.3275862,
         ),
         (
          -0.37076479,
          8.49191,
          0.3275862,
         ),
         (
          -1.1094725,
          8.4272814,
          0.3275862,
         ),
         (
          -1.8397368,
          8.2985163,
          0.3275862,
         ),
         (
          -2.5559993,
          8.1065941,
          0.3275862,
         ),
         (
          -3.252809,
          7.8529758,
          0.3275862,
         ),
         (
          -3.9248631,
          7.5395918,
          0.3275862,
         ),
         (
          -4.5670471,
          7.1688271,
          0.3275862,
         ),
         (
          -5.1744723,
          6.7435031,
          0.3275862,
         ),
         (
          -5.742517,
          6.2668571,
          0.3275862,
         ),
         (
          -6.2668571,
          5.742517,
          0.3275862,
         ),
         (
          -6.7435031,
          5.1744723,
          0.3275862,
         ),
         (
          -7.1688271,
          4.5670471,
          0.3275862,
         ),
         (
          -7.5395918,
          3.9248631,
          0.3275862,
         ),
         (
          -7.8529758,
          3.252809,
          0.3275862,
         ),
         (
          -8.1065941,
          2.5559993,
          0.3275862,
         ),
         (
          -8.2985163,
          1.8397368,
          0.3275862,
         ),
         (
          -8.4272814,
          1.1094725,
          0.3275862,
         ),
         (
          -8.49191,
          0.37076479,
          0.3275862,
         ),
         (
          -8.49191,
          -0.37076479,
          0.3275862,
         ),
         (
          -8.4272814,
          -1.1094725,
          0.3275862,
         ),
         (
          -8.2985163,
          -1.8397368,
          0.3275862,
         ),
         (
          -8.1065941,
          -2.5559993,
          0.3275862,
         ),
         (
          -7.8529758,
          -3.252809,
          0.3275862,
         ),
         (
          -7.5395918,
          -3.9248631,
          0.3275862,
         ),
         (
          -7.1688271,
          -4.5670471,
          0.3275862,
         ),
         (
          -6.7435031,
          -5.1744723,
          0.3275862,
         ),
         (
          -6.2668571,
          -5.742517,
          0.3275862,
         ),
         (
          -5.742517,
          -6.2668571,
          0.3275862,
         ),
         (
          -5.1744723,
          -6.7435031,
          0.3275862,
         ),
         (
          -4.5670471,
          -7.1688271,
          0.3275862,
         ),
         (
          -3.9248631,
          -7.5395918,
          0.3275862,
         ),
         (
          -3.252809,
          -7.8529758,
          0.3275862,
         ),
         (
          -2.5559993,
          -8.1065941,
          0.3275862,
         ),
         (
          -1.8397368,
          -8.2985163,
          0.3275862,
         ),
         (
          -1.1094725,
          -8.4272814,
          0.3275862,
         ),
         (
          -0.37076479,
          -8.49191,
          0.3275862,
         ),
         (
          0.37076479,
          -8.49191,
          0.3275862,
         ),
         (
          1.1094725,
          -8.4272814,
          0.3275862,
         ),
         (
          1.8397368,
          -8.2985163,
          0.3275862,
         ),
         (
          2.5559993,
          -8.1065941,
          0.3275862,
         ),
         (
          3.252809,
          -7.8529758,
          0.3275862,
         ),
         (
          3.9248631,
          -7.5395918,
          0.3275862,
         ),
         (
          4.5670471,
          -7.1688271,
          0.3275862,
         ),
         (
          5.1744723,
          -6.7435031,
          0.3275862,
         ),
         (
          5.742517,
          -6.2668571,
          0.3275862,
         ),
         (
          6.2668571,
          -5.742517,
          0.3275862,
         ),
         (
          6.7435031,
          -5.1744723,
          0.3275862,
         ),
         (
          7.1688271,
          -4.5670471,
          0.3275862,
         ),
         (
          7.5395918,
          -3.9248631,
          0.3275862,
         ),
         (
          7.8529758,
          -3.252809,
          0.3275862,
         ),
         (
          8.1065941,
          -2.5559993,
          0.3275862,
         ),
         (
          8.2985163,
          -1.8397368,
          0.3275862,
         ),
         (
          8.4272814,
          -1.1094725,
          0.3275862,
         ),
         (
          8.49191,
          -0.37076479,
          0.3275862,
         ),
         (
          8.5,
          0.0,
          0.98275864,
         ),
         (
          8.4676552,
          0.74082381,
          0.98275864,
         ),
         (
          8.3708658,
          1.4760095,
          0.98275864,
         ),
         (
          8.2103691,
          2.1999619,
          0.98275864,
         ),
         (
          7.9873872,
          2.9071712,
          0.98275864,
         ),
         (
          7.7036166,
          3.5922554,
          0.98275864,
         ),
         (
          7.3612156,
          4.25,
          0.98275864,
         ),
         (
          6.9627924,
          4.8753996,
          0.98275864,
         ),
         (
          6.5113778,
          5.463695,
          0.98275864,
         ),
         (
          6.0104074,
          6.0104074,
          0.98275864,
         ),
         (
          5.463695,
          6.5113778,
          0.98275864,
         ),
         (
          4.8753996,
          6.9627924,
          0.98275864,
         ),
         (
          4.25,
          7.3612156,
          0.98275864,
         ),
         (
          3.5922554,
          7.7036166,
          0.98275864,
         ),
         (
          2.9071712,
          7.9873872,
          0.98275864,
         ),
         (
          2.1999619,
          8.2103691,
          0.98275864,
         ),
         (
          1.4760095,
          8.3708658,
          0.98275864,
         ),
         (
          0.74082381,
          8.4676552,
          0.98275864,
         ),
         (
          5.2047491e-16,
          8.5,
          0.98275864,
         ),
         (
          -0.74082381,
          8.4676552,
          0.98275864,
         ),
         (
          -1.4760095,
          8.3708658,
          0.98275864,
         ),
         (
          -2.1999619,
          8.2103691,
          0.98275864,
         ),
         (
          -2.9071712,
          7.9873872,
          0.98275864,
         ),
         (
          -3.5922554,
          7.7036166,
          0.98275864,
         ),
         (
          -4.25,
          7.3612156,
          0.98275864,
         ),
         (
          -4.8753996,
          6.9627924,
          0.98275864,
         ),
         (
          -5.463695,
          6.5113778,
          0.98275864,
         ),
         (
          -6.0104074,
          6.0104074,
          0.98275864,
         ),
         (
          -6.5113778,
          5.463695,
          0.98275864,
         ),
         (
          -6.9627924,
          4.8753996,
          0.98275864,
         ),
         (
          -7.3612156,
          4.25,
          0.98275864,
         ),
         (
          -7.7036166,
          3.5922554,
          0.98275864,
         ),
         (
          -7.9873872,
          2.9071712,
          0.98275864,
         ),
         (
          -8.2103691,
          2.1999619,
          0.98275864,
         ),
         (
          -8.3708658,
          1.4760095,
          0.98275864,
         ),
         (
          -8.4676552,
          0.74082381,
          0.98275864,
         ),
         (
          -8.5,
          1.0409498e-15,
          0.98275864,
         ),
         (
          -8.4676552,
          -0.74082381,
          0.98275864,
         ),
         (
          -8.3708658,
          -1.4760095,
          0.98275864,
         ),
         (
          -8.2103691,
          -2.1999619,
          0.98275864,
         ),
         (
          -7.9873872,
          -2.9071712,
          0.98275864,
         ),
         (
          -7.7036166,
          -3.5922554,
          0.98275864,
         ),
         (
          -7.3612156,
          -4.25,
          0.98275864,
         ),
         (
          -6.9627924,
          -4.8753996,
          0.98275864,
         ),
         (
          -6.5113778,
          -5.463695,
          0.98275864,
         ),
         (
          -6.0104074,
          -6.0104074,
          0.98275864,
         ),
         (
          -5.463695,
          -6.5113778,
          0.98275864,
         ),
         (
          -4.8753996,
          -6.9627924,
          0.98275864,
         ),
         (
          -4.25,
          -7.3612156,
          0.98275864,
         ),
         (
          -3.5922554,
          -7.7036166,
          0.98275864,
         ),
         (
          -2.9071712,
          -7.9873872,
          0.98275864,
         ),
         (
          -2.1999619,
          -8.2103691,
          0.98275864,
         ),
         (
          -1.4760095,
          -8.3708658,
          0.98275864,
         ),
         (
          -0.74082381,
          -8.4676552,
          0.98275864,
         ),
         (
          -1.5614247e-15,
          -8.5,
          0.98275864,
         ),
         (
          0.74082381,
          -8.4676552,
          0.98275864,
         ),
         (
          1.4760095,
          -8.3708658,
          0.98275864,
         ),
         (
          2.1999619,
          -8.2103691,
          0.98275864,
         ),
         (
          2.9071712,
          -7.9873872,
          0.98275864,
         ),
         (
          3.5922554,
          -7.7036166,
          0.98275864,
         ),
         (
          4.25,
          -7.3612156,
          0.98275864,
         ),
         (
          4.8753996,
          -6.9627924,
          0.98275864,
         ),
         (
          5.463695,
          -6.5113778,
          0.98275864,
         ),
         (
          6.0104074,
          -6.0104074,
          0.98275864,
         ),
         (
          6.5113778,
          -5.463695,
          0.98275864,
         ),
         (
          6.9627924,
          -4.8753996,
          0.98275864,
         ),
         (
          7.3612156,
          -4.25,
          0.98275864,
         ),
         (
          7.7036166,
          -3.5922554,
          0.98275864,
         ),
         (
          7.9873872,
          -2.9071712,
          0.98275864,
         ),
         (
          8.2103691,
          -2.1999619,
          0.98275864,
         ),
         (
          8.3708658,
          -1.4760095,
          0.98275864,
         ),
         (
          8.4676552,
          -0.74082381,
          0.98275864,
         ),
         (
          8.49191,
          0.37076479,
          1.6379311,
         ),
         (
          8.4272814,
          1.1094725,
          1.6379311,
         ),
         (
          8.2985163,
          1.8397368,
          1.6379311,
         ),
         (
          8.1065941,
          2.5559993,
          1.6379311,
         ),
         (
          7.8529758,
          3.252809,
          1.6379311,
         ),
         (
          7.5395918,
          3.9248631,
          1.6379311,
         ),
         (
          7.1688271,
          4.5670471,
          1.6379311,
         ),
         (
          6.7435031,
          5.1744723,
          1.6379311,
         ),
         (
          6.2668571,
          5.742517,
          1.6379311,
         ),
         (
          5.742517,
          6.2668571,
          1.6379311,
         ),
         (
          5.1744723,
          6.7435031,
          1.6379311,
         ),
         (
          4.5670471,
          7.1688271,
          1.6379311,
         ),
         (
          3.9248631,
          7.5395918,
          1.6379311,
         ),
         (
          3.252809,
          7.8529758,
          1.6379311,
         ),
         (
          2.5559993,
          8.1065941,
          1.6379311,
         ),
         (
          1.8397368,
          8.2985163,
          1.6379311,
         ),
         (
          1.1094725,
          8.4272814,
          1.6379311,
         ),
         (
          0.37076479,
          8.49191,
          1.6379311,
         ),
         (
          -0.37076479,
          8.49191,
          1.6379311,
         ),
         (
          -1.1094725,
          8.4272814,
          1.6379311,
         ),
         (
          -1.8397368,
          8.2985163,
          1.6379311,
         ),
         (
          -2.5559993,
          8.1065941,
          1.6379311,
         ),
         (
          -3.252809,
          7.8529758,
          1.6379311,
         ),
         (
          -3.9248631,
          7.5395918,
          1.6379311,
         ),
         (
          -4.5670471,
          7.1688271,
          1.6379311,
         ),
         (
          -5.1744723,
          6.7435031,
          1.6379311,
         ),
         (
          -5.742517,
          6.2668571,
          1.6379311,
         ),
         (
          -6.2668571,
          5.742517,
          1.6379311,
         ),
         (
          -6.7435031,
          5.1744723,
          1.6379311,
         ),
         (
          -7.1688271,
          4.5670471,
          1.6379311,
         ),
         (
          -7.5395918,
          3.9248631,
          1.6379311,
         ),
         (
          -7.8529758,
          3.252809,
          1.6379311,
         ),
         (
          -8.1065941,
          2.5559993,
          1.6379311,
         ),
         (
          -8.2985163,
          1.8397368,
          1.6379311,
         ),
         (
          -8.4272814,
          1.1094725,
          1.6379311,
         ),
         (
          -8.49191,
          0.37076479,
          1.6379311,
         ),
         (
          -8.49191,
          -0.37076479,
          1.6379311,
         ),
         (
          -8.4272814,
          -1.1094725,
          1.6379311,
         ),
         (
          -8.2985163,
          -1.8397368,
          1.6379311,
         ),
         (
          -8.1065941,
          -2.5559993,
          1.6379311,
         ),
         (
          -7.8529758,
          -3.252809,
          1.6379311,
         ),
         (
          -7.5395918,
          -3.9248631,
          1.6379311,
         ),
         (
          -7.1688271,
          -4.5670471,
          1.6379311,
         ),
         (
          -6.7435031,
          -5.1744723,
          1.6379311,
         ),
         (
          -6.2668571,
          -5.742517,
          1.6379311,
         ),
         (
          -5.742517,
          -6.2668571,
          1.6379311,
         ),
         (
          -5.1744723,
          -6.7435031,
          1.6379311,
         ),
         (
          -4.5670471,
          -7.1688271,
          1.6379311,
         ),
         (
          -3.9248631,
          -7.5395918,
          1.6379311,
         ),
         (
          -3.252809,
          -7.8529758,
          1.6379311,
         ),
         (
          -2.5559993,
          -8.1065941,
          1.6379311,
         ),
         (
          -1.8397368,
          -8.2985163,
          1.6379311,
         ),
         (
          -1.1094725,
          -8.4272814,
          1.6379311,
         ),
         (
          -0.37076479,
          -8.49191,
          1.6379311,
         ),
         (
          0.37076479,
          -8.49191,
          1.6379311,
         ),
         (
          1.1094725,
          -8.4272814,
          1.6379311,
         ),
         (
          1.8397368,
          -8.2985163,
          1.6379311,
         ),
         (
          2.5559993,
          -8.1065941,
          1.6379311,
         ),
         (
          3.252809,
          -7.8529758,
          1.6379311,
         ),
         (
          3.9248631,
          -7.5395918,
          1.6379311,
         ),
         (
          4.5670471,
          -7.1688271,
          1.6379311,
         ),
         (
          5.1744723,
          -6.7435031,
          1.6379311,
         ),
         (
          5.742517,
          -6.2668571,
          1.6379311,
         ),
         (
          6.2668571,
          -5.742517,
          1.6379311,
         ),
         (
          6.7435031,
          -5.1744723,
          1.6379311,
         ),
         (
          7.1688271,
          -4.5670471,
          1.6379311,
         ),
         (
          7.5395918,
          -3.9248631,
          1.6379311,
         ),
         (
          7.8529758,
          -3.252809,
          1.6379311,
         ),
         (
          8.1065941,
          -2.5559993,
          1.6379311,
         ),
         (
          8.2985163,
          -1.8397368,
          1.6379311,
         ),
         (
          8.4272814,
          -1.1094725,
          1.6379311,
         ),
         (
          8.49191,
          -0.37076479,
          1.6379311,
         ),
         (
          8.5,
          0.0,
          2.2931035,
         ),
         (
          8.4676552,
          0.74082381,
          2.2931035,
         ),
         (
          8.3708658,
          1.4760095,
          2.2931035,
         ),
         (
          8.2103691,
          2.1999619,
          2.2931035,
         ),
         (
          7.9873872,
          2.9071712,
          2.2931035,
         ),
         (
          7.7036166,
          3.5922554,
          2.2931035,
         ),
         (
          7.3612156,
          4.25,
          2.2931035,
         ),
         (
          6.9627924,
          4.8753996,
          2.2931035,
         ),
         (
          6.5113778,
          5.463695,
          2.2931035,
         ),
         (
          6.0104074,
          6.0104074,
          2.2931035,
         ),
         (
          5.463695,
          6.5113778,
          2.2931035,
         ),
         (
          4.8753996,
          6.9627924,
          2.2931035,
         ),
         (
          4.25,
          7.3612156,
          2.2931035,
         ),
         (
          3.5922554,
          7.7036166,
          2.2931035,
         ),
         (
          2.9071712,
          7.9873872,
          2.2931035,
         ),
         (
          2.1999619,
          8.2103691,
          2.2931035,
         ),
         (
          1.4760095,
          8.3708658,
          2.2931035,
         ),
         (
          0.74082381,
          8.4676552,
          2.2931035,
         ),
         (
          5.2047491e-16,
          8.5,
          2.2931035,
         ),
         (
          -0.74082381,
          8.4676552,
          2.2931035,
         ),
         (
          -1.4760095,
          8.3708658,
          2.2931035,
         ),
         (
          -2.1999619,
          8.2103691,
          2.2931035,
         ),
         (
          -2.9071712,
          7.9873872,
          2.2931035,
         ),
         (
          -3.5922554,
          7.7036166,
          2.2931035,
         ),
         (
          -4.25,
          7.3612156,
          2.2931035,
         ),
         (
          -4.8753996,
          6.9627924,
          2.2931035,
         ),
         (
          -5.463695,
          6.5113778,
          2.2931035,
         ),
         (
          -6.0104074,
          6.0104074,
          2.2931035,
         ),
         (
          -6.5113778,
          5.463695,
          2.2931035,
         ),
         (
          -6.9627924,
          4.8753996,
          2.2931035,
         ),
         (
          -7.3612156,
          4.25,
          2.2931035,
         ),
         (
          -7.7036166,
          3.5922554,
          2.2931035,
         ),
         (
          -7.9873872,
          2.9071712,
          2.2931035,
         ),
         (
          -8.2103691,
          2.1999619,
          2.2931035,
         ),
         (
          -8.3708658,
          1.4760095,
          2.2931035,
         ),
         (
          -8.4676552,
          0.74082381,
          2.2931035,
         ),
         (
          -8.5,
          1.0409498e-15,
          2.2931035,
         ),
         (
          -8.4676552,
          -0.74082381,
          2.2931035,
         ),
         (
          -8.3708658,
          -1.4760095,
          2.2931035,
         ),
         (
          -8.2103691,
          -2.1999619,
          2.2931035,
         ),
         (
          -7.9873872,
          -2.9071712,
          2.2931035,
         ),
         (
          -7.7036166,
          -3.5922554,
          2.2931035,
         ),
         (
          -7.3612156,
          -4.25,
          2.2931035,
         ),
         (
          -6.9627924,
          -4.8753996,
          2.2931035,
         ),
         (
          -6.5113778,
          -5.463695,
          2.2931035,
         ),
         (
          -6.0104074,
          -6.0104074,
          2.2931035,
         ),
         (
          -5.463695,
          -6.5113778,
          2.2931035,
         ),
         (
          -4.8753996,
          -6.9627924,
          2.2931035,
         ),
         (
          -4.25,
          -7.3612156,
          2.2931035,
         ),
         (
          -3.5922554,
          -7.7036166,
          2.2931035,
         ),
         (
          -2.9071712,
          -7.9873872,
          2.2931035,
         ),
         (
          -2.1999619,
          -8.2103691,
          2.2931035,
         ),
         (
          -1.4760095,
          -8.3708658,
          2.2931035,
         ),
         (
          -0.74082381,
          -8.4676552,
          2.2931035,
         ),
         (
          -1.5614247e-15,
          -8.5,
          2.2931035,
         ),
         (
          0.74082381,
          -8.4676552,
          2.2931035,
         ),
         (
          1.4760095,
          -8.3708658,
          2.2931035,
         ),
         (
          2.1999619,
          -8.2103691,
          2.2931035,
         ),
         (
          2.9071712,
          -7.9873872,
          2.2931035,
         ),
         (
          3.5922554,
          -7.7036166,
          2.2931035,
         ),
         (
          4.25,
          -7.3612156,
          2.2931035,
         ),
         (
          4.8753996,
          -6.9627924,
          2.2931035,
         ),
         (
          5.463695,
          -6.5113778,
          2.2931035,
         ),
         (
          6.0104074,
          -6.0104074,
          2.2931035,
         ),
         (
          6.5113778,
          -5.463695,
          2.2931035,
         ),
         (
          6.9627924,
          -4.8753996,
          2.2931035,
         ),
         (
          7.3612156,
          -4.25,
          2.2931035,
         ),
         (
          7.7036166,
          -3.5922554,
          2.2931035,
         ),
         (
          7.9873872,
          -2.9071712,
          2.2931035,
         ),
         (
          8.2103691,
          -2.1999619,
          2.2931035,
         ),
         (
          8.3708658,
          -1.4760095,
          2.2931035,
         ),
         (
          8.4676552,
          -0.74082381,
          2.2931035,
         ),
         (
          8.49191,
          0.37076479,
          2.9482758,
         ),
         (
          8.4272814,
          1.1094725,
          2.9482758,
         ),
         (
          8.2985163,
          1.8397368,
          2.9482758,
         ),
         (
          8.1065941,
          2.5559993,
          2.9482758,
         ),
         (
          7.8529758,
          3.252809,
          2.9482758,
         ),
         (
          7.5395918,
          3.9248631,
          2.9482758,
         ),
         (
          7.1688271,
          4.5670471,
          2.9482758,
         ),
         (
          6.7435031,
          5.1744723,
          2.9482758,
         ),
         (
          6.2668571,
          5.742517,
          2.9482758,
         ),
         (
          5.742517,
          6.2668571,
          2.9482758,
         ),
         (
          5.1744723,
          6.7435031,
          2.9482758,
         ),
         (
          4.5670471,
          7.1688271,
          2.9482758,
         ),
         (
          3.9248631,
          7.5395918,
          2.9482758,
         ),
         (
          3.252809,
          7.8529758,
          2.9482758,
         ),
         (
          2.5559993,
          8.1065941,
          2.9482758,
         ),
         (
          1.8397368,
          8.2985163,
          2.9482758,
         ),
         (
          1.1094725,
          8.4272814,
          2.9482758,
         ),
         (
          0.37076479,
          8.49191,
          2.9482758,
         ),
         (
          -0.37076479,
          8.49191,
          2.9482758,
         ),
         (
          -1.1094725,
          8.4272814,
          2.9482758,
         ),
         (
          -1.8397368,
          8.2985163,
          2.9482758,
         ),
         (
          -2.5559993,
          8.1065941,
          2.9482758,
         ),
         (
          -3.252809,
          7.8529758,
          2.9482758,
         ),
         (
          -3.9248631,
          7.5395918,
          2.9482758,
         ),
         (
          -4.5670471,
          7.1688271,
          2.9482758,
         ),
         (
          -5.1744723,
          6.7435031,
          2.9482758,
         ),
         (
          -5.742517,
          6.2668571,
          2.9482758,
         ),
         (
          -6.2668571,
          5.742517,
          2.9482758,
         ),
         (
          -6.7435031,
          5.1744723,
          2.9482758,
         ),
         (
          -7.1688271,
          4.5670471,
          2.9482758,
         ),
         (
          -7.5395918,
          3.9248631,
          2.9482758,
         ),
         (
          -7.8529758,
          3.252809,
          2.9482758,
         ),
         (
          -8.1065941,
          2.5559993,
          2.9482758,
         ),
         (
          -8.2985163,
          1.8397368,
          2.9482758,
         ),
         (
          -8.4272814,
          1.1094725,
          2.9482758,
         ),
         (
          -8.49191,
          0.37076479,
          2.9482758,
         ),
         (
          -8.49191,
          -0.37076479,
          2.9482758,
         ),
         (
          -8.4272814,
          -1.1094725,
          2.9482758,
         ),
         (
          -8.2985163,
          -1.8397368,
          2.9482758,
         ),
         (
          -8.1065941,
          -2.5559993,
          2.9482758,
         ),
         (
          -7.8529758,
          -3.252809,
          2.9482758,
         ),
         (
          -7.5395918,
          -3.9248631,
          2.9482758,
         ),
         (
          -7.1688271,
          -4.5670471,
          2.9482758,
         ),
         (
          -6.7435031,
          -5.1744723,
          2.9482758,
         ),
         (
          -6.2668571,
          -5.742517,
          2.9482758,
         ),
         (
          -5.742517,
          -6.2668571,
          2.9482758,
         ),
         (
          -5.1744723,
          -6.7435031,
          2.9482758,
         ),
         (
          -4.5670471,
          -7.1688271,
          2.9482758,
         ),
         (
          -3.9248631,
          -7.5395918,
          2.9482758,
         ),
         (
          -3.252809,
          -7.8529758,
          2.9482758,
         ),
         (
          -2.5559993,
          -8.1065941,
          2.9482758,
         ),
         (
          -1.8397368,
          -8.2985163,
          2.9482758,
         ),
         (
          -1.1094725,
          -8.4272814,
          2.9482758,
         ),
         (
          -0.37076479,
          -8.49191,
          2.9482758,
         ),
         (
          0.37076479,
          -8.49191,
          2.9482758,
         ),
         (
          1.1094725,
          -8.4272814,
          2.9482758,
         ),
         (
          1.8397368,
          -8.2985163,
          2.9482758,
         ),
         (
          2.5559993,
          -8.1065941,
          2.9482758,
         ),
         (
          3.252809,
          -7.8529758,
          2.9482758,
         ),
         (
          3.9248631,
          -7.5395918,
          2.9482758,
         ),
         (
          4.5670471,
          -7.1688271,
          2.9482758,
         ),
         (
          5.1744723,
          -6.7435031,
          2.9482758,
         ),
         (
          5.742517,
          -6.2668571,
          2.9482758,
         ),
         (
          6.2668571,
          -5.742517,
          2.9482758,
         ),
         (
          6.7435031,
          -5.1744723,
          2.9482758,
         ),
         (
          7.1688271,
          -4.5670471,
          2.9482758,
         ),
         (
          7.5395918,
          -3.9248631,
          2.9482758,
         ),
         (
          7.8529758,
          -3.252809,
          2.9482758,
         ),
         (
          8.1065941,
          -2.5559993,
          2.9482758,
         ),
         (
          8.2985163,
          -1.8397368,
          2.9482758,
         ),
         (
          8.4272814,
          -1.1094725,
          2.9482758,
         ),
         (
          8.49191,
          -0.37076479,
          2.9482758,
         ),
         (
          8.5,
          0.0,
          3.6034482,
         ),
         (
          8.4676552,
          0.74082381,
          3.6034482,
         ),
         (
          8.3708658,
          1.4760095,
          3.6034482,
         ),
         (
          8.2103691,
          2.1999619,
          3.6034482,
         ),
         (
          7.9873872,
          2.9071712,
          3.6034482,
         ),
         (
          7.7036166,
          3.5922554,
          3.6034482,
         ),
         (
          7.3612156,
          4.25,
          3.6034482,
         ),
         (
          6.9627924,
          4.8753996,
          3.6034482,
         ),
         (
          6.5113778,
          5.463695,
          3.6034482,
         ),
         (
          6.0104074,
          6.0104074,
          3.6034482,
         ),
         (
          5.463695,
          6.5113778,
          3.6034482,
         ),
         (
          4.8753996,
          6.9627924,
          3.6034482,
         ),
         (
          4.25,
          7.3612156,
          3.6034482,
         ),
         (
          3.5922554,
          7.7036166,
          3.6034482,
         ),
         (
          2.9071712,
          7.9873872,
          3.6034482,
         ),
         (
          2.1999619,
          8.2103691,
          3.6034482,
         ),
         (
          1.4760095,
          8.3708658,
          3.6034482,
         ),
         (
          0.74082381,
          8.4676552,
          3.6034482,
         ),
         (
          5.2047491e-16,
          8.5,
          3.6034482,
         ),
         (
          -0.74082381,
          8.4676552,
          3.6034482,
         ),
         (
          -1.4760095,
          8.3708658,
          3.6034482,
         ),
         (
          -2.1999619,
          8.2103691,
          3.6034482,
         ),
         (
          -2.9071712,
          7.9873872,
          3.6034482,
         ),
         (
          -3.5922554,
          7.7036166,
          3.6034482,
         ),
         (
          -4.25,
          7.3612156,
          3.6034482,
         ),
         (
          -4.8753996,
          6.9627924,
          3.6034482,
         ),
         (
          -5.463695,
          6.5113778,
          3.6034482,
         ),
         (
          -6.0104074,
          6.0104074,
          3.6034482,
         ),
         (
          -6.5113778,
          5.463695,
          3.6034482,
         ),
         (
          -6.9627924,
          4.8753996,
          3.6034482,
         ),
         (
          -7.3612156,
          4.25,
          3.6034482,
         ),
         (
          -7.7036166,
          3.5922554,
          3.6034482,
         ),
         (
          -7.9873872,
          2.9071712,
          3.6034482,
         ),
         (
          -8.2103691,
          2.1999619,
          3.6034482,
         ),
         (
          -8.3708658,
          1.4760095,
          3.6034482,
         ),
         (
          -8.4676552,
          0.74082381,
          3.6034482,
         ),
         (
          -8.5,
          1.0409498e-15,
          3.6034482,
         ),
         (
          -8.4676552,
          -0.74082381,
          3.6034482,
         ),
         (
          -8.3708658,
          -1.4760095,
          3.6034482,
         ),
         (
          -8.2103691,
          -2.1999619,
          3.6034482,
         ),
         (
          -7.9873872,
          -2.9071712,
          3.6034482,
         ),
         (
          -7.7036166,
          -3.5922554,
          3.6034482,
         ),
         (
          -7.3612156,
          -4.25,
          3.6034482,
         ),
         (
          -6.9627924,
          -4.8753996,
          3.6034482,
         ),
         (
          -6.5113778,
          -5.463695,
          3.6034482,
         ),
         (
          -6.0104074,
          -6.0104074,
          3.6034482,
         ),
         (
          -5.463695,
          -6.5113778,
          3.6034482,
         ),
         (
          -4.8753996,
          -6.9627924,
          3.6034482,
         ),
         (
          -4.25,
          -7.3612156,
          3.6034482,
         ),
         (
          -3.5922554,
          -7.7036166,
          3.6034482,
         ),
         (
          -2.9071712,
          -7.9873872,
          3.6034482,
         ),
         (
          -2.1999619,
          -8.2103691,
          3.6034482,
         ),
         (
          -1.4760095,
          -8.3708658,
          3.6034482,
         ),
         (
          -0.74082381,
          -8.4676552,
          3.6034482,
         ),
         (
          -1.5614247e-15,
          -8.5,
          3.6034482,
         ),
         (
          0.74082381,
          -8.4676552,
          3.6034482,
         ),
         (
          1.4760095,
          -8.3708658,
          3.6034482,
         ),
         (
          2.1999619,
          -8.2103691,
          3.6034482,
         ),
         (
          2.9071712,
          -7.9873872,
          3.6034482,
         ),
         (
          3.5922554,
          -7.7036166,
          3.6034482,
         ),
         (
          4.25,
          -7.3612156,
          3.6034482,
         ),
         (
          4.8753996,
          -6.9627924,
          3.6034482,
         ),
         (
          5.463695,
          -6.5113778,
          3.6034482,
         ),
         (
          6.0104074,
          -6.0104074,
          3.6034482,
         ),
         (
          6.5113778,
          -5.463695,
          3.6034482,
         ),
         (
          6.9627924,
          -4.8753996,
          3.6034482,
         ),
         (
          7.3612156,
          -4.25,
          3.6034482,
         ),
         (
          7.7036166,
          -3.5922554,
          3.6034482,
         ),
         (
          7.9873872,
          -2.9071712,
          3.6034482,
         ),
         (
          8.2103691,
          -2.1999619,
          3.6034482,
         ),
         (
          8.3708658,
          -1.4760095,
          3.6034482,
         ),
         (
          8.4676552,
          -0.74082381,
          3.6034482,
         ),
         (
          8.49191,
          0.37076479,
          4.2586207,
         ),
         (
          8.4272814,
          1.1094725,
          4.2586207,
         ),
         (
          8.2985163,
          1.8397368,
          4.2586207,
         ),
         (
          8.1065941,
          2.5559993,
          4.2586207,
         ),
         (
          7.8529758,
          3.252809,
          4.2586207,
         ),
         (
          7.5395918,
          3.9248631,
          4.2586207,
         ),
         (
          7.1688271,
          4.5670471,
          4.2586207,
         ),
         (
          6.7435031,
          5.1744723,
          4.2586207,
         ),
         (
          6.2668571,
          5.742517,
          4.2586207,
         ),
         (
          5.742517,
          6.2668571,
          4.2586207,
         ),
         (
          5.1744723,
          6.7435031,
          4.2586207,
         ),
         (
          4.5670471,
          7.1688271,
          4.2586207,
         ),
         (
          3.9248631,
          7.5395918,
          4.2586207,
         ),
         (
          3.252809,
          7.8529758,
          4.2586207,
         ),
         (
          2.5559993,
          8.1065941,
          4.2586207,
         ),
         (
          1.8397368,
          8.2985163,
          4.2586207,
         ),
         (
          1.1094725,
          8.4272814,
          4.2586207,
         ),
         (
          0.37076479,
          8.49191,
          4.2586207,
         ),
         (
          -0.37076479,
          8.49191,
          4.2586207,
         ),
         (
          -1.1094725,
          8.4272814,
          4.2586207,
         ),
         (
          -1.8397368,
          8.2985163,
          4.2586207,
         ),
         (
          -2.5559993,
          8.1065941,
          4.2586207,
         ),
         (
          -3.252809,
          7.8529758,
          4.2586207,
         ),
         (
          -3.9248631,
          7.5395918,
          4.2586207,
         ),
         (
          -4.5670471,
          7.1688271,
          4.2586207,
         ),
         (
          -5.1744723,
          6.7435031,
          4.2586207,
         ),
         (
          -5.742517,
          6.2668571,
          4.2586207,
         ),
         (
          -6.2668571,
          5.742517,
          4.2586207,
         ),
         (
          -6.7435031,
          5.1744723,
          4.2586207,
         ),
         (
          -7.1688271,
          4.5670471,
          4.2586207,
         ),
         (
          -7.5395918,
          3.9248631,
          4.2586207,
         ),
         (
          -7.8529758,
          3.252809,
          4.2586207,
         ),
         (
          -8.1065941,
          2.5559993,
          4.2586207,
         ),
         (
          -8.2985163,
          1.8397368,
          4.2586207,
         ),
         (
          -8.4272814,
          1.1094725,
          4.2586207,
         ),
         (
          -8.49191,
          0.37076479,
          4.2586207,
         ),
         (
          -8.49191,
          -0.37076479,
          4.2586207,
         ),
         (
          -8.4272814,
          -1.1094725,
          4.2586207,
         ),
         (
          -8.2985163,
          -1.8397368,
          4.2586207,
         ),
         (
          -8.1065941,
          -2.5559993,
          4.2586207,
         ),
         (
          -7.8529758,
          -3.252809,
          4.2586207,
         ),
         (
          -7.5395918,
          -3.9248631,
          4.2586207,
         ),
         (
          -7.1688271,
          -4.5670471,
          4.2586207,
         ),
         (
          -6.7435031,
          -5.1744723,
          4.2586207,
         ),
         (
          -6.2668571,
          -5.742517,
          4.2586207,
         ),
         (
          -5.742517,
          -6.2668571,
          4.2586207,
         ),
         (
          -5.1744723,
          -6.7435031,
          4.2586207,
         ),
         (
          -4.5670471,
          -7.1688271,
          4.2586207,
         ),
         (
          -3.9248631,
          -7.5395918,
          4.2586207,
         ),
         (
          -3.252809,
          -7.8529758,
          4.2586207,
         ),
         (
          -2.5559993,
          -8.1065941,
          4.2586207,
         ),
         (
          -1.8397368,
          -8.2985163,
          4.2586207,
         ),
         (
          -1.1094725,
          -8.4272814,
          4.2586207,
         ),
         (
          -0.37076479,
          -8.49191,
          4.2586207,
         ),
         (
          0.37076479,
          -8.49191,
          4.2586207,
         ),
         (
          1.1094725,
          -8.4272814,
          4.2586207,
         ),
         (
          1.8397368,
          -8.2985163,
          4.2586207,
         ),
         (
          2.5559993,
          -8.1065941,
          4.2586207,
         ),
         (
          3.252809,
          -7.8529758,
          4.2586207,
         ),
         (
          3.9248631,
          -7.5395918,
          4.2586207,
         ),
         (
          4.5670471,
          -7.1688271,
          4.2586207,
         ),
         (
          5.1744723,
          -6.7435031,
          4.2586207,
         ),
         (
          5.742517,
          -6.2668571,
          4.2586207,
         ),
         (
          6.2668571,
          -5.742517,
          4.2586207,
         ),
         (
          6.7435031,
          -5.1744723,
          4.2586207,
         ),
         (
          7.1688271,
          -4.5670471,
          4.2586207,
         ),
         (
          7.5395918,
          -3.9248631,
          4.2586207,
         ),
         (
          7.8529758,
          -3.252809,
          4.2586207,
         ),
         (
          8.1065941,
          -2.5559993,
          4.2586207,
         ),
         (
          8.2985163,
          -1.8397368,
          4.2586207,
         ),
         (
          8.4272814,
          -1.1094725,
          4.2586207,
         ),
         (
          8.49191,
          -0.37076479,
          4.2586207,
         ),
         (
          8.5,
          0.0,
          4.9137931,
         ),
         (
          8.4676552,
          0.74082381,
          4.9137931,
         ),
         (
          8.3708658,
          1.4760095,
          4.9137931,
         ),
         (
          8.2103691,
          2.1999619,
          4.9137931,
         ),
         (
          7.9873872,
          2.9071712,
          4.9137931,
         ),
         (
          7.7036166,
          3.5922554,
          4.9137931,
         ),
         (
          7.3612156,
          4.25,
          4.9137931,
         ),
         (
          6.9627924,
          4.8753996,
          4.9137931,
         ),
         (
          6.5113778,
          5.463695,
          4.9137931,
         ),
         (
          6.0104074,
          6.0104074,
          4.9137931,
         ),
         (
          5.463695,
          6.5113778,
          4.9137931,
         ),
         (
          4.8753996,
          6.9627924,
          4.9137931,
         ),
         (
          4.25,
          7.3612156,
          4.9137931,
         ),
         (
          3.5922554,
          7.7036166,
          4.9137931,
         ),
         (
          2.9071712,
          7.9873872,
          4.9137931,
         ),
         (
          2.1999619,
          8.2103691,
          4.9137931,
         ),
         (
          1.4760095,
          8.3708658,
          4.9137931,
         ),
         (
          0.74082381,
          8.4676552,
          4.9137931,
         ),
         (
          5.2047491e-16,
          8.5,
          4.9137931,
         ),
         (
          -0.74082381,
          8.4676552,
          4.9137931,
         ),
         (
          -1.4760095,
          8.3708658,
          4.9137931,
         ),
         (
          -2.1999619,
          8.2103691,
          4.9137931,
         ),
         (
          -2.9071712,
          7.9873872,
          4.9137931,
         ),
         (
          -3.5922554,
          7.7036166,
          4.9137931,
         ),
         (
          -4.25,
          7.3612156,
          4.9137931,
         ),
         (
          -4.8753996,
          6.9627924,
          4.9137931,
         ),
         (
          -5.463695,
          6.5113778,
          4.9137931,
         ),
         (
          -6.0104074,
          6.0104074,
          4.9137931,
         ),
         (
          -6.5113778,
          5.463695,
          4.9137931,
         ),
         (
          -6.9627924,
          4.8753996,
          4.9137931,
         ),
         (
          -7.3612156,
          4.25,
          4.9137931,
         ),
         (
          -7.7036166,
          3.5922554,
          4.9137931,
         ),
         (
          -7.9873872,
          2.9071712,
          4.9137931,
         ),
         (
          -8.2103691,
          2.1999619,
          4.9137931,
         ),
         (
          -8.3708658,
          1.4760095,
          4.9137931,
         ),
         (
          -8.4676552,
          0.74082381,
          4.9137931,
         ),
         (
          -8.5,
          1.0409498e-15,
          4.9137931,
         ),
         (
          -8.4676552,
          -0.74082381,
          4.9137931,
         ),
         (
          -8.3708658,
          -1.4760095,
          4.9137931,
         ),
         (
          -8.2103691,
          -2.1999619,
          4.9137931,
         ),
         (
          -7.9873872,
          -2.9071712,
          4.9137931,
         ),
         (
          -7.7036166,
          -3.5922554,
          4.9137931,
         ),
         (
          -7.3612156,
          -4.25,
          4.9137931,
         ),
         (
          -6.9627924,
          -4.8753996,
          4.9137931,
         ),
         (
          -6.5113778,
          -5.463695,
          4.9137931,
         ),
         (
          -6.0104074,
          -6.0104074,
          4.9137931,
         ),
         (
          -5.463695,
          -6.5113778,
          4.9137931,
         ),
         (
          -4.8753996,
          -6.9627924,
          4.9137931,
         ),
         (
          -4.25,
          -7.3612156,
          4.9137931,
         ),
         (
          -3.5922554,
          -7.7036166,
          4.9137931,
         ),
         (
          -2.9071712,
          -7.9873872,
          4.9137931,
         ),
         (
          -2.1999619,
          -8.2103691,
          4.9137931,
         ),
         (
          -1.4760095,
          -8.3708658,
          4.9137931,
         ),
         (
          -0.74082381,
          -8.4676552,
          4.9137931,
         ),
         (
          -1.5614247e-15,
          -8.5,
          4.9137931,
         ),
         (
          0.74082381,
          -8.4676552,
          4.9137931,
         ),
         (
          1.4760095,
          -8.3708658,
          4.9137931,
         ),
         (
          2.1999619,
          -8.2103691,
          4.9137931,
         ),
         (
          2.9071712,
          -7.9873872,
          4.9137931,
         ),
         (
          3.5922554,
          -7.7036166,
          4.9137931,
         ),
         (
          4.25,
          -7.3612156,
          4.9137931,
         ),
         (
          4.8753996,
          -6.9627924,
          4.9137931,
         ),
         (
          5.463695,
          -6.5113778,
          4.9137931,
         ),
         (
          6.0104074,
          -6.0104074,
          4.9137931,
         ),
         (
          6.5113778,
          -5.463695,
          4.9137931,
         ),
         (
          6.9627924,
          -4.8753996,
          4.9137931,
         ),
         (
          7.3612156,
          -4.25,
          4.9137931,
         ),
         (
          7.7036166,
          -3.5922554,
          4.9137931,
         ),
         (
          7.9873872,
          -2.9071712,
          4.9137931,
         ),
         (
          8.2103691,
          -2.1999619,
          4.9137931,
         ),
         (
          8.3708658,
          -1.4760095,
          4.9137931,
         ),
         (
          8.4676552,
          -0.74082381,
          4.9137931,
         ),
         (
          8.49191,
          0.37076479,
          5.5689659,
         ),
         (
          8.4272814,
          1.1094725,
          5.5689659,
         ),
         (
          8.2985163,
          1.8397368,
          5.5689659,
         ),
         (
          8.1065941,
          2.5559993,
          5.5689659,
         ),
         (
          7.8529758,
          3.252809,
          5.5689659,
         ),
         (
          7.5395918,
          3.9248631,
          5.5689659,
         ),
         (
          7.1688271,
          4.5670471,
          5.5689659,
         ),
         (
          6.7435031,
          5.1744723,
          5.5689659,
         ),
         (
          6.2668571,
          5.742517,
          5.5689659,
         ),
         (
          5.742517,
          6.2668571,
          5.5689659,
         ),
         (
          5.1744723,
          6.7435031,
          5.5689659,
         ),
         (
          4.5670471,
          7.1688271,
          5.5689659,
         ),
         (
          3.9248631,
          7.5395918,
          5.5689659,
         ),
         (
          3.252809,
          7.8529758,
          5.5689659,
         ),
         (
          2.5559993,
          8.1065941,
          5.5689659,
         ),
         (
          1.8397368,
          8.2985163,
          5.5689659,
         ),
         (
          1.1094725,
          8.4272814,
          5.5689659,
         ),
         (
          0.37076479,
          8.49191,
          5.5689659,
         ),
         (
          -0.37076479,
          8.49191,
          5.5689659,
         ),
         (
          -1.1094725,
          8.4272814,
          5.5689659,
         ),
         (
          -1.8397368,
          8.2985163,
          5.5689659,
         ),
         (
          -2.5559993,
          8.1065941,
          5.5689659,
         ),
         (
          -3.252809,
          7.8529758,
          5.5689659,
         ),
         (
          -3.9248631,
          7.5395918,
          5.5689659,
         ),
         (
          -4.5670471,
          7.1688271,
          5.5689659,
         ),
         (
          -5.1744723,
          6.7435031,
          5.5689659,
         ),
         (
          -5.742517,
          6.2668571,
          5.5689659,
         ),
         (
          -6.2668571,
          5.742517,
          5.5689659,
         ),
         (
          -6.7435031,
          5.1744723,
          5.5689659,
         ),
         (
          -7.1688271,
          4.5670471,
          5.5689659,
         ),
         (
          -7.5395918,
          3.9248631,
          5.5689659,
         ),
         (
          -7.8529758,
          3.252809,
          5.5689659,
         ),
         (
          -8.1065941,
          2.5559993,
          5.5689659,
         ),
         (
          -8.2985163,
          1.8397368,
          5.5689659,
         ),
         (
          -8.4272814,
          1.1094725,
          5.5689659,
         ),
         (
          -8.49191,
          0.37076479,
          5.5689659,
         ),
         (
          -8.49191,
          -0.37076479,
          5.5689659,
         ),
         (
          -8.4272814,
          -1.1094725,
          5.5689659,
         ),
         (
          -8.2985163,
          -1.8397368,
          5.5689659,
         ),
         (
          -8.1065941,
          -2.5559993,
          5.5689659,
         ),
         (
          -7.8529758,
          -3.252809,
          5.5689659,
         ),
         (
          -7.5395918,
          -3.9248631,
          5.5689659,
         ),
         (
          -7.1688271,
          -4.5670471,
          5.5689659,
         ),
         (
          -6.7435031,
          -5.1744723,
          5.5689659,
         ),
         (
          -6.2668571,
          -5.742517,
          5.5689659,
         ),
         (
          -5.742517,
          -6.2668571,
          5.5689659,
         ),
         (
          -5.1744723,
          -6.7435031,
          5.5689659,
         ),
         (
          -4.5670471,
          -7.1688271,
          5.5689659,
         ),
         (
          -3.9248631,
          -7.5395918,
          5.5689659,
         ),
         (
          -3.252809,
          -7.8529758,
          5.5689659,
         ),
         (
          -2.5559993,
          -8.1065941,
          5.5689659,
         ),
         (
          -1.8397368,
          -8.2985163,
          5.5689659,
         ),
         (
          -1.1094725,
          -8.4272814,
          5.5689659,
         ),
         (
          -0.37076479,
          -8.49191,
          5.5689659,
         ),
         (
          0.37076479,
          -8.49191,
          5.5689659,
         ),
         (
          1.1094725,
          -8.4272814,
          5.5689659,
         ),
         (
          1.8397368,
          -8.2985163,
          5.5689659,
         ),
         (
          2.5559993,
          -8.1065941,
          5.5689659,
         ),
         (
          3.252809,
          -7.8529758,
          5.5689659,
         ),
         (
          3.9248631,
          -7.5395918,
          5.5689659,
         ),
         (
          4.5670471,
          -7.1688271,
          5.5689659,
         ),
         (
          5.1744723,
          -6.7435031,
          5.5689659,
         ),
         (
          5.742517,
          -6.2668571,
          5.5689659,
         ),
         (
          6.2668571,
          -5.742517,
          5.5689659,
         ),
         (
          6.7435031,
          -5.1744723,
          5.5689659,
         ),
         (
          7.1688271,
          -4.5670471,
          5.5689659,
         ),
         (
          7.5395918,
          -3.9248631,
          5.5689659,
         ),
         (
          7.8529758,
          -3.252809,
          5.5689659,
         ),
         (
          8.1065941,
          -2.5559993,
          5.5689659,
         ),
         (
          8.2985163,
          -1.8397368,
          5.5689659,
         ),
         (
          8.4272814,
          -1.1094725,
          5.5689659,
         ),
         (
          8.49191,
          -0.37076479,
          5.5689659,
         ),
         (
          8.5,
          0.0,
          6.2241378,
         ),
         (
          8.4676552,
          0.74082381,
          6.2241378,
         ),
         (
          8.3708658,
          1.4760095,
          6.2241378,
         ),
         (
          8.2103691,
          2.1999619,
          6.2241378,
         ),
         (
          7.9873872,
          2.9071712,
          6.2241378,
         ),
         (
          7.7036166,
          3.5922554,
          6.2241378,
         ),
         (
          7.3612156,
          4.25,
          6.2241378,
         ),
         (
          6.9627924,
          4.8753996,
          6.2241378,
         ),
         (
          6.5113778,
          5.463695,
          6.2241378,
         ),
         (
          6.0104074,
          6.0104074,
          6.2241378,
         ),
         (
          5.463695,
          6.5113778,
          6.2241378,
         ),
         (
          4.8753996,
          6.9627924,
          6.2241378,
         ),
         (
          4.25,
          7.3612156,
          6.2241378,
         ),
         (
          3.5922554,
          7.7036166,
          6.2241378,
         ),
         (
          2.9071712,
          7.9873872,
          6.2241378,
         ),
         (
          2.1999619,
          8.2103691,
          6.2241378,
         ),
         (
          1.4760095,
          8.3708658,
          6.2241378,
         ),
         (
          0.74082381,
          8.4676552,
          6.2241378,
         ),
         (
          5.2047491e-16,
          8.5,
          6.2241378,
         ),
         (
          -0.74082381,
          8.4676552,
          6.2241378,
         ),
         (
          -1.4760095,
          8.3708658,
          6.2241378,
         ),
         (
          -2.1999619,
          8.2103691,
          6.2241378,
         ),
         (
          -2.9071712,
          7.9873872,
          6.2241378,
         ),
         (
          -3.5922554,
          7.7036166,
          6.2241378,
         ),
         (
          -4.25,
          7.3612156,
          6.2241378,
         ),
         (
          -4.8753996,
          6.9627924,
          6.2241378,
         ),
         (
          -5.463695,
          6.5113778,
          6.2241378,
         ),
         (
          -6.0104074,
          6.0104074,
          6.2241378,
         ),
         (
          -6.5113778,
          5.463695,
          6.2241378,
         ),
         (
          -6.9627924,
          4.8753996,
          6.2241378,
         ),
         (
          -7.3612156,
          4.25,
          6.2241378,
         ),
         (
          -7.7036166,
          3.5922554,
          6.2241378,
         ),
         (
          -7.9873872,
          2.9071712,
          6.2241378,
         ),
         (
          -8.2103691,
          2.1999619,
          6.2241378,
         ),
         (
          -8.3708658,
          1.4760095,
          6.2241378,
         ),
         (
          -8.4676552,
          0.74082381,
          6.2241378,
         ),
         (
          -8.5,
          1.0409498e-15,
          6.2241378,
         ),
         (
          -8.4676552,
          -0.74082381,
          6.2241378,
         ),
         (
          -8.3708658,
          -1.4760095,
          6.2241378,
         ),
         (
          -8.2103691,
          -2.1999619,
          6.2241378,
         ),
         (
          -7.9873872,
          -2.9071712,
          6.2241378,
         ),
         (
          -7.7036166,
          -3.5922554,
          6.2241378,
         ),
         (
          -7.3612156,
          -4.25,
          6.2241378,
         ),
         (
          -6.9627924,
          -4.8753996,
          6.2241378,
         ),
         (
          -6.5113778,
          -5.463695,
          6.2241378,
         ),
         (
          -6.0104074,
          -6.0104074,
          6.2241378,
         ),
         (
          -5.463695,
          -6.5113778,
          6.2241378,
         ),
         (
          -4.8753996,
          -6.9627924,
          6.2241378,
         ),
         (
          -4.25,
          -7.3612156,
          6.2241378,
         ),
         (
          -3.5922554,
          -7.7036166,
          6.2241378,
         ),
         (
          -2.9071712,
          -7.9873872,
          6.2241378,
         ),
         (
          -2.1999619,
          -8.2103691,
          6.2241378,
         ),
         (
          -1.4760095,
          -8.3708658,
          6.2241378,
         ),
         (
          -0.74082381,
          -8.4676552,
          6.2241378,
         ),
         (
          -1.5614247e-15,
          -8.5,
          6.2241378,
         ),
         (
          0.74082381,
          -8.4676552,
          6.2241378,
         ),
         (
          1.4760095,
          -8.3708658,
          6.2241378,
         ),
         (
          2.1999619,
          -8.2103691,
          6.2241378,
         ),
         (
          2.9071712,
          -7.9873872,
          6.2241378,
         ),
         (
          3.5922554,
          -7.7036166,
          6.2241378,
         ),
         (
          4.25,
          -7.3612156,
          6.2241378,
         ),
         (
          4.8753996,
          -6.9627924,
          6.2241378,
         ),
         (
          5.463695,
          -6.5113778,
          6.2241378,
         ),
         (
          6.0104074,
          -6.0104074,
          6.2241378,
         ),
         (
          6.5113778,
          -5.463695,
          6.2241378,
         ),
         (
          6.9627924,
          -4.8753996,
          6.2241378,
         ),
         (
          7.3612156,
          -4.25,
          6.2241378,
         ),
         (
          7.7036166,
          -3.5922554,
          6.2241378,
         ),
         (
          7.9873872,
          -2.9071712,
          6.2241378,
         ),
         (
          8.2103691,
          -2.1999619,
          6.2241378,
         ),
         (
          8.3708658,
          -1.4760095,
          6.2241378,
         ),
         (
          8.4676552,
          -0.74082381,
          6.2241378,
         ),
         (
          8.49191,
          0.37076479,
          6.8793101,
         ),
         (
          8.4272814,
          1.1094725,
          6.8793101,
         ),
         (
          8.2985163,
          1.8397368,
          6.8793101,
         ),
         (
          8.1065941,
          2.5559993,
          6.8793101,
         ),
         (
          7.8529758,
          3.252809,
          6.8793101,
         ),
         (
          7.5395918,
          3.9248631,
          6.8793101,
         ),
         (
          7.1688271,
          4.5670471,
          6.8793101,
         ),
         (
          6.7435031,
          5.1744723,
          6.8793101,
         ),
         (
          6.2668571,
          5.742517,
          6.8793101,
         ),
         (
          5.742517,
          6.2668571,
          6.8793101,
         ),
         (
          5.1744723,
          6.7435031,
          6.8793101,
         ),
         (
          4.5670471,
          7.1688271,
          6.8793101,
         ),
         (
          3.9248631,
          7.5395918,
          6.8793101,
         ),
         (
          3.252809,
          7.8529758,
          6.8793101,
         ),
         (
          2.5559993,
          8.1065941,
          6.8793101,
         ),
         (
          1.8397368,
          8.2985163,
          6.8793101,
         ),
         (
          1.1094725,
          8.4272814,
          6.8793101,
         ),
         (
          0.37076479,
          8.49191,
          6.8793101,
         ),
         (
          -0.37076479,
          8.49191,
          6.8793101,
         ),
         (
          -1.1094725,
          8.4272814,
          6.8793101,
         ),
         (
          -1.8397368,
          8.2985163,
          6.8793101,
         ),
         (
          -2.5559993,
          8.1065941,
          6.8793101,
         ),
         (
          -3.252809,
          7.8529758,
          6.8793101,
         ),
         (
          -3.9248631,
          7.5395918,
          6.8793101,
         ),
         (
          -4.5670471,
          7.1688271,
          6.8793101,
         ),
         (
          -5.1744723,
          6.7435031,
          6.8793101,
         ),
         (
          -5.742517,
          6.2668571,
          6.8793101,
         ),
         (
          -6.2668571,
          5.742517,
          6.8793101,
         ),
         (
          -6.7435031,
          5.1744723,
          6.8793101,
         ),
         (
          -7.1688271,
          4.5670471,
          6.8793101,
         ),
         (
          -7.5395918,
          3.9248631,
          6.8793101,
         ),
         (
          -7.8529758,
          3.252809,
          6.8793101,
         ),
         (
          -8.1065941,
          2.5559993,
          6.8793101,
         ),
         (
          -8.2985163,
          1.8397368,
          6.8793101,
         ),
         (
          -8.4272814,
          1.1094725,
          6.8793101,
         ),
         (
          -8.49191,
          0.37076479,
          6.8793101,
         ),
         (
          -8.49191,
          -0.37076479,
          6.8793101,
         ),
         (
          -8.4272814,
          -1.1094725,
          6.8793101,
         ),
         (
          -8.2985163,
          -1.8397368,
          6.8793101,
         ),
         (
          -8.1065941,
          -2.5559993,
          6.8793101,
         ),
         (
          -7.8529758,
          -3.252809,
          6.8793101,
         ),
         (
          -7.5395918,
          -3.9248631,
          6.8793101,
         ),
         (
          -7.1688271,
          -4.5670471,
          6.8793101,
         ),
         (
          -6.7435031,
          -5.1744723,
          6.8793101,
         ),
         (
          -6.2668571,
          -5.742517,
          6.8793101,
         ),
         (
          -5.742517,
          -6.2668571,
          6.8793101,
         ),
         (
          -5.1744723,
          -6.7435031,
          6.8793101,
         ),
         (
          -4.5670471,
          -7.1688271,
          6.8793101,
         ),
         (
          -3.9248631,
          -7.5395918,
          6.8793101,
         ),
         (
          -3.252809,
          -7.8529758,
          6.8793101,
         ),
         (
          -2.5559993,
          -8.1065941,
          6.8793101,
         ),
         (
          -1.8397368,
          -8.2985163,
          6.8793101,
         ),
         (
          -1.1094725,
          -8.4272814,
          6.8793101,
         ),
         (
          -0.37076479,
          -8.49191,
          6.8793101,
         ),
         (
          0.37076479,
          -8.49191,
          6.8793101,
         ),
         (
          1.1094725,
          -8.4272814,
          6.8793101,
         ),
         (
          1.8397368,
          -8.2985163,
          6.8793101,
         ),
         (
          2.5559993,
          -8.1065941,
          6.8793101,
         ),
         (
          3.252809,
          -7.8529758,
          6.8793101,
         ),
         (
          3.9248631,
          -7.5395918,
          6.8793101,
         ),
         (
          4.5670471,
          -7.1688271,
          6.8793101,
         ),
         (
          5.1744723,
          -6.7435031,
          6.8793101,
         ),
         (
          5.742517,
          -6.2668571,
          6.8793101,
         ),
         (
          6.2668571,
          -5.742517,
          6.8793101,
         ),
         (
          6.7435031,
          -5.1744723,
          6.8793101,
         ),
         (
          7.1688271,
          -4.5670471,
          6.8793101,
         ),
         (
          7.5395918,
          -3.9248631,
          6.8793101,
         ),
         (
          7.8529758,
          -3.252809,
          6.8793101,
         ),
         (
          8.1065941,
          -2.5559993,
          6.8793101,
         ),
         (
          8.2985163,
          -1.8397368,
          6.8793101,
         ),
         (
          8.4272814,
          -1.1094725,
          6.8793101,
         ),
         (
          8.49191,
          -0.37076479,
          6.8793101,
         ),
         (
          8.5,
          0.0,
          7.534483,
         ),
         (
          8.4676552,
          0.74082381,
          7.534483,
         ),
         (
          8.3708658,
          1.4760095,
          7.534483,
         ),
         (
          8.2103691,
          2.1999619,
          7.534483,
         ),
         (
          7.9873872,
          2.9071712,
          7.534483,
         ),
         (
          7.7036166,
          3.5922554,
          7.534483,
         ),
         (
          7.3612156,
          4.25,
          7.534483,
         ),
         (
          6.9627924,
          4.8753996,
          7.534483,
         ),
         (
          6.5113778,
          5.463695,
          7.534483,
         ),
         (
          6.0104074,
          6.0104074,
          7.534483,
         ),
         (
          5.463695,
          6.5113778,
          7.534483,
         ),
         (
          4.8753996,
          6.9627924,
          7.534483,
         ),
         (
          4.25,
          7.3612156,
          7.534483,
         ),
         (
          3.5922554,
          7.7036166,
          7.534483,
         ),
         (
          2.9071712,
          7.9873872,
          7.534483,
         ),
         (
          2.1999619,
          8.2103691,
          7.534483,
         ),
         (
          1.4760095,
          8.3708658,
          7.534483,
         ),
         (
          0.74082381,
          8.4676552,
          7.534483,
         ),
         (
          5.2047491e-16,
          8.5,
          7.534483,
         ),
         (
          -0.74082381,
          8.4676552,
          7.534483,
         ),
         (
          -1.4760095,
          8.3708658,
          7.534483,
         ),
         (
          -2.1999619,
          8.2103691,
          7.534483,
         ),
         (
          -2.9071712,
          7.9873872,
          7.534483,
         ),
         (
          -3.5922554,
          7.7036166,
          7.534483,
         ),
         (
          -4.25,
          7.3612156,
          7.534483,
         ),
         (
          -4.8753996,
          6.9627924,
          7.534483,
         ),
         (
          -5.463695,
          6.5113778,
          7.534483,
         ),
         (
          -6.0104074,
          6.0104074,
          7.534483,
         ),
         (
          -6.5113778,
          5.463695,
          7.534483,
         ),
         (
          -6.9627924,
          4.8753996,
          7.534483,
         ),
         (
          -7.3612156,
          4.25,
          7.534483,
         ),
         (
          -7.7036166,
          3.5922554,
          7.534483,
         ),
         (
          -7.9873872,
          2.9071712,
          7.534483,
         ),
         (
          -8.2103691,
          2.1999619,
          7.534483,
         ),
         (
          -8.3708658,
          1.4760095,
          7.534483,
         ),
         (
          -8.4676552,
          0.74082381,
          7.534483,
         ),
         (
          -8.5,
          1.0409498e-15,
          7.534483,
         ),
         (
          -8.4676552,
          -0.74082381,
          7.534483,
         ),
         (
          -8.3708658,
          -1.4760095,
          7.534483,
         ),
         (
          -8.2103691,
          -2.1999619,
          7.534483,
         ),
         (
          -7.9873872,
          -2.9071712,
          7.534483,
         ),
         (
          -7.7036166,
          -3.5922554,
          7.534483,
         ),
         (
          -7.3612156,
          -4.25,
          7.534483,
         ),
         (
          -6.9627924,
          -4.8753996,
          7.534483,
         ),
         (
          -6.5113778,
          -5.463695,
          7.534483,
         ),
         (
          -6.0104074,
          -6.0104074,
          7.534483,
         ),
         (
          -5.463695,
          -6.5113778,
          7.534483,
         ),
         (
          -4.8753996,
          -6.9627924,
          7.534483,
         ),
         (
          -4.25,
          -7.3612156,
          7.534483,
         ),
         (
          -3.5922554,
          -7.7036166,
          7.534483,
         ),
         (
          -2.9071712,
          -7.9873872,
          7.534483,
         ),
         (
          -2.1999619,
          -8.2103691,
          7.534483,
         ),
         (
          -1.4760095,
          -8.3708658,
          7.534483,
         ),
         (
          -0.74082381,
          -8.4676552,
          7.534483,
         ),
         (
          -1.5614247e-15,
          -8.5,
          7.534483,
         ),
         (
          0.74082381,
          -8.4676552,
          7.534483,
         ),
         (
          1.4760095,
          -8.3708658,
          7.534483,
         ),
         (
          2.1999619,
          -8.2103691,
          7.534483,
         ),
         (
          2.9071712,
          -7.9873872,
          7.534483,
         ),
         (
          3.5922554,
          -7.7036166,
          7.534483,
         ),
         (
          4.25,
          -7.3612156,
          7.534483,
         ),
         (
          4.8753996,
          -6.9627924,
          7.534483,
         ),
         (
          5.463695,
          -6.5113778,
          7.534483,
         ),
         (
          6.0104074,
          -6.0104074,
          7.534483,
         ),
         (
          6.5113778,
          -5.463695,
          7.534483,
         ),
         (
          6.9627924,
          -4.8753996,
          7.534483,
         ),
         (
          7.3612156,
          -4.25,
          7.534483,
         ),
         (
          7.7036166,
          -3.5922554,
          7.534483,
         ),
         (
          7.9873872,
          -2.9071712,
          7.534483,
         ),
         (
          8.2103691,
          -2.1999619,
          7.534483,
         ),
         (
          8.3708658,
          -1.4760095,
          7.534483,
         ),
         (
          8.4676552,
          -0.74082381,
          7.534483,
         ),
         (
          8.49191,
          0.37076479,
          8.1896553,
         ),
         (
          8.4272814,
          1.1094725,
          8.1896553,
         ),
         (
          8.2985163,
          1.8397368,
          8.1896553,
         ),
         (
          8.1065941,
          2.5559993,
          8.1896553,
         ),
         (
          7.8529758,
          3.252809,
          8.1896553,
         ),
         (
          7.5395918,
          3.9248631,
          8.1896553,
         ),
         (
          7.1688271,
          4.5670471,
          8.1896553,
         ),
         (
          6.7435031,
          5.1744723,
          8.1896553,
         ),
         (
          6.2668571,
          5.742517,
          8.1896553,
         ),
         (
          5.742517,
          6.2668571,
          8.1896553,
         ),
         (
          5.1744723,
          6.7435031,
          8.1896553,
         ),
         (
          4.5670471,
          7.1688271,
          8.1896553,
         ),
         (
          3.9248631,
          7.5395918,
          8.1896553,
         ),
         (
          3.252809,
          7.8529758,
          8.1896553,
         ),
         (
          2.5559993,
          8.1065941,
          8.1896553,
         ),
         (
          1.8397368,
          8.2985163,
          8.1896553,
         ),
         (
          1.1094725,
          8.4272814,
          8.1896553,
         ),
         (
          0.37076479,
          8.49191,
          8.1896553,
         ),
         (
          -0.37076479,
          8.49191,
          8.1896553,
         ),
         (
          -1.1094725,
          8.4272814,
          8.1896553,
         ),
         (
          -1.8397368,
          8.2985163,
          8.1896553,
         ),
         (
          -2.5559993,
          8.1065941,
          8.1896553,
         ),
         (
          -3.252809,
          7.8529758,
          8.1896553,
         ),
         (
          -3.9248631,
          7.5395918,
          8.1896553,
         ),
         (
          -4.5670471,
          7.1688271,
          8.1896553,
         ),
         (
          -5.1744723,
          6.7435031,
          8.1896553,
         ),
         (
          -5.742517,
          6.2668571,
          8.1896553,
         ),
         (
          -6.2668571,
          5.742517,
          8.1896553,
         ),
         (
          -6.7435031,
          5.1744723,
          8.1896553,
         ),
         (
          -7.1688271,
          4.5670471,
          8.1896553,
         ),
         (
          -7.5395918,
          3.9248631,
          8.1896553,
         ),
         (
          -7.8529758,
          3.252809,
          8.1896553,
         ),
         (
          -8.1065941,
          2.5559993,
          8.1896553,
         ),
         (
          -8.2985163,
          1.8397368,
          8.1896553,
         ),
         (
          -8.4272814,
          1.1094725,
          8.1896553,
         ),
         (
          -8.49191,
          0.37076479,
          8.1896553,
         ),
         (
          -8.49191,
          -0.37076479,
          8.1896553,
         ),
         (
          -8.4272814,
          -1.1094725,
          8.1896553,
         ),
         (
          -8.2985163,
          -1.8397368,
          8.1896553,
         ),
         (
          -8.1065941,
          -2.5559993,
          8.1896553,
         ),
         (
          -7.8529758,
          -3.252809,
          8.1896553,
         ),
         (
          -7.5395918,
          -3.9248631,
          8.1896553,
         ),
         (
          -7.1688271,
          -4.5670471,
          8.1896553,
         ),
         (
          -6.7435031,
          -5.1744723,
          8.1896553,
         ),
         (
          -6.2668571,
          -5.742517,
          8.1896553,
         ),
         (
          -5.742517,
          -6.2668571,
          8.1896553,
         ),
         (
          -5.1744723,
          -6.7435031,
          8.1896553,
         ),
         (
          -4.5670471,
          -7.1688271,
          8.1896553,
         ),
         (
          -3.9248631,
          -7.5395918,
          8.1896553,
         ),
         (
          -3.252809,
          -7.8529758,
          8.1896553,
         ),
         (
          -2.5559993,
          -8.1065941,
          8.1896553,
         ),
         (
          -1.8397368,
          -8.2985163,
          8.1896553,
         ),
         (
          -1.1094725,
          -8.4272814,
          8.1896553,
         ),
         (
          -0.37076479,
          -8.49191,
          8.1896553,
         ),
         (
          0.37076479,
          -8.49191,
          8.1896553,
         ),
         (
          1.1094725,
          -8.4272814,
          8.1896553,
         ),
         (
          1.8397368,
          -8.2985163,
          8.1896553,
         ),
         (
          2.5559993,
          -8.1065941,
          8.1896553,
         ),
         (
          3.252809,
          -7.8529758,
          8.1896553,
         ),
         (
          3.9248631,
          -7.5395918,
          8.1896553,
         ),
         (
          4.5670471,
          -7.1688271,
          8.1896553,
         ),
         (
          5.1744723,
          -6.7435031,
          8.1896553,
         ),
         (
          5.742517,
          -6.2668571,
          8.1896553,
         ),
         (
          6.2668571,
          -5.742517,
          8.1896553,
         ),
         (
          6.7435031,
          -5.1744723,
          8.1896553,
         ),
         (
          7.1688271,
          -4.5670471,
          8.1896553,
         ),
         (
          7.5395918,
          -3.9248631,
          8.1896553,
         ),
         (
          7.8529758,
          -3.252809,
          8.1896553,
         ),
         (
          8.1065941,
          -2.5559993,
          8.1896553,
         ),
         (
          8.2985163,
          -1.8397368,
          8.1896553,
         ),
         (
          8.4272814,
          -1.1094725,
          8.1896553,
         ),
         (
          8.49191,
          -0.37076479,
          8.1896553,
         ),
         (
          8.5,
          0.0,
          8.8448277,
         ),
         (
          8.4676552,
          0.74082381,
          8.8448277,
         ),
         (
          8.3708658,
          1.4760095,
          8.8448277,
         ),
         (
          8.2103691,
          2.1999619,
          8.8448277,
         ),
         (
          7.9873872,
          2.9071712,
          8.8448277,
         ),
         (
          7.7036166,
          3.5922554,
          8.8448277,
         ),
         (
          7.3612156,
          4.25,
          8.8448277,
         ),
         (
          6.9627924,
          4.8753996,
          8.8448277,
         ),
         (
          6.5113778,
          5.463695,
          8.8448277,
         ),
         (
          6.0104074,
          6.0104074,
          8.8448277,
         ),
         (
          5.463695,
          6.5113778,
          8.8448277,
         ),
         (
          4.8753996,
          6.9627924,
          8.8448277,
         ),
         (
          4.25,
          7.3612156,
          8.8448277,
         ),
         (
          3.5922554,
          7.7036166,
          8.8448277,
         ),
         (
          2.9071712,
          7.9873872,
          8.8448277,
         ),
         (
          2.1999619,
          8.2103691,
          8.8448277,
         ),
         (
          1.4760095,
          8.3708658,
          8.8448277,
         ),
         (
          0.74082381,
          8.4676552,
          8.8448277,
         ),
         (
          5.2047491e-16,
          8.5,
          8.8448277,
         ),
         (
          -0.74082381,
          8.4676552,
          8.8448277,
         ),
         (
          -1.4760095,
          8.3708658,
          8.8448277,
         ),
         (
          -2.1999619,
          8.2103691,
          8.8448277,
         ),
         (
          -2.9071712,
          7.9873872,
          8.8448277,
         ),
         (
          -3.5922554,
          7.7036166,
          8.8448277,
         ),
         (
          -4.25,
          7.3612156,
          8.8448277,
         ),
         (
          -4.8753996,
          6.9627924,
          8.8448277,
         ),
         (
          -5.463695,
          6.5113778,
          8.8448277,
         ),
         (
          -6.0104074,
          6.0104074,
          8.8448277,
         ),
         (
          -6.5113778,
          5.463695,
          8.8448277,
         ),
         (
          -6.9627924,
          4.8753996,
          8.8448277,
         ),
         (
          -7.3612156,
          4.25,
          8.8448277,
         ),
         (
          -7.7036166,
          3.5922554,
          8.8448277,
         ),
         (
          -7.9873872,
          2.9071712,
          8.8448277,
         ),
         (
          -8.2103691,
          2.1999619,
          8.8448277,
         ),
         (
          -8.3708658,
          1.4760095,
          8.8448277,
         ),
         (
          -8.4676552,
          0.74082381,
          8.8448277,
         ),
         (
          -8.5,
          1.0409498e-15,
          8.8448277,
         ),
         (
          -8.4676552,
          -0.74082381,
          8.8448277,
         ),
         (
          -8.3708658,
          -1.4760095,
          8.8448277,
         ),
         (
          -8.2103691,
          -2.1999619,
          8.8448277,
         ),
         (
          -7.9873872,
          -2.9071712,
          8.8448277,
         ),
         (
          -7.7036166,
          -3.5922554,
          8.8448277,
         ),
         (
          -7.3612156,
          -4.25,
          8.8448277,
         ),
         (
          -6.9627924,
          -4.8753996,
          8.8448277,
         ),
         (
          -6.5113778,
          -5.463695,
          8.8448277,
         ),
         (
          -6.0104074,
          -6.0104074,
          8.8448277,
         ),
         (
          -5.463695,
          -6.5113778,
          8.8448277,
         ),
         (
          -4.8753996,
          -6.9627924,
          8.8448277,
         ),
         (
          -4.25,
          -7.3612156,
          8.8448277,
         ),
         (
          -3.5922554,
          -7.7036166,
          8.8448277,
         ),
         (
          -2.9071712,
          -7.9873872,
          8.8448277,
         ),
         (
          -2.1999619,
          -8.2103691,
          8.8448277,
         ),
         (
          -1.4760095,
          -8.3708658,
          8.8448277,
         ),
         (
          -0.74082381,
          -8.4676552,
          8.8448277,
         ),
         (
          -1.5614247e-15,
          -8.5,
          8.8448277,
         ),
         (
          0.74082381,
          -8.4676552,
          8.8448277,
         ),
         (
          1.4760095,
          -8.3708658,
          8.8448277,
         ),
         (
          2.1999619,
          -8.2103691,
          8.8448277,
         ),
         (
          2.9071712,
          -7.9873872,
          8.8448277,
         ),
         (
          3.5922554,
          -7.7036166,
          8.8448277,
         ),
         (
          4.25,
          -7.3612156,
          8.8448277,
         ),
         (
          4.8753996,
          -6.9627924,
          8.8448277,
         ),
         (
          5.463695,
          -6.5113778,
          8.8448277,
         ),
         (
          6.0104074,
          -6.0104074,
          8.8448277,
         ),
         (
          6.5113778,
          -5.463695,
          8.8448277,
         ),
         (
          6.9627924,
          -4.8753996,
          8.8448277,
         ),
         (
          7.3612156,
          -4.25,
          8.8448277,
         ),
         (
          7.7036166,
          -3.5922554,
          8.8448277,
         ),
         (
          7.9873872,
          -2.9071712,
          8.8448277,
         ),
         (
          8.2103691,
          -2.1999619,
          8.8448277,
         ),
         (
          8.3708658,
          -1.4760095,
          8.8448277,
         ),
         (
          8.4676552,
          -0.74082381,
          8.8448277,
         ),
         (
          8.49191,
          0.37076479,
          9.5,
         ),
         (
          8.4272814,
          1.1094725,
          9.5,
         ),
         (
          8.2985163,
          1.8397368,
          9.5,
         ),
         (
          8.1065941,
          2.5559993,
          9.5,
         ),
         (
          7.8529758,
          3.252809,
          9.5,
         ),
         (
          7.5395918,
          3.9248631,
          9.5,
         ),
         (
          7.1688271,
          4.5670471,
          9.5,
         ),
         (
          6.7435031,
          5.1744723,
          9.5,
         ),
         (
          6.2668571,
          5.742517,
          9.5,
         ),
         (
          5.742517,
          6.2668571,
          9.5,
         ),
         (
          5.1744723,
          6.7435031,
          9.5,
         ),
         (
          4.5670471,
          7.1688271,
          9.5,
         ),
         (
          3.9248631,
          7.5395918,
          9.5,
         ),
         (
          3.252809,
          7.8529758,
          9.5,
         ),
         (
          2.5559993,
          8.1065941,
          9.5,
         ),
         (
          1.8397368,
          8.2985163,
          9.5,
         ),
         (
          1.1094725,
          8.4272814,
          9.5,
         ),
         (
          0.37076479,
          8.49191,
          9.5,
         ),
         (
          -0.37076479,
          8.49191,
          9.5,
         ),
         (
          -1.1094725,
          8.4272814,
          9.5,
         ),
         (
          -1.8397368,
          8.2985163,
          9.5,
         ),
         (
          -2.5559993,
          8.1065941,
          9.5,
         ),
         (
          -3.252809,
          7.8529758,
          9.5,
         ),
         (
          -3.9248631,
          7.5395918,
          9.5,
         ),
         (
          -4.5670471,
          7.1688271,
          9.5,
         ),
         (
          -5.1744723,
          6.7435031,
          9.5,
         ),
         (
          -5.742517,
          6.2668571,
          9.5,
         ),
         (
          -6.2668571,
          5.742517,
          9.5,
         ),
         (
          -6.7435031,
          5.1744723,
          9.5,
         ),
         (
          -7.1688271,
          4.5670471,
          9.5,
         ),
         (
          -7.5395918,
          3.9248631,
          9.5,
         ),
         (
          -7.8529758,
          3.252809,
          9.5,
         ),
         (
          -8.1065941,
          2.5559993,
          9.5,
         ),
         (
          -8.2985163,
          1.8397368,
          9.5,
         ),
         (
          -8.4272814,
          1.1094725,
          9.5,
         ),
         (
          -8.49191,
          0.37076479,
          9.5,
         ),
         (
          -8.49191,
          -0.37076479,
          9.5,
         ),
         (
          -8.4272814,
          -1.1094725,
          9.5,
         ),
         (
          -8.2985163,
          -1.8397368,
          9.5,
         ),
         (
          -8.1065941,
          -2.5559993,
          9.5,
         ),
         (
          -7.8529758,
          -3.252809,
          9.5,
         ),
         (
          -7.5395918,
          -3.9248631,
          9.5,
         ),
         (
          -7.1688271,
          -4.5670471,
          9.5,
         ),
         (
          -6.7435031,
          -5.1744723,
          9.5,
         ),
         (
          -6.2668571,
          -5.742517,
          9.5,
         ),
         (
          -5.742517,
          -6.2668571,
          9.5,
         ),
         (
          -5.1744723,
          -6.7435031,
          9.5,
         ),
         (
          -4.5670471,
          -7.1688271,
          9.5,
         ),
         (
          -3.9248631,
          -7.5395918,
          9.5,
         ),
         (
          -3.252809,
          -7.8529758,
          9.5,
         ),
         (
          -2.5559993,
          -8.1065941,
          9.5,
         ),
         (
          -1.8397368,
          -8.2985163,
          9.5,
         ),
         (
          -1.1094725,
          -8.4272814,
          9.5,
         ),
         (
          -0.37076479,
          -8.49191,
          9.5,
         ),
         (
          0.37076479,
          -8.49191,
          9.5,
         ),
         (
          1.1094725,
          -8.4272814,
          9.5,
         ),
         (
          1.8397368,
          -8.2985163,
          9.5,
         ),
         (
          2.5559993,
          -8.1065941,
          9.5,
         ),
         (
          3.252809,
          -7.8529758,
          9.5,
         ),
         (
          3.9248631,
          -7.5395918,
          9.5,
         ),
         (
          4.5670471,
          -7.1688271,
          9.5,
         ),
         (
          5.1744723,
          -6.7435031,
          9.5,
         ),
         (
          5.742517,
          -6.2668571,
          9.5,
         ),
         (
          6.2668571,
          -5.742517,
          9.5,
         ),
         (
          6.7435031,
          -5.1744723,
          9.5,
         ),
         (
          7.1688271,
          -4.5670471,
          9.5,
         ),
         (
          7.5395918,
          -3.9248631,
          9.5,
         ),
         (
          7.8529758,
          -3.252809,
          9.5,
         ),
         (
          8.1065941,
          -2.5559993,
          9.5,
         ),
         (
          8.2985163,
          -1.8397368,
          9.5,
         ),
         (
          8.4272814,
          -1.1094725,
          9.5,
         ),
         (
          8.49191,
          -0.37076479,
          9.5,
         ),
         (
          0.0,
          0.0,
          -9.5,
         ),
         (
          0.0,
          0.0,
          9.5,
         ),
        ],
      },
     ],
    'version': 2,
   },
   {
    'class': 'Surface_Model_State',
    'name': 'cylinder',
    'one_transparent_layer': False,
    'pieces_are_selectable': True,
    'surface_model': {
      'active': True,
      'class': 'Model_State',
      'clip_plane_normal': ( 0.0, 0.0, 0.0, ),
      'clip_plane_origin': ( 0.0, 0.0, 0.0, ),
      'clip_thickness': 5.0,
      'display': True,
      'id': 1,
      'name': 'cylinder',
      'osl_identifier': '#1',
      'subid': 0,
      'use_clip_plane': False,
      'use_clip_thickness': False,
      'version': 4,
      'xform': {
        'class': 'Xform_State',
        'rotation_angle': 39.616659834786049,
        'rotation_axis': ( 0.9815272136880836, 0.11402930672779692, 0.1536282721273472, ),
        'translation': ( 193.18045036194994, 119.00700072692639, 1041.3282999654828, ),
        'version': 1,
       },
     },
    'surface_piece_states': [
      {
       'class': 'Surface_Piece_State',
       'color': ( 1.0, 0.27058824896812439, 0.0, 1.0, ),
       'displayStyle': 0,
       'dotSize': 1.0,
       'lineThickness': 1.0,
       'normals': [
         (
          0.83028609,
          0.0,
          -0.5573374,
         ),
         (
          0.82712668,
          0.072364248,
          -0.55733734,
         ),
         (
          0.81767207,
          0.14417781,
          -0.55733764,
         ),
         (
          0.8019945,
          0.21489388,
          -0.55733776,
         ),
         (
          0.78021389,
          0.28397435,
          -0.55733728,
         ),
         (
          0.75249493,
          0.3508943,
          -0.55733693,
         ),
         (
          0.71904886,
          0.41514313,
          -0.5573374,
         ),
         (
          0.6801306,
          0.47623244,
          -0.5573374,
         ),
         (
          0.63603616,
          0.53369772,
          -0.55733722,
         ),
         (
          0.58710086,
          0.58710092,
          -0.55733746,
         ),
         (
          0.53369772,
          0.63603616,
          -0.55733722,
         ),
         (
          0.47623244,
          0.6801306,
          -0.5573374,
         ),
         (
          0.41514313,
          0.7190488,
          -0.5573374,
         ),
         (
          0.35089427,
          0.75249493,
          -0.55733693,
         ),
         (
          0.28397441,
          0.78021383,
          -0.55733734,
         ),
         (
          0.21489386,
          0.8019945,
          -0.55733776,
         ),
         (
          0.14417781,
          0.81767207,
          -0.55733764,
         ),
         (
          0.072364248,
          0.82712668,
          -0.55733734,
         ),
         (
          0.0,
          0.83028609,
          -0.5573374,
         ),
         (
          -0.072364248,
          0.82712668,
          -0.55733734,
         ),
         (
          -0.14417781,
          0.81767207,
          -0.55733764,
         ),
         (
          -0.21489388,
          0.8019945,
          -0.55733776,
         ),
         (
          -0.28397435,
          0.78021389,
          -0.55733728,
         ),
         (
          -0.3508943,
          0.75249493,
          -0.55733693,
         ),
         (
          -0.41514313,
          0.71904886,
          -0.5573374,
         ),
         (
          -0.47623244,
          0.6801306,
          -0.5573374,
         ),
         (
          -0.53369772,
          0.63603616,
          -0.55733722,
         ),
         (
          -0.58710092,
          0.58710086,
          -0.55733746,
         ),
         (
          -0.63603616,
          0.53369772,
          -0.55733722,
         ),
         (
          -0.6801306,
          0.47623244,
          -0.5573374,
         ),
         (
          -0.7190488,
          0.41514313,
          -0.5573374,
         ),
         (
          -0.75249493,
          0.35089427,
          -0.55733693,
         ),
         (
          -0.78021383,
          0.28397441,
          -0.55733734,
         ),
         (
          -0.8019945,
          0.21489386,
          -0.55733776,
         ),
         (
          -0.81767207,
          0.14417781,
          -0.55733764,
         ),
         (
          -0.82712668,
          0.072364248,
          -0.55733734,
         ),
         (
          -0.83028609,
          0.0,
          -0.5573374,
         ),
         (
          -0.82712668,
          -0.072364248,
          -0.55733734,
         ),
         (
          -0.81767207,
          -0.14417781,
          -0.55733764,
         ),
         (
          -0.8019945,
          -0.21489388,
          -0.55733776,
         ),
         (
          -0.78021389,
          -0.28397435,
          -0.55733728,
         ),
         (
          -0.75249493,
          -0.3508943,
          -0.55733693,
         ),
         (
          -0.71904886,
          -0.41514313,
          -0.5573374,
         ),
         (
          -0.6801306,
          -0.47623244,
          -0.5573374,
         ),
         (
          -0.63603616,
          -0.53369772,
          -0.55733722,
         ),
         (
          -0.58710086,
          -0.58710092,
          -0.55733746,
         ),
         (
          -0.53369772,
          -0.63603616,
          -0.55733722,
         ),
         (
          -0.47623244,
          -0.6801306,
          -0.5573374,
         ),
         (
          -0.41514313,
          -0.7190488,
          -0.5573374,
         ),
         (
          -0.35089427,
          -0.75249493,
          -0.55733693,
         ),
         (
          -0.28397441,
          -0.78021383,
          -0.55733734,
         ),
         (
          -0.21489386,
          -0.8019945,
          -0.55733776,
         ),
         (
          -0.14417781,
          -0.81767207,
          -0.55733764,
         ),
         (
          -0.072364248,
          -0.82712668,
          -0.55733734,
         ),
         (
          0.0,
          -0.83028609,
          -0.5573374,
         ),
         (
          0.072364248,
          -0.82712668,
          -0.55733734,
         ),
         (
          0.14417781,
          -0.81767207,
          -0.55733764,
         ),
         (
          0.21489388,
          -0.8019945,
          -0.55733776,
         ),
         (
          0.28397435,
          -0.78021389,
          -0.55733728,
         ),
         (
          0.3508943,
          -0.75249493,
          -0.55733693,
         ),
         (
          0.41514313,
          -0.71904886,
          -0.5573374,
         ),
         (
          0.47623244,
          -0.6801306,
          -0.5573374,
         ),
         (
          0.53369772,
          -0.63603616,
          -0.55733722,
         ),
         (
          0.58710092,
          -0.58710086,
          -0.55733746,
         ),
         (
          0.63603616,
          -0.53369772,
          -0.55733722,
         ),
         (
          0.6801306,
          -0.47623244,
          -0.5573374,
         ),
         (
          0.7190488,
          -0.41514313,
          -0.5573374,
         ),
         (
          0.75249493,
          -0.35089427,
          -0.55733693,
         ),
         (
          0.78021383,
          -0.28397441,
          -0.55733734,
         ),
         (
          0.8019945,
          -0.21489386,
          -0.55733776,
         ),
         (
          0.81767207,
          -0.14417781,
          -0.55733764,
         ),
         (
          0.82712668,
          -0.072364248,
          -0.55733734,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          9.3198493e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.5533083e-10,
         ),
         (
          0.97629595,
          0.21643975,
          -1.0873157e-09,
         ),
         (
          0.95371693,
          0.30070585,
          1.7086391e-09,
         ),
         (
          0.92387956,
          0.38268337,
          1.5533082e-10,
         ),
         (
          0.88701075,
          0.46174878,
          1.5533083e-09,
         ),
         (
          0.84339154,
          0.53729939,
          4.6599247e-10,
         ),
         (
          0.79335344,
          0.60876131,
          2.6406239e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          0.60876131,
          0.7933535,
          2.6406242e-09,
         ),
         (
          0.53729945,
          0.84339154,
          2.9512857e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          0.38268337,
          0.92387956,
          2.7959546e-09,
         ),
         (
          0.30070585,
          0.95371699,
          4.1939323e-09,
         ),
         (
          0.21643974,
          0.97629595,
          4.038601e-09,
         ),
         (
          0.13052627,
          0.99144489,
          1.8639699e-09,
         ),
         (
          0.043619301,
          0.99904829,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          0.99904817,
          9.3198493e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.5533083e-10,
         ),
         (
          -0.21643975,
          0.97629595,
          -1.0873157e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          1.7086391e-09,
         ),
         (
          -0.38268337,
          0.92387956,
          1.5533082e-10,
         ),
         (
          -0.46174878,
          0.88701075,
          1.5533083e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          4.6599247e-10,
         ),
         (
          -0.60876131,
          0.79335344,
          2.6406239e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          2.6406242e-09,
         ),
         (
          -0.84339154,
          0.53729945,
          2.9512857e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.92387956,
          0.38268337,
          2.7959546e-09,
         ),
         (
          -0.95371699,
          0.30070585,
          4.1939323e-09,
         ),
         (
          -0.97629595,
          0.21643974,
          4.038601e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          1.8639699e-09,
         ),
         (
          -0.99904829,
          0.043619301,
          1.8639699e-09,
         ),
         (
          -0.99904817,
          -0.043619301,
          9.3198493e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.5533083e-10,
         ),
         (
          -0.97629595,
          -0.21643975,
          -1.0873157e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          1.7086391e-09,
         ),
         (
          -0.92387956,
          -0.38268337,
          1.5533082e-10,
         ),
         (
          -0.88701075,
          -0.46174878,
          1.5533083e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          4.6599247e-10,
         ),
         (
          -0.79335344,
          -0.60876131,
          2.6406239e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          2.6406242e-09,
         ),
         (
          -0.53729945,
          -0.84339154,
          2.9512857e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.38268337,
          -0.92387956,
          2.7959546e-09,
         ),
         (
          -0.30070585,
          -0.95371699,
          4.1939323e-09,
         ),
         (
          -0.21643974,
          -0.97629595,
          4.038601e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          -0.99904829,
          1.8639699e-09,
         ),
         (
          0.043619301,
          -0.99904817,
          9.3198493e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.5533083e-10,
         ),
         (
          0.21643975,
          -0.97629595,
          -1.0873157e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          1.7086391e-09,
         ),
         (
          0.38268337,
          -0.92387956,
          1.5533082e-10,
         ),
         (
          0.46174878,
          -0.88701075,
          1.5533083e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          4.6599247e-10,
         ),
         (
          0.60876131,
          -0.79335344,
          2.6406239e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          2.6406242e-09,
         ),
         (
          0.84339154,
          -0.53729945,
          2.9512857e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          0.92387956,
          -0.38268337,
          2.7959546e-09,
         ),
         (
          0.95371699,
          -0.30070585,
          4.1939323e-09,
         ),
         (
          0.97629595,
          -0.21643974,
          4.038601e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          1.8639699e-09,
         ),
         (
          0.99904829,
          -0.043619301,
          1.8639699e-09,
         ),
         (
          1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          0.99619478,
          0.087155804,
          -2.3299624e-09,
         ),
         (
          0.98480773,
          0.17364837,
          -3.1066165e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -1.8639699e-09,
         ),
         (
          0.93969274,
          0.34201986,
          -1.3979773e-09,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533081e-09,
         ),
         (
          0.86602545,
          0.50000006,
          -2.4852933e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -1.3979774e-09,
         ),
         (
          0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          0.57357633,
          0.81915212,
          1.0873157e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -2.4852933e-09,
         ),
         (
          0.42261839,
          0.9063077,
          -1.3979773e-09,
         ),
         (
          0.34201986,
          0.93969274,
          1.2426465e-09,
         ),
         (
          0.25881913,
          0.96592581,
          1.8639699e-09,
         ),
         (
          0.17364839,
          0.98480773,
          -4.6599247e-10,
         ),
         (
          0.087155804,
          0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          1.0,
          -1.2426465e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          -2.3299624e-09,
         ),
         (
          -0.17364837,
          0.98480773,
          -3.1066165e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -1.8639699e-09,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.3979773e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533081e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -1.3979774e-09,
         ),
         (
          -0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          1.0873157e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -2.4852933e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          -1.3979773e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          1.2426465e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          1.8639699e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          -4.6599247e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          -1.3979774e-09,
         ),
         (
          -1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          -2.3299624e-09,
         ),
         (
          -0.98480773,
          -0.17364837,
          -3.1066165e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -1.8639699e-09,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.3979773e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533081e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          -2.4852933e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -1.3979774e-09,
         ),
         (
          -0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          1.0873157e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -2.4852933e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          -1.3979773e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          1.2426465e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          1.8639699e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          -4.6599247e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          -1.0,
          -1.2426465e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          -2.3299624e-09,
         ),
         (
          0.17364837,
          -0.98480773,
          -3.1066165e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -1.8639699e-09,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.3979773e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533081e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -1.3979774e-09,
         ),
         (
          0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          1.0873157e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -2.4852933e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          -1.3979773e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          1.2426465e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          1.8639699e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          -4.6599247e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          -1.3979774e-09,
         ),
         (
          0.99904829,
          0.043619301,
          -2.1746316e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -3.1066165e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -4.038601e-09,
         ),
         (
          0.95371693,
          0.30070588,
          -1.3979774e-09,
         ),
         (
          0.92387956,
          0.3826834,
          -2.7959548e-09,
         ),
         (
          0.88701075,
          0.46174878,
          -1.5533083e-09,
         ),
         (
          0.84339154,
          0.53729945,
          -2.6406239e-09,
         ),
         (
          0.79335344,
          0.60876137,
          -4.6599247e-10,
         ),
         (
          0.73727721,
          0.67559034,
          -4.1939323e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -4.1939323e-09,
         ),
         (
          0.60876131,
          0.7933535,
          -4.6599247e-10,
         ),
         (
          0.53729939,
          0.84339154,
          -1.5533082e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -4.0386015e-09,
         ),
         (
          0.38268337,
          0.92387956,
          -1.5533082e-10,
         ),
         (
          0.30070585,
          0.95371693,
          1.2426465e-09,
         ),
         (
          0.21643975,
          0.97629595,
          1.0873157e-09,
         ),
         (
          0.13052627,
          0.99144489,
          -1.2426467e-09,
         ),
         (
          0.043619301,
          0.99904829,
          -1.2426467e-09,
         ),
         (
          -0.043619301,
          0.99904817,
          -2.1746316e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -3.1066165e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -4.038601e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          -1.3979774e-09,
         ),
         (
          -0.3826834,
          0.92387956,
          -2.7959548e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          -1.5533083e-09,
         ),
         (
          -0.53729945,
          0.84339154,
          -2.6406239e-09,
         ),
         (
          -0.60876137,
          0.79335344,
          -4.6599247e-10,
         ),
         (
          -0.67559034,
          0.73727721,
          -4.1939323e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -4.1939323e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          -4.6599247e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          -1.5533082e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -4.0386015e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          -1.5533082e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          1.2426465e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          1.0873157e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          -1.2426467e-09,
         ),
         (
          -0.99904829,
          0.043619301,
          -1.2426467e-09,
         ),
         (
          -0.99904817,
          -0.043619301,
          -2.1746316e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -3.1066165e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -4.038601e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          -1.3979774e-09,
         ),
         (
          -0.92387956,
          -0.3826834,
          -2.7959548e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          -1.5533083e-09,
         ),
         (
          -0.84339154,
          -0.53729945,
          -2.6406239e-09,
         ),
         (
          -0.79335344,
          -0.60876137,
          -4.6599247e-10,
         ),
         (
          -0.73727721,
          -0.67559034,
          -4.1939323e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -4.1939323e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          -4.6599247e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          -1.5533082e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -4.0386015e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          -1.5533082e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          1.2426465e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          1.0873157e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          -1.2426467e-09,
         ),
         (
          -0.043619301,
          -0.99904829,
          -1.2426467e-09,
         ),
         (
          0.043619301,
          -0.99904817,
          -2.1746316e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -3.1066165e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -4.038601e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          -1.3979774e-09,
         ),
         (
          0.3826834,
          -0.92387956,
          -2.7959548e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          -1.5533083e-09,
         ),
         (
          0.53729945,
          -0.84339154,
          -2.6406239e-09,
         ),
         (
          0.60876137,
          -0.79335344,
          -4.6599247e-10,
         ),
         (
          0.67559034,
          -0.73727721,
          -4.1939323e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -4.1939323e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          -4.6599247e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          -1.5533082e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -4.0386015e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          -1.5533082e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          1.2426465e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          1.0873157e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          -1.2426467e-09,
         ),
         (
          0.99904829,
          -0.043619301,
          -1.2426467e-09,
         ),
         (
          1.0,
          0.0,
          3.417278e-09,
         ),
         (
          0.99619478,
          0.087155804,
          2.0193007e-09,
         ),
         (
          0.98480773,
          0.17364839,
          1.3979774e-09,
         ),
         (
          0.96592581,
          0.25881913,
          2.1746314e-09,
         ),
         (
          0.93969274,
          0.34201986,
          3.1066163e-09,
         ),
         (
          0.9063077,
          0.42261836,
          3.1066163e-09,
         ),
         (
          0.86602545,
          0.50000006,
          1.8639699e-09,
         ),
         (
          0.81915218,
          0.57357633,
          2.9512857e-09,
         ),
         (
          0.76604438,
          0.64278764,
          1.5533083e-10,
         ),
         (
          0.70710683,
          0.70710683,
          -2.3299624e-09,
         ),
         (
          0.64278764,
          0.76604444,
          1.5533083e-10,
         ),
         (
          0.57357633,
          0.81915212,
          5.5919092e-09,
         ),
         (
          0.50000006,
          0.86602539,
          2.0193005e-09,
         ),
         (
          0.42261839,
          0.9063077,
          3.2619472e-09,
         ),
         (
          0.34201986,
          0.93969274,
          5.74724e-09,
         ),
         (
          0.25881913,
          0.96592581,
          6.0579017e-09,
         ),
         (
          0.17364839,
          0.98480773,
          3.8832706e-09,
         ),
         (
          0.087155797,
          0.99619466,
          2.9512857e-09,
         ),
         (
          0.0,
          1.0,
          3.417278e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          2.0193007e-09,
         ),
         (
          -0.17364839,
          0.98480773,
          1.3979774e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          2.1746314e-09,
         ),
         (
          -0.34201986,
          0.93969274,
          3.1066163e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          3.1066163e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          1.8639699e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          2.9512857e-09,
         ),
         (
          -0.64278764,
          0.76604438,
          1.5533083e-10,
         ),
         (
          -0.70710683,
          0.70710683,
          -2.3299624e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          1.5533083e-10,
         ),
         (
          -0.81915212,
          0.57357633,
          5.5919092e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          2.0193005e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          3.2619472e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          5.74724e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          6.0579017e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          3.8832706e-09,
         ),
         (
          -0.99619466,
          0.087155797,
          2.9512857e-09,
         ),
         (
          -1.0,
          0.0,
          3.417278e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          2.0193007e-09,
         ),
         (
          -0.98480773,
          -0.17364839,
          1.3979774e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          2.1746314e-09,
         ),
         (
          -0.93969274,
          -0.34201986,
          3.1066163e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          3.1066163e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          1.8639699e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          2.9512857e-09,
         ),
         (
          -0.76604438,
          -0.64278764,
          1.5533083e-10,
         ),
         (
          -0.70710683,
          -0.70710683,
          -2.3299624e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          1.5533083e-10,
         ),
         (
          -0.57357633,
          -0.81915212,
          5.5919092e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          2.0193005e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          3.2619472e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          5.74724e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          6.0579017e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          3.8832706e-09,
         ),
         (
          -0.087155797,
          -0.99619466,
          2.9512857e-09,
         ),
         (
          0.0,
          -1.0,
          3.417278e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          2.0193007e-09,
         ),
         (
          0.17364839,
          -0.98480773,
          1.3979774e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          2.1746314e-09,
         ),
         (
          0.34201986,
          -0.93969274,
          3.1066163e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          3.1066163e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          1.8639699e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          2.9512857e-09,
         ),
         (
          0.64278764,
          -0.76604438,
          1.5533083e-10,
         ),
         (
          0.70710683,
          -0.70710683,
          -2.3299624e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          1.5533083e-10,
         ),
         (
          0.81915212,
          -0.57357633,
          5.5919092e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          2.0193005e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          3.2619472e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          5.74724e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          6.0579017e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          3.8832706e-09,
         ),
         (
          0.99619466,
          -0.087155797,
          2.9512857e-09,
         ),
         (
          0.99904829,
          0.043619297,
          -2.1746316e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -3.2619472e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -4.3492627e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.708639e-09,
         ),
         (
          0.92387956,
          0.38268337,
          -2.7959546e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.3979774e-09,
         ),
         (
          0.84339154,
          0.53729939,
          -2.9512854e-09,
         ),
         (
          0.7933535,
          0.60876131,
          -1.5533083e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -4.038601e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -4.0386015e-09,
         ),
         (
          0.60876131,
          0.79335338,
          -1.5533083e-10,
         ),
         (
          0.53729939,
          0.84339154,
          -3.1066164e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -3.8832706e-09,
         ),
         (
          0.38268337,
          0.92387956,
          -1.5533082e-10,
         ),
         (
          0.30070585,
          0.95371693,
          9.3198493e-10,
         ),
         (
          0.21643975,
          0.97629595,
          9.3198493e-10,
         ),
         (
          0.13052627,
          0.99144489,
          -1.2426467e-09,
         ),
         (
          0.043619297,
          0.99904829,
          -1.2426467e-09,
         ),
         (
          -0.043619297,
          0.99904817,
          -2.1746316e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -3.2619472e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -4.3492627e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.708639e-09,
         ),
         (
          -0.38268337,
          0.92387956,
          -2.7959546e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.3979774e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          -2.9512854e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          -1.5533083e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -4.038601e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -4.0386015e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          -3.1066164e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -3.8832706e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          -1.5533082e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          9.3198493e-10,
         ),
         (
          -0.97629595,
          0.21643975,
          9.3198493e-10,
         ),
         (
          -0.99144489,
          0.13052627,
          -1.2426467e-09,
         ),
         (
          -0.99904829,
          0.043619297,
          -1.2426467e-09,
         ),
         (
          -0.99904817,
          -0.043619297,
          -2.1746316e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -3.2619472e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -4.3492627e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.708639e-09,
         ),
         (
          -0.92387956,
          -0.38268337,
          -2.7959546e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.3979774e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          -2.9512854e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          -1.5533083e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -4.038601e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -4.0386015e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          -1.5533083e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          -3.1066164e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -3.8832706e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          -1.5533082e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          9.3198493e-10,
         ),
         (
          -0.21643975,
          -0.97629595,
          9.3198493e-10,
         ),
         (
          -0.13052627,
          -0.99144489,
          -1.2426467e-09,
         ),
         (
          -0.043619297,
          -0.99904829,
          -1.2426467e-09,
         ),
         (
          0.043619297,
          -0.99904817,
          -2.1746316e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -3.2619472e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -4.3492627e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.708639e-09,
         ),
         (
          0.38268337,
          -0.92387956,
          -2.7959546e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.3979774e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          -2.9512854e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          -1.5533083e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -4.038601e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -4.0386015e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          -3.1066164e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -3.8832706e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          -1.5533082e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          9.3198493e-10,
         ),
         (
          0.97629595,
          -0.21643975,
          9.3198493e-10,
         ),
         (
          0.99144489,
          -0.13052627,
          -1.2426467e-09,
         ),
         (
          0.99904829,
          -0.043619297,
          -1.2426467e-09,
         ),
         (
          1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          0.99619466,
          0.087155797,
          -3.1066166e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.0873158e-09,
         ),
         (
          0.96592581,
          0.25881916,
          0.0,
         ),
         (
          0.9396928,
          0.34201986,
          7.7665413e-10,
         ),
         (
          0.9063077,
          0.42261836,
          7.7665407e-10,
         ),
         (
          0.86602539,
          0.5,
          -6.2132322e-10,
         ),
         (
          0.81915218,
          0.57357633,
          6.2132333e-10,
         ),
         (
          0.76604438,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -3.8832701e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          0.57357633,
          0.81915212,
          3.1066163e-09,
         ),
         (
          0.50000006,
          0.86602545,
          -6.2132333e-10,
         ),
         (
          0.42261839,
          0.9063077,
          7.7665407e-10,
         ),
         (
          0.34201989,
          0.93969274,
          3.2619474e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.8832701e-09,
         ),
         (
          0.17364839,
          0.98480773,
          1.5533083e-09,
         ),
         (
          0.087155804,
          0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          1.0,
          1.0873157e-09,
         ),
         (
          -0.087155797,
          0.99619466,
          -3.1066166e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.0873158e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          0.0,
         ),
         (
          -0.34201986,
          0.9396928,
          7.7665413e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          7.7665407e-10,
         ),
         (
          -0.5,
          0.86602539,
          -6.2132322e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          6.2132333e-10,
         ),
         (
          -0.64278764,
          0.76604438,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -3.8832701e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          3.1066163e-09,
         ),
         (
          -0.86602545,
          0.50000006,
          -6.2132333e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          7.7665407e-10,
         ),
         (
          -0.93969274,
          0.34201989,
          3.2619474e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.8832701e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          1.5533083e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          6.2132333e-10,
         ),
         (
          -1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          -0.99619466,
          -0.087155797,
          -3.1066166e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.0873158e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          0.0,
         ),
         (
          -0.9396928,
          -0.34201986,
          7.7665413e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          7.7665407e-10,
         ),
         (
          -0.86602539,
          -0.5,
          -6.2132322e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          6.2132333e-10,
         ),
         (
          -0.76604438,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -3.8832701e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          3.1066163e-09,
         ),
         (
          -0.50000006,
          -0.86602545,
          -6.2132333e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          -0.34201989,
          -0.93969274,
          3.2619474e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.8832701e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          1.5533083e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          -1.0,
          1.0873157e-09,
         ),
         (
          0.087155797,
          -0.99619466,
          -3.1066166e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.0873158e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          0.0,
         ),
         (
          0.34201986,
          -0.9396928,
          7.7665413e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          0.5,
          -0.86602539,
          -6.2132322e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          6.2132333e-10,
         ),
         (
          0.64278764,
          -0.76604438,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -3.8832701e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          3.1066163e-09,
         ),
         (
          0.86602545,
          -0.50000006,
          -6.2132333e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          7.7665407e-10,
         ),
         (
          0.93969274,
          -0.34201989,
          3.2619474e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.8832701e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          1.5533083e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          6.2132333e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -1.3979774e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -2.4852931e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -3.417278e-09,
         ),
         (
          0.95371699,
          0.30070585,
          -7.7665413e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -2.0193005e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -2.1746314e-09,
         ),
         (
          0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -2.9512854e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.9512857e-09,
         ),
         (
          0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          0.53729939,
          0.84339154,
          3.1066164e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -3.4172782e-09,
         ),
         (
          0.3826834,
          0.92387956,
          4.6599247e-10,
         ),
         (
          0.30070585,
          0.95371693,
          1.8639699e-09,
         ),
         (
          0.21643975,
          0.97629595,
          1.8639699e-09,
         ),
         (
          0.13052627,
          0.99144489,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          0.99904829,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -1.3979774e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -2.4852931e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -3.417278e-09,
         ),
         (
          -0.30070585,
          0.95371699,
          -7.7665413e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -2.0193005e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -2.1746314e-09,
         ),
         (
          -0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.9512854e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.9512857e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          3.1066164e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -3.4172782e-09,
         ),
         (
          -0.92387956,
          0.3826834,
          4.6599247e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          1.8639699e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          1.8639699e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          -4.6599247e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          -4.6599247e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -1.3979774e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -2.4852931e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -3.417278e-09,
         ),
         (
          -0.95371699,
          -0.30070585,
          -7.7665413e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -2.0193005e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -2.1746314e-09,
         ),
         (
          -0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.9512854e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.9512857e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          3.1066164e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -3.4172782e-09,
         ),
         (
          -0.3826834,
          -0.92387956,
          4.6599247e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          1.8639699e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          1.8639699e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -1.3979774e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -2.4852931e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -3.417278e-09,
         ),
         (
          0.30070585,
          -0.95371699,
          -7.7665413e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -2.0193005e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -2.1746314e-09,
         ),
         (
          0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.9512854e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.9512857e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          3.1066164e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -3.4172782e-09,
         ),
         (
          0.92387956,
          -0.3826834,
          4.6599247e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          1.8639699e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          1.8639699e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          -4.6599247e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          -4.6599247e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          6.2132327e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -6.2132333e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.3979774e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -4.6599247e-10,
         ),
         (
          0.93969274,
          0.34201986,
          4.6599247e-10,
         ),
         (
          0.9063077,
          0.42261836,
          4.6599247e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -9.3198493e-10,
         ),
         (
          0.81915218,
          0.57357633,
          3.1066166e-10,
         ),
         (
          0.76604444,
          0.64278764,
          -2.0193007e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.5045936e-09,
         ),
         (
          0.64278764,
          0.76604438,
          -2.0193007e-09,
         ),
         (
          0.57357633,
          0.81915218,
          2.9512854e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -9.3198493e-10,
         ),
         (
          0.42261836,
          0.9063077,
          3.1066164e-10,
         ),
         (
          0.34201992,
          0.93969274,
          2.9512857e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.417278e-09,
         ),
         (
          0.17364837,
          0.98480773,
          1.2426467e-09,
         ),
         (
          0.087155804,
          0.99619466,
          3.1066166e-10,
         ),
         (
          0.0,
          1.0,
          6.2132327e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -6.2132333e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.3979774e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -4.6599247e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          4.6599247e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          4.6599247e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -9.3198493e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          3.1066166e-10,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.0193007e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.5045936e-09,
         ),
         (
          -0.76604438,
          0.64278764,
          -2.0193007e-09,
         ),
         (
          -0.81915218,
          0.57357633,
          2.9512854e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -9.3198493e-10,
         ),
         (
          -0.9063077,
          0.42261836,
          3.1066164e-10,
         ),
         (
          -0.93969274,
          0.34201992,
          2.9512857e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.417278e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          1.2426467e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          3.1066166e-10,
         ),
         (
          -1.0,
          0.0,
          6.2132327e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -6.2132333e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.3979774e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -4.6599247e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          4.6599247e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          4.6599247e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -9.3198493e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          3.1066166e-10,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.0193007e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.5045936e-09,
         ),
         (
          -0.64278764,
          -0.76604438,
          -2.0193007e-09,
         ),
         (
          -0.57357633,
          -0.81915218,
          2.9512854e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -9.3198493e-10,
         ),
         (
          -0.42261836,
          -0.9063077,
          3.1066164e-10,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.9512857e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.417278e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          1.2426467e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          3.1066166e-10,
         ),
         (
          0.0,
          -1.0,
          6.2132327e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -6.2132333e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.3979774e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -4.6599247e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          4.6599247e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          4.6599247e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -9.3198493e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          3.1066166e-10,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.0193007e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.5045936e-09,
         ),
         (
          0.76604438,
          -0.64278764,
          -2.0193007e-09,
         ),
         (
          0.81915218,
          -0.57357633,
          2.9512854e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -9.3198493e-10,
         ),
         (
          0.9063077,
          -0.42261836,
          3.1066164e-10,
         ),
         (
          0.93969274,
          -0.34201992,
          2.9512857e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.417278e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          1.2426467e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          3.1066166e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.5533081e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.4852931e-09,
         ),
         (
          0.95371693,
          0.30070588,
          0.0,
         ),
         (
          0.92387956,
          0.38268337,
          -1.0873157e-09,
         ),
         (
          0.88701075,
          0.46174878,
          1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.79335338,
          0.60876143,
          1.0873158e-09,
         ),
         (
          0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          0.60876137,
          0.79335338,
          1.0873158e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.2426465e-09,
         ),
         (
          0.46174878,
          0.88701075,
          -2.4852933e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.3979773e-09,
         ),
         (
          0.30070588,
          0.95371693,
          2.4852933e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.5533081e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.4852931e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          0.0,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.0873157e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876143,
          0.79335338,
          1.0873158e-09,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.79335338,
          0.60876137,
          1.0873158e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.2426465e-09,
         ),
         (
          -0.88701075,
          0.46174878,
          -2.4852933e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.3979773e-09,
         ),
         (
          -0.95371693,
          0.30070588,
          2.4852933e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.5533081e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.4852931e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          0.0,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.0873157e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.79335338,
          -0.60876143,
          1.0873158e-09,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.60876137,
          -0.79335338,
          1.0873158e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.2426465e-09,
         ),
         (
          -0.46174878,
          -0.88701075,
          -2.4852933e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.3979773e-09,
         ),
         (
          -0.30070588,
          -0.95371693,
          2.4852933e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.5533081e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.4852931e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          0.0,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.0873157e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876143,
          -0.79335338,
          1.0873158e-09,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          0.79335338,
          -0.60876137,
          1.0873158e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.2426465e-09,
         ),
         (
          0.88701075,
          -0.46174878,
          -2.4852933e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.3979773e-09,
         ),
         (
          0.95371693,
          -0.30070588,
          2.4852933e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          4.6599247e-10,
         ),
         (
          0.99619478,
          0.087155804,
          -1.0873158e-09,
         ),
         (
          0.98480773,
          0.17364837,
          -1.5533083e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -1.0873157e-09,
         ),
         (
          0.93969274,
          0.34201992,
          -6.2132327e-10,
         ),
         (
          0.9063077,
          0.42261836,
          0.0,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -3.1066166e-10,
         ),
         (
          0.76604438,
          0.64278769,
          -2.7959548e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -5.2812479e-09,
         ),
         (
          0.64278769,
          0.76604438,
          -2.7959546e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.3299622e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -1.0873158e-09,
         ),
         (
          0.42261836,
          0.9063077,
          1.5533082e-10,
         ),
         (
          0.34201992,
          0.93969274,
          2.0193005e-09,
         ),
         (
          0.25881913,
          0.96592581,
          2.6406239e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155804,
          0.99619466,
          -1.5533083e-10,
         ),
         (
          0.0,
          1.0,
          4.6599247e-10,
         ),
         (
          -0.087155804,
          0.99619478,
          -1.0873158e-09,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.5533083e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -1.0873157e-09,
         ),
         (
          -0.34201992,
          0.93969274,
          -6.2132327e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          0.0,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -3.1066166e-10,
         ),
         (
          -0.64278769,
          0.76604438,
          -2.7959548e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -5.2812479e-09,
         ),
         (
          -0.76604438,
          0.64278769,
          -2.7959546e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.3299622e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -1.0873158e-09,
         ),
         (
          -0.9063077,
          0.42261836,
          1.5533082e-10,
         ),
         (
          -0.93969274,
          0.34201992,
          2.0193005e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          2.6406239e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          -1.5533083e-10,
         ),
         (
          -1.0,
          0.0,
          4.6599247e-10,
         ),
         (
          -0.99619478,
          -0.087155804,
          -1.0873158e-09,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.5533083e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -1.0873157e-09,
         ),
         (
          -0.93969274,
          -0.34201992,
          -6.2132327e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          0.0,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -3.1066166e-10,
         ),
         (
          -0.76604438,
          -0.64278769,
          -2.7959548e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -5.2812479e-09,
         ),
         (
          -0.64278769,
          -0.76604438,
          -2.7959546e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.3299622e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -1.0873158e-09,
         ),
         (
          -0.42261836,
          -0.9063077,
          1.5533082e-10,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.0193005e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          2.6406239e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          -1.5533083e-10,
         ),
         (
          0.0,
          -1.0,
          4.6599247e-10,
         ),
         (
          0.087155804,
          -0.99619478,
          -1.0873158e-09,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.5533083e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -1.0873157e-09,
         ),
         (
          0.34201992,
          -0.93969274,
          -6.2132327e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          0.0,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -3.1066166e-10,
         ),
         (
          0.64278769,
          -0.76604438,
          -2.7959548e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -5.2812479e-09,
         ),
         (
          0.76604438,
          -0.64278769,
          -2.7959546e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.3299622e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -1.0873158e-09,
         ),
         (
          0.9063077,
          -0.42261836,
          1.5533082e-10,
         ),
         (
          0.93969274,
          -0.34201992,
          2.0193005e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          2.6406239e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          -1.5533083e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -4.6599247e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.3979774e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.1746314e-09,
         ),
         (
          0.95371693,
          0.30070588,
          -1.5533083e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.0873157e-09,
         ),
         (
          0.88701075,
          0.46174878,
          4.6599247e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.0873157e-09,
         ),
         (
          0.79335338,
          0.60876143,
          1.2426467e-09,
         ),
         (
          0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          0.60876143,
          0.79335338,
          1.2426467e-09,
         ),
         (
          0.53729945,
          0.84339154,
          1.5533081e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.0193007e-09,
         ),
         (
          0.3826834,
          0.92387956,
          1.5533083e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.3299622e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.7959546e-09,
         ),
         (
          0.13052627,
          0.99144489,
          4.6599247e-10,
         ),
         (
          0.043619301,
          0.99904829,
          4.6599247e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -4.6599247e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.3979774e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.1746314e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          -1.5533083e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.0873157e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          4.6599247e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.0873157e-09,
         ),
         (
          -0.60876143,
          0.79335338,
          1.2426467e-09,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.73727715,
          0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.79335338,
          0.60876143,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729945,
          1.5533081e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.0193007e-09,
         ),
         (
          -0.92387956,
          0.3826834,
          1.5533083e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.3299622e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.7959546e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          4.6599247e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          4.6599247e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -4.6599247e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.3979774e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.1746314e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          -1.5533083e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.0873157e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          4.6599247e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.0873157e-09,
         ),
         (
          -0.79335338,
          -0.60876143,
          1.2426467e-09,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          -0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          -0.60876143,
          -0.79335338,
          1.2426467e-09,
         ),
         (
          -0.53729945,
          -0.84339154,
          1.5533081e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.0193007e-09,
         ),
         (
          -0.3826834,
          -0.92387956,
          1.5533083e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.3299622e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.7959546e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          4.6599247e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          4.6599247e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -4.6599247e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.3979774e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.1746314e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          -1.5533083e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.0873157e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          4.6599247e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.0873157e-09,
         ),
         (
          0.60876143,
          -0.79335338,
          1.2426467e-09,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.4852931e-09,
         ),
         (
          0.73727715,
          -0.6755904,
          -2.4852931e-09,
         ),
         (
          0.79335338,
          -0.60876143,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729945,
          1.5533081e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.0193007e-09,
         ),
         (
          0.92387956,
          -0.3826834,
          1.5533083e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.3299622e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.7959546e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          4.6599247e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          4.6599247e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619478,
          0.087155804,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.5533083e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -6.2132327e-10,
         ),
         (
          0.93969274,
          0.34201986,
          0.0,
         ),
         (
          0.9063077,
          0.42261836,
          3.1066164e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -1.5533083e-10,
         ),
         (
          0.76604444,
          0.64278769,
          -2.6406242e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278775,
          0.76604438,
          -2.6406242e-09,
         ),
         (
          0.57357633,
          0.81915218,
          2.4852931e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -1.2426467e-09,
         ),
         (
          0.42261836,
          0.9063077,
          1.5533082e-10,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852931e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364839,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155804,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155804,
          0.99619478,
          -9.3198493e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.5533083e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -6.2132327e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          0.0,
         ),
         (
          -0.42261836,
          0.9063077,
          3.1066164e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -1.5533083e-10,
         ),
         (
          -0.64278769,
          0.76604444,
          -2.6406242e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604438,
          0.64278775,
          -2.6406242e-09,
         ),
         (
          -0.81915218,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -1.2426467e-09,
         ),
         (
          -0.9063077,
          0.42261836,
          1.5533082e-10,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852931e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619478,
          -0.087155804,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.5533083e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -6.2132327e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          0.0,
         ),
         (
          -0.9063077,
          -0.42261836,
          3.1066164e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -1.5533083e-10,
         ),
         (
          -0.76604444,
          -0.64278769,
          -2.6406242e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278775,
          -0.76604438,
          -2.6406242e-09,
         ),
         (
          -0.57357633,
          -0.81915218,
          2.4852931e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -1.2426467e-09,
         ),
         (
          -0.42261836,
          -0.9063077,
          1.5533082e-10,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852931e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155804,
          -0.99619478,
          -9.3198493e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.5533083e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -6.2132327e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          0.0,
         ),
         (
          0.42261836,
          -0.9063077,
          3.1066164e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -1.5533083e-10,
         ),
         (
          0.64278769,
          -0.76604444,
          -2.6406242e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604438,
          -0.64278775,
          -2.6406242e-09,
         ),
         (
          0.81915218,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -1.2426467e-09,
         ),
         (
          0.9063077,
          -0.42261836,
          1.5533082e-10,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852931e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          -9.3198493e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -2.0193005e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -3.2619472e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -4.6599247e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.708639e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -4.6599247e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.8639699e-09,
         ),
         (
          0.7933535,
          0.60876131,
          9.3198493e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -2.7959546e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.7959548e-09,
         ),
         (
          0.60876131,
          0.79335338,
          9.3198493e-10,
         ),
         (
          0.53729939,
          0.84339154,
          7.7665407e-10,
         ),
         (
          0.46174878,
          0.88701075,
          -3.1066165e-09,
         ),
         (
          0.38268337,
          0.92387956,
          7.7665407e-10,
         ),
         (
          0.30070588,
          0.95371693,
          2.1746316e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.0193005e-09,
         ),
         (
          0.13052627,
          0.99144489,
          0.0,
         ),
         (
          0.043619301,
          0.99904829,
          0.0,
         ),
         (
          -0.043619301,
          0.99904817,
          -9.3198493e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -2.0193005e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -3.2619472e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -4.6599247e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.708639e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -4.6599247e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.8639699e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          9.3198493e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.7959546e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.7959548e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          9.3198493e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          7.7665407e-10,
         ),
         (
          -0.88701075,
          0.46174878,
          -3.1066165e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          7.7665407e-10,
         ),
         (
          -0.95371693,
          0.30070588,
          2.1746316e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.0193005e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          0.0,
         ),
         (
          -0.99904829,
          0.043619301,
          0.0,
         ),
         (
          -0.99904817,
          -0.043619301,
          -9.3198493e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -2.0193005e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -3.2619472e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -4.6599247e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.708639e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -4.6599247e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.8639699e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          9.3198493e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.7959546e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.7959548e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          9.3198493e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          7.7665407e-10,
         ),
         (
          -0.46174878,
          -0.88701075,
          -3.1066165e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          7.7665407e-10,
         ),
         (
          -0.30070588,
          -0.95371693,
          2.1746316e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.0193005e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          0.0,
         ),
         (
          -0.043619301,
          -0.99904829,
          0.0,
         ),
         (
          0.043619301,
          -0.99904817,
          -9.3198493e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -2.0193005e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -3.2619472e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -4.6599247e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.708639e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -4.6599247e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.8639699e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          9.3198493e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.7959546e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.7959548e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          9.3198493e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          7.7665407e-10,
         ),
         (
          0.88701075,
          -0.46174878,
          -3.1066165e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          7.7665407e-10,
         ),
         (
          0.95371693,
          -0.30070588,
          2.1746316e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.0193005e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          0.0,
         ),
         (
          0.99904829,
          -0.043619301,
          0.0,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          0.99619466,
          0.087155797,
          -3.1066166e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -1.0873158e-09,
         ),
         (
          0.96592581,
          0.25881916,
          0.0,
         ),
         (
          0.9396928,
          0.34201986,
          7.7665413e-10,
         ),
         (
          0.9063077,
          0.42261836,
          7.7665407e-10,
         ),
         (
          0.86602539,
          0.5,
          -6.2132322e-10,
         ),
         (
          0.81915218,
          0.57357633,
          6.2132333e-10,
         ),
         (
          0.76604438,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -3.8832701e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          0.57357633,
          0.81915212,
          3.1066163e-09,
         ),
         (
          0.50000006,
          0.86602545,
          -6.2132333e-10,
         ),
         (
          0.42261839,
          0.9063077,
          7.7665407e-10,
         ),
         (
          0.34201989,
          0.93969274,
          3.2619474e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.8832701e-09,
         ),
         (
          0.17364839,
          0.98480773,
          1.5533083e-09,
         ),
         (
          0.087155804,
          0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          1.0,
          1.0873157e-09,
         ),
         (
          -0.087155797,
          0.99619466,
          -3.1066166e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -1.0873158e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          0.0,
         ),
         (
          -0.34201986,
          0.9396928,
          7.7665413e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          7.7665407e-10,
         ),
         (
          -0.5,
          0.86602539,
          -6.2132322e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          6.2132333e-10,
         ),
         (
          -0.64278764,
          0.76604438,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -3.8832701e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          3.1066163e-09,
         ),
         (
          -0.86602545,
          0.50000006,
          -6.2132333e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          7.7665407e-10,
         ),
         (
          -0.93969274,
          0.34201989,
          3.2619474e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.8832701e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          1.5533083e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          6.2132333e-10,
         ),
         (
          -1.0,
          0.0,
          1.0873157e-09,
         ),
         (
          -0.99619466,
          -0.087155797,
          -3.1066166e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -1.0873158e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          0.0,
         ),
         (
          -0.9396928,
          -0.34201986,
          7.7665413e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          7.7665407e-10,
         ),
         (
          -0.86602539,
          -0.5,
          -6.2132322e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          6.2132333e-10,
         ),
         (
          -0.76604438,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -3.8832701e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          3.1066163e-09,
         ),
         (
          -0.50000006,
          -0.86602545,
          -6.2132333e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          -0.34201989,
          -0.93969274,
          3.2619474e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.8832701e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          1.5533083e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          6.2132333e-10,
         ),
         (
          0.0,
          -1.0,
          1.0873157e-09,
         ),
         (
          0.087155797,
          -0.99619466,
          -3.1066166e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -1.0873158e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          0.0,
         ),
         (
          0.34201986,
          -0.9396928,
          7.7665413e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          7.7665407e-10,
         ),
         (
          0.5,
          -0.86602539,
          -6.2132322e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          6.2132333e-10,
         ),
         (
          0.64278764,
          -0.76604438,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -3.8832701e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          3.1066163e-09,
         ),
         (
          0.86602545,
          -0.50000006,
          -6.2132333e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          7.7665407e-10,
         ),
         (
          0.93969274,
          -0.34201989,
          3.2619474e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.8832701e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          1.5533083e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          6.2132333e-10,
         ),
         (
          0.99904829,
          0.043619301,
          -1.3979774e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -2.4852931e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -3.417278e-09,
         ),
         (
          0.95371699,
          0.30070585,
          -7.7665413e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -2.0193005e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -2.1746314e-09,
         ),
         (
          0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          0.73727715,
          0.6755904,
          -2.9512854e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.9512857e-09,
         ),
         (
          0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          0.53729939,
          0.84339154,
          3.1066164e-10,
         ),
         (
          0.46174884,
          0.88701075,
          -3.4172782e-09,
         ),
         (
          0.3826834,
          0.92387956,
          4.6599247e-10,
         ),
         (
          0.30070585,
          0.95371693,
          1.8639699e-09,
         ),
         (
          0.21643975,
          0.97629595,
          1.8639699e-09,
         ),
         (
          0.13052627,
          0.99144489,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          0.99904829,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -1.3979774e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -2.4852931e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -3.417278e-09,
         ),
         (
          -0.30070585,
          0.95371699,
          -7.7665413e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -2.0193005e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -2.1746314e-09,
         ),
         (
          -0.60876131,
          0.79335338,
          4.6599247e-10,
         ),
         (
          -0.6755904,
          0.73727715,
          -2.9512854e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.9512857e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          4.6599247e-10,
         ),
         (
          -0.84339154,
          0.53729939,
          3.1066164e-10,
         ),
         (
          -0.88701075,
          0.46174884,
          -3.4172782e-09,
         ),
         (
          -0.92387956,
          0.3826834,
          4.6599247e-10,
         ),
         (
          -0.95371693,
          0.30070585,
          1.8639699e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          1.8639699e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          -4.6599247e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          -4.6599247e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -1.3979774e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -2.4852931e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -3.417278e-09,
         ),
         (
          -0.95371699,
          -0.30070585,
          -7.7665413e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -2.0193005e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -2.1746314e-09,
         ),
         (
          -0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          -0.73727715,
          -0.6755904,
          -2.9512854e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.9512857e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          -0.53729939,
          -0.84339154,
          3.1066164e-10,
         ),
         (
          -0.46174884,
          -0.88701075,
          -3.4172782e-09,
         ),
         (
          -0.3826834,
          -0.92387956,
          4.6599247e-10,
         ),
         (
          -0.30070585,
          -0.95371693,
          1.8639699e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          1.8639699e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          -4.6599247e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          -4.6599247e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -1.3979774e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -2.4852931e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -3.417278e-09,
         ),
         (
          0.30070585,
          -0.95371699,
          -7.7665413e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -2.0193005e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -2.1746314e-09,
         ),
         (
          0.60876131,
          -0.79335338,
          4.6599247e-10,
         ),
         (
          0.6755904,
          -0.73727715,
          -2.9512854e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.9512857e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          4.6599247e-10,
         ),
         (
          0.84339154,
          -0.53729939,
          3.1066164e-10,
         ),
         (
          0.88701075,
          -0.46174884,
          -3.4172782e-09,
         ),
         (
          0.92387956,
          -0.3826834,
          4.6599247e-10,
         ),
         (
          0.95371693,
          -0.30070585,
          1.8639699e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          1.8639699e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          -4.6599247e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          -4.6599247e-10,
         ),
         (
          1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          0.99619466,
          0.087155804,
          4.6599247e-10,
         ),
         (
          0.98480773,
          0.17364839,
          -3.1066166e-10,
         ),
         (
          0.96592581,
          0.25881916,
          4.6599247e-10,
         ),
         (
          0.93969274,
          0.34201986,
          1.3979773e-09,
         ),
         (
          0.9063077,
          0.42261836,
          1.5533081e-09,
         ),
         (
          0.86602545,
          0.50000006,
          3.1066166e-10,
         ),
         (
          0.81915218,
          0.57357633,
          1.3979774e-09,
         ),
         (
          0.76604438,
          0.64278764,
          -7.7665413e-10,
         ),
         (
          0.70710677,
          0.70710683,
          -3.5726087e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -7.7665413e-10,
         ),
         (
          0.57357633,
          0.81915212,
          4.038601e-09,
         ),
         (
          0.50000006,
          0.86602539,
          4.6599247e-10,
         ),
         (
          0.42261839,
          0.9063077,
          1.708639e-09,
         ),
         (
          0.34201992,
          0.93969274,
          4.0386015e-09,
         ),
         (
          0.25881913,
          0.96592581,
          4.3492627e-09,
         ),
         (
          0.17364837,
          0.98480773,
          2.3299624e-09,
         ),
         (
          0.087155797,
          0.99619466,
          1.3979774e-09,
         ),
         (
          0.0,
          1.0,
          1.8639699e-09,
         ),
         (
          -0.087155804,
          0.99619466,
          4.6599247e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          -3.1066166e-10,
         ),
         (
          -0.25881916,
          0.96592581,
          4.6599247e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          1.3979773e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          1.5533081e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          3.1066166e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          1.3979774e-09,
         ),
         (
          -0.64278764,
          0.76604438,
          -7.7665413e-10,
         ),
         (
          -0.70710683,
          0.70710677,
          -3.5726087e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -7.7665413e-10,
         ),
         (
          -0.81915212,
          0.57357633,
          4.038601e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          4.6599247e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          1.708639e-09,
         ),
         (
          -0.93969274,
          0.34201992,
          4.0386015e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          4.3492627e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          2.3299624e-09,
         ),
         (
          -0.99619466,
          0.087155797,
          1.3979774e-09,
         ),
         (
          -1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          -0.99619466,
          -0.087155804,
          4.6599247e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          -3.1066166e-10,
         ),
         (
          -0.96592581,
          -0.25881916,
          4.6599247e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          1.3979773e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          1.5533081e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          3.1066166e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          1.3979774e-09,
         ),
         (
          -0.76604438,
          -0.64278764,
          -7.7665413e-10,
         ),
         (
          -0.70710677,
          -0.70710683,
          -3.5726087e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -7.7665413e-10,
         ),
         (
          -0.57357633,
          -0.81915212,
          4.038601e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          4.6599247e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          1.708639e-09,
         ),
         (
          -0.34201992,
          -0.93969274,
          4.0386015e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          4.3492627e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          2.3299624e-09,
         ),
         (
          -0.087155797,
          -0.99619466,
          1.3979774e-09,
         ),
         (
          0.0,
          -1.0,
          1.8639699e-09,
         ),
         (
          0.087155804,
          -0.99619466,
          4.6599247e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          -3.1066166e-10,
         ),
         (
          0.25881916,
          -0.96592581,
          4.6599247e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          1.3979773e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          1.5533081e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          3.1066166e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          1.3979774e-09,
         ),
         (
          0.64278764,
          -0.76604438,
          -7.7665413e-10,
         ),
         (
          0.70710683,
          -0.70710677,
          -3.5726087e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -7.7665413e-10,
         ),
         (
          0.81915212,
          -0.57357633,
          4.038601e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          4.6599247e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          1.708639e-09,
         ),
         (
          0.93969274,
          -0.34201992,
          4.0386015e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          4.3492627e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          2.3299624e-09,
         ),
         (
          0.99619466,
          -0.087155797,
          1.3979774e-09,
         ),
         (
          0.99904829,
          0.043619297,
          -3.7279397e-09,
         ),
         (
          0.99144489,
          0.13052627,
          -4.6599244e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -5.5919092e-09,
         ),
         (
          0.95371693,
          0.30070588,
          -2.9512857e-09,
         ),
         (
          0.92387956,
          0.3826834,
          -4.0386015e-09,
         ),
         (
          0.88701075,
          0.46174878,
          -2.7959548e-09,
         ),
         (
          0.84339154,
          0.53729939,
          -4.1939319e-09,
         ),
         (
          0.79335344,
          0.60876137,
          -1.8639699e-09,
         ),
         (
          0.73727715,
          0.6755904,
          -5.74724e-09,
         ),
         (
          0.6755904,
          0.73727715,
          -5.74724e-09,
         ),
         (
          0.60876131,
          0.79335338,
          -1.8639699e-09,
         ),
         (
          0.53729939,
          0.84339154,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -5.2812483e-09,
         ),
         (
          0.38268337,
          0.92387956,
          -1.3979773e-09,
         ),
         (
          0.30070585,
          0.95371693,
          -3.1066166e-10,
         ),
         (
          0.21643975,
          0.97629595,
          -4.6599247e-10,
         ),
         (
          0.13052627,
          0.99144489,
          -2.7959548e-09,
         ),
         (
          0.043619297,
          0.99904829,
          -2.7959548e-09,
         ),
         (
          -0.043619297,
          0.99904817,
          -3.7279397e-09,
         ),
         (
          -0.13052627,
          0.99144489,
          -4.6599244e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -5.5919092e-09,
         ),
         (
          -0.30070588,
          0.95371693,
          -2.9512857e-09,
         ),
         (
          -0.3826834,
          0.92387956,
          -4.0386015e-09,
         ),
         (
          -0.46174878,
          0.88701075,
          -2.7959548e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          -4.1939319e-09,
         ),
         (
          -0.60876137,
          0.79335344,
          -1.8639699e-09,
         ),
         (
          -0.6755904,
          0.73727715,
          -5.74724e-09,
         ),
         (
          -0.73727715,
          0.6755904,
          -5.74724e-09,
         ),
         (
          -0.79335338,
          0.60876131,
          -1.8639699e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -5.2812483e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          -1.3979773e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          -3.1066166e-10,
         ),
         (
          -0.97629595,
          0.21643975,
          -4.6599247e-10,
         ),
         (
          -0.99144489,
          0.13052627,
          -2.7959548e-09,
         ),
         (
          -0.99904829,
          0.043619297,
          -2.7959548e-09,
         ),
         (
          -0.99904817,
          -0.043619297,
          -3.7279397e-09,
         ),
         (
          -0.99144489,
          -0.13052627,
          -4.6599244e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -5.5919092e-09,
         ),
         (
          -0.95371693,
          -0.30070588,
          -2.9512857e-09,
         ),
         (
          -0.92387956,
          -0.3826834,
          -4.0386015e-09,
         ),
         (
          -0.88701075,
          -0.46174878,
          -2.7959548e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          -4.1939319e-09,
         ),
         (
          -0.79335344,
          -0.60876137,
          -1.8639699e-09,
         ),
         (
          -0.73727715,
          -0.6755904,
          -5.74724e-09,
         ),
         (
          -0.6755904,
          -0.73727715,
          -5.74724e-09,
         ),
         (
          -0.60876131,
          -0.79335338,
          -1.8639699e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -5.2812483e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          -1.3979773e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          -3.1066166e-10,
         ),
         (
          -0.21643975,
          -0.97629595,
          -4.6599247e-10,
         ),
         (
          -0.13052627,
          -0.99144489,
          -2.7959548e-09,
         ),
         (
          -0.043619297,
          -0.99904829,
          -2.7959548e-09,
         ),
         (
          0.043619297,
          -0.99904817,
          -3.7279397e-09,
         ),
         (
          0.13052627,
          -0.99144489,
          -4.6599244e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -5.5919092e-09,
         ),
         (
          0.30070588,
          -0.95371693,
          -2.9512857e-09,
         ),
         (
          0.3826834,
          -0.92387956,
          -4.0386015e-09,
         ),
         (
          0.46174878,
          -0.88701075,
          -2.7959548e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          -4.1939319e-09,
         ),
         (
          0.60876137,
          -0.79335344,
          -1.8639699e-09,
         ),
         (
          0.6755904,
          -0.73727715,
          -5.74724e-09,
         ),
         (
          0.73727715,
          -0.6755904,
          -5.74724e-09,
         ),
         (
          0.79335338,
          -0.60876131,
          -1.8639699e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -5.2812483e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          -1.3979773e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          -3.1066166e-10,
         ),
         (
          0.97629595,
          -0.21643975,
          -4.6599247e-10,
         ),
         (
          0.99144489,
          -0.13052627,
          -2.7959548e-09,
         ),
         (
          0.99904829,
          -0.043619297,
          -2.7959548e-09,
         ),
         (
          1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          0.99619478,
          0.087155804,
          6.2132333e-10,
         ),
         (
          0.98480773,
          0.17364839,
          0.0,
         ),
         (
          0.96592581,
          0.25881913,
          9.3198493e-10,
         ),
         (
          0.93969274,
          0.34201986,
          1.5533081e-09,
         ),
         (
          0.9063077,
          0.42261836,
          1.3979773e-09,
         ),
         (
          0.86602545,
          0.50000006,
          3.1066166e-10,
         ),
         (
          0.81915218,
          0.57357633,
          1.5533083e-09,
         ),
         (
          0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          0.70710683,
          -3.7279397e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          0.57357633,
          0.81915212,
          4.038601e-09,
         ),
         (
          0.50000006,
          0.86602539,
          3.1066164e-10,
         ),
         (
          0.42261839,
          0.9063077,
          1.5533081e-09,
         ),
         (
          0.34201986,
          0.93969274,
          4.1939319e-09,
         ),
         (
          0.25881913,
          0.96592581,
          4.8152553e-09,
         ),
         (
          0.17364839,
          0.98480773,
          2.4852933e-09,
         ),
         (
          0.087155804,
          0.99619466,
          1.5533083e-09,
         ),
         (
          0.0,
          1.0,
          1.8639699e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          6.2132333e-10,
         ),
         (
          -0.17364839,
          0.98480773,
          0.0,
         ),
         (
          -0.25881913,
          0.96592581,
          9.3198493e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          1.5533081e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          1.3979773e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          3.1066166e-10,
         ),
         (
          -0.57357633,
          0.81915218,
          1.5533083e-09,
         ),
         (
          -0.64278764,
          0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          0.70710683,
          -3.7279397e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          4.038601e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          3.1066164e-10,
         ),
         (
          -0.9063077,
          0.42261839,
          1.5533081e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          4.1939319e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          4.8152553e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          2.4852933e-09,
         ),
         (
          -0.99619466,
          0.087155804,
          1.5533083e-09,
         ),
         (
          -1.0,
          0.0,
          1.8639699e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          6.2132333e-10,
         ),
         (
          -0.98480773,
          -0.17364839,
          0.0,
         ),
         (
          -0.96592581,
          -0.25881913,
          9.3198493e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          1.5533081e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          1.3979773e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          3.1066166e-10,
         ),
         (
          -0.81915218,
          -0.57357633,
          1.5533083e-09,
         ),
         (
          -0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          -0.70710683,
          -0.70710683,
          -3.7279397e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          4.038601e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          3.1066164e-10,
         ),
         (
          -0.42261839,
          -0.9063077,
          1.5533081e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          4.1939319e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          4.8152553e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          2.4852933e-09,
         ),
         (
          -0.087155804,
          -0.99619466,
          1.5533083e-09,
         ),
         (
          0.0,
          -1.0,
          1.8639699e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          6.2132333e-10,
         ),
         (
          0.17364839,
          -0.98480773,
          0.0,
         ),
         (
          0.25881913,
          -0.96592581,
          9.3198493e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          1.5533081e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          1.3979773e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          3.1066166e-10,
         ),
         (
          0.57357633,
          -0.81915218,
          1.5533083e-09,
         ),
         (
          0.64278764,
          -0.76604444,
          -1.5533083e-09,
         ),
         (
          0.70710683,
          -0.70710683,
          -3.7279397e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -1.5533083e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          4.038601e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          3.1066164e-10,
         ),
         (
          0.9063077,
          -0.42261839,
          1.5533081e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          4.1939319e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          4.8152553e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          2.4852933e-09,
         ),
         (
          0.99619466,
          -0.087155804,
          1.5533083e-09,
         ),
         (
          0.99904829,
          0.043619301,
          9.3198493e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.5533083e-10,
         ),
         (
          0.97629595,
          0.21643975,
          -1.0873157e-09,
         ),
         (
          0.95371693,
          0.30070585,
          1.7086391e-09,
         ),
         (
          0.92387956,
          0.38268337,
          1.5533082e-10,
         ),
         (
          0.88701075,
          0.46174878,
          1.5533083e-09,
         ),
         (
          0.84339154,
          0.53729939,
          4.6599247e-10,
         ),
         (
          0.79335344,
          0.60876131,
          2.6406239e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          0.60876131,
          0.7933535,
          2.6406242e-09,
         ),
         (
          0.53729945,
          0.84339154,
          2.9512857e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -9.3198493e-10,
         ),
         (
          0.38268337,
          0.92387956,
          2.7959546e-09,
         ),
         (
          0.30070585,
          0.95371699,
          4.1939323e-09,
         ),
         (
          0.21643974,
          0.97629595,
          4.038601e-09,
         ),
         (
          0.13052627,
          0.99144489,
          1.8639699e-09,
         ),
         (
          0.043619301,
          0.99904829,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          0.99904817,
          9.3198493e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.5533083e-10,
         ),
         (
          -0.21643975,
          0.97629595,
          -1.0873157e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          1.7086391e-09,
         ),
         (
          -0.38268337,
          0.92387956,
          1.5533082e-10,
         ),
         (
          -0.46174878,
          0.88701075,
          1.5533083e-09,
         ),
         (
          -0.53729939,
          0.84339154,
          4.6599247e-10,
         ),
         (
          -0.60876131,
          0.79335344,
          2.6406239e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          2.6406242e-09,
         ),
         (
          -0.84339154,
          0.53729945,
          2.9512857e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -9.3198493e-10,
         ),
         (
          -0.92387956,
          0.38268337,
          2.7959546e-09,
         ),
         (
          -0.95371699,
          0.30070585,
          4.1939323e-09,
         ),
         (
          -0.97629595,
          0.21643974,
          4.038601e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          1.8639699e-09,
         ),
         (
          -0.99904829,
          0.043619301,
          1.8639699e-09,
         ),
         (
          -0.99904817,
          -0.043619301,
          9.3198493e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.5533083e-10,
         ),
         (
          -0.97629595,
          -0.21643975,
          -1.0873157e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          1.7086391e-09,
         ),
         (
          -0.92387956,
          -0.38268337,
          1.5533082e-10,
         ),
         (
          -0.88701075,
          -0.46174878,
          1.5533083e-09,
         ),
         (
          -0.84339154,
          -0.53729939,
          4.6599247e-10,
         ),
         (
          -0.79335344,
          -0.60876131,
          2.6406239e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          2.6406242e-09,
         ),
         (
          -0.53729945,
          -0.84339154,
          2.9512857e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -9.3198493e-10,
         ),
         (
          -0.38268337,
          -0.92387956,
          2.7959546e-09,
         ),
         (
          -0.30070585,
          -0.95371699,
          4.1939323e-09,
         ),
         (
          -0.21643974,
          -0.97629595,
          4.038601e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          1.8639699e-09,
         ),
         (
          -0.043619301,
          -0.99904829,
          1.8639699e-09,
         ),
         (
          0.043619301,
          -0.99904817,
          9.3198493e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.5533083e-10,
         ),
         (
          0.21643975,
          -0.97629595,
          -1.0873157e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          1.7086391e-09,
         ),
         (
          0.38268337,
          -0.92387956,
          1.5533082e-10,
         ),
         (
          0.46174878,
          -0.88701075,
          1.5533083e-09,
         ),
         (
          0.53729939,
          -0.84339154,
          4.6599247e-10,
         ),
         (
          0.60876131,
          -0.79335344,
          2.6406239e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -1.0873158e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -1.0873158e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          2.6406242e-09,
         ),
         (
          0.84339154,
          -0.53729945,
          2.9512857e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -9.3198493e-10,
         ),
         (
          0.92387956,
          -0.38268337,
          2.7959546e-09,
         ),
         (
          0.95371699,
          -0.30070585,
          4.1939323e-09,
         ),
         (
          0.97629595,
          -0.21643974,
          4.038601e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          1.8639699e-09,
         ),
         (
          0.99904829,
          -0.043619301,
          1.8639699e-09,
         ),
         (
          1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          0.99619478,
          0.087155804,
          -2.3299624e-09,
         ),
         (
          0.98480773,
          0.17364837,
          -3.1066165e-09,
         ),
         (
          0.96592581,
          0.25881913,
          -1.8639699e-09,
         ),
         (
          0.93969274,
          0.34201986,
          -1.3979773e-09,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533081e-09,
         ),
         (
          0.86602545,
          0.50000006,
          -2.4852933e-09,
         ),
         (
          0.81915218,
          0.57357633,
          -1.3979774e-09,
         ),
         (
          0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          0.57357633,
          0.81915212,
          1.0873157e-09,
         ),
         (
          0.50000012,
          0.86602533,
          -2.4852933e-09,
         ),
         (
          0.42261839,
          0.9063077,
          -1.3979773e-09,
         ),
         (
          0.34201986,
          0.93969274,
          1.2426465e-09,
         ),
         (
          0.25881913,
          0.96592581,
          1.8639699e-09,
         ),
         (
          0.17364839,
          0.98480773,
          -4.6599247e-10,
         ),
         (
          0.087155804,
          0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          1.0,
          -1.2426465e-09,
         ),
         (
          -0.087155804,
          0.99619478,
          -2.3299624e-09,
         ),
         (
          -0.17364837,
          0.98480773,
          -3.1066165e-09,
         ),
         (
          -0.25881913,
          0.96592581,
          -1.8639699e-09,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.3979773e-09,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533081e-09,
         ),
         (
          -0.50000006,
          0.86602545,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          -1.3979774e-09,
         ),
         (
          -0.64278764,
          0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          1.0873157e-09,
         ),
         (
          -0.86602533,
          0.50000012,
          -2.4852933e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          -1.3979773e-09,
         ),
         (
          -0.93969274,
          0.34201986,
          1.2426465e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          1.8639699e-09,
         ),
         (
          -0.98480773,
          0.17364839,
          -4.6599247e-10,
         ),
         (
          -0.99619466,
          0.087155804,
          -1.3979774e-09,
         ),
         (
          -1.0,
          0.0,
          -1.2426465e-09,
         ),
         (
          -0.99619478,
          -0.087155804,
          -2.3299624e-09,
         ),
         (
          -0.98480773,
          -0.17364837,
          -3.1066165e-09,
         ),
         (
          -0.96592581,
          -0.25881913,
          -1.8639699e-09,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.3979773e-09,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533081e-09,
         ),
         (
          -0.86602545,
          -0.50000006,
          -2.4852933e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          -1.3979774e-09,
         ),
         (
          -0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          -0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          1.0873157e-09,
         ),
         (
          -0.50000012,
          -0.86602533,
          -2.4852933e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          -1.3979773e-09,
         ),
         (
          -0.34201986,
          -0.93969274,
          1.2426465e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          1.8639699e-09,
         ),
         (
          -0.17364839,
          -0.98480773,
          -4.6599247e-10,
         ),
         (
          -0.087155804,
          -0.99619466,
          -1.3979774e-09,
         ),
         (
          0.0,
          -1.0,
          -1.2426465e-09,
         ),
         (
          0.087155804,
          -0.99619478,
          -2.3299624e-09,
         ),
         (
          0.17364837,
          -0.98480773,
          -3.1066165e-09,
         ),
         (
          0.25881913,
          -0.96592581,
          -1.8639699e-09,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.3979773e-09,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533081e-09,
         ),
         (
          0.50000006,
          -0.86602545,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          -1.3979774e-09,
         ),
         (
          0.64278764,
          -0.76604444,
          -4.3492632e-09,
         ),
         (
          0.70710677,
          -0.70710677,
          -6.6792243e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -4.3492632e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          1.0873157e-09,
         ),
         (
          0.86602533,
          -0.50000012,
          -2.4852933e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          -1.3979773e-09,
         ),
         (
          0.93969274,
          -0.34201986,
          1.2426465e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          1.8639699e-09,
         ),
         (
          0.98480773,
          -0.17364839,
          -4.6599247e-10,
         ),
         (
          0.99619466,
          -0.087155804,
          -1.3979774e-09,
         ),
         (
          0.99904829,
          0.043619301,
          -6.2132333e-10,
         ),
         (
          0.99144489,
          0.13052627,
          -1.7086391e-09,
         ),
         (
          0.97629595,
          0.21643975,
          -2.7959546e-09,
         ),
         (
          0.95371693,
          0.30070585,
          -1.5533082e-10,
         ),
         (
          0.92387956,
          0.38268337,
          -1.5533081e-09,
         ),
         (
          0.88701075,
          0.46174884,
          -1.5533083e-10,
         ),
         (
          0.84339154,
          0.53729945,
          -1.3979773e-09,
         ),
         (
          0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          0.53729939,
          0.84339154,
          1.0873157e-09,
         ),
         (
          0.46174884,
          0.88701075,
          -2.6406242e-09,
         ),
         (
          0.38268337,
          0.92387956,
          1.0873157e-09,
         ),
         (
          0.30070585,
          0.95371693,
          2.4852931e-09,
         ),
         (
          0.21643975,
          0.97629595,
          2.4852931e-09,
         ),
         (
          0.13052627,
          0.99144489,
          3.1066166e-10,
         ),
         (
          0.043619301,
          0.99904829,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          0.99904817,
          -6.2132333e-10,
         ),
         (
          -0.13052627,
          0.99144489,
          -1.7086391e-09,
         ),
         (
          -0.21643975,
          0.97629595,
          -2.7959546e-09,
         ),
         (
          -0.30070585,
          0.95371693,
          -1.5533082e-10,
         ),
         (
          -0.38268337,
          0.92387956,
          -1.5533081e-09,
         ),
         (
          -0.46174884,
          0.88701075,
          -1.5533083e-10,
         ),
         (
          -0.53729945,
          0.84339154,
          -1.3979773e-09,
         ),
         (
          -0.60876131,
          0.7933535,
          1.2426467e-09,
         ),
         (
          -0.67559034,
          0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.73727721,
          0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.7933535,
          0.60876131,
          1.2426467e-09,
         ),
         (
          -0.84339154,
          0.53729939,
          1.0873157e-09,
         ),
         (
          -0.88701075,
          0.46174884,
          -2.6406242e-09,
         ),
         (
          -0.92387956,
          0.38268337,
          1.0873157e-09,
         ),
         (
          -0.95371693,
          0.30070585,
          2.4852931e-09,
         ),
         (
          -0.97629595,
          0.21643975,
          2.4852931e-09,
         ),
         (
          -0.99144489,
          0.13052627,
          3.1066166e-10,
         ),
         (
          -0.99904829,
          0.043619301,
          3.1066166e-10,
         ),
         (
          -0.99904817,
          -0.043619301,
          -6.2132333e-10,
         ),
         (
          -0.99144489,
          -0.13052627,
          -1.7086391e-09,
         ),
         (
          -0.97629595,
          -0.21643975,
          -2.7959546e-09,
         ),
         (
          -0.95371693,
          -0.30070585,
          -1.5533082e-10,
         ),
         (
          -0.92387956,
          -0.38268337,
          -1.5533081e-09,
         ),
         (
          -0.88701075,
          -0.46174884,
          -1.5533083e-10,
         ),
         (
          -0.84339154,
          -0.53729945,
          -1.3979773e-09,
         ),
         (
          -0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          -0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          -0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          -0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          -0.53729939,
          -0.84339154,
          1.0873157e-09,
         ),
         (
          -0.46174884,
          -0.88701075,
          -2.6406242e-09,
         ),
         (
          -0.38268337,
          -0.92387956,
          1.0873157e-09,
         ),
         (
          -0.30070585,
          -0.95371693,
          2.4852931e-09,
         ),
         (
          -0.21643975,
          -0.97629595,
          2.4852931e-09,
         ),
         (
          -0.13052627,
          -0.99144489,
          3.1066166e-10,
         ),
         (
          -0.043619301,
          -0.99904829,
          3.1066166e-10,
         ),
         (
          0.043619301,
          -0.99904817,
          -6.2132333e-10,
         ),
         (
          0.13052627,
          -0.99144489,
          -1.7086391e-09,
         ),
         (
          0.21643975,
          -0.97629595,
          -2.7959546e-09,
         ),
         (
          0.30070585,
          -0.95371693,
          -1.5533082e-10,
         ),
         (
          0.38268337,
          -0.92387956,
          -1.5533081e-09,
         ),
         (
          0.46174884,
          -0.88701075,
          -1.5533083e-10,
         ),
         (
          0.53729945,
          -0.84339154,
          -1.3979773e-09,
         ),
         (
          0.60876131,
          -0.7933535,
          1.2426467e-09,
         ),
         (
          0.67559034,
          -0.73727721,
          -2.4852933e-09,
         ),
         (
          0.73727721,
          -0.67559034,
          -2.4852933e-09,
         ),
         (
          0.7933535,
          -0.60876131,
          1.2426467e-09,
         ),
         (
          0.84339154,
          -0.53729939,
          1.0873157e-09,
         ),
         (
          0.88701075,
          -0.46174884,
          -2.6406242e-09,
         ),
         (
          0.92387956,
          -0.38268337,
          1.0873157e-09,
         ),
         (
          0.95371693,
          -0.30070585,
          2.4852931e-09,
         ),
         (
          0.97629595,
          -0.21643975,
          2.4852931e-09,
         ),
         (
          0.99144489,
          -0.13052627,
          3.1066166e-10,
         ),
         (
          0.99904829,
          -0.043619301,
          3.1066166e-10,
         ),
         (
          1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          0.99619466,
          0.087155797,
          -9.3198493e-10,
         ),
         (
          0.98480773,
          0.17364837,
          -1.7086391e-09,
         ),
         (
          0.96592581,
          0.25881916,
          -7.7665413e-10,
         ),
         (
          0.93969274,
          0.34201986,
          -1.5533082e-10,
         ),
         (
          0.9063077,
          0.42261836,
          -1.5533082e-10,
         ),
         (
          0.86602545,
          0.50000006,
          -1.2426467e-09,
         ),
         (
          0.81915218,
          0.57357633,
          0.0,
         ),
         (
          0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          0.70710677,
          0.70710683,
          -4.9705862e-09,
         ),
         (
          0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          0.57357633,
          0.81915212,
          2.4852931e-09,
         ),
         (
          0.50000006,
          0.86602539,
          -1.2426465e-09,
         ),
         (
          0.42261839,
          0.9063077,
          0.0,
         ),
         (
          0.34201992,
          0.93969274,
          2.4852933e-09,
         ),
         (
          0.25881913,
          0.96592581,
          3.1066163e-09,
         ),
         (
          0.17364837,
          0.98480773,
          9.3198493e-10,
         ),
         (
          0.087155797,
          0.99619466,
          0.0,
         ),
         (
          0.0,
          1.0,
          3.1066164e-10,
         ),
         (
          -0.087155797,
          0.99619466,
          -9.3198493e-10,
         ),
         (
          -0.17364837,
          0.98480773,
          -1.7086391e-09,
         ),
         (
          -0.25881916,
          0.96592581,
          -7.7665413e-10,
         ),
         (
          -0.34201986,
          0.93969274,
          -1.5533082e-10,
         ),
         (
          -0.42261836,
          0.9063077,
          -1.5533082e-10,
         ),
         (
          -0.50000006,
          0.86602545,
          -1.2426467e-09,
         ),
         (
          -0.57357633,
          0.81915218,
          0.0,
         ),
         (
          -0.64278764,
          0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.70710683,
          0.70710677,
          -4.9705862e-09,
         ),
         (
          -0.76604444,
          0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.81915212,
          0.57357633,
          2.4852931e-09,
         ),
         (
          -0.86602539,
          0.50000006,
          -1.2426465e-09,
         ),
         (
          -0.9063077,
          0.42261839,
          0.0,
         ),
         (
          -0.93969274,
          0.34201992,
          2.4852933e-09,
         ),
         (
          -0.96592581,
          0.25881913,
          3.1066163e-09,
         ),
         (
          -0.98480773,
          0.17364837,
          9.3198493e-10,
         ),
         (
          -0.99619466,
          0.087155797,
          0.0,
         ),
         (
          -1.0,
          0.0,
          3.1066164e-10,
         ),
         (
          -0.99619466,
          -0.087155797,
          -9.3198493e-10,
         ),
         (
          -0.98480773,
          -0.17364837,
          -1.7086391e-09,
         ),
         (
          -0.96592581,
          -0.25881916,
          -7.7665413e-10,
         ),
         (
          -0.93969274,
          -0.34201986,
          -1.5533082e-10,
         ),
         (
          -0.9063077,
          -0.42261836,
          -1.5533082e-10,
         ),
         (
          -0.86602545,
          -0.50000006,
          -1.2426467e-09,
         ),
         (
          -0.81915218,
          -0.57357633,
          0.0,
         ),
         (
          -0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          -0.70710677,
          -0.70710683,
          -4.9705862e-09,
         ),
         (
          -0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          -0.57357633,
          -0.81915212,
          2.4852931e-09,
         ),
         (
          -0.50000006,
          -0.86602539,
          -1.2426465e-09,
         ),
         (
          -0.42261839,
          -0.9063077,
          0.0,
         ),
         (
          -0.34201992,
          -0.93969274,
          2.4852933e-09,
         ),
         (
          -0.25881913,
          -0.96592581,
          3.1066163e-09,
         ),
         (
          -0.17364837,
          -0.98480773,
          9.3198493e-10,
         ),
         (
          -0.087155797,
          -0.99619466,
          0.0,
         ),
         (
          0.0,
          -1.0,
          3.1066164e-10,
         ),
         (
          0.087155797,
          -0.99619466,
          -9.3198493e-10,
         ),
         (
          0.17364837,
          -0.98480773,
          -1.7086391e-09,
         ),
         (
          0.25881916,
          -0.96592581,
          -7.7665413e-10,
         ),
         (
          0.34201986,
          -0.93969274,
          -1.5533082e-10,
         ),
         (
          0.42261836,
          -0.9063077,
          -1.5533082e-10,
         ),
         (
          0.50000006,
          -0.86602545,
          -1.2426467e-09,
         ),
         (
          0.57357633,
          -0.81915218,
          0.0,
         ),
         (
          0.64278764,
          -0.76604444,
          -2.4852933e-09,
         ),
         (
          0.70710683,
          -0.70710677,
          -4.9705862e-09,
         ),
         (
          0.76604444,
          -0.64278764,
          -2.4852933e-09,
         ),
         (
          0.81915212,
          -0.57357633,
          2.4852931e-09,
         ),
         (
          0.86602539,
          -0.50000006,
          -1.2426465e-09,
         ),
         (
          0.9063077,
          -0.42261839,
          0.0,
         ),
         (
          0.93969274,
          -0.34201992,
          2.4852933e-09,
         ),
         (
          0.96592581,
          -0.25881913,
          3.1066163e-09,
         ),
         (
          0.98480773,
          -0.17364837,
          9.3198493e-10,
         ),
         (
          0.99619466,
          -0.087155797,
          0.0,
         ),
         (
          0.82949585,
          0.036216497,
          0.5573374,
         ),
         (
          0.82318282,
          0.10837414,
          0.5573374,
         ),
         (
          0.81060517,
          0.17970698,
          0.55733699,
         ),
         (
          0.79185808,
          0.24967194,
          0.55733716,
         ),
         (
          0.76708418,
          0.31773663,
          0.55733776,
         ),
         (
          0.73647255,
          0.38338354,
          0.5573377,
         ),
         (
          0.70025635,
          0.44611236,
          0.55733728,
         ),
         (
          0.65871024,
          0.50544602,
          0.55733752,
         ),
         (
          0.61215103,
          0.56093329,
          0.5573374,
         ),
         (
          0.56093329,
          0.61215103,
          0.5573374,
         ),
         (
          0.50544602,
          0.65871024,
          0.55733752,
         ),
         (
          0.44611236,
          0.70025635,
          0.55733728,
         ),
         (
          0.38338354,
          0.73647255,
          0.5573377,
         ),
         (
          0.3177366,
          0.76708418,
          0.5573377,
         ),
         (
          0.24967194,
          0.79185808,
          0.55733716,
         ),
         (
          0.17970698,
          0.81060517,
          0.55733699,
         ),
         (
          0.10837415,
          0.82318282,
          0.5573374,
         ),
         (
          0.036216497,
          0.82949585,
          0.5573374,
         ),
         (
          -0.036216497,
          0.82949585,
          0.5573374,
         ),
         (
          -0.10837414,
          0.82318282,
          0.5573374,
         ),
         (
          -0.17970698,
          0.81060517,
          0.55733699,
         ),
         (
          -0.24967194,
          0.79185808,
          0.55733716,
         ),
         (
          -0.31773663,
          0.76708418,
          0.55733776,
         ),
         (
          -0.38338354,
          0.73647255,
          0.5573377,
         ),
         (
          -0.44611236,
          0.70025635,
          0.55733728,
         ),
         (
          -0.50544602,
          0.65871024,
          0.55733752,
         ),
         (
          -0.56093329,
          0.61215103,
          0.5573374,
         ),
         (
          -0.61215103,
          0.56093329,
          0.5573374,
         ),
         (
          -0.65871024,
          0.50544602,
          0.55733752,
         ),
         (
          -0.70025635,
          0.44611236,
          0.55733728,
         ),
         (
          -0.73647255,
          0.38338354,
          0.5573377,
         ),
         (
          -0.76708418,
          0.3177366,
          0.5573377,
         ),
         (
          -0.79185808,
          0.24967194,
          0.55733716,
         ),
         (
          -0.81060517,
          0.17970698,
          0.55733699,
         ),
         (
          -0.82318282,
          0.10837415,
          0.5573374,
         ),
         (
          -0.82949585,
          0.036216497,
          0.5573374,
         ),
         (
          -0.82949585,
          -0.036216497,
          0.5573374,
         ),
         (
          -0.82318282,
          -0.10837414,
          0.5573374,
         ),
         (
          -0.81060517,
          -0.17970698,
          0.55733699,
         ),
         (
          -0.79185808,
          -0.24967194,
          0.55733716,
         ),
         (
          -0.76708418,
          -0.31773663,
          0.55733776,
         ),
         (
          -0.73647255,
          -0.38338354,
          0.5573377,
         ),
         (
          -0.70025635,
          -0.44611236,
          0.55733728,
         ),
         (
          -0.65871024,
          -0.50544602,
          0.55733752,
         ),
         (
          -0.61215103,
          -0.56093329,
          0.5573374,
         ),
         (
          -0.56093329,
          -0.61215103,
          0.5573374,
         ),
         (
          -0.50544602,
          -0.65871024,
          0.55733752,
         ),
         (
          -0.44611236,
          -0.70025635,
          0.55733728,
         ),
         (
          -0.38338354,
          -0.73647255,
          0.5573377,
         ),
         (
          -0.3177366,
          -0.76708418,
          0.5573377,
         ),
         (
          -0.24967194,
          -0.79185808,
          0.55733716,
         ),
         (
          -0.17970698,
          -0.81060517,
          0.55733699,
         ),
         (
          -0.10837415,
          -0.82318282,
          0.5573374,
         ),
         (
          -0.036216497,
          -0.82949585,
          0.5573374,
         ),
         (
          0.036216497,
          -0.82949585,
          0.5573374,
         ),
         (
          0.10837414,
          -0.82318282,
          0.5573374,
         ),
         (
          0.17970698,
          -0.81060517,
          0.55733699,
         ),
         (
          0.24967194,
          -0.79185808,
          0.55733716,
         ),
         (
          0.31773663,
          -0.76708418,
          0.55733776,
         ),
         (
          0.38338354,
          -0.73647255,
          0.5573377,
         ),
         (
          0.44611236,
          -0.70025635,
          0.55733728,
         ),
         (
          0.50544602,
          -0.65871024,
          0.55733752,
         ),
         (
          0.56093329,
          -0.61215103,
          0.5573374,
         ),
         (
          0.61215103,
          -0.56093329,
          0.5573374,
         ),
         (
          0.65871024,
          -0.50544602,
          0.55733752,
         ),
         (
          0.70025635,
          -0.44611236,
          0.55733728,
         ),
         (
          0.73647255,
          -0.38338354,
          0.5573377,
         ),
         (
          0.76708418,
          -0.3177366,
          0.5573377,
         ),
         (
          0.79185808,
          -0.24967194,
          0.55733716,
         ),
         (
          0.81060517,
          -0.17970698,
          0.55733699,
         ),
         (
          0.82318282,
          -0.10837415,
          0.5573374,
         ),
         (
          0.82949585,
          -0.036216497,
          0.5573374,
         ),
         (
          0.0,
          0.0,
          -1.0,
         ),
         (
          0.0,
          0.0,
          1.0,
         ),
        ],
       'per_vertex_colors': None,
       'smoothLines': False,
       'transparencyBlendMode': 1,
       'triangle_and_edge_mask': None,
       'triangles': [
         ( 0, 1, 72, ),
         ( 1, 73, 72, ),
         ( 1, 2, 73, ),
         ( 2, 74, 73, ),
         ( 2, 3, 74, ),
         ( 3, 75, 74, ),
         ( 3, 4, 75, ),
         ( 4, 76, 75, ),
         ( 4, 5, 76, ),
         ( 5, 77, 76, ),
         ( 5, 6, 77, ),
         ( 6, 78, 77, ),
         ( 6, 7, 78, ),
         ( 7, 79, 78, ),
         ( 7, 8, 79, ),
         ( 8, 80, 79, ),
         ( 8, 9, 80, ),
         ( 9, 81, 80, ),
         ( 9, 10, 81, ),
         ( 10, 82, 81, ),
         ( 10, 11, 82, ),
         ( 11, 83, 82, ),
         ( 11, 12, 83, ),
         ( 12, 84, 83, ),
         ( 12, 13, 84, ),
         ( 13, 85, 84, ),
         ( 13, 14, 85, ),
         ( 14, 86, 85, ),
         ( 14, 15, 86, ),
         ( 15, 87, 86, ),
         ( 15, 16, 87, ),
         ( 16, 88, 87, ),
         ( 16, 17, 88, ),
         ( 17, 89, 88, ),
         ( 17, 18, 89, ),
         ( 18, 90, 89, ),
         ( 18, 19, 90, ),
         ( 19, 91, 90, ),
         ( 19, 20, 91, ),
         ( 20, 92, 91, ),
         ( 20, 21, 92, ),
         ( 21, 93, 92, ),
         ( 21, 22, 93, ),
         ( 22, 94, 93, ),
         ( 22, 23, 94, ),
         ( 23, 95, 94, ),
         ( 23, 24, 95, ),
         ( 24, 96, 95, ),
         ( 24, 25, 96, ),
         ( 25, 97, 96, ),
         ( 25, 26, 97, ),
         ( 26, 98, 97, ),
         ( 26, 27, 98, ),
         ( 27, 99, 98, ),
         ( 27, 28, 99, ),
         ( 28, 100, 99, ),
         ( 28, 29, 100, ),
         ( 29, 101, 100, ),
         ( 29, 30, 101, ),
         ( 30, 102, 101, ),
         ( 30, 31, 102, ),
         ( 31, 103, 102, ),
         ( 31, 32, 103, ),
         ( 32, 104, 103, ),
         ( 32, 33, 104, ),
         ( 33, 105, 104, ),
         ( 33, 34, 105, ),
         ( 34, 106, 105, ),
         ( 34, 35, 106, ),
         ( 35, 107, 106, ),
         ( 35, 36, 107, ),
         ( 36, 108, 107, ),
         ( 36, 37, 108, ),
         ( 37, 109, 108, ),
         ( 37, 38, 109, ),
         ( 38, 110, 109, ),
         ( 38, 39, 110, ),
         ( 39, 111, 110, ),
         ( 39, 40, 111, ),
         ( 40, 112, 111, ),
         ( 40, 41, 112, ),
         ( 41, 113, 112, ),
         ( 41, 42, 113, ),
         ( 42, 114, 113, ),
         ( 42, 43, 114, ),
         ( 43, 115, 114, ),
         ( 43, 44, 115, ),
         ( 44, 116, 115, ),
         ( 44, 45, 116, ),
         ( 45, 117, 116, ),
         ( 45, 46, 117, ),
         ( 46, 118, 117, ),
         ( 46, 47, 118, ),
         ( 47, 119, 118, ),
         ( 47, 48, 119, ),
         ( 48, 120, 119, ),
         ( 48, 49, 120, ),
         ( 49, 121, 120, ),
         ( 49, 50, 121, ),
         ( 50, 122, 121, ),
         ( 50, 51, 122, ),
         ( 51, 123, 122, ),
         ( 51, 52, 123, ),
         ( 52, 124, 123, ),
         ( 52, 53, 124, ),
         ( 53, 125, 124, ),
         ( 53, 54, 125, ),
         ( 54, 126, 125, ),
         ( 54, 55, 126, ),
         ( 55, 127, 126, ),
         ( 55, 56, 127, ),
         ( 56, 128, 127, ),
         ( 56, 57, 128, ),
         ( 57, 129, 128, ),
         ( 57, 58, 129, ),
         ( 58, 130, 129, ),
         ( 58, 59, 130, ),
         ( 59, 131, 130, ),
         ( 59, 60, 131, ),
         ( 60, 132, 131, ),
         ( 60, 61, 132, ),
         ( 61, 133, 132, ),
         ( 61, 62, 133, ),
         ( 62, 134, 133, ),
         ( 62, 63, 134, ),
         ( 63, 135, 134, ),
         ( 63, 64, 135, ),
         ( 64, 136, 135, ),
         ( 64, 65, 136, ),
         ( 65, 137, 136, ),
         ( 65, 66, 137, ),
         ( 66, 138, 137, ),
         ( 66, 67, 138, ),
         ( 67, 139, 138, ),
         ( 67, 68, 139, ),
         ( 68, 140, 139, ),
         ( 68, 69, 140, ),
         ( 69, 141, 140, ),
         ( 69, 70, 141, ),
         ( 70, 142, 141, ),
         ( 70, 71, 142, ),
         ( 71, 143, 142, ),
         ( 71, 0, 143, ),
         ( 0, 72, 143, ),
         ( 72, 73, 145, ),
         ( 72, 145, 144, ),
         ( 73, 74, 146, ),
         ( 73, 146, 145, ),
         ( 74, 75, 147, ),
         ( 74, 147, 146, ),
         ( 75, 76, 148, ),
         ( 75, 148, 147, ),
         ( 76, 77, 149, ),
         ( 76, 149, 148, ),
         ( 77, 78, 150, ),
         ( 77, 150, 149, ),
         ( 78, 79, 151, ),
         ( 78, 151, 150, ),
         ( 79, 80, 152, ),
         ( 79, 152, 151, ),
         ( 80, 81, 153, ),
         ( 80, 153, 152, ),
         ( 81, 82, 154, ),
         ( 81, 154, 153, ),
         ( 82, 83, 155, ),
         ( 82, 155, 154, ),
         ( 83, 84, 156, ),
         ( 83, 156, 155, ),
         ( 84, 85, 157, ),
         ( 84, 157, 156, ),
         ( 85, 86, 158, ),
         ( 85, 158, 157, ),
         ( 86, 87, 159, ),
         ( 86, 159, 158, ),
         ( 87, 88, 160, ),
         ( 87, 160, 159, ),
         ( 88, 89, 161, ),
         ( 88, 161, 160, ),
         ( 89, 90, 162, ),
         ( 89, 162, 161, ),
         ( 90, 91, 163, ),
         ( 90, 163, 162, ),
         ( 91, 92, 164, ),
         ( 91, 164, 163, ),
         ( 92, 93, 165, ),
         ( 92, 165, 164, ),
         ( 93, 94, 166, ),
         ( 93, 166, 165, ),
         ( 94, 95, 167, ),
         ( 94, 167, 166, ),
         ( 95, 96, 168, ),
         ( 95, 168, 167, ),
         ( 96, 97, 169, ),
         ( 96, 169, 168, ),
         ( 97, 98, 170, ),
         ( 97, 170, 169, ),
         ( 98, 99, 171, ),
         ( 98, 171, 170, ),
         ( 99, 100, 172, ),
         ( 99, 172, 171, ),
         ( 100, 101, 173, ),
         ( 100, 173, 172, ),
         ( 101, 102, 174, ),
         ( 101, 174, 173, ),
         ( 102, 103, 175, ),
         ( 102, 175, 174, ),
         ( 103, 104, 176, ),
         ( 103, 176, 175, ),
         ( 104, 105, 177, ),
         ( 104, 177, 176, ),
         ( 105, 106, 178, ),
         ( 105, 178, 177, ),
         ( 106, 107, 179, ),
         ( 106, 179, 178, ),
         ( 107, 108, 180, ),
         ( 107, 180, 179, ),
         ( 108, 109, 181, ),
         ( 108, 181, 180, ),
         ( 109, 110, 182, ),
         ( 109, 182, 181, ),
         ( 110, 111, 183, ),
         ( 110, 183, 182, ),
         ( 111, 112, 184, ),
         ( 111, 184, 183, ),
         ( 112, 113, 185, ),
         ( 112, 185, 184, ),
         ( 113, 114, 186, ),
         ( 113, 186, 185, ),
         ( 114, 115, 187, ),
         ( 114, 187, 186, ),
         ( 115, 116, 188, ),
         ( 115, 188, 187, ),
         ( 116, 117, 189, ),
         ( 116, 189, 188, ),
         ( 117, 118, 190, ),
         ( 117, 190, 189, ),
         ( 118, 119, 191, ),
         ( 118, 191, 190, ),
         ( 119, 120, 192, ),
         ( 119, 192, 191, ),
         ( 120, 121, 193, ),
         ( 120, 193, 192, ),
         ( 121, 122, 194, ),
         ( 121, 194, 193, ),
         ( 122, 123, 195, ),
         ( 122, 195, 194, ),
         ( 123, 124, 196, ),
         ( 123, 196, 195, ),
         ( 124, 125, 197, ),
         ( 124, 197, 196, ),
         ( 125, 126, 198, ),
         ( 125, 198, 197, ),
         ( 126, 127, 199, ),
         ( 126, 199, 198, ),
         ( 127, 128, 200, ),
         ( 127, 200, 199, ),
         ( 128, 129, 201, ),
         ( 128, 201, 200, ),
         ( 129, 130, 202, ),
         ( 129, 202, 201, ),
         ( 130, 131, 203, ),
         ( 130, 203, 202, ),
         ( 131, 132, 204, ),
         ( 131, 204, 203, ),
         ( 132, 133, 205, ),
         ( 132, 205, 204, ),
         ( 133, 134, 206, ),
         ( 133, 206, 205, ),
         ( 134, 135, 207, ),
         ( 134, 207, 206, ),
         ( 135, 136, 208, ),
         ( 135, 208, 207, ),
         ( 136, 137, 209, ),
         ( 136, 209, 208, ),
         ( 137, 138, 210, ),
         ( 137, 210, 209, ),
         ( 138, 139, 211, ),
         ( 138, 211, 210, ),
         ( 139, 140, 212, ),
         ( 139, 212, 211, ),
         ( 140, 141, 213, ),
         ( 140, 213, 212, ),
         ( 141, 142, 214, ),
         ( 141, 214, 213, ),
         ( 142, 143, 215, ),
         ( 142, 215, 214, ),
         ( 143, 72, 144, ),
         ( 143, 144, 215, ),
         ( 144, 145, 216, ),
         ( 145, 217, 216, ),
         ( 145, 146, 217, ),
         ( 146, 218, 217, ),
         ( 146, 147, 218, ),
         ( 147, 219, 218, ),
         ( 147, 148, 219, ),
         ( 148, 220, 219, ),
         ( 148, 149, 220, ),
         ( 149, 221, 220, ),
         ( 149, 150, 221, ),
         ( 150, 222, 221, ),
         ( 150, 151, 222, ),
         ( 151, 223, 222, ),
         ( 151, 152, 223, ),
         ( 152, 224, 223, ),
         ( 152, 153, 224, ),
         ( 153, 225, 224, ),
         ( 153, 154, 225, ),
         ( 154, 226, 225, ),
         ( 154, 155, 226, ),
         ( 155, 227, 226, ),
         ( 155, 156, 227, ),
         ( 156, 228, 227, ),
         ( 156, 157, 228, ),
         ( 157, 229, 228, ),
         ( 157, 158, 229, ),
         ( 158, 230, 229, ),
         ( 158, 159, 230, ),
         ( 159, 231, 230, ),
         ( 159, 160, 231, ),
         ( 160, 232, 231, ),
         ( 160, 161, 232, ),
         ( 161, 233, 232, ),
         ( 161, 162, 233, ),
         ( 162, 234, 233, ),
         ( 162, 163, 234, ),
         ( 163, 235, 234, ),
         ( 163, 164, 235, ),
         ( 164, 236, 235, ),
         ( 164, 165, 236, ),
         ( 165, 237, 236, ),
         ( 165, 166, 237, ),
         ( 166, 238, 237, ),
         ( 166, 167, 238, ),
         ( 167, 239, 238, ),
         ( 167, 168, 239, ),
         ( 168, 240, 239, ),
         ( 168, 169, 240, ),
         ( 169, 241, 240, ),
         ( 169, 170, 241, ),
         ( 170, 242, 241, ),
         ( 170, 171, 242, ),
         ( 171, 243, 242, ),
         ( 171, 172, 243, ),
         ( 172, 244, 243, ),
         ( 172, 173, 244, ),
         ( 173, 245, 244, ),
         ( 173, 174, 245, ),
         ( 174, 246, 245, ),
         ( 174, 175, 246, ),
         ( 175, 247, 246, ),
         ( 175, 176, 247, ),
         ( 176, 248, 247, ),
         ( 176, 177, 248, ),
         ( 177, 249, 248, ),
         ( 177, 178, 249, ),
         ( 178, 250, 249, ),
         ( 178, 179, 250, ),
         ( 179, 251, 250, ),
         ( 179, 180, 251, ),
         ( 180, 252, 251, ),
         ( 180, 181, 252, ),
         ( 181, 253, 252, ),
         ( 181, 182, 253, ),
         ( 182, 254, 253, ),
         ( 182, 183, 254, ),
         ( 183, 255, 254, ),
         ( 183, 184, 255, ),
         ( 184, 256, 255, ),
         ( 184, 185, 256, ),
         ( 185, 257, 256, ),
         ( 185, 186, 257, ),
         ( 186, 258, 257, ),
         ( 186, 187, 258, ),
         ( 187, 259, 258, ),
         ( 187, 188, 259, ),
         ( 188, 260, 259, ),
         ( 188, 189, 260, ),
         ( 189, 261, 260, ),
         ( 189, 190, 261, ),
         ( 190, 262, 261, ),
         ( 190, 191, 262, ),
         ( 191, 263, 262, ),
         ( 191, 192, 263, ),
         ( 192, 264, 263, ),
         ( 192, 193, 264, ),
         ( 193, 265, 264, ),
         ( 193, 194, 265, ),
         ( 194, 266, 265, ),
         ( 194, 195, 266, ),
         ( 195, 267, 266, ),
         ( 195, 196, 267, ),
         ( 196, 268, 267, ),
         ( 196, 197, 268, ),
         ( 197, 269, 268, ),
         ( 197, 198, 269, ),
         ( 198, 270, 269, ),
         ( 198, 199, 270, ),
         ( 199, 271, 270, ),
         ( 199, 200, 271, ),
         ( 200, 272, 271, ),
         ( 200, 201, 272, ),
         ( 201, 273, 272, ),
         ( 201, 202, 273, ),
         ( 202, 274, 273, ),
         ( 202, 203, 274, ),
         ( 203, 275, 274, ),
         ( 203, 204, 275, ),
         ( 204, 276, 275, ),
         ( 204, 205, 276, ),
         ( 205, 277, 276, ),
         ( 205, 206, 277, ),
         ( 206, 278, 277, ),
         ( 206, 207, 278, ),
         ( 207, 279, 278, ),
         ( 207, 208, 279, ),
         ( 208, 280, 279, ),
         ( 208, 209, 280, ),
         ( 209, 281, 280, ),
         ( 209, 210, 281, ),
         ( 210, 282, 281, ),
         ( 210, 211, 282, ),
         ( 211, 283, 282, ),
         ( 211, 212, 283, ),
         ( 212, 284, 283, ),
         ( 212, 213, 284, ),
         ( 213, 285, 284, ),
         ( 213, 214, 285, ),
         ( 214, 286, 285, ),
         ( 214, 215, 286, ),
         ( 215, 287, 286, ),
         ( 215, 144, 287, ),
         ( 144, 216, 287, ),
         ( 216, 217, 289, ),
         ( 216, 289, 288, ),
         ( 217, 218, 290, ),
         ( 217, 290, 289, ),
         ( 218, 219, 291, ),
         ( 218, 291, 290, ),
         ( 219, 220, 292, ),
         ( 219, 292, 291, ),
         ( 220, 221, 293, ),
         ( 220, 293, 292, ),
         ( 221, 222, 294, ),
         ( 221, 294, 293, ),
         ( 222, 223, 295, ),
         ( 222, 295, 294, ),
         ( 223, 224, 296, ),
         ( 223, 296, 295, ),
         ( 224, 225, 297, ),
         ( 224, 297, 296, ),
         ( 225, 226, 298, ),
         ( 225, 298, 297, ),
         ( 226, 227, 299, ),
         ( 226, 299, 298, ),
         ( 227, 228, 300, ),
         ( 227, 300, 299, ),
         ( 228, 229, 301, ),
         ( 228, 301, 300, ),
         ( 229, 230, 302, ),
         ( 229, 302, 301, ),
         ( 230, 231, 303, ),
         ( 230, 303, 302, ),
         ( 231, 232, 304, ),
         ( 231, 304, 303, ),
         ( 232, 233, 305, ),
         ( 232, 305, 304, ),
         ( 233, 234, 306, ),
         ( 233, 306, 305, ),
         ( 234, 235, 307, ),
         ( 234, 307, 306, ),
         ( 235, 236, 308, ),
         ( 235, 308, 307, ),
         ( 236, 237, 309, ),
         ( 236, 309, 308, ),
         ( 237, 238, 310, ),
         ( 237, 310, 309, ),
         ( 238, 239, 311, ),
         ( 238, 311, 310, ),
         ( 239, 240, 312, ),
         ( 239, 312, 311, ),
         ( 240, 241, 313, ),
         ( 240, 313, 312, ),
         ( 241, 242, 314, ),
         ( 241, 314, 313, ),
         ( 242, 243, 315, ),
         ( 242, 315, 314, ),
         ( 243, 244, 316, ),
         ( 243, 316, 315, ),
         ( 244, 245, 317, ),
         ( 244, 317, 316, ),
         ( 245, 246, 318, ),
         ( 245, 318, 317, ),
         ( 246, 247, 319, ),
         ( 246, 319, 318, ),
         ( 247, 248, 320, ),
         ( 247, 320, 319, ),
         ( 248, 249, 321, ),
         ( 248, 321, 320, ),
         ( 249, 250, 322, ),
         ( 249, 322, 321, ),
         ( 250, 251, 323, ),
         ( 250, 323, 322, ),
         ( 251, 252, 324, ),
         ( 251, 324, 323, ),
         ( 252, 253, 325, ),
         ( 252, 325, 324, ),
         ( 253, 254, 326, ),
         ( 253, 326, 325, ),
         ( 254, 255, 327, ),
         ( 254, 327, 326, ),
         ( 255, 256, 328, ),
         ( 255, 328, 327, ),
         ( 256, 257, 329, ),
         ( 256, 329, 328, ),
         ( 257, 258, 330, ),
         ( 257, 330, 329, ),
         ( 258, 259, 331, ),
         ( 258, 331, 330, ),
         ( 259, 260, 332, ),
         ( 259, 332, 331, ),
         ( 260, 261, 333, ),
         ( 260, 333, 332, ),
         ( 261, 262, 334, ),
         ( 261, 334, 333, ),
         ( 262, 263, 335, ),
         ( 262, 335, 334, ),
         ( 263, 264, 336, ),
         ( 263, 336, 335, ),
         ( 264, 265, 337, ),
         ( 264, 337, 336, ),
         ( 265, 266, 338, ),
         ( 265, 338, 337, ),
         ( 266, 267, 339, ),
         ( 266, 339, 338, ),
         ( 267, 268, 340, ),
         ( 267, 340, 339, ),
         ( 268, 269, 341, ),
         ( 268, 341, 340, ),
         ( 269, 270, 342, ),
         ( 269, 342, 341, ),
         ( 270, 271, 343, ),
         ( 270, 343, 342, ),
         ( 271, 272, 344, ),
         ( 271, 344, 343, ),
         ( 272, 273, 345, ),
         ( 272, 345, 344, ),
         ( 273, 274, 346, ),
         ( 273, 346, 345, ),
         ( 274, 275, 347, ),
         ( 274, 347, 346, ),
         ( 275, 276, 348, ),
         ( 275, 348, 347, ),
         ( 276, 277, 349, ),
         ( 276, 349, 348, ),
         ( 277, 278, 350, ),
         ( 277, 350, 349, ),
         ( 278, 279, 351, ),
         ( 278, 351, 350, ),
         ( 279, 280, 352, ),
         ( 279, 352, 351, ),
         ( 280, 281, 353, ),
         ( 280, 353, 352, ),
         ( 281, 282, 354, ),
         ( 281, 354, 353, ),
         ( 282, 283, 355, ),
         ( 282, 355, 354, ),
         ( 283, 284, 356, ),
         ( 283, 356, 355, ),
         ( 284, 285, 357, ),
         ( 284, 357, 356, ),
         ( 285, 286, 358, ),
         ( 285, 358, 357, ),
         ( 286, 287, 359, ),
         ( 286, 359, 358, ),
         ( 287, 216, 288, ),
         ( 287, 288, 359, ),
         ( 288, 289, 360, ),
         ( 289, 361, 360, ),
         ( 289, 290, 361, ),
         ( 290, 362, 361, ),
         ( 290, 291, 362, ),
         ( 291, 363, 362, ),
         ( 291, 292, 363, ),
         ( 292, 364, 363, ),
         ( 292, 293, 364, ),
         ( 293, 365, 364, ),
         ( 293, 294, 365, ),
         ( 294, 366, 365, ),
         ( 294, 295, 366, ),
         ( 295, 367, 366, ),
         ( 295, 296, 367, ),
         ( 296, 368, 367, ),
         ( 296, 297, 368, ),
         ( 297, 369, 368, ),
         ( 297, 298, 369, ),
         ( 298, 370, 369, ),
         ( 298, 299, 370, ),
         ( 299, 371, 370, ),
         ( 299, 300, 371, ),
         ( 300, 372, 371, ),
         ( 300, 301, 372, ),
         ( 301, 373, 372, ),
         ( 301, 302, 373, ),
         ( 302, 374, 373, ),
         ( 302, 303, 374, ),
         ( 303, 375, 374, ),
         ( 303, 304, 375, ),
         ( 304, 376, 375, ),
         ( 304, 305, 376, ),
         ( 305, 377, 376, ),
         ( 305, 306, 377, ),
         ( 306, 378, 377, ),
         ( 306, 307, 378, ),
         ( 307, 379, 378, ),
         ( 307, 308, 379, ),
         ( 308, 380, 379, ),
         ( 308, 309, 380, ),
         ( 309, 381, 380, ),
         ( 309, 310, 381, ),
         ( 310, 382, 381, ),
         ( 310, 311, 382, ),
         ( 311, 383, 382, ),
         ( 311, 312, 383, ),
         ( 312, 384, 383, ),
         ( 312, 313, 384, ),
         ( 313, 385, 384, ),
         ( 313, 314, 385, ),
         ( 314, 386, 385, ),
         ( 314, 315, 386, ),
         ( 315, 387, 386, ),
         ( 315, 316, 387, ),
         ( 316, 388, 387, ),
         ( 316, 317, 388, ),
         ( 317, 389, 388, ),
         ( 317, 318, 389, ),
         ( 318, 390, 389, ),
         ( 318, 319, 390, ),
         ( 319, 391, 390, ),
         ( 319, 320, 391, ),
         ( 320, 392, 391, ),
         ( 320, 321, 392, ),
         ( 321, 393, 392, ),
         ( 321, 322, 393, ),
         ( 322, 394, 393, ),
         ( 322, 323, 394, ),
         ( 323, 395, 394, ),
         ( 323, 324, 395, ),
         ( 324, 396, 395, ),
         ( 324, 325, 396, ),
         ( 325, 397, 396, ),
         ( 325, 326, 397, ),
         ( 326, 398, 397, ),
         ( 326, 327, 398, ),
         ( 327, 399, 398, ),
         ( 327, 328, 399, ),
         ( 328, 400, 399, ),
         ( 328, 329, 400, ),
         ( 329, 401, 400, ),
         ( 329, 330, 401, ),
         ( 330, 402, 401, ),
         ( 330, 331, 402, ),
         ( 331, 403, 402, ),
         ( 331, 332, 403, ),
         ( 332, 404, 403, ),
         ( 332, 333, 404, ),
         ( 333, 405, 404, ),
         ( 333, 334, 405, ),
         ( 334, 406, 405, ),
         ( 334, 335, 406, ),
         ( 335, 407, 406, ),
         ( 335, 336, 407, ),
         ( 336, 408, 407, ),
         ( 336, 337, 408, ),
         ( 337, 409, 408, ),
         ( 337, 338, 409, ),
         ( 338, 410, 409, ),
         ( 338, 339, 410, ),
         ( 339, 411, 410, ),
         ( 339, 340, 411, ),
         ( 340, 412, 411, ),
         ( 340, 341, 412, ),
         ( 341, 413, 412, ),
         ( 341, 342, 413, ),
         ( 342, 414, 413, ),
         ( 342, 343, 414, ),
         ( 343, 415, 414, ),
         ( 343, 344, 415, ),
         ( 344, 416, 415, ),
         ( 344, 345, 416, ),
         ( 345, 417, 416, ),
         ( 345, 346, 417, ),
         ( 346, 418, 417, ),
         ( 346, 347, 418, ),
         ( 347, 419, 418, ),
         ( 347, 348, 419, ),
         ( 348, 420, 419, ),
         ( 348, 349, 420, ),
         ( 349, 421, 420, ),
         ( 349, 350, 421, ),
         ( 350, 422, 421, ),
         ( 350, 351, 422, ),
         ( 351, 423, 422, ),
         ( 351, 352, 423, ),
         ( 352, 424, 423, ),
         ( 352, 353, 424, ),
         ( 353, 425, 424, ),
         ( 353, 354, 425, ),
         ( 354, 426, 425, ),
         ( 354, 355, 426, ),
         ( 355, 427, 426, ),
         ( 355, 356, 427, ),
         ( 356, 428, 427, ),
         ( 356, 357, 428, ),
         ( 357, 429, 428, ),
         ( 357, 358, 429, ),
         ( 358, 430, 429, ),
         ( 358, 359, 430, ),
         ( 359, 431, 430, ),
         ( 359, 288, 431, ),
         ( 288, 360, 431, ),
         ( 360, 361, 433, ),
         ( 360, 433, 432, ),
         ( 361, 362, 434, ),
         ( 361, 434, 433, ),
         ( 362, 363, 435, ),
         ( 362, 435, 434, ),
         ( 363, 364, 436, ),
         ( 363, 436, 435, ),
         ( 364, 365, 437, ),
         ( 364, 437, 436, ),
         ( 365, 366, 438, ),
         ( 365, 438, 437, ),
         ( 366, 367, 439, ),
         ( 366, 439, 438, ),
         ( 367, 368, 440, ),
         ( 367, 440, 439, ),
         ( 368, 369, 441, ),
         ( 368, 441, 440, ),
         ( 369, 370, 442, ),
         ( 369, 442, 441, ),
         ( 370, 371, 443, ),
         ( 370, 443, 442, ),
         ( 371, 372, 444, ),
         ( 371, 444, 443, ),
         ( 372, 373, 445, ),
         ( 372, 445, 444, ),
         ( 373, 374, 446, ),
         ( 373, 446, 445, ),
         ( 374, 375, 447, ),
         ( 374, 447, 446, ),
         ( 375, 376, 448, ),
         ( 375, 448, 447, ),
         ( 376, 377, 449, ),
         ( 376, 449, 448, ),
         ( 377, 378, 450, ),
         ( 377, 450, 449, ),
         ( 378, 379, 451, ),
         ( 378, 451, 450, ),
         ( 379, 380, 452, ),
         ( 379, 452, 451, ),
         ( 380, 381, 453, ),
         ( 380, 453, 452, ),
         ( 381, 382, 454, ),
         ( 381, 454, 453, ),
         ( 382, 383, 455, ),
         ( 382, 455, 454, ),
         ( 383, 384, 456, ),
         ( 383, 456, 455, ),
         ( 384, 385, 457, ),
         ( 384, 457, 456, ),
         ( 385, 386, 458, ),
         ( 385, 458, 457, ),
         ( 386, 387, 459, ),
         ( 386, 459, 458, ),
         ( 387, 388, 460, ),
         ( 387, 460, 459, ),
         ( 388, 389, 461, ),
         ( 388, 461, 460, ),
         ( 389, 390, 462, ),
         ( 389, 462, 461, ),
         ( 390, 391, 463, ),
         ( 390, 463, 462, ),
         ( 391, 392, 464, ),
         ( 391, 464, 463, ),
         ( 392, 393, 465, ),
         ( 392, 465, 464, ),
         ( 393, 394, 466, ),
         ( 393, 466, 465, ),
         ( 394, 395, 467, ),
         ( 394, 467, 466, ),
         ( 395, 396, 468, ),
         ( 395, 468, 467, ),
         ( 396, 397, 469, ),
         ( 396, 469, 468, ),
         ( 397, 398, 470, ),
         ( 397, 470, 469, ),
         ( 398, 399, 471, ),
         ( 398, 471, 470, ),
         ( 399, 400, 472, ),
         ( 399, 472, 471, ),
         ( 400, 401, 473, ),
         ( 400, 473, 472, ),
         ( 401, 402, 474, ),
         ( 401, 474, 473, ),
         ( 402, 403, 475, ),
         ( 402, 475, 474, ),
         ( 403, 404, 476, ),
         ( 403, 476, 475, ),
         ( 404, 405, 477, ),
         ( 404, 477, 476, ),
         ( 405, 406, 478, ),
         ( 405, 478, 477, ),
         ( 406, 407, 479, ),
         ( 406, 479, 478, ),
         ( 407, 408, 480, ),
         ( 407, 480, 479, ),
         ( 408, 409, 481, ),
         ( 408, 481, 480, ),
         ( 409, 410, 482, ),
         ( 409, 482, 481, ),
         ( 410, 411, 483, ),
         ( 410, 483, 482, ),
         ( 411, 412, 484, ),
         ( 411, 484, 483, ),
         ( 412, 413, 485, ),
         ( 412, 485, 484, ),
         ( 413, 414, 486, ),
         ( 413, 486, 485, ),
         ( 414, 415, 487, ),
         ( 414, 487, 486, ),
         ( 415, 416, 488, ),
         ( 415, 488, 487, ),
         ( 416, 417, 489, ),
         ( 416, 489, 488, ),
         ( 417, 418, 490, ),
         ( 417, 490, 489, ),
         ( 418, 419, 491, ),
         ( 418, 491, 490, ),
         ( 419, 420, 492, ),
         ( 419, 492, 491, ),
         ( 420, 421, 493, ),
         ( 420, 493, 492, ),
         ( 421, 422, 494, ),
         ( 421, 494, 493, ),
         ( 422, 423, 495, ),
         ( 422, 495, 494, ),
         ( 423, 424, 496, ),
         ( 423, 496, 495, ),
         ( 424, 425, 497, ),
         ( 424, 497, 496, ),
         ( 425, 426, 498, ),
         ( 425, 498, 497, ),
         ( 426, 427, 499, ),
         ( 426, 499, 498, ),
         ( 427, 428, 500, ),
         ( 427, 500, 499, ),
         ( 428, 429, 501, ),
         ( 428, 501, 500, ),
         ( 429, 430, 502, ),
         ( 429, 502, 501, ),
         ( 430, 431, 503, ),
         ( 430, 503, 502, ),
         ( 431, 360, 432, ),
         ( 431, 432, 503, ),
         ( 432, 433, 504, ),
         ( 433, 505, 504, ),
         ( 433, 434, 505, ),
         ( 434, 506, 505, ),
         ( 434, 435, 506, ),
         ( 435, 507, 506, ),
         ( 435, 436, 507, ),
         ( 436, 508, 507, ),
         ( 436, 437, 508, ),
         ( 437, 509, 508, ),
         ( 437, 438, 509, ),
         ( 438, 510, 509, ),
         ( 438, 439, 510, ),
         ( 439, 511, 510, ),
         ( 439, 440, 511, ),
         ( 440, 512, 511, ),
         ( 440, 441, 512, ),
         ( 441, 513, 512, ),
         ( 441, 442, 513, ),
         ( 442, 514, 513, ),
         ( 442, 443, 514, ),
         ( 443, 515, 514, ),
         ( 443, 444, 515, ),
         ( 444, 516, 515, ),
         ( 444, 445, 516, ),
         ( 445, 517, 516, ),
         ( 445, 446, 517, ),
         ( 446, 518, 517, ),
         ( 446, 447, 518, ),
         ( 447, 519, 518, ),
         ( 447, 448, 519, ),
         ( 448, 520, 519, ),
         ( 448, 449, 520, ),
         ( 449, 521, 520, ),
         ( 449, 450, 521, ),
         ( 450, 522, 521, ),
         ( 450, 451, 522, ),
         ( 451, 523, 522, ),
         ( 451, 452, 523, ),
         ( 452, 524, 523, ),
         ( 452, 453, 524, ),
         ( 453, 525, 524, ),
         ( 453, 454, 525, ),
         ( 454, 526, 525, ),
         ( 454, 455, 526, ),
         ( 455, 527, 526, ),
         ( 455, 456, 527, ),
         ( 456, 528, 527, ),
         ( 456, 457, 528, ),
         ( 457, 529, 528, ),
         ( 457, 458, 529, ),
         ( 458, 530, 529, ),
         ( 458, 459, 530, ),
         ( 459, 531, 530, ),
         ( 459, 460, 531, ),
         ( 460, 532, 531, ),
         ( 460, 461, 532, ),
         ( 461, 533, 532, ),
         ( 461, 462, 533, ),
         ( 462, 534, 533, ),
         ( 462, 463, 534, ),
         ( 463, 535, 534, ),
         ( 463, 464, 535, ),
         ( 464, 536, 535, ),
         ( 464, 465, 536, ),
         ( 465, 537, 536, ),
         ( 465, 466, 537, ),
         ( 466, 538, 537, ),
         ( 466, 467, 538, ),
         ( 467, 539, 538, ),
         ( 467, 468, 539, ),
         ( 468, 540, 539, ),
         ( 468, 469, 540, ),
         ( 469, 541, 540, ),
         ( 469, 470, 541, ),
         ( 470, 542, 541, ),
         ( 470, 471, 542, ),
         ( 471, 543, 542, ),
         ( 471, 472, 543, ),
         ( 472, 544, 543, ),
         ( 472, 473, 544, ),
         ( 473, 545, 544, ),
         ( 473, 474, 545, ),
         ( 474, 546, 545, ),
         ( 474, 475, 546, ),
         ( 475, 547, 546, ),
         ( 475, 476, 547, ),
         ( 476, 548, 547, ),
         ( 476, 477, 548, ),
         ( 477, 549, 548, ),
         ( 477, 478, 549, ),
         ( 478, 550, 549, ),
         ( 478, 479, 550, ),
         ( 479, 551, 550, ),
         ( 479, 480, 551, ),
         ( 480, 552, 551, ),
         ( 480, 481, 552, ),
         ( 481, 553, 552, ),
         ( 481, 482, 553, ),
         ( 482, 554, 553, ),
         ( 482, 483, 554, ),
         ( 483, 555, 554, ),
         ( 483, 484, 555, ),
         ( 484, 556, 555, ),
         ( 484, 485, 556, ),
         ( 485, 557, 556, ),
         ( 485, 486, 557, ),
         ( 486, 558, 557, ),
         ( 486, 487, 558, ),
         ( 487, 559, 558, ),
         ( 487, 488, 559, ),
         ( 488, 560, 559, ),
         ( 488, 489, 560, ),
         ( 489, 561, 560, ),
         ( 489, 490, 561, ),
         ( 490, 562, 561, ),
         ( 490, 491, 562, ),
         ( 491, 563, 562, ),
         ( 491, 492, 563, ),
         ( 492, 564, 563, ),
         ( 492, 493, 564, ),
         ( 493, 565, 564, ),
         ( 493, 494, 565, ),
         ( 494, 566, 565, ),
         ( 494, 495, 566, ),
         ( 495, 567, 566, ),
         ( 495, 496, 567, ),
         ( 496, 568, 567, ),
         ( 496, 497, 568, ),
         ( 497, 569, 568, ),
         ( 497, 498, 569, ),
         ( 498, 570, 569, ),
         ( 498, 499, 570, ),
         ( 499, 571, 570, ),
         ( 499, 500, 571, ),
         ( 500, 572, 571, ),
         ( 500, 501, 572, ),
         ( 501, 573, 572, ),
         ( 501, 502, 573, ),
         ( 502, 574, 573, ),
         ( 502, 503, 574, ),
         ( 503, 575, 574, ),
         ( 503, 432, 575, ),
         ( 432, 504, 575, ),
         ( 504, 505, 577, ),
         ( 504, 577, 576, ),
         ( 505, 506, 578, ),
         ( 505, 578, 577, ),
         ( 506, 507, 579, ),
         ( 506, 579, 578, ),
         ( 507, 508, 580, ),
         ( 507, 580, 579, ),
         ( 508, 509, 581, ),
         ( 508, 581, 580, ),
         ( 509, 510, 582, ),
         ( 509, 582, 581, ),
         ( 510, 511, 583, ),
         ( 510, 583, 582, ),
         ( 511, 512, 584, ),
         ( 511, 584, 583, ),
         ( 512, 513, 585, ),
         ( 512, 585, 584, ),
         ( 513, 514, 586, ),
         ( 513, 586, 585, ),
         ( 514, 515, 587, ),
         ( 514, 587, 586, ),
         ( 515, 516, 588, ),
         ( 515, 588, 587, ),
         ( 516, 517, 589, ),
         ( 516, 589, 588, ),
         ( 517, 518, 590, ),
         ( 517, 590, 589, ),
         ( 518, 519, 591, ),
         ( 518, 591, 590, ),
         ( 519, 520, 592, ),
         ( 519, 592, 591, ),
         ( 520, 521, 593, ),
         ( 520, 593, 592, ),
         ( 521, 522, 594, ),
         ( 521, 594, 593, ),
         ( 522, 523, 595, ),
         ( 522, 595, 594, ),
         ( 523, 524, 596, ),
         ( 523, 596, 595, ),
         ( 524, 525, 597, ),
         ( 524, 597, 596, ),
         ( 525, 526, 598, ),
         ( 525, 598, 597, ),
         ( 526, 527, 599, ),
         ( 526, 599, 598, ),
         ( 527, 528, 600, ),
         ( 527, 600, 599, ),
         ( 528, 529, 601, ),
         ( 528, 601, 600, ),
         ( 529, 530, 602, ),
         ( 529, 602, 601, ),
         ( 530, 531, 603, ),
         ( 530, 603, 602, ),
         ( 531, 532, 604, ),
         ( 531, 604, 603, ),
         ( 532, 533, 605, ),
         ( 532, 605, 604, ),
         ( 533, 534, 606, ),
         ( 533, 606, 605, ),
         ( 534, 535, 607, ),
         ( 534, 607, 606, ),
         ( 535, 536, 608, ),
         ( 535, 608, 607, ),
         ( 536, 537, 609, ),
         ( 536, 609, 608, ),
         ( 537, 538, 610, ),
         ( 537, 610, 609, ),
         ( 538, 539, 611, ),
         ( 538, 611, 610, ),
         ( 539, 540, 612, ),
         ( 539, 612, 611, ),
         ( 540, 541, 613, ),
         ( 540, 613, 612, ),
         ( 541, 542, 614, ),
         ( 541, 614, 613, ),
         ( 542, 543, 615, ),
         ( 542, 615, 614, ),
         ( 543, 544, 616, ),
         ( 543, 616, 615, ),
         ( 544, 545, 617, ),
         ( 544, 617, 616, ),
         ( 545, 546, 618, ),
         ( 545, 618, 617, ),
         ( 546, 547, 619, ),
         ( 546, 619, 618, ),
         ( 547, 548, 620, ),
         ( 547, 620, 619, ),
         ( 548, 549, 621, ),
         ( 548, 621, 620, ),
         ( 549, 550, 622, ),
         ( 549, 622, 621, ),
         ( 550, 551, 623, ),
         ( 550, 623, 622, ),
         ( 551, 552, 624, ),
         ( 551, 624, 623, ),
         ( 552, 553, 625, ),
         ( 552, 625, 624, ),
         ( 553, 554, 626, ),
         ( 553, 626, 625, ),
         ( 554, 555, 627, ),
         ( 554, 627, 626, ),
         ( 555, 556, 628, ),
         ( 555, 628, 627, ),
         ( 556, 557, 629, ),
         ( 556, 629, 628, ),
         ( 557, 558, 630, ),
         ( 557, 630, 629, ),
         ( 558, 559, 631, ),
         ( 558, 631, 630, ),
         ( 559, 560, 632, ),
         ( 559, 632, 631, ),
         ( 560, 561, 633, ),
         ( 560, 633, 632, ),
         ( 561, 562, 634, ),
         ( 561, 634, 633, ),
         ( 562, 563, 635, ),
         ( 562, 635, 634, ),
         ( 563, 564, 636, ),
         ( 563, 636, 635, ),
         ( 564, 565, 637, ),
         ( 564, 637, 636, ),
         ( 565, 566, 638, ),
         ( 565, 638, 637, ),
         ( 566, 567, 639, ),
         ( 566, 639, 638, ),
         ( 567, 568, 640, ),
         ( 567, 640, 639, ),
         ( 568, 569, 641, ),
         ( 568, 641, 640, ),
         ( 569, 570, 642, ),
         ( 569, 642, 641, ),
         ( 570, 571, 643, ),
         ( 570, 643, 642, ),
         ( 571, 572, 644, ),
         ( 571, 644, 643, ),
         ( 572, 573, 645, ),
         ( 572, 645, 644, ),
         ( 573, 574, 646, ),
         ( 573, 646, 645, ),
         ( 574, 575, 647, ),
         ( 574, 647, 646, ),
         ( 575, 504, 576, ),
         ( 575, 576, 647, ),
         ( 576, 577, 648, ),
         ( 577, 649, 648, ),
         ( 577, 578, 649, ),
         ( 578, 650, 649, ),
         ( 578, 579, 650, ),
         ( 579, 651, 650, ),
         ( 579, 580, 651, ),
         ( 580, 652, 651, ),
         ( 580, 581, 652, ),
         ( 581, 653, 652, ),
         ( 581, 582, 653, ),
         ( 582, 654, 653, ),
         ( 582, 583, 654, ),
         ( 583, 655, 654, ),
         ( 583, 584, 655, ),
         ( 584, 656, 655, ),
         ( 584, 585, 656, ),
         ( 585, 657, 656, ),
         ( 585, 586, 657, ),
         ( 586, 658, 657, ),
         ( 586, 587, 658, ),
         ( 587, 659, 658, ),
         ( 587, 588, 659, ),
         ( 588, 660, 659, ),
         ( 588, 589, 660, ),
         ( 589, 661, 660, ),
         ( 589, 590, 661, ),
         ( 590, 662, 661, ),
         ( 590, 591, 662, ),
         ( 591, 663, 662, ),
         ( 591, 592, 663, ),
         ( 592, 664, 663, ),
         ( 592, 593, 664, ),
         ( 593, 665, 664, ),
         ( 593, 594, 665, ),
         ( 594, 666, 665, ),
         ( 594, 595, 666, ),
         ( 595, 667, 666, ),
         ( 595, 596, 667, ),
         ( 596, 668, 667, ),
         ( 596, 597, 668, ),
         ( 597, 669, 668, ),
         ( 597, 598, 669, ),
         ( 598, 670, 669, ),
         ( 598, 599, 670, ),
         ( 599, 671, 670, ),
         ( 599, 600, 671, ),
         ( 600, 672, 671, ),
         ( 600, 601, 672, ),
         ( 601, 673, 672, ),
         ( 601, 602, 673, ),
         ( 602, 674, 673, ),
         ( 602, 603, 674, ),
         ( 603, 675, 674, ),
         ( 603, 604, 675, ),
         ( 604, 676, 675, ),
         ( 604, 605, 676, ),
         ( 605, 677, 676, ),
         ( 605, 606, 677, ),
         ( 606, 678, 677, ),
         ( 606, 607, 678, ),
         ( 607, 679, 678, ),
         ( 607, 608, 679, ),
         ( 608, 680, 679, ),
         ( 608, 609, 680, ),
         ( 609, 681, 680, ),
         ( 609, 610, 681, ),
         ( 610, 682, 681, ),
         ( 610, 611, 682, ),
         ( 611, 683, 682, ),
         ( 611, 612, 683, ),
         ( 612, 684, 683, ),
         ( 612, 613, 684, ),
         ( 613, 685, 684, ),
         ( 613, 614, 685, ),
         ( 614, 686, 685, ),
         ( 614, 615, 686, ),
         ( 615, 687, 686, ),
         ( 615, 616, 687, ),
         ( 616, 688, 687, ),
         ( 616, 617, 688, ),
         ( 617, 689, 688, ),
         ( 617, 618, 689, ),
         ( 618, 690, 689, ),
         ( 618, 619, 690, ),
         ( 619, 691, 690, ),
         ( 619, 620, 691, ),
         ( 620, 692, 691, ),
         ( 620, 621, 692, ),
         ( 621, 693, 692, ),
         ( 621, 622, 693, ),
         ( 622, 694, 693, ),
         ( 622, 623, 694, ),
         ( 623, 695, 694, ),
         ( 623, 624, 695, ),
         ( 624, 696, 695, ),
         ( 624, 625, 696, ),
         ( 625, 697, 696, ),
         ( 625, 626, 697, ),
         ( 626, 698, 697, ),
         ( 626, 627, 698, ),
         ( 627, 699, 698, ),
         ( 627, 628, 699, ),
         ( 628, 700, 699, ),
         ( 628, 629, 700, ),
         ( 629, 701, 700, ),
         ( 629, 630, 701, ),
         ( 630, 702, 701, ),
         ( 630, 631, 702, ),
         ( 631, 703, 702, ),
         ( 631, 632, 703, ),
         ( 632, 704, 703, ),
         ( 632, 633, 704, ),
         ( 633, 705, 704, ),
         ( 633, 634, 705, ),
         ( 634, 706, 705, ),
         ( 634, 635, 706, ),
         ( 635, 707, 706, ),
         ( 635, 636, 707, ),
         ( 636, 708, 707, ),
         ( 636, 637, 708, ),
         ( 637, 709, 708, ),
         ( 637, 638, 709, ),
         ( 638, 710, 709, ),
         ( 638, 639, 710, ),
         ( 639, 711, 710, ),
         ( 639, 640, 711, ),
         ( 640, 712, 711, ),
         ( 640, 641, 712, ),
         ( 641, 713, 712, ),
         ( 641, 642, 713, ),
         ( 642, 714, 713, ),
         ( 642, 643, 714, ),
         ( 643, 715, 714, ),
         ( 643, 644, 715, ),
         ( 644, 716, 715, ),
         ( 644, 645, 716, ),
         ( 645, 717, 716, ),
         ( 645, 646, 717, ),
         ( 646, 718, 717, ),
         ( 646, 647, 718, ),
         ( 647, 719, 718, ),
         ( 647, 576, 719, ),
         ( 576, 648, 719, ),
         ( 648, 649, 721, ),
         ( 648, 721, 720, ),
         ( 649, 650, 722, ),
         ( 649, 722, 721, ),
         ( 650, 651, 723, ),
         ( 650, 723, 722, ),
         ( 651, 652, 724, ),
         ( 651, 724, 723, ),
         ( 652, 653, 725, ),
         ( 652, 725, 724, ),
         ( 653, 654, 726, ),
         ( 653, 726, 725, ),
         ( 654, 655, 727, ),
         ( 654, 727, 726, ),
         ( 655, 656, 728, ),
         ( 655, 728, 727, ),
         ( 656, 657, 729, ),
         ( 656, 729, 728, ),
         ( 657, 658, 730, ),
         ( 657, 730, 729, ),
         ( 658, 659, 731, ),
         ( 658, 731, 730, ),
         ( 659, 660, 732, ),
         ( 659, 732, 731, ),
         ( 660, 661, 733, ),
         ( 660, 733, 732, ),
         ( 661, 662, 734, ),
         ( 661, 734, 733, ),
         ( 662, 663, 735, ),
         ( 662, 735, 734, ),
         ( 663, 664, 736, ),
         ( 663, 736, 735, ),
         ( 664, 665, 737, ),
         ( 664, 737, 736, ),
         ( 665, 666, 738, ),
         ( 665, 738, 737, ),
         ( 666, 667, 739, ),
         ( 666, 739, 738, ),
         ( 667, 668, 740, ),
         ( 667, 740, 739, ),
         ( 668, 669, 741, ),
         ( 668, 741, 740, ),
         ( 669, 670, 742, ),
         ( 669, 742, 741, ),
         ( 670, 671, 743, ),
         ( 670, 743, 742, ),
         ( 671, 672, 744, ),
         ( 671, 744, 743, ),
         ( 672, 673, 745, ),
         ( 672, 745, 744, ),
         ( 673, 674, 746, ),
         ( 673, 746, 745, ),
         ( 674, 675, 747, ),
         ( 674, 747, 746, ),
         ( 675, 676, 748, ),
         ( 675, 748, 747, ),
         ( 676, 677, 749, ),
         ( 676, 749, 748, ),
         ( 677, 678, 750, ),
         ( 677, 750, 749, ),
         ( 678, 679, 751, ),
         ( 678, 751, 750, ),
         ( 679, 680, 752, ),
         ( 679, 752, 751, ),
         ( 680, 681, 753, ),
         ( 680, 753, 752, ),
         ( 681, 682, 754, ),
         ( 681, 754, 753, ),
         ( 682, 683, 755, ),
         ( 682, 755, 754, ),
         ( 683, 684, 756, ),
         ( 683, 756, 755, ),
         ( 684, 685, 757, ),
         ( 684, 757, 756, ),
         ( 685, 686, 758, ),
         ( 685, 758, 757, ),
         ( 686, 687, 759, ),
         ( 686, 759, 758, ),
         ( 687, 688, 760, ),
         ( 687, 760, 759, ),
         ( 688, 689, 761, ),
         ( 688, 761, 760, ),
         ( 689, 690, 762, ),
         ( 689, 762, 761, ),
         ( 690, 691, 763, ),
         ( 690, 763, 762, ),
         ( 691, 692, 764, ),
         ( 691, 764, 763, ),
         ( 692, 693, 765, ),
         ( 692, 765, 764, ),
         ( 693, 694, 766, ),
         ( 693, 766, 765, ),
         ( 694, 695, 767, ),
         ( 694, 767, 766, ),
         ( 695, 696, 768, ),
         ( 695, 768, 767, ),
         ( 696, 697, 769, ),
         ( 696, 769, 768, ),
         ( 697, 698, 770, ),
         ( 697, 770, 769, ),
         ( 698, 699, 771, ),
         ( 698, 771, 770, ),
         ( 699, 700, 772, ),
         ( 699, 772, 771, ),
         ( 700, 701, 773, ),
         ( 700, 773, 772, ),
         ( 701, 702, 774, ),
         ( 701, 774, 773, ),
         ( 702, 703, 775, ),
         ( 702, 775, 774, ),
         ( 703, 704, 776, ),
         ( 703, 776, 775, ),
         ( 704, 705, 777, ),
         ( 704, 777, 776, ),
         ( 705, 706, 778, ),
         ( 705, 778, 777, ),
         ( 706, 707, 779, ),
         ( 706, 779, 778, ),
         ( 707, 708, 780, ),
         ( 707, 780, 779, ),
         ( 708, 709, 781, ),
         ( 708, 781, 780, ),
         ( 709, 710, 782, ),
         ( 709, 782, 781, ),
         ( 710, 711, 783, ),
         ( 710, 783, 782, ),
         ( 711, 712, 784, ),
         ( 711, 784, 783, ),
         ( 712, 713, 785, ),
         ( 712, 785, 784, ),
         ( 713, 714, 786, ),
         ( 713, 786, 785, ),
         ( 714, 715, 787, ),
         ( 714, 787, 786, ),
         ( 715, 716, 788, ),
         ( 715, 788, 787, ),
         ( 716, 717, 789, ),
         ( 716, 789, 788, ),
         ( 717, 718, 790, ),
         ( 717, 790, 789, ),
         ( 718, 719, 791, ),
         ( 718, 791, 790, ),
         ( 719, 648, 720, ),
         ( 719, 720, 791, ),
         ( 720, 721, 792, ),
         ( 721, 793, 792, ),
         ( 721, 722, 793, ),
         ( 722, 794, 793, ),
         ( 722, 723, 794, ),
         ( 723, 795, 794, ),
         ( 723, 724, 795, ),
         ( 724, 796, 795, ),
         ( 724, 725, 796, ),
         ( 725, 797, 796, ),
         ( 725, 726, 797, ),
         ( 726, 798, 797, ),
         ( 726, 727, 798, ),
         ( 727, 799, 798, ),
         ( 727, 728, 799, ),
         ( 728, 800, 799, ),
         ( 728, 729, 800, ),
         ( 729, 801, 800, ),
         ( 729, 730, 801, ),
         ( 730, 802, 801, ),
         ( 730, 731, 802, ),
         ( 731, 803, 802, ),
         ( 731, 732, 803, ),
         ( 732, 804, 803, ),
         ( 732, 733, 804, ),
         ( 733, 805, 804, ),
         ( 733, 734, 805, ),
         ( 734, 806, 805, ),
         ( 734, 735, 806, ),
         ( 735, 807, 806, ),
         ( 735, 736, 807, ),
         ( 736, 808, 807, ),
         ( 736, 737, 808, ),
         ( 737, 809, 808, ),
         ( 737, 738, 809, ),
         ( 738, 810, 809, ),
         ( 738, 739, 810, ),
         ( 739, 811, 810, ),
         ( 739, 740, 811, ),
         ( 740, 812, 811, ),
         ( 740, 741, 812, ),
         ( 741, 813, 812, ),
         ( 741, 742, 813, ),
         ( 742, 814, 813, ),
         ( 742, 743, 814, ),
         ( 743, 815, 814, ),
         ( 743, 744, 815, ),
         ( 744, 816, 815, ),
         ( 744, 745, 816, ),
         ( 745, 817, 816, ),
         ( 745, 746, 817, ),
         ( 746, 818, 817, ),
         ( 746, 747, 818, ),
         ( 747, 819, 818, ),
         ( 747, 748, 819, ),
         ( 748, 820, 819, ),
         ( 748, 749, 820, ),
         ( 749, 821, 820, ),
         ( 749, 750, 821, ),
         ( 750, 822, 821, ),
         ( 750, 751, 822, ),
         ( 751, 823, 822, ),
         ( 751, 752, 823, ),
         ( 752, 824, 823, ),
         ( 752, 753, 824, ),
         ( 753, 825, 824, ),
         ( 753, 754, 825, ),
         ( 754, 826, 825, ),
         ( 754, 755, 826, ),
         ( 755, 827, 826, ),
         ( 755, 756, 827, ),
         ( 756, 828, 827, ),
         ( 756, 757, 828, ),
         ( 757, 829, 828, ),
         ( 757, 758, 829, ),
         ( 758, 830, 829, ),
         ( 758, 759, 830, ),
         ( 759, 831, 830, ),
         ( 759, 760, 831, ),
         ( 760, 832, 831, ),
         ( 760, 761, 832, ),
         ( 761, 833, 832, ),
         ( 761, 762, 833, ),
         ( 762, 834, 833, ),
         ( 762, 763, 834, ),
         ( 763, 835, 834, ),
         ( 763, 764, 835, ),
         ( 764, 836, 835, ),
         ( 764, 765, 836, ),
         ( 765, 837, 836, ),
         ( 765, 766, 837, ),
         ( 766, 838, 837, ),
         ( 766, 767, 838, ),
         ( 767, 839, 838, ),
         ( 767, 768, 839, ),
         ( 768, 840, 839, ),
         ( 768, 769, 840, ),
         ( 769, 841, 840, ),
         ( 769, 770, 841, ),
         ( 770, 842, 841, ),
         ( 770, 771, 842, ),
         ( 771, 843, 842, ),
         ( 771, 772, 843, ),
         ( 772, 844, 843, ),
         ( 772, 773, 844, ),
         ( 773, 845, 844, ),
         ( 773, 774, 845, ),
         ( 774, 846, 845, ),
         ( 774, 775, 846, ),
         ( 775, 847, 846, ),
         ( 775, 776, 847, ),
         ( 776, 848, 847, ),
         ( 776, 777, 848, ),
         ( 777, 849, 848, ),
         ( 777, 778, 849, ),
         ( 778, 850, 849, ),
         ( 778, 779, 850, ),
         ( 779, 851, 850, ),
         ( 779, 780, 851, ),
         ( 780, 852, 851, ),
         ( 780, 781, 852, ),
         ( 781, 853, 852, ),
         ( 781, 782, 853, ),
         ( 782, 854, 853, ),
         ( 782, 783, 854, ),
         ( 783, 855, 854, ),
         ( 783, 784, 855, ),
         ( 784, 856, 855, ),
         ( 784, 785, 856, ),
         ( 785, 857, 856, ),
         ( 785, 786, 857, ),
         ( 786, 858, 857, ),
         ( 786, 787, 858, ),
         ( 787, 859, 858, ),
         ( 787, 788, 859, ),
         ( 788, 860, 859, ),
         ( 788, 789, 860, ),
         ( 789, 861, 860, ),
         ( 789, 790, 861, ),
         ( 790, 862, 861, ),
         ( 790, 791, 862, ),
         ( 791, 863, 862, ),
         ( 791, 720, 863, ),
         ( 720, 792, 863, ),
         ( 792, 793, 865, ),
         ( 792, 865, 864, ),
         ( 793, 794, 866, ),
         ( 793, 866, 865, ),
         ( 794, 795, 867, ),
         ( 794, 867, 866, ),
         ( 795, 796, 868, ),
         ( 795, 868, 867, ),
         ( 796, 797, 869, ),
         ( 796, 869, 868, ),
         ( 797, 798, 870, ),
         ( 797, 870, 869, ),
         ( 798, 799, 871, ),
         ( 798, 871, 870, ),
         ( 799, 800, 872, ),
         ( 799, 872, 871, ),
         ( 800, 801, 873, ),
         ( 800, 873, 872, ),
         ( 801, 802, 874, ),
         ( 801, 874, 873, ),
         ( 802, 803, 875, ),
         ( 802, 875, 874, ),
         ( 803, 804, 876, ),
         ( 803, 876, 875, ),
         ( 804, 805, 877, ),
         ( 804, 877, 876, ),
         ( 805, 806, 878, ),
         ( 805, 878, 877, ),
         ( 806, 807, 879, ),
         ( 806, 879, 878, ),
         ( 807, 808, 880, ),
         ( 807, 880, 879, ),
         ( 808, 809, 881, ),
         ( 808, 881, 880, ),
         ( 809, 810, 882, ),
         ( 809, 882, 881, ),
         ( 810, 811, 883, ),
         ( 810, 883, 882, ),
         ( 811, 812, 884, ),
         ( 811, 884, 883, ),
         ( 812, 813, 885, ),
         ( 812, 885, 884, ),
         ( 813, 814, 886, ),
         ( 813, 886, 885, ),
         ( 814, 815, 887, ),
         ( 814, 887, 886, ),
         ( 815, 816, 888, ),
         ( 815, 888, 887, ),
         ( 816, 817, 889, ),
         ( 816, 889, 888, ),
         ( 817, 818, 890, ),
         ( 817, 890, 889, ),
         ( 818, 819, 891, ),
         ( 818, 891, 890, ),
         ( 819, 820, 892, ),
         ( 819, 892, 891, ),
         ( 820, 821, 893, ),
         ( 820, 893, 892, ),
         ( 821, 822, 894, ),
         ( 821, 894, 893, ),
         ( 822, 823, 895, ),
         ( 822, 895, 894, ),
         ( 823, 824, 896, ),
         ( 823, 896, 895, ),
         ( 824, 825, 897, ),
         ( 824, 897, 896, ),
         ( 825, 826, 898, ),
         ( 825, 898, 897, ),
         ( 826, 827, 899, ),
         ( 826, 899, 898, ),
         ( 827, 828, 900, ),
         ( 827, 900, 899, ),
         ( 828, 829, 901, ),
         ( 828, 901, 900, ),
         ( 829, 830, 902, ),
         ( 829, 902, 901, ),
         ( 830, 831, 903, ),
         ( 830, 903, 902, ),
         ( 831, 832, 904, ),
         ( 831, 904, 903, ),
         ( 832, 833, 905, ),
         ( 832, 905, 904, ),
         ( 833, 834, 906, ),
         ( 833, 906, 905, ),
         ( 834, 835, 907, ),
         ( 834, 907, 906, ),
         ( 835, 836, 908, ),
         ( 835, 908, 907, ),
         ( 836, 837, 909, ),
         ( 836, 909, 908, ),
         ( 837, 838, 910, ),
         ( 837, 910, 909, ),
         ( 838, 839, 911, ),
         ( 838, 911, 910, ),
         ( 839, 840, 912, ),
         ( 839, 912, 911, ),
         ( 840, 841, 913, ),
         ( 840, 913, 912, ),
         ( 841, 842, 914, ),
         ( 841, 914, 913, ),
         ( 842, 843, 915, ),
         ( 842, 915, 914, ),
         ( 843, 844, 916, ),
         ( 843, 916, 915, ),
         ( 844, 845, 917, ),
         ( 844, 917, 916, ),
         ( 845, 846, 918, ),
         ( 845, 918, 917, ),
         ( 846, 847, 919, ),
         ( 846, 919, 918, ),
         ( 847, 848, 920, ),
         ( 847, 920, 919, ),
         ( 848, 849, 921, ),
         ( 848, 921, 920, ),
         ( 849, 850, 922, ),
         ( 849, 922, 921, ),
         ( 850, 851, 923, ),
         ( 850, 923, 922, ),
         ( 851, 852, 924, ),
         ( 851, 924, 923, ),
         ( 852, 853, 925, ),
         ( 852, 925, 924, ),
         ( 853, 854, 926, ),
         ( 853, 926, 925, ),
         ( 854, 855, 927, ),
         ( 854, 927, 926, ),
         ( 855, 856, 928, ),
         ( 855, 928, 927, ),
         ( 856, 857, 929, ),
         ( 856, 929, 928, ),
         ( 857, 858, 930, ),
         ( 857, 930, 929, ),
         ( 858, 859, 931, ),
         ( 858, 931, 930, ),
         ( 859, 860, 932, ),
         ( 859, 932, 931, ),
         ( 860, 861, 933, ),
         ( 860, 933, 932, ),
         ( 861, 862, 934, ),
         ( 861, 934, 933, ),
         ( 862, 863, 935, ),
         ( 862, 935, 934, ),
         ( 863, 792, 864, ),
         ( 863, 864, 935, ),
         ( 864, 865, 936, ),
         ( 865, 937, 936, ),
         ( 865, 866, 937, ),
         ( 866, 938, 937, ),
         ( 866, 867, 938, ),
         ( 867, 939, 938, ),
         ( 867, 868, 939, ),
         ( 868, 940, 939, ),
         ( 868, 869, 940, ),
         ( 869, 941, 940, ),
         ( 869, 870, 941, ),
         ( 870, 942, 941, ),
         ( 870, 871, 942, ),
         ( 871, 943, 942, ),
         ( 871, 872, 943, ),
         ( 872, 944, 943, ),
         ( 872, 873, 944, ),
         ( 873, 945, 944, ),
         ( 873, 874, 945, ),
         ( 874, 946, 945, ),
         ( 874, 875, 946, ),
         ( 875, 947, 946, ),
         ( 875, 876, 947, ),
         ( 876, 948, 947, ),
         ( 876, 877, 948, ),
         ( 877, 949, 948, ),
         ( 877, 878, 949, ),
         ( 878, 950, 949, ),
         ( 878, 879, 950, ),
         ( 879, 951, 950, ),
         ( 879, 880, 951, ),
         ( 880, 952, 951, ),
         ( 880, 881, 952, ),
         ( 881, 953, 952, ),
         ( 881, 882, 953, ),
         ( 882, 954, 953, ),
         ( 882, 883, 954, ),
         ( 883, 955, 954, ),
         ( 883, 884, 955, ),
         ( 884, 956, 955, ),
         ( 884, 885, 956, ),
         ( 885, 957, 956, ),
         ( 885, 886, 957, ),
         ( 886, 958, 957, ),
         ( 886, 887, 958, ),
         ( 887, 959, 958, ),
         ( 887, 888, 959, ),
         ( 888, 960, 959, ),
         ( 888, 889, 960, ),
         ( 889, 961, 960, ),
         ( 889, 890, 961, ),
         ( 890, 962, 961, ),
         ( 890, 891, 962, ),
         ( 891, 963, 962, ),
         ( 891, 892, 963, ),
         ( 892, 964, 963, ),
         ( 892, 893, 964, ),
         ( 893, 965, 964, ),
         ( 893, 894, 965, ),
         ( 894, 966, 965, ),
         ( 894, 895, 966, ),
         ( 895, 967, 966, ),
         ( 895, 896, 967, ),
         ( 896, 968, 967, ),
         ( 896, 897, 968, ),
         ( 897, 969, 968, ),
         ( 897, 898, 969, ),
         ( 898, 970, 969, ),
         ( 898, 899, 970, ),
         ( 899, 971, 970, ),
         ( 899, 900, 971, ),
         ( 900, 972, 971, ),
         ( 900, 901, 972, ),
         ( 901, 973, 972, ),
         ( 901, 902, 973, ),
         ( 902, 974, 973, ),
         ( 902, 903, 974, ),
         ( 903, 975, 974, ),
         ( 903, 904, 975, ),
         ( 904, 976, 975, ),
         ( 904, 905, 976, ),
         ( 905, 977, 976, ),
         ( 905, 906, 977, ),
         ( 906, 978, 977, ),
         ( 906, 907, 978, ),
         ( 907, 979, 978, ),
         ( 907, 908, 979, ),
         ( 908, 980, 979, ),
         ( 908, 909, 980, ),
         ( 909, 981, 980, ),
         ( 909, 910, 981, ),
         ( 910, 982, 981, ),
         ( 910, 911, 982, ),
         ( 911, 983, 982, ),
         ( 911, 912, 983, ),
         ( 912, 984, 983, ),
         ( 912, 913, 984, ),
         ( 913, 985, 984, ),
         ( 913, 914, 985, ),
         ( 914, 986, 985, ),
         ( 914, 915, 986, ),
         ( 915, 987, 986, ),
         ( 915, 916, 987, ),
         ( 916, 988, 987, ),
         ( 916, 917, 988, ),
         ( 917, 989, 988, ),
         ( 917, 918, 989, ),
         ( 918, 990, 989, ),
         ( 918, 919, 990, ),
         ( 919, 991, 990, ),
         ( 919, 920, 991, ),
         ( 920, 992, 991, ),
         ( 920, 921, 992, ),
         ( 921, 993, 992, ),
         ( 921, 922, 993, ),
         ( 922, 994, 993, ),
         ( 922, 923, 994, ),
         ( 923, 995, 994, ),
         ( 923, 924, 995, ),
         ( 924, 996, 995, ),
         ( 924, 925, 996, ),
         ( 925, 997, 996, ),
         ( 925, 926, 997, ),
         ( 926, 998, 997, ),
         ( 926, 927, 998, ),
         ( 927, 999, 998, ),
         ( 927, 928, 999, ),
         ( 928, 1000, 999, ),
         ( 928, 929, 1000, ),
         ( 929, 1001, 1000, ),
         ( 929, 930, 1001, ),
         ( 930, 1002, 1001, ),
         ( 930, 931, 1002, ),
         ( 931, 1003, 1002, ),
         ( 931, 932, 1003, ),
         ( 932, 1004, 1003, ),
         ( 932, 933, 1004, ),
         ( 933, 1005, 1004, ),
         ( 933, 934, 1005, ),
         ( 934, 1006, 1005, ),
         ( 934, 935, 1006, ),
         ( 935, 1007, 1006, ),
         ( 935, 864, 1007, ),
         ( 864, 936, 1007, ),
         ( 936, 937, 1009, ),
         ( 936, 1009, 1008, ),
         ( 937, 938, 1010, ),
         ( 937, 1010, 1009, ),
         ( 938, 939, 1011, ),
         ( 938, 1011, 1010, ),
         ( 939, 940, 1012, ),
         ( 939, 1012, 1011, ),
         ( 940, 941, 1013, ),
         ( 940, 1013, 1012, ),
         ( 941, 942, 1014, ),
         ( 941, 1014, 1013, ),
         ( 942, 943, 1015, ),
         ( 942, 1015, 1014, ),
         ( 943, 944, 1016, ),
         ( 943, 1016, 1015, ),
         ( 944, 945, 1017, ),
         ( 944, 1017, 1016, ),
         ( 945, 946, 1018, ),
         ( 945, 1018, 1017, ),
         ( 946, 947, 1019, ),
         ( 946, 1019, 1018, ),
         ( 947, 948, 1020, ),
         ( 947, 1020, 1019, ),
         ( 948, 949, 1021, ),
         ( 948, 1021, 1020, ),
         ( 949, 950, 1022, ),
         ( 949, 1022, 1021, ),
         ( 950, 951, 1023, ),
         ( 950, 1023, 1022, ),
         ( 951, 952, 1024, ),
         ( 951, 1024, 1023, ),
         ( 952, 953, 1025, ),
         ( 952, 1025, 1024, ),
         ( 953, 954, 1026, ),
         ( 953, 1026, 1025, ),
         ( 954, 955, 1027, ),
         ( 954, 1027, 1026, ),
         ( 955, 956, 1028, ),
         ( 955, 1028, 1027, ),
         ( 956, 957, 1029, ),
         ( 956, 1029, 1028, ),
         ( 957, 958, 1030, ),
         ( 957, 1030, 1029, ),
         ( 958, 959, 1031, ),
         ( 958, 1031, 1030, ),
         ( 959, 960, 1032, ),
         ( 959, 1032, 1031, ),
         ( 960, 961, 1033, ),
         ( 960, 1033, 1032, ),
         ( 961, 962, 1034, ),
         ( 961, 1034, 1033, ),
         ( 962, 963, 1035, ),
         ( 962, 1035, 1034, ),
         ( 963, 964, 1036, ),
         ( 963, 1036, 1035, ),
         ( 964, 965, 1037, ),
         ( 964, 1037, 1036, ),
         ( 965, 966, 1038, ),
         ( 965, 1038, 1037, ),
         ( 966, 967, 1039, ),
         ( 966, 1039, 1038, ),
         ( 967, 968, 1040, ),
         ( 967, 1040, 1039, ),
         ( 968, 969, 1041, ),
         ( 968, 1041, 1040, ),
         ( 969, 970, 1042, ),
         ( 969, 1042, 1041, ),
         ( 970, 971, 1043, ),
         ( 970, 1043, 1042, ),
         ( 971, 972, 1044, ),
         ( 971, 1044, 1043, ),
         ( 972, 973, 1045, ),
         ( 972, 1045, 1044, ),
         ( 973, 974, 1046, ),
         ( 973, 1046, 1045, ),
         ( 974, 975, 1047, ),
         ( 974, 1047, 1046, ),
         ( 975, 976, 1048, ),
         ( 975, 1048, 1047, ),
         ( 976, 977, 1049, ),
         ( 976, 1049, 1048, ),
         ( 977, 978, 1050, ),
         ( 977, 1050, 1049, ),
         ( 978, 979, 1051, ),
         ( 978, 1051, 1050, ),
         ( 979, 980, 1052, ),
         ( 979, 1052, 1051, ),
         ( 980, 981, 1053, ),
         ( 980, 1053, 1052, ),
         ( 981, 982, 1054, ),
         ( 981, 1054, 1053, ),
         ( 982, 983, 1055, ),
         ( 982, 1055, 1054, ),
         ( 983, 984, 1056, ),
         ( 983, 1056, 1055, ),
         ( 984, 985, 1057, ),
         ( 984, 1057, 1056, ),
         ( 985, 986, 1058, ),
         ( 985, 1058, 1057, ),
         ( 986, 987, 1059, ),
         ( 986, 1059, 1058, ),
         ( 987, 988, 1060, ),
         ( 987, 1060, 1059, ),
         ( 988, 989, 1061, ),
         ( 988, 1061, 1060, ),
         ( 989, 990, 1062, ),
         ( 989, 1062, 1061, ),
         ( 990, 991, 1063, ),
         ( 990, 1063, 1062, ),
         ( 991, 992, 1064, ),
         ( 991, 1064, 1063, ),
         ( 992, 993, 1065, ),
         ( 992, 1065, 1064, ),
         ( 993, 994, 1066, ),
         ( 993, 1066, 1065, ),
         ( 994, 995, 1067, ),
         ( 994, 1067, 1066, ),
         ( 995, 996, 1068, ),
         ( 995, 1068, 1067, ),
         ( 996, 997, 1069, ),
         ( 996, 1069, 1068, ),
         ( 997, 998, 1070, ),
         ( 997, 1070, 1069, ),
         ( 998, 999, 1071, ),
         ( 998, 1071, 1070, ),
         ( 999, 1000, 1072, ),
         ( 999, 1072, 1071, ),
         ( 1000, 1001, 1073, ),
         ( 1000, 1073, 1072, ),
         ( 1001, 1002, 1074, ),
         ( 1001, 1074, 1073, ),
         ( 1002, 1003, 1075, ),
         ( 1002, 1075, 1074, ),
         ( 1003, 1004, 1076, ),
         ( 1003, 1076, 1075, ),
         ( 1004, 1005, 1077, ),
         ( 1004, 1077, 1076, ),
         ( 1005, 1006, 1078, ),
         ( 1005, 1078, 1077, ),
         ( 1006, 1007, 1079, ),
         ( 1006, 1079, 1078, ),
         ( 1007, 936, 1008, ),
         ( 1007, 1008, 1079, ),
         ( 1008, 1009, 1080, ),
         ( 1009, 1081, 1080, ),
         ( 1009, 1010, 1081, ),
         ( 1010, 1082, 1081, ),
         ( 1010, 1011, 1082, ),
         ( 1011, 1083, 1082, ),
         ( 1011, 1012, 1083, ),
         ( 1012, 1084, 1083, ),
         ( 1012, 1013, 1084, ),
         ( 1013, 1085, 1084, ),
         ( 1013, 1014, 1085, ),
         ( 1014, 1086, 1085, ),
         ( 1014, 1015, 1086, ),
         ( 1015, 1087, 1086, ),
         ( 1015, 1016, 1087, ),
         ( 1016, 1088, 1087, ),
         ( 1016, 1017, 1088, ),
         ( 1017, 1089, 1088, ),
         ( 1017, 1018, 1089, ),
         ( 1018, 1090, 1089, ),
         ( 1018, 1019, 1090, ),
         ( 1019, 1091, 1090, ),
         ( 1019, 1020, 1091, ),
         ( 1020, 1092, 1091, ),
         ( 1020, 1021, 1092, ),
         ( 1021, 1093, 1092, ),
         ( 1021, 1022, 1093, ),
         ( 1022, 1094, 1093, ),
         ( 1022, 1023, 1094, ),
         ( 1023, 1095, 1094, ),
         ( 1023, 1024, 1095, ),
         ( 1024, 1096, 1095, ),
         ( 1024, 1025, 1096, ),
         ( 1025, 1097, 1096, ),
         ( 1025, 1026, 1097, ),
         ( 1026, 1098, 1097, ),
         ( 1026, 1027, 1098, ),
         ( 1027, 1099, 1098, ),
         ( 1027, 1028, 1099, ),
         ( 1028, 1100, 1099, ),
         ( 1028, 1029, 1100, ),
         ( 1029, 1101, 1100, ),
         ( 1029, 1030, 1101, ),
         ( 1030, 1102, 1101, ),
         ( 1030, 1031, 1102, ),
         ( 1031, 1103, 1102, ),
         ( 1031, 1032, 1103, ),
         ( 1032, 1104, 1103, ),
         ( 1032, 1033, 1104, ),
         ( 1033, 1105, 1104, ),
         ( 1033, 1034, 1105, ),
         ( 1034, 1106, 1105, ),
         ( 1034, 1035, 1106, ),
         ( 1035, 1107, 1106, ),
         ( 1035, 1036, 1107, ),
         ( 1036, 1108, 1107, ),
         ( 1036, 1037, 1108, ),
         ( 1037, 1109, 1108, ),
         ( 1037, 1038, 1109, ),
         ( 1038, 1110, 1109, ),
         ( 1038, 1039, 1110, ),
         ( 1039, 1111, 1110, ),
         ( 1039, 1040, 1111, ),
         ( 1040, 1112, 1111, ),
         ( 1040, 1041, 1112, ),
         ( 1041, 1113, 1112, ),
         ( 1041, 1042, 1113, ),
         ( 1042, 1114, 1113, ),
         ( 1042, 1043, 1114, ),
         ( 1043, 1115, 1114, ),
         ( 1043, 1044, 1115, ),
         ( 1044, 1116, 1115, ),
         ( 1044, 1045, 1116, ),
         ( 1045, 1117, 1116, ),
         ( 1045, 1046, 1117, ),
         ( 1046, 1118, 1117, ),
         ( 1046, 1047, 1118, ),
         ( 1047, 1119, 1118, ),
         ( 1047, 1048, 1119, ),
         ( 1048, 1120, 1119, ),
         ( 1048, 1049, 1120, ),
         ( 1049, 1121, 1120, ),
         ( 1049, 1050, 1121, ),
         ( 1050, 1122, 1121, ),
         ( 1050, 1051, 1122, ),
         ( 1051, 1123, 1122, ),
         ( 1051, 1052, 1123, ),
         ( 1052, 1124, 1123, ),
         ( 1052, 1053, 1124, ),
         ( 1053, 1125, 1124, ),
         ( 1053, 1054, 1125, ),
         ( 1054, 1126, 1125, ),
         ( 1054, 1055, 1126, ),
         ( 1055, 1127, 1126, ),
         ( 1055, 1056, 1127, ),
         ( 1056, 1128, 1127, ),
         ( 1056, 1057, 1128, ),
         ( 1057, 1129, 1128, ),
         ( 1057, 1058, 1129, ),
         ( 1058, 1130, 1129, ),
         ( 1058, 1059, 1130, ),
         ( 1059, 1131, 1130, ),
         ( 1059, 1060, 1131, ),
         ( 1060, 1132, 1131, ),
         ( 1060, 1061, 1132, ),
         ( 1061, 1133, 1132, ),
         ( 1061, 1062, 1133, ),
         ( 1062, 1134, 1133, ),
         ( 1062, 1063, 1134, ),
         ( 1063, 1135, 1134, ),
         ( 1063, 1064, 1135, ),
         ( 1064, 1136, 1135, ),
         ( 1064, 1065, 1136, ),
         ( 1065, 1137, 1136, ),
         ( 1065, 1066, 1137, ),
         ( 1066, 1138, 1137, ),
         ( 1066, 1067, 1138, ),
         ( 1067, 1139, 1138, ),
         ( 1067, 1068, 1139, ),
         ( 1068, 1140, 1139, ),
         ( 1068, 1069, 1140, ),
         ( 1069, 1141, 1140, ),
         ( 1069, 1070, 1141, ),
         ( 1070, 1142, 1141, ),
         ( 1070, 1071, 1142, ),
         ( 1071, 1143, 1142, ),
         ( 1071, 1072, 1143, ),
         ( 1072, 1144, 1143, ),
         ( 1072, 1073, 1144, ),
         ( 1073, 1145, 1144, ),
         ( 1073, 1074, 1145, ),
         ( 1074, 1146, 1145, ),
         ( 1074, 1075, 1146, ),
         ( 1075, 1147, 1146, ),
         ( 1075, 1076, 1147, ),
         ( 1076, 1148, 1147, ),
         ( 1076, 1077, 1148, ),
         ( 1077, 1149, 1148, ),
         ( 1077, 1078, 1149, ),
         ( 1078, 1150, 1149, ),
         ( 1078, 1079, 1150, ),
         ( 1079, 1151, 1150, ),
         ( 1079, 1008, 1151, ),
         ( 1008, 1080, 1151, ),
         ( 1080, 1081, 1153, ),
         ( 1080, 1153, 1152, ),
         ( 1081, 1082, 1154, ),
         ( 1081, 1154, 1153, ),
         ( 1082, 1083, 1155, ),
         ( 1082, 1155, 1154, ),
         ( 1083, 1084, 1156, ),
         ( 1083, 1156, 1155, ),
         ( 1084, 1085, 1157, ),
         ( 1084, 1157, 1156, ),
         ( 1085, 1086, 1158, ),
         ( 1085, 1158, 1157, ),
         ( 1086, 1087, 1159, ),
         ( 1086, 1159, 1158, ),
         ( 1087, 1088, 1160, ),
         ( 1087, 1160, 1159, ),
         ( 1088, 1089, 1161, ),
         ( 1088, 1161, 1160, ),
         ( 1089, 1090, 1162, ),
         ( 1089, 1162, 1161, ),
         ( 1090, 1091, 1163, ),
         ( 1090, 1163, 1162, ),
         ( 1091, 1092, 1164, ),
         ( 1091, 1164, 1163, ),
         ( 1092, 1093, 1165, ),
         ( 1092, 1165, 1164, ),
         ( 1093, 1094, 1166, ),
         ( 1093, 1166, 1165, ),
         ( 1094, 1095, 1167, ),
         ( 1094, 1167, 1166, ),
         ( 1095, 1096, 1168, ),
         ( 1095, 1168, 1167, ),
         ( 1096, 1097, 1169, ),
         ( 1096, 1169, 1168, ),
         ( 1097, 1098, 1170, ),
         ( 1097, 1170, 1169, ),
         ( 1098, 1099, 1171, ),
         ( 1098, 1171, 1170, ),
         ( 1099, 1100, 1172, ),
         ( 1099, 1172, 1171, ),
         ( 1100, 1101, 1173, ),
         ( 1100, 1173, 1172, ),
         ( 1101, 1102, 1174, ),
         ( 1101, 1174, 1173, ),
         ( 1102, 1103, 1175, ),
         ( 1102, 1175, 1174, ),
         ( 1103, 1104, 1176, ),
         ( 1103, 1176, 1175, ),
         ( 1104, 1105, 1177, ),
         ( 1104, 1177, 1176, ),
         ( 1105, 1106, 1178, ),
         ( 1105, 1178, 1177, ),
         ( 1106, 1107, 1179, ),
         ( 1106, 1179, 1178, ),
         ( 1107, 1108, 1180, ),
         ( 1107, 1180, 1179, ),
         ( 1108, 1109, 1181, ),
         ( 1108, 1181, 1180, ),
         ( 1109, 1110, 1182, ),
         ( 1109, 1182, 1181, ),
         ( 1110, 1111, 1183, ),
         ( 1110, 1183, 1182, ),
         ( 1111, 1112, 1184, ),
         ( 1111, 1184, 1183, ),
         ( 1112, 1113, 1185, ),
         ( 1112, 1185, 1184, ),
         ( 1113, 1114, 1186, ),
         ( 1113, 1186, 1185, ),
         ( 1114, 1115, 1187, ),
         ( 1114, 1187, 1186, ),
         ( 1115, 1116, 1188, ),
         ( 1115, 1188, 1187, ),
         ( 1116, 1117, 1189, ),
         ( 1116, 1189, 1188, ),
         ( 1117, 1118, 1190, ),
         ( 1117, 1190, 1189, ),
         ( 1118, 1119, 1191, ),
         ( 1118, 1191, 1190, ),
         ( 1119, 1120, 1192, ),
         ( 1119, 1192, 1191, ),
         ( 1120, 1121, 1193, ),
         ( 1120, 1193, 1192, ),
         ( 1121, 1122, 1194, ),
         ( 1121, 1194, 1193, ),
         ( 1122, 1123, 1195, ),
         ( 1122, 1195, 1194, ),
         ( 1123, 1124, 1196, ),
         ( 1123, 1196, 1195, ),
         ( 1124, 1125, 1197, ),
         ( 1124, 1197, 1196, ),
         ( 1125, 1126, 1198, ),
         ( 1125, 1198, 1197, ),
         ( 1126, 1127, 1199, ),
         ( 1126, 1199, 1198, ),
         ( 1127, 1128, 1200, ),
         ( 1127, 1200, 1199, ),
         ( 1128, 1129, 1201, ),
         ( 1128, 1201, 1200, ),
         ( 1129, 1130, 1202, ),
         ( 1129, 1202, 1201, ),
         ( 1130, 1131, 1203, ),
         ( 1130, 1203, 1202, ),
         ( 1131, 1132, 1204, ),
         ( 1131, 1204, 1203, ),
         ( 1132, 1133, 1205, ),
         ( 1132, 1205, 1204, ),
         ( 1133, 1134, 1206, ),
         ( 1133, 1206, 1205, ),
         ( 1134, 1135, 1207, ),
         ( 1134, 1207, 1206, ),
         ( 1135, 1136, 1208, ),
         ( 1135, 1208, 1207, ),
         ( 1136, 1137, 1209, ),
         ( 1136, 1209, 1208, ),
         ( 1137, 1138, 1210, ),
         ( 1137, 1210, 1209, ),
         ( 1138, 1139, 1211, ),
         ( 1138, 1211, 1210, ),
         ( 1139, 1140, 1212, ),
         ( 1139, 1212, 1211, ),
         ( 1140, 1141, 1213, ),
         ( 1140, 1213, 1212, ),
         ( 1141, 1142, 1214, ),
         ( 1141, 1214, 1213, ),
         ( 1142, 1143, 1215, ),
         ( 1142, 1215, 1214, ),
         ( 1143, 1144, 1216, ),
         ( 1143, 1216, 1215, ),
         ( 1144, 1145, 1217, ),
         ( 1144, 1217, 1216, ),
         ( 1145, 1146, 1218, ),
         ( 1145, 1218, 1217, ),
         ( 1146, 1147, 1219, ),
         ( 1146, 1219, 1218, ),
         ( 1147, 1148, 1220, ),
         ( 1147, 1220, 1219, ),
         ( 1148, 1149, 1221, ),
         ( 1148, 1221, 1220, ),
         ( 1149, 1150, 1222, ),
         ( 1149, 1222, 1221, ),
         ( 1150, 1151, 1223, ),
         ( 1150, 1223, 1222, ),
         ( 1151, 1080, 1152, ),
         ( 1151, 1152, 1223, ),
         ( 1152, 1153, 1224, ),
         ( 1153, 1225, 1224, ),
         ( 1153, 1154, 1225, ),
         ( 1154, 1226, 1225, ),
         ( 1154, 1155, 1226, ),
         ( 1155, 1227, 1226, ),
         ( 1155, 1156, 1227, ),
         ( 1156, 1228, 1227, ),
         ( 1156, 1157, 1228, ),
         ( 1157, 1229, 1228, ),
         ( 1157, 1158, 1229, ),
         ( 1158, 1230, 1229, ),
         ( 1158, 1159, 1230, ),
         ( 1159, 1231, 1230, ),
         ( 1159, 1160, 1231, ),
         ( 1160, 1232, 1231, ),
         ( 1160, 1161, 1232, ),
         ( 1161, 1233, 1232, ),
         ( 1161, 1162, 1233, ),
         ( 1162, 1234, 1233, ),
         ( 1162, 1163, 1234, ),
         ( 1163, 1235, 1234, ),
         ( 1163, 1164, 1235, ),
         ( 1164, 1236, 1235, ),
         ( 1164, 1165, 1236, ),
         ( 1165, 1237, 1236, ),
         ( 1165, 1166, 1237, ),
         ( 1166, 1238, 1237, ),
         ( 1166, 1167, 1238, ),
         ( 1167, 1239, 1238, ),
         ( 1167, 1168, 1239, ),
         ( 1168, 1240, 1239, ),
         ( 1168, 1169, 1240, ),
         ( 1169, 1241, 1240, ),
         ( 1169, 1170, 1241, ),
         ( 1170, 1242, 1241, ),
         ( 1170, 1171, 1242, ),
         ( 1171, 1243, 1242, ),
         ( 1171, 1172, 1243, ),
         ( 1172, 1244, 1243, ),
         ( 1172, 1173, 1244, ),
         ( 1173, 1245, 1244, ),
         ( 1173, 1174, 1245, ),
         ( 1174, 1246, 1245, ),
         ( 1174, 1175, 1246, ),
         ( 1175, 1247, 1246, ),
         ( 1175, 1176, 1247, ),
         ( 1176, 1248, 1247, ),
         ( 1176, 1177, 1248, ),
         ( 1177, 1249, 1248, ),
         ( 1177, 1178, 1249, ),
         ( 1178, 1250, 1249, ),
         ( 1178, 1179, 1250, ),
         ( 1179, 1251, 1250, ),
         ( 1179, 1180, 1251, ),
         ( 1180, 1252, 1251, ),
         ( 1180, 1181, 1252, ),
         ( 1181, 1253, 1252, ),
         ( 1181, 1182, 1253, ),
         ( 1182, 1254, 1253, ),
         ( 1182, 1183, 1254, ),
         ( 1183, 1255, 1254, ),
         ( 1183, 1184, 1255, ),
         ( 1184, 1256, 1255, ),
         ( 1184, 1185, 1256, ),
         ( 1185, 1257, 1256, ),
         ( 1185, 1186, 1257, ),
         ( 1186, 1258, 1257, ),
         ( 1186, 1187, 1258, ),
         ( 1187, 1259, 1258, ),
         ( 1187, 1188, 1259, ),
         ( 1188, 1260, 1259, ),
         ( 1188, 1189, 1260, ),
         ( 1189, 1261, 1260, ),
         ( 1189, 1190, 1261, ),
         ( 1190, 1262, 1261, ),
         ( 1190, 1191, 1262, ),
         ( 1191, 1263, 1262, ),
         ( 1191, 1192, 1263, ),
         ( 1192, 1264, 1263, ),
         ( 1192, 1193, 1264, ),
         ( 1193, 1265, 1264, ),
         ( 1193, 1194, 1265, ),
         ( 1194, 1266, 1265, ),
         ( 1194, 1195, 1266, ),
         ( 1195, 1267, 1266, ),
         ( 1195, 1196, 1267, ),
         ( 1196, 1268, 1267, ),
         ( 1196, 1197, 1268, ),
         ( 1197, 1269, 1268, ),
         ( 1197, 1198, 1269, ),
         ( 1198, 1270, 1269, ),
         ( 1198, 1199, 1270, ),
         ( 1199, 1271, 1270, ),
         ( 1199, 1200, 1271, ),
         ( 1200, 1272, 1271, ),
         ( 1200, 1201, 1272, ),
         ( 1201, 1273, 1272, ),
         ( 1201, 1202, 1273, ),
         ( 1202, 1274, 1273, ),
         ( 1202, 1203, 1274, ),
         ( 1203, 1275, 1274, ),
         ( 1203, 1204, 1275, ),
         ( 1204, 1276, 1275, ),
         ( 1204, 1205, 1276, ),
         ( 1205, 1277, 1276, ),
         ( 1205, 1206, 1277, ),
         ( 1206, 1278, 1277, ),
         ( 1206, 1207, 1278, ),
         ( 1207, 1279, 1278, ),
         ( 1207, 1208, 1279, ),
         ( 1208, 1280, 1279, ),
         ( 1208, 1209, 1280, ),
         ( 1209, 1281, 1280, ),
         ( 1209, 1210, 1281, ),
         ( 1210, 1282, 1281, ),
         ( 1210, 1211, 1282, ),
         ( 1211, 1283, 1282, ),
         ( 1211, 1212, 1283, ),
         ( 1212, 1284, 1283, ),
         ( 1212, 1213, 1284, ),
         ( 1213, 1285, 1284, ),
         ( 1213, 1214, 1285, ),
         ( 1214, 1286, 1285, ),
         ( 1214, 1215, 1286, ),
         ( 1215, 1287, 1286, ),
         ( 1215, 1216, 1287, ),
         ( 1216, 1288, 1287, ),
         ( 1216, 1217, 1288, ),
         ( 1217, 1289, 1288, ),
         ( 1217, 1218, 1289, ),
         ( 1218, 1290, 1289, ),
         ( 1218, 1219, 1290, ),
         ( 1219, 1291, 1290, ),
         ( 1219, 1220, 1291, ),
         ( 1220, 1292, 1291, ),
         ( 1220, 1221, 1292, ),
         ( 1221, 1293, 1292, ),
         ( 1221, 1222, 1293, ),
         ( 1222, 1294, 1293, ),
         ( 1222, 1223, 1294, ),
         ( 1223, 1295, 1294, ),
         ( 1223, 1152, 1295, ),
         ( 1152, 1224, 1295, ),
         ( 1224, 1225, 1297, ),
         ( 1224, 1297, 1296, ),
         ( 1225, 1226, 1298, ),
         ( 1225, 1298, 1297, ),
         ( 1226, 1227, 1299, ),
         ( 1226, 1299, 1298, ),
         ( 1227, 1228, 1300, ),
         ( 1227, 1300, 1299, ),
         ( 1228, 1229, 1301, ),
         ( 1228, 1301, 1300, ),
         ( 1229, 1230, 1302, ),
         ( 1229, 1302, 1301, ),
         ( 1230, 1231, 1303, ),
         ( 1230, 1303, 1302, ),
         ( 1231, 1232, 1304, ),
         ( 1231, 1304, 1303, ),
         ( 1232, 1233, 1305, ),
         ( 1232, 1305, 1304, ),
         ( 1233, 1234, 1306, ),
         ( 1233, 1306, 1305, ),
         ( 1234, 1235, 1307, ),
         ( 1234, 1307, 1306, ),
         ( 1235, 1236, 1308, ),
         ( 1235, 1308, 1307, ),
         ( 1236, 1237, 1309, ),
         ( 1236, 1309, 1308, ),
         ( 1237, 1238, 1310, ),
         ( 1237, 1310, 1309, ),
         ( 1238, 1239, 1311, ),
         ( 1238, 1311, 1310, ),
         ( 1239, 1240, 1312, ),
         ( 1239, 1312, 1311, ),
         ( 1240, 1241, 1313, ),
         ( 1240, 1313, 1312, ),
         ( 1241, 1242, 1314, ),
         ( 1241, 1314, 1313, ),
         ( 1242, 1243, 1315, ),
         ( 1242, 1315, 1314, ),
         ( 1243, 1244, 1316, ),
         ( 1243, 1316, 1315, ),
         ( 1244, 1245, 1317, ),
         ( 1244, 1317, 1316, ),
         ( 1245, 1246, 1318, ),
         ( 1245, 1318, 1317, ),
         ( 1246, 1247, 1319, ),
         ( 1246, 1319, 1318, ),
         ( 1247, 1248, 1320, ),
         ( 1247, 1320, 1319, ),
         ( 1248, 1249, 1321, ),
         ( 1248, 1321, 1320, ),
         ( 1249, 1250, 1322, ),
         ( 1249, 1322, 1321, ),
         ( 1250, 1251, 1323, ),
         ( 1250, 1323, 1322, ),
         ( 1251, 1252, 1324, ),
         ( 1251, 1324, 1323, ),
         ( 1252, 1253, 1325, ),
         ( 1252, 1325, 1324, ),
         ( 1253, 1254, 1326, ),
         ( 1253, 1326, 1325, ),
         ( 1254, 1255, 1327, ),
         ( 1254, 1327, 1326, ),
         ( 1255, 1256, 1328, ),
         ( 1255, 1328, 1327, ),
         ( 1256, 1257, 1329, ),
         ( 1256, 1329, 1328, ),
         ( 1257, 1258, 1330, ),
         ( 1257, 1330, 1329, ),
         ( 1258, 1259, 1331, ),
         ( 1258, 1331, 1330, ),
         ( 1259, 1260, 1332, ),
         ( 1259, 1332, 1331, ),
         ( 1260, 1261, 1333, ),
         ( 1260, 1333, 1332, ),
         ( 1261, 1262, 1334, ),
         ( 1261, 1334, 1333, ),
         ( 1262, 1263, 1335, ),
         ( 1262, 1335, 1334, ),
         ( 1263, 1264, 1336, ),
         ( 1263, 1336, 1335, ),
         ( 1264, 1265, 1337, ),
         ( 1264, 1337, 1336, ),
         ( 1265, 1266, 1338, ),
         ( 1265, 1338, 1337, ),
         ( 1266, 1267, 1339, ),
         ( 1266, 1339, 1338, ),
         ( 1267, 1268, 1340, ),
         ( 1267, 1340, 1339, ),
         ( 1268, 1269, 1341, ),
         ( 1268, 1341, 1340, ),
         ( 1269, 1270, 1342, ),
         ( 1269, 1342, 1341, ),
         ( 1270, 1271, 1343, ),
         ( 1270, 1343, 1342, ),
         ( 1271, 1272, 1344, ),
         ( 1271, 1344, 1343, ),
         ( 1272, 1273, 1345, ),
         ( 1272, 1345, 1344, ),
         ( 1273, 1274, 1346, ),
         ( 1273, 1346, 1345, ),
         ( 1274, 1275, 1347, ),
         ( 1274, 1347, 1346, ),
         ( 1275, 1276, 1348, ),
         ( 1275, 1348, 1347, ),
         ( 1276, 1277, 1349, ),
         ( 1276, 1349, 1348, ),
         ( 1277, 1278, 1350, ),
         ( 1277, 1350, 1349, ),
         ( 1278, 1279, 1351, ),
         ( 1278, 1351, 1350, ),
         ( 1279, 1280, 1352, ),
         ( 1279, 1352, 1351, ),
         ( 1280, 1281, 1353, ),
         ( 1280, 1353, 1352, ),
         ( 1281, 1282, 1354, ),
         ( 1281, 1354, 1353, ),
         ( 1282, 1283, 1355, ),
         ( 1282, 1355, 1354, ),
         ( 1283, 1284, 1356, ),
         ( 1283, 1356, 1355, ),
         ( 1284, 1285, 1357, ),
         ( 1284, 1357, 1356, ),
         ( 1285, 1286, 1358, ),
         ( 1285, 1358, 1357, ),
         ( 1286, 1287, 1359, ),
         ( 1286, 1359, 1358, ),
         ( 1287, 1288, 1360, ),
         ( 1287, 1360, 1359, ),
         ( 1288, 1289, 1361, ),
         ( 1288, 1361, 1360, ),
         ( 1289, 1290, 1362, ),
         ( 1289, 1362, 1361, ),
         ( 1290, 1291, 1363, ),
         ( 1290, 1363, 1362, ),
         ( 1291, 1292, 1364, ),
         ( 1291, 1364, 1363, ),
         ( 1292, 1293, 1365, ),
         ( 1292, 1365, 1364, ),
         ( 1293, 1294, 1366, ),
         ( 1293, 1366, 1365, ),
         ( 1294, 1295, 1367, ),
         ( 1294, 1367, 1366, ),
         ( 1295, 1224, 1296, ),
         ( 1295, 1296, 1367, ),
         ( 1296, 1297, 1368, ),
         ( 1297, 1369, 1368, ),
         ( 1297, 1298, 1369, ),
         ( 1298, 1370, 1369, ),
         ( 1298, 1299, 1370, ),
         ( 1299, 1371, 1370, ),
         ( 1299, 1300, 1371, ),
         ( 1300, 1372, 1371, ),
         ( 1300, 1301, 1372, ),
         ( 1301, 1373, 1372, ),
         ( 1301, 1302, 1373, ),
         ( 1302, 1374, 1373, ),
         ( 1302, 1303, 1374, ),
         ( 1303, 1375, 1374, ),
         ( 1303, 1304, 1375, ),
         ( 1304, 1376, 1375, ),
         ( 1304, 1305, 1376, ),
         ( 1305, 1377, 1376, ),
         ( 1305, 1306, 1377, ),
         ( 1306, 1378, 1377, ),
         ( 1306, 1307, 1378, ),
         ( 1307, 1379, 1378, ),
         ( 1307, 1308, 1379, ),
         ( 1308, 1380, 1379, ),
         ( 1308, 1309, 1380, ),
         ( 1309, 1381, 1380, ),
         ( 1309, 1310, 1381, ),
         ( 1310, 1382, 1381, ),
         ( 1310, 1311, 1382, ),
         ( 1311, 1383, 1382, ),
         ( 1311, 1312, 1383, ),
         ( 1312, 1384, 1383, ),
         ( 1312, 1313, 1384, ),
         ( 1313, 1385, 1384, ),
         ( 1313, 1314, 1385, ),
         ( 1314, 1386, 1385, ),
         ( 1314, 1315, 1386, ),
         ( 1315, 1387, 1386, ),
         ( 1315, 1316, 1387, ),
         ( 1316, 1388, 1387, ),
         ( 1316, 1317, 1388, ),
         ( 1317, 1389, 1388, ),
         ( 1317, 1318, 1389, ),
         ( 1318, 1390, 1389, ),
         ( 1318, 1319, 1390, ),
         ( 1319, 1391, 1390, ),
         ( 1319, 1320, 1391, ),
         ( 1320, 1392, 1391, ),
         ( 1320, 1321, 1392, ),
         ( 1321, 1393, 1392, ),
         ( 1321, 1322, 1393, ),
         ( 1322, 1394, 1393, ),
         ( 1322, 1323, 1394, ),
         ( 1323, 1395, 1394, ),
         ( 1323, 1324, 1395, ),
         ( 1324, 1396, 1395, ),
         ( 1324, 1325, 1396, ),
         ( 1325, 1397, 1396, ),
         ( 1325, 1326, 1397, ),
         ( 1326, 1398, 1397, ),
         ( 1326, 1327, 1398, ),
         ( 1327, 1399, 1398, ),
         ( 1327, 1328, 1399, ),
         ( 1328, 1400, 1399, ),
         ( 1328, 1329, 1400, ),
         ( 1329, 1401, 1400, ),
         ( 1329, 1330, 1401, ),
         ( 1330, 1402, 1401, ),
         ( 1330, 1331, 1402, ),
         ( 1331, 1403, 1402, ),
         ( 1331, 1332, 1403, ),
         ( 1332, 1404, 1403, ),
         ( 1332, 1333, 1404, ),
         ( 1333, 1405, 1404, ),
         ( 1333, 1334, 1405, ),
         ( 1334, 1406, 1405, ),
         ( 1334, 1335, 1406, ),
         ( 1335, 1407, 1406, ),
         ( 1335, 1336, 1407, ),
         ( 1336, 1408, 1407, ),
         ( 1336, 1337, 1408, ),
         ( 1337, 1409, 1408, ),
         ( 1337, 1338, 1409, ),
         ( 1338, 1410, 1409, ),
         ( 1338, 1339, 1410, ),
         ( 1339, 1411, 1410, ),
         ( 1339, 1340, 1411, ),
         ( 1340, 1412, 1411, ),
         ( 1340, 1341, 1412, ),
         ( 1341, 1413, 1412, ),
         ( 1341, 1342, 1413, ),
         ( 1342, 1414, 1413, ),
         ( 1342, 1343, 1414, ),
         ( 1343, 1415, 1414, ),
         ( 1343, 1344, 1415, ),
         ( 1344, 1416, 1415, ),
         ( 1344, 1345, 1416, ),
         ( 1345, 1417, 1416, ),
         ( 1345, 1346, 1417, ),
         ( 1346, 1418, 1417, ),
         ( 1346, 1347, 1418, ),
         ( 1347, 1419, 1418, ),
         ( 1347, 1348, 1419, ),
         ( 1348, 1420, 1419, ),
         ( 1348, 1349, 1420, ),
         ( 1349, 1421, 1420, ),
         ( 1349, 1350, 1421, ),
         ( 1350, 1422, 1421, ),
         ( 1350, 1351, 1422, ),
         ( 1351, 1423, 1422, ),
         ( 1351, 1352, 1423, ),
         ( 1352, 1424, 1423, ),
         ( 1352, 1353, 1424, ),
         ( 1353, 1425, 1424, ),
         ( 1353, 1354, 1425, ),
         ( 1354, 1426, 1425, ),
         ( 1354, 1355, 1426, ),
         ( 1355, 1427, 1426, ),
         ( 1355, 1356, 1427, ),
         ( 1356, 1428, 1427, ),
         ( 1356, 1357, 1428, ),
         ( 1357, 1429, 1428, ),
         ( 1357, 1358, 1429, ),
         ( 1358, 1430, 1429, ),
         ( 1358, 1359, 1430, ),
         ( 1359, 1431, 1430, ),
         ( 1359, 1360, 1431, ),
         ( 1360, 1432, 1431, ),
         ( 1360, 1361, 1432, ),
         ( 1361, 1433, 1432, ),
         ( 1361, 1362, 1433, ),
         ( 1362, 1434, 1433, ),
         ( 1362, 1363, 1434, ),
         ( 1363, 1435, 1434, ),
         ( 1363, 1364, 1435, ),
         ( 1364, 1436, 1435, ),
         ( 1364, 1365, 1436, ),
         ( 1365, 1437, 1436, ),
         ( 1365, 1366, 1437, ),
         ( 1366, 1438, 1437, ),
         ( 1366, 1367, 1438, ),
         ( 1367, 1439, 1438, ),
         ( 1367, 1296, 1439, ),
         ( 1296, 1368, 1439, ),
         ( 1368, 1369, 1441, ),
         ( 1368, 1441, 1440, ),
         ( 1369, 1370, 1442, ),
         ( 1369, 1442, 1441, ),
         ( 1370, 1371, 1443, ),
         ( 1370, 1443, 1442, ),
         ( 1371, 1372, 1444, ),
         ( 1371, 1444, 1443, ),
         ( 1372, 1373, 1445, ),
         ( 1372, 1445, 1444, ),
         ( 1373, 1374, 1446, ),
         ( 1373, 1446, 1445, ),
         ( 1374, 1375, 1447, ),
         ( 1374, 1447, 1446, ),
         ( 1375, 1376, 1448, ),
         ( 1375, 1448, 1447, ),
         ( 1376, 1377, 1449, ),
         ( 1376, 1449, 1448, ),
         ( 1377, 1378, 1450, ),
         ( 1377, 1450, 1449, ),
         ( 1378, 1379, 1451, ),
         ( 1378, 1451, 1450, ),
         ( 1379, 1380, 1452, ),
         ( 1379, 1452, 1451, ),
         ( 1380, 1381, 1453, ),
         ( 1380, 1453, 1452, ),
         ( 1381, 1382, 1454, ),
         ( 1381, 1454, 1453, ),
         ( 1382, 1383, 1455, ),
         ( 1382, 1455, 1454, ),
         ( 1383, 1384, 1456, ),
         ( 1383, 1456, 1455, ),
         ( 1384, 1385, 1457, ),
         ( 1384, 1457, 1456, ),
         ( 1385, 1386, 1458, ),
         ( 1385, 1458, 1457, ),
         ( 1386, 1387, 1459, ),
         ( 1386, 1459, 1458, ),
         ( 1387, 1388, 1460, ),
         ( 1387, 1460, 1459, ),
         ( 1388, 1389, 1461, ),
         ( 1388, 1461, 1460, ),
         ( 1389, 1390, 1462, ),
         ( 1389, 1462, 1461, ),
         ( 1390, 1391, 1463, ),
         ( 1390, 1463, 1462, ),
         ( 1391, 1392, 1464, ),
         ( 1391, 1464, 1463, ),
         ( 1392, 1393, 1465, ),
         ( 1392, 1465, 1464, ),
         ( 1393, 1394, 1466, ),
         ( 1393, 1466, 1465, ),
         ( 1394, 1395, 1467, ),
         ( 1394, 1467, 1466, ),
         ( 1395, 1396, 1468, ),
         ( 1395, 1468, 1467, ),
         ( 1396, 1397, 1469, ),
         ( 1396, 1469, 1468, ),
         ( 1397, 1398, 1470, ),
         ( 1397, 1470, 1469, ),
         ( 1398, 1399, 1471, ),
         ( 1398, 1471, 1470, ),
         ( 1399, 1400, 1472, ),
         ( 1399, 1472, 1471, ),
         ( 1400, 1401, 1473, ),
         ( 1400, 1473, 1472, ),
         ( 1401, 1402, 1474, ),
         ( 1401, 1474, 1473, ),
         ( 1402, 1403, 1475, ),
         ( 1402, 1475, 1474, ),
         ( 1403, 1404, 1476, ),
         ( 1403, 1476, 1475, ),
         ( 1404, 1405, 1477, ),
         ( 1404, 1477, 1476, ),
         ( 1405, 1406, 1478, ),
         ( 1405, 1478, 1477, ),
         ( 1406, 1407, 1479, ),
         ( 1406, 1479, 1478, ),
         ( 1407, 1408, 1480, ),
         ( 1407, 1480, 1479, ),
         ( 1408, 1409, 1481, ),
         ( 1408, 1481, 1480, ),
         ( 1409, 1410, 1482, ),
         ( 1409, 1482, 1481, ),
         ( 1410, 1411, 1483, ),
         ( 1410, 1483, 1482, ),
         ( 1411, 1412, 1484, ),
         ( 1411, 1484, 1483, ),
         ( 1412, 1413, 1485, ),
         ( 1412, 1485, 1484, ),
         ( 1413, 1414, 1486, ),
         ( 1413, 1486, 1485, ),
         ( 1414, 1415, 1487, ),
         ( 1414, 1487, 1486, ),
         ( 1415, 1416, 1488, ),
         ( 1415, 1488, 1487, ),
         ( 1416, 1417, 1489, ),
         ( 1416, 1489, 1488, ),
         ( 1417, 1418, 1490, ),
         ( 1417, 1490, 1489, ),
         ( 1418, 1419, 1491, ),
         ( 1418, 1491, 1490, ),
         ( 1419, 1420, 1492, ),
         ( 1419, 1492, 1491, ),
         ( 1420, 1421, 1493, ),
         ( 1420, 1493, 1492, ),
         ( 1421, 1422, 1494, ),
         ( 1421, 1494, 1493, ),
         ( 1422, 1423, 1495, ),
         ( 1422, 1495, 1494, ),
         ( 1423, 1424, 1496, ),
         ( 1423, 1496, 1495, ),
         ( 1424, 1425, 1497, ),
         ( 1424, 1497, 1496, ),
         ( 1425, 1426, 1498, ),
         ( 1425, 1498, 1497, ),
         ( 1426, 1427, 1499, ),
         ( 1426, 1499, 1498, ),
         ( 1427, 1428, 1500, ),
         ( 1427, 1500, 1499, ),
         ( 1428, 1429, 1501, ),
         ( 1428, 1501, 1500, ),
         ( 1429, 1430, 1502, ),
         ( 1429, 1502, 1501, ),
         ( 1430, 1431, 1503, ),
         ( 1430, 1503, 1502, ),
         ( 1431, 1432, 1504, ),
         ( 1431, 1504, 1503, ),
         ( 1432, 1433, 1505, ),
         ( 1432, 1505, 1504, ),
         ( 1433, 1434, 1506, ),
         ( 1433, 1506, 1505, ),
         ( 1434, 1435, 1507, ),
         ( 1434, 1507, 1506, ),
         ( 1435, 1436, 1508, ),
         ( 1435, 1508, 1507, ),
         ( 1436, 1437, 1509, ),
         ( 1436, 1509, 1508, ),
         ( 1437, 1438, 1510, ),
         ( 1437, 1510, 1509, ),
         ( 1438, 1439, 1511, ),
         ( 1438, 1511, 1510, ),
         ( 1439, 1368, 1440, ),
         ( 1439, 1440, 1511, ),
         ( 1440, 1441, 1512, ),
         ( 1441, 1513, 1512, ),
         ( 1441, 1442, 1513, ),
         ( 1442, 1514, 1513, ),
         ( 1442, 1443, 1514, ),
         ( 1443, 1515, 1514, ),
         ( 1443, 1444, 1515, ),
         ( 1444, 1516, 1515, ),
         ( 1444, 1445, 1516, ),
         ( 1445, 1517, 1516, ),
         ( 1445, 1446, 1517, ),
         ( 1446, 1518, 1517, ),
         ( 1446, 1447, 1518, ),
         ( 1447, 1519, 1518, ),
         ( 1447, 1448, 1519, ),
         ( 1448, 1520, 1519, ),
         ( 1448, 1449, 1520, ),
         ( 1449, 1521, 1520, ),
         ( 1449, 1450, 1521, ),
         ( 1450, 1522, 1521, ),
         ( 1450, 1451, 1522, ),
         ( 1451, 1523, 1522, ),
         ( 1451, 1452, 1523, ),
         ( 1452, 1524, 1523, ),
         ( 1452, 1453, 1524, ),
         ( 1453, 1525, 1524, ),
         ( 1453, 1454, 1525, ),
         ( 1454, 1526, 1525, ),
         ( 1454, 1455, 1526, ),
         ( 1455, 1527, 1526, ),
         ( 1455, 1456, 1527, ),
         ( 1456, 1528, 1527, ),
         ( 1456, 1457, 1528, ),
         ( 1457, 1529, 1528, ),
         ( 1457, 1458, 1529, ),
         ( 1458, 1530, 1529, ),
         ( 1458, 1459, 1530, ),
         ( 1459, 1531, 1530, ),
         ( 1459, 1460, 1531, ),
         ( 1460, 1532, 1531, ),
         ( 1460, 1461, 1532, ),
         ( 1461, 1533, 1532, ),
         ( 1461, 1462, 1533, ),
         ( 1462, 1534, 1533, ),
         ( 1462, 1463, 1534, ),
         ( 1463, 1535, 1534, ),
         ( 1463, 1464, 1535, ),
         ( 1464, 1536, 1535, ),
         ( 1464, 1465, 1536, ),
         ( 1465, 1537, 1536, ),
         ( 1465, 1466, 1537, ),
         ( 1466, 1538, 1537, ),
         ( 1466, 1467, 1538, ),
         ( 1467, 1539, 1538, ),
         ( 1467, 1468, 1539, ),
         ( 1468, 1540, 1539, ),
         ( 1468, 1469, 1540, ),
         ( 1469, 1541, 1540, ),
         ( 1469, 1470, 1541, ),
         ( 1470, 1542, 1541, ),
         ( 1470, 1471, 1542, ),
         ( 1471, 1543, 1542, ),
         ( 1471, 1472, 1543, ),
         ( 1472, 1544, 1543, ),
         ( 1472, 1473, 1544, ),
         ( 1473, 1545, 1544, ),
         ( 1473, 1474, 1545, ),
         ( 1474, 1546, 1545, ),
         ( 1474, 1475, 1546, ),
         ( 1475, 1547, 1546, ),
         ( 1475, 1476, 1547, ),
         ( 1476, 1548, 1547, ),
         ( 1476, 1477, 1548, ),
         ( 1477, 1549, 1548, ),
         ( 1477, 1478, 1549, ),
         ( 1478, 1550, 1549, ),
         ( 1478, 1479, 1550, ),
         ( 1479, 1551, 1550, ),
         ( 1479, 1480, 1551, ),
         ( 1480, 1552, 1551, ),
         ( 1480, 1481, 1552, ),
         ( 1481, 1553, 1552, ),
         ( 1481, 1482, 1553, ),
         ( 1482, 1554, 1553, ),
         ( 1482, 1483, 1554, ),
         ( 1483, 1555, 1554, ),
         ( 1483, 1484, 1555, ),
         ( 1484, 1556, 1555, ),
         ( 1484, 1485, 1556, ),
         ( 1485, 1557, 1556, ),
         ( 1485, 1486, 1557, ),
         ( 1486, 1558, 1557, ),
         ( 1486, 1487, 1558, ),
         ( 1487, 1559, 1558, ),
         ( 1487, 1488, 1559, ),
         ( 1488, 1560, 1559, ),
         ( 1488, 1489, 1560, ),
         ( 1489, 1561, 1560, ),
         ( 1489, 1490, 1561, ),
         ( 1490, 1562, 1561, ),
         ( 1490, 1491, 1562, ),
         ( 1491, 1563, 1562, ),
         ( 1491, 1492, 1563, ),
         ( 1492, 1564, 1563, ),
         ( 1492, 1493, 1564, ),
         ( 1493, 1565, 1564, ),
         ( 1493, 1494, 1565, ),
         ( 1494, 1566, 1565, ),
         ( 1494, 1495, 1566, ),
         ( 1495, 1567, 1566, ),
         ( 1495, 1496, 1567, ),
         ( 1496, 1568, 1567, ),
         ( 1496, 1497, 1568, ),
         ( 1497, 1569, 1568, ),
         ( 1497, 1498, 1569, ),
         ( 1498, 1570, 1569, ),
         ( 1498, 1499, 1570, ),
         ( 1499, 1571, 1570, ),
         ( 1499, 1500, 1571, ),
         ( 1500, 1572, 1571, ),
         ( 1500, 1501, 1572, ),
         ( 1501, 1573, 1572, ),
         ( 1501, 1502, 1573, ),
         ( 1502, 1574, 1573, ),
         ( 1502, 1503, 1574, ),
         ( 1503, 1575, 1574, ),
         ( 1503, 1504, 1575, ),
         ( 1504, 1576, 1575, ),
         ( 1504, 1505, 1576, ),
         ( 1505, 1577, 1576, ),
         ( 1505, 1506, 1577, ),
         ( 1506, 1578, 1577, ),
         ( 1506, 1507, 1578, ),
         ( 1507, 1579, 1578, ),
         ( 1507, 1508, 1579, ),
         ( 1508, 1580, 1579, ),
         ( 1508, 1509, 1580, ),
         ( 1509, 1581, 1580, ),
         ( 1509, 1510, 1581, ),
         ( 1510, 1582, 1581, ),
         ( 1510, 1511, 1582, ),
         ( 1511, 1583, 1582, ),
         ( 1511, 1440, 1583, ),
         ( 1440, 1512, 1583, ),
         ( 1512, 1513, 1585, ),
         ( 1512, 1585, 1584, ),
         ( 1513, 1514, 1586, ),
         ( 1513, 1586, 1585, ),
         ( 1514, 1515, 1587, ),
         ( 1514, 1587, 1586, ),
         ( 1515, 1516, 1588, ),
         ( 1515, 1588, 1587, ),
         ( 1516, 1517, 1589, ),
         ( 1516, 1589, 1588, ),
         ( 1517, 1518, 1590, ),
         ( 1517, 1590, 1589, ),
         ( 1518, 1519, 1591, ),
         ( 1518, 1591, 1590, ),
         ( 1519, 1520, 1592, ),
         ( 1519, 1592, 1591, ),
         ( 1520, 1521, 1593, ),
         ( 1520, 1593, 1592, ),
         ( 1521, 1522, 1594, ),
         ( 1521, 1594, 1593, ),
         ( 1522, 1523, 1595, ),
         ( 1522, 1595, 1594, ),
         ( 1523, 1524, 1596, ),
         ( 1523, 1596, 1595, ),
         ( 1524, 1525, 1597, ),
         ( 1524, 1597, 1596, ),
         ( 1525, 1526, 1598, ),
         ( 1525, 1598, 1597, ),
         ( 1526, 1527, 1599, ),
         ( 1526, 1599, 1598, ),
         ( 1527, 1528, 1600, ),
         ( 1527, 1600, 1599, ),
         ( 1528, 1529, 1601, ),
         ( 1528, 1601, 1600, ),
         ( 1529, 1530, 1602, ),
         ( 1529, 1602, 1601, ),
         ( 1530, 1531, 1603, ),
         ( 1530, 1603, 1602, ),
         ( 1531, 1532, 1604, ),
         ( 1531, 1604, 1603, ),
         ( 1532, 1533, 1605, ),
         ( 1532, 1605, 1604, ),
         ( 1533, 1534, 1606, ),
         ( 1533, 1606, 1605, ),
         ( 1534, 1535, 1607, ),
         ( 1534, 1607, 1606, ),
         ( 1535, 1536, 1608, ),
         ( 1535, 1608, 1607, ),
         ( 1536, 1537, 1609, ),
         ( 1536, 1609, 1608, ),
         ( 1537, 1538, 1610, ),
         ( 1537, 1610, 1609, ),
         ( 1538, 1539, 1611, ),
         ( 1538, 1611, 1610, ),
         ( 1539, 1540, 1612, ),
         ( 1539, 1612, 1611, ),
         ( 1540, 1541, 1613, ),
         ( 1540, 1613, 1612, ),
         ( 1541, 1542, 1614, ),
         ( 1541, 1614, 1613, ),
         ( 1542, 1543, 1615, ),
         ( 1542, 1615, 1614, ),
         ( 1543, 1544, 1616, ),
         ( 1543, 1616, 1615, ),
         ( 1544, 1545, 1617, ),
         ( 1544, 1617, 1616, ),
         ( 1545, 1546, 1618, ),
         ( 1545, 1618, 1617, ),
         ( 1546, 1547, 1619, ),
         ( 1546, 1619, 1618, ),
         ( 1547, 1548, 1620, ),
         ( 1547, 1620, 1619, ),
         ( 1548, 1549, 1621, ),
         ( 1548, 1621, 1620, ),
         ( 1549, 1550, 1622, ),
         ( 1549, 1622, 1621, ),
         ( 1550, 1551, 1623, ),
         ( 1550, 1623, 1622, ),
         ( 1551, 1552, 1624, ),
         ( 1551, 1624, 1623, ),
         ( 1552, 1553, 1625, ),
         ( 1552, 1625, 1624, ),
         ( 1553, 1554, 1626, ),
         ( 1553, 1626, 1625, ),
         ( 1554, 1555, 1627, ),
         ( 1554, 1627, 1626, ),
         ( 1555, 1556, 1628, ),
         ( 1555, 1628, 1627, ),
         ( 1556, 1557, 1629, ),
         ( 1556, 1629, 1628, ),
         ( 1557, 1558, 1630, ),
         ( 1557, 1630, 1629, ),
         ( 1558, 1559, 1631, ),
         ( 1558, 1631, 1630, ),
         ( 1559, 1560, 1632, ),
         ( 1559, 1632, 1631, ),
         ( 1560, 1561, 1633, ),
         ( 1560, 1633, 1632, ),
         ( 1561, 1562, 1634, ),
         ( 1561, 1634, 1633, ),
         ( 1562, 1563, 1635, ),
         ( 1562, 1635, 1634, ),
         ( 1563, 1564, 1636, ),
         ( 1563, 1636, 1635, ),
         ( 1564, 1565, 1637, ),
         ( 1564, 1637, 1636, ),
         ( 1565, 1566, 1638, ),
         ( 1565, 1638, 1637, ),
         ( 1566, 1567, 1639, ),
         ( 1566, 1639, 1638, ),
         ( 1567, 1568, 1640, ),
         ( 1567, 1640, 1639, ),
         ( 1568, 1569, 1641, ),
         ( 1568, 1641, 1640, ),
         ( 1569, 1570, 1642, ),
         ( 1569, 1642, 1641, ),
         ( 1570, 1571, 1643, ),
         ( 1570, 1643, 1642, ),
         ( 1571, 1572, 1644, ),
         ( 1571, 1644, 1643, ),
         ( 1572, 1573, 1645, ),
         ( 1572, 1645, 1644, ),
         ( 1573, 1574, 1646, ),
         ( 1573, 1646, 1645, ),
         ( 1574, 1575, 1647, ),
         ( 1574, 1647, 1646, ),
         ( 1575, 1576, 1648, ),
         ( 1575, 1648, 1647, ),
         ( 1576, 1577, 1649, ),
         ( 1576, 1649, 1648, ),
         ( 1577, 1578, 1650, ),
         ( 1577, 1650, 1649, ),
         ( 1578, 1579, 1651, ),
         ( 1578, 1651, 1650, ),
         ( 1579, 1580, 1652, ),
         ( 1579, 1652, 1651, ),
         ( 1580, 1581, 1653, ),
         ( 1580, 1653, 1652, ),
         ( 1581, 1582, 1654, ),
         ( 1581, 1654, 1653, ),
         ( 1582, 1583, 1655, ),
         ( 1582, 1655, 1654, ),
         ( 1583, 1512, 1584, ),
         ( 1583, 1584, 1655, ),
         ( 1584, 1585, 1656, ),
         ( 1585, 1657, 1656, ),
         ( 1585, 1586, 1657, ),
         ( 1586, 1658, 1657, ),
         ( 1586, 1587, 1658, ),
         ( 1587, 1659, 1658, ),
         ( 1587, 1588, 1659, ),
         ( 1588, 1660, 1659, ),
         ( 1588, 1589, 1660, ),
         ( 1589, 1661, 1660, ),
         ( 1589, 1590, 1661, ),
         ( 1590, 1662, 1661, ),
         ( 1590, 1591, 1662, ),
         ( 1591, 1663, 1662, ),
         ( 1591, 1592, 1663, ),
         ( 1592, 1664, 1663, ),
         ( 1592, 1593, 1664, ),
         ( 1593, 1665, 1664, ),
         ( 1593, 1594, 1665, ),
         ( 1594, 1666, 1665, ),
         ( 1594, 1595, 1666, ),
         ( 1595, 1667, 1666, ),
         ( 1595, 1596, 1667, ),
         ( 1596, 1668, 1667, ),
         ( 1596, 1597, 1668, ),
         ( 1597, 1669, 1668, ),
         ( 1597, 1598, 1669, ),
         ( 1598, 1670, 1669, ),
         ( 1598, 1599, 1670, ),
         ( 1599, 1671, 1670, ),
         ( 1599, 1600, 1671, ),
         ( 1600, 1672, 1671, ),
         ( 1600, 1601, 1672, ),
         ( 1601, 1673, 1672, ),
         ( 1601, 1602, 1673, ),
         ( 1602, 1674, 1673, ),
         ( 1602, 1603, 1674, ),
         ( 1603, 1675, 1674, ),
         ( 1603, 1604, 1675, ),
         ( 1604, 1676, 1675, ),
         ( 1604, 1605, 1676, ),
         ( 1605, 1677, 1676, ),
         ( 1605, 1606, 1677, ),
         ( 1606, 1678, 1677, ),
         ( 1606, 1607, 1678, ),
         ( 1607, 1679, 1678, ),
         ( 1607, 1608, 1679, ),
         ( 1608, 1680, 1679, ),
         ( 1608, 1609, 1680, ),
         ( 1609, 1681, 1680, ),
         ( 1609, 1610, 1681, ),
         ( 1610, 1682, 1681, ),
         ( 1610, 1611, 1682, ),
         ( 1611, 1683, 1682, ),
         ( 1611, 1612, 1683, ),
         ( 1612, 1684, 1683, ),
         ( 1612, 1613, 1684, ),
         ( 1613, 1685, 1684, ),
         ( 1613, 1614, 1685, ),
         ( 1614, 1686, 1685, ),
         ( 1614, 1615, 1686, ),
         ( 1615, 1687, 1686, ),
         ( 1615, 1616, 1687, ),
         ( 1616, 1688, 1687, ),
         ( 1616, 1617, 1688, ),
         ( 1617, 1689, 1688, ),
         ( 1617, 1618, 1689, ),
         ( 1618, 1690, 1689, ),
         ( 1618, 1619, 1690, ),
         ( 1619, 1691, 1690, ),
         ( 1619, 1620, 1691, ),
         ( 1620, 1692, 1691, ),
         ( 1620, 1621, 1692, ),
         ( 1621, 1693, 1692, ),
         ( 1621, 1622, 1693, ),
         ( 1622, 1694, 1693, ),
         ( 1622, 1623, 1694, ),
         ( 1623, 1695, 1694, ),
         ( 1623, 1624, 1695, ),
         ( 1624, 1696, 1695, ),
         ( 1624, 1625, 1696, ),
         ( 1625, 1697, 1696, ),
         ( 1625, 1626, 1697, ),
         ( 1626, 1698, 1697, ),
         ( 1626, 1627, 1698, ),
         ( 1627, 1699, 1698, ),
         ( 1627, 1628, 1699, ),
         ( 1628, 1700, 1699, ),
         ( 1628, 1629, 1700, ),
         ( 1629, 1701, 1700, ),
         ( 1629, 1630, 1701, ),
         ( 1630, 1702, 1701, ),
         ( 1630, 1631, 1702, ),
         ( 1631, 1703, 1702, ),
         ( 1631, 1632, 1703, ),
         ( 1632, 1704, 1703, ),
         ( 1632, 1633, 1704, ),
         ( 1633, 1705, 1704, ),
         ( 1633, 1634, 1705, ),
         ( 1634, 1706, 1705, ),
         ( 1634, 1635, 1706, ),
         ( 1635, 1707, 1706, ),
         ( 1635, 1636, 1707, ),
         ( 1636, 1708, 1707, ),
         ( 1636, 1637, 1708, ),
         ( 1637, 1709, 1708, ),
         ( 1637, 1638, 1709, ),
         ( 1638, 1710, 1709, ),
         ( 1638, 1639, 1710, ),
         ( 1639, 1711, 1710, ),
         ( 1639, 1640, 1711, ),
         ( 1640, 1712, 1711, ),
         ( 1640, 1641, 1712, ),
         ( 1641, 1713, 1712, ),
         ( 1641, 1642, 1713, ),
         ( 1642, 1714, 1713, ),
         ( 1642, 1643, 1714, ),
         ( 1643, 1715, 1714, ),
         ( 1643, 1644, 1715, ),
         ( 1644, 1716, 1715, ),
         ( 1644, 1645, 1716, ),
         ( 1645, 1717, 1716, ),
         ( 1645, 1646, 1717, ),
         ( 1646, 1718, 1717, ),
         ( 1646, 1647, 1718, ),
         ( 1647, 1719, 1718, ),
         ( 1647, 1648, 1719, ),
         ( 1648, 1720, 1719, ),
         ( 1648, 1649, 1720, ),
         ( 1649, 1721, 1720, ),
         ( 1649, 1650, 1721, ),
         ( 1650, 1722, 1721, ),
         ( 1650, 1651, 1722, ),
         ( 1651, 1723, 1722, ),
         ( 1651, 1652, 1723, ),
         ( 1652, 1724, 1723, ),
         ( 1652, 1653, 1724, ),
         ( 1653, 1725, 1724, ),
         ( 1653, 1654, 1725, ),
         ( 1654, 1726, 1725, ),
         ( 1654, 1655, 1726, ),
         ( 1655, 1727, 1726, ),
         ( 1655, 1584, 1727, ),
         ( 1584, 1656, 1727, ),
         ( 1656, 1657, 1729, ),
         ( 1656, 1729, 1728, ),
         ( 1657, 1658, 1730, ),
         ( 1657, 1730, 1729, ),
         ( 1658, 1659, 1731, ),
         ( 1658, 1731, 1730, ),
         ( 1659, 1660, 1732, ),
         ( 1659, 1732, 1731, ),
         ( 1660, 1661, 1733, ),
         ( 1660, 1733, 1732, ),
         ( 1661, 1662, 1734, ),
         ( 1661, 1734, 1733, ),
         ( 1662, 1663, 1735, ),
         ( 1662, 1735, 1734, ),
         ( 1663, 1664, 1736, ),
         ( 1663, 1736, 1735, ),
         ( 1664, 1665, 1737, ),
         ( 1664, 1737, 1736, ),
         ( 1665, 1666, 1738, ),
         ( 1665, 1738, 1737, ),
         ( 1666, 1667, 1739, ),
         ( 1666, 1739, 1738, ),
         ( 1667, 1668, 1740, ),
         ( 1667, 1740, 1739, ),
         ( 1668, 1669, 1741, ),
         ( 1668, 1741, 1740, ),
         ( 1669, 1670, 1742, ),
         ( 1669, 1742, 1741, ),
         ( 1670, 1671, 1743, ),
         ( 1670, 1743, 1742, ),
         ( 1671, 1672, 1744, ),
         ( 1671, 1744, 1743, ),
         ( 1672, 1673, 1745, ),
         ( 1672, 1745, 1744, ),
         ( 1673, 1674, 1746, ),
         ( 1673, 1746, 1745, ),
         ( 1674, 1675, 1747, ),
         ( 1674, 1747, 1746, ),
         ( 1675, 1676, 1748, ),
         ( 1675, 1748, 1747, ),
         ( 1676, 1677, 1749, ),
         ( 1676, 1749, 1748, ),
         ( 1677, 1678, 1750, ),
         ( 1677, 1750, 1749, ),
         ( 1678, 1679, 1751, ),
         ( 1678, 1751, 1750, ),
         ( 1679, 1680, 1752, ),
         ( 1679, 1752, 1751, ),
         ( 1680, 1681, 1753, ),
         ( 1680, 1753, 1752, ),
         ( 1681, 1682, 1754, ),
         ( 1681, 1754, 1753, ),
         ( 1682, 1683, 1755, ),
         ( 1682, 1755, 1754, ),
         ( 1683, 1684, 1756, ),
         ( 1683, 1756, 1755, ),
         ( 1684, 1685, 1757, ),
         ( 1684, 1757, 1756, ),
         ( 1685, 1686, 1758, ),
         ( 1685, 1758, 1757, ),
         ( 1686, 1687, 1759, ),
         ( 1686, 1759, 1758, ),
         ( 1687, 1688, 1760, ),
         ( 1687, 1760, 1759, ),
         ( 1688, 1689, 1761, ),
         ( 1688, 1761, 1760, ),
         ( 1689, 1690, 1762, ),
         ( 1689, 1762, 1761, ),
         ( 1690, 1691, 1763, ),
         ( 1690, 1763, 1762, ),
         ( 1691, 1692, 1764, ),
         ( 1691, 1764, 1763, ),
         ( 1692, 1693, 1765, ),
         ( 1692, 1765, 1764, ),
         ( 1693, 1694, 1766, ),
         ( 1693, 1766, 1765, ),
         ( 1694, 1695, 1767, ),
         ( 1694, 1767, 1766, ),
         ( 1695, 1696, 1768, ),
         ( 1695, 1768, 1767, ),
         ( 1696, 1697, 1769, ),
         ( 1696, 1769, 1768, ),
         ( 1697, 1698, 1770, ),
         ( 1697, 1770, 1769, ),
         ( 1698, 1699, 1771, ),
         ( 1698, 1771, 1770, ),
         ( 1699, 1700, 1772, ),
         ( 1699, 1772, 1771, ),
         ( 1700, 1701, 1773, ),
         ( 1700, 1773, 1772, ),
         ( 1701, 1702, 1774, ),
         ( 1701, 1774, 1773, ),
         ( 1702, 1703, 1775, ),
         ( 1702, 1775, 1774, ),
         ( 1703, 1704, 1776, ),
         ( 1703, 1776, 1775, ),
         ( 1704, 1705, 1777, ),
         ( 1704, 1777, 1776, ),
         ( 1705, 1706, 1778, ),
         ( 1705, 1778, 1777, ),
         ( 1706, 1707, 1779, ),
         ( 1706, 1779, 1778, ),
         ( 1707, 1708, 1780, ),
         ( 1707, 1780, 1779, ),
         ( 1708, 1709, 1781, ),
         ( 1708, 1781, 1780, ),
         ( 1709, 1710, 1782, ),
         ( 1709, 1782, 1781, ),
         ( 1710, 1711, 1783, ),
         ( 1710, 1783, 1782, ),
         ( 1711, 1712, 1784, ),
         ( 1711, 1784, 1783, ),
         ( 1712, 1713, 1785, ),
         ( 1712, 1785, 1784, ),
         ( 1713, 1714, 1786, ),
         ( 1713, 1786, 1785, ),
         ( 1714, 1715, 1787, ),
         ( 1714, 1787, 1786, ),
         ( 1715, 1716, 1788, ),
         ( 1715, 1788, 1787, ),
         ( 1716, 1717, 1789, ),
         ( 1716, 1789, 1788, ),
         ( 1717, 1718, 1790, ),
         ( 1717, 1790, 1789, ),
         ( 1718, 1719, 1791, ),
         ( 1718, 1791, 1790, ),
         ( 1719, 1720, 1792, ),
         ( 1719, 1792, 1791, ),
         ( 1720, 1721, 1793, ),
         ( 1720, 1793, 1792, ),
         ( 1721, 1722, 1794, ),
         ( 1721, 1794, 1793, ),
         ( 1722, 1723, 1795, ),
         ( 1722, 1795, 1794, ),
         ( 1723, 1724, 1796, ),
         ( 1723, 1796, 1795, ),
         ( 1724, 1725, 1797, ),
         ( 1724, 1797, 1796, ),
         ( 1725, 1726, 1798, ),
         ( 1725, 1798, 1797, ),
         ( 1726, 1727, 1799, ),
         ( 1726, 1799, 1798, ),
         ( 1727, 1656, 1728, ),
         ( 1727, 1728, 1799, ),
         ( 1728, 1729, 1800, ),
         ( 1729, 1801, 1800, ),
         ( 1729, 1730, 1801, ),
         ( 1730, 1802, 1801, ),
         ( 1730, 1731, 1802, ),
         ( 1731, 1803, 1802, ),
         ( 1731, 1732, 1803, ),
         ( 1732, 1804, 1803, ),
         ( 1732, 1733, 1804, ),
         ( 1733, 1805, 1804, ),
         ( 1733, 1734, 1805, ),
         ( 1734, 1806, 1805, ),
         ( 1734, 1735, 1806, ),
         ( 1735, 1807, 1806, ),
         ( 1735, 1736, 1807, ),
         ( 1736, 1808, 1807, ),
         ( 1736, 1737, 1808, ),
         ( 1737, 1809, 1808, ),
         ( 1737, 1738, 1809, ),
         ( 1738, 1810, 1809, ),
         ( 1738, 1739, 1810, ),
         ( 1739, 1811, 1810, ),
         ( 1739, 1740, 1811, ),
         ( 1740, 1812, 1811, ),
         ( 1740, 1741, 1812, ),
         ( 1741, 1813, 1812, ),
         ( 1741, 1742, 1813, ),
         ( 1742, 1814, 1813, ),
         ( 1742, 1743, 1814, ),
         ( 1743, 1815, 1814, ),
         ( 1743, 1744, 1815, ),
         ( 1744, 1816, 1815, ),
         ( 1744, 1745, 1816, ),
         ( 1745, 1817, 1816, ),
         ( 1745, 1746, 1817, ),
         ( 1746, 1818, 1817, ),
         ( 1746, 1747, 1818, ),
         ( 1747, 1819, 1818, ),
         ( 1747, 1748, 1819, ),
         ( 1748, 1820, 1819, ),
         ( 1748, 1749, 1820, ),
         ( 1749, 1821, 1820, ),
         ( 1749, 1750, 1821, ),
         ( 1750, 1822, 1821, ),
         ( 1750, 1751, 1822, ),
         ( 1751, 1823, 1822, ),
         ( 1751, 1752, 1823, ),
         ( 1752, 1824, 1823, ),
         ( 1752, 1753, 1824, ),
         ( 1753, 1825, 1824, ),
         ( 1753, 1754, 1825, ),
         ( 1754, 1826, 1825, ),
         ( 1754, 1755, 1826, ),
         ( 1755, 1827, 1826, ),
         ( 1755, 1756, 1827, ),
         ( 1756, 1828, 1827, ),
         ( 1756, 1757, 1828, ),
         ( 1757, 1829, 1828, ),
         ( 1757, 1758, 1829, ),
         ( 1758, 1830, 1829, ),
         ( 1758, 1759, 1830, ),
         ( 1759, 1831, 1830, ),
         ( 1759, 1760, 1831, ),
         ( 1760, 1832, 1831, ),
         ( 1760, 1761, 1832, ),
         ( 1761, 1833, 1832, ),
         ( 1761, 1762, 1833, ),
         ( 1762, 1834, 1833, ),
         ( 1762, 1763, 1834, ),
         ( 1763, 1835, 1834, ),
         ( 1763, 1764, 1835, ),
         ( 1764, 1836, 1835, ),
         ( 1764, 1765, 1836, ),
         ( 1765, 1837, 1836, ),
         ( 1765, 1766, 1837, ),
         ( 1766, 1838, 1837, ),
         ( 1766, 1767, 1838, ),
         ( 1767, 1839, 1838, ),
         ( 1767, 1768, 1839, ),
         ( 1768, 1840, 1839, ),
         ( 1768, 1769, 1840, ),
         ( 1769, 1841, 1840, ),
         ( 1769, 1770, 1841, ),
         ( 1770, 1842, 1841, ),
         ( 1770, 1771, 1842, ),
         ( 1771, 1843, 1842, ),
         ( 1771, 1772, 1843, ),
         ( 1772, 1844, 1843, ),
         ( 1772, 1773, 1844, ),
         ( 1773, 1845, 1844, ),
         ( 1773, 1774, 1845, ),
         ( 1774, 1846, 1845, ),
         ( 1774, 1775, 1846, ),
         ( 1775, 1847, 1846, ),
         ( 1775, 1776, 1847, ),
         ( 1776, 1848, 1847, ),
         ( 1776, 1777, 1848, ),
         ( 1777, 1849, 1848, ),
         ( 1777, 1778, 1849, ),
         ( 1778, 1850, 1849, ),
         ( 1778, 1779, 1850, ),
         ( 1779, 1851, 1850, ),
         ( 1779, 1780, 1851, ),
         ( 1780, 1852, 1851, ),
         ( 1780, 1781, 1852, ),
         ( 1781, 1853, 1852, ),
         ( 1781, 1782, 1853, ),
         ( 1782, 1854, 1853, ),
         ( 1782, 1783, 1854, ),
         ( 1783, 1855, 1854, ),
         ( 1783, 1784, 1855, ),
         ( 1784, 1856, 1855, ),
         ( 1784, 1785, 1856, ),
         ( 1785, 1857, 1856, ),
         ( 1785, 1786, 1857, ),
         ( 1786, 1858, 1857, ),
         ( 1786, 1787, 1858, ),
         ( 1787, 1859, 1858, ),
         ( 1787, 1788, 1859, ),
         ( 1788, 1860, 1859, ),
         ( 1788, 1789, 1860, ),
         ( 1789, 1861, 1860, ),
         ( 1789, 1790, 1861, ),
         ( 1790, 1862, 1861, ),
         ( 1790, 1791, 1862, ),
         ( 1791, 1863, 1862, ),
         ( 1791, 1792, 1863, ),
         ( 1792, 1864, 1863, ),
         ( 1792, 1793, 1864, ),
         ( 1793, 1865, 1864, ),
         ( 1793, 1794, 1865, ),
         ( 1794, 1866, 1865, ),
         ( 1794, 1795, 1866, ),
         ( 1795, 1867, 1866, ),
         ( 1795, 1796, 1867, ),
         ( 1796, 1868, 1867, ),
         ( 1796, 1797, 1868, ),
         ( 1797, 1869, 1868, ),
         ( 1797, 1798, 1869, ),
         ( 1798, 1870, 1869, ),
         ( 1798, 1799, 1870, ),
         ( 1799, 1871, 1870, ),
         ( 1799, 1728, 1871, ),
         ( 1728, 1800, 1871, ),
         ( 1800, 1801, 1873, ),
         ( 1800, 1873, 1872, ),
         ( 1801, 1802, 1874, ),
         ( 1801, 1874, 1873, ),
         ( 1802, 1803, 1875, ),
         ( 1802, 1875, 1874, ),
         ( 1803, 1804, 1876, ),
         ( 1803, 1876, 1875, ),
         ( 1804, 1805, 1877, ),
         ( 1804, 1877, 1876, ),
         ( 1805, 1806, 1878, ),
         ( 1805, 1878, 1877, ),
         ( 1806, 1807, 1879, ),
         ( 1806, 1879, 1878, ),
         ( 1807, 1808, 1880, ),
         ( 1807, 1880, 1879, ),
         ( 1808, 1809, 1881, ),
         ( 1808, 1881, 1880, ),
         ( 1809, 1810, 1882, ),
         ( 1809, 1882, 1881, ),
         ( 1810, 1811, 1883, ),
         ( 1810, 1883, 1882, ),
         ( 1811, 1812, 1884, ),
         ( 1811, 1884, 1883, ),
         ( 1812, 1813, 1885, ),
         ( 1812, 1885, 1884, ),
         ( 1813, 1814, 1886, ),
         ( 1813, 1886, 1885, ),
         ( 1814, 1815, 1887, ),
         ( 1814, 1887, 1886, ),
         ( 1815, 1816, 1888, ),
         ( 1815, 1888, 1887, ),
         ( 1816, 1817, 1889, ),
         ( 1816, 1889, 1888, ),
         ( 1817, 1818, 1890, ),
         ( 1817, 1890, 1889, ),
         ( 1818, 1819, 1891, ),
         ( 1818, 1891, 1890, ),
         ( 1819, 1820, 1892, ),
         ( 1819, 1892, 1891, ),
         ( 1820, 1821, 1893, ),
         ( 1820, 1893, 1892, ),
         ( 1821, 1822, 1894, ),
         ( 1821, 1894, 1893, ),
         ( 1822, 1823, 1895, ),
         ( 1822, 1895, 1894, ),
         ( 1823, 1824, 1896, ),
         ( 1823, 1896, 1895, ),
         ( 1824, 1825, 1897, ),
         ( 1824, 1897, 1896, ),
         ( 1825, 1826, 1898, ),
         ( 1825, 1898, 1897, ),
         ( 1826, 1827, 1899, ),
         ( 1826, 1899, 1898, ),
         ( 1827, 1828, 1900, ),
         ( 1827, 1900, 1899, ),
         ( 1828, 1829, 1901, ),
         ( 1828, 1901, 1900, ),
         ( 1829, 1830, 1902, ),
         ( 1829, 1902, 1901, ),
         ( 1830, 1831, 1903, ),
         ( 1830, 1903, 1902, ),
         ( 1831, 1832, 1904, ),
         ( 1831, 1904, 1903, ),
         ( 1832, 1833, 1905, ),
         ( 1832, 1905, 1904, ),
         ( 1833, 1834, 1906, ),
         ( 1833, 1906, 1905, ),
         ( 1834, 1835, 1907, ),
         ( 1834, 1907, 1906, ),
         ( 1835, 1836, 1908, ),
         ( 1835, 1908, 1907, ),
         ( 1836, 1837, 1909, ),
         ( 1836, 1909, 1908, ),
         ( 1837, 1838, 1910, ),
         ( 1837, 1910, 1909, ),
         ( 1838, 1839, 1911, ),
         ( 1838, 1911, 1910, ),
         ( 1839, 1840, 1912, ),
         ( 1839, 1912, 1911, ),
         ( 1840, 1841, 1913, ),
         ( 1840, 1913, 1912, ),
         ( 1841, 1842, 1914, ),
         ( 1841, 1914, 1913, ),
         ( 1842, 1843, 1915, ),
         ( 1842, 1915, 1914, ),
         ( 1843, 1844, 1916, ),
         ( 1843, 1916, 1915, ),
         ( 1844, 1845, 1917, ),
         ( 1844, 1917, 1916, ),
         ( 1845, 1846, 1918, ),
         ( 1845, 1918, 1917, ),
         ( 1846, 1847, 1919, ),
         ( 1846, 1919, 1918, ),
         ( 1847, 1848, 1920, ),
         ( 1847, 1920, 1919, ),
         ( 1848, 1849, 1921, ),
         ( 1848, 1921, 1920, ),
         ( 1849, 1850, 1922, ),
         ( 1849, 1922, 1921, ),
         ( 1850, 1851, 1923, ),
         ( 1850, 1923, 1922, ),
         ( 1851, 1852, 1924, ),
         ( 1851, 1924, 1923, ),
         ( 1852, 1853, 1925, ),
         ( 1852, 1925, 1924, ),
         ( 1853, 1854, 1926, ),
         ( 1853, 1926, 1925, ),
         ( 1854, 1855, 1927, ),
         ( 1854, 1927, 1926, ),
         ( 1855, 1856, 1928, ),
         ( 1855, 1928, 1927, ),
         ( 1856, 1857, 1929, ),
         ( 1856, 1929, 1928, ),
         ( 1857, 1858, 1930, ),
         ( 1857, 1930, 1929, ),
         ( 1858, 1859, 1931, ),
         ( 1858, 1931, 1930, ),
         ( 1859, 1860, 1932, ),
         ( 1859, 1932, 1931, ),
         ( 1860, 1861, 1933, ),
         ( 1860, 1933, 1932, ),
         ( 1861, 1862, 1934, ),
         ( 1861, 1934, 1933, ),
         ( 1862, 1863, 1935, ),
         ( 1862, 1935, 1934, ),
         ( 1863, 1864, 1936, ),
         ( 1863, 1936, 1935, ),
         ( 1864, 1865, 1937, ),
         ( 1864, 1937, 1936, ),
         ( 1865, 1866, 1938, ),
         ( 1865, 1938, 1937, ),
         ( 1866, 1867, 1939, ),
         ( 1866, 1939, 1938, ),
         ( 1867, 1868, 1940, ),
         ( 1867, 1940, 1939, ),
         ( 1868, 1869, 1941, ),
         ( 1868, 1941, 1940, ),
         ( 1869, 1870, 1942, ),
         ( 1869, 1942, 1941, ),
         ( 1870, 1871, 1943, ),
         ( 1870, 1943, 1942, ),
         ( 1871, 1800, 1872, ),
         ( 1871, 1872, 1943, ),
         ( 1872, 1873, 1944, ),
         ( 1873, 1945, 1944, ),
         ( 1873, 1874, 1945, ),
         ( 1874, 1946, 1945, ),
         ( 1874, 1875, 1946, ),
         ( 1875, 1947, 1946, ),
         ( 1875, 1876, 1947, ),
         ( 1876, 1948, 1947, ),
         ( 1876, 1877, 1948, ),
         ( 1877, 1949, 1948, ),
         ( 1877, 1878, 1949, ),
         ( 1878, 1950, 1949, ),
         ( 1878, 1879, 1950, ),
         ( 1879, 1951, 1950, ),
         ( 1879, 1880, 1951, ),
         ( 1880, 1952, 1951, ),
         ( 1880, 1881, 1952, ),
         ( 1881, 1953, 1952, ),
         ( 1881, 1882, 1953, ),
         ( 1882, 1954, 1953, ),
         ( 1882, 1883, 1954, ),
         ( 1883, 1955, 1954, ),
         ( 1883, 1884, 1955, ),
         ( 1884, 1956, 1955, ),
         ( 1884, 1885, 1956, ),
         ( 1885, 1957, 1956, ),
         ( 1885, 1886, 1957, ),
         ( 1886, 1958, 1957, ),
         ( 1886, 1887, 1958, ),
         ( 1887, 1959, 1958, ),
         ( 1887, 1888, 1959, ),
         ( 1888, 1960, 1959, ),
         ( 1888, 1889, 1960, ),
         ( 1889, 1961, 1960, ),
         ( 1889, 1890, 1961, ),
         ( 1890, 1962, 1961, ),
         ( 1890, 1891, 1962, ),
         ( 1891, 1963, 1962, ),
         ( 1891, 1892, 1963, ),
         ( 1892, 1964, 1963, ),
         ( 1892, 1893, 1964, ),
         ( 1893, 1965, 1964, ),
         ( 1893, 1894, 1965, ),
         ( 1894, 1966, 1965, ),
         ( 1894, 1895, 1966, ),
         ( 1895, 1967, 1966, ),
         ( 1895, 1896, 1967, ),
         ( 1896, 1968, 1967, ),
         ( 1896, 1897, 1968, ),
         ( 1897, 1969, 1968, ),
         ( 1897, 1898, 1969, ),
         ( 1898, 1970, 1969, ),
         ( 1898, 1899, 1970, ),
         ( 1899, 1971, 1970, ),
         ( 1899, 1900, 1971, ),
         ( 1900, 1972, 1971, ),
         ( 1900, 1901, 1972, ),
         ( 1901, 1973, 1972, ),
         ( 1901, 1902, 1973, ),
         ( 1902, 1974, 1973, ),
         ( 1902, 1903, 1974, ),
         ( 1903, 1975, 1974, ),
         ( 1903, 1904, 1975, ),
         ( 1904, 1976, 1975, ),
         ( 1904, 1905, 1976, ),
         ( 1905, 1977, 1976, ),
         ( 1905, 1906, 1977, ),
         ( 1906, 1978, 1977, ),
         ( 1906, 1907, 1978, ),
         ( 1907, 1979, 1978, ),
         ( 1907, 1908, 1979, ),
         ( 1908, 1980, 1979, ),
         ( 1908, 1909, 1980, ),
         ( 1909, 1981, 1980, ),
         ( 1909, 1910, 1981, ),
         ( 1910, 1982, 1981, ),
         ( 1910, 1911, 1982, ),
         ( 1911, 1983, 1982, ),
         ( 1911, 1912, 1983, ),
         ( 1912, 1984, 1983, ),
         ( 1912, 1913, 1984, ),
         ( 1913, 1985, 1984, ),
         ( 1913, 1914, 1985, ),
         ( 1914, 1986, 1985, ),
         ( 1914, 1915, 1986, ),
         ( 1915, 1987, 1986, ),
         ( 1915, 1916, 1987, ),
         ( 1916, 1988, 1987, ),
         ( 1916, 1917, 1988, ),
         ( 1917, 1989, 1988, ),
         ( 1917, 1918, 1989, ),
         ( 1918, 1990, 1989, ),
         ( 1918, 1919, 1990, ),
         ( 1919, 1991, 1990, ),
         ( 1919, 1920, 1991, ),
         ( 1920, 1992, 1991, ),
         ( 1920, 1921, 1992, ),
         ( 1921, 1993, 1992, ),
         ( 1921, 1922, 1993, ),
         ( 1922, 1994, 1993, ),
         ( 1922, 1923, 1994, ),
         ( 1923, 1995, 1994, ),
         ( 1923, 1924, 1995, ),
         ( 1924, 1996, 1995, ),
         ( 1924, 1925, 1996, ),
         ( 1925, 1997, 1996, ),
         ( 1925, 1926, 1997, ),
         ( 1926, 1998, 1997, ),
         ( 1926, 1927, 1998, ),
         ( 1927, 1999, 1998, ),
         ( 1927, 1928, 1999, ),
         ( 1928, 2000, 1999, ),
         ( 1928, 1929, 2000, ),
         ( 1929, 2001, 2000, ),
         ( 1929, 1930, 2001, ),
         ( 1930, 2002, 2001, ),
         ( 1930, 1931, 2002, ),
         ( 1931, 2003, 2002, ),
         ( 1931, 1932, 2003, ),
         ( 1932, 2004, 2003, ),
         ( 1932, 1933, 2004, ),
         ( 1933, 2005, 2004, ),
         ( 1933, 1934, 2005, ),
         ( 1934, 2006, 2005, ),
         ( 1934, 1935, 2006, ),
         ( 1935, 2007, 2006, ),
         ( 1935, 1936, 2007, ),
         ( 1936, 2008, 2007, ),
         ( 1936, 1937, 2008, ),
         ( 1937, 2009, 2008, ),
         ( 1937, 1938, 2009, ),
         ( 1938, 2010, 2009, ),
         ( 1938, 1939, 2010, ),
         ( 1939, 2011, 2010, ),
         ( 1939, 1940, 2011, ),
         ( 1940, 2012, 2011, ),
         ( 1940, 1941, 2012, ),
         ( 1941, 2013, 2012, ),
         ( 1941, 1942, 2013, ),
         ( 1942, 2014, 2013, ),
         ( 1942, 1943, 2014, ),
         ( 1943, 2015, 2014, ),
         ( 1943, 1872, 2015, ),
         ( 1872, 1944, 2015, ),
         ( 1944, 1945, 2017, ),
         ( 1944, 2017, 2016, ),
         ( 1945, 1946, 2018, ),
         ( 1945, 2018, 2017, ),
         ( 1946, 1947, 2019, ),
         ( 1946, 2019, 2018, ),
         ( 1947, 1948, 2020, ),
         ( 1947, 2020, 2019, ),
         ( 1948, 1949, 2021, ),
         ( 1948, 2021, 2020, ),
         ( 1949, 1950, 2022, ),
         ( 1949, 2022, 2021, ),
         ( 1950, 1951, 2023, ),
         ( 1950, 2023, 2022, ),
         ( 1951, 1952, 2024, ),
         ( 1951, 2024, 2023, ),
         ( 1952, 1953, 2025, ),
         ( 1952, 2025, 2024, ),
         ( 1953, 1954, 2026, ),
         ( 1953, 2026, 2025, ),
         ( 1954, 1955, 2027, ),
         ( 1954, 2027, 2026, ),
         ( 1955, 1956, 2028, ),
         ( 1955, 2028, 2027, ),
         ( 1956, 1957, 2029, ),
         ( 1956, 2029, 2028, ),
         ( 1957, 1958, 2030, ),
         ( 1957, 2030, 2029, ),
         ( 1958, 1959, 2031, ),
         ( 1958, 2031, 2030, ),
         ( 1959, 1960, 2032, ),
         ( 1959, 2032, 2031, ),
         ( 1960, 1961, 2033, ),
         ( 1960, 2033, 2032, ),
         ( 1961, 1962, 2034, ),
         ( 1961, 2034, 2033, ),
         ( 1962, 1963, 2035, ),
         ( 1962, 2035, 2034, ),
         ( 1963, 1964, 2036, ),
         ( 1963, 2036, 2035, ),
         ( 1964, 1965, 2037, ),
         ( 1964, 2037, 2036, ),
         ( 1965, 1966, 2038, ),
         ( 1965, 2038, 2037, ),
         ( 1966, 1967, 2039, ),
         ( 1966, 2039, 2038, ),
         ( 1967, 1968, 2040, ),
         ( 1967, 2040, 2039, ),
         ( 1968, 1969, 2041, ),
         ( 1968, 2041, 2040, ),
         ( 1969, 1970, 2042, ),
         ( 1969, 2042, 2041, ),
         ( 1970, 1971, 2043, ),
         ( 1970, 2043, 2042, ),
         ( 1971, 1972, 2044, ),
         ( 1971, 2044, 2043, ),
         ( 1972, 1973, 2045, ),
         ( 1972, 2045, 2044, ),
         ( 1973, 1974, 2046, ),
         ( 1973, 2046, 2045, ),
         ( 1974, 1975, 2047, ),
         ( 1974, 2047, 2046, ),
         ( 1975, 1976, 2048, ),
         ( 1975, 2048, 2047, ),
         ( 1976, 1977, 2049, ),
         ( 1976, 2049, 2048, ),
         ( 1977, 1978, 2050, ),
         ( 1977, 2050, 2049, ),
         ( 1978, 1979, 2051, ),
         ( 1978, 2051, 2050, ),
         ( 1979, 1980, 2052, ),
         ( 1979, 2052, 2051, ),
         ( 1980, 1981, 2053, ),
         ( 1980, 2053, 2052, ),
         ( 1981, 1982, 2054, ),
         ( 1981, 2054, 2053, ),
         ( 1982, 1983, 2055, ),
         ( 1982, 2055, 2054, ),
         ( 1983, 1984, 2056, ),
         ( 1983, 2056, 2055, ),
         ( 1984, 1985, 2057, ),
         ( 1984, 2057, 2056, ),
         ( 1985, 1986, 2058, ),
         ( 1985, 2058, 2057, ),
         ( 1986, 1987, 2059, ),
         ( 1986, 2059, 2058, ),
         ( 1987, 1988, 2060, ),
         ( 1987, 2060, 2059, ),
         ( 1988, 1989, 2061, ),
         ( 1988, 2061, 2060, ),
         ( 1989, 1990, 2062, ),
         ( 1989, 2062, 2061, ),
         ( 1990, 1991, 2063, ),
         ( 1990, 2063, 2062, ),
         ( 1991, 1992, 2064, ),
         ( 1991, 2064, 2063, ),
         ( 1992, 1993, 2065, ),
         ( 1992, 2065, 2064, ),
         ( 1993, 1994, 2066, ),
         ( 1993, 2066, 2065, ),
         ( 1994, 1995, 2067, ),
         ( 1994, 2067, 2066, ),
         ( 1995, 1996, 2068, ),
         ( 1995, 2068, 2067, ),
         ( 1996, 1997, 2069, ),
         ( 1996, 2069, 2068, ),
         ( 1997, 1998, 2070, ),
         ( 1997, 2070, 2069, ),
         ( 1998, 1999, 2071, ),
         ( 1998, 2071, 2070, ),
         ( 1999, 2000, 2072, ),
         ( 1999, 2072, 2071, ),
         ( 2000, 2001, 2073, ),
         ( 2000, 2073, 2072, ),
         ( 2001, 2002, 2074, ),
         ( 2001, 2074, 2073, ),
         ( 2002, 2003, 2075, ),
         ( 2002, 2075, 2074, ),
         ( 2003, 2004, 2076, ),
         ( 2003, 2076, 2075, ),
         ( 2004, 2005, 2077, ),
         ( 2004, 2077, 2076, ),
         ( 2005, 2006, 2078, ),
         ( 2005, 2078, 2077, ),
         ( 2006, 2007, 2079, ),
         ( 2006, 2079, 2078, ),
         ( 2007, 2008, 2080, ),
         ( 2007, 2080, 2079, ),
         ( 2008, 2009, 2081, ),
         ( 2008, 2081, 2080, ),
         ( 2009, 2010, 2082, ),
         ( 2009, 2082, 2081, ),
         ( 2010, 2011, 2083, ),
         ( 2010, 2083, 2082, ),
         ( 2011, 2012, 2084, ),
         ( 2011, 2084, 2083, ),
         ( 2012, 2013, 2085, ),
         ( 2012, 2085, 2084, ),
         ( 2013, 2014, 2086, ),
         ( 2013, 2086, 2085, ),
         ( 2014, 2015, 2087, ),
         ( 2014, 2087, 2086, ),
         ( 2015, 1944, 2016, ),
         ( 2015, 2016, 2087, ),
         ( 2016, 2017, 2088, ),
         ( 2017, 2089, 2088, ),
         ( 2017, 2018, 2089, ),
         ( 2018, 2090, 2089, ),
         ( 2018, 2019, 2090, ),
         ( 2019, 2091, 2090, ),
         ( 2019, 2020, 2091, ),
         ( 2020, 2092, 2091, ),
         ( 2020, 2021, 2092, ),
         ( 2021, 2093, 2092, ),
         ( 2021, 2022, 2093, ),
         ( 2022, 2094, 2093, ),
         ( 2022, 2023, 2094, ),
         ( 2023, 2095, 2094, ),
         ( 2023, 2024, 2095, ),
         ( 2024, 2096, 2095, ),
         ( 2024, 2025, 2096, ),
         ( 2025, 2097, 2096, ),
         ( 2025, 2026, 2097, ),
         ( 2026, 2098, 2097, ),
         ( 2026, 2027, 2098, ),
         ( 2027, 2099, 2098, ),
         ( 2027, 2028, 2099, ),
         ( 2028, 2100, 2099, ),
         ( 2028, 2029, 2100, ),
         ( 2029, 2101, 2100, ),
         ( 2029, 2030, 2101, ),
         ( 2030, 2102, 2101, ),
         ( 2030, 2031, 2102, ),
         ( 2031, 2103, 2102, ),
         ( 2031, 2032, 2103, ),
         ( 2032, 2104, 2103, ),
         ( 2032, 2033, 2104, ),
         ( 2033, 2105, 2104, ),
         ( 2033, 2034, 2105, ),
         ( 2034, 2106, 2105, ),
         ( 2034, 2035, 2106, ),
         ( 2035, 2107, 2106, ),
         ( 2035, 2036, 2107, ),
         ( 2036, 2108, 2107, ),
         ( 2036, 2037, 2108, ),
         ( 2037, 2109, 2108, ),
         ( 2037, 2038, 2109, ),
         ( 2038, 2110, 2109, ),
         ( 2038, 2039, 2110, ),
         ( 2039, 2111, 2110, ),
         ( 2039, 2040, 2111, ),
         ( 2040, 2112, 2111, ),
         ( 2040, 2041, 2112, ),
         ( 2041, 2113, 2112, ),
         ( 2041, 2042, 2113, ),
         ( 2042, 2114, 2113, ),
         ( 2042, 2043, 2114, ),
         ( 2043, 2115, 2114, ),
         ( 2043, 2044, 2115, ),
         ( 2044, 2116, 2115, ),
         ( 2044, 2045, 2116, ),
         ( 2045, 2117, 2116, ),
         ( 2045, 2046, 2117, ),
         ( 2046, 2118, 2117, ),
         ( 2046, 2047, 2118, ),
         ( 2047, 2119, 2118, ),
         ( 2047, 2048, 2119, ),
         ( 2048, 2120, 2119, ),
         ( 2048, 2049, 2120, ),
         ( 2049, 2121, 2120, ),
         ( 2049, 2050, 2121, ),
         ( 2050, 2122, 2121, ),
         ( 2050, 2051, 2122, ),
         ( 2051, 2123, 2122, ),
         ( 2051, 2052, 2123, ),
         ( 2052, 2124, 2123, ),
         ( 2052, 2053, 2124, ),
         ( 2053, 2125, 2124, ),
         ( 2053, 2054, 2125, ),
         ( 2054, 2126, 2125, ),
         ( 2054, 2055, 2126, ),
         ( 2055, 2127, 2126, ),
         ( 2055, 2056, 2127, ),
         ( 2056, 2128, 2127, ),
         ( 2056, 2057, 2128, ),
         ( 2057, 2129, 2128, ),
         ( 2057, 2058, 2129, ),
         ( 2058, 2130, 2129, ),
         ( 2058, 2059, 2130, ),
         ( 2059, 2131, 2130, ),
         ( 2059, 2060, 2131, ),
         ( 2060, 2132, 2131, ),
         ( 2060, 2061, 2132, ),
         ( 2061, 2133, 2132, ),
         ( 2061, 2062, 2133, ),
         ( 2062, 2134, 2133, ),
         ( 2062, 2063, 2134, ),
         ( 2063, 2135, 2134, ),
         ( 2063, 2064, 2135, ),
         ( 2064, 2136, 2135, ),
         ( 2064, 2065, 2136, ),
         ( 2065, 2137, 2136, ),
         ( 2065, 2066, 2137, ),
         ( 2066, 2138, 2137, ),
         ( 2066, 2067, 2138, ),
         ( 2067, 2139, 2138, ),
         ( 2067, 2068, 2139, ),
         ( 2068, 2140, 2139, ),
         ( 2068, 2069, 2140, ),
         ( 2069, 2141, 2140, ),
         ( 2069, 2070, 2141, ),
         ( 2070, 2142, 2141, ),
         ( 2070, 2071, 2142, ),
         ( 2071, 2143, 2142, ),
         ( 2071, 2072, 2143, ),
         ( 2072, 2144, 2143, ),
         ( 2072, 2073, 2144, ),
         ( 2073, 2145, 2144, ),
         ( 2073, 2074, 2145, ),
         ( 2074, 2146, 2145, ),
         ( 2074, 2075, 2146, ),
         ( 2075, 2147, 2146, ),
         ( 2075, 2076, 2147, ),
         ( 2076, 2148, 2147, ),
         ( 2076, 2077, 2148, ),
         ( 2077, 2149, 2148, ),
         ( 2077, 2078, 2149, ),
         ( 2078, 2150, 2149, ),
         ( 2078, 2079, 2150, ),
         ( 2079, 2151, 2150, ),
         ( 2079, 2080, 2151, ),
         ( 2080, 2152, 2151, ),
         ( 2080, 2081, 2152, ),
         ( 2081, 2153, 2152, ),
         ( 2081, 2082, 2153, ),
         ( 2082, 2154, 2153, ),
         ( 2082, 2083, 2154, ),
         ( 2083, 2155, 2154, ),
         ( 2083, 2084, 2155, ),
         ( 2084, 2156, 2155, ),
         ( 2084, 2085, 2156, ),
         ( 2085, 2157, 2156, ),
         ( 2085, 2086, 2157, ),
         ( 2086, 2158, 2157, ),
         ( 2086, 2087, 2158, ),
         ( 2087, 2159, 2158, ),
         ( 2087, 2016, 2159, ),
         ( 2016, 2088, 2159, ),
         ( 2160, 1, 0, ),
         ( 2160, 2, 1, ),
         ( 2160, 3, 2, ),
         ( 2160, 4, 3, ),
         ( 2160, 5, 4, ),
         ( 2160, 6, 5, ),
         ( 2160, 7, 6, ),
         ( 2160, 8, 7, ),
         ( 2160, 9, 8, ),
         ( 2160, 10, 9, ),
         ( 2160, 11, 10, ),
         ( 2160, 12, 11, ),
         ( 2160, 13, 12, ),
         ( 2160, 14, 13, ),
         ( 2160, 15, 14, ),
         ( 2160, 16, 15, ),
         ( 2160, 17, 16, ),
         ( 2160, 18, 17, ),
         ( 2160, 19, 18, ),
         ( 2160, 20, 19, ),
         ( 2160, 21, 20, ),
         ( 2160, 22, 21, ),
         ( 2160, 23, 22, ),
         ( 2160, 24, 23, ),
         ( 2160, 25, 24, ),
         ( 2160, 26, 25, ),
         ( 2160, 27, 26, ),
         ( 2160, 28, 27, ),
         ( 2160, 29, 28, ),
         ( 2160, 30, 29, ),
         ( 2160, 31, 30, ),
         ( 2160, 32, 31, ),
         ( 2160, 33, 32, ),
         ( 2160, 34, 33, ),
         ( 2160, 35, 34, ),
         ( 2160, 36, 35, ),
         ( 2160, 37, 36, ),
         ( 2160, 38, 37, ),
         ( 2160, 39, 38, ),
         ( 2160, 40, 39, ),
         ( 2160, 41, 40, ),
         ( 2160, 42, 41, ),
         ( 2160, 43, 42, ),
         ( 2160, 44, 43, ),
         ( 2160, 45, 44, ),
         ( 2160, 46, 45, ),
         ( 2160, 47, 46, ),
         ( 2160, 48, 47, ),
         ( 2160, 49, 48, ),
         ( 2160, 50, 49, ),
         ( 2160, 51, 50, ),
         ( 2160, 52, 51, ),
         ( 2160, 53, 52, ),
         ( 2160, 54, 53, ),
         ( 2160, 55, 54, ),
         ( 2160, 56, 55, ),
         ( 2160, 57, 56, ),
         ( 2160, 58, 57, ),
         ( 2160, 59, 58, ),
         ( 2160, 60, 59, ),
         ( 2160, 61, 60, ),
         ( 2160, 62, 61, ),
         ( 2160, 63, 62, ),
         ( 2160, 64, 63, ),
         ( 2160, 65, 64, ),
         ( 2160, 66, 65, ),
         ( 2160, 67, 66, ),
         ( 2160, 68, 67, ),
         ( 2160, 69, 68, ),
         ( 2160, 70, 69, ),
         ( 2160, 71, 70, ),
         ( 2160, 0, 71, ),
         ( 2161, 2088, 2089, ),
         ( 2161, 2089, 2090, ),
         ( 2161, 2090, 2091, ),
         ( 2161, 2091, 2092, ),
         ( 2161, 2092, 2093, ),
         ( 2161, 2093, 2094, ),
         ( 2161, 2094, 2095, ),
         ( 2161, 2095, 2096, ),
         ( 2161, 2096, 2097, ),
         ( 2161, 2097, 2098, ),
         ( 2161, 2098, 2099, ),
         ( 2161, 2099, 2100, ),
         ( 2161, 2100, 2101, ),
         ( 2161, 2101, 2102, ),
         ( 2161, 2102, 2103, ),
         ( 2161, 2103, 2104, ),
         ( 2161, 2104, 2105, ),
         ( 2161, 2105, 2106, ),
         ( 2161, 2106, 2107, ),
         ( 2161, 2107, 2108, ),
         ( 2161, 2108, 2109, ),
         ( 2161, 2109, 2110, ),
         ( 2161, 2110, 2111, ),
         ( 2161, 2111, 2112, ),
         ( 2161, 2112, 2113, ),
         ( 2161, 2113, 2114, ),
         ( 2161, 2114, 2115, ),
         ( 2161, 2115, 2116, ),
         ( 2161, 2116, 2117, ),
         ( 2161, 2117, 2118, ),
         ( 2161, 2118, 2119, ),
         ( 2161, 2119, 2120, ),
         ( 2161, 2120, 2121, ),
         ( 2161, 2121, 2122, ),
         ( 2161, 2122, 2123, ),
         ( 2161, 2123, 2124, ),
         ( 2161, 2124, 2125, ),
         ( 2161, 2125, 2126, ),
         ( 2161, 2126, 2127, ),
         ( 2161, 2127, 2128, ),
         ( 2161, 2128, 2129, ),
         ( 2161, 2129, 2130, ),
         ( 2161, 2130, 2131, ),
         ( 2161, 2131, 2132, ),
         ( 2161, 2132, 2133, ),
         ( 2161, 2133, 2134, ),
         ( 2161, 2134, 2135, ),
         ( 2161, 2135, 2136, ),
         ( 2161, 2136, 2137, ),
         ( 2161, 2137, 2138, ),
         ( 2161, 2138, 2139, ),
         ( 2161, 2139, 2140, ),
         ( 2161, 2140, 2141, ),
         ( 2161, 2141, 2142, ),
         ( 2161, 2142, 2143, ),
         ( 2161, 2143, 2144, ),
         ( 2161, 2144, 2145, ),
         ( 2161, 2145, 2146, ),
         ( 2161, 2146, 2147, ),
         ( 2161, 2147, 2148, ),
         ( 2161, 2148, 2149, ),
         ( 2161, 2149, 2150, ),
         ( 2161, 2150, 2151, ),
         ( 2161, 2151, 2152, ),
         ( 2161, 2152, 2153, ),
         ( 2161, 2153, 2154, ),
         ( 2161, 2154, 2155, ),
         ( 2161, 2155, 2156, ),
         ( 2161, 2156, 2157, ),
         ( 2161, 2157, 2158, ),
         ( 2161, 2158, 2159, ),
         ( 2161, 2159, 2088, ),
        ],
       'twoSidedLighting': True,
       'useLighting': True,
       'version': 2,
       'vertices': [
         (
          8.5,
          0.0,
          -9.5,
         ),
         (
          8.4676552,
          0.74082381,
          -9.5,
         ),
         (
          8.3708658,
          1.4760095,
          -9.5,
         ),
         (
          8.2103691,
          2.1999619,
          -9.5,
         ),
         (
          7.9873872,
          2.9071712,
          -9.5,
         ),
         (
          7.7036166,
          3.5922554,
          -9.5,
         ),
         (
          7.3612156,
          4.25,
          -9.5,
         ),
         (
          6.9627924,
          4.8753996,
          -9.5,
         ),
         (
          6.5113778,
          5.463695,
          -9.5,
         ),
         (
          6.0104074,
          6.0104074,
          -9.5,
         ),
         (
          5.463695,
          6.5113778,
          -9.5,
         ),
         (
          4.8753996,
          6.9627924,
          -9.5,
         ),
         (
          4.25,
          7.3612156,
          -9.5,
         ),
         (
          3.5922554,
          7.7036166,
          -9.5,
         ),
         (
          2.9071712,
          7.9873872,
          -9.5,
         ),
         (
          2.1999619,
          8.2103691,
          -9.5,
         ),
         (
          1.4760095,
          8.3708658,
          -9.5,
         ),
         (
          0.74082381,
          8.4676552,
          -9.5,
         ),
         (
          5.2047491e-16,
          8.5,
          -9.5,
         ),
         (
          -0.74082381,
          8.4676552,
          -9.5,
         ),
         (
          -1.4760095,
          8.3708658,
          -9.5,
         ),
         (
          -2.1999619,
          8.2103691,
          -9.5,
         ),
         (
          -2.9071712,
          7.9873872,
          -9.5,
         ),
         (
          -3.5922554,
          7.7036166,
          -9.5,
         ),
         (
          -4.25,
          7.3612156,
          -9.5,
         ),
         (
          -4.8753996,
          6.9627924,
          -9.5,
         ),
         (
          -5.463695,
          6.5113778,
          -9.5,
         ),
         (
          -6.0104074,
          6.0104074,
          -9.5,
         ),
         (
          -6.5113778,
          5.463695,
          -9.5,
         ),
         (
          -6.9627924,
          4.8753996,
          -9.5,
         ),
         (
          -7.3612156,
          4.25,
          -9.5,
         ),
         (
          -7.7036166,
          3.5922554,
          -9.5,
         ),
         (
          -7.9873872,
          2.9071712,
          -9.5,
         ),
         (
          -8.2103691,
          2.1999619,
          -9.5,
         ),
         (
          -8.3708658,
          1.4760095,
          -9.5,
         ),
         (
          -8.4676552,
          0.74082381,
          -9.5,
         ),
         (
          -8.5,
          1.0409498e-15,
          -9.5,
         ),
         (
          -8.4676552,
          -0.74082381,
          -9.5,
         ),
         (
          -8.3708658,
          -1.4760095,
          -9.5,
         ),
         (
          -8.2103691,
          -2.1999619,
          -9.5,
         ),
         (
          -7.9873872,
          -2.9071712,
          -9.5,
         ),
         (
          -7.7036166,
          -3.5922554,
          -9.5,
         ),
         (
          -7.3612156,
          -4.25,
          -9.5,
         ),
         (
          -6.9627924,
          -4.8753996,
          -9.5,
         ),
         (
          -6.5113778,
          -5.463695,
          -9.5,
         ),
         (
          -6.0104074,
          -6.0104074,
          -9.5,
         ),
         (
          -5.463695,
          -6.5113778,
          -9.5,
         ),
         (
          -4.8753996,
          -6.9627924,
          -9.5,
         ),
         (
          -4.25,
          -7.3612156,
          -9.5,
         ),
         (
          -3.5922554,
          -7.7036166,
          -9.5,
         ),
         (
          -2.9071712,
          -7.9873872,
          -9.5,
         ),
         (
          -2.1999619,
          -8.2103691,
          -9.5,
         ),
         (
          -1.4760095,
          -8.3708658,
          -9.5,
         ),
         (
          -0.74082381,
          -8.4676552,
          -9.5,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -9.5,
         ),
         (
          0.74082381,
          -8.4676552,
          -9.5,
         ),
         (
          1.4760095,
          -8.3708658,
          -9.5,
         ),
         (
          2.1999619,
          -8.2103691,
          -9.5,
         ),
         (
          2.9071712,
          -7.9873872,
          -9.5,
         ),
         (
          3.5922554,
          -7.7036166,
          -9.5,
         ),
         (
          4.25,
          -7.3612156,
          -9.5,
         ),
         (
          4.8753996,
          -6.9627924,
          -9.5,
         ),
         (
          5.463695,
          -6.5113778,
          -9.5,
         ),
         (
          6.0104074,
          -6.0104074,
          -9.5,
         ),
         (
          6.5113778,
          -5.463695,
          -9.5,
         ),
         (
          6.9627924,
          -4.8753996,
          -9.5,
         ),
         (
          7.3612156,
          -4.25,
          -9.5,
         ),
         (
          7.7036166,
          -3.5922554,
          -9.5,
         ),
         (
          7.9873872,
          -2.9071712,
          -9.5,
         ),
         (
          8.2103691,
          -2.1999619,
          -9.5,
         ),
         (
          8.3708658,
          -1.4760095,
          -9.5,
         ),
         (
          8.4676552,
          -0.74082381,
          -9.5,
         ),
         (
          8.49191,
          0.37076479,
          -8.8448277,
         ),
         (
          8.4272814,
          1.1094725,
          -8.8448277,
         ),
         (
          8.2985163,
          1.8397368,
          -8.8448277,
         ),
         (
          8.1065941,
          2.5559993,
          -8.8448277,
         ),
         (
          7.8529758,
          3.252809,
          -8.8448277,
         ),
         (
          7.5395918,
          3.9248631,
          -8.8448277,
         ),
         (
          7.1688271,
          4.5670471,
          -8.8448277,
         ),
         (
          6.7435031,
          5.1744723,
          -8.8448277,
         ),
         (
          6.2668571,
          5.742517,
          -8.8448277,
         ),
         (
          5.742517,
          6.2668571,
          -8.8448277,
         ),
         (
          5.1744723,
          6.7435031,
          -8.8448277,
         ),
         (
          4.5670471,
          7.1688271,
          -8.8448277,
         ),
         (
          3.9248631,
          7.5395918,
          -8.8448277,
         ),
         (
          3.252809,
          7.8529758,
          -8.8448277,
         ),
         (
          2.5559993,
          8.1065941,
          -8.8448277,
         ),
         (
          1.8397368,
          8.2985163,
          -8.8448277,
         ),
         (
          1.1094725,
          8.4272814,
          -8.8448277,
         ),
         (
          0.37076479,
          8.49191,
          -8.8448277,
         ),
         (
          -0.37076479,
          8.49191,
          -8.8448277,
         ),
         (
          -1.1094725,
          8.4272814,
          -8.8448277,
         ),
         (
          -1.8397368,
          8.2985163,
          -8.8448277,
         ),
         (
          -2.5559993,
          8.1065941,
          -8.8448277,
         ),
         (
          -3.252809,
          7.8529758,
          -8.8448277,
         ),
         (
          -3.9248631,
          7.5395918,
          -8.8448277,
         ),
         (
          -4.5670471,
          7.1688271,
          -8.8448277,
         ),
         (
          -5.1744723,
          6.7435031,
          -8.8448277,
         ),
         (
          -5.742517,
          6.2668571,
          -8.8448277,
         ),
         (
          -6.2668571,
          5.742517,
          -8.8448277,
         ),
         (
          -6.7435031,
          5.1744723,
          -8.8448277,
         ),
         (
          -7.1688271,
          4.5670471,
          -8.8448277,
         ),
         (
          -7.5395918,
          3.9248631,
          -8.8448277,
         ),
         (
          -7.8529758,
          3.252809,
          -8.8448277,
         ),
         (
          -8.1065941,
          2.5559993,
          -8.8448277,
         ),
         (
          -8.2985163,
          1.8397368,
          -8.8448277,
         ),
         (
          -8.4272814,
          1.1094725,
          -8.8448277,
         ),
         (
          -8.49191,
          0.37076479,
          -8.8448277,
         ),
         (
          -8.49191,
          -0.37076479,
          -8.8448277,
         ),
         (
          -8.4272814,
          -1.1094725,
          -8.8448277,
         ),
         (
          -8.2985163,
          -1.8397368,
          -8.8448277,
         ),
         (
          -8.1065941,
          -2.5559993,
          -8.8448277,
         ),
         (
          -7.8529758,
          -3.252809,
          -8.8448277,
         ),
         (
          -7.5395918,
          -3.9248631,
          -8.8448277,
         ),
         (
          -7.1688271,
          -4.5670471,
          -8.8448277,
         ),
         (
          -6.7435031,
          -5.1744723,
          -8.8448277,
         ),
         (
          -6.2668571,
          -5.742517,
          -8.8448277,
         ),
         (
          -5.742517,
          -6.2668571,
          -8.8448277,
         ),
         (
          -5.1744723,
          -6.7435031,
          -8.8448277,
         ),
         (
          -4.5670471,
          -7.1688271,
          -8.8448277,
         ),
         (
          -3.9248631,
          -7.5395918,
          -8.8448277,
         ),
         (
          -3.252809,
          -7.8529758,
          -8.8448277,
         ),
         (
          -2.5559993,
          -8.1065941,
          -8.8448277,
         ),
         (
          -1.8397368,
          -8.2985163,
          -8.8448277,
         ),
         (
          -1.1094725,
          -8.4272814,
          -8.8448277,
         ),
         (
          -0.37076479,
          -8.49191,
          -8.8448277,
         ),
         (
          0.37076479,
          -8.49191,
          -8.8448277,
         ),
         (
          1.1094725,
          -8.4272814,
          -8.8448277,
         ),
         (
          1.8397368,
          -8.2985163,
          -8.8448277,
         ),
         (
          2.5559993,
          -8.1065941,
          -8.8448277,
         ),
         (
          3.252809,
          -7.8529758,
          -8.8448277,
         ),
         (
          3.9248631,
          -7.5395918,
          -8.8448277,
         ),
         (
          4.5670471,
          -7.1688271,
          -8.8448277,
         ),
         (
          5.1744723,
          -6.7435031,
          -8.8448277,
         ),
         (
          5.742517,
          -6.2668571,
          -8.8448277,
         ),
         (
          6.2668571,
          -5.742517,
          -8.8448277,
         ),
         (
          6.7435031,
          -5.1744723,
          -8.8448277,
         ),
         (
          7.1688271,
          -4.5670471,
          -8.8448277,
         ),
         (
          7.5395918,
          -3.9248631,
          -8.8448277,
         ),
         (
          7.8529758,
          -3.252809,
          -8.8448277,
         ),
         (
          8.1065941,
          -2.5559993,
          -8.8448277,
         ),
         (
          8.2985163,
          -1.8397368,
          -8.8448277,
         ),
         (
          8.4272814,
          -1.1094725,
          -8.8448277,
         ),
         (
          8.49191,
          -0.37076479,
          -8.8448277,
         ),
         (
          8.5,
          0.0,
          -8.1896553,
         ),
         (
          8.4676552,
          0.74082381,
          -8.1896553,
         ),
         (
          8.3708658,
          1.4760095,
          -8.1896553,
         ),
         (
          8.2103691,
          2.1999619,
          -8.1896553,
         ),
         (
          7.9873872,
          2.9071712,
          -8.1896553,
         ),
         (
          7.7036166,
          3.5922554,
          -8.1896553,
         ),
         (
          7.3612156,
          4.25,
          -8.1896553,
         ),
         (
          6.9627924,
          4.8753996,
          -8.1896553,
         ),
         (
          6.5113778,
          5.463695,
          -8.1896553,
         ),
         (
          6.0104074,
          6.0104074,
          -8.1896553,
         ),
         (
          5.463695,
          6.5113778,
          -8.1896553,
         ),
         (
          4.8753996,
          6.9627924,
          -8.1896553,
         ),
         (
          4.25,
          7.3612156,
          -8.1896553,
         ),
         (
          3.5922554,
          7.7036166,
          -8.1896553,
         ),
         (
          2.9071712,
          7.9873872,
          -8.1896553,
         ),
         (
          2.1999619,
          8.2103691,
          -8.1896553,
         ),
         (
          1.4760095,
          8.3708658,
          -8.1896553,
         ),
         (
          0.74082381,
          8.4676552,
          -8.1896553,
         ),
         (
          5.2047491e-16,
          8.5,
          -8.1896553,
         ),
         (
          -0.74082381,
          8.4676552,
          -8.1896553,
         ),
         (
          -1.4760095,
          8.3708658,
          -8.1896553,
         ),
         (
          -2.1999619,
          8.2103691,
          -8.1896553,
         ),
         (
          -2.9071712,
          7.9873872,
          -8.1896553,
         ),
         (
          -3.5922554,
          7.7036166,
          -8.1896553,
         ),
         (
          -4.25,
          7.3612156,
          -8.1896553,
         ),
         (
          -4.8753996,
          6.9627924,
          -8.1896553,
         ),
         (
          -5.463695,
          6.5113778,
          -8.1896553,
         ),
         (
          -6.0104074,
          6.0104074,
          -8.1896553,
         ),
         (
          -6.5113778,
          5.463695,
          -8.1896553,
         ),
         (
          -6.9627924,
          4.8753996,
          -8.1896553,
         ),
         (
          -7.3612156,
          4.25,
          -8.1896553,
         ),
         (
          -7.7036166,
          3.5922554,
          -8.1896553,
         ),
         (
          -7.9873872,
          2.9071712,
          -8.1896553,
         ),
         (
          -8.2103691,
          2.1999619,
          -8.1896553,
         ),
         (
          -8.3708658,
          1.4760095,
          -8.1896553,
         ),
         (
          -8.4676552,
          0.74082381,
          -8.1896553,
         ),
         (
          -8.5,
          1.0409498e-15,
          -8.1896553,
         ),
         (
          -8.4676552,
          -0.74082381,
          -8.1896553,
         ),
         (
          -8.3708658,
          -1.4760095,
          -8.1896553,
         ),
         (
          -8.2103691,
          -2.1999619,
          -8.1896553,
         ),
         (
          -7.9873872,
          -2.9071712,
          -8.1896553,
         ),
         (
          -7.7036166,
          -3.5922554,
          -8.1896553,
         ),
         (
          -7.3612156,
          -4.25,
          -8.1896553,
         ),
         (
          -6.9627924,
          -4.8753996,
          -8.1896553,
         ),
         (
          -6.5113778,
          -5.463695,
          -8.1896553,
         ),
         (
          -6.0104074,
          -6.0104074,
          -8.1896553,
         ),
         (
          -5.463695,
          -6.5113778,
          -8.1896553,
         ),
         (
          -4.8753996,
          -6.9627924,
          -8.1896553,
         ),
         (
          -4.25,
          -7.3612156,
          -8.1896553,
         ),
         (
          -3.5922554,
          -7.7036166,
          -8.1896553,
         ),
         (
          -2.9071712,
          -7.9873872,
          -8.1896553,
         ),
         (
          -2.1999619,
          -8.2103691,
          -8.1896553,
         ),
         (
          -1.4760095,
          -8.3708658,
          -8.1896553,
         ),
         (
          -0.74082381,
          -8.4676552,
          -8.1896553,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -8.1896553,
         ),
         (
          0.74082381,
          -8.4676552,
          -8.1896553,
         ),
         (
          1.4760095,
          -8.3708658,
          -8.1896553,
         ),
         (
          2.1999619,
          -8.2103691,
          -8.1896553,
         ),
         (
          2.9071712,
          -7.9873872,
          -8.1896553,
         ),
         (
          3.5922554,
          -7.7036166,
          -8.1896553,
         ),
         (
          4.25,
          -7.3612156,
          -8.1896553,
         ),
         (
          4.8753996,
          -6.9627924,
          -8.1896553,
         ),
         (
          5.463695,
          -6.5113778,
          -8.1896553,
         ),
         (
          6.0104074,
          -6.0104074,
          -8.1896553,
         ),
         (
          6.5113778,
          -5.463695,
          -8.1896553,
         ),
         (
          6.9627924,
          -4.8753996,
          -8.1896553,
         ),
         (
          7.3612156,
          -4.25,
          -8.1896553,
         ),
         (
          7.7036166,
          -3.5922554,
          -8.1896553,
         ),
         (
          7.9873872,
          -2.9071712,
          -8.1896553,
         ),
         (
          8.2103691,
          -2.1999619,
          -8.1896553,
         ),
         (
          8.3708658,
          -1.4760095,
          -8.1896553,
         ),
         (
          8.4676552,
          -0.74082381,
          -8.1896553,
         ),
         (
          8.49191,
          0.37076479,
          -7.534483,
         ),
         (
          8.4272814,
          1.1094725,
          -7.534483,
         ),
         (
          8.2985163,
          1.8397368,
          -7.534483,
         ),
         (
          8.1065941,
          2.5559993,
          -7.534483,
         ),
         (
          7.8529758,
          3.252809,
          -7.534483,
         ),
         (
          7.5395918,
          3.9248631,
          -7.534483,
         ),
         (
          7.1688271,
          4.5670471,
          -7.534483,
         ),
         (
          6.7435031,
          5.1744723,
          -7.534483,
         ),
         (
          6.2668571,
          5.742517,
          -7.534483,
         ),
         (
          5.742517,
          6.2668571,
          -7.534483,
         ),
         (
          5.1744723,
          6.7435031,
          -7.534483,
         ),
         (
          4.5670471,
          7.1688271,
          -7.534483,
         ),
         (
          3.9248631,
          7.5395918,
          -7.534483,
         ),
         (
          3.252809,
          7.8529758,
          -7.534483,
         ),
         (
          2.5559993,
          8.1065941,
          -7.534483,
         ),
         (
          1.8397368,
          8.2985163,
          -7.534483,
         ),
         (
          1.1094725,
          8.4272814,
          -7.534483,
         ),
         (
          0.37076479,
          8.49191,
          -7.534483,
         ),
         (
          -0.37076479,
          8.49191,
          -7.534483,
         ),
         (
          -1.1094725,
          8.4272814,
          -7.534483,
         ),
         (
          -1.8397368,
          8.2985163,
          -7.534483,
         ),
         (
          -2.5559993,
          8.1065941,
          -7.534483,
         ),
         (
          -3.252809,
          7.8529758,
          -7.534483,
         ),
         (
          -3.9248631,
          7.5395918,
          -7.534483,
         ),
         (
          -4.5670471,
          7.1688271,
          -7.534483,
         ),
         (
          -5.1744723,
          6.7435031,
          -7.534483,
         ),
         (
          -5.742517,
          6.2668571,
          -7.534483,
         ),
         (
          -6.2668571,
          5.742517,
          -7.534483,
         ),
         (
          -6.7435031,
          5.1744723,
          -7.534483,
         ),
         (
          -7.1688271,
          4.5670471,
          -7.534483,
         ),
         (
          -7.5395918,
          3.9248631,
          -7.534483,
         ),
         (
          -7.8529758,
          3.252809,
          -7.534483,
         ),
         (
          -8.1065941,
          2.5559993,
          -7.534483,
         ),
         (
          -8.2985163,
          1.8397368,
          -7.534483,
         ),
         (
          -8.4272814,
          1.1094725,
          -7.534483,
         ),
         (
          -8.49191,
          0.37076479,
          -7.534483,
         ),
         (
          -8.49191,
          -0.37076479,
          -7.534483,
         ),
         (
          -8.4272814,
          -1.1094725,
          -7.534483,
         ),
         (
          -8.2985163,
          -1.8397368,
          -7.534483,
         ),
         (
          -8.1065941,
          -2.5559993,
          -7.534483,
         ),
         (
          -7.8529758,
          -3.252809,
          -7.534483,
         ),
         (
          -7.5395918,
          -3.9248631,
          -7.534483,
         ),
         (
          -7.1688271,
          -4.5670471,
          -7.534483,
         ),
         (
          -6.7435031,
          -5.1744723,
          -7.534483,
         ),
         (
          -6.2668571,
          -5.742517,
          -7.534483,
         ),
         (
          -5.742517,
          -6.2668571,
          -7.534483,
         ),
         (
          -5.1744723,
          -6.7435031,
          -7.534483,
         ),
         (
          -4.5670471,
          -7.1688271,
          -7.534483,
         ),
         (
          -3.9248631,
          -7.5395918,
          -7.534483,
         ),
         (
          -3.252809,
          -7.8529758,
          -7.534483,
         ),
         (
          -2.5559993,
          -8.1065941,
          -7.534483,
         ),
         (
          -1.8397368,
          -8.2985163,
          -7.534483,
         ),
         (
          -1.1094725,
          -8.4272814,
          -7.534483,
         ),
         (
          -0.37076479,
          -8.49191,
          -7.534483,
         ),
         (
          0.37076479,
          -8.49191,
          -7.534483,
         ),
         (
          1.1094725,
          -8.4272814,
          -7.534483,
         ),
         (
          1.8397368,
          -8.2985163,
          -7.534483,
         ),
         (
          2.5559993,
          -8.1065941,
          -7.534483,
         ),
         (
          3.252809,
          -7.8529758,
          -7.534483,
         ),
         (
          3.9248631,
          -7.5395918,
          -7.534483,
         ),
         (
          4.5670471,
          -7.1688271,
          -7.534483,
         ),
         (
          5.1744723,
          -6.7435031,
          -7.534483,
         ),
         (
          5.742517,
          -6.2668571,
          -7.534483,
         ),
         (
          6.2668571,
          -5.742517,
          -7.534483,
         ),
         (
          6.7435031,
          -5.1744723,
          -7.534483,
         ),
         (
          7.1688271,
          -4.5670471,
          -7.534483,
         ),
         (
          7.5395918,
          -3.9248631,
          -7.534483,
         ),
         (
          7.8529758,
          -3.252809,
          -7.534483,
         ),
         (
          8.1065941,
          -2.5559993,
          -7.534483,
         ),
         (
          8.2985163,
          -1.8397368,
          -7.534483,
         ),
         (
          8.4272814,
          -1.1094725,
          -7.534483,
         ),
         (
          8.49191,
          -0.37076479,
          -7.534483,
         ),
         (
          8.5,
          0.0,
          -6.8793101,
         ),
         (
          8.4676552,
          0.74082381,
          -6.8793101,
         ),
         (
          8.3708658,
          1.4760095,
          -6.8793101,
         ),
         (
          8.2103691,
          2.1999619,
          -6.8793101,
         ),
         (
          7.9873872,
          2.9071712,
          -6.8793101,
         ),
         (
          7.7036166,
          3.5922554,
          -6.8793101,
         ),
         (
          7.3612156,
          4.25,
          -6.8793101,
         ),
         (
          6.9627924,
          4.8753996,
          -6.8793101,
         ),
         (
          6.5113778,
          5.463695,
          -6.8793101,
         ),
         (
          6.0104074,
          6.0104074,
          -6.8793101,
         ),
         (
          5.463695,
          6.5113778,
          -6.8793101,
         ),
         (
          4.8753996,
          6.9627924,
          -6.8793101,
         ),
         (
          4.25,
          7.3612156,
          -6.8793101,
         ),
         (
          3.5922554,
          7.7036166,
          -6.8793101,
         ),
         (
          2.9071712,
          7.9873872,
          -6.8793101,
         ),
         (
          2.1999619,
          8.2103691,
          -6.8793101,
         ),
         (
          1.4760095,
          8.3708658,
          -6.8793101,
         ),
         (
          0.74082381,
          8.4676552,
          -6.8793101,
         ),
         (
          5.2047491e-16,
          8.5,
          -6.8793101,
         ),
         (
          -0.74082381,
          8.4676552,
          -6.8793101,
         ),
         (
          -1.4760095,
          8.3708658,
          -6.8793101,
         ),
         (
          -2.1999619,
          8.2103691,
          -6.8793101,
         ),
         (
          -2.9071712,
          7.9873872,
          -6.8793101,
         ),
         (
          -3.5922554,
          7.7036166,
          -6.8793101,
         ),
         (
          -4.25,
          7.3612156,
          -6.8793101,
         ),
         (
          -4.8753996,
          6.9627924,
          -6.8793101,
         ),
         (
          -5.463695,
          6.5113778,
          -6.8793101,
         ),
         (
          -6.0104074,
          6.0104074,
          -6.8793101,
         ),
         (
          -6.5113778,
          5.463695,
          -6.8793101,
         ),
         (
          -6.9627924,
          4.8753996,
          -6.8793101,
         ),
         (
          -7.3612156,
          4.25,
          -6.8793101,
         ),
         (
          -7.7036166,
          3.5922554,
          -6.8793101,
         ),
         (
          -7.9873872,
          2.9071712,
          -6.8793101,
         ),
         (
          -8.2103691,
          2.1999619,
          -6.8793101,
         ),
         (
          -8.3708658,
          1.4760095,
          -6.8793101,
         ),
         (
          -8.4676552,
          0.74082381,
          -6.8793101,
         ),
         (
          -8.5,
          1.0409498e-15,
          -6.8793101,
         ),
         (
          -8.4676552,
          -0.74082381,
          -6.8793101,
         ),
         (
          -8.3708658,
          -1.4760095,
          -6.8793101,
         ),
         (
          -8.2103691,
          -2.1999619,
          -6.8793101,
         ),
         (
          -7.9873872,
          -2.9071712,
          -6.8793101,
         ),
         (
          -7.7036166,
          -3.5922554,
          -6.8793101,
         ),
         (
          -7.3612156,
          -4.25,
          -6.8793101,
         ),
         (
          -6.9627924,
          -4.8753996,
          -6.8793101,
         ),
         (
          -6.5113778,
          -5.463695,
          -6.8793101,
         ),
         (
          -6.0104074,
          -6.0104074,
          -6.8793101,
         ),
         (
          -5.463695,
          -6.5113778,
          -6.8793101,
         ),
         (
          -4.8753996,
          -6.9627924,
          -6.8793101,
         ),
         (
          -4.25,
          -7.3612156,
          -6.8793101,
         ),
         (
          -3.5922554,
          -7.7036166,
          -6.8793101,
         ),
         (
          -2.9071712,
          -7.9873872,
          -6.8793101,
         ),
         (
          -2.1999619,
          -8.2103691,
          -6.8793101,
         ),
         (
          -1.4760095,
          -8.3708658,
          -6.8793101,
         ),
         (
          -0.74082381,
          -8.4676552,
          -6.8793101,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -6.8793101,
         ),
         (
          0.74082381,
          -8.4676552,
          -6.8793101,
         ),
         (
          1.4760095,
          -8.3708658,
          -6.8793101,
         ),
         (
          2.1999619,
          -8.2103691,
          -6.8793101,
         ),
         (
          2.9071712,
          -7.9873872,
          -6.8793101,
         ),
         (
          3.5922554,
          -7.7036166,
          -6.8793101,
         ),
         (
          4.25,
          -7.3612156,
          -6.8793101,
         ),
         (
          4.8753996,
          -6.9627924,
          -6.8793101,
         ),
         (
          5.463695,
          -6.5113778,
          -6.8793101,
         ),
         (
          6.0104074,
          -6.0104074,
          -6.8793101,
         ),
         (
          6.5113778,
          -5.463695,
          -6.8793101,
         ),
         (
          6.9627924,
          -4.8753996,
          -6.8793101,
         ),
         (
          7.3612156,
          -4.25,
          -6.8793101,
         ),
         (
          7.7036166,
          -3.5922554,
          -6.8793101,
         ),
         (
          7.9873872,
          -2.9071712,
          -6.8793101,
         ),
         (
          8.2103691,
          -2.1999619,
          -6.8793101,
         ),
         (
          8.3708658,
          -1.4760095,
          -6.8793101,
         ),
         (
          8.4676552,
          -0.74082381,
          -6.8793101,
         ),
         (
          8.49191,
          0.37076479,
          -6.2241378,
         ),
         (
          8.4272814,
          1.1094725,
          -6.2241378,
         ),
         (
          8.2985163,
          1.8397368,
          -6.2241378,
         ),
         (
          8.1065941,
          2.5559993,
          -6.2241378,
         ),
         (
          7.8529758,
          3.252809,
          -6.2241378,
         ),
         (
          7.5395918,
          3.9248631,
          -6.2241378,
         ),
         (
          7.1688271,
          4.5670471,
          -6.2241378,
         ),
         (
          6.7435031,
          5.1744723,
          -6.2241378,
         ),
         (
          6.2668571,
          5.742517,
          -6.2241378,
         ),
         (
          5.742517,
          6.2668571,
          -6.2241378,
         ),
         (
          5.1744723,
          6.7435031,
          -6.2241378,
         ),
         (
          4.5670471,
          7.1688271,
          -6.2241378,
         ),
         (
          3.9248631,
          7.5395918,
          -6.2241378,
         ),
         (
          3.252809,
          7.8529758,
          -6.2241378,
         ),
         (
          2.5559993,
          8.1065941,
          -6.2241378,
         ),
         (
          1.8397368,
          8.2985163,
          -6.2241378,
         ),
         (
          1.1094725,
          8.4272814,
          -6.2241378,
         ),
         (
          0.37076479,
          8.49191,
          -6.2241378,
         ),
         (
          -0.37076479,
          8.49191,
          -6.2241378,
         ),
         (
          -1.1094725,
          8.4272814,
          -6.2241378,
         ),
         (
          -1.8397368,
          8.2985163,
          -6.2241378,
         ),
         (
          -2.5559993,
          8.1065941,
          -6.2241378,
         ),
         (
          -3.252809,
          7.8529758,
          -6.2241378,
         ),
         (
          -3.9248631,
          7.5395918,
          -6.2241378,
         ),
         (
          -4.5670471,
          7.1688271,
          -6.2241378,
         ),
         (
          -5.1744723,
          6.7435031,
          -6.2241378,
         ),
         (
          -5.742517,
          6.2668571,
          -6.2241378,
         ),
         (
          -6.2668571,
          5.742517,
          -6.2241378,
         ),
         (
          -6.7435031,
          5.1744723,
          -6.2241378,
         ),
         (
          -7.1688271,
          4.5670471,
          -6.2241378,
         ),
         (
          -7.5395918,
          3.9248631,
          -6.2241378,
         ),
         (
          -7.8529758,
          3.252809,
          -6.2241378,
         ),
         (
          -8.1065941,
          2.5559993,
          -6.2241378,
         ),
         (
          -8.2985163,
          1.8397368,
          -6.2241378,
         ),
         (
          -8.4272814,
          1.1094725,
          -6.2241378,
         ),
         (
          -8.49191,
          0.37076479,
          -6.2241378,
         ),
         (
          -8.49191,
          -0.37076479,
          -6.2241378,
         ),
         (
          -8.4272814,
          -1.1094725,
          -6.2241378,
         ),
         (
          -8.2985163,
          -1.8397368,
          -6.2241378,
         ),
         (
          -8.1065941,
          -2.5559993,
          -6.2241378,
         ),
         (
          -7.8529758,
          -3.252809,
          -6.2241378,
         ),
         (
          -7.5395918,
          -3.9248631,
          -6.2241378,
         ),
         (
          -7.1688271,
          -4.5670471,
          -6.2241378,
         ),
         (
          -6.7435031,
          -5.1744723,
          -6.2241378,
         ),
         (
          -6.2668571,
          -5.742517,
          -6.2241378,
         ),
         (
          -5.742517,
          -6.2668571,
          -6.2241378,
         ),
         (
          -5.1744723,
          -6.7435031,
          -6.2241378,
         ),
         (
          -4.5670471,
          -7.1688271,
          -6.2241378,
         ),
         (
          -3.9248631,
          -7.5395918,
          -6.2241378,
         ),
         (
          -3.252809,
          -7.8529758,
          -6.2241378,
         ),
         (
          -2.5559993,
          -8.1065941,
          -6.2241378,
         ),
         (
          -1.8397368,
          -8.2985163,
          -6.2241378,
         ),
         (
          -1.1094725,
          -8.4272814,
          -6.2241378,
         ),
         (
          -0.37076479,
          -8.49191,
          -6.2241378,
         ),
         (
          0.37076479,
          -8.49191,
          -6.2241378,
         ),
         (
          1.1094725,
          -8.4272814,
          -6.2241378,
         ),
         (
          1.8397368,
          -8.2985163,
          -6.2241378,
         ),
         (
          2.5559993,
          -8.1065941,
          -6.2241378,
         ),
         (
          3.252809,
          -7.8529758,
          -6.2241378,
         ),
         (
          3.9248631,
          -7.5395918,
          -6.2241378,
         ),
         (
          4.5670471,
          -7.1688271,
          -6.2241378,
         ),
         (
          5.1744723,
          -6.7435031,
          -6.2241378,
         ),
         (
          5.742517,
          -6.2668571,
          -6.2241378,
         ),
         (
          6.2668571,
          -5.742517,
          -6.2241378,
         ),
         (
          6.7435031,
          -5.1744723,
          -6.2241378,
         ),
         (
          7.1688271,
          -4.5670471,
          -6.2241378,
         ),
         (
          7.5395918,
          -3.9248631,
          -6.2241378,
         ),
         (
          7.8529758,
          -3.252809,
          -6.2241378,
         ),
         (
          8.1065941,
          -2.5559993,
          -6.2241378,
         ),
         (
          8.2985163,
          -1.8397368,
          -6.2241378,
         ),
         (
          8.4272814,
          -1.1094725,
          -6.2241378,
         ),
         (
          8.49191,
          -0.37076479,
          -6.2241378,
         ),
         (
          8.5,
          0.0,
          -5.5689659,
         ),
         (
          8.4676552,
          0.74082381,
          -5.5689659,
         ),
         (
          8.3708658,
          1.4760095,
          -5.5689659,
         ),
         (
          8.2103691,
          2.1999619,
          -5.5689659,
         ),
         (
          7.9873872,
          2.9071712,
          -5.5689659,
         ),
         (
          7.7036166,
          3.5922554,
          -5.5689659,
         ),
         (
          7.3612156,
          4.25,
          -5.5689659,
         ),
         (
          6.9627924,
          4.8753996,
          -5.5689659,
         ),
         (
          6.5113778,
          5.463695,
          -5.5689659,
         ),
         (
          6.0104074,
          6.0104074,
          -5.5689659,
         ),
         (
          5.463695,
          6.5113778,
          -5.5689659,
         ),
         (
          4.8753996,
          6.9627924,
          -5.5689659,
         ),
         (
          4.25,
          7.3612156,
          -5.5689659,
         ),
         (
          3.5922554,
          7.7036166,
          -5.5689659,
         ),
         (
          2.9071712,
          7.9873872,
          -5.5689659,
         ),
         (
          2.1999619,
          8.2103691,
          -5.5689659,
         ),
         (
          1.4760095,
          8.3708658,
          -5.5689659,
         ),
         (
          0.74082381,
          8.4676552,
          -5.5689659,
         ),
         (
          5.2047491e-16,
          8.5,
          -5.5689659,
         ),
         (
          -0.74082381,
          8.4676552,
          -5.5689659,
         ),
         (
          -1.4760095,
          8.3708658,
          -5.5689659,
         ),
         (
          -2.1999619,
          8.2103691,
          -5.5689659,
         ),
         (
          -2.9071712,
          7.9873872,
          -5.5689659,
         ),
         (
          -3.5922554,
          7.7036166,
          -5.5689659,
         ),
         (
          -4.25,
          7.3612156,
          -5.5689659,
         ),
         (
          -4.8753996,
          6.9627924,
          -5.5689659,
         ),
         (
          -5.463695,
          6.5113778,
          -5.5689659,
         ),
         (
          -6.0104074,
          6.0104074,
          -5.5689659,
         ),
         (
          -6.5113778,
          5.463695,
          -5.5689659,
         ),
         (
          -6.9627924,
          4.8753996,
          -5.5689659,
         ),
         (
          -7.3612156,
          4.25,
          -5.5689659,
         ),
         (
          -7.7036166,
          3.5922554,
          -5.5689659,
         ),
         (
          -7.9873872,
          2.9071712,
          -5.5689659,
         ),
         (
          -8.2103691,
          2.1999619,
          -5.5689659,
         ),
         (
          -8.3708658,
          1.4760095,
          -5.5689659,
         ),
         (
          -8.4676552,
          0.74082381,
          -5.5689659,
         ),
         (
          -8.5,
          1.0409498e-15,
          -5.5689659,
         ),
         (
          -8.4676552,
          -0.74082381,
          -5.5689659,
         ),
         (
          -8.3708658,
          -1.4760095,
          -5.5689659,
         ),
         (
          -8.2103691,
          -2.1999619,
          -5.5689659,
         ),
         (
          -7.9873872,
          -2.9071712,
          -5.5689659,
         ),
         (
          -7.7036166,
          -3.5922554,
          -5.5689659,
         ),
         (
          -7.3612156,
          -4.25,
          -5.5689659,
         ),
         (
          -6.9627924,
          -4.8753996,
          -5.5689659,
         ),
         (
          -6.5113778,
          -5.463695,
          -5.5689659,
         ),
         (
          -6.0104074,
          -6.0104074,
          -5.5689659,
         ),
         (
          -5.463695,
          -6.5113778,
          -5.5689659,
         ),
         (
          -4.8753996,
          -6.9627924,
          -5.5689659,
         ),
         (
          -4.25,
          -7.3612156,
          -5.5689659,
         ),
         (
          -3.5922554,
          -7.7036166,
          -5.5689659,
         ),
         (
          -2.9071712,
          -7.9873872,
          -5.5689659,
         ),
         (
          -2.1999619,
          -8.2103691,
          -5.5689659,
         ),
         (
          -1.4760095,
          -8.3708658,
          -5.5689659,
         ),
         (
          -0.74082381,
          -8.4676552,
          -5.5689659,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -5.5689659,
         ),
         (
          0.74082381,
          -8.4676552,
          -5.5689659,
         ),
         (
          1.4760095,
          -8.3708658,
          -5.5689659,
         ),
         (
          2.1999619,
          -8.2103691,
          -5.5689659,
         ),
         (
          2.9071712,
          -7.9873872,
          -5.5689659,
         ),
         (
          3.5922554,
          -7.7036166,
          -5.5689659,
         ),
         (
          4.25,
          -7.3612156,
          -5.5689659,
         ),
         (
          4.8753996,
          -6.9627924,
          -5.5689659,
         ),
         (
          5.463695,
          -6.5113778,
          -5.5689659,
         ),
         (
          6.0104074,
          -6.0104074,
          -5.5689659,
         ),
         (
          6.5113778,
          -5.463695,
          -5.5689659,
         ),
         (
          6.9627924,
          -4.8753996,
          -5.5689659,
         ),
         (
          7.3612156,
          -4.25,
          -5.5689659,
         ),
         (
          7.7036166,
          -3.5922554,
          -5.5689659,
         ),
         (
          7.9873872,
          -2.9071712,
          -5.5689659,
         ),
         (
          8.2103691,
          -2.1999619,
          -5.5689659,
         ),
         (
          8.3708658,
          -1.4760095,
          -5.5689659,
         ),
         (
          8.4676552,
          -0.74082381,
          -5.5689659,
         ),
         (
          8.49191,
          0.37076479,
          -4.9137931,
         ),
         (
          8.4272814,
          1.1094725,
          -4.9137931,
         ),
         (
          8.2985163,
          1.8397368,
          -4.9137931,
         ),
         (
          8.1065941,
          2.5559993,
          -4.9137931,
         ),
         (
          7.8529758,
          3.252809,
          -4.9137931,
         ),
         (
          7.5395918,
          3.9248631,
          -4.9137931,
         ),
         (
          7.1688271,
          4.5670471,
          -4.9137931,
         ),
         (
          6.7435031,
          5.1744723,
          -4.9137931,
         ),
         (
          6.2668571,
          5.742517,
          -4.9137931,
         ),
         (
          5.742517,
          6.2668571,
          -4.9137931,
         ),
         (
          5.1744723,
          6.7435031,
          -4.9137931,
         ),
         (
          4.5670471,
          7.1688271,
          -4.9137931,
         ),
         (
          3.9248631,
          7.5395918,
          -4.9137931,
         ),
         (
          3.252809,
          7.8529758,
          -4.9137931,
         ),
         (
          2.5559993,
          8.1065941,
          -4.9137931,
         ),
         (
          1.8397368,
          8.2985163,
          -4.9137931,
         ),
         (
          1.1094725,
          8.4272814,
          -4.9137931,
         ),
         (
          0.37076479,
          8.49191,
          -4.9137931,
         ),
         (
          -0.37076479,
          8.49191,
          -4.9137931,
         ),
         (
          -1.1094725,
          8.4272814,
          -4.9137931,
         ),
         (
          -1.8397368,
          8.2985163,
          -4.9137931,
         ),
         (
          -2.5559993,
          8.1065941,
          -4.9137931,
         ),
         (
          -3.252809,
          7.8529758,
          -4.9137931,
         ),
         (
          -3.9248631,
          7.5395918,
          -4.9137931,
         ),
         (
          -4.5670471,
          7.1688271,
          -4.9137931,
         ),
         (
          -5.1744723,
          6.7435031,
          -4.9137931,
         ),
         (
          -5.742517,
          6.2668571,
          -4.9137931,
         ),
         (
          -6.2668571,
          5.742517,
          -4.9137931,
         ),
         (
          -6.7435031,
          5.1744723,
          -4.9137931,
         ),
         (
          -7.1688271,
          4.5670471,
          -4.9137931,
         ),
         (
          -7.5395918,
          3.9248631,
          -4.9137931,
         ),
         (
          -7.8529758,
          3.252809,
          -4.9137931,
         ),
         (
          -8.1065941,
          2.5559993,
          -4.9137931,
         ),
         (
          -8.2985163,
          1.8397368,
          -4.9137931,
         ),
         (
          -8.4272814,
          1.1094725,
          -4.9137931,
         ),
         (
          -8.49191,
          0.37076479,
          -4.9137931,
         ),
         (
          -8.49191,
          -0.37076479,
          -4.9137931,
         ),
         (
          -8.4272814,
          -1.1094725,
          -4.9137931,
         ),
         (
          -8.2985163,
          -1.8397368,
          -4.9137931,
         ),
         (
          -8.1065941,
          -2.5559993,
          -4.9137931,
         ),
         (
          -7.8529758,
          -3.252809,
          -4.9137931,
         ),
         (
          -7.5395918,
          -3.9248631,
          -4.9137931,
         ),
         (
          -7.1688271,
          -4.5670471,
          -4.9137931,
         ),
         (
          -6.7435031,
          -5.1744723,
          -4.9137931,
         ),
         (
          -6.2668571,
          -5.742517,
          -4.9137931,
         ),
         (
          -5.742517,
          -6.2668571,
          -4.9137931,
         ),
         (
          -5.1744723,
          -6.7435031,
          -4.9137931,
         ),
         (
          -4.5670471,
          -7.1688271,
          -4.9137931,
         ),
         (
          -3.9248631,
          -7.5395918,
          -4.9137931,
         ),
         (
          -3.252809,
          -7.8529758,
          -4.9137931,
         ),
         (
          -2.5559993,
          -8.1065941,
          -4.9137931,
         ),
         (
          -1.8397368,
          -8.2985163,
          -4.9137931,
         ),
         (
          -1.1094725,
          -8.4272814,
          -4.9137931,
         ),
         (
          -0.37076479,
          -8.49191,
          -4.9137931,
         ),
         (
          0.37076479,
          -8.49191,
          -4.9137931,
         ),
         (
          1.1094725,
          -8.4272814,
          -4.9137931,
         ),
         (
          1.8397368,
          -8.2985163,
          -4.9137931,
         ),
         (
          2.5559993,
          -8.1065941,
          -4.9137931,
         ),
         (
          3.252809,
          -7.8529758,
          -4.9137931,
         ),
         (
          3.9248631,
          -7.5395918,
          -4.9137931,
         ),
         (
          4.5670471,
          -7.1688271,
          -4.9137931,
         ),
         (
          5.1744723,
          -6.7435031,
          -4.9137931,
         ),
         (
          5.742517,
          -6.2668571,
          -4.9137931,
         ),
         (
          6.2668571,
          -5.742517,
          -4.9137931,
         ),
         (
          6.7435031,
          -5.1744723,
          -4.9137931,
         ),
         (
          7.1688271,
          -4.5670471,
          -4.9137931,
         ),
         (
          7.5395918,
          -3.9248631,
          -4.9137931,
         ),
         (
          7.8529758,
          -3.252809,
          -4.9137931,
         ),
         (
          8.1065941,
          -2.5559993,
          -4.9137931,
         ),
         (
          8.2985163,
          -1.8397368,
          -4.9137931,
         ),
         (
          8.4272814,
          -1.1094725,
          -4.9137931,
         ),
         (
          8.49191,
          -0.37076479,
          -4.9137931,
         ),
         (
          8.5,
          0.0,
          -4.2586207,
         ),
         (
          8.4676552,
          0.74082381,
          -4.2586207,
         ),
         (
          8.3708658,
          1.4760095,
          -4.2586207,
         ),
         (
          8.2103691,
          2.1999619,
          -4.2586207,
         ),
         (
          7.9873872,
          2.9071712,
          -4.2586207,
         ),
         (
          7.7036166,
          3.5922554,
          -4.2586207,
         ),
         (
          7.3612156,
          4.25,
          -4.2586207,
         ),
         (
          6.9627924,
          4.8753996,
          -4.2586207,
         ),
         (
          6.5113778,
          5.463695,
          -4.2586207,
         ),
         (
          6.0104074,
          6.0104074,
          -4.2586207,
         ),
         (
          5.463695,
          6.5113778,
          -4.2586207,
         ),
         (
          4.8753996,
          6.9627924,
          -4.2586207,
         ),
         (
          4.25,
          7.3612156,
          -4.2586207,
         ),
         (
          3.5922554,
          7.7036166,
          -4.2586207,
         ),
         (
          2.9071712,
          7.9873872,
          -4.2586207,
         ),
         (
          2.1999619,
          8.2103691,
          -4.2586207,
         ),
         (
          1.4760095,
          8.3708658,
          -4.2586207,
         ),
         (
          0.74082381,
          8.4676552,
          -4.2586207,
         ),
         (
          5.2047491e-16,
          8.5,
          -4.2586207,
         ),
         (
          -0.74082381,
          8.4676552,
          -4.2586207,
         ),
         (
          -1.4760095,
          8.3708658,
          -4.2586207,
         ),
         (
          -2.1999619,
          8.2103691,
          -4.2586207,
         ),
         (
          -2.9071712,
          7.9873872,
          -4.2586207,
         ),
         (
          -3.5922554,
          7.7036166,
          -4.2586207,
         ),
         (
          -4.25,
          7.3612156,
          -4.2586207,
         ),
         (
          -4.8753996,
          6.9627924,
          -4.2586207,
         ),
         (
          -5.463695,
          6.5113778,
          -4.2586207,
         ),
         (
          -6.0104074,
          6.0104074,
          -4.2586207,
         ),
         (
          -6.5113778,
          5.463695,
          -4.2586207,
         ),
         (
          -6.9627924,
          4.8753996,
          -4.2586207,
         ),
         (
          -7.3612156,
          4.25,
          -4.2586207,
         ),
         (
          -7.7036166,
          3.5922554,
          -4.2586207,
         ),
         (
          -7.9873872,
          2.9071712,
          -4.2586207,
         ),
         (
          -8.2103691,
          2.1999619,
          -4.2586207,
         ),
         (
          -8.3708658,
          1.4760095,
          -4.2586207,
         ),
         (
          -8.4676552,
          0.74082381,
          -4.2586207,
         ),
         (
          -8.5,
          1.0409498e-15,
          -4.2586207,
         ),
         (
          -8.4676552,
          -0.74082381,
          -4.2586207,
         ),
         (
          -8.3708658,
          -1.4760095,
          -4.2586207,
         ),
         (
          -8.2103691,
          -2.1999619,
          -4.2586207,
         ),
         (
          -7.9873872,
          -2.9071712,
          -4.2586207,
         ),
         (
          -7.7036166,
          -3.5922554,
          -4.2586207,
         ),
         (
          -7.3612156,
          -4.25,
          -4.2586207,
         ),
         (
          -6.9627924,
          -4.8753996,
          -4.2586207,
         ),
         (
          -6.5113778,
          -5.463695,
          -4.2586207,
         ),
         (
          -6.0104074,
          -6.0104074,
          -4.2586207,
         ),
         (
          -5.463695,
          -6.5113778,
          -4.2586207,
         ),
         (
          -4.8753996,
          -6.9627924,
          -4.2586207,
         ),
         (
          -4.25,
          -7.3612156,
          -4.2586207,
         ),
         (
          -3.5922554,
          -7.7036166,
          -4.2586207,
         ),
         (
          -2.9071712,
          -7.9873872,
          -4.2586207,
         ),
         (
          -2.1999619,
          -8.2103691,
          -4.2586207,
         ),
         (
          -1.4760095,
          -8.3708658,
          -4.2586207,
         ),
         (
          -0.74082381,
          -8.4676552,
          -4.2586207,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -4.2586207,
         ),
         (
          0.74082381,
          -8.4676552,
          -4.2586207,
         ),
         (
          1.4760095,
          -8.3708658,
          -4.2586207,
         ),
         (
          2.1999619,
          -8.2103691,
          -4.2586207,
         ),
         (
          2.9071712,
          -7.9873872,
          -4.2586207,
         ),
         (
          3.5922554,
          -7.7036166,
          -4.2586207,
         ),
         (
          4.25,
          -7.3612156,
          -4.2586207,
         ),
         (
          4.8753996,
          -6.9627924,
          -4.2586207,
         ),
         (
          5.463695,
          -6.5113778,
          -4.2586207,
         ),
         (
          6.0104074,
          -6.0104074,
          -4.2586207,
         ),
         (
          6.5113778,
          -5.463695,
          -4.2586207,
         ),
         (
          6.9627924,
          -4.8753996,
          -4.2586207,
         ),
         (
          7.3612156,
          -4.25,
          -4.2586207,
         ),
         (
          7.7036166,
          -3.5922554,
          -4.2586207,
         ),
         (
          7.9873872,
          -2.9071712,
          -4.2586207,
         ),
         (
          8.2103691,
          -2.1999619,
          -4.2586207,
         ),
         (
          8.3708658,
          -1.4760095,
          -4.2586207,
         ),
         (
          8.4676552,
          -0.74082381,
          -4.2586207,
         ),
         (
          8.49191,
          0.37076479,
          -3.6034482,
         ),
         (
          8.4272814,
          1.1094725,
          -3.6034482,
         ),
         (
          8.2985163,
          1.8397368,
          -3.6034482,
         ),
         (
          8.1065941,
          2.5559993,
          -3.6034482,
         ),
         (
          7.8529758,
          3.252809,
          -3.6034482,
         ),
         (
          7.5395918,
          3.9248631,
          -3.6034482,
         ),
         (
          7.1688271,
          4.5670471,
          -3.6034482,
         ),
         (
          6.7435031,
          5.1744723,
          -3.6034482,
         ),
         (
          6.2668571,
          5.742517,
          -3.6034482,
         ),
         (
          5.742517,
          6.2668571,
          -3.6034482,
         ),
         (
          5.1744723,
          6.7435031,
          -3.6034482,
         ),
         (
          4.5670471,
          7.1688271,
          -3.6034482,
         ),
         (
          3.9248631,
          7.5395918,
          -3.6034482,
         ),
         (
          3.252809,
          7.8529758,
          -3.6034482,
         ),
         (
          2.5559993,
          8.1065941,
          -3.6034482,
         ),
         (
          1.8397368,
          8.2985163,
          -3.6034482,
         ),
         (
          1.1094725,
          8.4272814,
          -3.6034482,
         ),
         (
          0.37076479,
          8.49191,
          -3.6034482,
         ),
         (
          -0.37076479,
          8.49191,
          -3.6034482,
         ),
         (
          -1.1094725,
          8.4272814,
          -3.6034482,
         ),
         (
          -1.8397368,
          8.2985163,
          -3.6034482,
         ),
         (
          -2.5559993,
          8.1065941,
          -3.6034482,
         ),
         (
          -3.252809,
          7.8529758,
          -3.6034482,
         ),
         (
          -3.9248631,
          7.5395918,
          -3.6034482,
         ),
         (
          -4.5670471,
          7.1688271,
          -3.6034482,
         ),
         (
          -5.1744723,
          6.7435031,
          -3.6034482,
         ),
         (
          -5.742517,
          6.2668571,
          -3.6034482,
         ),
         (
          -6.2668571,
          5.742517,
          -3.6034482,
         ),
         (
          -6.7435031,
          5.1744723,
          -3.6034482,
         ),
         (
          -7.1688271,
          4.5670471,
          -3.6034482,
         ),
         (
          -7.5395918,
          3.9248631,
          -3.6034482,
         ),
         (
          -7.8529758,
          3.252809,
          -3.6034482,
         ),
         (
          -8.1065941,
          2.5559993,
          -3.6034482,
         ),
         (
          -8.2985163,
          1.8397368,
          -3.6034482,
         ),
         (
          -8.4272814,
          1.1094725,
          -3.6034482,
         ),
         (
          -8.49191,
          0.37076479,
          -3.6034482,
         ),
         (
          -8.49191,
          -0.37076479,
          -3.6034482,
         ),
         (
          -8.4272814,
          -1.1094725,
          -3.6034482,
         ),
         (
          -8.2985163,
          -1.8397368,
          -3.6034482,
         ),
         (
          -8.1065941,
          -2.5559993,
          -3.6034482,
         ),
         (
          -7.8529758,
          -3.252809,
          -3.6034482,
         ),
         (
          -7.5395918,
          -3.9248631,
          -3.6034482,
         ),
         (
          -7.1688271,
          -4.5670471,
          -3.6034482,
         ),
         (
          -6.7435031,
          -5.1744723,
          -3.6034482,
         ),
         (
          -6.2668571,
          -5.742517,
          -3.6034482,
         ),
         (
          -5.742517,
          -6.2668571,
          -3.6034482,
         ),
         (
          -5.1744723,
          -6.7435031,
          -3.6034482,
         ),
         (
          -4.5670471,
          -7.1688271,
          -3.6034482,
         ),
         (
          -3.9248631,
          -7.5395918,
          -3.6034482,
         ),
         (
          -3.252809,
          -7.8529758,
          -3.6034482,
         ),
         (
          -2.5559993,
          -8.1065941,
          -3.6034482,
         ),
         (
          -1.8397368,
          -8.2985163,
          -3.6034482,
         ),
         (
          -1.1094725,
          -8.4272814,
          -3.6034482,
         ),
         (
          -0.37076479,
          -8.49191,
          -3.6034482,
         ),
         (
          0.37076479,
          -8.49191,
          -3.6034482,
         ),
         (
          1.1094725,
          -8.4272814,
          -3.6034482,
         ),
         (
          1.8397368,
          -8.2985163,
          -3.6034482,
         ),
         (
          2.5559993,
          -8.1065941,
          -3.6034482,
         ),
         (
          3.252809,
          -7.8529758,
          -3.6034482,
         ),
         (
          3.9248631,
          -7.5395918,
          -3.6034482,
         ),
         (
          4.5670471,
          -7.1688271,
          -3.6034482,
         ),
         (
          5.1744723,
          -6.7435031,
          -3.6034482,
         ),
         (
          5.742517,
          -6.2668571,
          -3.6034482,
         ),
         (
          6.2668571,
          -5.742517,
          -3.6034482,
         ),
         (
          6.7435031,
          -5.1744723,
          -3.6034482,
         ),
         (
          7.1688271,
          -4.5670471,
          -3.6034482,
         ),
         (
          7.5395918,
          -3.9248631,
          -3.6034482,
         ),
         (
          7.8529758,
          -3.252809,
          -3.6034482,
         ),
         (
          8.1065941,
          -2.5559993,
          -3.6034482,
         ),
         (
          8.2985163,
          -1.8397368,
          -3.6034482,
         ),
         (
          8.4272814,
          -1.1094725,
          -3.6034482,
         ),
         (
          8.49191,
          -0.37076479,
          -3.6034482,
         ),
         (
          8.5,
          0.0,
          -2.9482758,
         ),
         (
          8.4676552,
          0.74082381,
          -2.9482758,
         ),
         (
          8.3708658,
          1.4760095,
          -2.9482758,
         ),
         (
          8.2103691,
          2.1999619,
          -2.9482758,
         ),
         (
          7.9873872,
          2.9071712,
          -2.9482758,
         ),
         (
          7.7036166,
          3.5922554,
          -2.9482758,
         ),
         (
          7.3612156,
          4.25,
          -2.9482758,
         ),
         (
          6.9627924,
          4.8753996,
          -2.9482758,
         ),
         (
          6.5113778,
          5.463695,
          -2.9482758,
         ),
         (
          6.0104074,
          6.0104074,
          -2.9482758,
         ),
         (
          5.463695,
          6.5113778,
          -2.9482758,
         ),
         (
          4.8753996,
          6.9627924,
          -2.9482758,
         ),
         (
          4.25,
          7.3612156,
          -2.9482758,
         ),
         (
          3.5922554,
          7.7036166,
          -2.9482758,
         ),
         (
          2.9071712,
          7.9873872,
          -2.9482758,
         ),
         (
          2.1999619,
          8.2103691,
          -2.9482758,
         ),
         (
          1.4760095,
          8.3708658,
          -2.9482758,
         ),
         (
          0.74082381,
          8.4676552,
          -2.9482758,
         ),
         (
          5.2047491e-16,
          8.5,
          -2.9482758,
         ),
         (
          -0.74082381,
          8.4676552,
          -2.9482758,
         ),
         (
          -1.4760095,
          8.3708658,
          -2.9482758,
         ),
         (
          -2.1999619,
          8.2103691,
          -2.9482758,
         ),
         (
          -2.9071712,
          7.9873872,
          -2.9482758,
         ),
         (
          -3.5922554,
          7.7036166,
          -2.9482758,
         ),
         (
          -4.25,
          7.3612156,
          -2.9482758,
         ),
         (
          -4.8753996,
          6.9627924,
          -2.9482758,
         ),
         (
          -5.463695,
          6.5113778,
          -2.9482758,
         ),
         (
          -6.0104074,
          6.0104074,
          -2.9482758,
         ),
         (
          -6.5113778,
          5.463695,
          -2.9482758,
         ),
         (
          -6.9627924,
          4.8753996,
          -2.9482758,
         ),
         (
          -7.3612156,
          4.25,
          -2.9482758,
         ),
         (
          -7.7036166,
          3.5922554,
          -2.9482758,
         ),
         (
          -7.9873872,
          2.9071712,
          -2.9482758,
         ),
         (
          -8.2103691,
          2.1999619,
          -2.9482758,
         ),
         (
          -8.3708658,
          1.4760095,
          -2.9482758,
         ),
         (
          -8.4676552,
          0.74082381,
          -2.9482758,
         ),
         (
          -8.5,
          1.0409498e-15,
          -2.9482758,
         ),
         (
          -8.4676552,
          -0.74082381,
          -2.9482758,
         ),
         (
          -8.3708658,
          -1.4760095,
          -2.9482758,
         ),
         (
          -8.2103691,
          -2.1999619,
          -2.9482758,
         ),
         (
          -7.9873872,
          -2.9071712,
          -2.9482758,
         ),
         (
          -7.7036166,
          -3.5922554,
          -2.9482758,
         ),
         (
          -7.3612156,
          -4.25,
          -2.9482758,
         ),
         (
          -6.9627924,
          -4.8753996,
          -2.9482758,
         ),
         (
          -6.5113778,
          -5.463695,
          -2.9482758,
         ),
         (
          -6.0104074,
          -6.0104074,
          -2.9482758,
         ),
         (
          -5.463695,
          -6.5113778,
          -2.9482758,
         ),
         (
          -4.8753996,
          -6.9627924,
          -2.9482758,
         ),
         (
          -4.25,
          -7.3612156,
          -2.9482758,
         ),
         (
          -3.5922554,
          -7.7036166,
          -2.9482758,
         ),
         (
          -2.9071712,
          -7.9873872,
          -2.9482758,
         ),
         (
          -2.1999619,
          -8.2103691,
          -2.9482758,
         ),
         (
          -1.4760095,
          -8.3708658,
          -2.9482758,
         ),
         (
          -0.74082381,
          -8.4676552,
          -2.9482758,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -2.9482758,
         ),
         (
          0.74082381,
          -8.4676552,
          -2.9482758,
         ),
         (
          1.4760095,
          -8.3708658,
          -2.9482758,
         ),
         (
          2.1999619,
          -8.2103691,
          -2.9482758,
         ),
         (
          2.9071712,
          -7.9873872,
          -2.9482758,
         ),
         (
          3.5922554,
          -7.7036166,
          -2.9482758,
         ),
         (
          4.25,
          -7.3612156,
          -2.9482758,
         ),
         (
          4.8753996,
          -6.9627924,
          -2.9482758,
         ),
         (
          5.463695,
          -6.5113778,
          -2.9482758,
         ),
         (
          6.0104074,
          -6.0104074,
          -2.9482758,
         ),
         (
          6.5113778,
          -5.463695,
          -2.9482758,
         ),
         (
          6.9627924,
          -4.8753996,
          -2.9482758,
         ),
         (
          7.3612156,
          -4.25,
          -2.9482758,
         ),
         (
          7.7036166,
          -3.5922554,
          -2.9482758,
         ),
         (
          7.9873872,
          -2.9071712,
          -2.9482758,
         ),
         (
          8.2103691,
          -2.1999619,
          -2.9482758,
         ),
         (
          8.3708658,
          -1.4760095,
          -2.9482758,
         ),
         (
          8.4676552,
          -0.74082381,
          -2.9482758,
         ),
         (
          8.49191,
          0.37076479,
          -2.2931035,
         ),
         (
          8.4272814,
          1.1094725,
          -2.2931035,
         ),
         (
          8.2985163,
          1.8397368,
          -2.2931035,
         ),
         (
          8.1065941,
          2.5559993,
          -2.2931035,
         ),
         (
          7.8529758,
          3.252809,
          -2.2931035,
         ),
         (
          7.5395918,
          3.9248631,
          -2.2931035,
         ),
         (
          7.1688271,
          4.5670471,
          -2.2931035,
         ),
         (
          6.7435031,
          5.1744723,
          -2.2931035,
         ),
         (
          6.2668571,
          5.742517,
          -2.2931035,
         ),
         (
          5.742517,
          6.2668571,
          -2.2931035,
         ),
         (
          5.1744723,
          6.7435031,
          -2.2931035,
         ),
         (
          4.5670471,
          7.1688271,
          -2.2931035,
         ),
         (
          3.9248631,
          7.5395918,
          -2.2931035,
         ),
         (
          3.252809,
          7.8529758,
          -2.2931035,
         ),
         (
          2.5559993,
          8.1065941,
          -2.2931035,
         ),
         (
          1.8397368,
          8.2985163,
          -2.2931035,
         ),
         (
          1.1094725,
          8.4272814,
          -2.2931035,
         ),
         (
          0.37076479,
          8.49191,
          -2.2931035,
         ),
         (
          -0.37076479,
          8.49191,
          -2.2931035,
         ),
         (
          -1.1094725,
          8.4272814,
          -2.2931035,
         ),
         (
          -1.8397368,
          8.2985163,
          -2.2931035,
         ),
         (
          -2.5559993,
          8.1065941,
          -2.2931035,
         ),
         (
          -3.252809,
          7.8529758,
          -2.2931035,
         ),
         (
          -3.9248631,
          7.5395918,
          -2.2931035,
         ),
         (
          -4.5670471,
          7.1688271,
          -2.2931035,
         ),
         (
          -5.1744723,
          6.7435031,
          -2.2931035,
         ),
         (
          -5.742517,
          6.2668571,
          -2.2931035,
         ),
         (
          -6.2668571,
          5.742517,
          -2.2931035,
         ),
         (
          -6.7435031,
          5.1744723,
          -2.2931035,
         ),
         (
          -7.1688271,
          4.5670471,
          -2.2931035,
         ),
         (
          -7.5395918,
          3.9248631,
          -2.2931035,
         ),
         (
          -7.8529758,
          3.252809,
          -2.2931035,
         ),
         (
          -8.1065941,
          2.5559993,
          -2.2931035,
         ),
         (
          -8.2985163,
          1.8397368,
          -2.2931035,
         ),
         (
          -8.4272814,
          1.1094725,
          -2.2931035,
         ),
         (
          -8.49191,
          0.37076479,
          -2.2931035,
         ),
         (
          -8.49191,
          -0.37076479,
          -2.2931035,
         ),
         (
          -8.4272814,
          -1.1094725,
          -2.2931035,
         ),
         (
          -8.2985163,
          -1.8397368,
          -2.2931035,
         ),
         (
          -8.1065941,
          -2.5559993,
          -2.2931035,
         ),
         (
          -7.8529758,
          -3.252809,
          -2.2931035,
         ),
         (
          -7.5395918,
          -3.9248631,
          -2.2931035,
         ),
         (
          -7.1688271,
          -4.5670471,
          -2.2931035,
         ),
         (
          -6.7435031,
          -5.1744723,
          -2.2931035,
         ),
         (
          -6.2668571,
          -5.742517,
          -2.2931035,
         ),
         (
          -5.742517,
          -6.2668571,
          -2.2931035,
         ),
         (
          -5.1744723,
          -6.7435031,
          -2.2931035,
         ),
         (
          -4.5670471,
          -7.1688271,
          -2.2931035,
         ),
         (
          -3.9248631,
          -7.5395918,
          -2.2931035,
         ),
         (
          -3.252809,
          -7.8529758,
          -2.2931035,
         ),
         (
          -2.5559993,
          -8.1065941,
          -2.2931035,
         ),
         (
          -1.8397368,
          -8.2985163,
          -2.2931035,
         ),
         (
          -1.1094725,
          -8.4272814,
          -2.2931035,
         ),
         (
          -0.37076479,
          -8.49191,
          -2.2931035,
         ),
         (
          0.37076479,
          -8.49191,
          -2.2931035,
         ),
         (
          1.1094725,
          -8.4272814,
          -2.2931035,
         ),
         (
          1.8397368,
          -8.2985163,
          -2.2931035,
         ),
         (
          2.5559993,
          -8.1065941,
          -2.2931035,
         ),
         (
          3.252809,
          -7.8529758,
          -2.2931035,
         ),
         (
          3.9248631,
          -7.5395918,
          -2.2931035,
         ),
         (
          4.5670471,
          -7.1688271,
          -2.2931035,
         ),
         (
          5.1744723,
          -6.7435031,
          -2.2931035,
         ),
         (
          5.742517,
          -6.2668571,
          -2.2931035,
         ),
         (
          6.2668571,
          -5.742517,
          -2.2931035,
         ),
         (
          6.7435031,
          -5.1744723,
          -2.2931035,
         ),
         (
          7.1688271,
          -4.5670471,
          -2.2931035,
         ),
         (
          7.5395918,
          -3.9248631,
          -2.2931035,
         ),
         (
          7.8529758,
          -3.252809,
          -2.2931035,
         ),
         (
          8.1065941,
          -2.5559993,
          -2.2931035,
         ),
         (
          8.2985163,
          -1.8397368,
          -2.2931035,
         ),
         (
          8.4272814,
          -1.1094725,
          -2.2931035,
         ),
         (
          8.49191,
          -0.37076479,
          -2.2931035,
         ),
         (
          8.5,
          0.0,
          -1.6379311,
         ),
         (
          8.4676552,
          0.74082381,
          -1.6379311,
         ),
         (
          8.3708658,
          1.4760095,
          -1.6379311,
         ),
         (
          8.2103691,
          2.1999619,
          -1.6379311,
         ),
         (
          7.9873872,
          2.9071712,
          -1.6379311,
         ),
         (
          7.7036166,
          3.5922554,
          -1.6379311,
         ),
         (
          7.3612156,
          4.25,
          -1.6379311,
         ),
         (
          6.9627924,
          4.8753996,
          -1.6379311,
         ),
         (
          6.5113778,
          5.463695,
          -1.6379311,
         ),
         (
          6.0104074,
          6.0104074,
          -1.6379311,
         ),
         (
          5.463695,
          6.5113778,
          -1.6379311,
         ),
         (
          4.8753996,
          6.9627924,
          -1.6379311,
         ),
         (
          4.25,
          7.3612156,
          -1.6379311,
         ),
         (
          3.5922554,
          7.7036166,
          -1.6379311,
         ),
         (
          2.9071712,
          7.9873872,
          -1.6379311,
         ),
         (
          2.1999619,
          8.2103691,
          -1.6379311,
         ),
         (
          1.4760095,
          8.3708658,
          -1.6379311,
         ),
         (
          0.74082381,
          8.4676552,
          -1.6379311,
         ),
         (
          5.2047491e-16,
          8.5,
          -1.6379311,
         ),
         (
          -0.74082381,
          8.4676552,
          -1.6379311,
         ),
         (
          -1.4760095,
          8.3708658,
          -1.6379311,
         ),
         (
          -2.1999619,
          8.2103691,
          -1.6379311,
         ),
         (
          -2.9071712,
          7.9873872,
          -1.6379311,
         ),
         (
          -3.5922554,
          7.7036166,
          -1.6379311,
         ),
         (
          -4.25,
          7.3612156,
          -1.6379311,
         ),
         (
          -4.8753996,
          6.9627924,
          -1.6379311,
         ),
         (
          -5.463695,
          6.5113778,
          -1.6379311,
         ),
         (
          -6.0104074,
          6.0104074,
          -1.6379311,
         ),
         (
          -6.5113778,
          5.463695,
          -1.6379311,
         ),
         (
          -6.9627924,
          4.8753996,
          -1.6379311,
         ),
         (
          -7.3612156,
          4.25,
          -1.6379311,
         ),
         (
          -7.7036166,
          3.5922554,
          -1.6379311,
         ),
         (
          -7.9873872,
          2.9071712,
          -1.6379311,
         ),
         (
          -8.2103691,
          2.1999619,
          -1.6379311,
         ),
         (
          -8.3708658,
          1.4760095,
          -1.6379311,
         ),
         (
          -8.4676552,
          0.74082381,
          -1.6379311,
         ),
         (
          -8.5,
          1.0409498e-15,
          -1.6379311,
         ),
         (
          -8.4676552,
          -0.74082381,
          -1.6379311,
         ),
         (
          -8.3708658,
          -1.4760095,
          -1.6379311,
         ),
         (
          -8.2103691,
          -2.1999619,
          -1.6379311,
         ),
         (
          -7.9873872,
          -2.9071712,
          -1.6379311,
         ),
         (
          -7.7036166,
          -3.5922554,
          -1.6379311,
         ),
         (
          -7.3612156,
          -4.25,
          -1.6379311,
         ),
         (
          -6.9627924,
          -4.8753996,
          -1.6379311,
         ),
         (
          -6.5113778,
          -5.463695,
          -1.6379311,
         ),
         (
          -6.0104074,
          -6.0104074,
          -1.6379311,
         ),
         (
          -5.463695,
          -6.5113778,
          -1.6379311,
         ),
         (
          -4.8753996,
          -6.9627924,
          -1.6379311,
         ),
         (
          -4.25,
          -7.3612156,
          -1.6379311,
         ),
         (
          -3.5922554,
          -7.7036166,
          -1.6379311,
         ),
         (
          -2.9071712,
          -7.9873872,
          -1.6379311,
         ),
         (
          -2.1999619,
          -8.2103691,
          -1.6379311,
         ),
         (
          -1.4760095,
          -8.3708658,
          -1.6379311,
         ),
         (
          -0.74082381,
          -8.4676552,
          -1.6379311,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -1.6379311,
         ),
         (
          0.74082381,
          -8.4676552,
          -1.6379311,
         ),
         (
          1.4760095,
          -8.3708658,
          -1.6379311,
         ),
         (
          2.1999619,
          -8.2103691,
          -1.6379311,
         ),
         (
          2.9071712,
          -7.9873872,
          -1.6379311,
         ),
         (
          3.5922554,
          -7.7036166,
          -1.6379311,
         ),
         (
          4.25,
          -7.3612156,
          -1.6379311,
         ),
         (
          4.8753996,
          -6.9627924,
          -1.6379311,
         ),
         (
          5.463695,
          -6.5113778,
          -1.6379311,
         ),
         (
          6.0104074,
          -6.0104074,
          -1.6379311,
         ),
         (
          6.5113778,
          -5.463695,
          -1.6379311,
         ),
         (
          6.9627924,
          -4.8753996,
          -1.6379311,
         ),
         (
          7.3612156,
          -4.25,
          -1.6379311,
         ),
         (
          7.7036166,
          -3.5922554,
          -1.6379311,
         ),
         (
          7.9873872,
          -2.9071712,
          -1.6379311,
         ),
         (
          8.2103691,
          -2.1999619,
          -1.6379311,
         ),
         (
          8.3708658,
          -1.4760095,
          -1.6379311,
         ),
         (
          8.4676552,
          -0.74082381,
          -1.6379311,
         ),
         (
          8.49191,
          0.37076479,
          -0.98275864,
         ),
         (
          8.4272814,
          1.1094725,
          -0.98275864,
         ),
         (
          8.2985163,
          1.8397368,
          -0.98275864,
         ),
         (
          8.1065941,
          2.5559993,
          -0.98275864,
         ),
         (
          7.8529758,
          3.252809,
          -0.98275864,
         ),
         (
          7.5395918,
          3.9248631,
          -0.98275864,
         ),
         (
          7.1688271,
          4.5670471,
          -0.98275864,
         ),
         (
          6.7435031,
          5.1744723,
          -0.98275864,
         ),
         (
          6.2668571,
          5.742517,
          -0.98275864,
         ),
         (
          5.742517,
          6.2668571,
          -0.98275864,
         ),
         (
          5.1744723,
          6.7435031,
          -0.98275864,
         ),
         (
          4.5670471,
          7.1688271,
          -0.98275864,
         ),
         (
          3.9248631,
          7.5395918,
          -0.98275864,
         ),
         (
          3.252809,
          7.8529758,
          -0.98275864,
         ),
         (
          2.5559993,
          8.1065941,
          -0.98275864,
         ),
         (
          1.8397368,
          8.2985163,
          -0.98275864,
         ),
         (
          1.1094725,
          8.4272814,
          -0.98275864,
         ),
         (
          0.37076479,
          8.49191,
          -0.98275864,
         ),
         (
          -0.37076479,
          8.49191,
          -0.98275864,
         ),
         (
          -1.1094725,
          8.4272814,
          -0.98275864,
         ),
         (
          -1.8397368,
          8.2985163,
          -0.98275864,
         ),
         (
          -2.5559993,
          8.1065941,
          -0.98275864,
         ),
         (
          -3.252809,
          7.8529758,
          -0.98275864,
         ),
         (
          -3.9248631,
          7.5395918,
          -0.98275864,
         ),
         (
          -4.5670471,
          7.1688271,
          -0.98275864,
         ),
         (
          -5.1744723,
          6.7435031,
          -0.98275864,
         ),
         (
          -5.742517,
          6.2668571,
          -0.98275864,
         ),
         (
          -6.2668571,
          5.742517,
          -0.98275864,
         ),
         (
          -6.7435031,
          5.1744723,
          -0.98275864,
         ),
         (
          -7.1688271,
          4.5670471,
          -0.98275864,
         ),
         (
          -7.5395918,
          3.9248631,
          -0.98275864,
         ),
         (
          -7.8529758,
          3.252809,
          -0.98275864,
         ),
         (
          -8.1065941,
          2.5559993,
          -0.98275864,
         ),
         (
          -8.2985163,
          1.8397368,
          -0.98275864,
         ),
         (
          -8.4272814,
          1.1094725,
          -0.98275864,
         ),
         (
          -8.49191,
          0.37076479,
          -0.98275864,
         ),
         (
          -8.49191,
          -0.37076479,
          -0.98275864,
         ),
         (
          -8.4272814,
          -1.1094725,
          -0.98275864,
         ),
         (
          -8.2985163,
          -1.8397368,
          -0.98275864,
         ),
         (
          -8.1065941,
          -2.5559993,
          -0.98275864,
         ),
         (
          -7.8529758,
          -3.252809,
          -0.98275864,
         ),
         (
          -7.5395918,
          -3.9248631,
          -0.98275864,
         ),
         (
          -7.1688271,
          -4.5670471,
          -0.98275864,
         ),
         (
          -6.7435031,
          -5.1744723,
          -0.98275864,
         ),
         (
          -6.2668571,
          -5.742517,
          -0.98275864,
         ),
         (
          -5.742517,
          -6.2668571,
          -0.98275864,
         ),
         (
          -5.1744723,
          -6.7435031,
          -0.98275864,
         ),
         (
          -4.5670471,
          -7.1688271,
          -0.98275864,
         ),
         (
          -3.9248631,
          -7.5395918,
          -0.98275864,
         ),
         (
          -3.252809,
          -7.8529758,
          -0.98275864,
         ),
         (
          -2.5559993,
          -8.1065941,
          -0.98275864,
         ),
         (
          -1.8397368,
          -8.2985163,
          -0.98275864,
         ),
         (
          -1.1094725,
          -8.4272814,
          -0.98275864,
         ),
         (
          -0.37076479,
          -8.49191,
          -0.98275864,
         ),
         (
          0.37076479,
          -8.49191,
          -0.98275864,
         ),
         (
          1.1094725,
          -8.4272814,
          -0.98275864,
         ),
         (
          1.8397368,
          -8.2985163,
          -0.98275864,
         ),
         (
          2.5559993,
          -8.1065941,
          -0.98275864,
         ),
         (
          3.252809,
          -7.8529758,
          -0.98275864,
         ),
         (
          3.9248631,
          -7.5395918,
          -0.98275864,
         ),
         (
          4.5670471,
          -7.1688271,
          -0.98275864,
         ),
         (
          5.1744723,
          -6.7435031,
          -0.98275864,
         ),
         (
          5.742517,
          -6.2668571,
          -0.98275864,
         ),
         (
          6.2668571,
          -5.742517,
          -0.98275864,
         ),
         (
          6.7435031,
          -5.1744723,
          -0.98275864,
         ),
         (
          7.1688271,
          -4.5670471,
          -0.98275864,
         ),
         (
          7.5395918,
          -3.9248631,
          -0.98275864,
         ),
         (
          7.8529758,
          -3.252809,
          -0.98275864,
         ),
         (
          8.1065941,
          -2.5559993,
          -0.98275864,
         ),
         (
          8.2985163,
          -1.8397368,
          -0.98275864,
         ),
         (
          8.4272814,
          -1.1094725,
          -0.98275864,
         ),
         (
          8.49191,
          -0.37076479,
          -0.98275864,
         ),
         (
          8.5,
          0.0,
          -0.3275862,
         ),
         (
          8.4676552,
          0.74082381,
          -0.3275862,
         ),
         (
          8.3708658,
          1.4760095,
          -0.3275862,
         ),
         (
          8.2103691,
          2.1999619,
          -0.3275862,
         ),
         (
          7.9873872,
          2.9071712,
          -0.3275862,
         ),
         (
          7.7036166,
          3.5922554,
          -0.3275862,
         ),
         (
          7.3612156,
          4.25,
          -0.3275862,
         ),
         (
          6.9627924,
          4.8753996,
          -0.3275862,
         ),
         (
          6.5113778,
          5.463695,
          -0.3275862,
         ),
         (
          6.0104074,
          6.0104074,
          -0.3275862,
         ),
         (
          5.463695,
          6.5113778,
          -0.3275862,
         ),
         (
          4.8753996,
          6.9627924,
          -0.3275862,
         ),
         (
          4.25,
          7.3612156,
          -0.3275862,
         ),
         (
          3.5922554,
          7.7036166,
          -0.3275862,
         ),
         (
          2.9071712,
          7.9873872,
          -0.3275862,
         ),
         (
          2.1999619,
          8.2103691,
          -0.3275862,
         ),
         (
          1.4760095,
          8.3708658,
          -0.3275862,
         ),
         (
          0.74082381,
          8.4676552,
          -0.3275862,
         ),
         (
          5.2047491e-16,
          8.5,
          -0.3275862,
         ),
         (
          -0.74082381,
          8.4676552,
          -0.3275862,
         ),
         (
          -1.4760095,
          8.3708658,
          -0.3275862,
         ),
         (
          -2.1999619,
          8.2103691,
          -0.3275862,
         ),
         (
          -2.9071712,
          7.9873872,
          -0.3275862,
         ),
         (
          -3.5922554,
          7.7036166,
          -0.3275862,
         ),
         (
          -4.25,
          7.3612156,
          -0.3275862,
         ),
         (
          -4.8753996,
          6.9627924,
          -0.3275862,
         ),
         (
          -5.463695,
          6.5113778,
          -0.3275862,
         ),
         (
          -6.0104074,
          6.0104074,
          -0.3275862,
         ),
         (
          -6.5113778,
          5.463695,
          -0.3275862,
         ),
         (
          -6.9627924,
          4.8753996,
          -0.3275862,
         ),
         (
          -7.3612156,
          4.25,
          -0.3275862,
         ),
         (
          -7.7036166,
          3.5922554,
          -0.3275862,
         ),
         (
          -7.9873872,
          2.9071712,
          -0.3275862,
         ),
         (
          -8.2103691,
          2.1999619,
          -0.3275862,
         ),
         (
          -8.3708658,
          1.4760095,
          -0.3275862,
         ),
         (
          -8.4676552,
          0.74082381,
          -0.3275862,
         ),
         (
          -8.5,
          1.0409498e-15,
          -0.3275862,
         ),
         (
          -8.4676552,
          -0.74082381,
          -0.3275862,
         ),
         (
          -8.3708658,
          -1.4760095,
          -0.3275862,
         ),
         (
          -8.2103691,
          -2.1999619,
          -0.3275862,
         ),
         (
          -7.9873872,
          -2.9071712,
          -0.3275862,
         ),
         (
          -7.7036166,
          -3.5922554,
          -0.3275862,
         ),
         (
          -7.3612156,
          -4.25,
          -0.3275862,
         ),
         (
          -6.9627924,
          -4.8753996,
          -0.3275862,
         ),
         (
          -6.5113778,
          -5.463695,
          -0.3275862,
         ),
         (
          -6.0104074,
          -6.0104074,
          -0.3275862,
         ),
         (
          -5.463695,
          -6.5113778,
          -0.3275862,
         ),
         (
          -4.8753996,
          -6.9627924,
          -0.3275862,
         ),
         (
          -4.25,
          -7.3612156,
          -0.3275862,
         ),
         (
          -3.5922554,
          -7.7036166,
          -0.3275862,
         ),
         (
          -2.9071712,
          -7.9873872,
          -0.3275862,
         ),
         (
          -2.1999619,
          -8.2103691,
          -0.3275862,
         ),
         (
          -1.4760095,
          -8.3708658,
          -0.3275862,
         ),
         (
          -0.74082381,
          -8.4676552,
          -0.3275862,
         ),
         (
          -1.5614247e-15,
          -8.5,
          -0.3275862,
         ),
         (
          0.74082381,
          -8.4676552,
          -0.3275862,
         ),
         (
          1.4760095,
          -8.3708658,
          -0.3275862,
         ),
         (
          2.1999619,
          -8.2103691,
          -0.3275862,
         ),
         (
          2.9071712,
          -7.9873872,
          -0.3275862,
         ),
         (
          3.5922554,
          -7.7036166,
          -0.3275862,
         ),
         (
          4.25,
          -7.3612156,
          -0.3275862,
         ),
         (
          4.8753996,
          -6.9627924,
          -0.3275862,
         ),
         (
          5.463695,
          -6.5113778,
          -0.3275862,
         ),
         (
          6.0104074,
          -6.0104074,
          -0.3275862,
         ),
         (
          6.5113778,
          -5.463695,
          -0.3275862,
         ),
         (
          6.9627924,
          -4.8753996,
          -0.3275862,
         ),
         (
          7.3612156,
          -4.25,
          -0.3275862,
         ),
         (
          7.7036166,
          -3.5922554,
          -0.3275862,
         ),
         (
          7.9873872,
          -2.9071712,
          -0.3275862,
         ),
         (
          8.2103691,
          -2.1999619,
          -0.3275862,
         ),
         (
          8.3708658,
          -1.4760095,
          -0.3275862,
         ),
         (
          8.4676552,
          -0.74082381,
          -0.3275862,
         ),
         (
          8.49191,
          0.37076479,
          0.3275862,
         ),
         (
          8.4272814,
          1.1094725,
          0.3275862,
         ),
         (
          8.2985163,
          1.8397368,
          0.3275862,
         ),
         (
          8.1065941,
          2.5559993,
          0.3275862,
         ),
         (
          7.8529758,
          3.252809,
          0.3275862,
         ),
         (
          7.5395918,
          3.9248631,
          0.3275862,
         ),
         (
          7.1688271,
          4.5670471,
          0.3275862,
         ),
         (
          6.7435031,
          5.1744723,
          0.3275862,
         ),
         (
          6.2668571,
          5.742517,
          0.3275862,
         ),
         (
          5.742517,
          6.2668571,
          0.3275862,
         ),
         (
          5.1744723,
          6.7435031,
          0.3275862,
         ),
         (
          4.5670471,
          7.1688271,
          0.3275862,
         ),
         (
          3.9248631,
          7.5395918,
          0.3275862,
         ),
         (
          3.252809,
          7.8529758,
          0.3275862,
         ),
         (
          2.5559993,
          8.1065941,
          0.3275862,
         ),
         (
          1.8397368,
          8.2985163,
          0.3275862,
         ),
         (
          1.1094725,
          8.4272814,
          0.3275862,
         ),
         (
          0.37076479,
          8.49191,
          0.3275862,
         ),
         (
          -0.37076479,
          8.49191,
          0.3275862,
         ),
         (
          -1.1094725,
          8.4272814,
          0.3275862,
         ),
         (
          -1.8397368,
          8.2985163,
          0.3275862,
         ),
         (
          -2.5559993,
          8.1065941,
          0.3275862,
         ),
         (
          -3.252809,
          7.8529758,
          0.3275862,
         ),
         (
          -3.9248631,
          7.5395918,
          0.3275862,
         ),
         (
          -4.5670471,
          7.1688271,
          0.3275862,
         ),
         (
          -5.1744723,
          6.7435031,
          0.3275862,
         ),
         (
          -5.742517,
          6.2668571,
          0.3275862,
         ),
         (
          -6.2668571,
          5.742517,
          0.3275862,
         ),
         (
          -6.7435031,
          5.1744723,
          0.3275862,
         ),
         (
          -7.1688271,
          4.5670471,
          0.3275862,
         ),
         (
          -7.5395918,
          3.9248631,
          0.3275862,
         ),
         (
          -7.8529758,
          3.252809,
          0.3275862,
         ),
         (
          -8.1065941,
          2.5559993,
          0.3275862,
         ),
         (
          -8.2985163,
          1.8397368,
          0.3275862,
         ),
         (
          -8.4272814,
          1.1094725,
          0.3275862,
         ),
         (
          -8.49191,
          0.37076479,
          0.3275862,
         ),
         (
          -8.49191,
          -0.37076479,
          0.3275862,
         ),
         (
          -8.4272814,
          -1.1094725,
          0.3275862,
         ),
         (
          -8.2985163,
          -1.8397368,
          0.3275862,
         ),
         (
          -8.1065941,
          -2.5559993,
          0.3275862,
         ),
         (
          -7.8529758,
          -3.252809,
          0.3275862,
         ),
         (
          -7.5395918,
          -3.9248631,
          0.3275862,
         ),
         (
          -7.1688271,
          -4.5670471,
          0.3275862,
         ),
         (
          -6.7435031,
          -5.1744723,
          0.3275862,
         ),
         (
          -6.2668571,
          -5.742517,
          0.3275862,
         ),
         (
          -5.742517,
          -6.2668571,
          0.3275862,
         ),
         (
          -5.1744723,
          -6.7435031,
          0.3275862,
         ),
         (
          -4.5670471,
          -7.1688271,
          0.3275862,
         ),
         (
          -3.9248631,
          -7.5395918,
          0.3275862,
         ),
         (
          -3.252809,
          -7.8529758,
          0.3275862,
         ),
         (
          -2.5559993,
          -8.1065941,
          0.3275862,
         ),
         (
          -1.8397368,
          -8.2985163,
          0.3275862,
         ),
         (
          -1.1094725,
          -8.4272814,
          0.3275862,
         ),
         (
          -0.37076479,
          -8.49191,
          0.3275862,
         ),
         (
          0.37076479,
          -8.49191,
          0.3275862,
         ),
         (
          1.1094725,
          -8.4272814,
          0.3275862,
         ),
         (
          1.8397368,
          -8.2985163,
          0.3275862,
         ),
         (
          2.5559993,
          -8.1065941,
          0.3275862,
         ),
         (
          3.252809,
          -7.8529758,
          0.3275862,
         ),
         (
          3.9248631,
          -7.5395918,
          0.3275862,
         ),
         (
          4.5670471,
          -7.1688271,
          0.3275862,
         ),
         (
          5.1744723,
          -6.7435031,
          0.3275862,
         ),
         (
          5.742517,
          -6.2668571,
          0.3275862,
         ),
         (
          6.2668571,
          -5.742517,
          0.3275862,
         ),
         (
          6.7435031,
          -5.1744723,
          0.3275862,
         ),
         (
          7.1688271,
          -4.5670471,
          0.3275862,
         ),
         (
          7.5395918,
          -3.9248631,
          0.3275862,
         ),
         (
          7.8529758,
          -3.252809,
          0.3275862,
         ),
         (
          8.1065941,
          -2.5559993,
          0.3275862,
         ),
         (
          8.2985163,
          -1.8397368,
          0.3275862,
         ),
         (
          8.4272814,
          -1.1094725,
          0.3275862,
         ),
         (
          8.49191,
          -0.37076479,
          0.3275862,
         ),
         (
          8.5,
          0.0,
          0.98275864,
         ),
         (
          8.4676552,
          0.74082381,
          0.98275864,
         ),
         (
          8.3708658,
          1.4760095,
          0.98275864,
         ),
         (
          8.2103691,
          2.1999619,
          0.98275864,
         ),
         (
          7.9873872,
          2.9071712,
          0.98275864,
         ),
         (
          7.7036166,
          3.5922554,
          0.98275864,
         ),
         (
          7.3612156,
          4.25,
          0.98275864,
         ),
         (
          6.9627924,
          4.8753996,
          0.98275864,
         ),
         (
          6.5113778,
          5.463695,
          0.98275864,
         ),
         (
          6.0104074,
          6.0104074,
          0.98275864,
         ),
         (
          5.463695,
          6.5113778,
          0.98275864,
         ),
         (
          4.8753996,
          6.9627924,
          0.98275864,
         ),
         (
          4.25,
          7.3612156,
          0.98275864,
         ),
         (
          3.5922554,
          7.7036166,
          0.98275864,
         ),
         (
          2.9071712,
          7.9873872,
          0.98275864,
         ),
         (
          2.1999619,
          8.2103691,
          0.98275864,
         ),
         (
          1.4760095,
          8.3708658,
          0.98275864,
         ),
         (
          0.74082381,
          8.4676552,
          0.98275864,
         ),
         (
          5.2047491e-16,
          8.5,
          0.98275864,
         ),
         (
          -0.74082381,
          8.4676552,
          0.98275864,
         ),
         (
          -1.4760095,
          8.3708658,
          0.98275864,
         ),
         (
          -2.1999619,
          8.2103691,
          0.98275864,
         ),
         (
          -2.9071712,
          7.9873872,
          0.98275864,
         ),
         (
          -3.5922554,
          7.7036166,
          0.98275864,
         ),
         (
          -4.25,
          7.3612156,
          0.98275864,
         ),
         (
          -4.8753996,
          6.9627924,
          0.98275864,
         ),
         (
          -5.463695,
          6.5113778,
          0.98275864,
         ),
         (
          -6.0104074,
          6.0104074,
          0.98275864,
         ),
         (
          -6.5113778,
          5.463695,
          0.98275864,
         ),
         (
          -6.9627924,
          4.8753996,
          0.98275864,
         ),
         (
          -7.3612156,
          4.25,
          0.98275864,
         ),
         (
          -7.7036166,
          3.5922554,
          0.98275864,
         ),
         (
          -7.9873872,
          2.9071712,
          0.98275864,
         ),
         (
          -8.2103691,
          2.1999619,
          0.98275864,
         ),
         (
          -8.3708658,
          1.4760095,
          0.98275864,
         ),
         (
          -8.4676552,
          0.74082381,
          0.98275864,
         ),
         (
          -8.5,
          1.0409498e-15,
          0.98275864,
         ),
         (
          -8.4676552,
          -0.74082381,
          0.98275864,
         ),
         (
          -8.3708658,
          -1.4760095,
          0.98275864,
         ),
         (
          -8.2103691,
          -2.1999619,
          0.98275864,
         ),
         (
          -7.9873872,
          -2.9071712,
          0.98275864,
         ),
         (
          -7.7036166,
          -3.5922554,
          0.98275864,
         ),
         (
          -7.3612156,
          -4.25,
          0.98275864,
         ),
         (
          -6.9627924,
          -4.8753996,
          0.98275864,
         ),
         (
          -6.5113778,
          -5.463695,
          0.98275864,
         ),
         (
          -6.0104074,
          -6.0104074,
          0.98275864,
         ),
         (
          -5.463695,
          -6.5113778,
          0.98275864,
         ),
         (
          -4.8753996,
          -6.9627924,
          0.98275864,
         ),
         (
          -4.25,
          -7.3612156,
          0.98275864,
         ),
         (
          -3.5922554,
          -7.7036166,
          0.98275864,
         ),
         (
          -2.9071712,
          -7.9873872,
          0.98275864,
         ),
         (
          -2.1999619,
          -8.2103691,
          0.98275864,
         ),
         (
          -1.4760095,
          -8.3708658,
          0.98275864,
         ),
         (
          -0.74082381,
          -8.4676552,
          0.98275864,
         ),
         (
          -1.5614247e-15,
          -8.5,
          0.98275864,
         ),
         (
          0.74082381,
          -8.4676552,
          0.98275864,
         ),
         (
          1.4760095,
          -8.3708658,
          0.98275864,
         ),
         (
          2.1999619,
          -8.2103691,
          0.98275864,
         ),
         (
          2.9071712,
          -7.9873872,
          0.98275864,
         ),
         (
          3.5922554,
          -7.7036166,
          0.98275864,
         ),
         (
          4.25,
          -7.3612156,
          0.98275864,
         ),
         (
          4.8753996,
          -6.9627924,
          0.98275864,
         ),
         (
          5.463695,
          -6.5113778,
          0.98275864,
         ),
         (
          6.0104074,
          -6.0104074,
          0.98275864,
         ),
         (
          6.5113778,
          -5.463695,
          0.98275864,
         ),
         (
          6.9627924,
          -4.8753996,
          0.98275864,
         ),
         (
          7.3612156,
          -4.25,
          0.98275864,
         ),
         (
          7.7036166,
          -3.5922554,
          0.98275864,
         ),
         (
          7.9873872,
          -2.9071712,
          0.98275864,
         ),
         (
          8.2103691,
          -2.1999619,
          0.98275864,
         ),
         (
          8.3708658,
          -1.4760095,
          0.98275864,
         ),
         (
          8.4676552,
          -0.74082381,
          0.98275864,
         ),
         (
          8.49191,
          0.37076479,
          1.6379311,
         ),
         (
          8.4272814,
          1.1094725,
          1.6379311,
         ),
         (
          8.2985163,
          1.8397368,
          1.6379311,
         ),
         (
          8.1065941,
          2.5559993,
          1.6379311,
         ),
         (
          7.8529758,
          3.252809,
          1.6379311,
         ),
         (
          7.5395918,
          3.9248631,
          1.6379311,
         ),
         (
          7.1688271,
          4.5670471,
          1.6379311,
         ),
         (
          6.7435031,
          5.1744723,
          1.6379311,
         ),
         (
          6.2668571,
          5.742517,
          1.6379311,
         ),
         (
          5.742517,
          6.2668571,
          1.6379311,
         ),
         (
          5.1744723,
          6.7435031,
          1.6379311,
         ),
         (
          4.5670471,
          7.1688271,
          1.6379311,
         ),
         (
          3.9248631,
          7.5395918,
          1.6379311,
         ),
         (
          3.252809,
          7.8529758,
          1.6379311,
         ),
         (
          2.5559993,
          8.1065941,
          1.6379311,
         ),
         (
          1.8397368,
          8.2985163,
          1.6379311,
         ),
         (
          1.1094725,
          8.4272814,
          1.6379311,
         ),
         (
          0.37076479,
          8.49191,
          1.6379311,
         ),
         (
          -0.37076479,
          8.49191,
          1.6379311,
         ),
         (
          -1.1094725,
          8.4272814,
          1.6379311,
         ),
         (
          -1.8397368,
          8.2985163,
          1.6379311,
         ),
         (
          -2.5559993,
          8.1065941,
          1.6379311,
         ),
         (
          -3.252809,
          7.8529758,
          1.6379311,
         ),
         (
          -3.9248631,
          7.5395918,
          1.6379311,
         ),
         (
          -4.5670471,
          7.1688271,
          1.6379311,
         ),
         (
          -5.1744723,
          6.7435031,
          1.6379311,
         ),
         (
          -5.742517,
          6.2668571,
          1.6379311,
         ),
         (
          -6.2668571,
          5.742517,
          1.6379311,
         ),
         (
          -6.7435031,
          5.1744723,
          1.6379311,
         ),
         (
          -7.1688271,
          4.5670471,
          1.6379311,
         ),
         (
          -7.5395918,
          3.9248631,
          1.6379311,
         ),
         (
          -7.8529758,
          3.252809,
          1.6379311,
         ),
         (
          -8.1065941,
          2.5559993,
          1.6379311,
         ),
         (
          -8.2985163,
          1.8397368,
          1.6379311,
         ),
         (
          -8.4272814,
          1.1094725,
          1.6379311,
         ),
         (
          -8.49191,
          0.37076479,
          1.6379311,
         ),
         (
          -8.49191,
          -0.37076479,
          1.6379311,
         ),
         (
          -8.4272814,
          -1.1094725,
          1.6379311,
         ),
         (
          -8.2985163,
          -1.8397368,
          1.6379311,
         ),
         (
          -8.1065941,
          -2.5559993,
          1.6379311,
         ),
         (
          -7.8529758,
          -3.252809,
          1.6379311,
         ),
         (
          -7.5395918,
          -3.9248631,
          1.6379311,
         ),
         (
          -7.1688271,
          -4.5670471,
          1.6379311,
         ),
         (
          -6.7435031,
          -5.1744723,
          1.6379311,
         ),
         (
          -6.2668571,
          -5.742517,
          1.6379311,
         ),
         (
          -5.742517,
          -6.2668571,
          1.6379311,
         ),
         (
          -5.1744723,
          -6.7435031,
          1.6379311,
         ),
         (
          -4.5670471,
          -7.1688271,
          1.6379311,
         ),
         (
          -3.9248631,
          -7.5395918,
          1.6379311,
         ),
         (
          -3.252809,
          -7.8529758,
          1.6379311,
         ),
         (
          -2.5559993,
          -8.1065941,
          1.6379311,
         ),
         (
          -1.8397368,
          -8.2985163,
          1.6379311,
         ),
         (
          -1.1094725,
          -8.4272814,
          1.6379311,
         ),
         (
          -0.37076479,
          -8.49191,
          1.6379311,
         ),
         (
          0.37076479,
          -8.49191,
          1.6379311,
         ),
         (
          1.1094725,
          -8.4272814,
          1.6379311,
         ),
         (
          1.8397368,
          -8.2985163,
          1.6379311,
         ),
         (
          2.5559993,
          -8.1065941,
          1.6379311,
         ),
         (
          3.252809,
          -7.8529758,
          1.6379311,
         ),
         (
          3.9248631,
          -7.5395918,
          1.6379311,
         ),
         (
          4.5670471,
          -7.1688271,
          1.6379311,
         ),
         (
          5.1744723,
          -6.7435031,
          1.6379311,
         ),
         (
          5.742517,
          -6.2668571,
          1.6379311,
         ),
         (
          6.2668571,
          -5.742517,
          1.6379311,
         ),
         (
          6.7435031,
          -5.1744723,
          1.6379311,
         ),
         (
          7.1688271,
          -4.5670471,
          1.6379311,
         ),
         (
          7.5395918,
          -3.9248631,
          1.6379311,
         ),
         (
          7.8529758,
          -3.252809,
          1.6379311,
         ),
         (
          8.1065941,
          -2.5559993,
          1.6379311,
         ),
         (
          8.2985163,
          -1.8397368,
          1.6379311,
         ),
         (
          8.4272814,
          -1.1094725,
          1.6379311,
         ),
         (
          8.49191,
          -0.37076479,
          1.6379311,
         ),
         (
          8.5,
          0.0,
          2.2931035,
         ),
         (
          8.4676552,
          0.74082381,
          2.2931035,
         ),
         (
          8.3708658,
          1.4760095,
          2.2931035,
         ),
         (
          8.2103691,
          2.1999619,
          2.2931035,
         ),
         (
          7.9873872,
          2.9071712,
          2.2931035,
         ),
         (
          7.7036166,
          3.5922554,
          2.2931035,
         ),
         (
          7.3612156,
          4.25,
          2.2931035,
         ),
         (
          6.9627924,
          4.8753996,
          2.2931035,
         ),
         (
          6.5113778,
          5.463695,
          2.2931035,
         ),
         (
          6.0104074,
          6.0104074,
          2.2931035,
         ),
         (
          5.463695,
          6.5113778,
          2.2931035,
         ),
         (
          4.8753996,
          6.9627924,
          2.2931035,
         ),
         (
          4.25,
          7.3612156,
          2.2931035,
         ),
         (
          3.5922554,
          7.7036166,
          2.2931035,
         ),
         (
          2.9071712,
          7.9873872,
          2.2931035,
         ),
         (
          2.1999619,
          8.2103691,
          2.2931035,
         ),
         (
          1.4760095,
          8.3708658,
          2.2931035,
         ),
         (
          0.74082381,
          8.4676552,
          2.2931035,
         ),
         (
          5.2047491e-16,
          8.5,
          2.2931035,
         ),
         (
          -0.74082381,
          8.4676552,
          2.2931035,
         ),
         (
          -1.4760095,
          8.3708658,
          2.2931035,
         ),
         (
          -2.1999619,
          8.2103691,
          2.2931035,
         ),
         (
          -2.9071712,
          7.9873872,
          2.2931035,
         ),
         (
          -3.5922554,
          7.7036166,
          2.2931035,
         ),
         (
          -4.25,
          7.3612156,
          2.2931035,
         ),
         (
          -4.8753996,
          6.9627924,
          2.2931035,
         ),
         (
          -5.463695,
          6.5113778,
          2.2931035,
         ),
         (
          -6.0104074,
          6.0104074,
          2.2931035,
         ),
         (
          -6.5113778,
          5.463695,
          2.2931035,
         ),
         (
   