#
# Apr 2014 ECM modified 2D labels text positions, added white rectangle label bg
#  use with data supplied in zip file here:
#  http://www.rbvi.ucsf.edu/chimera/animations/animations.html#myosin-analysis
#
# This command script remakes the 2006 myosin thick filament movie using
# Chimera 1.5.2 (2010) capabilities.  The original movie was made with a complex
# Python script.
#
# Most setup is done in Chimera session file myomovie.py which should be opened
# before running this movie recording script.
#
# Here are some commands that were used in making the myomovie.py session.
#
# windowsize 484 880
# set bg_color white
# set silhouette
# lighting quality glossy
# open myosin2.mrc
# cofr 0,0,0
# turn x -90
# scale 0.65
# volume #0 level 0.2
# open myosin2.mrc
# modeldisplay #1
# vol #1 level 0.15 region 0,0,41,99,99,81 color 0,0,1,.3
# open 1i84-notail.pdb
# rainbow chain
# ~ribbon
# display #2
# repr sphere
# open tail.cmm
# open subfilament0.mrc subfilament1.mrc ... subfilament12.mrc
# volume #4-16 level 0.2 color gray
# volume #4 color .8,.6,.4,1
# volume #5,7,9,11,13,15 color .7,.7,.3
#

# Show initial models and create title.
volume #0 show
volume #1,4-16 hide style surface
~modeldisplay #2,3
reset start
2dlabel create caption ypos .95 bgColor white margin 10
alias ^title 2dlabel change caption visibility hide frames 5 ; wait 15 ; 2dlabel change caption visibility show color black
title text "Myosin thick filament, EM map" xpos .15
alias ^crossfade movie crossfade frames

# The supersample 3 option improves image quality but slows rendering.
movie record supersample 3

wait 30

# Rotate filament map.
cofr 0,0,0 coord #0
turn y 0.5 90
wait 75

# Fade in blue map copy for showing symmetry.
surftrans 100 #1
volume #1 show
surftrans 70 #1 15
wait 15

# Illustrate 4-fold symmetry by rotating blue map copy.
title text "Symmetry: 90 degree rotation"
turn y 3 30 model #1
wait 50

# Illustrate translation symmetry.
title text "Symmetry: 43.5 nm translation"
move y 7.5 58 model #1
wait 80

# Rotate and shift blue map
title text "Four-strand helix" xpos .3
turn y -1 30 model #1
move y -5 29 model #1
wait 45
turn y -1 30 model #1
move y -5 29 model #1
wait 45
turn y -1 30 model #1
move y -5 29 model #1
wait 60

# Hide blue map.
surftrans 100 #1 20
wait 20
volume #1 hide

title text "Myosin heads, 'J' shapes on surface" xpos .1
crossfade 30
scolor #0 geometry cylindrical cmap 120,gray:121,orange
wait 60

title text "Myosin tails make filament body" xpos .15
crossfade 30
scolor #0 geometry cylindrical cmap 110,salmon:111,gray
wait 60

title text "Fit myosin model, hand placement" xpos .12
crossfade 15
modeldisp #2
wait 30
reset p1 30
wait 30
reset p2 30
wait 60

title text "Computational fit optimization" xpos .17
select #2
crossfade 30
scolor #0 geometry cylindrical cmap 110,salmon:111,.7,.7,.7,.7
reset p3 30
wait 30
~select

title text "Flip and fit - wrong orientation"
reset p4 15
wait 15
reset p5 15
wait 45

title text "Fitting with symmetric copies"
sym #2 coord #0 update true
rainbow chain #17 ; ~ribbon #17 ; repr sphere #17 ; display #17
wait 15
reset p6 30
wait 60
~sym #2
crossfade 30
~scolor #0 ; volume #0 color .7,.7,.7,.7

title text "Myosin tail, hand-traced"  xpos .2
~display #3
modeldisp #3
display #3:1 ; wait 6
display #3:1-2 ; wait 6
display #3:1-3 ; wait 6
display #3:1-4 ; wait 6
display #3:1-5 ; wait 6
scale .975 30
display #3:1-6 ; wait 6
display #3:1-7 ; wait 6
display #3:1-8 ; wait 6
display #3:1-9 ; wait 6
display #3:1-10 ; wait 6
crossfade 15
~modeldisp #2,3 ; volume #0 color gray

title text "Filament has 12 subfilaments"  xpos .17
crossfade 60
volume #4-16 show ; volume #0 hide

cofr 0,0,0 coord #0
turn y 3 15
wait 30

# Extract one subfilament and rotate it
reset p7 15
wait 15
reset p8 15
wait 40
turn y 4 90 model #13 center #13
wait 90

# Explode subfilaments radially.
reset p9 60
wait 45
surftransp 100 #5-16 15
wait 45
volume #5-16 hide

title text "Filament core, contents unknown"  xpos .13
cofr 0,0,0 coord #0
turn y -0.5 90
scale 1.01 60
wait 45
title text ""

# Redisplay subfilaments.
surft 0 #5-16
matrixcopy #4 #5-16
volume #12 show ; wait 4
volume #11 show ; wait 4
volume #10 show ; wait 4
volume #9  show ; wait 4
volume #8  show ; wait 4
volume #7  show ; wait 4
volume #6  show ; wait 4
volume #5  show ; wait 4
volume #16 show ; wait 4
volume #15 show ; wait 4
volume #14 show ; wait 4

# Fly in atomic model and subfilament trace
volume #13 style mesh color .7,.7,.3,0 show
surftransp 50 #13 30

reset p10
crossfade 10
modeldisp #2,3
reset p11 30
wait 40

title text "\u2000\u2000\u2000Animation created with UCSF Chimera\n\nData from John Woodhead and Roger Craig" size 18
wait 30

movie encode output ~/Desktop/myomovie.mov

2dlabel delete caption
