import cPickle, base64
try:
	from SimpleSession.versions.v52 import beginRestore,\
	    registerAfterModelsCB, reportRestoreError, checkVersion
except ImportError:
	from chimera import UserError
	raise UserError('Cannot open session that was saved in a'
	    ' newer version of Chimera; update your version')
checkVersion([1, 5, 3, 33475])
import chimera
from chimera import replyobj
replyobj.status('Beginning session restore...', \
    blankAfter=0)
beginRestore()

def restoreCoreModels():
	from SimpleSession.versions.v52 import init, restoreViewer, \
	     restoreMolecules, restoreColors, restoreSurfaces, \
	     restoreVRML, restorePseudoBondGroups, restoreModelAssociations
	molInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVRFyaWJib25JbnNpZGVDb2xvcnECSwBOfYdVCWJhbGxTY2FsZXEDSwBOfYdVCXBvaW50U2l6ZXEESwBOfYdVBWNvbG9ycQVLAE59h1UNYXJvbWF0aWNDb2xvcnEGSwBOfYdVCnN0aWNrU2NhbGVxB0sATn2HVQxhcm9tYXRpY01vZGVxCEsATn2HVQp2ZHdEZW5zaXR5cQlLAE59h1UGaGlkZGVucQpLAE59h1UJYXV0b2NoYWlucQtLAE59h1UIb3B0aW9uYWxxDH1VD2xvd2VyQ2FzZUNoYWluc3ENSwBOfYdVCWxpbmVXaWR0aHEOSwBOfYdVD3Jlc2lkdWVMYWJlbFBvc3EPSwBOfYdVBG5hbWVxEEsATn2HVQ9hcm9tYXRpY0Rpc3BsYXlxEUsATn2HVRBhcm9tYXRpY0xpbmVUeXBlcRJLAE59h1UKcGRiSGVhZGVyc3ETXVUDaWRzcRRLAE59h1UOc3VyZmFjZU9wYWNpdHlxFUsATn2HVRRyaWJib25IaWRlc01haW5jaGFpbnEWSwBOfYdVB2Rpc3BsYXlxF0sATn2HdS4='))
	resInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQZpbnNlcnRxAksATn2HVQtmaWxsRGlzcGxheXEDSwBOfYdVBG5hbWVxBEsATn2HVQVjaGFpbnEFSwBOfYdVDnJpYmJvbkRyYXdNb2RlcQZLAE59h1UCc3NxB0sATn2HVQhtb2xlY3VsZXEISwBOfYdVC3JpYmJvbkNvbG9ycQlLAE59h1UFbGFiZWxxCksATn2HVQpsYWJlbENvbG9ycQtLAE59h1UIZmlsbE1vZGVxDEsATn2HVQVpc0hldHENSwBOfYdVC2xhYmVsT2Zmc2V0cQ5LAE59h1UIcG9zaXRpb25xD11VDXJpYmJvbkRpc3BsYXlxEEsATn2HVQhvcHRpb25hbHERfVUEc3NJZHESSwBOfYd1Lg=='))
	atomInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQdyZXNpZHVlcQJLAE59h1UIdmR3Q29sb3JxA0sATn2HVQRuYW1lcQRLAE59h1UDdmR3cQVLAE59h1UOc3VyZmFjZURpc3BsYXlxBksATn2HVQVjb2xvcnEHSwBOfYdVCWlkYXRtVHlwZXEISwBOfYdVBmFsdExvY3EJSwBOfYdVBWxhYmVscQpLAE59h1UOc3VyZmFjZU9wYWNpdHlxC0sATn2HVQdlbGVtZW50cQxLAE59h1UKbGFiZWxDb2xvcnENSwBOfYdVDHN1cmZhY2VDb2xvcnEOSwBOfYdVD3N1cmZhY2VDYXRlZ29yeXEPSwBOfYdVBnJhZGl1c3EQSwBOfYdVC2xhYmVsT2Zmc2V0cRFLAE59h1USbWluaW11bUxhYmVsUmFkaXVzcRJLAE59h1UIZHJhd01vZGVxE0sATn2HVQhvcHRpb25hbHEUfVUHZGlzcGxheXEVSwBOfYd1Lg=='))
	bondInfo = cPickle.loads(base64.b64decode('gAJ9cQEoVQVhdG9tc3ECXVUFbGFiZWxxA0sATn2HVQZyYWRpdXNxBEsATn2HVQtsYWJlbE9mZnNldHEFSwBOfYdVCGRyYXdNb2RlcQZLAE59h1UIb3B0aW9uYWxxB31VB2Rpc3BsYXlxCEsATn2HdS4='))
	crdInfo = cPickle.loads(base64.b64decode('gAJ9cQEu'))
	surfInfo = {'category': (0, None, {}), 'probeRadius': (0, None, {}), 'pointSize': (0, None, {}), 'name': [], 'density': (0, None, {}), 'colorMode': (0, None, {}), 'useLighting': (0, None, {}), 'transparencyBlendMode': (0, None, {}), 'molecule': [], 'smoothLines': (0, None, {}), 'lineWidth': (0, None, {}), 'allComponents': (0, None, {}), 'twoSidedLighting': (0, None, {}), 'oneTransparentLayer': (0, None, {}), 'drawMode': (0, None, {}), 'display': (0, None, {}), 'customColors': []}
	vrmlInfo = {'subid': (0, None, {}), 'display': (0, None, {}), 'id': (0, None, {}), 'vrmlString': [], 'name': (0, None, {})}
	colors = {'Ru': ((0.141176, 0.560784, 0.560784), 1, u'default'), 'Ni': ((0.313725, 0.815686, 0.313725), 1, u'default'), 'Re': ((0.14902, 0.490196, 0.670588), 1, u'default'), 'Rf': ((0.8, 0, 0.34902), 1, u'default'), 'Ra': ((0, 0.490196, 0), 1, u'default'), 'Rb': ((0.439216, 0.180392, 0.690196), 1, u'default'), 'Rn': ((0.258824, 0.509804, 0.588235), 1, u'default'), 'Rh': ((0.0392157, 0.490196, 0.54902), 1, u'default'), 'Be': ((0.760784, 1, 0), 1, u'default'), 'Ba': ((0, 0.788235, 0), 1, u'default'), 'Bh': ((0.878431, 0, 0.219608), 1, u'default'), 'Bi': ((0.619608, 0.309804, 0.709804), 1, u'default'), 'Bk': ((0.541176, 0.309804, 0.890196), 1, u'default'), 'Br': ((0.65098, 0.160784, 0.160784), 1, u'default'), '_openColor00': ((1, 1, 1), 1, u'default'), '_openColor01': ((1, 0, 1), 1, u'default'), '_openColor02': ((0, 1, 1), 1, u'default'), '_openColor03': ((1, 1, 0), 1, u'default'), '_openColor04': ((1, 0, 0), 1, u'default'), '_openColor05': ((0, 0, 1), 1, u'default'), '_openColor06': ((0.67, 1, 0), 1, u'default'), '_openColor07': ((0.67, 0, 1), 1, u'default'), '_openColor08': ((0.67, 1, 1), 1, u'default'),
'H': ((1, 1, 1), 1, u'default'), 'P': ((1, 0.501961, 0), 1, u'default'), 'Os': ((0.14902, 0.4, 0.588235), 1, u'default'), 'Ge': ((0.4, 0.560784, 0.560784), 1, u'default'), 'Gd': ((0.270588, 1, 0.780392), 1, u'default'), 'Ga': ((0.760784, 0.560784, 0.560784), 1, u'default'), 'Pr': ((0.85098, 1, 0.780392), 1, u'default'), '_openColor12': ((1, 1, 0.5), 1, u'default'), '_openColor11': ((1, 0.67, 1), 1, u'default'), '_openColor10': ((0, 0.67, 1), 1, u'default'), 'Pt': ((0.815686, 0.815686, 0.878431), 1, u'default'), 'Pu': ((0, 0.419608, 1), 1, u'default'), 'C': ((0.564706, 0.564706, 0.564706), 1, u'default'), 'Pb': ((0.341176, 0.34902, 0.380392), 1, u'default'), 'Pa': ((0, 0.631373, 1), 1, u'default'), 'Pd': ((0, 0.411765, 0.521569), 1, u'default'), 'Xe': ((0.258824, 0.619608, 0.690196), 1, u'default'), 'Po': ((0.670588, 0.360784, 0), 1, u'default'), 'Pm': ((0.639216, 1, 0.780392), 1, u'default'), 'Hs': ((0.901961, 0, 0.180392), 1, u'default'), 'Ho': ((0, 1, 0.611765), 1, u'default'), 'Hf': ((0.301961, 0.760784, 1), 1, u'default'), 'Hg': ((0.721569, 0.721569, 0.815686), 1, u'default'),
'He': ((0.85098, 1, 1), 1, u'default'), 'Md': ((0.701961, 0.0509804, 0.65098), 1, u'default'), 'Mg': ((0.541176, 1, 0), 1, u'default'), 'K': ((0.560784, 0.25098, 0.831373), 1, u'default'), 'Mn': ((0.611765, 0.478431, 0.780392), 1, u'default'), 'O': ((1, 0.0509804, 0.0509804), 1, u'default'), 'Mt': ((0.921569, 0, 0.14902), 1, u'default'), 'S': ((1, 1, 0.188235), 1, u'default'), 'W': ((0.129412, 0.580392, 0.839216), 1, u'default'), 'Zn': ((0.490196, 0.501961, 0.690196), 1, u'default'), 'Eu': ((0.380392, 1, 0.780392), 1, u'default'), 'Zr': ((0.580392, 0.878431, 0.878431), 1, u'default'), 'Er': ((0, 0.901961, 0.458824), 1, u'default'), '_openColor13': ((1, 0, 0.5), 1, u'default'), 'No': ((0.741176, 0.0509804, 0.529412), 1, u'default'), 'Na': ((0.670588, 0.360784, 0.94902), 1, u'default'), 'Nb': ((0.45098, 0.760784, 0.788235), 1, u'default'), 'Nd': ((0.780392, 1, 0.780392), 1, u'default'), 'Ne': ((0.701961, 0.890196, 0.960784), 1, u'default'), 'Np': ((0, 0.501961, 1), 1, u'default'), 'Fr': ((0.258824, 0, 0.4), 1, u'default'), '_openColor15': ((0.67, 0.67, 1), 1, u'default'),
'_openColor14': ((0, 1, 0.5), 1, u'default'), 'Fe': ((0.878431, 0.4, 0.2), 1, u'default'), 'Fm': ((0.701961, 0.121569, 0.729412), 1, u'default'), 'B': ((1, 0.709804, 0.709804), 1, u'default'), 'F': ((0.564706, 0.878431, 0.313725), 1, u'default'), 'Sr': ((0, 1, 0), 1, u'default'), 'N': ((0.188235, 0.313725, 0.972549), 1, u'default'), 'Kr': ((0.360784, 0.721569, 0.819608), 1, u'default'), 'Si': ((0.941176, 0.784314, 0.627451), 1, u'default'), 'Sn': ((0.4, 0.501961, 0.501961), 1, u'default'), 'Sm': ((0.560784, 1, 0.780392), 1, u'default'), 'V': ((0.65098, 0.65098, 0.670588), 1, u'default'), 'Sc': ((0.901961, 0.901961, 0.901961), 1, u'default'), 'Sb': ((0.619608, 0.388235, 0.709804), 1, u'default'), 'Sg': ((0.85098, 0, 0.270588), 1, u'default'), 'Se': ((1, 0.631373, 0), 1, u'default'), 'Co': ((0.941176, 0.564706, 0.627451), 1, u'default'), 'Cm': ((0.470588, 0.360784, 0.890196), 1, u'default'), 'Cl': ((0.121569, 0.941176, 0.121569), 1, u'default'), 'Ca': ((0.239216, 1, 0), 1, u'default'), 'Cf': ((0.631373, 0.211765, 0.831373), 1, u'default'), 'Ce': ((1, 1, 0.780392), 1, u'default'),
'Cd': ((1, 0.85098, 0.560784), 1, u'default'), 'Tm': ((0, 0.831373, 0.321569), 1, u'default'), 'Cs': ((0.341176, 0.0901961, 0.560784), 1, u'default'), 'Cr': ((0.541176, 0.6, 0.780392), 1, u'default'), 'Cu': ((0.784314, 0.501961, 0.2), 1, u'default'), 'La': ((0.439216, 0.831373, 1), 1, u'default'), 'Li': ((0.8, 0.501961, 1), 1, u'default'), 'Tl': ((0.65098, 0.329412, 0.301961), 1, u'default'), 'Lu': ((0, 0.670588, 0.141176), 1, u'default'), 'Lr': ((0.780392, 0, 0.4), 1, u'default'), 'Th': ((0, 0.729412, 1), 1, u'default'), 'Ti': ((0.74902, 0.760784, 0.780392), 1, u'default'), 'Te': ((0.831373, 0.478431, 0), 1, u'default'), 'Tb': ((0.188235, 1, 0.780392), 1, u'default'), 'Tc': ((0.231373, 0.619608, 0.619608), 1, u'default'), 'Ta': ((0.301961, 0.65098, 1), 1, u'default'), 'Yb': ((0, 0.74902, 0.219608), 1, u'default'), 'Db': ((0.819608, 0, 0.309804), 1, u'default'), 'Dy': ((0.121569, 1, 0.780392), 1, u'default'), '_openColor09': ((1, 0.67, 0), 1, u'default'), 'At': ((0.458824, 0.309804, 0.270588), 1, u'default'), 'I': ((0.580392, 0, 0.580392), 1, u'default'),
'U': ((0, 0.560784, 1), 1, u'default'), 'Y': ((0.580392, 1, 1), 1, u'default'), 'Ac': ((0.439216, 0.670588, 0.980392), 1, u'default'), 'Ag': ((0.752941, 0.752941, 0.752941), 1, u'default'), 'Ir': ((0.0901961, 0.329412, 0.529412), 1, u'default'), 'Am': ((0.329412, 0.360784, 0.94902), 1, u'default'), 'Al': ((0.74902, 0.65098, 0.65098), 1, u'default'), 'As': ((0.741176, 0.501961, 0.890196), 1, u'default'), 'Ar': ((0.501961, 0.819608, 0.890196), 1, u'default'), 'Au': ((1, 0.819608, 0.137255), 1, u'default'), 'Es': ((0.701961, 0.121569, 0.831373), 1, u'default'), 'In': ((0.65098, 0.458824, 0.45098), 1, u'default'), 'Mo': ((0.329412, 0.709804, 0.709804), 1, u'default')}
	materials = {u'default': ((0.85, 0.85, 0.85), 30)}
	pbInfo = {'category': [u'distance monitor'], 'bondInfo': [{'color': (0, None, {}), 'atoms': [], 'label': (0, None, {}), 'halfbond': (0, None, {}), 'labelColor': (0, None, {}), 'drawMode': (0, None, {}), 'display': (0, None, {})}], 'lineType': (1, 2, {}), 'color': (1, 0, {}), 'optional': {'fixedLabels': (True, False, (1, 0, {}))}, 'showStubBonds': (1, False, {}), 'lineWidth': (1, 1, {}), 'stickScale': (1, 1, {}), 'id': [-2]}
	modelAssociations = {}
	colorInfo = {0: (u'yellow', (1, 1, 0, 1)), 1: (u'black', (0, 0, 0, 1)), 2: (u'green', (0, 1, 0, 1))}
	viewerInfo = {'cameraAttrs': {'center': (905.041, 789.375, 2312.34), 'fieldOfView': 22.9777, 'nearFar': (3273.32, 1403.12), 'ortho': False, 'eyeSeparation': 50.8, 'focal': 2312.34}, 'viewerAttrs': {'silhouetteColor': None, 'clipping': False, 'showSilhouette': False, 'viewSize': 927.936, 'depthCueRange': (0.5, 1.05556), 'silhouetteWidth': 1, 'depthCue': True, 'highlight': 0, 'scaleFactor': 1}, 'viewerHL': 2, 'cameraMode': 'mono', 'detail': 1, 'viewerFog': 1, 'viewerBG': None}

	replyobj.status("Initializing session restore...", blankAfter=0)
	init(colorInfo)
	replyobj.status("Restoring colors...", blankAfter=0)
	restoreColors(colors, materials)
	replyobj.status("Restoring molecules...", blankAfter=0)
	restoreMolecules(molInfo, resInfo, atomInfo, bondInfo, crdInfo)
	replyobj.status("Restoring surfaces...", blankAfter=0)
	restoreSurfaces(surfInfo)
	replyobj.status("Restoring VRML models...", blankAfter=0)
	restoreVRML(vrmlInfo)
	replyobj.status("Restoring pseudobond groups...", blankAfter=0)
	restorePseudoBondGroups(pbInfo)
	replyobj.status("Restoring model associations...", blankAfter=0)
	restoreModelAssociations(modelAssociations)
	replyobj.status("Restoring camera...", blankAfter=0)
	restoreViewer(viewerInfo)

try:
	restoreCoreModels()
except:
	reportRestoreError("Error restoring core models")

	replyobj.status("Restoring extension info...", blankAfter=0)


def restore_surface_zones():
 surface_zone_state = \
   {
    'class': 'Surface_Zone_State',
    'version': 2,
    'zone_table': {},
   }
 try:
  import SurfaceZone.session
  SurfaceZone.session.restore_surface_zone_state(surface_zone_state)
 except:
  reportRestoreError('Error restoring surface zones')

registerAfterModelsCB(restore_surface_zones)


def restore_color_zones():
 color_zone_state = \
   {
    'class': 'Color_Zone_State',
    'color_zone_table': {},
    'version': 2,
   }
 try:
  import ColorZone.session
  ColorZone.session.restore_color_zone_state(color_zone_state)
 except:
  reportRestoreError('Error restoring surface color zones')

registerAfterModelsCB(restore_color_zones)


def restore_surface_capping():
 capper_state = \
  {
   'cap_offset': '0.01',
   'cap_rgba': ( 1, 1, 1, 1, ),
   'cap_style': 'solid',
   'class': 'Capper_Dialog_State',
   'color_caps': 0,
   'geometry': '213x162+902+384',
   'is_visible': False,
   'show_caps': 1,
   'subdivision_factor': '1.0',
   'version': 1,
  }
 import SurfaceCap.session
 SurfaceCap.session.restore_capper_state(capper_state)

try:
  restore_surface_capping()
except:
  reportRestoreError('Error restoring surface capping')


def restore_volume_path_tracer():
 path_tracer_state = \
  (
   [ ],
   {
    'active_marker_set_name': '',
    'cap_surface_ends': 0,
    'class': 'Path_Tracer_Dialog_State',
    'curve_band_length': '0',
    'curve_radius': '0',
    'curve_segment_subdivisions': '10',
    'geometry': '1x1+1570+45',
    'is_visible': False,
    'link_color': ( 1, 1, 1, 1.0, ),
    'link_consecutive': 0,
    'link_radius': '',
    'link_to_selected': 1,
    'marker_color': ( 1, 0.26666666666666666, 0.13333333333333333, 1.0, ),
    'marker_matches_volume_color': 0,
    'marker_note': '',
    'marker_radius': '100',
    'move_markers': 1,
    'note_color': ( 1, 1, 1, 1.0, ),
    'place_markers_continuously': 0,
    'place_markers_on_planes': 0,
    'place_markers_on_spots': 0,
    'place_markers_on_surfaces': 0,
    'place_markers_outside_data': 0,
    'placement_button': 'button 2',
    'show_slice_line': 0,
    'shown_panels': [ 'Marker set menu', 'Mouse button menu', 'Marker color and radius', ],
    'slice_color': ( 1, 1, 1, 1.0, ),
    'surface_model_state': None,
    'use_mouse': 0,
    'use_volume_colors': 0,
    'version': 4,
   },
  )
 import VolumePath.session
 VolumePath.session.restore_path_tracer_state(path_tracer_state)

try:
  restore_volume_path_tracer()
except:
  reportRestoreError('Error restoring volume path tracer')


def restore_volume_data():
 volume_data_state = \
  {
   'class': 'Volume_Manager_State',
   'data_and_regions_state': [
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90.0, 90.0, 90.0, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': 'hiv_debris.mrc',
       'path': 'hiv_debris.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 0.7, 0.7, 0.7, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 92, 90, 100, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 92, 90, 100, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': False,
          'cap_faces': True,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': True,
          'dim_transparent_voxels': True,
          'flip_normals': True,
          'limit_voxel_count': True,
          'line_thickness': 1.0,
          'linear_interpolation': True,
          'maximum_intensity_projection': False,
          'mesh_lighting': True,
          'minimal_texture_memory': False,
          'one_transparent_layer': False,
          'outline_box_linewidth': 1,
          'outline_box_rgb': ( 1, 1, 1, ),
          'projection_mode': '2d-xyz',
          'show_outline_box': False,
          'smooth_lines': False,
          'smoothing_factor': 0.3,
          'smoothing_iterations': 2,
          'square_mesh': True,
          'subdivide_surface': False,
          'subdivision_levels': 1,
          'surface_smoothing': True,
          'two_sided_lighting': False,
          'version': 1,
          'voxel_limit': 1,
         },
        'representation': 'surface',
        'session_volume_id': 445856504,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
         ],
        'solid_levels': [
          ( 128.30809143066406, 0, ),
          ( 133.8867041015625, 0.5, ),
          ( 139.46531677246094, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 0.9333333333333333, 0.7333333333333333, 0.2, 1.0, ),
         ],
        'surface_levels': [ 128.30809143066406, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( -0.7682877548203362, -0.28954374707755276, 0.570875068926133, ),
          'clip_plane_origin': ( 906.2431945800781, 696.9441375732422, 2264.2266235351562, ),
          'clip_thickness': 101.87811279296875,
          'display': True,
          'id': 1,
          'name': u'hiv_debris.mrc',
          'osl_identifier': u'#1',
          'subid': 0,
          'use_clip_plane': True,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 128.92430239716103,
            'rotation_axis': ( -0.08948864893296003, -0.9707098751392351, 0.22296663431851005, ),
            'translation': ( 3261.2979319764095, 618.3883910898919, 3257.316031913546, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.010989010457460207,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90.0, 90.0, 90.0, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': 'hiv_envelope.mrc',
       'path': 'hiv_envelope.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 0.7, 0.7, 0.7, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 92, 90, 100, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 92, 90, 100, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': False,
          'cap_faces': True,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': True,
          'dim_transparent_voxels': True,
          'flip_normals': True,
          'limit_voxel_count': True,
          'line_thickness': 1.0,
          'linear_interpolation': True,
          'maximum_intensity_projection': False,
          'mesh_lighting': True,
          'minimal_texture_memory': False,
          'one_transparent_layer': False,
          'outline_box_linewidth': 1,
          'outline_box_rgb': ( 1, 1, 1, ),
          'projection_mode': '2d-xyz',
          'show_outline_box': False,
          'smooth_lines': False,
          'smoothing_factor': 0.3,
          'smoothing_iterations': 2,
          'square_mesh': True,
          'subdivide_surface': False,
          'subdivision_levels': 1,
          'surface_smoothing': True,
          'two_sided_lighting': False,
          'version': 1,
          'voxel_limit': 1,
         },
        'representation': 'surface',
        'session_volume_id': 445883576,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
         ],
        'solid_levels': [
          ( 134.95980766296387, 0, ),
          ( 140.5892254257202, 0.5, ),
          ( 146.21864318847656, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 0.2, 0.7, 0.9333333333333333, 1.0, ),
         ],
        'surface_levels': [ 128.0, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( -0.7682877548203362, -0.28954374707755276, 0.570875068926133, ),
          'clip_plane_origin': ( 882.1725540161133, 737.9263675957918, 2271.6513061523438, ),
          'clip_thickness': 147.54983390271664,
          'display': True,
          'id': 2,
          'name': u'hiv_envelope.mrc',
          'osl_identifier': u'#2',
          'subid': 0,
          'use_clip_plane': True,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 128.92430239716103,
            'rotation_axis': ( -0.08948864893296003, -0.9707098751392351, 0.22296663431851005, ),
            'translation': ( 3261.2979319764095, 618.3883910898919, 3257.316031913546, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.010989010457460207,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
     (
      {
       'available_subsamplings': {},
       'cell_angles': ( 90.0, 90.0, 90.0, ),
       'class': 'Data_State',
       'file_type': 'mrc',
       'grid_id': '',
       'name': 'hiv_core.mrc',
       'path': 'hiv_core.mrc',
       'rotation': (
         ( 1, 0, 0, ),
         ( 0, 1, 0, ),
         ( 0, 0, 1, ),
        ),
       'symmetries': ( ),
       'version': 6,
       'xyz_origin': None,
       'xyz_step': None,
      },
      [
       {
        'class': 'Volume_State',
        'default_rgba': ( 0.7, 0.7, 0.7, 1, ),
        'region': (
          ( 0, 0, 0, ),
          ( 92, 90, 100, ),
          [ 1, 1, 1, ],
         ),
        'region_list': {
          'class': 'Region_List_State',
          'current_index': 0,
          'named_regions': [ ],
          'region_list': [
            (
             ( 0, 0, 0, ),
             ( 92, 90, 100, ),
            ),
           ],
          'version': 1,
         },
        'rendering_options': {
          'bt_correction': False,
          'cap_faces': True,
          'class': 'Rendering_Options_State',
          'color_mode': 'auto8',
          'dim_transparency': True,
          'dim_transparent_voxels': True,
          'flip_normals': True,
          'limit_voxel_count': True,
          'line_thickness': 1.0,
          'linear_interpolation': True,
          'maximum_intensity_projection': False,
          'mesh_lighting': True,
          'minimal_texture_memory': False,
          'one_transparent_layer': False,
          'outline_box_linewidth': 1,
          'outline_box_rgb': ( 1, 1, 1, ),
          'projection_mode': '2d-xyz',
          'show_outline_box': False,
          'smooth_lines': False,
          'smoothing_factor': 0.3,
          'smoothing_iterations': 2,
          'square_mesh': True,
          'subdivide_surface': False,
          'subdivision_levels': 1,
          'surface_smoothing': True,
          'two_sided_lighting': False,
          'version': 1,
          'voxel_limit': 1,
         },
        'representation': 'surface',
        'session_volume_id': 445854104,
        'solid_brightness_factor': 1.0,
        'solid_colors': [
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
          ( 1.0, 1.0, 1.0, 1, ),
         ],
        'solid_levels': [
          ( 130.75600146484376, 0, ),
          ( 135.82843255615234, 0.5, ),
          ( 140.90086364746094, 1, ),
         ],
        'solid_model': None,
        'surface_brightness_factor': 1.0,
        'surface_colors': [
          ( 0.8666666666666667, 0.13333333333333333, 0.06666666666666667, 1.0, ),
         ],
        'surface_levels': [ 128.0, ],
        'surface_model': {
          'active': True,
          'class': 'Model_State',
          'clip_plane_normal': ( -0.7682877548203362, -0.28954374707755276, 0.570875068926133, ),
          'clip_plane_origin': ( 906.8286437988281, 811.6422576904297, 2305.431396484375, ),
          'clip_thickness': 73.80314025878906,
          'display': True,
          'id': 0,
          'name': u'hiv_core.mrc',
          'osl_identifier': u'#0',
          'subid': 0,
          'use_clip_plane': False,
          'use_clip_thickness': False,
          'version': 4,
          'xform': {
            'class': 'Xform_State',
            'rotation_angle': 128.92430239716103,
            'rotation_axis': ( -0.08948864893296003, -0.9707098751392351, 0.22296663431851005, ),
            'translation': ( 3261.2979319764095, 618.3883910898919, 3257.316031913546, ),
            'version': 1,
           },
         },
        'transparency_depth': 0.010989010457460207,
        'transparency_factor': 0.0,
        'version': 6,
       },
      ],
     ),
    ],
   'version': 2,
  }
 from VolumeViewer import session
 session.restore_volume_data_state(volume_data_state)

try:
  restore_volume_data()
except:
  reportRestoreError('Error restoring volume data')


def restore_volume_dialog():
 volume_dialog_state = \
  {
   'adjust_camera': 0,
   'auto_show_subregion': 0,
   'box_padding': '0',
   'class': 'Volume_Dialog_State',
   'data_cache_size': '128',
   'focus_volume': 445854104,
   'geometry': '384x454+784+85',
   'histogram_active_order': [ 2, 1, 0, ],
   'histogram_volumes': [ 445883576, 445856504, 445854104, ],
   'immediate_update': 1,
   'initial_colors': (
     ( 0.7, 0.7, 0.7, 1, ),
     ( 1, 1, 0.7, 1, ),
     ( 0.7, 1, 1, 1, ),
     ( 0.7, 0.7, 1, 1, ),
     ( 1, 0.7, 1, 1, ),
     ( 1, 0.7, 0.7, 1, ),
     ( 0.7, 1, 0.7, 1, ),
     ( 0.9, 0.75, 0.6, 1, ),
     ( 0.6, 0.75, 0.9, 1, ),
     ( 0.8, 0.8, 0.6, 1, ),
    ),
   'is_visible': True,
   'max_histograms': '5',
   'representation': 'surface',
   'selectable_subregions': 0,
   'show_on_open': 1,
   'show_plane': 1,
   'shown_panels': [ 'Feature buttons', 'Display style', 'Threshold and Color', ],
   'subregion_button': 'button 2',
   'use_initial_colors': 1,
   'version': 12,
   'voxel_limit_for_open': '256',
   'voxel_limit_for_plane': '256',
   'zone_radius': 2.0,
  }
 from VolumeViewer import session
 session.restore_volume_dialog_state(volume_dialog_state)

try:
  restore_volume_dialog()
except:
  reportRestoreError('Error restoring volume dialog')


def restoreLightController():
	import Lighting
	Lighting._setFromParams({'brightness': 1.05300518926304, 'material': [30.0, (0.85, 0.85, 0.85), 1.0], 'back': [(0.3574067443365933, 0.6604015517481455, -0.6604015517481456), (1.0, 1.0, 1.0), 0.0], 'mode': 'two-point', 'key': [(-0.3574067443365933, 0.6604015517481455, 0.6604015517481456), (1.0, 1.0, 1.0), 0.8613070249557495], 'quality': 'normal', 'contrast': 1.7222136572191813, 'fill': [(0.2505628070857316, 0.2505628070857316, 0.9351131265310294), (1.0, 1.0, 1.0), 0.20000000298023224]})
try:
	restoreLightController()
except:
	reportRestoreError("Error restoring lighting parameters")


def restoreSession_RibbonStyleEditor():
	import SimpleSession
	import RibbonStyleEditor
	userScalings = [('aa', [[0.25, 0.25], [1.7, 0.25], [1.5, 0.25], [0.25, 0.25, 3, 0.25], [1.7, 0.25]]), ('helen2', [[0.4, 0.4], [1.7, 0.4], [2, 0.4], [2, 0.4, 0.4, 0.4], [0.9, 0.25]]), ('maya', [[0.2, 0.2], [1.2, 0.2], [1.2, 0.2], [1.8, 0.2, 0.2, 0.2], [0.9, 0.2]]), ('encyclo_virol_2006_FAT', [[0.6, 0.6], [1.5, 0.6], [1.5, 0.6], [3, 0.25, 0.25, 0.25], [0.6, 0.6]]), ('testdefault', [[0.25, 0.25], [1.5, 0.25], [1.5, 0.25], [3, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('80percent', [[0.2, 0.2], [1.2, 0.2], [1.2, 0.2], [2.4, 0.2, 0.2, 0.2], [1.2, 0.2]]), ('slim', [[0.2, 0.2], [0.6, 0.2], [0.6, 0.2], [1, 0.2, 0.2, 0.2], [0.6, 0.2]]), ('skinny', [[0.25, 0.25], [0.75, 0.25], [0.75, 0.25], [1.5, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('Liz1', [[0.5, 0.5], [0.9, 0.25], [0.9, 0.25], [1.8, 0.25, 0.25, 0.25], [0.9, 0.25]]), ('SUPERFAT', [[0.7, 0.7], [1.6, 0.7], [1.6, 0.7], [3.1, 0.35, 0.35, 0.35], [0.7, 0.7]]), ('narrow nucleic - gary', [[0.2, 0.2], [0.9, 0.2], [0.95, 0.2], [1.8, 0.2, 0.2, 0.2], [0.35, 0.2]]), ('60%', [[0.15, 0.15], [0.9, 0.15], [0.9, 0.15], [1.8, 0.15, 0.15, 0.15], [0.9, 0.15]]),
('minus_20%', [[0.2, 0.2], [1.2, 0.2], [1.2, 0.2], [2.4, 0.2, 0.2, 0.2], [1.2, 0.2]]), ('60_percent', [[0.15, 0.15], [0.9, 0.15], [0.9, 0.15], [2.4, 0.15, 0.15, 0.15], [0.9, 0.15]]), ('20%', [[0.05, 0.05], [0.3, 0.05], [0.3, 0.05], [0.6, 0.05, 0.05, 0.05], [0.3, 0.05]]), ('no-helix', [[0.25, 0.25], [0.25, 0.25], [1.5, 0.25], [3, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('for3Dprint1round', [[0.8, 0.8], [1.5, 0.8], [1.5, 0.8], [2.4, 0.8, 0.8, 0.8], [1, 0.6]]), ('BS', [[0.3, 0.3], [1.5, 0.3], [1.5, 0.3], [3, 0.3, 0.25, 0.3], [1.5, 0.3]]), ('ssccmv_ribbon_scale', [[0.3, 0.3], [1.25, 0.5], [1.25, 0.5], [2.25, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('fatz', [[0.25, 0.25], [2.5, 0.25], [2.5, 0.25], [3, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('spaghetti', [[0.25, 0.25], [0.25, 0.25], [0.25, 0.25], [0.25, 0.25, 0.25, 0.25], [0.25, 0.25]]), ('for3Dprint1', [[0.5, 0.5], [0.9, 0.5], [0.9, 0.5], [1.8, 0.5, 0.5, 0.5], [0.9, 0.5]]), ('Margy_thin', [[0.25, 0.25], [0.4, 0.25], [0.4, 0.25], [1.5, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('40%', [[0.1, 0.1], [0.6, 0.1], [0.6, 0.1], [1.2, 0.1, 0.1, 0.1], [0.6, 0.1]]),
('thin2', [[0.25, 0.15], [0.4, 0.15], [0.4, 0.15], [1, 0.15, 0.25, 0.15], [1.5, 0.25]]), ('histon_1_s1', [[0.25, 0.25], [1.5, 0.25], [1.5, 0.25], [3, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('default', [[0.25, 0.25], [1.5, 0.25], [1.5, 0.25], [0.25, 0.25, 3, 0.25], [1.5, 0.25]]), ('narrow nucleic 2 -gary', [[0.2, 0.2], [0.9, 0.2], [0.95, 0.2], [1.8, 0.2, 0.2, 0.2], [0.35, 0.35]]), ('user default', [[0.25, 0.25], [1.5, 0.25], [1.5, 0.25], [0.25, 0.25, 3, 0.25], [1.5, 0.25]]), ('licorice', [[0.35, 0.35], [0.35, 0.35], [0.35, 0.35], [0.35, 0.35, 0.35, 0.35], [0.35, 0.35]]), ('slim2029', [[0.2, 0.2], [1.2, 0.2], [1.2, 0.2], [2.4, 0.2, 0.2, 0.2], [1.2, 0.2]]), ('FAT', [[0.6, 0.6], [1.5, 0.6], [1.5, 0.6], [3, 0.25, 0.25, 0.25], [0.7, 0.7]]), ('thinturn', [[0.1, 0.25], [1.5, 0.25], [1.5, 0.25], [3, 0.25, 0.25, 0.25], [1.5, 0.25]]), ('linguini', [[0.1, 0.1], [0.1, 0.1], [0.1, 0.1], [0.1, 0.1, 0.1, 0.1], [0.1, 0.1]]), ('Margy_medium', [[0.45, 0.25], [0.7, 0.25], [0.7, 0.25], [1.5, 0.25, 0.45, 0.25], [1.5, 0.25]]), ('encyclo_virol_2006_STD', [[0.4, 0.4], [1.5, 0.4], [1.5, 0.4], [3, 0.25, 0.25, 0.25], [0.4, 0.4]]),
('thin', [[0.15, 0.15], [0.75, 0.15], [0.75, 0.15], [1.75, 0.15, 0.15, 0.15], [1.5, 0.25]]), ('thin even', [[0.4, 0.4], [0.4, 0.4], [0.4, 0.4], [0.4, 0.4, 0.4, 0.4], [1.5, 0.25]]), ('slimrib', [[0.2, 0.2], [1, 0.2], [1, 0.2], [0.2, 0.2, 2, 0.2], [1, 0.2]]), ('barrel', [[0.75, 0.75], [2, 0.75], [2, 0.75], [2.6, 0.75, 0.75, 0.75], [0.9, 0.25]]), ('60percent', [[0.15, 0.15], [0.9, 0.15], [0.9, 0.15], [1.8, 0.15, 0.15, 0.15], [0.9, 0.15]]), ('plump', [[0.3, 0.3], [1.2, 0.3], [1.2, 0.3], [2, 0.3, 0.3, 0.3], [1.2, 0.3]])]
	userXSections = [('', ([(4, 4), (5, 5), (6, 5), (7, 4), (7, 3), (6, 2), (5, 2), (4, 3)], 1, 1, 1, 10)), ('diamond', ([(3, 3), (0, 5), (3, 7), (7, 7), (10, 5), (7, 3)], 0, 1, 1, 10)), ('large_octagon', ([(1, 3), (1, 5), (3, 7), (5, 7), (7, 5), (7, 3), (5, 1), (3, 1)], 1, 1, 1, 8)), ('octagon', ([(4, 4), (5, 5), (6, 5), (7, 4), (7, 3), (6, 2), (5, 2), (4, 3)], 1, 1, 1, 10)), ('thin_round_square', ([(4, 2), (5, 2), (6, 5), (4, 3), (4, 4), (4, 5), (6, 4), (5, 4), (5, 3), (6, 3)], True, True, True, 10)), ('ibeam', ([(10, 0), (8, 0), (8, 4), (2, 4), (2, 0), (0, 0), (0, 10), (2, 10), (2, 6), (8, 6), (8, 10), (10, 10)], 0, 1, 1, 10)), ('aitch', ([(0, 0), (0, 10), (3, 10), (3, 6), (7, 6), (7, 10), (10, 10), (10, 0), (7, 0), (7, 4), (3, 4), (3, 0), (0, 0)], 1, True, False, 10)), ('ocatagon', ([(4, 4), (5, 5), (6, 5), (7, 4), (7, 3), (6, 2), (5, 2), (4, 3)], 1, 1, 1, 10)), ('wave', ([(18, 18), (18, 19), (18, 31), (31, 31), (31, 18)], True, True, True, 50))]
	userResidueClasses = [('aa-nomain-ca-o', ('CA', 'O', False, False, {})), ('aa-camain-ca-n', ('CA', 'N', False, False, {'CA': 0.5})), ('aa-camain-ca-o', ('CA', 'O', False, False, {'CA': 0.5})), ('aa-camain-ca-c', ('CA', 'C', False, False, {'CA': 0.5})), ('pguide', ('P', "C1'", False, True, {"C5'": 0.5, 'P': 0.166667, 'O2P': 0.166667, 'O1P': 0.166667, 'O3P': 0.166667, "O5'": 0.333333, 'O3T': 1, "O3'": 1, 'O5T': 0})), ('aa-nomain-c-o', ('C', 'O', False, False, {})), ('pguiderot', ('P', "C1'", 1, True, {"C5'": 0.5, 'P': 0.166667, 'O2P': 0.166667, 'O1P': 0.166667, 'O3P': 0.166667, "O5'": 0.333333, 'O3T': 1, "O3'": 1, 'O5T': 0}))]
	residueData = []
	flags = RibbonStyleEditor.NucleicDefault1
	SimpleSession.registerAfterModelsCB(RibbonStyleEditor.restoreState,
				(userScalings, userXSections,
				userResidueClasses, residueData, flags))
try:
	restoreSession_RibbonStyleEditor()
except:
	reportRestoreError("Error restoring RibbonStyleEditor state")
geomData = {'AxisManager': {}, 'CentroidManager': {}, 'PlaneManager': {}}

try:
	from StructMeasure.Geometry import geomManager
	geomManager._restoreSession(geomData)
except:
	reportRestoreError("Error restoring geometry objects in session")


def restoreMidasText():
	from Midas import midas_text
	midas_text.aliases = {}
	midas_text.userSurfCategories = {}

try:
	restoreMidasText()
except:
	reportRestoreError('Error restoring Midas text state')


def restoreMidasBase():
	import chimera
	from SimpleSession import modelMap, modelOffset
	def deformatPosition(pos):
		xfDict = {}
		for molId, xfData in pos[5].items():
			mid, subid = molId
			trData, rotData = xfData
			xf = chimera.Xform.translation(*trData)
			xf.rotate(*rotData)
			xfDict[(mid+modelOffset, subid)] = xf
		try:
			from chimera.misc import KludgeWeakWrappyDict
			clipDict = KludgeWeakWrappyDict("Model")
		except ImportError:
			from weakref import WeakKeyDictionary
			clipDict = WeakKeyDictionary()
		for clipID, clipInfo in pos[6].items():
			mid, subid, className = clipID
			models = [m for m in modelMap.get((mid, subid), [])
					if m.__class__.__name__ == className]
			if not models:
				continue
			useClip, ox, oy, oz, nx, ny, nz, useThick, thickness = clipInfo
			if useClip:
				origin = chimera.Point(ox, oy, oz)
				normal = chimera.Vector(nx, ny, nz)
				plane = chimera.Plane(origin, normal)
			else:
				plane = chimera.Plane()
			for m in models:
				clipDict[m] = (useClip, plane,
							useThick, thickness)
		return pos[:5] + (xfDict, clipDict) + pos[7:]
	formattedPositions = {'session-start': (1.0, 927.936, (905.041, 789.375, 2312.34), (3071.89, 1552.79), 2312.34, {(2, 0): ((3261.2979319764095, 618.3883910898919, 3257.316031913546), (-0.08948864893296003, -0.9707098751392351, 0.22296663431851005, 128.92430239716103)), (1, 0): ((3261.2979319764095, 618.3883910898919, 3257.316031913546), (-0.08948864893296003, -0.9707098751392351, 0.22296663431851005, 128.92430239716103)), (0, 0): ((3261.2979319764095, 618.3883910898919, 3257.316031913546), (-0.08948864893296003, -0.9707098751392351, 0.22296663431851005, 128.92430239716103))}, {(1, 0, 'Volume'): (True, 906.2431945800781, 696.9441375732422, 2264.2266235351562, -0.7682877548203362, -0.28954374707755276, 0.570875068926133, False, 101.87811279296875), (0, 0, 'Volume'): (False, 906.8286437988281, 811.6422576904297, 2305.431396484375, -0.7682877548203362, -0.28954374707755276, 0.570875068926133, False, 73.80314025878906), (2, 0, 'Volume'): (True, 882.1725540161133, 737.9263675957918, 2271.6513061523438, -0.7682877548203362, -0.28954374707755276, 0.570875068926133, False, 147.54983390271664)}, 1, (907.1116829310647, 921.6170659410902, 2338.2200217706063), True)}
	positions = {}
	for name, fpos in formattedPositions.items():
		positions[name] = deformatPosition(fpos)
	import Midas
	if modelOffset == 0:
		Midas.positions.clear()
	Midas.positions.update(positions)

def delayedMidasBase():
	try:
		restoreMidasBase()
	except:
		reportRestoreError('Error restoring Midas base state')
import SimpleSession
SimpleSession.registerAfterModelsCB(delayedMidasBase)


try:
	import StructMeasure
	from StructMeasure.DistMonitor import restoreDistances
	registerAfterModelsCB(restoreDistances, 1)
except:
	reportRestoreError("Error restoring distances in session")


def restoreRemainder():
	from SimpleSession.versions.v52 import restoreWindowSize, \
	     restoreOpenStates, restoreSelections, restoreFontInfo, \
	     restoreOpenModelsAttrs, restoreModelClip

	curSelIds =  []
	savedSels = []
	openModelsAttrs = { 'cofrMethod': 1 }
	windowSize = (600, 600)
	xformMap = {}
	fontInfo = {'face': ('Sans Serif', 'Normal', 16)}
	clipPlaneInfo = {}

	replyobj.status("Restoring window...", blankAfter=0)
	restoreWindowSize(windowSize)
	replyobj.status("Restoring open states...", blankAfter=0)
	restoreOpenStates(xformMap)
	replyobj.status("Restoring font info...", blankAfter=0)
	restoreFontInfo(fontInfo)
	replyobj.status("Restoring selections...", blankAfter=0)
	restoreSelections(curSelIds, savedSels)
	replyobj.status("Restoring openModel attributes...", blankAfter=0)
	restoreOpenModelsAttrs(openModelsAttrs)
	replyobj.status("Restoring model clipping...", blankAfter=0)
	restoreModelClip(clipPlaneInfo)

	replyobj.status("Restoring remaining extension info...", blankAfter=0)
try:
	restoreRemainder()
except:
	reportRestoreError("Error restoring post-model state")
from SimpleSession.versions.v52 import makeAfterModelsCBs
makeAfterModelsCBs()

from SimpleSession.versions.v52 import endRestore
replyobj.status('Finishing restore...', blankAfter=0)
endRestore()
replyobj.status('Restore finished.')

