# Convert .a3m sequence alignment to fasta so it can be read by ChimeraX and shown with Profile Grid.
# This just removes the lower case letters for the sequences which are insertions.

def a3m_to_fasta(path):
    from os.path import splitext
    fasta_path = splitext(path)[0] + '.fasta'
    import re
    with open(path, 'r') as f:
        with open(fasta_path, 'w') as fasta:
            while line := f.readline():
                if not line.startswith('>'):
                    # remove lower case letters
                    line = re.sub('[a-z]', '', line)
                fasta.write(line)

from sys import argv
for a3m_path in argv[1:]:
    a3m_to_fasta(a3m_path)
