# Read ipTM scores from all dimer predictions and output a list.

def iptm_scores(predictions_dir):
    from os import listdir
    from os.path import join
    import json
    score_lines = []
    for pdir in listdir(predictions_dir):
        conf_filename = f'confidence_{pdir}_model_0.json'
        conf_path = join(predictions_dir, pdir, conf_filename)
        with open(conf_path, 'r') as f:
            scores = json.load(f)
        line = f'{"%25s"%pdir}\t{"%.3f"%scores["iptm"]}\t{"%.3f"%scores["ptm"]}\t{"%.3f"%scores["chains_ptm"]["0"]}\t{"%.3f"%scores["chains_ptm"]["1"]}\t{"%.3f"%scores["complex_plddt"]}\t{"%.3f"%scores["complex_iplddt"]}\t{"%.1f"%scores["complex_pde"]}\t{"%.1f"%scores["complex_ipde"]}'
        score_lines.append((scores['iptm'], line))

    score_lines.sort(reverse = True)
    print ('#         dimer            \tiptm\tptm\tptm1\tptm2\tplddt\tiplddt\tpde\tipde')
    print('\n'.join(line for score, line in score_lines))

from sys import argv
predictions_dir = argv[1]
iptm_scores(predictions_dir)
