def make_boltz_dimer_yaml(fasta_path, max_separation = 10, max_length = 1200):
    named_seqs = read_fasta(fasta_path)
    n = len(named_seqs)
    nlong = nyaml = 0
    for i, (name1,seq1) in enumerate(named_seqs):
        for j in range(i, min(i+max_separation+1, n)):
            name2, seq2 = named_seqs[j]
            if len(seq1) + len(seq2) > max_length:
                nlong += 1
                continue
            nyaml += 1

            if j > i:
                yaml_text = \
f'''version: 1
sequences:
  - protein:
      id: [A]
      sequence: {seq1}
      msa: "msas/{name1}_{name2}_0.csv"
  - protein:
      id: [B]
      sequence: {seq2}
      msa: "msas/{name1}_{name2}_1.csv"
'''
            else:
                yaml_text = \
f'''version: 1
sequences:
  - protein:
      id: [A,B]
      sequence: {seq1}
      msa: "msas/{name1}_{name2}_0.csv"
'''
            yaml_path = f'{name1}.{name2}.yaml'                
            with open(yaml_path, 'w') as yaml:
                yaml.write(yaml_text)
    print(f'Wrote {nyaml} Boltz input files, omitted {nlong} with sequence length > {max_length}')

def read_fasta(path):
    named_seqs = []
    with open(path, 'r') as fasta:
        name = ''
        seq_lines = []
        while line := fasta.readline():
            if line.startswith('>'):
                if name and seq_lines:
                    named_seqs.append((name, ''.join(seq_lines)))
                name = line[1:].strip()
                seq_lines.clear()
            else:
                seq_lines.append(line.strip())
        named_seqs.append((name, ''.join(seq_lines)))
    return named_seqs

from sys import argv
fasta_path = argv[1]
make_boltz_dimer_yaml(fasta_path)
