#!/bin/sh

#$ -S /bin/sh
#$ -q gpu.q
#$ -N colabfold
#$ -cwd
#$ -l h_rt=08:00:00
#$ -l mem_free=60G
#$ -l scratch=50G
#$ -l compute_cap=80,gpu_mem=40G

# Specify which GPU to use.
echo "Wynton assigned GPU" $SGE_GPU
export CUDA_VISIBLE_DEVICES=$SGE_GPU

# Add the path to the colabfold_batch executable
export PATH=/wynton/home/ferrin/goddard/localcolabfold/localcolabfold/colabfold-conda/bin:$PATH

exec colabfold_batch --num-recycle 3 sequences.fasta .
