// Copyright (c) 1998-2000 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms are permitted
// provided that the above copyright notice and this paragraph are
// duplicated in all such forms and that any documentation,
// distribution and/or use acknowledge that the software was developed
// by the Computer Graphics Laboratory, University of California,
// San Francisco.  The name of the University may not be used to
// endorse or promote products derived from this software without
// specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// IN NO EVENT SHALL THE REGENTS OF THE UNIVERSITY OF CALIFORNIA BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
// OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE.

// $Id: WrapPy.cpp,v 1.5 2001/08/20 23:08:50 pett Exp $

#define OTF_NO_SYMBOL
#define OTF_WRAPPY_EXPORT
#include "WrapPy.h"
#include "WrapPyProxy.h"

namespace otf {

PyObject* WrapPyString = PyString_FromString("__wrappy__");

const WrapPyObj*
wrappyObject(PyObject* o)
{
	if (o == NULL || !PyInstance_Check(o)) {
		PyErr_SetString(PyExc_RuntimeError, "not an instance");
		return NULL;
	}
	PyInstanceObject* obj = reinterpret_cast<PyInstanceObject*>(o);
	PyObject* tmp = PyDict_GetItem(obj->in_dict, WrapPyString);
	if (tmp == NULL) {
		PyErr_SetString(PyExc_RuntimeError, "__wrappy__ is missing");
		return NULL;
	}
	return WrapPyProxy_AsWrapPyObj(tmp);
}

void*
wrappyVoidObject(PyObject *o)
{
	if (o == NULL || !PyInstance_Check(o)) {
		PyErr_SetString(PyExc_RuntimeError, "not an instance");
		return NULL;
	}
	PyInstanceObject* obj = reinterpret_cast<PyInstanceObject*>(o);
	PyObject* tmp = PyDict_GetItem(obj->in_dict, WrapPyString);
	if (tmp == NULL) {
		PyErr_SetString(PyExc_RuntimeError, "__wrappy__ is missing");
		return NULL;
	}
	return PyCObject_AsVoidPtr(tmp);
}

void
WrapPyObj::wpyDisassociate()
{
	// only called in Python class' destructor method
	pyObj = NULL;
}

void
WrapPyObj::wpyAssociate(PyObject* o) const
{
	// only called by a Python class' __init__ method
	pyObj = o;
}

} // namespace otf

#ifdef __APPLE__
extern "C"
void callStaticInitWrappy()
{
	void __initialize_Cplusplus();
	__initialize_Cplusplus();
}
#endif
