// Copyright (c) 2000 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms are permitted
// provided that the above copyright notice and this paragraph are
// duplicated in all such forms and that any documentation,
// distribution and/or use acknowledge that the software was developed
// by the Computer Graphics Laboratory, University of California,
// San Francisco.  The name of the University may not be used to
// endorse or promote products derived from this software without
// specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// IN NO EVENT SHALL THE REGENTS OF THE UNIVERSITY OF CALIFORNIA BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
// OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE.

// $Id: WrapPyPCFWK.h,v 1.3 2000/12/28 06:10:23 gregc Exp $

#ifndef otf_WrapPyPCFWK_h
# define otf_WrapPyPCFWK_h

# include <Python.h>
# include "WrapPy.h"

namespace otf {

class WrapPyObj;

OTF_WRAPPY_IMEX extern PyTypeObject WrapPyPCFWK_Type;

inline bool
WrapPyPCFWK_Check(PyObject *obj)
{
	return obj->ob_type == &WrapPyPCFWK_Type;
}

OTF_WRAPPY_IMEX extern PyObject*
	WrapPyPCFWK_FromPCFWK(PyCFunctionWithKeywords pcfwk,
				char const* description = 0, int *debug = 0);
OTF_WRAPPY_IMEX extern PyCFunctionWithKeywords
	WrapPyPCFWK_AsPCFWK(PyObject *self);

} // namespace otf

#endif
