// Copyright (c) 1998-2000 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms are permitted
// provided that the above copyright notice and this paragraph are
// duplicated in all such forms and that any documentation,
// distribution and/or use acknowledge that the software was developed
// by the Computer Graphics Laboratory, University of California,
// San Francisco.  The name of the University may not be used to
// endorse or promote products derived from this software without
// specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// IN NO EVENT SHALL THE REGENTS OF THE UNIVERSITY OF CALIFORNIA BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
// OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE.

// $Id: compute.h,v 1.12 2000/11/16 19:49:08 gregc Exp $

#ifndef compute_h
# define compute_h

# include "ParseHeader.h"

class ClassInfo;

typedef std::vector<ClassInfo *> CIList;
typedef std::set<const ClassDecl *> CDSet;

struct ClassAttrInfo {
	otf::Symbol	name;
	std::string	get;
	std::string	set;
	bool		cache;
	ClassAttrInfo(): cache(false) {}
};
typedef std::vector<ClassAttrInfo> AttrVec;

typedef std::multimap<otf::Symbol, const FuncDecl *> MethodMap;
typedef std::pair<MethodMap::iterator, MethodMap::iterator> MethodRange;

struct ClassInfo {
	// This structure describes how a C++ class is converted to
	// a Python class or type.
	const ClassDecl	*cd;
	CIList		baseClasses;
	otf::Symbol	name;
	std::string	includeFile;
	bool		skipClass;		// class in header, no code 
	bool		isPythonClass;		// else a Python type
	bool		isWrappySubclass;	// subclass of WrapPy<>
	bool		isAbstractType;		// an implicit Python type
	bool		hasNumberMethods;
	bool		hasSequenceMethods;
	bool		hasMappingMethods;
	bool		hasBufferProcs;
	bool		dontCache;
	AttrVec		attrs;
	AttrVec		constants;
	AttrVec		variables;	// a subset of attrs that are variables
	MethodMap	attrMethods;	// attributes that are C++ member funcs
	MethodMap	methods;	// public member funcs
	MethodMap	classMethods;	// static public member funcs
	MethodMap	constructors;
	// Python type methods
	bool		print;
	MethodMap	compare, hash;
	MethodMap	call, repr, str;
	// Python number methods
	MethodMap	nb_add, nb_subtract, nb_multiply, nb_divide,
			nb_remainder, nb_divmod, nb_power, nb_negative,
			nb_positive, nb_absolute, nb_nonzero, nb_invert,
			nb_lshift, nb_rshift, nb_and, nb_xor, nb_or;
	bool		nb_coerce;
	MethodMap	nb_int, nb_long, nb_float, nb_oct, nb_hex;
	// reverse number methods for Python classes
	MethodMap	nb_radd, nb_rsubtract, nb_rmultiply, nb_rdivide,
			nb_rremainder, nb_rdivmod, nb_rpower,
			nb_rlshift, nb_rrshift, nb_rand, nb_rxor, nb_ror;
	// Python sequence methods
	MethodMap	sq_length, sq_concat, sq_repeat, sq_item,
			sq_slice, sq_ass_item, sq_ass_slice;
	// Python mapping methods
	MethodMap	mp_length, mp_subscript, mp_ass_subscript;
	// Python buffer procedures
	MethodMap	bf_getreadbuffer, bf_getwritebuffer, bf_getsegcount;

	ClassInfo(const ClassDecl *d): cd(d), name(d->name),
		skipClass(true), isPythonClass(false),
		isWrappySubclass(false), isAbstractType(false),
		hasNumberMethods(false), hasSequenceMethods(false),
		hasMappingMethods(false), hasBufferProcs(false),
		dontCache(false),
		print(0), nb_coerce(false)
	{
	}
};
typedef std::map<const ClassDecl *, const ClassInfo *> CDCIMap;

class AttrNameLt {
public:
	bool operator()(const ClassAttrInfo &a, const ClassAttrInfo &b) const
	{
		return a.name < b.name;
	}
};

class AttrNameEq {
public:
	bool operator()(const ClassAttrInfo &a, const ClassAttrInfo &b) const
	{
		return a.name == b.name;
	}
};

class AttrHasName {
	otf::Symbol name;
public:
	AttrHasName(otf::Symbol n): name(n) {}
	bool operator()(const ClassAttrInfo &a) const
	{
		return a.name == name;
	}
};

typedef std::map<otf::Symbol, const ClassDecl *> SymCDMap;

// All global declarations -- input to this module -- the parse result
extern DeclList		globalDecls;

//
// The following global variables are the output of this module
//

extern NamespaceDecl	*moduleScope;	// module scope, NULL if same as global

extern SymCDMap	classDeclsMap;		// key is C++ class name
extern CDCIMap	classInfoMap;		// key is ClassDecl*

// key is base class, values are derived classes
typedef std::multimap<otf::Symbol, otf::Symbol> DerivedClasses;
extern DerivedClasses	derivedClasses;

extern void	computeWrapInformation();

#endif
