.if t .2C
.NH 1
Introduction
.PP
.B Wrappy
is a programming tool that generates the wrapper code needed
for a C++ library to be accessible from a Python interpreter.
When combined, the wrapper code
plus the C++ library become a Python extension module.
In this paper we will discuss the reasons why we wrote this tool
and how we mesh Python and C++ semantics.
.NH 2
A Bit of History
.PP
In the spring of 1997, we had a prototype of our next generation
molecular modeling system that was written in C++ using Motif,
OpenInventor, and OpenGL libraries.
It was fast but cumbersome for prototyping work.
Then we discovered Python and Tk.
.PP
By the spring of 1998, we had another prototype that was written in
Python with Tk, OpenGL, and a thin custom C++ library
(5 classes, 29 member functions, 4 global functions).
It was easy to prototype new molecular modeling tools,
but it was slower than the earlier prototype
and at least 10 times slower than our previous generation
of modeling software.
We sped up the program by profiling the code
and rewriting parts in C++ (especially I/O),
but it was still too slow.
.PP
The challenge was to speed up the program dramatically
while preserving the ease of prototyping that Python provides.
Consequently, we increased the size of the the custom C++ library.
The initial rewrite produced 30 C++ classes,
\(ap500 member functions, and 3 global functions.
Unlike the previous version of the C++ library,
it was not reasonable to write the Python wrapper code by hand.
In the print of 1999, we wrote the
.B wrappy
program,
an automated tool for wrapping C++ code with a Python interface
in the spring of 1999.
