.NH
Object Lifetimes (Reference Counting)
.PP
A difficult problem with wrapping C++ with Python
is the dangling reference problem
\(em insuring that C++ objects don't go away
while there is a Python object that refers to it.
Sometimes that is not possible,
but we can prevent the dangling reference from crashing the Python interpreter.
.PP
Python avoids dangling references for its own objects
by maintaining a reference count.
When the reference count goes to zero, it is safe to remove the object.
In C++, it is not so simple.
Reference counting (via smart pointers) often is not used
because the overhead is deemed to be unnecessary.
Without reference counting,
programmers depend on the documentation to determine
how long objects are intended to stay around.
Wrappy depends on annotations and code modifications to do the right thing. 
.NH 2
Graph Example
.KF
.F+
figure graph.eps
.F-
.ce
.B "Figure 1"
.sp
.KE
.PP
To illustrate some of the issues in wrapping C++ classes,
consider a
.B Graph
class that manages
.B Vertex es
and
.B Edge s
(Figure 1).
When a Graph goes away,
all its Vertexes and Edges should be deleted as well.
In C++, the way a class controls the lifetime
of another class' objects is to allocate them on the heap.
That restriction is enforced by the C++ compiler
if the Vertex and Edge destructors are private,
with the Graph class being a friend of Vertex and Edge,
so it can call their destructors.
Making these three classes available in Python
requires careful management
of Python references counts and C++ object lifetimes.
.NH 2
Class Wrapping Methods
.PP
Wrappy has two methods for associating a C++ object with a Python object.
The first method is to put the C++ object inside a Python object by value.
Here the C++ object and the Python object have identical lifetimes. 
When the Python object's reference count goes to zero,
the C++ object is removed along with the Python object.
This method works for any C++ class with a copy constructor,
and works especially well for simple C++ objects
that are passed by value to other C++ functions.
.PP
The second method is to have the Python object keep a pointer
to the C++ object.
Here the C++ class must inherit from a particular base class known to wrappy.
The base class keeps a pointer to the Python object
that the C++ object belongs to.
The Python object is lazily created,
so a C++ object need not have a Python object associated with it.
The works well for the Vertex and Edge classes above.
.PP
In the second method,
a pointer from the C++ object back to the Python object is needed
for two reasons.
Every time the C++ object is converted to a Python object
that it should return the same Python object.
Secondly, if the C++ object goes away early,
it can tell the Python object,
so the Python object can throw an exception if it is used.
Early removal of the C++ object should only happen
when the C++ object's lifetime is controlled by the C++ code.
Wrappy detects this case based on annotations
and the presence of a private destructor.
Wrappy gives the Python object an extra reference
to prevent the reference count from going to zero.
When the C++ object is deleted,
it decrements the Python object's reference count which frees it.
This method also works with private constructors.
.NH 2
Attribute Caching
.PP
There is still a synchronization problem between cross references
among C++ objects
and the reference counts of the corresponding Python objects.
When a Python object's reference count goes to zero,
it is removed and the memory reclaimed.
The trick to synchronizing the reference count is to notice when
the C++ object is keeping a reference to another C++ object.
The technique is to cue off accessing attributes
and other annotated functions.
Consider the example:
.ID
.ft C
define colorVertex(v):
	c = Color("green")
	v.color = c
.ft P
.DE
Here a local object,
.I c ,
is initialized with a new Python/C++ object
and that object is assigned to an attribute of another hybrid Python object.
Internally,
the C++ Vertex object's color is set to the C++ Color object.
If the reference count of the Python Color object isn't incremented
by the assignment,
when the local object goes away,
its reference count will go to zero.
Python will delete it and the associated C++ object,
and the C++ Vertex object is left with a a dangling reference.
A similar scenario exists for getting attributes.
Consequently,
whenever an attribute of object
.I P
is accessed, get or set to Python object
.I Q ,
a reference to
.I Q
is saved in
.I P .
Saving the reference is known as attributes caching.
