// Copyright (c) 2000 The Regents of the University of California.
// All rights reserved.
//
// Redistribution and use in source and binary forms are permitted
// provided that the above copyright notice and this paragraph are
// duplicated in all such forms and that any documentation,
// distribution and/or use acknowledge that the software was developed
// by the Computer Graphics Laboratory, University of California,
// San Francisco.  The name of the University may not be used to
// endorse or promote products derived from this software without
// specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// IN NO EVENT SHALL THE REGENTS OF THE UNIVERSITY OF CALIFORNIA BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
// OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE.

// $Id: WrapPyPCFWK.cpp,v 1.3 2001/02/07 01:17:32 gregc Exp $

#define OTF_NO_SYMBOL
#define OTF_WRAPPY_EXPORT
#include <iostream>
#include "WrapPyPCFWK.h"

namespace otf {

struct WrapPyPCFWK: public PyObject {
	PyCFunctionWithKeywords pcfwk;
	const char* description;
	int* debug;
};

PyObject*
WrapPyPCFWK_FromPCFWK(PyCFunctionWithKeywords pcfwk, const char *description,
								int *debug)
{
	WrapPyPCFWK* self = PyObject_NEW(WrapPyPCFWK, &WrapPyPCFWK_Type);
	if (self == NULL)
		return NULL;
	self->pcfwk = pcfwk;
	self->description = description;
	self->debug = debug;
	return (PyObject *)self;
}

PyCFunctionWithKeywords
WrapPyPCFWK_AsPCFWK(PyObject* self)
{
	if (self == NULL) {
		if (!PyErr_Occurred())
			PyErr_SetString(PyExc_TypeError,
			  "WrapPyPCFWK_AsPCFWK called with null pointer");
		return NULL;
	}
	if (!WrapPyPCFWK_Check(self)) {
		PyErr_SetString(PyExc_TypeError,
			"WrapPyPCFWK_AsPCFWK with non-WrapPyPCFWK-object");
		return NULL;
	}
	WrapPyPCFWK* wpp = static_cast<WrapPyPCFWK*>(self);
	return wpp->pcfwk;
}

extern "C" {

static void
WrapPyPCFWK_dealloc(PyObject* self)
{
	WrapPyPCFWK* wpp = static_cast<WrapPyPCFWK*>(self);
	if (wpp->debug && *wpp->debug >= 6)
		std::cerr << "Deallocating " << wpp->description << ": "
							<< wpp->pcfwk << '\n';
	PyMem_DEL(self);
}

} // extern "C"

static char WrapPyPCFWK_Type__doc__[] = 
"PCFWK class to keep track of PyCObjectWithKeywords objects";

PyTypeObject WrapPyPCFWK_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,			// ob_size
	"WrapPyPCFWK",		// tp_name
	sizeof(WrapPyPCFWK),	// tp_basicsize
	0,			// tp_itemsize
	WrapPyPCFWK_dealloc,	// tp_dealloc
	0,			// tp_print
	0,			// tp_getattr
	0,			// tp_setattr
	0,			// tp_compare
	0,			// tp_repr
	0,			// tp_as_number
	0,			// tp_as_sequence
	0,			// tp_as_mapping
	0,			// tp_hash
	0,			// tp_call
	0,			// tp_str
	0,			// tp_getattro
	0,			// tp_setattro
	0,			// tp_as_buffer
	0,			// tp_flags
	WrapPyPCFWK_Type__doc__	// tp_doc
};

} // namespace otf
