.if !t .na
.TL
Wrappy \(em a Python Wrapper Generator for C++ Classes
.AU
Gregory S. Couch
Conrad C. Huang
Thomas E. Ferrin
.AI
University of California
Computer Graphics Laboratory
San Francisco, CA  94143-0446
gregc@cgl.ucsf.edu
.AB
Wrappy generates a Python extension module from annotated C++ header files.
Wrappy's power comes from how it translates C++ features to Python features:
standard C++ container classes are mapped to Python lists and dictionaries;
C++ classes are converted to Python types
(or a Python-subclassable extension class [.Extension Classes.]);
public member data and accessor member functions are mapped to attributes;
C++ exceptions are mapped to Python exceptions;
overloaded functions are supported;
function argument names are used for Python keyword arguments.
Annotating C++ header files is necessary to designate output arguments
in functions and to choose how C++ classes are wrapped.
Some C++ source code modifications are necessary 
to harmonize C++ and Python object semantics 
and to work around limitations in wrappy.
.PP
The impetus behind wrappy was to generate wrapper code
for our (growing) C++ molecular graphics library
with 500 member functions in 30 classes.
Writing and maintaining wrapper code by hand
for that many functions was unappealing.
We also found that existing wrapper generators didn't support
all the C++ features we use.
Wrappy generates code that is similar to hand-crafted wrapper code,
but more robust.
The C++ header files generate about 30 times their ``weight''
in Python interface code
(in our case, from 850 lines in C++ header files
to over 25,000 lines of Python interface code).
.AE
