.NH
Making C++ Code Accessible from Python
.NH 2
Python and C++ Compatibility
.PP
One design goal was to get as much Python behavior
out of our of C++ code as possible.
Standard C++ and Python have many features in common.
We were able to convert C++ exceptions to Python exceptions;
convert standard C++ container classes to and from Python containers (by value);
use C++ function argument names for Python function keyword arguments;
convert C++ member data to Python class/type attributes;
return C++ output function argument in Python tuples;
.I etc.
We also map C++ accessor member functions into Python type attributes,
which makes the Python interface simpler than the C++ interface.
.PP
Where C++ and Python don't match,
the Python functionality is generally a subset of the C++ functionality.
For instance, Python has no concept of a constant object.
Here, wrappy depends on the compiler to give an error
when it tries to compile the wrapper code.
.NH 3
Example:  Accessor Functions as Attributes
.PP
An accessor function in C++ is a function
that gets or sets the value of private member data.
They are used to track changes in the member data
and to keep a backwards-compatible interface during class design changes.
For example, given the two C++ member functions:
.ID
.ft C
std::string name() const;
void setName(
	const std::string &n);
.ft P
.DE
Those two functions are combined into the Python attribute
.B name .
Getting the attribute's value invokes the C++
.I name
function,
and setting the value invokes the C++
.I setName
function.
.NH 2
Basic Ideas
.PP
As hinted above,
the basic idea behind wrappy is
that a C++ class should be made into a Python type.
A Python type is different from a Python class:
it is
.I not
subclassable.
We can't generate a Python class,
because the Python class methods could not be C functions
(no longer true in Python 1.5.2!).
There is a third-party extension to Python,
Extension Class[.Extension Classes.] from Jim Fulton at Digital Creations,
that provides the missing functionality.
Wrappy optionally generates code that uses Extension Class
if a C++ class needs to be subclassable in Python.
.PP
One advantage that the Python class mechanism has over the
Python type mechanism is
that the class methods are found by hashing
and the type methods are found by linear search.
For the Python primitive types,
this has not been a problem because the number of methods is small,
and they are placed in most commonly used order as determined by profiling.
For the Python types that we generate from C++ classes,
the number of methods is large (averaging 17 methods per C++ class),
so we use a publicly available near-perfect hash generator, gperf[.gperf.],
to speed up method lookup.
.PP
Another basic idea is
that wrappy should decide what Python interface to generate
by parsing C++ declaration syntax.
The C++ declarations are optionally annotated with special comments.
For example,
annotations are needed to designate output function arguments.
These annotations don't work well for bulk removal of sections
that should not be wrapped
(\fIe.g.\fP, some member functions shouldn't be accessible to Python).
The solution is to use only a subset of the the C++ header files,
or embed ifdef's and use the C preprocessor to pipe the input to wrappy.
.NH 3
Example:  Function Output Arguments
.PP
Sometimes a function returns information through some of its arguments.
Often it is because it needs to return more than one value.
Output arguments are annotated with an \fCOUT\fP comment.
For example, the C++ function:
.ID
.ft C
void bounds(const
	std::vector<int> &list,
	/*OUT*/ int *min,
	/*OUT*/ int *max);
.ft P
.DE
is converted into a single argument Python function
that returns a 2-tuple (min, max).
The argument is checked to confirm that it is a sequence of integers
and if not, an exception is raised.
