# -----------------------------------------------------------------------------
# Templates for spin graphs
#

# -----------------------------------------------------------------------------
# Templates for 20 standard amino acids.
#
protein_layout = {
  'A': {
	'C':((217, 569), 'red', (217, 605)),
	'CA':((143, 482), 'red', (140, 520)),
	'CB':((145, 376), 'red', (194, 361)),
	'H':((62, 570), 'yellow', (62, 607)),
	'HA':((140, 570), 'yellow', (140, 607)),
	'HB1':((152, 286), 'yellow', (161, 251)),
	'HB2':((62, 284), 'yellow', (59, 247)),
	'HB3':((237, 286), 'yellow', (266, 251)),
	'MB':((62, 284), 'yellow', (59, 247)),
	'N':((65, 482), 'blue', (65, 517)),
	},
  'C': {
	'C':((234, 570), 'red', (234, 604)),
	'CA':((151, 496), 'red', (151, 532)),
	'CB':((146, 421), 'red', (146, 457)),
	'H':((60, 569), 'yellow', (60, 606)),
	'HA':((152, 569), 'yellow', (152, 606)),
	'HB2':((61, 407), 'yellow', (61, 442)),
	'HB3':((239, 407), 'yellow', (239, 442)),
	'HG':((139, 305), 'yellow', (139, 341)),
	'N':((61, 493), 'blue', (61, 528)),
	'QB':((61, 407), 'yellow', (61, 442)),
	},
  'D': {
	'C':((245, 570), 'red', (245, 606)),
	'CA':((156, 493), 'red', (156, 528)),
	'CB':((151, 391), 'red', (179, 362)),
	'CG':((151, 295), 'red', (106, 303)),
	'H':((54, 569), 'yellow', (54, 606)),
	'HA':((153, 568), 'yellow', (153, 604)),
	'HB2':((61, 389), 'yellow', (20, 421)),
	'HB3':((240, 389), 'yellow', (276, 429)),
	'HD2':((145, 236), 'yellow', (143, 199)),
	'N':((54, 489), 'blue', (54, 525)),
	'QB':((61, 389), 'yellow', (20, 421)),
	},
  'E': {
	'C':((238, 570), 'red', (236, 605)),
	'CA':((151, 498), 'red', (151, 534)),
	'CB':((151, 425), 'red', (151, 461)),
	'CD':((151, 278), 'red', (151, 313)),
	'CG':((151, 352), 'red', (151, 388)),
	'H':((58, 565), 'yellow', (55, 601)),
	'HA':((149, 565), 'yellow', (147, 601)),
	'HB2':((61, 418), 'yellow', (58, 454)),
	'HB3':((241, 422), 'yellow', (238, 458)),
	'HE2':((147, 225), 'yellow', (137, 190)),
	'HG2':((58, 345), 'yellow', (56, 381)),
	'HG3':((241, 335), 'yellow', (238, 370)),
	'N':((58, 500), 'blue', (58, 535)),
	'QB':((61, 418), 'yellow', (58, 454)),
	'QG':((58, 345), 'yellow', (56, 381)),
	},
  'F': {
	'C':((245, 568), 'red', (245, 603)),
	'CA':((150, 494), 'red', (149, 529)),
	'CB':((147, 408), 'red', (147, 444)),
	'CD1':((54, 237), 'red', (54, 272)),
	'CD2':((232, 251), 'red', (232, 286)),
	'CE1':((54, 147), 'red', (54, 183)),
	'CE2':((232, 156), 'red', (232, 192)),
	'CG':((140, 318), 'red', (140, 354)),
	'CQD':((54, 237), 'red', (54, 272)),
	'CQE':((54, 147), 'red', (54, 183)),
	'CZ':((154, 102), 'red', (154, 138)),
	'H':((60, 565), 'yellow', (60, 599)),
	'HA':((152, 570), 'yellow', (152, 607)),
	'HB2':((67, 419), 'yellow', (67, 454)),
	'HB3':((234, 399), 'yellow', (234, 434)),
	'HD1':((10, 222), 'yellow', (-30, 204)),
	'HD2':((289, 249), 'yellow', (312, 225)),
	'HE1':((13, 133), 'yellow', (31, 111)),
	'HE2':((256, 109), 'yellow', (312, 124)),
	'HZ':((159, 52), 'yellow', (211, 60)),
	'N':((57, 492), 'blue', (57, 528)),
	'QB':((67, 419), 'yellow', (67, 454)),
	'QD':((10, 222), 'yellow', (-30, 204)),
	'QE':((13, 133), 'yellow', (31, 111)),
	},
  'G': {
	'C':((229, 568), 'red', (229, 603)),
	'CA':((146, 484), 'red', (146, 519)),
	'H':((74, 562), 'yellow', (74, 598)),
	'HA2':((148, 570), 'yellow', (148, 606)),
	'HA3':((146, 420), 'yellow', (146, 377)),
	'N':((70, 485), 'blue', (70, 521)),
	'QA':((148, 570), 'yellow', (148, 606)),
	},
  'H': {
	'C':((252, 570), 'red', (252, 605)),
	'CA':((158, 496), 'red', (158, 531)),
	'CB':((151, 411), 'red', (151, 447)),
	'CD2':((228, 287), 'red', (228, 324)),
	'CE1':((85, 200), 'red', (110, 232)),
	'CG':((146, 328), 'red', (146, 363)),
	'H':((65, 567), 'yellow', (65, 603)),
	'HA':((165, 565), 'yellow', (165, 601)),
	'HB2':((64, 413), 'yellow', (64, 449)),
	'HB3':((246, 404), 'yellow', (246, 440)),
	'HD1':((16, 287), 'yellow', (16, 259)),
	'HD2':((283, 282), 'yellow', (278, 252)),
	'HE1':((89, 145), 'yellow', (46, 116)),
	'HE2':((212, 141), 'yellow', (189, 107)),
	'N':((60, 497), 'blue', (60, 533)),
	'ND1':((73, 284), 'blue', (73, 321)),
	'NE2':((196, 190), 'blue', (255, 188)),
	'QB':((64, 413), 'yellow', (64, 449)),
	},
  'I': {
	'C':((223, 568), 'red', (223, 603)),
	'CA':((128, 493), 'red', (128, 528)),
	'CB':((126, 410), 'red', (126, 446)),
	'CD1':((109, 256), 'red', (142, 289)),
	'CG1':((124, 335), 'red', (124, 370)),
	'CG2':((229, 408), 'red', (218, 441)),
	'CQG':((124, 335), 'red', (124, 370)),
	'H':((41, 567), 'yellow', (41, 604)),
	'HA':((135, 570), 'yellow', (135, 605)),
	'HB':((38, 403), 'yellow', (38, 439)),
	'HD11':((121, 213), 'yellow', (147, 182)),
	'HD12':((72, 209), 'yellow', (12, 202)),
	'HD13':((175, 211), 'yellow', (229, 236)),
	'HG12':((67, 342), 'yellow', (-1, 337)),
	'HG13':((69, 310), 'yellow', (8, 293)),
	'HG21':((220, 353), 'yellow', (227, 328)),
	'HG22':((242, 370), 'yellow', (309, 360)),
	'HG23':((261, 389), 'yellow', (321, 415)),
	'MD1':((72, 209), 'yellow', (12, 202)),
	'MG2':((242, 370), 'yellow', (309, 360)),
	'N':((40, 494), 'blue', (40, 529)),
	'QG1':((67, 342), 'yellow', (-1, 337)),
	},
  'K': {
	'C':((233, 570), 'red', (233, 605)),
	'CA':((148, 500), 'red', (148, 534)),
	'CB':((139, 419), 'red', (139, 454)),
	'CD':((150, 255), 'red', (150, 290)),
	'CE':((146, 174), 'red', (146, 210)),
	'CG':((143, 338), 'red', (143, 374)),
	'H':((59, 565), 'yellow', (59, 601)),
	'HA':((150, 563), 'yellow', (150, 599)),
	'HB2':((62, 421), 'yellow', (62, 457)),
	'HB3':((223, 423), 'yellow', (223, 459)),
	'HD2':((62, 245), 'yellow', (62, 281)),
	'HD3':((221, 257), 'yellow', (221, 292)),
	'HE2':((60, 169), 'yellow', (60, 205)),
	'HE3':((223, 186), 'yellow', (223, 222)),
	'HG2':((60, 327), 'yellow', (60, 362)),
	'HG3':((235, 348), 'yellow', (235, 384)),
	'HZ1':((169, 37), 'yellow', (169, 73)),
	'HZ2':((68, 92), 'yellow', (68, 126)),
	'HZ3':((240, 101), 'yellow', (240, 137)),
	'MZ':((68, 92), 'yellow', (68, 126)),
	'N':((62, 500), 'blue', (62, 536)),
	'NZ':((160, 99), 'blue', (160, 134)),
	'QB':((62, 421), 'yellow', (62, 457)),
	'QD':((62, 245), 'yellow', (62, 281)),
	'QE':((60, 169), 'yellow', (60, 205)),
	'QG':((60, 327), 'yellow', (60, 362)),
	},
  'L': {
	'C':((230, 566), 'red', (230, 602)),
	'CA':((144, 480), 'red', (144, 516)),
	'CB':((144, 388), 'red', (144, 424)),
	'CD1':((66, 222), 'red', (127, 217)),
	'CD2':((235, 205), 'red', (235, 240)),
	'CG':((139, 285), 'red', (139, 322)),
	'CQD':((66, 222), 'red', (127, 217)),
	'H':((42, 570), 'yellow', (42, 606)),
	'HA':((146, 557), 'yellow', (146, 592)),
	'HB2':((49, 382), 'yellow', (49, 416)),
	'HB3':((233, 388), 'yellow', (233, 424)),
	'HD11':((58, 156), 'yellow', (92, 120)),
	'HD12':((23, 170), 'yellow', (-14, 151)),
	'HD13':((92, 163), 'yellow', (155, 165)),
	'HD21':((246, 160), 'yellow', (297, 125)),
	'HD22':((217, 165), 'yellow', (194, 110)),
	'HD23':((276, 172), 'yellow', (322, 203)),
	'HG':((61, 281), 'yellow', (61, 318)),
	'MD1':((23, 170), 'yellow', (-14, 151)),
	'MD2':((217, 165), 'yellow', (194, 110)),
	'N':((44, 479), 'blue', (44, 514)),
	'QB':((49, 382), 'yellow', (49, 416)),
	'QMD':((23, 170), 'yellow', (-14, 151)),
	},
  'M': {
	'C':((237, 570), 'red', (237, 605)),
	'CA':((150, 493), 'red', (150, 528)),
	'CB':((136, 403), 'red', (167, 375)),
	'CE':((136, 225), 'red', (164, 201)),
	'CG':((150, 308), 'red', (119, 279)),
	'H':((67, 565), 'yellow', (67, 602)),
	'HA':((155, 569), 'yellow', (155, 605)),
	'HB2':((77, 401), 'yellow', (16, 412)),
	'HB3':((214, 412), 'yellow', (278, 431)),
	'HE1':((136, 145), 'yellow', (143, 97)),
	'HE2':((67, 194), 'yellow', (6, 192)),
	'HE3':((205, 199), 'yellow', (266, 182)),
	'HG2':((72, 308), 'yellow', (10, 301)),
	'HG3':((212, 306), 'yellow', (273, 316)),
	'ME':((67, 194), 'yellow', (6, 192)),
	'N':((62, 485), 'blue', (62, 521)),
	'QB':((77, 401), 'yellow', (16, 412)),
	'QG':((72, 308), 'yellow', (10, 301)),
	},
  'N': {
	'C':((222, 568), 'red', (222, 603)),
	'CA':((139, 501), 'red', (139, 536)),
	'CB':((141, 423), 'red', (141, 458)),
	'CG':((132, 340), 'red', (132, 376)),
	'H':((60, 570), 'yellow', (60, 607)),
	'HA':((143, 567), 'yellow', (144, 604)),
	'HB2':((61, 426), 'yellow', (61, 461)),
	'HB3':((241, 428), 'yellow', (241, 463)),
	'HD21':((87, 216), 'yellow', (66, 180)),
	'HD22':((167, 209), 'yellow', (189, 173)),
	'N':((58, 499), 'blue', (58, 534)),
	'ND2':((130, 266), 'blue', (130, 303)),
	'QB':((61, 426), 'yellow', (61, 461)),
	'QD2':((87, 216), 'yellow', (66, 180)),
	},
  'P': {
	'C':((239, 566), 'red', (239, 602)),
	'CA':((151, 495), 'red', (151, 531)),
	'CB':((141, 351), 'red', (141, 387)),
	'CD':((146, 161), 'red', (146, 196)),
	'CG':((151, 251), 'red', (151, 287)),
	'H2':((73, 565), 'yellow', (73, 601)),
	'H3':((241, 418), 'yellow', (241, 454)),
	'HA':((158, 570), 'yellow', (158, 605)),
	'HB2':((71, 346), 'yellow', (71, 383)),
	'HB3':((226, 349), 'yellow', (226, 385)),
	'HD2':((58, 163), 'yellow', (58, 199)),
	'HD3':((238, 166), 'yellow', (238, 202)),
	'HG2':((68, 249), 'yellow', (68, 284)),
	'HG3':((241, 251), 'yellow', (241, 287)),
	'N':((68, 495), 'blue', (68, 530)),
	'QB':((71, 346), 'yellow', (71, 383)),
	'QD':((58, 163), 'yellow', (58, 199)),
	'QG':((68, 249), 'yellow', (68, 284)),
	},
  'Q': {
	'C':((235, 565), 'red', (235, 601)),
	'CA':((148, 504), 'red', (148, 540)),
	'CB':((148, 410), 'red', (148, 445)),
	'CD':((134, 257), 'red', (134, 293)),
	'CG':((145, 331), 'red', (145, 366)),
	'H':((63, 567), 'yellow', (61, 603)),
	'HA':((160, 570), 'yellow', (158, 607)),
	'HB2':((74, 405), 'yellow', (72, 440)),
	'HB3':((240, 403), 'yellow', (238, 438)),
	'HE21':((94, 138), 'yellow', (74, 111)),
	'HE22':((151, 138), 'yellow', (217, 125)),
	'HG2':((54, 333), 'yellow', (51, 369)),
	'HG3':((245, 336), 'yellow', (243, 371)),
	'N':((61, 499), 'blue', (61, 535)),
	'NE2':((134, 184), 'blue', (134, 219)),
	'QB':((74, 405), 'yellow', (72, 440)),
	'QE2':((94, 138), 'yellow', (74, 111)),
	'QG':((54, 333), 'yellow', (51, 369)),
	},
  'R': {
	'C':((243, 568), 'red', (243, 603)),
	'CA':((159, 497), 'red', (159, 532)),
	'CB':((150, 413), 'red', (150, 449)),
	'CD':((143, 235), 'red', (143, 271)),
	'CG':((147, 317), 'red', (147, 352)),
	'CZ':((140, 51), 'red', (140, 86)),
	'H':((66, 560), 'yellow', (66, 595)),
	'HA':((157, 570), 'yellow', (157, 607)),
	'HB2':((63, 404), 'yellow', (63, 440)),
	'HB3':((238, 407), 'yellow', (238, 442)),
	'HD2':((60, 228), 'yellow', (60, 264)),
	'HD3':((231, 240), 'yellow', (231, 276)),
	'HE':((81, 146), 'yellow', (81, 182)),
	'HG2':((56, 312), 'yellow', (56, 347)),
	'HG3':((228, 319), 'yellow', (233, 354)),
	'HH11':((56, 4), 'yellow', (1, -22)),
	'HH12':((95, 0), 'yellow', (119, -24)),
	'HH21':((199, 10), 'yellow', (238, -19)),
	'HH22':((240, 17), 'yellow', (307, 27)),
	'N':((64, 493), 'blue', (64, 528)),
	'NE':((147, 143), 'blue', (147, 178)),
	'NH1':((74, 51), 'blue', (29, 84)),
	'NH2':((209, 51), 'blue', (247, 86)),
	'NQH':((74, 51), 'blue', (29, 84)),
	'QB':((63, 404), 'yellow', (63, 440)),
	'QD':((60, 228), 'yellow', (60, 264)),
	'QG':((56, 312), 'yellow', (56, 347)),
	'QH1':((56, 4), 'yellow', (1, -22)),
	'QH2':((199, 10), 'yellow', (238, -19)),
	'QQH':((56, 4), 'yellow', (1, -22)),
	},
  'S': {
	'C':((237, 565), 'red', (237, 600)),
	'CA':((144, 496), 'red', (144, 530)),
	'CB':((142, 413), 'red', (172, 390)),
	'H':((65, 570), 'yellow', (65, 607)),
	'HA':((147, 565), 'yellow', (147, 601)),
	'HB2':((76, 410), 'yellow', (33, 376)),
	'HB3':((224, 408), 'yellow', (274, 385)),
	'HG':((135, 302), 'yellow', (108, 268)),
	'N':((62, 496), 'blue', (62, 530)),
	'QB':((76, 410), 'yellow', (33, 376)),
	},
  'T': {
	'C':((235, 569), 'red', (235, 605)),
	'CA':((148, 500), 'red', (148, 536)),
	'CB':((139, 422), 'red', (139, 458)),
	'CG2':((139, 352), 'red', (139, 388)),
	'H':((66, 570), 'yellow', (66, 606)),
	'HA':((155, 570), 'yellow', (155, 604)),
	'HB':((79, 420), 'yellow', (79, 456)),
	'HG1':((96, 318), 'yellow', (82, 289)),
	'HG21':((200, 333), 'yellow', (252, 316)),
	'HG22':((167, 302), 'yellow', (221, 278)),
	'HG23':((146, 266), 'yellow', (214, 245)),
	'MG2':((167, 302), 'yellow', (221, 278)),
	'N':((64, 497), 'blue', (64, 532)),
	},
  'V': {
	'C':((234, 563), 'red', (234, 597)),
	'CA':((141, 497), 'red', (141, 533)),
	'CB':((137, 405), 'red', (137, 440)),
	'CG1':((61, 322), 'red', (61, 358)),
	'CG2':((224, 310), 'red', (224, 345)),
	'CQG':((61, 322), 'red', (61, 358)),
	'H':((48, 570), 'yellow', (48, 607)),
	'HA':((144, 570), 'yellow', (144, 607)),
	'HB':((226, 403), 'yellow', (226, 437)),
	'HG11':((53, 281), 'yellow', (21, 247)),
	'HG12':((28, 286), 'yellow', (-35, 292)),
	'HG13':((82, 286), 'yellow', (130, 252)),
	'HG21':((235, 259), 'yellow', (255, 234)),
	'HG22':((207, 270), 'yellow', (153, 292)),
	'HG23':((271, 270), 'yellow', (310, 310)),
	'MG1':((28, 286), 'yellow', (-35, 292)),
	'MG2':((207, 270), 'yellow', (153, 292)),
	'N':((51, 497), 'blue', (51, 533)),
	'QMG':((28, 286), 'yellow', (-35, 292)),
	},
  'W': {
	'C':((271, 569), 'red', (271, 604)),
	'CA':((177, 504), 'red', (177, 540)),
	'CB':((177, 424), 'red', (177, 459)),
	'CD1':((82, 341), 'red', (82, 376)),
	'CD2':((198, 254), 'red', (197, 289)),
	'CE2':((114, 212), 'red', (114, 247)),
	'CE3':((259, 202), 'red', (259, 237)),
	'CG':((175, 341), 'red', (176, 376)),
	'CH2':((167, 93), 'red', (167, 128)),
	'CZ2':((87, 135), 'red', (87, 171)),
	'CZ3':((249, 118), 'red', (249, 154)),
	'H':((81, 569), 'yellow', (80, 606)),
	'HA':((185, 570), 'yellow', (186, 607)),
	'HB2':((80, 428), 'yellow', (80, 464)),
	'HB3':((278, 418), 'yellow', (278, 455)),
	'HD1':((36, 329), 'yellow', (-2, 361)),
	'HE1':((0, 252), 'yellow', (-48, 252)),
	'HE3':((300, 188), 'yellow', (358, 197)),
	'HH2':((145, 63), 'yellow', (120, 33)),
	'HZ2':((46, 120), 'yellow', (11, 86)),
	'HZ3':((262, 87), 'yellow', (279, 51)),
	'N':((77, 503), 'blue', (76, 538)),
	'NE1':((46, 254), 'blue', (76, 292)),
	'QB':((80, 428), 'yellow', (80, 464)),
	},
  'Y': {
	'C':((246, 566), 'red', (246, 600)),
	'CA':((151, 491), 'red', (151, 527)),
	'CB':((148, 406), 'red', (148, 440)),
	'CD1':((89, 265), 'red', (89, 302)),
	'CD2':((217, 266), 'red', (231, 318)),
	'CE1':((92, 192), 'red', (92, 228)),
	'CE2':((224, 183), 'red', (224, 218)),
	'CG':((146, 323), 'red', (146, 358)),
	'CQD':((89, 265), 'red', (89, 302)),
	'CQE':((92, 192), 'red', (92, 228)),
	'CZ':((153, 147), 'red', (153, 183)),
	'H':((54, 570), 'yellow', (54, 606)),
	'HA':((160, 566), 'yellow', (160, 603)),
	'HB2':((61, 410), 'yellow', (61, 446)),
	'HB3':((246, 410), 'yellow', (246, 446)),
	'HD1':((25, 278), 'yellow', (4, 244)),
	'HD2':((276, 273), 'yellow', (303, 244)),
	'HE1':((23, 166), 'yellow', (28, 134)),
	'HE2':((243, 126), 'yellow', (246, 88)),
	'HH':((141, 101), 'yellow', (105, 78)),
	'N':((58, 491), 'blue', (58, 527)),
	'QB':((61, 410), 'yellow', (61, 446)),
	'QD':((25, 278), 'yellow', (4, 244)),
	'QE':((23, 166), 'yellow', (28, 134)),
	},
  }

# -----------------------------------------------------------------------------
# Templates for DNA
#
dna_rna_layout = {
  'A': {
	"C1'":((188, 420), 'red', (162, 396)),
	'C2':((59, 171), 'red', (77, 143)),
	"C2'":((152, 473), 'red', (141, 441)),
	"C3'":((77, 473), 'red', (87, 445)),
	'C4':((165, 165), 'red', (175, 192)),
	"C4'":((42, 422), 'red', (79, 400)),
	'C5':((160, 102), 'red', (150, 137)),
	"C5'":((42, 360), 'red', (83, 347)),
	'C6':((102, 72), 'red', (105, 107)),
	'C8':((252, 126), 'red', (274, 156)),
	"H1'":((218, 381), 'cyan', (261, 349)),
	'H2':((19, 190), 'blue', (-6, 158)),
	"H2'1":((203, 471), 'cyan', (259, 460)),
	"H2'2":((177, 505), 'cyan', (225, 539)),
	"H3'":((42, 503), 'cyan', (62, 542)),
	"H4'":((0, 417), 'cyan', (-45, 447)),
	"H5'1":((14, 304), 'cyan', (-10, 274)),
	"H5'2":((66, 304), 'cyan', (98, 267)),
	'H61':((62, 0), 'blue', (62, -32)),
	'H62':((126, 0), 'blue', (126, -34)),
	'H8':((300, 107), 'blue', (310, 66)),
	'N1':((57, 107), 'green', (23, 77)),
	'N3':((104, 203), 'green', (126, 229)),
	'N6':((100, 30), 'green', (68, 36)),
	'N7':((212, 72), 'green', (231, 40)),
	'N9':((218, 180), 'green', (250, 216)),
	},
  'C': {
	"C1'":((222, 407), 'red', (203, 379)),
	'C2':((72, 171), 'red', (57, 145)),
	"C2'":((192, 460), 'red', (190, 428)),
	"C3'":((132, 460), 'red', (143, 430)),
	'C4':((130, 70), 'red', (130, 40)),
	"C4'":((92, 409), 'red', (128, 392)),
	'C5':((188, 98), 'red', (169, 68)),
	"C5'":((87, 349), 'red', (124, 355)),
	'C6':((186, 165), 'red', (184, 134)),
	"H1'":((257, 375), 'cyan', (282, 340)),
	"H2'1":((237, 467), 'cyan', (293, 490)),
	"H2'2":((210, 497), 'cyan', (225, 537)),
	"H3'":((94, 499), 'cyan', (68, 539)),
	"H4'":((42, 424), 'cyan', (-4, 426)),
	'H41':((94, 8), 'blue', (94, -23)),
	'H42':((167, 6), 'blue', (167, -25)),
	'H5':((229, 77), 'blue', (276, 51)),
	"H5'1":((51, 300), 'cyan', (32, 263)),
	"H5'2":((102, 297), 'cyan', (132, 263)),
	'H6':((212, 192), 'blue', (246, 169)),
	'N1':((132, 195), 'green', (128, 180)),
	'N3':((68, 98), 'green', (104, 109)),
	},
  'G': {
	"C1'":((158, 358), 'red', (149, 328)),
	'C2':((81, 121), 'red', (55, 95)),
	"C2'":((130, 418), 'red', (152, 393)),
	"C3'":((70, 421), 'red', (79, 397)),
	'C4':((171, 112), 'red', (173, 142)),
	"C4'":((42, 354), 'red', (79, 346)),
	'C5':((173, 67), 'red', (173, 22)),
	"C5'":((40, 286), 'red', (83, 296)),
	'C6':((124, 43), 'red', (124, 11)),
	'C8':((257, 86), 'red', (265, 58)),
	'H1':((40, 35), 'blue', (4, 9)),
	"H1'":((209, 337), 'cyan', (242, 307)),
	"H2'1":((182, 446), 'cyan', (237, 466)),
	"H2'2":((132, 470), 'cyan', (169, 515)),
	"H3'":((32, 470), 'cyan', (-8, 513)),
	"H4'":((0, 376), 'cyan', (-40, 414)),
	"H5'1":((23, 247), 'cyan', (-8, 223)),
	"H5'2":((66, 249), 'cyan', (90, 217)),
	'H8':((299, 86), 'blue', (327, 56)),
	'N1':((81, 67), 'green', (83, 37)),
	'N2':((42, 140), 'green', (8, 153)),
	'N3':((119, 140), 'green', (124, 170)),
	'N7':((222, 48), 'green', (237, 13)),
	'N9':((222, 136), 'green', (261, 163)),
	},
  'T': {
	"C1'":((240, 370), 'red', (276, 383)),
	'C2':((77, 156), 'red', (64, 184)),
	"C2'":((199, 439), 'red', (205, 407)),
	"C3'":((122, 439), 'red', (141, 413)),
	'C4':((139, 57), 'red', (141, 27)),
	"C4'":((94, 370), 'red', (135, 368)),
	'C5':((197, 90), 'red', (164, 105)),
	"C5'":((92, 308), 'red', (122, 332)),
	'C6':((199, 154), 'red', (220, 184)),
	'C7':((225, 62), 'red', (246, 90)),
	"H1'":((274, 336), 'cyan', (276, 282)),
	"H2'1":((248, 443), 'cyan', (300, 460)),
	"H2'2":((212, 480), 'cyan', (229, 518)),
	'H3':((59, 55), 'blue', (59, 23)),
	"H3'":((98, 477), 'cyan', (51, 514)),
	"H4'":((25, 392), 'cyan', (-17, 420)),
	"H5'1":((57, 263), 'cyan', (25, 237)),
	"H5'2":((107, 261), 'cyan', (139, 231)),
	'H6':((274, 150), 'blue', (310, 132)),
	'H71':((203, 25), 'blue', (186, 2)),
	'H72':((231, 27), 'blue', (244, 0)),
	'H73':((261, 27), 'blue', (302, -2)),
	'M7':((257, 57), 'blue', (306, 62)),
	'N1':((137, 186), 'green', (149, 160)),
	'N3':((79, 90), 'green', (53, 117)),
	},
  'U': {
	"C1'":((240, 370), 'red', (276, 383)),
	'C2':((77, 156), 'red', (64, 184)),
	"C2'":((199, 439), 'red', (205, 407)),
	"C3'":((122, 439), 'red', (141, 413)),
	'C4':((139, 57), 'red', (141, 27)),
	"C4'":((94, 370), 'red', (134, 368)),
	'C5':((197, 90), 'red', (165, 105)),
	"C5'":((92, 308), 'red', (122, 332)),
	'C6':((199, 154), 'red', (220, 184)),
	"H1'":((274, 336), 'cyan', (276, 282)),
	"H2'":((248, 443), 'cyan', (299, 460)),
	'H3':((59, 55), 'blue', (59, 23)),
	"H3'":((98, 477), 'cyan', (51, 514)),
	"H4'":((25, 392), 'cyan', (-17, 420)),
	'H5':((231, 27), 'blue', (244, 0)),
	"H5'1":((57, 263), 'cyan', (25, 237)),
	"H5'2":((107, 261), 'cyan', (139, 231)),
	'H6':((274, 150), 'blue', (310, 132)),
	'N1':((137, 186), 'green', (149, 160)),
	'N3':((79, 90), 'green', (53, 117)),
	},
  }

# -----------------------------------------------------------------------------
#
def merge_table(tfrom, tto):
  for k, tv in tfrom.items():
    if not tto.has_key(k):
      tto[k] = {}
    tto[k].update(tv)

# -----------------------------------------------------------------------------
#
cell_size = (300, 570)
sizes = {
  'vertex_font_height':20,
  'line_font_height':20,
  'line_spacing':3,
  'line_thickness':2,
  'group_font_height':30,
  'dot_radius':15,
  }
layout = {}
merge_table(protein_layout, layout)
merge_table(dna_rna_layout, layout)
