// ----------------------------------------------------------------------------
// Execute menu commands
//

#ifndef COMMAND_HEADER_INCLUDED
#define COMMAND_HEADER_INCLUDED

#include "stringc.h"		// use Stringy

class Accelerator_List;
class Session;

typedef bool (*Command_Proc)(Session &, const Stringy &accel, void *cmd_data);

// ----------------------------------------------------------------------------
//
class Command_Dispatcher
{
public:
  Command_Dispatcher(Session &);
  ~Command_Dispatcher();

  void add_accelerator(const Stringy &accelerator,
		       const Stringy &menu_text,
		       Command_Proc cmd, void *cmd_data);
  bool remove_accelerator(const Stringy &accelerator);
  bool execute_menu_accelerator(const Stringy &accelerator);

  void parse_key(char key);
  void parse_function_key(int key, bool shifted);
  void parse_key_event(void *event);
  void ignore_keys(bool ignore);
  void clear_key_buffer();

private:
  Session &session;
  Accelerator_List *accel_list;
  Stringy key_buffer;
  bool ignore_key_commands;
};

#endif
