// ----------------------------------------------------------------------------
// Contour drawing and caching.
//

#ifndef _Contour_h
#define _Contour_h

#define CONTOUR_TILE_SIZE	32

class Contour_Cache;
class Memory_Cache;
class Notifier;
class Spectrum;
class SRegion;
class Wait;

class Contour_Levels
{
public:
  double lowest;
  double factor;
  int levels;
  bool operator==(const Contour_Levels &) const;
  double highest() const;
};

class Drawing_Routines
{
 public:
  virtual void set_contour_level(float level);
  virtual void draw_contour_path(float *xy, int length);
};

void draw_contours(Spectrum *, const SRegion &,
		   const Contour_Levels &pos, const Contour_Levels &neg,
		   bool subtract_fit_peaks, Drawing_Routines &,
		   Contour_Cache *, Wait *);
Contour_Cache *create_contour_cache(Memory_Cache *, Notifier &);
void delete_contour_cache(Contour_Cache *);

#endif
