// ----------------------------------------------------------------------------
// Regions of spectrum data.
// Regions above a threshold.
//

#ifndef DATAREGION_HEADER_INCLUDED
#define DATAREGION_HEADER_INCLUDED

#include "spoint.h"		// Use IRegion, IPoint

class List;
class Spectrum;
class Wait;

// ----------------------------------------------------------------------------
//
class Data_Region
{
 public:
  Data_Region(Spectrum *sp, const IRegion &region);
  virtual ~Data_Region();

  Spectrum *spectrum() const;
  const IRegion &region() const;
  float *data() const;
  double height(const IPoint &p) const;

  void change_region(const IRegion &r);

 private:
  float *values;
  IRegion reg;
  Spectrum *spect;
};

// ----------------------------------------------------------------------------
//
class Marked_Region : public Data_Region
{
 public:
  Marked_Region(Spectrum *sp, const SRegion &limits);
  ~Marked_Region();

  bool mark_connected(const IPoint &start,
		      double lothresh, double hithresh,
		      int volume_limit, Wait *wait);
  void mark_region(const SRegion &r);
  bool is_marked(const IPoint &p) const;
  int marked_volume() const;
  bool enscribe_marked(); // set region to enclose marked points

 private:
  bool *marks;
  IRegion limits;

  bool mark_connected(List &frontier, List &free_ipoints,
		      double lothresh, double hithresh,
		      int volume_limit, Wait *wait);
  bool extend_region(const IPoint &start, int volume_limit);
  void resize_region(const IRegion &r);

  bool *marked();
};

#endif
