// ----------------------------------------------------------------------------
// Reading and writing Sparky files.
//
#ifndef FORMAT_HEADER_INCLUDED
#define FORMAT_HEADER_INCLUDED

class istream;
class ostream;

class Condition;
class Object_Table;
class Ornament;
class Project;
class Session;
class Spectrum;
class Stringy;

// ----------------------------------------------------------------------------
// Open nmr data, spectrum file or project file.
//
Spectrum *open_spectrum(Session &, const Stringy &path, Stringy *error_msg);
bool open_sparky_file(Session &, const Stringy &path, Stringy *error_msg);
bool load_resonances(const Stringy &path, Condition *c);

// ----------------------------------------------------------------------------
// Save spectrum or project
//
bool save_project(Session &, bool backup);
bool save_spectrum(Session &, Spectrum *, bool backup);

// ----------------------------------------------------------------------------
// Undo
//
void ornament_save_for_undo(Ornament *op, ostream &o, Object_Table &ids);
Ornament *ornament_restore_for_undo(Session &, const Stringy &first_line,
				    istream &strm, Object_Table &ids);

#endif
