#include <math.h>

#include "num.h"

#define TINY 1.0e-20;
#define true	1
#define false	0
#define MAXSIZ	101

static bool
_ludcmp(double **a, int n, int *indx, double *d)
{
	int	i,imax,j,k;
	double	big,dum,sum,temp;
	double	vv[MAXSIZ];

	imax = 0;	// Suppress compiler warning about possibly uninit var.
	*d=1.0;
	for (i=1;i<=n;i++) {
		big=0.0;
		for (j=1;j<=n;j++)
			if ((temp=abs(a[i][j])) > big) big=temp;
		if (big == 0.0)
			return false;
		vv[i]=1.0/big;
	}
	for (j=1;j<=n;j++) {
		for (i=1;i<j;i++) {
			sum=a[i][j];
			for (k=1;k<i;k++) sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
		}
		big=0.0;
		for (i=j;i<=n;i++) {
			sum=a[i][j];
			for (k=1;k<j;k++)
				sum -= a[i][k]*a[k][j];
			a[i][j]=sum;
			if ( (dum=vv[i]*abs(sum)) >= big) {
				big=dum;
				imax=i;
			}
		}
		if (j != imax) {
			for (k=1;k<=n;k++) {
				dum=a[imax][k];
				a[imax][k]=a[j][k];
				a[j][k]=dum;
			}
			*d = -(*d);
			vv[imax]=vv[j];
		}
		indx[j]=imax;
		if (a[j][j] == 0.0) a[j][j]=TINY;
		if (j != n) {
			dum=1.0/(a[j][j]);
			for (i=j+1;i<=n;i++) a[i][j] *= dum;
		}
	}
	return true;
}

static void
_lubksb(double **a, int n, int *indx, double b[])
{
	int	i,ii=0,ip,j;
	double	sum;

	for (i=1;i<=n;i++) {
		ip=indx[i];
		sum=b[ip];
		b[ip]=b[i];
		if (ii)
			for (j=ii;j<=i-1;j++) sum -= a[i][j]*b[j];
		else if (sum) ii=i;
		b[i]=sum;
	}
	for (i=n;i>=1;i--) {
		sum=b[i];
		for (j=i+1;j<=n;j++) sum -= a[i][j]*b[j];
		b[i]=sum/a[i][i];
	}
}

/*
 * Solve the system of equations given in matrix "a" . "x" = "b"
 * with the input vector being in array "b". "a" ("b") is
 * replaced with the LU decomposition (solution vector).
 */
bool
lusolve(double **a, double *b, int n)
{
	double	*a2[MAXSIZ];
	int	indx[MAXSIZ];
	double	d;
	int	i;

	if (n > MAXSIZ - 1)
		return false;

	for (i = 0; i < n; i++)
		a2[i] = a[i] - 1;
	if (_ludcmp(a2 - 1, n, indx - 1, &d)) {
		_lubksb(a2 - 1, n, indx - 1, b - 1);
		return true;
	}
	return false;
}

#undef TINY
