// ----------------------------------------------------------------------------
//
#ifndef STRING_HEADER_INCLUDED
#define STRING_HEADER_INCLUDED

#include <stdarg.h>

#undef NULL		// Fix bad define in stddef.h gnu distribution.
#define NULL 0L

class istream;
class ostream;
class List;

class Stringy
{
 public:

  Stringy();
  Stringy(const char *);
  Stringy(const Stringy &s);
  Stringy(char c);
  Stringy(int i);
  virtual ~Stringy();

  bool operator==(const Stringy &) const;
  bool operator==(const char *) const;
  bool operator!=(const Stringy &) const;
  bool operator!=(const char *) const;
  Stringy &operator=(const Stringy &);
  Stringy &operator=(const char *);

  Stringy &operator<<(const Stringy &);
  Stringy &operator<<(const char *);
  Stringy &operator<<(char);
  Stringy &operator<<(int);
  Stringy operator+(const Stringy &) const;

  char operator[](int k) const;

  int length() const;
  bool is_empty() const;
  bool is_white() const;
  Stringy substring(int start, int end) const;
  Stringy substring(int start) const;
  const char *cstring() const;

 private:

  char *s;
};

Stringy operator+(const char* s1, const Stringy& s2);
ostream &operator<<(ostream &strm, const Stringy &s);
istream &operator>>(istream &strm, Stringy &s);
bool stream_line(istream &strm, Stringy *s);
Stringy formatted_string(const char *format, ...);
Stringy va_formatted_string(const char *format, va_list args);
Stringy backslashify_characters(const Stringy &s, const Stringy &chars);
Stringy spaces(int num);
Stringy substring(const char *start, const char *end);
bool has_prefix(const Stringy &s, const Stringy &prefix);
Stringy remove_suffix(const Stringy &s, const Stringy &suffix);
bool contains_whitespace(const Stringy &s);
bool find_character(const Stringy &s, const Stringy &chars, int *pos);
Stringy replace_character(const Stringy &s, char from, char to);
bool number_suffix(const Stringy &s, char suffix_separator,
		   Stringy *basename, int *suffix_number);

Stringy first_word(const Stringy &s, const Stringy &separators, Stringy *rest);
Stringy first_token(const Stringy &s, Stringy *rest);
Stringy trim_white(const Stringy &s);
const char *skip_white(const char *string);
const char *skip_nonwhite(const char *string);
char *skip_white(char *string);
char *skip_nonwhite(char *string);

int compare_strings(const Stringy &, const Stringy &);
int string_compare(const void *string1, const void *string2);
bool equal_strings(const void *string1, const void *string2);
unsigned long hash_string(const void *string);

void free_string_list_entries(List &strings);
List duplicate_string_list(const List &strings);
char *allocate_character_array(const char *s);

int name_index(const char *names[], const Stringy &name);
Stringy index_name(const char *names[], int index);
const char *matching_string(const char *names[], const Stringy &name);

#endif
