// ----------------------------------------------------------------------------
//
#include <dir.h>		// use mkdir()
#include <stdio.h>		// use FILE
#include <stdlib.h>		// use getenv()
#include <windows.h>		// Use MoveFile(), DeleteFile()

#include "stringc.h"		// use Stringy

// ----------------------------------------------------------------------------
// Include system routines portable to all platforms.
//
#include "system-all.cc"

// ----------------------------------------------------------------------------
//
Stringy path_separator()
  { return "\\"; }

// ----------------------------------------------------------------------------
//
Stringy resolve_links(const Stringy &path)
  { return path; }

// ----------------------------------------------------------------------------
//
bool make_directory(const Stringy &path)
{
  return mkdir(path.cstring()) == 0;
}

// ----------------------------------------------------------------------------
//
bool same_file(const Stringy &path1, const Stringy &path2)
{
  return (path1 == path2);
}

// ----------------------------------------------------------------------------
//
Stringy default_sparky_install_path()
{
  return file_path(file_path("c:", "Program Files"), "sparky");
}

// ----------------------------------------------------------------------------
//
bool remove_file(const Stringy &path)
{
  return DeleteFile(path.cstring());
}

// ----------------------------------------------------------------------------
//
bool move_file(const Stringy &from, const Stringy &to)
{
  return MoveFile(from.cstring(), to.cstring());
}

// ----------------------------------------------------------------------------
//
bool user_owns_file(const Stringy &path)
{
  return true;
}

// ----------------------------------------------------------------------------
//
Stringy get_username()
{
  const char *u = getenv("USERNAME");
  if (u)
    return u;

  u = getenv("USER");
  if (u)
    return u;

  return "";
}

// ----------------------------------------------------------------------------
//
static Stringy user_home_directory()
{
  return getenv("HOME");
}

// ----------------------------------------------------------------------------
//
static Stringy user_home_directory(const Stringy &username)
{
  return "";
}

// ----------------------------------------------------------------------------
//
bool catch_signal(int sig, void (*handler)(int))
{
  return false;
}

// ----------------------------------------------------------------------------
//
bool ignore_signal(int sig)
{
  return false;
}

// ----------------------------------------------------------------------------
//
Stringy file_owner(FILE *fp)
{
  return "";
}

// ----------------------------------------------------------------------------
//
bool is_data_available(FILE *fp)
{
  return true;
}

// ----------------------------------------------------------------------------
//
void catch_fatal_errors(void (*handler)(int))
{
  catch_signal(SIGFPE, handler);
  catch_signal(SIGTERM, handler);
}

// ----------------------------------------------------------------------------
//
void catch_user_signal(void (*)(int))
{
}

// ----------------------------------------------------------------------------
//
void ignore_broken_pipes()
{
}

// ----------------------------------------------------------------------------
//
void core_dump()
{
  abort();
}

// ----------------------------------------------------------------------------
// Start a sub process with bidirectional I/O.
// The client should close the streams when they are done.
//
bool start_process(const Stringy &command,
		   FILE **to_process, FILE **from_process)
{
  if (to_process == NULL && from_process == NULL)
    {
      STARTUPINFO sinfo;
      memset(&sinfo, 0, sizeof(STARTUPINFO));
      sinfo.cb = sizeof(STARTUPINFO);
      PROCESS_INFORMATION pinfo;
      bool success = CreateProcess(NULL, (char *) command.cstring(),
				   NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS,
				   NULL, NULL, &sinfo, &pinfo);
      if (success)
	{
	  CloseHandle(pinfo.hProcess);
	  CloseHandle(pinfo.hThread);
	}
      return success;
    }

  return false;	// processes with i/o not implemented
}

// ----------------------------------------------------------------------------
//
Stringy default_print_command()
{
  return "print";
}

// ----------------------------------------------------------------------------
//
bool start_netscape(const Stringy &url)
{
  Stringy command = formatted_string("netscape %s", url.cstring());
  return start_process(command);
}
