#ifndef SYSTEM_HEADER_INCLUDED
#define SYSTEM_HEADER_INCLUDED

#include <signal.h>		// Use SIG_* with catch_signal()
#include <stdio.h>		// Use FILE
#include <time.h>		// Use time_t

class Stringy;

//
// File paths
//
Stringy file_name(const Stringy &path);
Stringy file_directory(const Stringy &path);
Stringy file_path(const Stringy &directory, const Stringy &file);
bool is_absolute_path(const Stringy &path);
Stringy path_separator();
Stringy parent_directory(const Stringy &directory);
Stringy current_directory();
Stringy tilde_expand(const Stringy &path);
Stringy resolve_links(const Stringy &path);
Stringy dedotify_path(const Stringy &path);
Stringy temporary_file_name();
bool same_file(const Stringy &path1, const Stringy &path2);
Stringy default_sparky_install_path();

//
// File queries
//
unsigned long file_size(const Stringy &path);
bool is_directory(const Stringy &path);
bool file_exists(const Stringy &path);
bool file_is_writable(const Stringy &path);
bool user_owns_file(const Stringy &path);
time_t file_modification_time(const Stringy &path);
Stringy file_owner(FILE *fp);
bool is_data_available(FILE *);
//
// Making and removing files
//
bool make_directory(const Stringy &path);
bool move_file(const Stringy &from, const Stringy &to);
bool remove_file(const Stringy &path);
void remove_file_at_exit(const Stringy &path);

//
// Subprocesses
//
bool run_command(const Stringy &command);
bool start_process(const Stringy &command,
		   FILE **to_process = NULL, FILE **from_process = NULL);
Stringy default_print_command();
bool start_netscape(const Stringy &url);

//
// Signal handling
//
bool catch_signal(int sig, void (*handler)(int));
bool ignore_signal(int sig);
void core_dump();
void catch_fatal_errors(void (*handler)(int));
void catch_user_signal(void (*handler)(int));
void ignore_broken_pipes();

//
// User info
//
Stringy get_username();

#endif
