// ----------------------------------------------------------------------------
//

#include "color.h"		// use Color
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "num.h"		// Use round()
#include "session.h"		// use Session
#include "stringc.h"		// Use Stringy
#include "uicomponents.h"	// Use View_Menu
#include "uidialogs.h"		// use help_cb()
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "uiview.h"		// Use View
#include "winsystem.h"		// use WinSys

// ----------------------------------------------------------------------------
//
class contour_dialog : public Dialog
{
public:
  contour_dialog(Session &);
  ~contour_dialog();

  static contour_dialog *the(Session &);

  void show(View *view);
  void update(View *view);

private:
  Widget table;
  View_Menu *view_menu;
  View *view;

  static void will_delete_view_cb(void *cdialog, void *view);
  static void view_menu_cb(Widget, CB_Data, CB_Data);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_contour_dialog(Session &s, View *view)
  { contour_dialog::the(s)->show(view); }

// ----------------------------------------------------------------------------
//
contour_dialog::contour_dialog(Session &s) : Dialog(s, "contourDialog")
{
  this->view = NULL;

  view_menu = new View_Menu(s, dialog, "viewMenu");
  ws.option_callback(view_menu->option_menu(), view_menu_cb, this);

  Table_Entry label = TABLE_LABEL;
  Table_Entry value = TABLE_TEXT_FIELD;
  Table_Entry menu = TABLE_OPTION_MENU;
  table = ws.widget_table(dialog, "levels", 3, 5,
		       label, label, label, label, label,
		       label, value, value, value, menu,
		       label, value, value, value, menu);

  const char *clist[] = {"beige", "black", "blue",
			 "coral", "cyan", "gold", "gray",
			 "green", "green-blue",
			 "light blue", "light green", "light yellow",
			 "magenta", "maroon", "orange",
			 "pink", "purple", "red", "red-blue",
			 "red-yellow", "tomato",
			 "turquoise", "white", "yellow",
			 NULL};
  for (int ci = 0 ; clist[ci] ; ++ci)
    {
      ws.add_option(ws.table_element(table, 1, 4), clist[ci]);
      ws.add_option(ws.table_element(table, 2, 4), clist[ci]);
    }


  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       "help", help_cb, &s,
			       NULL);

  ws.column_attachments(separator, view_menu->option_menu(), table,
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_will_delete_view, will_delete_view_cb, this);
}

// ----------------------------------------------------------------------------
//
contour_dialog::~contour_dialog()
{
  session.dialog_table().delete_dialog("contour_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_will_delete_view, will_delete_view_cb, this);

  delete view_menu;
}

// ----------------------------------------------------------------------------
// The default contour_dialog instance.
//
contour_dialog *contour_dialog::the(Session &s)
{
  Stringy name = "contour_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new contour_dialog(s));
  return (contour_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void contour_dialog::will_delete_view_cb(void *cdialog, void *view)
{
  contour_dialog *cd = (contour_dialog *) cdialog;
  View *v = (View *) view;
  if (cd->view == v)
    cd->update(NULL);
}

// ----------------------------------------------------------------------------
//
void contour_dialog::view_menu_cb(Widget, CB_Data client_data, CB_Data)
{
  contour_dialog *cd = (contour_dialog *) client_data;
  View *view = cd->view_menu->selected_view();
  if (view)
    cd->update(view);
}

// ----------------------------------------------------------------------------
//
void contour_dialog::show(View *view)
{
  update(view);
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void contour_dialog::update(View *view)
{
  this->view = view;

  Stringy dialog_title = (view == NULL ? Stringy("Contour Levels") :
			  Stringy("Contour Levels ") + view->name());
  ws.set_dialog_title(dialog, dialog_title);

  view_menu->set_view_choice(view);

  Contour_Parameters pos = (view == NULL ? Contour_Parameters(true) :
			    view->positive_contours());
  Contour_Levels &plev = pos.levels;
  ws.set_numeric_text_field(ws.table_element(table,1,1), "%.3g", plev.lowest);
  ws.set_numeric_text_field(ws.table_element(table,1,2), "%.0f", plev.levels);
  ws.set_numeric_text_field(ws.table_element(table,1,3), "%.2f", plev.factor);
  ws.set_option(ws.table_element(table,1,4), pos.color_scheme());

  Contour_Parameters neg = (view == NULL ? Contour_Parameters(false) :
			    view->negative_contours());
  Contour_Levels &nlev = neg.levels;
  ws.set_numeric_text_field(ws.table_element(table,2,1), "%.3g", nlev.lowest);
  ws.set_numeric_text_field(ws.table_element(table,2,2), "%.0f", nlev.levels);
  ws.set_numeric_text_field(ws.table_element(table,2,3), "%.2f", nlev.factor);
  ws.set_option(ws.table_element(table,2,4), neg.color_scheme());
}

// ----------------------------------------------------------------------------
//
void contour_dialog::apply()
{
  Contour_Parameters pos(true);
  pos.levels.lowest = ws.numeric_text_field(ws.table_element(table,1,1));
  pos.levels.levels = round(ws.numeric_text_field(ws.table_element(table,1,2)));
  pos.levels.factor = ws.numeric_text_field(ws.table_element(table,1,3));
  pos.set_color_scheme(ws.option_selected(ws.table_element(table,1,4)));

  Contour_Parameters neg(false);
  neg.levels.lowest = ws.numeric_text_field(ws.table_element(table,2,1));
  neg.levels.levels = round(ws.numeric_text_field(ws.table_element(table,2,2)));
  neg.levels.factor = ws.numeric_text_field(ws.table_element(table,2,3));
  neg.set_color_scheme(ws.option_selected(ws.table_element(table,2,4)));

  if (view)
    {
      view->set_contour_parameters(pos);
      view->set_contour_parameters(neg);
    }
}
