// ----------------------------------------------------------------------------
// Show sections of the manual using Netscape
//

#include <string.h>		// use strchr()

#include "paths.h"		// use installation_path(), SPARKY_MANUAL
#include "reporter.h"		// use Reporter
#include "session.h"		// use Session
#include "stringc.h"		// use Stringy
#include "system.h"		// use start_netscape()
#include "uidialogs.h"		// use show_manual_url()
#include "uimain.h"		// use query()
#include "utility.h"		// use warning()
#include "winsystem.h"		// use Widget, show_url()

// ----------------------------------------------------------------------------
// URL is retrieved from option database.
//
void show_help(Session &s, const Stringy &topic)
{
  WinSys &ws = s.window_system();
  Stringy url = ws.read_application_resource(ws.main_widget(),
					     topic + "Url", "Url", "");
  show_manual_url(s, url);
}

// ----------------------------------------------------------------------------
//
void show_manual_url(Session &s, const Stringy &manual_url)
{
  Stringy mandir = installation_path(SPARKY_MANUAL);
  Stringy page = (manual_url.is_empty() ? Stringy("index.html") : manual_url);
  Stringy path = file_path(mandir, page);
  Stringy url = "file://" + path;
  if (!s.window_system().show_url(url))
    {
      if (query(s,
		"Sparky wants to show you part of the manual:\n\n\t" + path +
		"\n\nWould you like to start Netscape to display this page?",
		"Start Netscape", "Cancel") == 1)
	{
	  if (!start_netscape(url))
	    {
	      Reporter &rr = s.reporter();
	      rr.warning("Couldn't start Netscape.\n"
			 "You can use any web browser to look at URL:\n\t"
			 "%s", url.cstring());
	    }
	}
    }
}
