// ----------------------------------------------------------------------------
//  Mode panel.
//

#ifndef UIMODE_HEADER_INCLUDED
#define UIMODE_HEADER_INCLUDED

class Session;

/*
 * Pointer modes.
 */
enum Pointer_Mode {
  MODE_SELECT,				/* F1 */
  MODE_CENTER,				/* F2 */
  MODE_GRIDBOTH,			/* F3 */
  MODE_GRIDHOR,				/* F4 */
  MODE_GRIDVERT,			/* F5 */
  MODE_LABEL,				/* F6 */
  MODE_LINE,				/* F7 */
  MODE_PEAK,				/* F8 */
  MODE_INTEGRATE,			/* F10 */
  MODE_ZOOM,				/* F11 */
  MODE_DUPZOOM,				/* F12 */
  MODE_COPYASSIGNMENT,			/* shift-F1 */
  MODE_GUESSASSIGNMENT			/* shift-F2 */
};

void show_mode_buttons(Session &);
void set_pointer_mode(Session &, Pointer_Mode mode);
Pointer_Mode pointer_mode(Session &);
Stringy pointer_mode_name(Pointer_Mode mode);
Pointer_Mode named_pointer_mode(const Stringy &mode_name);

#endif
