// ----------------------------------------------------------------------------
//
#include <math.h>	       // Use fabs()

#include "list.h"		// Use List
#include "memalloc.h"		// use new()
#include "notifier.h"		// use Notifier
#include "ornament.h"		// Use Ornament
#include "project.h"		// Use Project
#include "session.h"		// use Session
#include "spectrum.h"		// Use Spectrum
#include "stringc.h"		// Use Stringy
#include "uidialog.h"		// use Dialog, Dialog_Table
#include "winsystem.h"		// Use ws.edit_field(), ...

static void update_ornament_size(WinSys &, Widget size_field,
				 Ornament_Type type, Spectrum *sp);

// ----------------------------------------------------------------------------
//
class ornament_size_dialog : public Dialog
{
public:
  ornament_size_dialog(Session &);
  ~ornament_size_dialog();

  static ornament_size_dialog *the(Session &);

  void show();
  void update();

private:
  Widget label_size, peak_size, peakgroup_size, line_size;
  Spectrum *spectrum;

  static void selections_changed_cb(void *osdialog, void *);

  void apply();
};

// ----------------------------------------------------------------------------
//
void show_ornament_size_dialog(Session &s)
  { ornament_size_dialog::the(s)->show(); }

// ----------------------------------------------------------------------------
//
ornament_size_dialog::ornament_size_dialog(Session &s)
  : Dialog(s, "ornamentSizeDialog")
{
  spectrum = NULL;

  Widget sizes_heading = ws.create_label(dialog, "heading");

  label_size = ws.edit_field(dialog, "labelSize");
  peak_size = ws.edit_field(dialog, "peakSize");
  peakgroup_size = ws.edit_field(dialog, "peakGroupSize");
  line_size = ws.edit_field(dialog, "lineSize");

  Widget separator = ws.create_separator(dialog, "separator");

  Widget controls = ws.button_row(dialog, "controls",
			       "ok", ok_cb, this,
			       "apply", apply_cb, this,
			       "close", close_cb, this,
			       NULL);

  ws.column_attachments(separator, sizes_heading,
		     label_size, peak_size, peakgroup_size, line_size,
		     separator, controls, END_OF_WIDGETS);

  Notifier &n = session.notifier();
  n.notify_me(nt_selected_ornaments_changed, selections_changed_cb, this);
}

// ----------------------------------------------------------------------------
//
ornament_size_dialog::~ornament_size_dialog()
{
  session.dialog_table().delete_dialog("ornament_size_dialog", this);

  Notifier &n = session.notifier();
  n.dont_notify_me(nt_selected_ornaments_changed, selections_changed_cb, this);
}

// ----------------------------------------------------------------------------
// The default ornament_size_dialog instance.
//
ornament_size_dialog *ornament_size_dialog::the(Session &s)
{
  Stringy name = "ornament_size_dialog";
  Dialog_Table &dt = s.dialog_table();
  if (dt.get_dialog(name) == NULL)
    dt.set_dialog(name, new ornament_size_dialog(s));
  return (ornament_size_dialog *) dt.get_dialog(name);
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::selections_changed_cb(void *osdialog, void *)
{
  ornament_size_dialog *osd = (ornament_size_dialog *) osdialog;

  if (osd->shown())
    osd->update();
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::show()
{
  update();
  ws.show_dialog(dialog);
  ws.raise_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::update()
{
  spectrum = spectrum_of_ornaments(session.project().selected_ornaments());

  Stringy spectrum_name = (spectrum ? spectrum->name() : Stringy(""));
  Stringy title = Stringy("Ornament Sizes ") + spectrum_name;
  ws.set_dialog_title(dialog, title);

  ws.set_sensitive(label_size, spectrum != NULL);
  ws.set_sensitive(peak_size, spectrum != NULL);
  ws.set_sensitive(peakgroup_size, spectrum != NULL);
  ws.set_sensitive(line_size, spectrum != NULL);

  if (spectrum)
    {
      ws.set_numeric_edit_value(label_size, "%.3f",
			     spectrum->ornament_size(label));
      ws.set_numeric_edit_value(peak_size, "%.3f",
			     spectrum->ornament_size(peak));
      ws.set_numeric_edit_value(peakgroup_size, "%.3f",
			     spectrum->ornament_size(peakgroup));
      ws.set_numeric_edit_value(line_size, "%.3f",
			     spectrum->ornament_size(line));
    }
}

// ----------------------------------------------------------------------------
//
void ornament_size_dialog::apply()
{
  if (spectrum)
    {
      update_ornament_size(ws, label_size, label, spectrum);
      update_ornament_size(ws, peak_size, peak, spectrum);
      update_ornament_size(ws, peakgroup_size, peakgroup, spectrum);
      update_ornament_size(ws, line_size, line, spectrum);
    }
}

// ----------------------------------------------------------------------------
//
static void update_ornament_size(WinSys &ws, Widget size_field,
				 Ornament_Type type, Spectrum *sp)
{
  double size = sp->ornament_size(type);
  double new_size = ws.numeric_edit_value(size_field);

  if (fabs(new_size - size) >= 1e-6)
    sp->set_ornament_size(type, new_size);
}
