/*
 * undo.h	- Interface to Undo class.
 *
 *		  Deals with ornaments only!
 *
 */
#ifndef _Undo_h
#define _Undo_h

#include <strstream.h>		// use ostrstream

#include "objectid.h"		// use Object_Table
#include "stringc.h"		// use Stringy

class Ornament;
class Session;

// ----------------------------------------------------------------------------
//
class Undo
{
public:

  Undo(Session &, const Stringy &doMsg, const Stringy &undoMsg);
  virtual			~Undo();
  
  void		add(Ornament *);	// Add an ornament
  void		finish();		// Finished adding ornaments
  bool		undo();			// Perform the Undo.

private:
  Session	&session;
  Stringy	mDoMsg;		// msg. at start of undoable operation.
  Stringy	mUndoMsg;	// msg. at start of undo.
  int		mCount;		// number of ornaments saved
  Object_Table	ids;		// for ornaments that point to others
  ostrstream	*mOut;		// state saved to here

  static void will_delete_ornament_cb(void *undo, void *ornament);
};

#endif
