# -----------------------------------------------------------------------------
# Display separation in Hz between the most recent two selected peaks.
#
import Tkinter

import pythonshell
import pyutil
import sparky
import sputil
import tkutil

# -----------------------------------------------------------------------------
#
class coupling_constants(tkutil.Dialog):

  # ---------------------------------------------------------------------------
  #
  def __init__(self, session):

    self.session = session
    self.peaks = [None, None]

    tkutil.Dialog.__init__(self, session.tk, 'Coupling Constants')

    self.peak_lines = [Tkinter.Label(self.top, text = 'Peak 1'),
		       Tkinter.Label(self.top, text = 'Peak 2')]
    self.peak_lines[0].pack(side = 'top', anchor = 'w')
    self.peak_lines[1].pack(side = 'top', anchor = 'w')

    self.separation = Tkinter.Label(self.top, text = 'Difference')
    self.separation.pack(side = 'top', anchor = 'w')

    self.selection_notice = \
      self.session.notify_me('selection changed', self.peak_selected_cb)

    w = Tkinter.Button(self.top, text = 'Close', command = self.close_cb)
    w.pack(side = 'top', anchor = 'w')

  # ---------------------------------------------------------------------------
  #
  def peak_selected_cb(self):

    if self.is_window_destroyed():
      self.session.dont_notify_me(self.selection_notice)
      self.selection_notice = None
      return

    peaks = self.session.selected_ornaments()
    if len(peaks) != 1 or peaks[0].__class__ != sparky.Peak:
      return
    peak = peaks[0]

    self.peaks[0] = self.peaks[1]
    self.peaks[1] = peak

    self.show_peak_line(0)
    self.show_peak_line(1)

    if self.peaks[0] and self.peaks[1]:
      freq0 = self.peaks[0].frequency
      freq1 = self.peaks[1].frequency
      f = []
      hz_per_ppm = peak.spectrum.hz_per_ppm
      for a in range(min(len(freq0), len(freq1))):
	f.append((freq1[a] - freq0[a]) * hz_per_ppm[a])
      line = ('Difference (Hz): %13s' % ''
	      + pyutil.sequence_string(f, ' %7.3f'))
      self.separation['text'] = line

  # ---------------------------------------------------------------------------
  #
  def show_peak_line(self, n):

    peak = self.peaks[n]
    line = 'Peak %d:' % (n+1)
    if peak:
      line = line + (' %20s ' % peak.assignment +
		     pyutil.sequence_string(peak.frequency, '% 7.3f'))
    self.peak_lines[n]['text'] = line

# -----------------------------------------------------------------------------
#
def show_coupling_dialog(session):
  sputil.the_dialog(coupling_constants,session).show_window(1)

# -----------------------------------------------------------------------------
#
def add_commands(session):
  pythonshell.add_command('cc', 'Coupling constants (cc)',
                          'coupling', 'show_coupling_dialog', session)
