/*
 * Atom.C - Implementation of the Atom class 
 *
 * A Molecule is composed of Atoms. Atoms with magnetic dipoles resonate at
 * frequencies determined by chemical bonds, molecular geometry, and
 * the NMR and physical conditions of a given NMR experiment. The
 * resonant frequency is encoded in the Resonance object, contained in
 * the Condition object, which encodes the NMR and physical conditions.
 *
 * Each Atom has a unique identifier (its ID) and a name given to it by the
 * user. Each Atom may also belong to a Group, which is usually an amino acid
 * or DNA base.
 *
 */
#include "atom.h"
#include "group.h"

//
//
Atom::Atom(const Stringy &name, const Stringy &nucleus, Group *g)
{
	mName = name;
	mNucleus = nucleus;
	mGroup = g;
}

//
// Atom destructor
//
Atom::~Atom()
{
  mGroup = NULL;
}

// ----------------------------------------------------------------------------
//
const Stringy &Atom::name() const
  { return mName; }
Stringy Atom::LongName() const
  { return mGroup->name() + name(); }
const Stringy &Atom::nucleus() const
  { return mNucleus; }
Group *Atom::group() const
  { return mGroup; }
