// ----------------------------------------------------------------------------
// Reading and writing matrices of floats stored in files in block format.
// The data arrays in memory are always indexed with the last axis varying
// fastest.
//
#ifndef BLOCKFILE_HEADER_INCLUDED
#define BLOCKFILE_HEADER_INCLUDED

#include "offsettype.h"		// use offset_type
#include "spoint.h"		// Use IPoint, IRegion
#include "stringc.h"		// Use Stringy
#include "table.h"		// Use Table

class Data_Block;
class Memory_Cache;

class Block_File
{
 public:
  Block_File(const Stringy &path,
	     const IPoint &size, const IPoint &block_size,
	     Memory_Cache *);
  virtual ~Block_File();

  Stringy path() const;
  IPoint size() const;
  IPoint block_size() const;
  bool read_value(const IPoint &position, float *value);
  bool read_values(const IRegion &region, float *values);
  bool write_value(const IPoint &position, float value);
  bool write_values(const IRegion &region, float *values);
  bool write_zeros();
  void flush_cache();
  Memory_Cache *memory_cache();
  virtual bool read_block(const IPoint &block, float *values) = 0;
  virtual bool write_block(const IPoint &block, float *values) = 0;

  size_t block_volume() const;
  IRegion block_space();
  IRegion block_region(const IPoint &block);

 private:
  Stringy data_path;
  IPoint data_size, block_siz;
  Table blocks;
  Memory_Cache *mcache;

  static void free_data_block_cb(void *dblock, void *bfile);

  IRegion data_region();
  IRegion block_subspace(const IRegion &region);

  Data_Block *data_block(const IPoint &block);
  bool get_block_data(const IPoint &block, const IRegion &region, float *data);
  bool put_block_data(const IPoint &block, const IRegion &region, float *data);
  bool read_block(Data_Block *b);
  bool write_block(Data_Block *b);
  void block_location(const IPoint &position,
		      IPoint *block, offset_type *block_index) const;
};

IRegion block_space(const IPoint &data_size, const IPoint &block_size);
IRegion block_region(const IPoint &block, const IPoint &block_size);

Block_File *packed_block_file(const Stringy &path, const Stringy &mode,
			      const IPoint &size, const IPoint &block_size,
			      offset_type data_start, bool big_endian_indexing,
			      Memory_Cache *);

#endif
