// ----------------------------------------------------------------------------
//
#include <stdarg.h>		// use ...

#include "color.h"		// Use Color
#include "list.h"		// Use List
#include "memalloc.h"		// use new()

// ----------------------------------------------------------------------------
//
Color::Color()
  { cname = "black"; }
Color::Color(const Stringy &colorname)
  { cname = colorname; }
Color::Color(const char *colorname)
  { cname = colorname; }

// ----------------------------------------------------------------------------
//
Color &Color::operator=(const Color &color)
  { cname = color.name(); return *this; }
bool Color::operator==(const Color &color) const
  { return name() == color.name(); }
bool Color::operator!=(const Color &color) const
  { return name() != color.name(); }
const Stringy &Color::name() const
  { return cname; }

// ----------------------------------------------------------------------------
//
List color_list(const char *cname, ...)
{
  List colors;

  va_list args;
  va_start(args, cname);

  for (const char *name = cname ; name != NULL ;
       name = va_arg(args, const char *))
    colors.append(new Color(name));

  va_end(args);

  return colors;
}

// ----------------------------------------------------------------------------
//
void free_color_list(List &clist)
{
  for (int ci = 0 ; ci < clist.size() ; ++ci)
    delete (Color *) clist[ci];
  clist.erase();
}
