// ----------------------------------------------------------------------------
//  Miscellaneous numerical routines.
//

#ifndef NUM_HEADER_INCLUDED
#define NUM_HEADER_INCLUDED

#include <stdlib.h>	// Use int abs(int)

#undef NULL		// Fix bad define in stddef.h gnu distribution.
#define NULL 0L

int min(int a, int b);
unsigned int min(unsigned int a, unsigned int b);
double min(double a, double b);

int max(int a, int b);
unsigned int max(unsigned int a, unsigned int b);
double max(double a, double b);

double floor(double x, double step);
double floor(double x, double a, double b);
double ceil(double x, double step);

int nearest_int(double x);
double nearest_multiple(double x, double unit);
double interval_mod(double x, double a, double b);

int bounded(int lo, int x, int hi);
double bounded(double lo, double x, double hi);

double length(double x, double y);

double segment_distance(double x1, double x2, double x, double y);

void scientific_form(double x, double *mant, long *exp, double *decade);

void swap(double *a, double *b);

bool is_between(double x, double a, double b);

bool is_bit_set(unsigned int word, int bit);
unsigned int set_bit(unsigned int word, int bit, bool state);

int random_int(int min, int max);

void sort_floats(float *values, int n);

#endif
