// ----------------------------------------------------------------------------
//
#include <stdarg.h>		// use va_list
#include <stdio.h>		// use vfprintf(), stdout, stderr

#include "reporter.h"		// use Reporter

// ----------------------------------------------------------------------------
//
void Reporter::message(const char *format, ...)
{
  va_list args;
  va_start(args, format);
  vfprintf(stdout, format, args);
  va_end(args);
}

// ----------------------------------------------------------------------------
//
void Reporter::warning(const char *format, ...)
{
  va_list args;

  va_start(args, format);
  vfprintf(stderr, format, args);
  va_end(args);
}
