// ----------------------------------------------------------------------------
//  Dialog components.
//

#ifndef UICOMPONENTS_HEADER_INCLUDED
#define UICOMPONENTS_HEADER_INCLUDED

#include "winsystem.h"		// Use Widget, CB_Data, CB_Proc

class Condition;
class Resonance;
class Session;
class Spectrum;
class Stringy;
class View;
class WinSys;

// ----------------------------------------------------------------------------
// Option menu for choosing a spectrum.
//
class Spectrum_Menu
{
public:
  Spectrum_Menu(Session &, Widget parent, const Stringy &name);
  ~Spectrum_Menu();

  Widget option_menu();
  void set_spectrum_choice(Spectrum *sp);
  Spectrum *selected_spectrum();

private:
  Session &session;
  WinSys &ws;
  Widget menu;
  static void spectrum_added_cb(void *, void *);
  static void spectrum_deleted_cb(void *, void *);
  static void spectrum_renamed_cb(void *, void *);
  void renamed_spectrum(Spectrum *sp);
  void update_spectrum_menu();
};

// ----------------------------------------------------------------------------
// Option menu for choosing a view.
//
class View_Menu
{
public:
  View_Menu(Session &, Widget parent, const Stringy &name);
  ~View_Menu();
  
  Widget option_menu();
  void set_view_choice(View *view);
  View *selected_view();

private:
  Session &session;
  WinSys &ws;
  Widget menu;
  static void view_added_cb(void *, void *);
  static void view_deleted_cb(void *, void *);
  static void view_renamed_cb(void *, void *);
  void renamed_view(View *);
  void update_view_menu();
};

// ----------------------------------------------------------------------------
// Option menu for choosing a condition
//
class Condition_Menu
{
public:
  Condition_Menu(Session &s, Widget parent, const Stringy &name);
  ~Condition_Menu();

  Widget option_menu();
  void set_condition_choice(const Condition &);
  Condition *condition_chosen();

private:
  Session &session;
  WinSys &ws;
  Widget menu;
  static void added_condition_cb(void *, void *);
  void update_condition_menu();
};

// ----------------------------------------------------------------------------
// Text entry field for choosing a condition
//
class Condition_Field
{
public:
  Condition_Field(Session &, Widget parent, const Stringy &name);
  ~Condition_Field();
  Widget edit_field();

private:
  Session &session;
  WinSys &ws;
  Widget cf;
  static void added_condition_cb(void *, void *);
  void update_condition_menu();
};

// ----------------------------------------------------------------------------
// Text entry field for choosing a molecule
//
class Molecule_Field
{
public:
  Molecule_Field(Session &, Widget parent, const Stringy &name);
  ~Molecule_Field();
  Widget edit_field();

private:
  Session &session;
  WinSys &ws;
  Widget mf;
  static void added_molecule_cb(void *, void *);
  void update_molecule_menu();
};

// ----------------------------------------------------------------------------
// Composite widget to choose a resonance using text entry fields for
// resonance name and condition name and menus.
//
class Resonance_Field
{
public:
  Resonance_Field(Session &, Widget parent, const Stringy &name);
  ~Resonance_Field();

  Widget frame();
  Widget resonance_text_field();
  Widget condition_text_field();

  void set_resonance_field(const Resonance *r);
  Resonance *resonance_chosen();

private:
  Session &session;
  WinSys &ws;
  Widget f, cond, condtext, res, restext;
  static void destroy_resonance_menu_cb(Widget, CB_Data, CB_Data);
  static void condition_changed_cb(Widget, CB_Data, CB_Data);
  static void condition_list_changed_cb(void *, void *);
  static void resonance_list_changed_cb(void *, void *);
  static void update_resonance_menu(void *);
  void update_condition_menu();
};

Stringy table_axis_label(Spectrum *sp, int axis, const Stringy &suffix);

#endif
