// ----------------------------------------------------------------------------
// Contour level edge panel.
//

#ifndef UICSCALE_HEADER_INCLUDED
#define UISCALE_HEADER_INCLUDED

#include "uiepanel.h"		// Use edge_panel
#include "winsystem.h"		// Use Widget, CB_Data

class Color;
class Contour_Parameters;
class View;

// ----------------------------------------------------------------------------
//
class ContourScale : public edge_panel
{
 public:

  ContourScale(View *view, double a, double b, int screen_length);
  virtual ~ContourScale();

// ----------------------------------------------------------------------------
//
 private:

  View *view;
  double scale;			// level height / ppm
  bool showing_current_level;
  double current_level;		// current pointer level

  int last_y;
  enum { AdjustLow, AdjustHigh, AdjustLevels } drag_mode;
  double drag_sign;

  static void contours_changed_cb(void *cscale, void *view);
  static void button_press_cb(Widget, CB_Data, CB_Data);
  static void pointer_drag_cb(Widget, CB_Data, CB_Data);

  virtual void redraw(double a_clip, double b_clip);

  double height_y_position(double h, bool positive_half);
  double y_range();
  void draw_levels(const Contour_Parameters &, const Contour_Parameters &);
  void draw_current_level();
  void adjust_scale(const Contour_Parameters &, const Contour_Parameters &);
  void show_pointer_level();
  void process_button(int y);
  void process_drag(int y);

  virtual void pointer_in(double x, double y);
  virtual void pointer_move(double x, double y);
  virtual void pointer_out(double x, double y);
};

#endif
