// ----------------------------------------------------------------------------
//  Peak list options dialog.
//

#ifndef UIPLOP_HEADER_INCLUDED
#define UIPLOP_HEADER_INCLUDED

#include "stringc.h"			// Use Stringy

enum Peak_List_Field
{
  ASSIGNMENT_NAME_FIELD,
  USER_NAME_FIELD,
  FREQUENCY_FIELD,
  HZ_FREQUENCY_FIELD,
  RESONANCE_DEV_FIELD,
  VOLUME_FIELD,
  VOLUME_ERROR_FIELD,
  TRANSPOSED_VOLUME_FIELD,
  FIT_RESIDUAL_FIELD,
  FIT_HEIGHT_FIELD,
  DATA_HEIGHT_FIELD,
  NOISE_FIELD,
  LINEWIDTH_FIELD,
  RES_FREQ_FIELD,
  RES_DEV_FIELD,
  SPECTRUM_NAME_FIELD,
  ASSIGNMENT_DISTANCE_FIELD,
  MARDIGRAS_FIELD,
  DIANA_FIELD,
  NOTE_FIELD
};
extern const char *Peak_List_Field_Names[];
#define PEAK_LIST_FIELD_COUNT 20

enum Peak_List_Sort
{
  NO_SORT,
  RESONANCE_NAME_SORT,
  USER_NAME_SORT,
  FREQUENCY_SORT,
  VOLUME_SORT,
  ASSIGNMENT_DISTANCE_SORT
};
extern const char *Peak_List_Sort_Names[];

class CrossPeak;
class List;
class peak_list_dialog;
class Session;

// ----------------------------------------------------------------------------
//
class Peak_List_Options
{
public:
  Peak_List_Options();

  Stringy heading(int max_dimension);
  Stringy text(const CrossPeak *, int max_dimension);
  void sort(List &peaks);

  Stringy title;
  bool fields[PEAK_LIST_FIELD_COUNT];
  Peak_List_Sort sort_type;
  int sort_axis;
  bool sort_pairx;			// Pair cross-diagonal peaks?
  Stringy assignment_format;
  Stringy selected_resonance;

private:

  Stringy field_heading(int field, int max_dimension);
  Stringy field_value(int field, const CrossPeak *xp, int max_dimension);
};

void show_peak_list_options_dialog(Session &s, const Peak_List_Options &plo,
				   peak_list_dialog *pld);
void unshow_peak_list_options_dialog(Session &s, peak_list_dialog *pld);

Peak_List_Options default_peak_list_format();
Peak_List_Options resonance_peaks_format();

#endif
