// ----------------------------------------------------------------------------
// Resonance panel display
//

#ifndef RPANEL_HEADER_INCLUDED
#define RPANEL_HEADER_INCLUDED

#include "color.h"		// Use Color
#include "uiepanel.h"		// use edge_panel
#include "rectangle.h"		// Use Axis
#include "stringc.h"		// Use Stringy
#include "winsystem.h"		// Use CB_Data

class CrossPeak;
class Panel_String;
class SRegion;
class View;

// ----------------------------------------------------------------------------
//
class RPanel : public edge_panel
{
 public:

  RPanel(View *view, double a, double b, int screen_length, bool is_horz);
  ~RPanel();

  void resonance_changed();
  bool filter_resonances() const;
  void set_resonance_filtering(bool onoff);
  List resonance_positions(const SRegion &, double ppm_spacing);

// ----------------------------------------------------------------------------
//
 private:

  View *view;
  Axis axis;
  bool filter;
  double a_cluster, b_cluster;
  List panel_strings;
  Stringy highlight_resonance;
  Color highlight_color;
  bool update_strings;

  // Incremental refresh.

  int next_to_draw;
  double a_clip, b_clip;
  bool update_in_progress;

  static void draw_resonances_cb(CB_Data rpanel);

  virtual void view_region_changed();
  virtual void redraw(double a_clip, double b_clip);
  void draw_resonance(Panel_String *ps);
  void new_highlight(const Stringy &resname, const Color &c);
  void draw_highlight(const Stringy &resname, const Color &c);

  virtual void pointer_in(double x, double y);
  virtual void pointer_move(double x, double y);
  virtual void pointer_out(double x, double y);
};

class Panel_String
{
 public:
  Panel_String(const Stringy &label, double tick_pos, double label_pos);
  Stringy label;
  double tick_position;		// ppm units
  double label_position;	// ppm units
};

void free_panel_string_list_entries(List &pslist);

#endif
