// ----------------------------------------------------------------------------
// Scale display for plots.
//

#ifndef SCALE_HEADER_INCLUDED
#define SCALE_HEADER_INCLUDED

#include "uiepanel.h"
#include "winsystem.h"		// Use Widget

class CrossPeak;
class View;

// ----------------------------------------------------------------------------
//
class Scale : public edge_panel
{
 public:
  Scale(View *view, double a, double b, int screen_length, bool is_horz);

  void update();

  virtual void pointer_in(double x, double y);
  virtual void pointer_move(double x, double y);
  virtual void pointer_out(double x, double y);

// ----------------------------------------------------------------------------
//
 private:
  int axis;
  Widget lbl, value;
  View *view;

  virtual void redraw(double a_clip, double b_clip);
  double scale_value(double d);
  double ppm_value(double scale_value);
  void tick_spacing(double a, double b,
		    double *first, double *last, double *spacing);
  void show_pointer_value(double p, CrossPeak *xp);
};

#endif
