// ----------------------------------------------------------------------------
// 1-D spectrum data slice display
//

#ifndef SLICE_HEADER_INCLUDED
#define SLICE_HEADER_INCLUDED

#include "uiepanel.h"		// Use edge_panel
#include "rectangle.h"		// Use Axis
#include "spoint.h"		// Use SPoint
#include "winsystem.h"		// Use Widget, CB_Data

class Color;
class IRegion;
class View;

// ----------------------------------------------------------------------------
//
class Slice : public edge_panel
{
 public:

  Slice(View *view, double a, double b, int screen_length, bool is_horz);
  virtual ~Slice();

  SPoint section() const;
  void height(double *hmin, double *hmax) const;
  void set_height(double hmin, double hmax);
  void get_slice_data(double p1, double p2, int *d1, int *d2,
		      float **spectrum_data, float **peak_fit,
		      float **selected_peak, float **difference) const;

  bool auto_scale() const;
  void set_auto_scale(bool onoff);

  bool subtract_fit_peaks() const;
  void show_peaks_subtracted(bool onoff);

// ----------------------------------------------------------------------------
//
 private:

  View *view;
  Axis axis;
  SPoint center;
  double min_height, max_height;
  bool auto_adjust, subtract_peaks;
  bool dragging;			// pointer drag in progress
  int last_x, last_y;			// pointer drag previous xy

  static void button_press_cb(Widget, CB_Data, CB_Data);
  static void pointer_drag_cb(Widget, CB_Data, CB_Data);
  static void button_release_cb(Widget, CB_Data, CB_Data);

  virtual void redraw(double a_clip, double b_clip);
  bool auto_scaling_update();
  IRegion slice_region(int d1, int d2) const;
  void draw_curve(const Color &color, int dmin, int dmax, float *data);

  virtual void pointer_in(double x, double y);
  virtual void pointer_move(double x, double y);
  virtual void pointer_out(double x, double y);
  virtual void view_region_changed();
  void update_center();
};

#endif
