# -----------------------------------------------------------------------------
# Command "dc" to set contour levels to default values.
# Put this code in
#
#       ~/Sparky/Python/sparky_init.py
#
# and restart Sparky.
#
def initialize_session(session):

  cb = lambda s=session: set_default_contour_levels(s)
  session.add_command('dc', 'Default contour levels', cb)

# -----------------------------------------------------------------------------
#
def set_default_contour_levels(session):
  
  v = session.selected_view()
  if v == None:
    return

  import sparky
  lev = sparky.Contour_Levels()

  lev.lowest = 5
  lev.factor = 1.5
  lev.levels = 10
  lev.color = 'red-blue'

  v.positive_levels = lev

  lev.lowest = -5		# must be <0 to set negative levels
  lev.factor = 1.5
  lev.levels = 0
  lev.color = 'green'

  v.negative_levels = lev
