# -----------------------------------------------------------------------------
# Put this in ~/Sparky/Python/sparky_init.py.
# This file is read and the initialize_session() function is called
# when Sparky starts.
#
def initialize_session(session):

    def select_labels(s=session):
        select_labels_of_selected_peaks(s)

    session.add_command('lS', 'Select labels of selected peaks (lS)',
                        select_labels)

# -----------------------------------------------------------------------------
# Select the labels of the currently selected peaks.
#
def select_labels_of_selected_peaks(session) :

    peaks = session.selected_peaks()
#
# If you want to unselect everything except the labels you could uncomment
# the following line.
#
#    session.unselect_all_ornaments()
    for p in peaks:
        if p.label != None:
            p.label.selected = 1
