#ifndef CMAP_HEADER_INCLUDED
#define CMAP_HEADER_INCLUDED

#include <stdarg.h>		// use ...

#include "stringc.h"		// Use Stringy

class List;

class Color
{
 public:
  Color();
  Color(const Stringy &colorname);
  Color(const char *colorname);
  Color &operator=(const Color &);
  bool operator==(const Color &) const;
  bool operator!=(const Color &) const;
  const Stringy &name() const;
 private:
  Stringy cname;
};

List color_list(const char *cname, ...);
void free_color_list(List &clist);

#endif
