// ----------------------------------------------------------------------------
// Calculated contours for a given spectrum, region, and set of levels.
//
#ifndef _ContourPlane_h
#define _ContourPlane_h

#include <stdlib.h>		// use size_t

#include "spoint.h"		// Use IRegion
#include "contour.h"		// Use Contour_Levels

class ContourStream;
class Drawing_Routines;
class Spectrum;

class ContourPlane {

public:
	ContourPlane(Spectrum *spectrum, const IRegion &tile,
		     const Contour_Levels &pos, const Contour_Levels &neg,
		     bool subtract_fit_peaks);
	virtual	~ContourPlane();

	void			display(Drawing_Routines &dr);
	Spectrum *		spectrum() const { return mSpectrum; }
	const IRegion &		region() const { return mRegion; }
	const Contour_Levels & 	positive_levels() const { return mPosLevels; }
	const Contour_Levels & 	negative_levels() const { return mNegLevels; }
	size_t			memory_use();

private:
	Spectrum	*mSpectrum;
	IRegion		mRegion;
	Contour_Levels  mPosLevels, mNegLevels;
	bool		mSubtractPeaks;
	ContourStream	*mStream;		// display stream

	void		compute();		// Compute contours
};

bool equal_contour_planes(const void *cp1, const void *cp2);
unsigned long contour_plane_hash(const void *cp);

#endif
