/*
 * grid.h:		Interface to the Grid ornament class.
 *
 * A Grid is an ornament centered at a point (the center is not so important)
 * and extending essentially to infinity parallel to one axis.
 *
 */
#ifndef _Grid_h
#define _Grid_h

#include "spoint.h"		// Use SPoint
#include "ornament.h"

class Axis_Map;

/*
 * The Grid class
 */
class Grid : public Ornament {

public:
			Grid(Spectrum *sp, const SPoint &p, int axis);
			~Grid();

	virtual Ornament *copy(Spectrum *to, const Axis_Map &axismap);

	virtual void		display(ODraw &) const;
	virtual SRegion		erasure_region(ODraw &) const;
	virtual void		print(ODraw &, FILE *fp,
				      double xsc, double ysc,
				      Rectangle r) const;

	virtual Ornament_Type		type() const;
	virtual const char	*type_name() const;

	virtual void		IncrementLocation(const SPoint &);

	int			axis;		// the direction
	SPoint			location;
};
#endif
